/*
 *  ocidl.h     ActiveX control interfaces
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2014 The Open Watcom Contributors. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */

#include <rpc.h>
#include <rpcndr.h>
#ifndef COM_NO_WINDOWS_H
    #include <windows.h>
    #include <ole2.h>
#endif

#ifndef __ocidl_h__
#define __ocidl_h__

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file;
#endif

#include <oleidl.h>
#include <oaidl.h>
#include <servprov.h>
#include <urlmon.h>

#ifdef __cplusplus
extern "C" {
#endif

/* Forward declarations */
typedef interface IConnectionPointContainer IConnectionPointContainer;
typedef interface IPropertyPageSite         IPropertyPageSite;
typedef interface IPropertyBag              IPropertyBag;
typedef interface IOleUndoManager           IOleUndoManager;
typedef interface IAdviseSinkEx             IAdviseSinkEx;
typedef interface IPropertyNotifySink       IPropertyNotifySink;
typedef interface IFont                     IFont;
typedef interface IOleControlSite           IOleControlSite;

/* Primitive data types for controls */
typedef UINT        OLE_HANDLE;
typedef LONG        OLE_XPOS_HIMETRIC;
typedef LONG        OLE_YPOS_HIMETRIC;
typedef LONG        OLE_XSIZE_HIMETRIC;
typedef LONG        OLE_YSIZE_HIMETRIC;
typedef UINT_PTR    HHANDLE;
typedef DWORD       OLE_COLOR;

/* IProvideMultipleClassInfo::GetInfoOfIndex() flags */
#define MULTICLASSINFO_GETTYPEINFO              0x00000001L
#define MULTICLASSINFO_GETNUMRESERVEDDISPIDS    0x00000002L
#define MULTICLASSINFO_GETIIDPRIMARY            0x00000004L
#define MULTICLASSINFO_GETIIDSOURCE             0x00000008L

/* Type information flags */
#define TIFLAGS_EXTENDDISPATCHONLY  0x00000001L

/* Undo state flags */
typedef enum tagUASFLAGS {
    UAS_NORMAL          = 0x00000000,
    UAS_BLOCKED         = 0x00000001,
    UAS_NOPARENTENABLE  = 0x00000002,
    UAS_MASK            = 0x00000003
} UASFLAGS;

/* Ready states */
typedef enum tagREADYSTATE {
    READYSTATE_UNINITIALIZED    = 0,
    READYSTATE_LOADING          = 1,
    READYSTATE_LOADED           = 2,
    READYSTATE_INTERACTIVE      = 3,
    READYSTATE_COMPLETE         = 4
} READYSTATE;

/* Connection data */
typedef struct tagCONNECTDATA {
    IUnknown    *pUnk;
    DWORD       dwCookie;
} CONNECTDATA;
typedef CONNECTDATA *PCONNECTDATA;
typedef CONNECTDATA *LPCONNECTDATA;

/* License information */
typedef struct tagLICINFO {
    LONG    cbLicInfo;
    BOOL    fRuntimeKeyAvail;
    BOOL    fLicVerified;
} LICINFO;
typedef LICINFO *LPLICINFO;

/* GUID kinds */
typedef enum tagGUIDKIND {
    GUIDKIND_DEFAULT_SOURCE_DISP_IID    = 1
} GUIDKIND;

/* Control information */
typedef struct tagCONTROLINFO {
    ULONG   cb;
    HACCEL  hAccel;
    USHORT  cAccel;
    DWORD   dwFlags;
} CONTROLINFO;
typedef CONTROLINFO *LPCONTROLINFO;

/* Control information flags */
typedef enum tagCTRLINFO {
    CTRLINFO_EATS_RETURN    = 1,
    CTRLINFO_EATS_ESCAPE    = 2
} CTRLINFO;

/* Point (floating-point version) */
typedef struct tagPOINTF {
    FLOAT   x;
    FLOAT   y;
} POINTF;
typedef POINTF  *LPPOINTF;

/* Coordinate transformation flags */
typedef enum tagXFORMCOORDS {
    XFORMCOORDS_POSITION            = 0x00000001,
    XFORMCOORDS_SIZE                = 0x00000002,
    XFORMCOORDS_HIMETRICTOCONTAINER = 0x00000004,
    XFORMCOORDS_CONTAINERTOHIMETRIC = 0x00000008,
    XFORMCOORDS_EVENTCOMPAT         = 0x00000010
} XFORMCOORDS;

/* Property page information */
typedef struct tagPROPPAGEINFO {
    ULONG       cb;
    LPOLESTR    pszTitle;
    SIZE        size;
    LPOLESTR    pszDocString;
    LPOLESTR    pszHelpFile;
    DWORD       dwHelpContext;
} PROPPAGEINFO;
typedef PROPPAGEINFO    *LPPROPPAGEINFO;

/* Property page status value */
typedef enum tagPROPPAGESTATUS {
    PROPPAGESTATUS_DIRTY    = 0x00000001,
    PROPPAGESTATUS_VALIDATE = 0x00000002,
    PROPPAGESTATUS_CLEAN    = 0x00000004
} PROPPAGESTATUS;

/* GUID counted array */
typedef struct tagCAUUID {
    ULONG   cElems;
    GUID    *pElems;
} CAUUID;
typedef CAUUID  *LPCAUUID;

/* Text metric (OLE version) */
typedef TEXTMETRICW     TEXTMETRICOLE;
typedef TEXTMETRICOLE   *LPTEXTMETRICOLE;

/* Picture attributes */
typedef enum tagPictureAttributes {
    PICTURE_SCALABLE    = 0x00000001,
    PICTURE_TRANSPARENT = 0x00000002
} PICTUREATTRIBUTES;

/* Activate flags */
typedef enum tagACTIVATEFLAGS {
    ACTIVATE_WINDOWLESS = 1
} ACTIVATEFLAGS;

/* OLE device context flags */
typedef enum tagOLEDCFLAGS {
    OLEDC_NODRAW        = 0x00000001,
    OLEDC_PAINTBKGND    = 0x00000002,
    OLEDC_OFFSCREEN     = 0x00000004
} OLEDCFLAGS;

/* View status flags */
typedef enum tagVIEWSTATUS {
    VIEWSTATUS_OPAQUE               = 1,
    VIEWSTATUS_SOLIDBKGND           = 2,
    VIEWSTATUS_DVASPECTOPAQUE       = 4,
    VIEWSTATUS_DVASPECTTRANSPARENT  = 8,
    VIEWSTATUS_SURFACE              = 16,
    VIEWSTATUS_3DSURFACE            = 32
} VIEWSTATUS;

/* Hit results */
typedef enum tagHITRESULT {
    HITRESULT_OUTSIDE       = 0,
    HITRESULT_TRANSPARENT   = 1,
    HITRESULT_CLOSE         = 2,
    HITRESULT_HIT           = 3
} HITRESULT;

/* Additional data/view aspects */
typedef enum tagDVASPECT2 {
    DVASPECT_OPAQUE         = 16,
    DVASPECT_TRANSPARENT    = 32
} DVASPECT2;

/* Date/view extent information */
typedef struct tagExtentInfo {
    ULONG   cb;
    DWORD   dwExtentMode;
    SIZEL   sizelProposed;
} DVEXTENTINFO;

/* Data/view extent modes */
typedef enum tagExtentMode {
    DVEXTENT_CONTENT    = 0,
    DVEXTENT_INTEGRAL   = 1
} DVEXTENTMODE;

/* Data/view aspect information flags */
typedef enum tagAspectInfoFlag {
    DVASPECTINFOFLAG_CANOPTIMIZE    = 1
} DVASPECTINFOFLAG;

/* Data/view aspect information */
typedef struct tagAspectInfo {
    ULONG   cb;
    DWORD   dwFlags;
} DVASPECTINFO;

/* Pointer inactive flags */
typedef enum tagPOINTERINACTIVE {
    POINTERINACTIVE_ACTIVATEONENTRY     = 1,
    POINTERINACTIVE_DEACTIVATEONLEAVE   = 2,
    POINTERINACTIVE_ACTIVATEONDRAG      = 4
} POINTERINACTIVE;

/* OLE string counted array */
typedef struct tagCALPOLESTR {
    ULONG       cElems;
    LPOLESTR    *pElems;
} CALPOLESTR;
typedef CALPOLESTR  *LPCALPOLESTR;

/* Double word counted array */
typedef struct tagCADWORD {
    ULONG   cElems;
    DWORD   *pElems;
} CADWORD;
typedef CADWORD *LPCADWORD;

/* IPropertyBag2 types */
typedef enum tagPROPBAG2_TYPE {
    PROPBAG2_TYPE_UNDEFINED = 0,
    PROPBAG2_TYPE_DATA      = 1,
    PROPBAG2_TYPE_URL       = 2,
    PROPBAG2_TYPE_OBJECT    = 3,
    PROPBAG2_TYPE_STREAM    = 4,
    PROPBAG2_TYPE_STORAGE   = 5,
    PROPBAG2_TYPE_MONIKER   = 6
} PROPBAG2_TYPE;

/* IPropertyBag2 information */
typedef struct tagPROPBAG2 {
    DWORD       dwType;
    VARTYPE     vt;
    CLIPFORMAT  cfType;
    DWORD       dwHint;
    LPOLESTR    pstrName;
    CLSID       clsid;
} PROPBAG2;

/* IQuickActivate container flags */
typedef enum tagQACONTAINERFLAGS {
    QACONTAINER_SHOWHATCHING        = 0x00000001,
    QACONTAINER_SHOWGRABHANDLES     = 0x00000002,
    QACONTAINER_USERMODE            = 0x00000004,
    QACONTAINER_DISPLAYASDEFAULT    = 0x00000008,
    QACONTAINER_UIDEAD              = 0x00000010,
    QACONTAINER_AUTOCLIP            = 0x00000020,
    QACONTAINER_MESSAGEREFLECT      = 0x00000040,
    QACONTAINER_SUPPORTSMNEMONICS   = 0x00000080
} QACONTAINERFLAGS;

/* IQuickActivate container */
typedef struct tagQACONTAINER {
    ULONG               cbSize;
    IOleClientSite      *pClientSite;
    IAdviseSinkEx       *pAdviseSink;
    IPropertyNotifySink *pPropertyNotifySink;
    IUnknown            *pUnkEventSink;
    DWORD               dwAmbientFlags;
    OLE_COLOR           colorFore;
    OLE_COLOR           colorBack;
    IFont               *pFont;
    IOleUndoManager     *pUndoMgr;
    DWORD               dwAppearance;
    LONG                lcid;
    HPALETTE            hpal;
    IBindHost           *pBindHost;
    IOleControlSite     *pOleControlSite;
    IServiceProvider    *pServiceProvider;
} QACONTAINER;

/* IQuickActivate control */
typedef struct tagQACONTROL {
    ULONG   cbSize;
    DWORD   dwMiscStatus;
    DWORD   dwViewStatus;
    DWORD   dwEventCookie;
    DWORD   dwPropNotifyCookie;
    DWORD   dwPointerActivationPolicy;
} QACONTROL;

/* IEnumConnections interface */
#undef INTERFACE
#define INTERFACE   IEnumConnections
DECLARE_INTERFACE_( IEnumConnections, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IEnumConnections methods */
    STDMETHOD( Next )( THIS_ ULONG, LPCONNECTDATA, ULONG * ) PURE;
    STDMETHOD( Skip )( THIS_ ULONG ) PURE;
    STDMETHOD( Reset )( THIS ) PURE;
    STDMETHOD( Clone )( THIS_ IEnumConnections ** ) PURE;
};
typedef IEnumConnections    *PENUMCONNECTIONS;
typedef IEnumConnections    *LPENUMCONNECTIONS;

/* IConnectionPoint interface */
#undef INTERFACE
#define INTERFACE   IConnectionPoint
DECLARE_INTERFACE_( IConnectionPoint, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IConnectionPoint methods */
    STDMETHOD( GetConnectionInterface )( THIS_ IID * ) PURE;
    STDMETHOD( GetConnectionPointContainer )( THIS_ IConnectionPointContainer ** ) PURE;
    STDMETHOD( Advise )( THIS_ IUnknown *, DWORD * ) PURE;
    STDMETHOD( Unadvise )( THIS_ DWORD ) PURE;
    STDMETHOD( EnumConnections )( THIS_ IEnumConnections ** ) PURE;
};
typedef IConnectionPoint    *PCONNECTIONPOINT;
typedef IConnectionPoint    *LPCONNECTIONPOINT;

/* IEnumConnectionPoints interface */
#undef INTERFACE
#define INTERFACE   IEnumConnectionPoints
DECLARE_INTERFACE_( IEnumConnectionPoints, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IEnumConnectionPoints methods */
    STDMETHOD( Next )( THIS_ ULONG, LPCONNECTIONPOINT *, ULONG * ) PURE;
    STDMETHOD( Skip )( THIS_ ULONG ) PURE;
    STDMETHOD( Reset )( THIS ) PURE;
    STDMETHOD( Clone )( THIS_ IEnumConnectionPoints ** ) PURE;
};
typedef IEnumConnectionPoints   *PENUMCONNECTIONPOINTS;
typedef IEnumConnectionPoints   *LPENUMCONNECTIONPOINTS;

/* IConnectionPointContainer interface */
#undef INTERFACE
#define INTERFACE   IConnectionPointContainer
DECLARE_INTERFACE_( IConnectionPointContainer, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IConnectionPointContainer methods */
    STDMETHOD( EnumConnectionPoints )( THIS_ IEnumConnectionPoints ** ) PURE;
    STDMETHOD( FindConnectionPoint )( THIS_ REFIID, IConnectionPoint ** ) PURE;
};
typedef IConnectionPointContainer   *PCONNECTIONPOINTCONTAINER;
typedef IConnectionPointContainer   *LPCONNECTIONPOINTCONTAINER;

/* IClassFactory2 interface */
#undef INTERFACE
#define INTERFACE   IClassFactory2
DECLARE_INTERFACE_( IClassFactory2, IClassFactory ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IClassFactory methods */
    STDMETHOD( CreateInstance )( THIS_ IUnknown *, REFIID, void ** ) PURE;
    STDMETHOD( LockServer )( THIS_ BOOL ) PURE;

    /* IClassFactory2 methods */
    STDMETHOD( GetLicInfo )( THIS_ LICINFO * ) PURE;
    STDMETHOD( RequestLicKey )( THIS_ DWORD, BSTR * ) PURE;
    STDMETHOD( CreateInstanceLic )( THIS_ IUnknown *, IUnknown *, REFIID, BSTR, PVOID * ) PURE;
};
typedef IClassFactory2  *LPCLASSFACTORY2;

/* IProvideClassInfo interface */
#undef INTERFACE
#define INTERFACE   IProvideClassInfo
DECLARE_INTERFACE_( IProvideClassInfo, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IProvideClassInfo methods */
    STDMETHOD( GetClassInfo )( THIS_ ITypeInfo ** ) PURE;
};
typedef IProvideClassInfo   *LPPROVIDECLASSINFO;

/* IProvideClassInfo2 interface */
#undef INTERFACE
#define INTERFACE   IProvideClassInfo2
DECLARE_INTERFACE_( IProvideClassInfo2, IProvideClassInfo ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IProvideClassInfo methods */
    STDMETHOD( GetClassInfo )( THIS_ ITypeInfo ** ) PURE;
    
    /* IProvideClassInfo2 methods */
    STDMETHOD( GetGUID )( THIS_ DWORD, GUID * ) PURE;
};
typedef IProvideClassInfo2  *LPPROVIDECLASSINFO2;

/* IProvideMultipleClassInfo interface */
#undef INTERFACE
#define INTERFACE   IProvideMultipleClassInfo
DECLARE_INTERFACE_( IProvideMultipleClassInfo, IProvideClassInfo2 ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IProvideClassInfo methods */
    STDMETHOD( GetClassInfo )( THIS_ ITypeInfo ** ) PURE;
    
    /* IProvideClassInfo2 methods */
    STDMETHOD( GetGUID )( THIS_ DWORD, GUID * ) PURE;

    /* IProvideMultipleClassInfo methods */
    STDMETHOD( GetMultiTypeInfoCount )( THIS_ ULONG * ) PURE;
    STDMETHOD( GetInfoOfIndex )( THIS_ ULONG, DWORD, ITypeInfo **, DWORD *, ULONG *, IID *, IID * ) PURE;
};
typedef IProvideMultipleClassInfo   *LPPROVIDEMULTIPLECLASSINFO;

/* IOleControl interface */
#undef INTERFACE
#define INTERFACE   IOleControl
DECLARE_INTERFACE_( IOleControl, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IOleControl methods */
    STDMETHOD( GetControlInfo )( THIS_ CONTROLINFO * ) PURE;
    STDMETHOD( OnMnemonic )( THIS_ MSG * ) PURE;
    STDMETHOD( OnAmbientPropertyChange )( THIS_ DISPID ) PURE;
    STDMETHOD( FreezeEvents )( THIS_ BOOL ) PURE;
};
typedef IOleControl *LPOLECONTROL;

/* IOleControlSite interface */
#undef INTERFACE
#define INTERFACE   IOleControlSite
DECLARE_INTERFACE_( IOleControlSite, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IOleControlSite methods */
    STDMETHOD( OnControlInfoChanged )( THIS ) PURE;
    STDMETHOD( LockInPlaceActive )( THIS_ BOOL ) PURE;
    STDMETHOD( GetExtendedControl )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( TransformCoords )( THIS_ POINTL *, POINTF *, DWORD ) PURE;
    STDMETHOD( TranslateAccelerator )( THIS_ MSG *, DWORD ) PURE;
    STDMETHOD( OnFocus )( THIS_ BOOL ) PURE;
    STDMETHOD( ShowPropertyFrame )( THIS ) PURE;
};
typedef IOleControlSite *LPOLECONTROLSITE;

/* IPropertyPage interface */
#undef INTERFACE
#define INTERFACE   IPropertyPage
DECLARE_INTERFACE_( IPropertyPage, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IPropertyPage methods */
    STDMETHOD( SetPageSite )( THIS_ IPropertyPageSite * ) PURE;
    STDMETHOD( Activate )( THIS_ HWND, LPCRECT, BOOL ) PURE;
    STDMETHOD( Deactivate )( THIS ) PURE;
    STDMETHOD( GetPageInfo )( THIS_ PROPPAGEINFO * ) PURE;
    STDMETHOD( SetObjects )( THIS_ ULONG, IUnknown ** ) PURE;
    STDMETHOD( Show )( THIS_ UINT ) PURE;
    STDMETHOD( Move )( THIS_ LPCRECT ) PURE;
    STDMETHOD( IsPageDirty )( THIS ) PURE;
    STDMETHOD( Apply )( THIS ) PURE;
    STDMETHOD( Help )( THIS_ LPCOLESTR ) PURE;
    STDMETHOD( TranslateAccelerator )( THIS_ MSG * ) PURE;
};
typedef IPropertyPage   *LPPROPERTYPAGE;

/* IPropertyPage2 interface */
#undef INTERFACE
#define INTERFACE   IPropertyPage2
DECLARE_INTERFACE_( IPropertyPage2, IPropertyPage ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IPropertyPage methods */
    STDMETHOD( SetPageSite )( THIS_ IPropertyPageSite * ) PURE;
    STDMETHOD( Activate )( THIS_ HWND, LPCRECT, BOOL ) PURE;
    STDMETHOD( Deactivate )( THIS ) PURE;
    STDMETHOD( GetPageInfo )( THIS_ PROPPAGEINFO * ) PURE;
    STDMETHOD( SetObjects )( THIS_ ULONG, IUnknown ** ) PURE;
    STDMETHOD( Show )( THIS_ UINT ) PURE;
    STDMETHOD( Move )( THIS_ LPCRECT ) PURE;
    STDMETHOD( IsPageDirty )( THIS ) PURE;
    STDMETHOD( Apply )( THIS ) PURE;
    STDMETHOD( Help )( THIS_ LPCOLESTR ) PURE;
    STDMETHOD( TranslateAccelerator )( THIS_ MSG * ) PURE;

    /* IPropertyPage2 methods */
    STDMETHOD( EditProperty )( THIS_ DISPID ) PURE;
};
typedef IPropertyPage2  *LPPROPERTYPAGE2;

/* IPropertyPageSite interface */
#undef INTERFACE
#define INTERFACE   IPropertyPageSite
DECLARE_INTERFACE_( IPropertyPageSite, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IPropertyPageSite methods */
    STDMETHOD( OnStatusChange )( THIS_ DWORD ) PURE;
    STDMETHOD( GetLocaleID )( THIS_ LCID * ) PURE;
    STDMETHOD( GetPageContainer )( THIS_ IUnknown ** ) PURE;
    STDMETHOD( TranslateAccelerator )( THIS_ MSG * ) PURE;
};
typedef IPropertyPageSite   *LPPROPERTYPAGESITE;

/* IPropertyNotifySink interface */
#undef INTERFACE
#define INTERFACE   IPropertyNotifySink
DECLARE_INTERFACE_( IPropertyNotifySink, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IPropertyNotifySink methods */
    STDMETHOD( OnChanged )( THIS_ DISPID ) PURE;
    STDMETHOD( OnRequestEdit )( THIS_ DISPID ) PURE;
};
typedef IPropertyNotifySink *LPPROPERTYNOTIFYSINK;

/* ISpecifyPropertyPages interface */
#undef INTERFACE
#define INTERFACE   ISpecifyPropertyPages
DECLARE_INTERFACE_( ISpecifyPropertyPages, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* ISpecifyPropertyPages methods */
    STDMETHOD( GetPages )( THIS_ CAUUID * ) PURE;
};
typedef ISpecifyPropertyPages   *LPSPECIFYPROPERTYPAGES;

/* IPersistMemory interface */
#undef INTERFACE
#define INTERFACE   IPersistMemory
DECLARE_INTERFACE_( IPersistMemory, IPersist ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IPersist methods */
    STDMETHOD( GetClassID )( THIS_ CLSID * ) PURE;

    /* IPersistMemory methods */
    STDMETHOD( IsDirty )( THIS ) PURE;
    STDMETHOD( Load )( THIS_ LPVOID, ULONG ) PURE;
    STDMETHOD( Save )( THIS_ LPVOID, BOOL, ULONG ) PURE;
    STDMETHOD( GetSizeMax )( THIS_ ULONG * ) PURE;
    STDMETHOD( InitNew )( THIS ) PURE;
};
typedef IPersistMemory  *LPPERSISTMEMORY;

/* IPersistStreamInit interface */
#undef INTERFACE
#define INTERFACE   IPersistStreamInit
DECLARE_INTERFACE_( IPersistStreamInit, IPersist ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IPersist methods */
    STDMETHOD( GetClassID )( THIS_ CLSID * ) PURE;

    /* IPersistStreamInit methods */
    STDMETHOD( IsDirty )( THIS ) PURE;
    STDMETHOD( Load )( THIS_ LPSTREAM ) PURE;
    STDMETHOD( Save )( THIS_ LPSTREAM, BOOL ) PURE;
    STDMETHOD( GetSizeMax )( THIS_ ULARGE_INTEGER * ) PURE;
    STDMETHOD( InitNew )( THIS ) PURE;
};
typedef IPersistStreamInit  *LPPERSISTSTREAMINIT;

/* IPersistPropertyBag interface */
#undef INTERFACE
#define INTERFACE   IPersistPropertyBag
DECLARE_INTERFACE_( IPersistPropertyBag, IPersist ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IPersist methods */
    STDMETHOD( GetClassID )( THIS_ CLSID * ) PURE;

    /* IPersistPropertyBag methods */
    STDMETHOD( InitNew )( THIS ) PURE;
    STDMETHOD( Load )( THIS_ IPropertyBag *, IErrorLog * ) PURE;
    STDMETHOD( Save )( THIS_ IPropertyBag *, BOOL, BOOL ) PURE;
};
typedef IPersistPropertyBag *LPPERSISTPROPERTYBAG;

/* ISimpleFrameSite interface */
#undef INTERFACE
#define INTERFACE   ISimpleFrameSite
DECLARE_INTERFACE_( ISimpleFrameSite, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* ISimpleFrameSite methods */
    STDMETHOD( PreMessageFilter )( THIS_ HWND, UINT, WPARAM, LPARAM, LRESULT *, DWORD * ) PURE;
    STDMETHOD( PostMessageFilter )( THIS_ HWND, UINT, WPARAM, LPARAM, LRESULT *, DWORD ) PURE;
};
typedef ISimpleFrameSite    *LPSIMPLEFRAMESITE;

/* IFont interface */
#undef INTERFACE
#define INTERFACE   IFont
DECLARE_INTERFACE_( IFont, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IFont methods */
    STDMETHOD( get_Name )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_Name )( THIS_ BSTR ) PURE;
    STDMETHOD( get_Size )( THIS_ CY * ) PURE;
    STDMETHOD( put_Size )( THIS_ CY ) PURE;
    STDMETHOD( get_Bold )( THIS_ BOOL * ) PURE;
    STDMETHOD( put_Bold )( THIS_ BOOL ) PURE;
    STDMETHOD( get_Italic )( THIS_ BOOL * ) PURE;
    STDMETHOD( put_Italic )( THIS_ BOOL ) PURE;
    STDMETHOD( get_Underline )( THIS_ BOOL * ) PURE;
    STDMETHOD( put_Underline )( THIS_ BOOL ) PURE;
    STDMETHOD( get_Strikethrough )( THIS_ BOOL * ) PURE;
    STDMETHOD( put_Strikethrough )( THIS_ BOOL ) PURE;
    STDMETHOD( get_Weight )( THIS_ SHORT * ) PURE;
    STDMETHOD( put_Weight )( THIS_ SHORT ) PURE;
    STDMETHOD( get_Charset )( THIS_ SHORT * ) PURE;
    STDMETHOD( put_Charset )( THIS_ SHORT ) PURE;
    STDMETHOD( get_hFont )( THIS_ HFONT * ) PURE;
    STDMETHOD( Clone )( THIS_ IFont ** ) PURE;
    STDMETHOD( IsEqual )( THIS_ IFont * ) PURE;
    STDMETHOD( SetRatio )( THIS_ LONG, LONG ) PURE;
    STDMETHOD( QueryTextMetrics )( THIS_ TEXTMETRICOLE * ) PURE;
    STDMETHOD( AddRefHfont )( THIS_ HFONT ) PURE;
    STDMETHOD( ReleaseHfont )( THIS_ HFONT ) PURE;
    STDMETHOD( SetHdc )( THIS_ HDC ) PURE;
};
typedef IFont   *LPFONT;

/* IPicture interface */
#undef INTERFACE
#define INTERFACE   IPicture
DECLARE_INTERFACE_( IPicture, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IPicture methods */
    STDMETHOD( get_Handle )( THIS_ OLE_HANDLE * ) PURE;
    STDMETHOD( get_hPal )( THIS_ OLE_HANDLE * ) PURE;
    STDMETHOD( get_Type )( THIS_ SHORT * ) PURE;
    STDMETHOD( get_Width )( THIS_ OLE_XSIZE_HIMETRIC * ) PURE;
    STDMETHOD( get_Height )( THIS_ OLE_YSIZE_HIMETRIC * ) PURE;
    STDMETHOD( Render )( THIS_ HDC, LONG, LONG, LONG, LONG, OLE_XPOS_HIMETRIC, OLE_YPOS_HIMETRIC, OLE_XSIZE_HIMETRIC, OLE_YSIZE_HIMETRIC, LPCRECT );
    STDMETHOD( set_hPal )( THIS_ OLE_HANDLE ) PURE;
    STDMETHOD( get_CurDC )( THIS_ HDC * ) PURE;
    STDMETHOD( SelectPicture )( THIS_ HDC, HDC *, OLE_HANDLE * ) PURE;
    STDMETHOD( get_KeepOriginalFormat )( THIS_ BOOL * ) PURE;
    STDMETHOD( put_KeepOriginalFormat )( THIS_ BOOL ) PURE;
    STDMETHOD( PictureChanged )( THIS ) PURE;
    STDMETHOD( SaveAsFile )( THIS_ LPSTREAM, BOOL, LONG * ) PURE;
    STDMETHOD( get_Attributes )( THIS_ DWORD * ) PURE;
};
typedef IPicture    *LPPICTURE;

/* IPicture2 interface */
#undef INTERFACE
#define INTERFACE   IPicture2
DECLARE_INTERFACE_( IPicture2, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IPicture2 methods */
    STDMETHOD( get_Handle )( THIS_ HHANDLE * ) PURE;
    STDMETHOD( get_hPal )( THIS_ HHANDLE * ) PURE;
    STDMETHOD( get_Type )( THIS_ SHORT * ) PURE;
    STDMETHOD( get_Width )( THIS_ OLE_XSIZE_HIMETRIC * ) PURE;
    STDMETHOD( get_Height )( THIS_ OLE_YSIZE_HIMETRIC * ) PURE;
    STDMETHOD( Render )( THIS_ HDC, LONG, LONG, LONG, LONG, OLE_XPOS_HIMETRIC, OLE_YPOS_HIMETRIC, OLE_XSIZE_HIMETRIC, OLE_YSIZE_HIMETRIC, LPCRECT ) PURE;
    STDMETHOD( set_hPal )( THIS_ HHANDLE ) PURE;
    STDMETHOD( get_CurDC )( THIS_ HDC * ) PURE;
    STDMETHOD( SelectPicture )( THIS_ HDC, HDC *, HHANDLE * ) PURE;
    STDMETHOD( get_KeepOriginalFormat )( THIS_ BOOL * ) PURE;
    STDMETHOD( put_KeepOriginalFormat )( THIS_ BOOL ) PURE;
    STDMETHOD( PictureChanged )( THIS ) PURE;
    STDMETHOD( SaveAsFile )( THIS_ LPSTREAM, BOOL, LONG * ) PURE;
    STDMETHOD( get_Attributes )( THIS_ DWORD * ) PURE;
};
typedef IPicture2   *LPPICTURE2;

/* IFontEventsDisp interface */
#undef INTERFACE
#define INTERFACE   IFontEventsDisp
DECLARE_INTERFACE_( IFontEventsDisp, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};
typedef IFontEventsDisp *LPFONTEVENTS;

/* IFontDisp interface */
#undef INTERFACE
#define INTERFACE   IFontDisp
DECLARE_INTERFACE_( IFontDisp, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};
typedef IFontDisp   *LPFONTDISP;

/* IPictureDisp interface */
#undef INTERFACE
#define INTERFACE   IPictureDisp
DECLARE_INTERFACE_( IPictureDisp, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};
typedef IPictureDisp    *LPPICTUREDISP;

/* IOleInPlaceObjectWindowless interface */
#undef INTERFACE
#define INTERFACE   IOleInPlaceObjectWindowless
DECLARE_INTERFACE_( IOleInPlaceObjectWindowless, IOleInPlaceObject ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IOleWindow methods */
    STDMETHOD( GetWindow )( THIS_ HWND * ) PURE;
    STDMETHOD( ContextSensitiveHelp )( THIS_ BOOL ) PURE;
    STDMETHOD( InPlaceDeactivate )( THIS ) PURE;
    
    /* IOleInPlaceObject methods */
    STDMETHOD( UIDeactivate )( THIS ) PURE;
    STDMETHOD( SetObjectRects )( THIS_ LPCRECT, LPCRECT ) PURE;
    STDMETHOD( ReactivateAndUndo )( THIS ) PURE;
    
    /* IOleInPlaceObjectWindowless methods */
    STDMETHOD( OnWindowMessage )( THIS_ UINT, WPARAM, LPARAM, LRESULT * ) PURE;
    STDMETHOD( GetDropTarget )( THIS_ IDropTarget ** ) PURE;
};
typedef IOleInPlaceObjectWindowless *LPOLEINPLACEOBJECTWINDOWLESS;

/* IOleInPlaceSiteEx interface */
#undef INTERFACE
#define INTERFACE   IOleInPlaceSiteEx
DECLARE_INTERFACE_( IOleInPlaceSiteEx, IOleInPlaceSite ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IOleWindow methods */
    STDMETHOD( GetWindow )( THIS_ HWND * ) PURE;
    STDMETHOD( ContextSensitiveHelp )( THIS_ BOOL ) PURE;
    
    /* IOleInPlaceSite methods */
    STDMETHOD( CanInPlaceActivate )( THIS ) PURE;
    STDMETHOD( OnInPlaceActivate )( THIS ) PURE;
    STDMETHOD( OnUIActivate )( THIS ) PURE;
    STDMETHOD( GetWindowContext )( THIS_ IOleInPlaceFrame **, IOleInPlaceUIWindow **, LPRECT, LPRECT, LPOLEINPLACEFRAMEINFO ) PURE;
    STDMETHOD( Scroll )( THIS_ SIZE ) PURE;
    STDMETHOD( OnUIDeactivate )( THIS_ BOOL ) PURE;
    STDMETHOD( OnInPlaceDeactivate )( THIS ) PURE;
    STDMETHOD( DiscardUndoState )( THIS ) PURE;
    STDMETHOD( DeactivateAndUndo )( THIS ) PURE;
    STDMETHOD( OnPosRectChange )( THIS_ LPCRECT ) PURE;
    
    /* IOleInPlaceSiteEx methods */
    STDMETHOD( OnInPlaceActivateEx )( THIS_ BOOL *, DWORD ) PURE;
    STDMETHOD( OnInPlaceDeactivateEx )( THIS_ BOOL ) PURE;
    STDMETHOD( RequestUIActivate )( THIS ) PURE;
};
typedef IOleInPlaceSiteEx   *LPOLEINPLACESITEEX;

/* IOleInPlaceSiteWindowless interface */
#undef INTERFACE
#define INTERFACE   IOleInPlaceSiteWindowless
DECLARE_INTERFACE_( IOleInPlaceSiteWindowless, IOleInPlaceSiteEx ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IOleWindow methods */
    STDMETHOD( GetWindow )( THIS_ HWND * ) PURE;
    STDMETHOD( ContextSensitiveHelp )( THIS_ BOOL ) PURE;
    
    /* IOleInPlaceSite methods */
    STDMETHOD( CanInPlaceActivate )( THIS ) PURE;
    STDMETHOD( OnInPlaceActivate )( THIS ) PURE;
    STDMETHOD( OnUIActivate )( THIS ) PURE;
    STDMETHOD( GetWindowContext )( THIS_ IOleInPlaceFrame **, IOleInPlaceUIWindow **, LPRECT, LPRECT, LPOLEINPLACEFRAMEINFO ) PURE;
    STDMETHOD( Scroll )( THIS_ SIZE ) PURE;
    STDMETHOD( OnUIDeactivate )( THIS_ BOOL ) PURE;
    STDMETHOD( OnInPlaceDeactivate )( THIS ) PURE;
    STDMETHOD( DiscardUndoState )( THIS ) PURE;
    STDMETHOD( DeactivateAndUndo )( THIS ) PURE;
    STDMETHOD( OnPosRectChange )( THIS_ LPCRECT ) PURE;
    
    /* IOleInPlaceSiteEx methods */
    STDMETHOD( OnInPlaceActivateEx )( THIS_ BOOL *, DWORD ) PURE;
    STDMETHOD( OnInPlaceDeactivateEx )( THIS_ BOOL ) PURE;
    STDMETHOD( RequestUIActivate )( THIS ) PURE;
    
    /* IOleInPlaceSiteWindowless methods */
    STDMETHOD( CanWindowlessActivate )( THIS ) PURE;
    STDMETHOD( GetCapture )( THIS ) PURE;
    STDMETHOD( SetCapture )( THIS_ BOOL ) PURE;
    STDMETHOD( GetFocus )( THIS ) PURE;
    STDMETHOD( SetFocus )( THIS_ BOOL ) PURE;
    STDMETHOD( GetDC )( THIS_ LPCRECT, DWORD, HDC * ) PURE;
    STDMETHOD( ReleaseDC )( THIS_ HDC ) PURE;
    STDMETHOD( InvalidateRect )( THIS_ LPCRECT, BOOL ) PURE;
    STDMETHOD( InvalidateRgn )( THIS_ HRGN, BOOL ) PURE;
    STDMETHOD( ScrollRect )( THIS_ INT, INT, LPCRECT, LPCRECT ) PURE;
    STDMETHOD( AdjustRect )( THIS_ LPRECT ) PURE;
    STDMETHOD( OnDefWindowMessage )( UINT, WPARAM, LPARAM, LRESULT * ) PURE;
};
typedef IOleInPlaceSiteWindowless   *LPOLEINPLACESITEWINDOWLESS;

/* IViewObjectEx interface */
#undef INTERFACE
#define INTERFACE   IViewObjectEx
DECLARE_INTERFACE_( IViewObjectEx, IViewObject2 ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IViewObject methods */
    STDMETHOD( Draw )( THIS_ DWORD, LONG, void *, DVTARGETDEVICE *, HDC, HDC, LPCRECTL, LPCRECTL, BOOL (CALLBACK *)( ULONG_PTR ), ULONG_PTR ) PURE;
    STDMETHOD( GetColorSet )( THIS_ DWORD, LONG, void *, DVTARGETDEVICE *, HDC, LOGPALETTE ** ) PURE;
    STDMETHOD( Freeze )( THIS_ DWORD, LONG, void *, DWORD * ) PURE;
    STDMETHOD( Unfreeze )( THIS_ DWORD ) PURE;
    STDMETHOD( SetAdvise )( THIS_ DWORD, DWORD, IAdviseSink * ) PURE;
    STDMETHOD( GetAdvise )( THIS_ DWORD *, DWORD *, IAdviseSink ** ) PURE;
    
    /* IViewObject2 methods */
    STDMETHOD( GetExtent )( THIS_ DWORD, LONG, DVTARGETDEVICE *, LPSIZEL ) PURE;

    /* IViewObjectEx methods */
    STDMETHOD( GetRect )( THIS_ DWORD, LPRECTL ) PURE;
    STDMETHOD( GetViewStatus )( THIS_ DWORD * ) PURE;
    STDMETHOD( QueryHitPoint )( THIS_ DWORD, LPCRECT, POINT, LONG, DWORD * ) PURE;
    STDMETHOD( QueryHitRect )( THIS_ DWORD, LPCRECT, LPCRECT, LONG, DWORD * ) PURE;
    STDMETHOD( GetNaturalExtent )( THIS_ DWORD, LONG, DVTARGETDEVICE *, HDC, DVEXTENTINFO *, LPSIZEL ) PURE;
};
typedef IViewObjectEx   *LPVIEWOBJECTEX;

/* IOleUndoUnit interface */
#undef INTERFACE
#define INTERFACE   IOleUndoUnit
DECLARE_INTERFACE_( IOleUndoUnit, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IOleUndoUnit methods */
    STDMETHOD( Do )( THIS_ IOleUndoManager * ) PURE;
    STDMETHOD( GetDescription )( THIS_ BSTR * ) PURE;
    STDMETHOD( GetUnitType )( THIS_ CLSID *, LONG * ) PURE;
    STDMETHOD( OnNextAdd )( THIS ) PURE;
};
typedef IOleUndoUnit    *LPOLEUNDOUNIT;

/* IOleParentUndoUnit interface */
#undef INTERFACE
#define INTERFACE   IOleParentUndoUnit
DECLARE_INTERFACE_( IOleParentUndoUnit, IOleUndoUnit ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IOleUndoUnit methods */
    STDMETHOD( Do )( THIS_ IOleUndoManager * ) PURE;
    STDMETHOD( GetDescription )( THIS_ BSTR * ) PURE;
    STDMETHOD( GetUnitType )( THIS_ CLSID *, LONG * ) PURE;
    STDMETHOD( OnNextAdd )( THIS ) PURE;

    /* IOleParentUndoUnit methods */
    STDMETHOD( Open )( THIS_ IOleParentUndoUnit * ) PURE;
    STDMETHOD( Close )( THIS_ IOleParentUndoUnit *, BOOL ) PURE;
    STDMETHOD( Add )( THIS_ IOleUndoUnit * ) PURE;
    STDMETHOD( FindUnit )( THIS_ IOleUndoUnit * ) PURE;
    STDMETHOD( GetParentState )( THIS_ DWORD * ) PURE;
};
typedef IOleParentUndoUnit  *LPOLEPARENTUNDOUNIT;

/* IEnumOleUndoUnits interface */
#undef INTERFACE
#define INTERFACE   IEnumOleUndoUnits
DECLARE_INTERFACE_( IEnumOleUndoUnits, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IEnumOleUndoUnits methods */
    STDMETHOD( Next )( THIS_ ULONG, IOleUndoUnit **, ULONG * ) PURE;
    STDMETHOD( Skip )( THIS_ ULONG ) PURE;
    STDMETHOD( Reset )( THIS ) PURE;
    STDMETHOD( Clone )( THIS_ IEnumOleUndoUnits ** ) PURE;
};
typedef IEnumOleUndoUnits   *LPENUMOLEUNDOUNITS;

/* IOleUndoManager interface */
#undef INTERFACE
#define INTERFACE   IOleUndoManager
DECLARE_INTERFACE_( IOleUndoManager, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IOleUndoManager methods */
    STDMETHOD( Open )( THIS_ IOleParentUndoUnit * ) PURE;
    STDMETHOD( Close )( THIS_ IOleParentUndoUnit *, BOOL ) PURE;
    STDMETHOD( Add )( THIS_ IOleUndoUnit * ) PURE;
    STDMETHOD( GetOpenParentState )( THIS_ DWORD * ) PURE;
    STDMETHOD( DiscardFrom )( THIS_ IOleUndoUnit * ) PURE;
    STDMETHOD( UndoTo )( THIS_ IOleUndoUnit * ) PURE;
    STDMETHOD( RedoTo )( THIS_ IOleUndoUnit * ) PURE;
    STDMETHOD( EnumUndoable )( THIS_ IEnumOleUndoUnits ** ) PURE;
    STDMETHOD( EnumRedoable )( THIS_ IEnumOleUndoUnits ** ) PURE;
    STDMETHOD( GetLastUndoDescription )( THIS_ BSTR * ) PURE;
    STDMETHOD( GetLastRedoDescription )( THIS_ BSTR * ) PURE;
    STDMETHOD( Enable )( THIS_ BOOL ) PURE;
};
typedef IOleUndoManager *LPOLEUNDOMANAGER;

/* IPointerInactive interface */
#undef INTERFACE
#define INTERFACE   IPointerInactive
DECLARE_INTERFACE_( IPointerInactive, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IPointerInactive methods */
    STDMETHOD( GetActivationPolicy )( THIS_ DWORD * ) PURE;
    STDMETHOD( OnInactiveMouseMove )( THIS_ LPCRECT, LONG, LONG, DWORD ) PURE;
    STDMETHOD( OnInactiveSetCursor )( THIS_ LPCRECT, LONG, LONG, DWORD, BOOL ) PURE;
};
typedef IPointerInactive    *LPPOINTERINACTIVE;

/* IObjectWithSite interface */
#undef INTERFACE
#define INTERFACE   IObjectWithSite
DECLARE_INTERFACE_( IObjectWithSite, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IObjectWithSite methods */
    STDMETHOD( SetSite )( THIS_ IUnknown * ) PURE;
    STDMETHOD( GetSite )( THIS_ REFIID, void ** ) PURE;
};
typedef IObjectWithSite *LPOBJECTWITHSITE;

/* IPerPropertyBrowsing interface */
#undef INTERFACE
#define INTERFACE   IPerPropertyBrowsing
DECLARE_INTERFACE_( IPerPropertyBrowsing, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IPerPropertyBrowsing methods */
    STDMETHOD( GetDisplayString )( THIS_ DISPID, BSTR * ) PURE;
    STDMETHOD( MapPropertyToPage )( THIS_ DISPID, CLSID * ) PURE;
    STDMETHOD( GetPredefinedStrings )( THIS_ DISPID, CALPOLESTR *, CADWORD * ) PURE;
    STDMETHOD( GetPredefinedValue )( THIS_ DISPID, DWORD, VARIANT * ) PURE;
};
typedef IPerPropertyBrowsing    *LPPERPROPERTYBROWSING;

/* IPropertyBag2 interface */
#undef INTERFACE
#define INTERFACE   IPropertyBag2
DECLARE_INTERFACE_( IPropertyBag2, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IPropertyBag2 methods */
    STDMETHOD( Read )( THIS_ ULONG, PROPBAG2 *, IErrorLog *, VARIANT *, HRESULT * ) PURE;
    STDMETHOD( Write )( THIS_ ULONG, PROPBAG2 *, VARIANT * ) PURE;
    STDMETHOD( CountProperties )( THIS_ ULONG * ) PURE;
    STDMETHOD( GetPropertyInfo )( THIS_ ULONG, ULONG, PROPBAG2 *, ULONG * ) PURE;
    STDMETHOD( LoadObject )( THIS_ LPCOLESTR, DWORD, IUnknown *, IErrorLog * ) PURE;
};
typedef IPropertyBag2   *LPPROPERTYBAG2;

/* IPersistPropertyBag2 interface */
#undef INTERFACE
#define INTERFACE   IPersistPropertyBag2
DECLARE_INTERFACE_( IPersistPropertyBag2, IPersist ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IPersist methods */
    STDMETHOD( GetClassID )( THIS_ CLSID * ) PURE;

    /* IPersistPropertyBag2 methods */
    STDMETHOD( InitNew )( THIS ) PURE;
    STDMETHOD( Load )( THIS_ IPropertyBag2 *, IErrorLog * ) PURE;
    STDMETHOD( Save )( THIS_ IPropertyBag2 *, BOOL, BOOL ) PURE;
    STDMETHOD( IsDirty )( THIS ) PURE;
};
typedef IPersistPropertyBag2    *LPPERSISTPROPERTYBAG2;

/* IAdviseSinkEx interface */
#undef INTERFACE
#define INTERFACE   IAdviseSinkEx
DECLARE_INTERFACE_( IAdviseSinkEx, IAdviseSink ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IAdviseSink methods */
    STDMETHOD_( void, OnDataChange )( THIS_ FORMATETC *, STGMEDIUM * ) PURE;
    STDMETHOD_( void, OnViewChange )( THIS_ DWORD, LONG ) PURE;
    STDMETHOD_( void, OnRename )( THIS_ IMoniker * ) PURE;
    STDMETHOD_( void, OnSave )( THIS ) PURE;
    STDMETHOD_( void, OnClose )( THIS ) PURE;
    
    /* IAdviseSinkEx methods */
    STDMETHOD_( void, OnViewStatusChange )( THIS_ DWORD ) PURE;
};
typedef IAdviseSinkEx   *LPADVISESINKEX;

/* IQuickActivate interface */
#undef INTERFACE
#define INTERFACE   IQuickActivate
DECLARE_INTERFACE_( IQuickActivate, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IQuickActivate methods */
    STDMETHOD( QuickActivate )( THIS_ QACONTAINER *, QACONTROL * ) PURE;
    STDMETHOD( SetContentExtent )( THIS_ LPSIZEL ) PURE;
    STDMETHOD( GetContentExtent )( THIS_ LPSIZEL ) PURE;
};
typedef IQuickActivate  *LPQUICKACTIVATE;

/* C object macros */
#if (!defined( __cplusplus ) || defined( CINTERFACE )) && defined( COBJMACROS )
    #define IEnumConnections_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IEnumConnections_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IEnumConnections_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IEnumConnections_Next( x, p1, p2, p3 ) \
        (x)->lpVtbl->Next( x, p1, p2, p3 )
    #define IEnumConnections_Skip( x, p ) \
        (x)->lpVtbl->Skip( x, p )
    #define IEnumConnections_Reset( x ) \
        (x)->lpVtbl->Reset( x )
    #define IEnumConnections_Clone( x, p ) \
        (x)->lpVtbl->Clone( x, p )
    #define IConnectionPoint_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IConnectionPoint_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IConnectionPoint_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IConnectionPoint_GetConnectionInterface( x, p ) \
        (x)->lpVtbl->GetConnectionInterface( x, p )
    #define IConnectionPoint_GetConnectionPointContainer( x, p ) \
        (x)->lpVtbl->GetConnectionPointContainer( x, p )
    #define IConnectionPoint_Advise( x, p1, p2 ) \
        (x)->lpVtbl->Advise( x, p1, p2 )
    #define IConnectionPoint_Unadvise( x, p ) \
        (x)->lpVtbl->Unadvise( x, p )
    #define IConnectionPoint_EnumConnections( x, p ) \
        (x)->lpVtbl->EnumConnections( x, p )
    #define IEnumConnectionPoints_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IEnumConnectionPoints_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IEnumConnectionPoints_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IEnumConnectionPoints_Next( x, p1, p2, p3 ) \
        (x)->lpVtbl->Next( x, p1, p2, p3 )
    #define IEnumConnectionPoints_Skip( x, p ) \
        (x)->lpVtbl->Skip( x, p )
    #define IEnumConnectionPoints_Reset( x ) \
        (x)->lpVtbl->Reset( x )
    #define IEnumConnectionPoints_Clone( x, p ) \
        (x)->lpVtbl->Clone( x, p )
    #define IConnectionPointContainer_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IConnectionPointContainer_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IConnectionPointContainer_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IConnectionPointContainer_EnumConnectionPoints( x, p ) \
        (x)->lpVtbl->EnumConnectionPoints( x, p )
    #define IConnectionPointContainer_FindConnectionPoint( x, p1, p2 ) \
        (x)->lpVtbl->FindConnectionPoint( x, p1, p2 )
    #define IClassFactory2_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IClassFactory2_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IClassFactory2_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IClassFactory2_CreateInstance( x, p1, p2, p3 ) \
        (x)->lpVtbl->CreateInstance( x, p1, p2, p3 )
    #define IClassFactory2_LockServer( x, p ) \
        (x)->lpVtbl->LockServer( x, p )
    #define IClassFactory2_GetLicInfo( x, p ) \
        (x)->lpVtbl->GetLicInfo( x, p )
    #define IClassFactory2_RequestLicKey( x, p1, p2 ) \
        (x)->lpVtbl->RequestLicKey( x, p1, p2 )
    #define IClassFactory2_CreateInstanceLic( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->CreateInstanceLic( x, p1, p2, p3, p4, p5 )
    #define IProvideClassInfo_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IProvideClassInfo_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IProvideClassInfo_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IProvideClassInfo_GetClassInfo( x, p ) \
        (x)->lpVtbl->GetClassInfo( x, p )
    #define IProvideClassInfo2_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IProvideClassInfo2_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IProvideClassInfo2_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IProvideClassInfo2_GetClassInfo( x, p ) \
        (x)->lpVtbl->GetClassInfo( x, p )
    #define IProvideClassInfo2_GetGUID( x, p1, p2 ) \
        (x)->lpVtbl->GetGUID( x, p1, p2 )
    #define IProvideMultipleClassInfo_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IProvideMultipleClassInfo_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IProvideMultipleClassInfo_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IProvideMultipleClassInfo_GetClassInfo( x, p ) \
        (x)->lpVtbl->GetClassInfo( x, p )
    #define IProvideMultipleClassInfo_GetGUID( x, p1, p2 ) \
        (x)->lpVtbl->GetGUID( x, p1, p2 )
    #define IProvideMultipleClassInfo_GetMultiTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetMultiTypeInfoCount( x, p )
    #define IProvideMultipleClassInfo_GetInfoOfIndex( x, p1, p2, p3, p4, p5, p6, p7 ) \
        (x)->lpVtbl->GetInfoOfIndex( x, p1, p2, p3, p4, p5, p6, p7 )
    #define IOleControl_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IOleControl_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IOleControl_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IOleControl_GetControlInfo( x, p ) \
        (x)->lpVtbl->GetControlInfo( x, p )
    #define IOleControl_OnMnemonic( x, p ) \
        (x)->lpVtbl->OnMnemonic( x, p )
    #define IOleControl_OnAmbientPropertyChange( x, p ) \
        (x)->lpVtbl->OnAmbientPropertyChange( x, p )
    #define IOleControl_FreezeEvents( x, p ) \
        (x)->lpVtbl->FreezeEvents( x, p )
    #define IOleControlSite_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IOleControlSite_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IOleControlSite_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IOleControlSite_OnControlInfoChanged( x ) \
        (x)->lpVtbl->OnControlInfoChanged( x )
    #define IOleControlSite_LockInPlaceActive( x, p ) \
        (x)->lpVtbl->LockInPlaceActive( x, p )
    #define IOleControlSite_GetExtendedControl( x, p ) \
        (x)->lpVtbl->GetExtendedControl( x, p )
    #define IOleControlSite_TransformCoords( x, p1, p2, p3 ) \
        (x)->lpVtbl->TransformCoords( x, p1, p2, p3 )
    #define IOleControlSite_TranslateAccelerator( x, p1, p2 ) \
        (x)->lpVtbl->TranslateAccelerator( x, p1, p2 )
    #define IOleControlSite_OnFocus( x, p ) \
        (x)->lpVtbl->OnFocus( x, p )
    #define IOleControlSite_ShowPropertyFrame( x ) \
        (x)->lpVtbl->ShowPropertyFrame( x )
    #define IPropertyPage_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IPropertyPage_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IPropertyPage_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IPropertyPage_SetPageSite( x, p ) \
        (x)->lpVtbl->SetPageSite( x, p )
    #define IPropertyPage_Activate( x, p1, p2, p3 ) \
        (x)->lpVtbl->Activate( x, p1, p2, p3 )
    #define IPropertyPage_Deactivate( x ) \
        (x)->lpVtbl->Deactivate( x )
    #define IPropertyPage_GetPageInfo( x, p ) \
        (x)->lpVtbl->GetPageInfo( x, p )
    #define IPropertyPage_SetObjects( x, p1, p2 ) \
        (x)->lpVtbl->SetObjects( x, p1, p2 )
    #define IPropertyPage_Show( x, p ) \
        (x)->lpVtbl->Show( x, p )
    #define IPropertyPage_Move( x, p ) \
        (x)->lpVtbl->Move( x, p )
    #define IPropertyPage_IsPageDirty( x ) \
        (x)->lpVtbl->IsPageDirty( x )
    #define IPropertyPage_Apply( x ) \
        (x)->lpVtbl->Apply( x )
    #define IPropertyPage_Help( x, p ) \
        (x)->lpVtbl->Help( x, p )
    #define IPropertyPage_TranslateAccelerator( x, p ) \
        (x)->lpVtbl->TranslateAccelerator( x, p )
    #define IPropertyPage2_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IPropertyPage2_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IPropertyPage2_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IPropertyPage2_SetPageSite( x, p ) \
        (x)->lpVtbl->SetPageSite( x, p )
    #define IPropertyPage2_Activate( x, p1, p2, p3 ) \
        (x)->lpVtbl->Activate( x, p1, p2, p3 )
    #define IPropertyPage2_Deactivate( x ) \
        (x)->lpVtbl->Deactivate( x )
    #define IPropertyPage2_GetPageInfo( x, p ) \
        (x)->lpVtbl->GetPageInfo( x, p )
    #define IPropertyPage2_SetObjects( x, p1, p2 ) \
        (x)->lpVtbl->SetObjects( x, p1, p2 )
    #define IPropertyPage2_Show( x, p ) \
        (x)->lpVtbl->Show( x, p )
    #define IPropertyPage2_Move( x, p ) \
        (x)->lpVtbl->Move( x, p )
    #define IPropertyPage2_IsPageDirty( x ) \
        (x)->lpVtbl->IsPageDirty( x )
    #define IPropertyPage2_Apply( x ) \
        (x)->lpVtbl->Apply( x )
    #define IPropertyPage2_Help( x, p ) \
        (x)->lpVtbl->Help( x, p )
    #define IPropertyPage2_TranslateAccelerator( x, p ) \
        (x)->lpVtbl->TranslateAccelerator( x, p )
    #define IPropertyPage2_EditProperty( x, p ) \
        (x)->lpVtbl->EditProperty( x, p )
    #define IPropertyPageSite_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IPropertyPageSite_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IPropertyPageSite_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IPropertyPageSite_OnStatusChange( x, p ) \
        (x)->lpVtbl->OnStatusChange( x, p )
    #define IPropertyPageSite_GetLocaleID( x, p ) \
        (x)->lpVtbl->GetLocaleID( x, p )
    #define IPropertyPageSite_GetPageContainer( x, p ) \
        (x)->lpVtbl->GetPageContainer( x, p )
    #define IPropertyPageSite_TranslateAccelerator( x, p ) \
        (x)->lpVtbl->TranslateAccelerator( x, p )
    #define IPropertyNotifySink_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IPropertyNotifySink_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IPropertyNotifySink_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IPropertyNotifySink_OnChanged( x, p ) \
        (x)->lpVtbl->OnChanged( x, p )
    #define IPropertyNotifySink_OnRequestEdit( x, p ) \
        (x)->lpVtbl->OnRequestEdit( x, p )
    #define ISpecifyPropertyPages_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define ISpecifyPropertyPages_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define ISpecifyPropertyPages_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define ISpecifyPropertyPages_GetPages( x, p ) \
        (x)->lpVtbl->GetPages( x, p )
    #define IPersistMemory_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IPersistMemory_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IPersistMemory_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IPersistMemory_GetClassID( x, p ) \
        (x)->lpVtbl->GetClassID( x, p )
    #define IPersistMemory_IsDirty( x ) \
        (x)->lpVtbl->IsDirty( x )
    #define IPersistMemory_Load( x, p1, p2 ) \
        (x)->lpVtbl->Load( x, p1, p2 )
    #define IPersistMemory_Save( x, p1, p2, p3 ) \
        (x)->lpVtbl->Save( x, p1, p2, p3 )
    #define IPersistMemory_GetSizeMax( x, p ) \
        (x)->lpVtbl->GetSizeMax( x, p )
    #define IPersistMemory_InitNew( x ) \
        (x)->lpVtbl->InitNew( x )
    #define IPersistStreamInit_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IPersistStreamInit_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IPersistStreamInit_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IPersistStreamInit_GetClassID( x, p ) \
        (x)->lpVtbl->GetClassID( x, p )
    #define IPersistStreamInit_IsDirty( x ) \
        (x)->lpVtbl->IsDirty( x )
    #define IPersistStreamInit_Load( x, p ) \
        (x)->lpVtbl->Load( x, p )
    #define IPersistStreamInit_Save( x, p1, p2 ) \
        (x)->lpVtbl->Save( x, p1, p2 )
    #define IPersistStreamInit_GetSizeMax( x, p ) \
        (x)->lpVtbl->GetSizeMax( x, p )
    #define IPersistStreamInit_InitNew( x ) \
        (x)->lpVtbl->InitNew( x )
    #define IPersistPropertyBag_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IPersistPropertyBag_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IPersistPropertyBag_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IPersistPropertyBag_GetClassID( x, p ) \
        (x)->lpVtbl->GetClassID( x, p )
    #define IPersistPropertyBag_InitNew( x ) \
        (x)->lpVtbl->InitNew( x )
    #define IPersistPropertyBag_Load( x, p1, p2 ) \
        (x)->lpVtbl->Load( x, p1, p2 )
    #define IPersistPropertyBag_Save( x, p1, p2, p3 ) \
        (x)->lpVtbl->Save( x, p1, p2, p3 )
    #define ISimpleFrameSite_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define ISimpleFrameSite_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define ISimpleFrameSite_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define ISimpleFrameSite_PreMessageFilter( x, p1, p2, p3, p4, p5, p6 ) \
        (x)->lpVtbl->PreMessageFilter( x, p1, p2, p3, p4, p5, p6 )
    #define ISimpleFrameSite_PostMessageFilter( x, p1, p2, p3, p4, p5, p6 ) \
        (x)->lpVtbl->PostMessageFilter( x, p1, p2, p3, p4, p5, p6 )
    #define IFont_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IFont_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IFont_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IFont_get_Name( x, p ) \
        (x)->lpVtbl->get_Name( x, p )
    #define IFont_put_Name( x, p ) \
        (x)->lpVtbl->put_Name( x, p )
    #define IFont_get_Size( x, p ) \
        (x)->lpVtbl->get_Size( x, p )
    #define IFont_put_Size( x, p ) \
        (x)->lpVtbl->put_Size( x, p )
    #define IFont_get_Bold( x, p ) \
        (x)->lpVtbl->get_Bold( x, p )
    #define IFont_put_Bold( x, p ) \
        (x)->lpVtbl->put_Bold( x, p )
    #define IFont_get_Italic( x, p ) \
        (x)->lpVtbl->get_Italic( x, p )
    #define IFont_put_Italic( x, p ) \
        (x)->lpVtbl->put_Italic( x, p )
    #define IFont_get_Underline( x, p ) \
        (x)->lpVtbl->get_Underline( x, p )
    #define IFont_put_Underline( x, p ) \
        (x)->lpVtbl->put_Underline( x, p )
    #define IFont_get_Strikethrough( x, p ) \
        (x)->lpVtbl->get_Strikethrough( x, p )
    #define IFont_put_Strikethrough( x, p ) \
        (x)->lpVtbl->put_Strikethrough( x, p )
    #define IFont_get_Weight( x, p ) \
        (x)->lpVtbl->get_Weight( x, p )
    #define IFont_put_Weight( x, p ) \
        (x)->lpVtbl->put_Weight( x, p )
    #define IFont_get_Charset( x, p ) \
        (x)->lpVtbl->get_Charset( x, p )
    #define IFont_put_Charset( x, p ) \
        (x)->lpVtbl->put_Charset( x, p )
    #define IFont_get_hFont( x, p ) \
        (x)->lpVtbl->get_hFont( x, p )
    #define IFont_Clone( x, p ) \
        (x)->lpVtbl->Clone( x, p )
    #define IFont_IsEqual( x, p ) \
        (x)->lpVtbl->IsEqual( x, p )
    #define IFont_SetRatio( x, p1, p2 ) \
        (x)->lpVtbl->SetRatio( x, p1, p2 )
    #define IFont_QueryTextMetrics( x, p ) \
        (x)->lpVtbl->QueryTextMetrics( x, p )
    #define IFont_AddRefHfont( x, p ) \
        (x)->lpVtbl->AddRefHfont( x, p )
    #define IFont_ReleaseHfont( x, p ) \
        (x)->lpVtbl->ReleaseHfont( x, p )
    #define IFont_SetHdc( x, p ) \
        (x)->lpVtbl->SetHdc( x, p )
    #define IPicture_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IPicture_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IPicture_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IPicture_get_Handle( x, p ) \
        (x)->lpVtbl->get_Handle( x, p )
    #define IPicture_get_hPal( x, p ) \
        (x)->lpVtbl->get_hPal( x, p )
    #define IPicture_get_Type( x, p ) \
        (x)->lpVtbl->get_Type( x, p )
    #define IPicture_get_Width( x, p ) \
        (x)->lpVtbl->get_Width( x, p )
    #define IPicture_get_Height( x, p ) \
        (x)->lpVtbl->get_Height( x, p )
    #define IPicture_Render( x, p1, p2, p3, p4, p5, p6, p7, p8, p9, p10 ) \
        (x)->lpVtbl->Render( x, p1, p2, p3, p4, p5, p6, p7, p8, p9, p10 )
    #define IPicture_set_hPal( x, p ) \
        (x)->lpVtbl->set_hPal( x, p )
    #define IPicture_get_CurDC( x, p ) \
        (x)->lpVtbl->get_CurDC( x, p )
    #define IPicture_SelectPicture( x, p1, p2, p3 ) \
        (x)->lpVtbl->SelectPicture( x, p1, p2, p3 )
    #define IPicture_get_KeepOriginalFormat( x, p ) \
        (x)->lpVtbl->get_KeepOriginalFormat( x, p )
    #define IPicture_put_KeepOriginalFormat( x, p ) \
        (x)->lpVtbl->put_KeepOriginalFormat( x, p )
    #define IPicture_PictureChanged( x ) \
        (x)->lpVtbl->PictureChanged( x )
    #define IPicture_SaveAsFile( x, p1, p2, p3 ) \
        (x)->lpVtbl->SaveAsFile( x, p1, p2, p3 )
    #define IPicture_get_Attributes( x, p ) \
        (x)->lpVtbl->get_Attributes( x, p )
    #define IPicture2_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IPicture2_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IPicture2_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IPicture2_get_Handle( x, p ) \
        (x)->lpVtbl->get_Handle( x, p )
    #define IPicture2_get_hPal( x, p ) \
        (x)->lpVtbl->get_hPal( x, p )
    #define IPicture2_get_Type( x, p ) \
        (x)->lpVtbl->get_Type( x, p )
    #define IPicture2_get_Width( x, p ) \
        (x)->lpVtbl->get_Width( x, p )
    #define IPicture2_get_Height( x, p ) \
        (x)->lpVtbl->get_Height( x, p )
    #define IPicture2_Render( x, p1, p2, p3, p4, p5, p6, p7, p8, p9, p10 ) \
        (x)->lpVtbl->Render( x, p1, p2, p3, p4, p5, p6, p7, p8, p9, p10 )
    #define IPicture2_set_hPal( x, p ) \
        (x)->lpVtbl->set_hPal( x, p )
    #define IPicture2_get_CurDC( x, p ) \
        (x)->lpVtbl->get_CurDC( x, p )
    #define IPicture2_SelectPicture( x, p1, p2, p3 ) \
        (x)->lpVtbl->SelectPicture( x, p1, p2, p3 )
    #define IPicture2_get_KeepOriginalFormat( x, p ) \
        (x)->lpVtbl->get_KeepOriginalFormat( x, p )
    #define IPicture2_put_KeepOriginalFormat( x, p ) \
        (x)->lpVtbl->put_KeepOriginalFormat( x, p )
    #define IPicture2_PictureChanged( x ) \
        (x)->lpVtbl->PictureChanged( x )
    #define IPicture2_SaveAsFile( x, p1, p2, p3 ) \
        (x)->lpVtbl->SaveAsFile( x, p1, p2, p3 )
    #define IPicture2_get_Attributes( x, p ) \
        (x)->lpVtbl->get_Attributes( x, p )
    #define IFontEventsDisp_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IFontEventsDisp_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IFontEventsDisp_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IFontEventsDisp_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IFontEventsDisp_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IFontEventsDisp_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IFontEventsDisp_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IFontDisp_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IFontDisp_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IFontDisp_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IFontDisp_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IFontDisp_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IFontDisp_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IFontDisp_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IPictureDisp_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IPictureDisp_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IPictureDisp_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IPictureDisp_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IPictureDisp_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IPictureDisp_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IPictureDisp_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IOleInPlaceObjectWindowless_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IOleInPlaceObjectWindowless_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IOleInPlaceObjectWindowless_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IOleInPlaceObjectWindowless_GetWindow( x, p ) \
        (x)->lpVtbl->GetWindow( x, p )
    #define IOleInPlaceObjectWindowless_ContextSensitiveHelp( x, p ) \
        (x)->lpVtbl->ContextSensitiveHelp( x, p )
    #define IOleInPlaceObjectWindowless_InPlaceDeactivate( x ) \
        (x)->lpVtbl->InPlaceDeactivate( x )
    #define IOleInPlaceObjectWindowless_UIDeactivate( x ) \
        (x)->lpVtbl->UIDeactivate( x )
    #define IOleInPlaceObjectWindowless_SetObjectRects( x, p1, p2 ) \
        (x)->lpVtbl->SetObjectRects( x, p1, p2 )
    #define IOleInPlaceObjectWindowless_ReactivateAndUndo( x ) \
        (x)->lpVtbl->ReactivateAndUndo( x )
    #define IOleInPlaceObjectWindowless_OnWindowMessage( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->OnWindowMessage( x, p1, p2, p3, p4 )
    #define IOleInPlaceObjectWindowless_GetDropTarget( x, p ) \
        (x)->lpVtbl->GetDropTarget( x, p )
    #define IOleInPlaceSiteEx_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IOleInPlaceSiteEx_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IOleInPlaceSiteEx_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IOleInPlaceSiteEx_GetWindow( x, p ) \
        (x)->lpVtbl->GetWindow( x, p )
    #define IOleInPlaceSiteEx_ContextSensitiveHelp( x, p ) \
        (x)->lpVtbl->ContextSensitiveHelp( x, p )
    #define IOleInPlaceSiteEx_CanInPlaceActivate( x ) \
        (x)->lpVtbl->CanInPlaceActivate( x )
    #define IOleInPlaceSiteEx_OnInPlaceActivate( x ) \
        (x)->lpVtbl->OnInPlaceActivate( x )
    #define IOleInPlaceSiteEx_OnUIActivate( x ) \
        (x)->lpVtbl->OnUIActivate( x )
    #define IOleInPlaceSiteEx_GetWindowContext( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetWindowContext( x, p1, p2, p3, p4, p5 )
    #define IOleInPlaceSiteEx_Scroll( x, p ) \
        (x)->lpVtbl->Scroll( x, p )
    #define IOleInPlaceSiteEx_OnUIDeactivate( x, p ) \
        (x)->lpVtbl->OnUIDeactivate( x, p )
    #define IOleInPlaceSiteEx_OnInPlaceDeactivate( x ) \
        (x)->lpVtbl->OnInPlaceDeactivate( x )
    #define IOleInPlaceSiteEx_DiscardUndoState( x ) \
        (x)->lpVtbl->DiscardUndoState( x )
    #define IOleInPlaceSiteEx_DeactivateAndUndo( x ) \
        (x)->lpVtbl->DeactivateAndUndo( x )
    #define IOleInPlaceSiteEx_OnPosRectChange( x, p ) \
        (x)->lpVtbl->OnPosRectChange( x, p )
    #define IOleInPlaceSiteEx_OnInPlaceActivateEx( x, p1, p2 ) \
        (x)->lpVtbl->OnInPlaceActivateEx( x, p1, p2 )
    #define IOleInPlaceSiteEx_OnInPlaceDeactivateEx( x, p ) \
        (x)->lpVtbl->OnInPlaceDeactivateEx( x, p )
    #define IOleInPlaceSiteEx_RequestUIActivate( x ) \
        (x)->lpVtbl->RequestUIActivate( x )
    #define IOleInPlaceSiteWindowless_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IOleInPlaceSiteWindowless_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IOleInPlaceSiteWindowless_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IOleInPlaceSiteWindowless_GetWindow( x, p ) \
        (x)->lpVtbl->GetWindow( x, p )
    #define IOleInPlaceSiteWindowless_ContextSensitiveHelp( x, p ) \
        (x)->lpVtbl->ContextSensitiveHelp( x, p )
    #define IOleInPlaceSiteWindowless_CanInPlaceActivate( x ) \
        (x)->lpVtbl->CanInPlaceActivate( x )
    #define IOleInPlaceSiteWindowless_OnInPlaceActivate( x ) \
        (x)->lpVtbl->OnInPlaceActivate( x )
    #define IOleInPlaceSiteWindowless_OnUIActivate( x ) \
        (x)->lpVtbl->OnUIActivate( x )
    #define IOleInPlaceSiteWindowless_GetWindowContext( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetWindowContext( x, p1, p2, p3, p4, p5 )
    #define IOleInPlaceSiteWindowless_Scroll( x, p ) \
        (x)->lpVtbl->Scroll( x, p )
    #define IOleInPlaceSiteWindowless_OnUIDeactivate( x, p ) \
        (x)->lpVtbl->OnUIDeactivate( x, p )
    #define IOleInPlaceSiteWindowless_OnInPlaceDeactivate( x ) \
        (x)->lpVtbl->OnInPlaceDeactivate( x )
    #define IOleInPlaceSiteWindowless_DiscardUndoState( x ) \
        (x)->lpVtbl->DiscardUndoState( x )
    #define IOleInPlaceSiteWindowless_DeactivateAndUndo( x ) \
        (x)->lpVtbl->DeactivateAndUndo( x )
    #define IOleInPlaceSiteWindowless_OnPosRectChange( x, p ) \
        (x)->lpVtbl->OnPosRectChange( x, p )
    #define IOleInPlaceSiteWindowless_OnInPlaceActivateEx( x, p1, p2 ) \
        (x)->lpVtbl->OnInPlaceActivateEx( x, p1, p2 )
    #define IOleInPlaceSiteWindowless_OnInPlaceDeactivateEx( x, p ) \
        (x)->lpVtbl->OnInPlaceDeactivateEx( x, p )
    #define IOleInPlaceSiteWindowless_RequestUIActivate( x ) \
        (x)->lpVtbl->RequestUIActivate( x )
    #define IOleInPlaceSiteWindowless_CanWindowlessActivate( x ) \
        (x)->lpVtbl->CanWindowlessActivate( x )
    #define IOleInPlaceSiteWindowless_GetCapture( x ) \
        (x)->lpVtbl->GetCapture( x )
    #define IOleInPlaceSiteWindowless_SetCapture( x, p ) \
        (x)->lpVtbl->SetCapture( x, p )
    #define IOleInPlaceSiteWindowless_GetFocus( x ) \
        (x)->lpVtbl->GetFocus( x )
    #define IOleInPlaceSiteWindowless_SetFocus( x, p ) \
        (x)->lpVtbl->SetFocus( x, p )
    #define IOleInPlaceSiteWindowless_GetDC( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetDC( x, p1, p2, p3 )
    #define IOleInPlaceSiteWindowless_ReleaseDC( x, p ) \
        (x)->lpVtbl->ReleaseDC( x, p )
    #define IOleInPlaceSiteWindowless_InvalidateRect( x, p1, p2 ) \
        (x)->lpVtbl->InvalidateRect( x, p1, p2 )
    #define IOleInPlaceSiteWindowless_InvalidateRgn( x, p1, p2 ) \
        (x)->lpVtbl->InvalidateRgn( x, p1, p2 )
    #define IOleInPlaceSiteWindowless_ScrollRect( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->ScrollRect( x, p1, p2, p3, p4 )
    #define IOleInPlaceSiteWindowless_AdjustRect( x, p ) \
        (x)->lpVtbl->AdjustRect( x, p )
    #define IOleInPlaceSiteWindowless_OnDefWindowMessage( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->OnDefWindowMessage( x, p1, p2, p3, p4 )
    #define IViewObjectEx_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IViewObjectEx_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IViewObjectEx_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IViewObjectEx_Draw( x, p1, p2, p3, p4, p5, p6, p7, p8, p9, p10 ) \
        (x)->lpVtbl->Draw( x, p1, p2, p3, p4, p5, p6, p7, p8, p9, p10 )
    #define IViewObjectEx_GetColorSet( x, p1, p2, p3, p4, p5, p6 ) \
        (x)->lpVtbl->GetColorSet( x, p1, p2, p3, p4, p5, p6 )
    #define IViewObjectEx_Freeze( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->Freeze( x, p1, p2, p3, p4 )
    #define IViewObjectEx_Unfreeze( x, p ) \
        (x)->lpVtbl->Unfreeze( x, p )
    #define IViewObjectEx_SetAdvise( x, p1, p2, p3 ) \
        (x)->lpVtbl->SetAdvise( x, p1, p2, p3 )
    #define IViewObjectEx_GetAdvise( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetAdvise( x, p1, p2, p3 )
    #define IViewObjectEx_GetExtent( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->GetExtent( x, p1, p2, p3, p4 )
    #define IViewObjectEx_GetRect( x, p1, p2 ) \
        (x)->lpVtbl->GetRect( x, p1, p2 )
    #define IViewObjectEx_GetViewStatus( x, p ) \
        (x)->lpVtbl->GetViewStatus( x, p )
    #define IViewObjectEx_QueryHitPoint( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->QueryHitPoint( x, p1, p2, p3, p4, p5 )
    #define IViewObjectEx_QueryHitRect( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->QueryHitRect( x, p1, p2, p3, p4, p5 )
    #define IViewObjectEx_GetNaturalExtent( x, p1, p2, p3, p4, p5, p6 ) \
        (x)->lpVtbl->GetNaturalExtent( x, p1, p2, p3, p4, p5, p6 )
    #define IOleUndoUnit_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IOleUndoUnit_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IOleUndoUnit_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IOleUndoUnit_Do( x, p ) \
        (x)->lpVtbl->Do( x, p )
    #define IOleUndoUnit_GetDescription( x, p ) \
        (x)->lpVtbl->GetDescription( x, p )
    #define IOleUndoUnit_GetUnitType( x, p1, p2 ) \
        (x)->lpVtbl->GetUnitType( x, p1, p2 )
    #define IOleUndoUnit_OnNextAdd( x ) \
        (x)->lpVtbl->OnNextAdd( x )
    #define IOleParentUndoUnit_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IOleParentUndoUnit_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IOleParentUndoUnit_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IOleParentUndoUnit_Do( x, p ) \
        (x)->lpVtbl->Do( x, p )
    #define IOleParentUndoUnit_GetDescription( x, p ) \
        (x)->lpVtbl->GetDescription( x, p )
    #define IOleParentUndoUnit_GetUnitType( x, p1, p2 ) \
        (x)->lpVtbl->GetUnitType( x, p1, p2 )
    #define IOleParentUndoUnit_OnNextAdd( x ) \
        (x)->lpVtbl->OnNextAdd( x )
    #define IOleParentUndoUnit_Open( x, p ) \
        (x)->lpVtbl->Open( x, p )
    #define IOleParentUndoUnit_Close( x, p1, p2 ) \
        (x)->lpVtbl->Close( x, p1, p2 )
    #define IOleParentUndoUnit_Add( x, p ) \
        (x)->lpVtbl->Add( x, p )
    #define IOleParentUndoUnit_FindUnit( x, p ) \
        (x)->lpVtbl->FindUnit( x, p )
    #define IOleParentUndoUnit_GetParentState( x, p ) \
        (x)->lpVtbl->GetParentState( x, p )
    #define IEnumOleUndoUnits_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IEnumOleUndoUnits_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IEnumOleUndoUnits_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IEnumOleUndoUnits_Next( x, p1, p2, p3 ) \
        (x)->lpVtbl->Next( x, p1, p2, p3 )
    #define IEnumOleUndoUnits_Skip( x, p ) \
        (x)->lpVtbl->Skip( x, p )
    #define IEnumOleUndoUnits_Reset( x ) \
        (x)->lpVtbl->Reset( x )
    #define IEnumOleUndoUnits_Clone( x, p ) \
        (x)->lpVtbl->Clone( x, p )
    #define IOleUndoManager_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IOleUndoManager_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IOleUndoManager_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IOleUndoManager_Open( x, p ) \
        (x)->lpVtbl->Open( x, p )
    #define IOleUndoManager_Close( x, p1, p2 ) \
        (x)->lpVtbl->Close( x, p1, p2 )
    #define IOleUndoManager_Add( x, p ) \
        (x)->lpVtbl->Add( x, p )
    #define IOleUndoManager_GetOpenParentState( x, p ) \
        (x)->lpVtbl->GetOpenParentState( x, p )
    #define IOleUndoManager_DiscardFrom( x, p ) \
        (x)->lpVtbl->DiscardFrom( x, p )
    #define IOleUndoManager_UndoTo( x, p ) \
        (x)->lpVtbl->UndoTo( x, p )
    #define IOleUndoManager_RedoTo( x, p ) \
        (x)->lpVtbl->RedoTo( x, p )
    #define IOleUndoManager_EnumUndoable( x, p ) \
        (x)->lpVtbl->EnumUndoable( x, p )
    #define IOleUndoManager_EnumRedoable( x, p ) \
        (x)->lpVtbl->EnumRedoable( x, p )
    #define IOleUndoManager_GetLastUndoDescription( x, p ) \
        (x)->lpVtbl->GetLastUndoDescription( x, p )
    #define IOleUndoManager_GetLastRedoDescription( x, p ) \
        (x)->lpVtbl->GetLastRedoDescription( x, p )
    #define IOleUndoManager_Enable( x, p ) \
        (x)->lpVtbl->Enable( x, p )
    #define IPointerInactive_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IPointerInactive_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IPointerInactive_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IPointerInactive_GetActivationPolicy( x, p ) \
        (x)->lpVtbl->GetActivationPolicy( x, p )
    #define IPointerInactive_OnInactiveMouseMove( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->OnInactiveMouseMove( x, p1, p2, p3, p4 )
    #define IPointerInactive_OnInactiveSetCursor( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->OnInactiveSetCursor( x, p1, p2, p3, p4, p5 )
    #define IObjectWithSite_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IObjectWithSite_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IObjectWithSite_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IObjectWithSite_SetSite( x, p ) \
        (x)->lpVtbl->SetSite( x, p )
    #define IObjectWithSite_GetSite( x, p1, p2 ) \
        (x)->lpVtbl->GetSite( x, p1, p2 )
    #define IPerPropertyBrowsing_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IPerPropertyBrowsing_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IPerPropertyBrowsing_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IPerPropertyBrowsing_GetDisplayString( x, p1, p2 ) \
        (x)->lpVtbl->GetDisplayString( x, p1, p2 )
    #define IPerPropertyBrowsing_MapPropertyToPage( x, p1, p2 ) \
        (x)->lpVtbl->MapPropertyToPage( x, p1, p2 )
    #define IPerPropertyBrowsing_GetPredefinedStrings( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetPredefinedStrings( x, p1, p2, p3 )
    #define IPerPropertyBrowsing_GetPredefinedValue( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetPredefinedValue( x, p1, p2, p3 )
    #define IPropertyBag2_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IPropertyBag2_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IPropertyBag2_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IPropertyBag2_Read( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->Read( x, p1, p2, p3, p4, p5 )
    #define IPropertyBag2_Write( x, p1, p2, p3 ) \
        (x)->lpVtbl->Write( x, p1, p2, p3 )
    #define IPropertyBag2_CountProperties( x, p ) \
        (x)->lpVtbl->CountProperties( x, p )
    #define IPropertyBag2_GetPropertyInfo( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->GetPropertyInfo( x, p1, p2, p3, p4 )
    #define IPropertyBag2_LoadObject( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->LoadObject( x, p1, p2, p3, p4 )
    #define IPersistPropertyBag2_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IPersistPropertyBag2_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IPersistPropertyBag2_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IPersistPropertyBag2_GetClassID( x, p ) \
        (x)->lpVtbl->GetClassID( x, p )
    #define IPersistPropertyBag2_InitNew( x ) \
        (x)->lpVtbl->InitNew( x )
    #define IPersistPropertyBag2_Load( x, p1, p2 ) \
        (x)->lpVtbl->Load( x, p1, p2 )
    #define IPersistPropertyBag2_Save( x, p1, p2, p3 ) \
        (x)->lpVtbl->Save( x, p1, p2, p3 )
    #define IPersistPropertyBag2_IsDirty( x ) \
        (x)->lpVtbl->IsDirty( x )
    #define IAdviseSinkEx_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IAdviseSinkEx_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IAdviseSinkEx_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IAdviseSinkEx_OnDataChange( x, p1, p2 ) \
        (x)->lpVtbl->OnDataChange( x, p1, p2 )
    #define IAdviseSinkEx_OnViewChange( x, p1, p2 ) \
        (x)->lpVtbl->OnViewChange( x, p1, p2 )
    #define IAdviseSinkEx_OnRename( x, p ) \
        (x)->lpVtbl->OnRename( x, p )
    #define IAdviseSinkEx_OnSave( x ) \
        (x)->lpVtbl->OnSave( x )
    #define IAdviseSinkEx_OnClose( x ) \
        (x)->lpVtbl->OnClose( x )
    #define IAdviseSinkEx_OnViewStatusChange( x, p ) \
        (x)->lpVtbl->OnViewStatusChange( x, p )
    #define IQuickActivate_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IQuickActivate_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IQuickActivate_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IQuickActivate_QuickActivate( x, p1, p2 ) \
        (x)->lpVtbl->QuickActivate( x, p1, p2 )
    #define IQuickActivate_SetContentExtent( x, p ) \
        (x)->lpVtbl->SetContentExtent( x, p )
    #define IQuickActivate_GetContentExtent( x, p ) \
        (x)->lpVtbl->GetContentExtent( x, p )
#endif

#ifdef __cplusplus
} /* extern "C" */
#endif

/* GUIDs */
EXTERN_C const IID  __cdecl IID_IEnumConnections;
EXTERN_C const IID  __cdecl IID_IConnectionPoint;
EXTERN_C const IID  __cdecl IID_IEnumConnectionPoints;
EXTERN_C const IID  __cdecl IID_IConnectionPointContainer;
EXTERN_C const IID  __cdecl IID_IClassFactory2;
EXTERN_C const IID  __cdecl IID_IProvideClassInfo;
EXTERN_C const IID  __cdecl IID_IProvideClassInfo2;
EXTERN_C const IID  __cdecl IID_IProvideMultipleClassInfo;
EXTERN_C const IID  __cdecl IID_IOleControl;
EXTERN_C const IID  __cdecl IID_IOleControlSite;
EXTERN_C const IID  __cdecl IID_IPropertyPage;
EXTERN_C const IID  __cdecl IID_IPropertyPage2;
EXTERN_C const IID  __cdecl IID_IPropertyPageSite;
EXTERN_C const IID  __cdecl IID_IPropertyNotifySink;
EXTERN_C const IID  __cdecl IID_ISpecifyPropertyPages;
EXTERN_C const IID  __cdecl IID_IPersistMemory;
EXTERN_C const IID  __cdecl IID_IPersistStreamInit;
EXTERN_C const IID  __cdecl IID_IPersistPropertyBag;
EXTERN_C const IID  __cdecl IID_ISimpleFrameSite;
EXTERN_C const IID  __cdecl IID_IFont;
EXTERN_C const IID  __cdecl IID_IPicture;
EXTERN_C const IID  __cdecl IID_IPicture2;
EXTERN_C const IID  __cdecl IID_IFontEventsDisp;
EXTERN_C const IID  __cdecl IID_IFontDisp;
EXTERN_C const IID  __cdecl IID_IPictureDisp;
EXTERN_C const IID  __cdecl IID_IOleInPlaceObjectWindowless;
EXTERN_C const IID  __cdecl IID_IOleInPlaceSiteEx;
EXTERN_C const IID  __cdecl IID_IOleInPlaceSiteWindowless;
EXTERN_C const IID  __cdecl IID_IViewObjectEx;
EXTERN_C const IID  __cdecl IID_IOleUndoUnit;
EXTERN_C const IID  __cdecl IID_IOleParentUndoUnit;
EXTERN_C const IID  __cdecl IID_IEnumOleUndoUnits;
EXTERN_C const IID  __cdecl IID_IOleUndoManager;
EXTERN_C const IID  __cdecl IID_IPointerInactive;
EXTERN_C const IID  __cdecl IID_IObjectWithSite;
EXTERN_C const IID  __cdecl IID_IPerPropertyBrowsing;
EXTERN_C const IID  __cdecl IID_IPropertyBag2;
EXTERN_C const IID  __cdecl IID_IPersistPropertyBag2;
EXTERN_C const IID  __cdecl IID_IAdviseSinkEx;
EXTERN_C const IID  __cdecl IID_IQuickActivate;

#endif /* __ocidl_h__ */
