/*
 *  ntsecapi.h  Local Security Authority (LSA) functions
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2014 The Open Watcom Contributors. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file;
#endif

/* LSA GUIDs */
#if !defined( INITGUID ) || !defined( _LSA_GUIDS_DEFINED )
DEFINE_GUID( Audit_System_SecurityStateChange, 0x0CCE9210, 0x69AE, 0x11D9, 0xBE, 0xD3, 0x50, 0x50, 0x54, 0x50, 0x30, 0x30 );
DEFINE_GUID( Audit_System_SecuritySubsystemExtension, 0x0CCE9211, 0x69AE, 0x11D9, 0xBE, 0xD3, 0x50, 0x50, 0x54, 0x50, 0x30, 0x30 );
DEFINE_GUID( Audit_System_Integrity, 0x0CCE9212, 0x69AE, 0x11D9, 0xBE, 0xD3, 0x50, 0x50, 0x54, 0x50, 0x30, 0x30 );
DEFINE_GUID( Audit_System_IPSecDriverEvents, 0x0CCE9213, 0x69AE, 0x11D9, 0xBE, 0xD3, 0x50, 0x50, 0x54, 0x50, 0x30, 0x30 );
DEFINE_GUID( Audit_System_Others, 0x0CCE9214, 0x69AE, 0x11D9, 0xBE, 0xD3, 0x50, 0x50, 0x54, 0x50, 0x30, 0x30 );
DEFINE_GUID( Audit_Logon_Logon, 0x0CCE9215, 0x69AE, 0x11D9, 0xBE, 0xD3, 0x50, 0x50, 0x54, 0x50, 0x30, 0x30 );
DEFINE_GUID( Audit_Logon_Logoff, 0x0CCE9216, 0x69AE, 0x11D9, 0xBE, 0xD3, 0x50, 0x50, 0x54, 0x50, 0x30, 0x30 );
DEFINE_GUID( Audit_Logon_AccountLockout, 0x0CCE9217, 0x69AE, 0x11D9, 0xBE, 0xD3, 0x50, 0x50, 0x54, 0x50, 0x30, 0x30 );
DEFINE_GUID( Audit_Logon_IPSecMainMode, 0x0CCE9218, 0x69AE, 0x11D9, 0xBE, 0xD3, 0x50, 0x50, 0x54, 0x50, 0x30, 0x30 );
DEFINE_GUID( Audit_Logon_IPSecQuickMode, 0x0CCE9219, 0x69AE, 0x11D9, 0xBE, 0xD3, 0x50, 0x50, 0x54, 0x50, 0x30, 0x30 );
DEFINE_GUID( Audit_Logon_IPSecUserMode, 0x0CCE921A, 0x69AE, 0x11D9, 0xBE, 0xD3, 0x50, 0x50, 0x54, 0x50, 0x30, 0x30 );
DEFINE_GUID( Audit_Logon_SpecialLogon, 0x0CCE921B, 0x69AE, 0x11D9, 0xBE, 0xD3, 0x50, 0x50, 0x54, 0x50, 0x30, 0x30 );
DEFINE_GUID( Audit_Logon_Others, 0x0CCE921C, 0x69AE, 0x11D9, 0xBE, 0xD3, 0x50, 0x50, 0x54, 0x50, 0x30, 0x30 );
DEFINE_GUID( Audit_ObjectAccess_FileSystem, 0x0CCE921D, 0x69AE, 0x11D9, 0xBE, 0xD3, 0x50, 0x50, 0x54, 0x50, 0x30, 0x30 );
DEFINE_GUID( Audit_ObjectAccess_Registry, 0x0CCE921E, 0x69AE, 0x11D9, 0xBE, 0xD3, 0x50, 0x50, 0x54, 0x50, 0x30, 0x30 );
DEFINE_GUID( Audit_ObjectAccess_Kernel, 0x0CCE921F, 0x69AE, 0x11D9, 0xBE, 0xD3, 0x50, 0x50, 0x54, 0x50, 0x30, 0x30 );
DEFINE_GUID( Audit_ObjectAccess_Sam, 0x0CCE9220, 0x69AE, 0x11D9, 0xBE, 0xD3, 0x50, 0x50, 0x54, 0x50, 0x30, 0x30 );
DEFINE_GUID( Audit_ObjectAccess_CertificationServices, 0x0CCE9221, 0x69AE, 0x11D9, 0xBE, 0xD3, 0x50, 0x50, 0x54, 0x50, 0x30, 0x30 );
DEFINE_GUID( Audit_ObjectAccess_ApplicationGenerated, 0x0CCE9222, 0x69AE, 0x11D9, 0xBE, 0xD3, 0x50, 0x50, 0x54, 0x50, 0x30, 0x30 );
DEFINE_GUID( Audit_ObjectAccess_Handle, 0x0CCE9223, 0x69AE, 0x11D9, 0xBE, 0xD3, 0x50, 0x50, 0x54, 0x50, 0x30, 0x30 );
DEFINE_GUID( Audit_ObjectAccess_Share, 0x0CCE9224, 0x69AE, 0x11D9, 0xBE, 0xD3, 0x50, 0x50, 0x54, 0x50, 0x30, 0x30 );
DEFINE_GUID( Audit_ObjectAccess_FirewallPacketDrops, 0x0CCE9225, 0x69AE, 0x11D9, 0xBE, 0xD3, 0x50, 0x50, 0x54, 0x50, 0x30, 0x30 );
DEFINE_GUID( Audit_ObjectAccess_FirewallConnection, 0x0CCE9226, 0x69AE, 0x11D9, 0xBE, 0xD3, 0x50, 0x50, 0x54, 0x50, 0x30, 0x30 );
DEFINE_GUID( Audit_ObjectAccess_Other, 0x0CCE9227, 0x69AE, 0x11D9, 0xBE, 0xD3, 0x50, 0x50, 0x54, 0x50, 0x30, 0x30 );
DEFINE_GUID( Audit_PrivilegeUse_Sensitive, 0x0CCE9228, 0x69AE, 0x11D9, 0xBE, 0xD3, 0x50, 0x50, 0x54, 0x50, 0x30, 0x30 );
DEFINE_GUID( Audit_PrivilegeUse_NonSensitive, 0x0CCE9229, 0x69AE, 0x11D9, 0xBE, 0xD3, 0x50, 0x50, 0x54, 0x50, 0x30, 0x30 );
DEFINE_GUID( Audit_PrivilegeUse_Others, 0x0CCE922A, 0x69AE, 0x11D9, 0xBE, 0xD3, 0x50, 0x50, 0x54, 0x50, 0x30, 0x30 );
DEFINE_GUID( Audit_DetailedTracking_ProcessCreation, 0x0CCE922B, 0x69AE, 0x11D9, 0xBE, 0xD3, 0x50, 0x50, 0x54, 0x50, 0x30, 0x30 );
DEFINE_GUID( Audit_DetailedTracking_ProcessTermination, 0x0CCE922C, 0x69AE, 0x11D9, 0xBE, 0xD3, 0x50, 0x50, 0x54, 0x50, 0x30, 0x30 );
DEFINE_GUID( Audit_DetailedTracking_DpapiActivity, 0x0CCE922D, 0x69AE, 0x11D9, 0xBE, 0xD3, 0x50, 0x50, 0x54, 0x50, 0x30, 0x30 );
DEFINE_GUID( Audit_DetailedTracking_RpcCall, 0x0CCE922E, 0x69AE, 0x11D9, 0xBE, 0xD3, 0x50, 0x50, 0x54, 0x50, 0x30, 0x30 );
DEFINE_GUID( Audit_PolicyChange_AuditPolicy, 0x0CCE922F, 0x69AE, 0x11D9, 0xBE, 0xD3, 0x50, 0x50, 0x54, 0x50, 0x30, 0x30 );
DEFINE_GUID( Audit_PolicyChange_AuthenticationPolicy, 0x0CCE9230, 0x69AE, 0x11D9, 0xBE, 0xD3, 0x50, 0x50, 0x54, 0x50, 0x30, 0x30 );
DEFINE_GUID( Audit_PolicyChange_AuthorizationPolicy, 0x0CCE9231, 0x69AE, 0x11D9, 0xBE, 0xD3, 0x50, 0x50, 0x54, 0x50, 0x30, 0x30 );
DEFINE_GUID( Audit_PolicyChange_MpsscvRulePolicy, 0x0CCE9232, 0x69AE, 0x11D9, 0xBE, 0xD3, 0x50, 0x50, 0x54, 0x50, 0x30, 0x30 );
DEFINE_GUID( Audit_PolicyChange_WfpIPSecPolicy, 0x0CCE9233, 0x69AE, 0x11D9, 0xBE, 0xD3, 0x50, 0x50, 0x54, 0x50, 0x30, 0x30 );
DEFINE_GUID( Audit_PolicyChange_Others, 0x0CCE9234, 0x69AE, 0x11D9, 0xBE, 0xD3, 0x50, 0x50, 0x54, 0x50, 0x30, 0x30 );
DEFINE_GUID( Audit_AccountManagement_UserAccount, 0x0CCE9235, 0x69AE, 0x11D9, 0xBE, 0xD3, 0x50, 0x50, 0x54, 0x50, 0x30, 0x30 );
DEFINE_GUID( Audit_AccountManagement_ComputerAccount, 0x0CCE9236, 0x69AE, 0x11D9, 0xBE, 0xD3, 0x50, 0x50, 0x54, 0x50, 0x30, 0x30 );
DEFINE_GUID( Audit_AccountManagement_SecurityGroup, 0x0CCE9237, 0x69AE, 0x11D9, 0xBE, 0xD3, 0x50, 0x50, 0x54, 0x50, 0x30, 0x30 );
DEFINE_GUID( Audit_AccountManagement_DistributionGroup, 0x0CCE9238, 0x69AE, 0x11D9, 0xBE, 0xD3, 0x50, 0x50, 0x54, 0x50, 0x30, 0x30 );
DEFINE_GUID( Audit_AccountManagement_ApplicationGroup, 0x0CCE9239, 0x69AE, 0x11D9, 0xBE, 0xD3, 0x50, 0x50, 0x54, 0x50, 0x30, 0x30 );
DEFINE_GUID( Audit_AccountManagement_Others, 0x0CCE923A, 0x69AE, 0x11D9, 0xBE, 0xD3, 0x50, 0x50, 0x54, 0x50, 0x30, 0x30 );
DEFINE_GUID( Audit_DSAccess_DSAccess, 0x0CCE923B, 0x69AE, 0x11D9, 0xBE, 0xD3, 0x50, 0x50, 0x54, 0x50, 0x30, 0x30 );
DEFINE_GUID( Audit_DsAccess_AdAuditChanges, 0x0CCE923C, 0x69AE, 0x11D9, 0xBE, 0xD3, 0x50, 0x50, 0x54, 0x50, 0x30, 0x30 );
DEFINE_GUID( Audit_Ds_Replication, 0x0CCE923D, 0x69AE, 0x11D9, 0xBE, 0xD3, 0x50, 0x50, 0x54, 0x50, 0x30, 0x30 );
DEFINE_GUID( Audit_Ds_DetailedReplication, 0x0CCE923E, 0x69AE, 0x11D9, 0xBE, 0xD3, 0x50, 0x50, 0x54, 0x50, 0x30, 0x30 );
DEFINE_GUID( Audit_AccountLogon_CredentialValidation, 0x0CCE923F, 0x69AE, 0x11D9, 0xBE, 0xD3, 0x50, 0x50, 0x54, 0x50, 0x30, 0x30 );
DEFINE_GUID( Audit_AccountLogon_Kerberos, 0x0CCE9240, 0x69AE, 0x11D9, 0xBE, 0xD3, 0x50, 0x50, 0x54, 0x50, 0x30, 0x30 );
DEFINE_GUID( Audit_AccountLogon_Others, 0x0CCE9241, 0x69AE, 0x11D9, 0xBE, 0xD3, 0x50, 0x50, 0x54, 0x50, 0x30, 0x30 );
DEFINE_GUID( Audit_AccountLogin_KerbCredentialValidation, 0x0CCE9242, 0x69AE, 0x11D9, 0xBE, 0xD3, 0x50, 0x50, 0x54, 0x50, 0x30, 0x30 );
DEFINE_GUID( Audit_Logon_NPS, 0x0CCE9243, 0x69AE, 0x11D9, 0xBE, 0xD3, 0x50, 0x50, 0x54, 0x50, 0x30, 0x30 );
DEFINE_GUID( Audit_ObjectAccess_DetailedFileShare, 0x0CCE9244, 0x69AE, 0x11D9, 0xBE, 0xD3, 0x50, 0x50, 0x54, 0x50, 0x30, 0x30 );
DEFINE_GUID( Audit_System, 0x69979848, 0x797A, 0x11D9, 0xBE, 0xD3, 0x50, 0x50, 0x54, 0x50, 0x30, 0x30 );
DEFINE_GUID( Audit_Logon, 0x69979849, 0x797A, 0x11D9, 0xBE, 0xD3, 0x50, 0x50, 0x54, 0x50, 0x30, 0x30 );
DEFINE_GUID( Audit_ObjectAccess, 0x6997984A, 0x797A, 0x11D9, 0xBE, 0xD3, 0x50, 0x50, 0x54, 0x50, 0x30, 0x30 );
DEFINE_GUID( Audit_PrivilegeUse, 0x6997984B, 0x797A, 0x11D9, 0xBE, 0xD3, 0x50, 0x50, 0x54, 0x50, 0x30, 0x30 );
DEFINE_GUID( Audit_DetailedTracking, 0x6997984C, 0x797A, 0x11D9, 0xBE, 0xD3, 0x50, 0x50, 0x54, 0x50, 0x30, 0x30 );
DEFINE_GUID( Audit_PolicyChange, 0x6997984D, 0x797A, 0x11D9, 0xBE, 0xD3, 0x50, 0x50, 0x54, 0x50, 0x30, 0x30 );
DEFINE_GUID( Audit_AccountManagement, 0x6997984E, 0x797A, 0x11D9, 0xBE, 0xD3, 0x50, 0x50, 0x54, 0x50, 0x30, 0x30 );
DEFINE_GUID( Audit_DirectoryServiceAccess, 0x6997984F, 0x797A, 0x11D9, 0xBE, 0xD3, 0x50, 0x50, 0x54, 0x50, 0x30, 0x30 );
DEFINE_GUID( Audit_AccountLogon, 0x69979850, 0x797A, 0x11D9, 0xBE, 0xD3, 0x50, 0x50, 0x54, 0x50, 0x30, 0x30 );
#ifdef INITGUID
    #define _LSA_GUIDS_DEFINED
#endif
#endif

#ifndef _NTSECAPI_
#define _NTSECAPI_

#ifdef __cplusplus
extern "C" {
#endif

/* NT error code data type */
#ifndef _NTSTATUS_DEFINED
#define _NTSTATUS_DEFINED
typedef LONG    NTSTATUS;
typedef LONG    *PNTSTATUS;
#endif

/* LSA operational mode data type */
typedef ULONG   LSA_OPERATIONAL_MODE;
typedef ULONG   *PLSA_OPERATIONAL_MODE;

/* Policy audit event options data type */
typedef ULONG   POLICY_AUDIT_EVENT_OPTIONS;
typedef ULONG   *PPOLICY_AUDIT_EVENT_OPTIONS;

/* LSA handle data type */
typedef PVOID   LSA_HANDLE;
typedef PVOID   *PLSA_HANDLE;

/* LSA enumeration context data type */
typedef ULONG   LSA_ENUMERATION_HANDLE;
typedef ULONG   *PLSA_ENUMERATION_HANDLE;

/* LSA operational mode flags */
#define LSA_MODE_PASSWORD_PROTECTED     0x00000001L
#define LSA_MODE_INDIVIDUAL_ACCOUNTS    0x00000002L
#define LSA_MODE_MANDATORY_ACCESS       0x00000004L
#define LSA_MODE_LOG_FULL               0x00000008L

/* Security audit object flags */
#define SE_ADT_OBJECT_ONLY  0x0001

/* Maximum numbers of audit parameters */
#define SE_MAX_AUDIT_PARAMETERS         32
#define SE_MAX_GENERIC_AUDIT_PARAMETERS 28

/* Security audit parameter flags */
#define SE_ADT_PARAMETERS_SELF_RELATIVE     0x00000001L
#define SE_ADT_PARAMETERS_SEND_TO_LSA       0x00000002L
#define SE_ADT_PARAMETER_EXTENSIBLE_AUDIT   0x00000004L
#define SE_ADT_PARAMETER_GENERIC_AUDIT      0x00000008L
#define SE_ADT_PARAMETER_WRITE_SYNCHRONOUS  0x00000010L

/* Policy audit event flags */
#define POLICY_AUDIT_EVENT_UNCHANGED    0x00000000L
#define POLICY_AUDIT_EVENT_SUCCESS      0x00000001L
#define POLICY_AUDIT_EVENT_FAILURE      0x00000002L
#define POLICY_AUDIT_EVENT_NONE         0x00000004L
#define POLICY_AUDIT_EVENT_MASK \
    (POLICY_AUDIT_EVENT_UNCHANGED | POLICY_AUDIT_EVENT_SUCCESS | \
    POLICY_AUDIT_EVENT_FAILURE | POLICY_AUDIT_EVENT_NONE)

/* Macro to test for success of an LSA function */
#define LSA_SUCCESS( x )    ((LONG)(x) >= 0)

/* Policy access rights */
#define POLICY_VIEW_LOCAL_INFORMATION   0x0001L
#define POLICY_VIEW_AUDIT_INFORMATION   0x0002L
#define POLICY_GET_PRIVATE_INFORMATION  0x0004L
#define POLICY_TRUST_ADMIN              0x0008L
#define POLICY_CREATE_ACCOUNT           0x0010L
#define POLICY_CREATE_SECRET            0x0020L
#define POLICY_CREATE_PRIVILEGE         0x0040L
#define POLICY_SET_DEFAULT_QUOTA_LIMITS 0x0080L
#define POLICY_SET_AUDIT_REQUIREMENTS   0x0100L
#define POLICY_AUDIT_LOG_ADMIN          0x0200L
#define POLICY_SERVER_ADMIN             0x0400L
#define POLICY_LOOKUP_NAMES             0x0800L
#define POLICY_NOTIFICATION             0x1000L
#define POLICY_ALL_ACCESS \
    (STANDARD_RIGHTS_REQUIRED | POLICY_VIEW_LOCAL_INFORMATION | \
    POLICY_VIEW_AUDIT_INFORMATION | POLICY_GET_PRIVATE_INFORMATION | \
    POLICY_TRUST_ADMIN | POLICY_CREATE_ACCOUNT | POLICY_CREATE_SECRET | \
    POLICY_CREATE_PRIVILEGE | POLICY_SET_DEFAULT_QUOTA_LIMITS | \
    POLICY_SET_AUDIT_REQUIREMENTS | POLICY_AUDIT_LOG_ADMIN | POLICY_SERVER_ADMIN | \
    POLICY_LOOKUP_NAMES)
#define POLICY_READ \
    (STANDARD_RIGHTS_READ | POLICY_VIEW_AUDIT_INFORMATION | \
    POLICY_GET_PRIVATE_INFORMATION)
#define POLICY_WRITE \
    (STANDARD_RIGHTS_WRITE | POLICY_TRUST_ADMIN | POLICY_CREATE_ACCOUNT | \
    POLICY_CREATE_SECRET | POLICY_CREATE_PRIVILEGE | POLICY_SET_DEFAULT_QUOTA_LIMITS | \
    POLICY_SET_AUDIT_REQUIREMENTS | POLICY_AUDIT_LOG_ADMIN | POLICY_SERVER_ADMIN)
#define POLICY_EXECUTE \
    (STANDARD_RIGHTS_EXECUTE | POLICY_VIEW_LOCAL_INFORMATION | POLICY_LOOKUP_NAMES)

/* Per user audit policy flags */
#define PER_USER_POLICY_UNCHANGED       0x00
#define PER_USER_AUDIT_SUCCESS_INCLUDE  0x01
#define PER_USER_AUDIT_SUCCESS_EXCLUDE  0x02
#define PER_USER_AUDIT_FAILURE_INCLUDE  0x04
#define PER_USER_AUDIT_FAILURE_EXCLUDE  0x08
#define PER_USER_AUDIT_NONE             0x10
#define VALID_PER_USER_AUDIT_POLICY_FLAG \
    (PER_USER_AUDIT_SUCCESS_INCLUDE | PER_USER_AUDIT_SUCCESS_EXCLUDE | \
    PER_USER_AUDIT_FAILURE_INCLUDE | PER_USER_AUDIT_FAILURE_EXCLUDE | \
    PER_USER_AUDIT_NONE)

/* Policy quality of service flags */
#if (_WIN32_WINNT < 0x0502)
    #define POLICY_QOS_SCHANNEL_REQUIRED            0x00000001L
    #define POLICY_QOS_OUTBOUND_INTEGRITY           0x00000002L
    #define POLICY_QOS_OUTBOUND_CONFIDENTIALITY     0x00000004L
    #define POLICY_QOS_INBOUND_INTEGRITY            0x00000008L
    #define POLICY_QOS_INBOUND_CONFIDENTIALITY      0x00000010L
    #define POLICY_QOS_ALLOW_LOCAL_ROOT_CERT_STORE  0x00000020L
    #define POLICY_QOS_RAS_SERVER_ALLOWED           0x00000040L
    #define POLICY_QOS_DHCP_SERVER_ALLOWED          0x00000080L
#endif

/* Policy Kerberos flags */
#define POLICY_KERBEROS_VALIDATE_CLIENT 0x00000080L

/* Trust directions */
#define TRUST_DIRECTION_DISABLED        0x00000000L
#define TRUST_DIRECTION_INBOUND         0x00000001L
#define TRUST_DIRECTION_OUTBOUND        0x00000002L
#define TRUST_DIRECTION_BIDIRECTIONAL \
    (TRUST_DIRECTION_INBOUND | TRUST_DIRECTION_OUTBOUND)

/* Trust types */
#define TRUST_TYPE_DOWNLEVEL    0x00000001L
#define TRUST_TYPE_UPLEVEL      0x00000002L
#define TRUST_TYPE_MIT          0x00000003L
#if (_WIN32_WINNT < 0x0502)
    #define TRUST_TYPE_DCE      0x00000004L
#endif

/* Trust attributes */
#define TRUST_ATTRIBUTE_NON_TRANSITIVE                  0x00000001L
#define TRUST_ATTRIBUTE_UPLEVEL_ONLY                    0x00000002L
#if (_WIN32_WINNT == 0x0500)
    #define TRUST_ATTRIBUTE_TREE_PARENT                 0x00400000L
    #define TRUST_ATTRIBUTE_TREE_ROOT                   0x00800000L
    #define TRUST_ATTRIBUTES_VALID                      0xFF02FFFFL
#endif
#if (_WIN32_WINNT >= 0x0502)
    #define TRUST_ATTRIBUTE_QUARANTINED_DOMAIN          0x00000004L
#else
    #define TRUST_ATTRIBUTE_FILTER_SIDS                 0x00000004L
#endif
#if (_WIN32_WINNT >= 0x0501)
    #define TRUST_ATTRIBUTE_FOREST_TRANSITIVE           0x00000008L
#endif
#if (_WIN32_WINNT >= 0x0502)
    #define TRUST_ATTRIBUTE_CROSS_ORGANIZATION          0x00000010L
    #define TRUST_ATTRIBUTE_WITHIN_FOREST               0x00000020L
    #define TRUST_ATTRIBUTE_TREAT_AS_EXTERNAL           0x00000040L
#endif
#if (_WIN32_WINNT >= 0x0600)
    #define TRUST_ATTRIBUTE_TRUST_USES_RC4_ENCRYPTION   0x00000080L
    #define TRUST_ATTRIBUTE_TRUST_USES_AES_KEYS         0x00000100L
#endif
#if (_WIN32_WINNT >= 0x0501)
    #define TRUST_ATTRIBUTES_VALID                      0xFF03FFFFL
#endif
#define TRUST_ATTRIBUTES_USED                           0xFF000000L

/* Trust authentication types */
#define TRUST_AUTH_TYPE_NONE    0L
#define TRUST_AUTH_TYPE_NT4OWF  1L
#define TRUST_AUTH_TYPE_CLEAR   2L
#define TRUST_AUTH_TYPE_VERSION 3L

/* LSA forest trust record type special value */
#if (_WIN32_WINNT < 0x0502)
    #define LSA_FOREST_TRUST_RECORD_TYPE_UNRECOGNIZED   0x80000000L
#endif

/* LSA forest trust record disabled reasons */
#define LSA_FTRECORD_DISABLED_REASONS   0x0000FFFFL

/* LSA top-level name disabled reasons */
#define LSA_TLN_DISABLED_NEW        0x00000001L
#define LSA_TLN_DISABLED_ADMIN      0x00000002L
#define LSA_TLN_DISABLED_CONFLICT   0x00000004L

/* LSA domain information forest disabled reasons */
#define LSA_SID_DISABLED_ADMIN      0x00000001L
#define LSA_SID_DISABLED_CONFLICT   0x00000002L
#define LSA_NB_DISABLED_ADMIN       0x00000004L
#define LSA_NB_DISABLED_CONFLICT    0x00000008L

/* Maximum forest trust binary data size */
#if (_WIN32_WINNT >= 0x0502)
    #define MAX_FOREST_TRUST_BINARY_DATA_SIZE   131072
#endif

/* Maximum records in forest trust information */
#if (_WIN32_WINNT >= 0x0502)
    #define MAX_RECORDS_IN_FOREST_TRUST_INFO    4000
#endif

/* Privilege names */
#define SE_INTERACTIVE_LOGON_NAME                   TEXT("SeInteractiveLogonRight")
#define SE_NETWORK_LOGON_NAME                       TEXT("SeNetworkLogonRight")
#define SE_BATCH_LOGON_NAME                         TEXT("SeBatchLogonRight")
#define SE_SERVICE_LOGON_NAME                       TEXT("SeServiceLogonRight")
#define SE_DENY_INTERACTIVE_LOGON_NAME              TEXT("SeDenyInteractiveLogonRight")
#define SE_DENY_NETWORK_LOGON_NAME                  TEXT("SeDenyNetworkLogonRight")
#define SE_DENY_BATCH_LOGON_NAME                    TEXT("SeDenyBatchLogonRight")
#define SE_DENY_SERVICE_LOGON_NAME                  TEXT("SeDenyServiceLogonRight")
#if (_WIN32_WINNT >= 0x0501)
    #define SE_REMOTE_INTERACTIVE_LOGON_NAME        TEXT("SeRemoteInteractiveLogonRight")
    #define SE_DENY_REMOTE_INTERACTIVE_LOGON_NAME   TEXT("SeDenyRemoteInteractiveLogonRight")
#endif

/* Negotiate maximum prefix lengths */
#define NEGOTIATE_MAX_PREFIX    32

/* Password properties flags */
#if (_WIN32_WINNT >= 0x0501)
    #define DOMAIN_PASSWORD_COMPLEX         0x00000001L
    #define DOMAIN_PASSWORD_NO_ANON_CHANGE  0x00000002L
    #define DOMAIN_PASSWORD_NO_CLEAR_CHANGE 0x00000004L
    #define DOMAIN_LOCKOUT_ADMINS           0x00000008L
    #define DOMAIN_PASSWORD_STORE_CLEARTEXT 0x00000010L
    #define DOMAIN_REFUSE_PASSWORD_CHANGE   0x00000020L
#endif
#if (_WIN32_WINNT >= 0x0502)
    #define DOMAIN_NO_LM_OWF_CHANGE         0x00000040L
#endif

/* SAM callback names */
#define SAM_PASSWORD_CHANGE_NOTIFY_ROUTINE  "PasswordChangeNotify"
#define SAM_INIT_NOTIFICATION_ROUTINE       "InitializeChangeNotify"
#define SAM_PASSWORD_FILTER_ROUTINE         "PasswordFilter"

/* MSV1.0 constants */
#define MSV1_0_PACKAGE_NAME             "MICROSOFT_AUTHENTICATION_PACKAGE_V1_0"
#define MSV1_0_PACKAGE_NAMEW            L"MICROSOFT_AUTHENTICATION_PACKAGE_V1_0"
#define MSV1_0_PACKAGE_NAMEW_LENGTH \
    (sizeof( MSV1_0_PACKAGE_NAMEW ) - sizeof( WCHAR ))
#define MSV1_0_SUBAUTHENTICATION_KEY \
    "SYSTEM\\CurrentControlSet\\Control\\Lsa\\MSV1_0"
#define MSV1_0_SUBAUTHENTICATION_VALUE  "Auth"

/* MSV1.0 string lengths */
#define MSV1_0_CHALLENGE_LENGTH             8
#define MSV1_0_USER_SESSION_KEY_LENGTH      16
#define MSV1_0_LANMAN_SESSION_KEY_LENGTH    8

/* MSV1.0 parameter control flags */
#define MSV1_0_CLEARTEXT_PASSWORD_ALLOWED       0x00000002L
#define MSV1_0_UPDATE_LOGON_STATISTICS          0x00000004L
#define MSV1_0_RETURN_USER_PARAMETERS           0x00000008L
#define MSV1_0_DONT_TRY_GUEST_ACCOUNT           0x00000010L
#define MSV1_0_ALLOW_SERVER_TRUST_ACCOUNT       0x00000020L
#define MSV1_0_RETURN_PASSWORD_EXPIRY           0x00000040L
#define MSV1_0_USE_CLIENT_CHALLENGE             0x00000080L
#define MSV1_0_TRY_GUEST_ACCOUNT_ONLY           0x00000100L
#define MSV1_0_RETURN_PROFILE_PATH              0x00000200L
#define MSV1_0_TRY_SPECIFIED_DOMAIN_ONLY        0x00000400L
#define MSV1_0_ALLOW_WORKSTATION_TRUST_ACCOUNT  0x00000800L
#define MSV1_0_DISABLE_PERSONAL_FALLBACK        0x00001000L
#define MSV1_0_ALLOW_FORCE_GUEST                0x00002000L
#if (_WIN32_WINNT >= 0x0502)
    #define MSV1_0_CLEARTEXT_PASSWORD_SUPPLIED  0x00004000L
    #define MSV1_0_USE_DOMAIN_FOR_ROUTING_ONLY  0x00008000L
#endif
#define MSV1_0_ALLOW_MSVCHAPV2                  0x00010000L
#if (_WIN32_WINNT >= 0x0600)
    #define MSV1_0_S4U2SELF                     0x00020000L
    #define MSV1_0_CHECK_LOGONHOURS_FOR_S4U     0x00040000L
#endif
#define MSV1_0_SUBAUTHENTICATION_DLL_EX         0x00100000L
#define MSV1_0_SUBAUTHENTICATION_DLL            0xFF000000L
#define MSV1_0_SUBAUTHENTICATION_DLL_SHIFT      24
#define MSV1_0_MNS_LOGON                        0x01000000L

/* MSV1.0 subauthentication DLL values */
#define MSV1_0_SUBAUTHENTICATION_DLL_RAS    2
#define MSV1_0_SUBAUTHENTICATION_DLL_IIS    132

/* MSV1.0 S4U logon flags */
#if (_WIN32_WINNT >= 0x0600)
    #define MSV1_0_S4U_LOGON_FLAG_CHECK_LOGONHOURS  0x00000002L
#endif

/* Logon user flags */
#define LOGON_USER                      0x00000001L
#define LOGON_NOENCRYPTION              0x00000002L
#define LOGON_CACHED_ACCOUNT            0x00000004L
#define LOGON_USED_LM_PASSWORD          0x00000008L
#define LOGON_EXTRA_SIDS                0x00000020L
#define LOGON_SUBAUTH_SESSION_KEY       0x00000040L
#define LOGON_SERVER_TRUST_ACCOUNT      0x00000080L
#define LOGON_NTLMV2_ENABLED            0x00000100L
#define LOGON_RESOURCE_GROUPS           0x00000200L
#define LOGON_PROFILE_PATH_RETURNED     0x00000400L
#define LOGON_NT_V2                     0x00000800L
#define LOGON_LM_V2                     0x00001000L
#define LOGON_NTLM_V2                   0x00002000L
#if (_WIN32_WINNT >= 0x0600)
    #define LOGON_OPTIMIZED             0x00004000L
    #define LOGON_WINLOGON              0x00008000L
    #define LOGON_PKINIT                0x00010000L
    #define LOGON_NO_OPTIMIZED          0x00020000L
#endif
#define MSV1_0_SUBAUTHENTICATION_FLAGS  0xFF000000L
#define LOGON_GRACE_LOGON               0x01000000L

/* MSV1.0 supplemental credential constants */
#define MSV1_0_OWF_PASSWORD_LENGTH  16
#define MSV1_0_CRED_LM_PRESENT      0x00000001L
#define MSV1_0_CRED_NT_PRESENT      0x00000002L
#define MSV1_0_CRED_VERSION         0L

/* MSV1.0 NTLM3 constants */
#define MSV1_0_NTLM3_RESPONSE_LENGTH    16
#define MSV1_0_NTLM3_OWF_LENGTH         16
#if (_WIN32_WINNT == 0x0500)
    #define MSV1_0_MAX_NTLM3_LIFE       1800
#else
    #define MSV1_0_MAX_NTLM3_LIFE       129600
#endif
#define MSV1_0_MAX_AVL_SIZE             64000

/* MSV1.0 AV flags */
#if (_WIN32_WINNT >= 0x0501)
    #define MSV1_0_AV_FLAG_FORCE_GUEST              0x00000001L
#endif
#if (_WIN32_WINNT >= 0x0600)
    #define MSV1_0_AV_FLAG_MIC_HANDSHAKE_MESSAGES   0x00000002L
#endif

/* RtlEncryptMemory() buffer size */
#define RTL_ENCRYPT_MEMORY_SIZE 8

/* RtlEncryptMemory() option flags */
#define RTL_ENCRYPT_OPTION_CROSS_PROCESS    0x00000001L
#define RTL_ENCRYPT_OPTION_SAME_LOGON       0x00000002L

/* Kerberos version numbers */
#define KERBEROS_VERSION    5
#define KERBEROS_REVISION   6

/* Kerberos encryption types */
#define KERB_ETYPE_NULL                             0
#define KERB_ETYPE_DES_CBC_CRC                      1
#define KERB_ETYPE_DES_CBC_MD4                      2
#define KERB_ETYPE_DES_CBC_MD5                      3
#define KERB_ETYPE_AES128_CTS_HMAC_SHA1_96          17
#define KERB_ETYPE_AES256_CTS_HMAC_SHA1_96          18
#define KERB_ETYPE_RC4_MD4                          (-128)
#define KERB_ETYPE_RC4_PLAIN2                       (-129)
#define KERB_ETYPE_RC4_LM                           (-130)
#define KERB_ETYPE_RC4_SHA                          (-131)
#define KERB_ETYPE_DES_PLAIN                        (-132)
#define KERB_ETYPE_RC4_HMAC_OLD                     (-133)
#define KERB_ETYPE_RC4_PLAIN_OLD                    (-134)
#define KERB_ETYPE_RC4_HMAC_OLD_EXP                 (-135)
#define KERB_ETYPE_RC4_PLAIN_OLD_EXP                (-136)
#define KERB_ETYPE_RC4_PLAIN                        (-140)
#define KERB_ETYPE_RC4_PLAIN_EXP                    (-141)
#define KERB_ETYPE_AES128_CTS_HMAC_SHA1_96_PLAIN    (-148)
#define KERB_ETYPE_AES256_CTS_HMAC_SHA1_96_PLAIN    (-149)
#define KERB_ETYPE_DSA_SHA1_CMS                     9
#define KERB_ETYPE_RSA_MD5_CMS                      10
#define KERB_ETYPE_RSA_SHA1_CMS                     11
#define KERB_ETYPE_RC2_CBC_ENV                      12
#define KERB_ETYPE_RSA_ENV                          13
#define KERB_ETYPE_RSA_ES_OEAP_ENV                  14
#define KERB_ETYPE_DES_EDE3_CBC_ENV                 15
#define KERB_ETYPE_DSA_SIGN                         8
#define KERB_ETYPE_RSA_PRIV                         9
#define KERB_ETYPE_RSA_PUB                          10
#define KERB_ETYPE_RSA_PUB_MD5                      11
#define KERB_ETYPE_RSA_PUB_SHA1                     12
#define KERB_ETYPE_PKCS7_PUB                        13
#if (_WIN32_WINNT >= 0x0502)
    #define KERB_ETYPE_DES3_CBC_MD5                 5
    #define KERB_ETYPE_DES3_CBC_SHA                 7
    #define KERB_ETYPE_DES3_CBC_SHA1_KD             16
#endif
#define KERB_ETYPE_DES_CBC_MD5_NT                   20
#define KERB_ETYPE_RC4_HMAC_NT                      23
#define KERB_ETYPE_RC4_HMAC_NT_EXP                  24

/* Kerberos checksum algorithms */
#define KERB_CHECKSUM_NONE                      0
#define KERB_CHECKSUM_CRC32                     1
#define KERB_CHECKSUM_MD4                       2
#define KERB_CHECKSUM_KRB_DES_MAC               4
#if (_WIN32_WINNT >= 0x0501)
    #define KERB_CHECKSUM_KRB_DES_MAC_K         5
#endif
#define KERB_CHECKSUM_MD5                       7
#define KERB_CHECKSUM_MD5_DES                   8
#define KERB_CHECKSUM_SHA1_NEW                  14
#define KERB_CHECKSUM_HMAC_SHA1_96_AES128       15
#define KERB_CHECKSUM_HMAC_SHA1_96_AES256       16
#define KERB_CHECKSUM_LM                        (-130)
#define KERB_CHECKSUM_SHA1                      (-131)
#define KERB_CHECKSUM_REAL_CRC32                (-132)
#define KERB_CHECKSUM_DES_MAC                   (-133)
#define KERB_CHECKSUM_DES_MAC_MD5               (-134)
#define KERB_CHECKSUM_MD25                      (-135)
#define KERB_CHECKSUM_RC4_MD5                   (-136)
#define KERB_CHECKSUM_MD5_HMAC                  (-137)
#define KERB_CHECKSUM_HMAC_MD5                  (-138)
#define KERB_CHECKSUM_HMAC_SHA1_96_AES128_Ki    (-150)
#define KERB_CHECKSUM_HMAC_SHA1_96_AES256_Ki    (-151)

/* Authentication requirement flags */
#define AUTH_REQ_ALLOW_FORWARDABLE      0x00000001L
#define AUTH_REQ_ALLOW_PROXIABLE        0x00000002L
#define AUTH_REQ_ALLOW_POSTDATE         0x00000004L
#define AUTH_REQ_ALLOW_RENEWABLE        0x00000008L
#define AUTH_REQ_ALLOW_NOADDRESS        0x00000010L
#define AUTH_REQ_ALLOW_ENC_TKT_IN_SKEY  0x00000020L
#define AUTH_REQ_ALLOW_VALIDATE         0x00000040L
#define AUTH_REQ_VALIDATE_CLIENT        0x00000080L
#define AUTH_REQ_OK_AS_DELEGATE         0x00000100L
#define AUTH_REQ_PREAUTH_REQUIRED       0x00000200L
#define AUTH_REQ_TRANSITIVE_TRUST       0x00000400L
#if (_WIN32_WINNT >= 0x0502)
    #define AUTH_REQ_ALLOW_S4U_DELEGATE 0x00000800L
#endif
#define AUTH_REQ_PER_USER_FLAGS \
    (AUTH_REQ_ALLOW_FORWARDABLE | AUTH_REQ_ALLOW_PROXIABLE | AUTH_REQ_ALLOW_POSTDATE | \
    AUTH_REQ_ALLOW_RENEWABLE | AUTH_REQ_ALLOW_VALIDATE)

/* Kerberos ticket flags */
#define KERB_TICKET_FLAGS_reserved              0x80000000L
#define KERB_TICKET_FLAGS_forwardable           0x40000000L
#define KERB_TICKET_FLAGS_forwarded             0x20000000L
#define KERB_TICKET_FLAGS_proxiable             0x10000000L
#define KERB_TICKET_FLAGS_proxy                 0x08000000L
#define KERB_TICKET_FLAGS_may_postdate          0x04000000L
#define KERB_TICKET_FLAGS_postdated             0x02000000L
#define KERB_TICKET_FLAGS_invalid               0x01000000L
#define KERB_TICKET_FLAGS_renewable             0x00800000L
#define KERB_TICKET_FLAGS_initial               0x00400000L
#define KERB_TICKET_FLAGS_pre_authent           0x00200000L
#define KERB_TICKET_FLAGS_hw_authent            0x00100000L
#define KERB_TICKET_FLAGS_ok_as_delegate        0x00040000L
#define KERB_TICKET_FLAGS_name_canonicalize     0x00010000L
#if (_WIN32_WINNT == 0x0501)
    #define KERB_TICKET_FLAGS_cname_in_pa_data  0x00040000L
#endif

/* Kerberos name types */
#if (_WIN32_WINNT >= 0x0501)
    #define KRB_NT_UNKNOWN              0
    #define KRB_NT_PRINCIPAL            1
    #define KRB_NT_PRINCIPAL_AND_ID     (-131)
    #define KRB_NT_SRV_INST             2
    #define KRB_NT_SRV_INST_AND_ID      (-132)
    #define KRB_NT_SRV_HST              3
    #define KRB_NT_SRV_XHST             4
    #define KRB_NT_UID                  5
    #define KRB_NT_ENTERPRISE_PRINCIPAL 10
    #define KRB_NT_ENT_PRINCIPAL_AND_ID (-130)
    #define KRB_NT_MS_PRINCIPAL         (-128)
    #define KRB_NT_MS_PRINCIPAL_AND_ID  (-129)
    #define KRB_NT_MS_BRANCH_ID         (-133)
#endif
#if (_WIN32_WINNT >= 0x0600)
    #define KRB_NT_X500_PRINCIPAL       6
#endif

/* Macro to test for Microsoft principal name types */
#if (_WIN32_WINNT >= 0x0501)
    #define KERB_IS_MS_PRINCIPAL( x ) \
        (((x) <= KRB_NT_MS_PRINCIPAL) || ((x) >= KRB_NT_ENTERPRISE_PRINCIPAL))
#endif

/* Microsoft Kerberos name */
#ifndef MICROSOFT_KERBEROS_NAME_A
    #define MICROSOFT_KERBEROS_NAME_A   "Kerberos"
    #define MICROSOFT_KERBEROS_NAME_W   L"Kerberos"
    #define MICROSOFT_KERBEROS_NAME     MICROSOFT_KERBEROS_NAMEW
#endif

/* EncryptMessage() flags */
#define KERB_WRAP_NO_ENCRYPT    0x80000001L

/* Kerberos certificate logon flags */
#if (_WIN32_WINNT >= 0x0600)
    #define KERB_CERTIFICATE_LOGON_FLAG_CHECK_DUPLICATES    0x00000001L
#endif

/* Kerberos certificate S4U logon flags */
#if (_WIN32_WINNT >= 0x0600)
    #define KERB_CERTIFICATE_S4U_LOGON_FLAG_CHECK_DUPLICATES                0x00000001L
    #define KERB_CERTIFICATE_S4U_LOGON_FLAG_CHECK_LOGONHOURS                0x00000002L
    #define KERB_CERTIFICATE_S4U_LOGON_FLAG_FAIL_IF_NT_AUTH_POLICY_REQUIRED 0x00000004L
#endif

/* Kerberos ticket logon flags */
#define KERB_LOGON_FLAG_ALLOW_EXPIRED_TICKET    0x00000001L

/* Kerberos S4U logon flags */
#if (_WIN32_WINNT >= 0x0600)
    #define KERB_S4U_LOGON_FLAG_CHECK_LOGONHOURS    0x00000002L
#endif

/* Kerberos ticket flags */
#if (_WIN32_WINNT >= 0x0501)
    #define KERB_USE_DEFAULT_TICKET_FLAGS   0x00000000L
#endif

/* Kerberos cache options */
#if (_WIN32_WINNT >= 0x0501)
    #define KERB_RETRIEVE_TICKET_DEFAULT        0x00000000L
#endif
#define KERB_RETRIEVE_TICKET_DONT_USE_CACHE     0x00000001L
#define KERB_RETRIEVE_TICKET_USE_CACHE_ONLY     0x00000002L
#define KERB_RETRIEVE_TICKET_USE_CREDHANDLE     0x00000004L
#if (_WIN32_WINNT >= 0x0501)
    #define KERB_RETRIEVE_TICKET_AS_KERB_CRED   0x00000008L
    #define KERB_RETRIEVE_TICKET_WITH_SEC_CRED  0x00000010L
#endif
#if (_WIN32_WINNT >= 0x0600)
    #define KERB_RETRIEVE_TICKET_CACHE_TICKET   0x00000020L
#endif
#if (_WIN32_WINNT >= 0x0601)
    #define KERB_RETRIEVE_TICKET_MAX_LIFETIME   0x00000040L
#endif

/* Kerberos encryption type options */
#if (_WIN32_WINNT >= 0x0501)
    #define KERB_ETYPE_DEFAULT  0x00000000L
#endif

/* Kerberos purge ticket request flags */
#if (_WIN32_WINNT >= 0x0501)
    #define KERB_PURGE_ALL_TICKETS  1
#endif

/* Kerberos set password request flags */
#define DS_UNKNOWN_ADDRESS_TYPE     0L
#define KERB_SETPASS_USE_LOGONID    1L
#define KERB_SETPASS_USE_CREDHANDLE 2L

/* Kerberos decrypt request flags */
#define KERB_DECRYPT_FLAG_DEFAULT_KEY   0x00000001L

/* Kerberos refresh smart card credentials request flags */
#if (_WIN32_WINNT >= 0x0502)
    #define KERB_REFRESH_SCCRED_RELEASE 0x00000000L
    #define KERB_REFRESH_SCCRED_GETTGT  0x00000001L
#endif

/* Kerberos add credentials request flags */
#if (_WIN32_WINNT != 0x0501)
    #define KERB_REQUEST_ADD_CREDENTIAL     1L
    #define KERB_REQUEST_REPLACE_CREDENTIAL 2L
    #define KERB_REQUEST_REMOVE_CREDENTIAL  4L
#endif

/* Kerberos transfer credentials request flags */
#define KERB_TRANSFER_CRED_WITH_TICKETS 0x00000001L

/* Audit access rights */
#define AUDIT_SET_SYSTEM_POLICY     0x0001L
#define AUDIT_QUERY_SYSTEM_POLICY   0x0002L
#define AUDIT_SET_USER_POLICY       0x0004L
#define AUDIT_QUERY_USER_POLICY     0x0008L
#define AUDIT_ENUMERATE_USERS       0x0010L
#define AUDIT_SET_MISC_POLICY       0x0020L
#define AUDIT_QUERY_MISC_POLICY     0x0040L
#define AUDIT_GENERIC_READ \
    (STANDARD_RIGHTS_READ | AUDIT_QUERY_SYSTEM_POLICY | AUDIT_QUERY_USER_POLICY | \
    AUDIT_ENUMERATE_USERS | AUDIT_QUERY_MISC_POLICY)
#define AUDIT_GENERIC_WRITE \
    (STANDARD_RIGHTS_WRITE | AUDIT_SET_USER_POLICY | AUDIT_SET_MISC_POLICY | \
    AUDIT_SET_SYSTEM_POLICY)
#define AUDIT_GENERIC_EXECUTE       STANDARD_RIGHTS_EXECUTE
#define AUDIT_GENERIC_ALL \
    (STANDARD_RIGHTS_REQUIRED | AUDIT_SET_SYSTEM_POLICY | AUDIT_QUERY_SYSTEM_POLICY | \
    AUDIT_SET_USER_POLICY | AUDIT_QUERY_USER_POLICY | AUDIT_ENUMERATE_USERS | \
    AUDIT_SET_MISC_POLICY | AUDIT_QUERY_MISC_POLICY)

/* PKU2U constants */
#if (_WIN32_WINNT >= 0x0601)
    #define PKU2U_PACKAGE_NAME_A            "pku2u"
    #define PKU2U_PACKAGE_NAME              L"pku2u"
    #define PKU2U_PACKAGE_NAME_W            PKU2U_PACKAGE_NAME
    #define PKU2U_CREDUI_CONTEXT_VERSION    0x4154414454524543
#endif

/* Security logon types */
typedef enum _SECURITY_LOGON_TYPE {
    UndefinedLogonType      = 0,
    Interactive             = 2,
    Network                 = 3,
    Batch                   = 4,
    Service                 = 5,
    Proxy                   = 6,
    Unlock                  = 7,
    NetworkCleartxt         = 8,
#if (_WIN32_WINNT >= 0x0501)
    NewCredentials          = 9,
    RemoteInteractive       = 10,
#if (_WIN32_WINNT >= 0x0502)
    CachedInteractive       = 11,
    CachedRemoteInteractive = 12,
    CachedUnlock            = 13,
#else
    CachedInteractive       = 11
#endif
#else
    NewCredentials          = 9
#endif
} SECURITY_LOGON_TYPE;
typedef SECURITY_LOGON_TYPE *PSECURITY_LOGON_TYPE;

/* Security audit parameter types */
typedef enum _SE_ADT_PARAMETER_TYPE {
    SeAdtParmTypeNone               = 0,
    SeAdtParmTypeString             = 1,
    SeAdtParmTypeFileSpec           = 2,
    SeAdtParmTypeUlong              = 3,
    SeAdtParmTypeSid                = 4,
    SeAdtParmTypeLogonId            = 5,
    SeAdtParmTypeNoLogonId          = 6,
    SeAdtParmTypeAccessMask         = 7,
    SeAdtParmTypePrivs              = 8,
    SeAdtParmTypeObjectTypes        = 9,
    SeAdtParmTypeHexUlong           = 10,
    SeAdtParmTypePtr                = 11,
    SeAdtParmTypeTime               = 12,
    SeAdtParmTypeGuid               = 13,
    SeAdtParmTypeLuid               = 14,
    SeAdtParmTypeHexInt64           = 15,
    SeAdtParmTypeStringList         = 16,
    SeAdtParmTypeSidList            = 17,
    SeAdtParmTypeDuration           = 18,
    SeAdtParmTypeUserAccountControl = 19,
    SeAdtParmTypeNoUac              = 20,
    SeAdtParmTypeMessage            = 21,
    SeAdtParmTypeDateTime           = 22,
    SeAdtParmTypeSockAddr           = 23,
    SeAdtParmTypeSD                 = 24,
    SeAdtParmTypeLogonHours         = 25,
    SeAdtParmTypeLogonIdNoSid       = 26,
    SeAdtParmTypeUlongNoConv        = 27,
    SeAdtParmTypeSockAddrNoPort     = 28,
    SeAdtParmTypeAccessReason       = 29
} SE_ADT_PARAMETER_TYPE;
typedef SE_ADT_PARAMETER_TYPE   *PSE_ADT_PARAMETER_TYPE;

/* Security audit object type */
typedef struct _SE_ADT_OBJECT_TYPE {
    GUID        ObjectType;
    USHORT      Flags;
    USHORT      Level;
    ACCESS_MASK AccessMask;
} SE_ADT_OBJECT_TYPE;
typedef SE_ADT_OBJECT_TYPE  *PSE_ADT_OBJECT_TYPE;

/* Security audit parameter array entry */
typedef struct _SE_ADT_PARAMETER_ARRAY_ENTRY {
    SE_ADT_PARAMETER_TYPE   Type;
    ULONG                   Length;
    ULONG_PTR               Data[2];
    PVOID                   Address;
} SE_ADT_PARAMETER_ARRAY_ENTRY;
typedef SE_ADT_PARAMETER_ARRAY_ENTRY    *PSE_ADT_PARAMETER_ARRAY_ENTRY;

/* Security audit access reason */
typedef struct _SE_ADT_ACCESS_REASON {
    ACCESS_MASK             AccessMask;
    ULONG                   AccessReasons[32];
    ULONG                   ObjectTypeIndex;
    ULONG                   AccessGranted;
    PSECURITY_DESCRIPTOR    SecurityDescriptor;
} SE_ADT_ACCESS_REASON;
typedef SE_ADT_ACCESS_REASON    *PSE_ADT_ACCESS_REASON;

/* Security audit parameter array */
typedef struct _SE_ADT_PARAMETER_ARRAY {
    ULONG                           CategoryId;
    ULONG                           AuditId;
    ULONG                           ParameterCount;
    ULONG                           Length;
    USHORT                          FlatSubCategoryId;
    USHORT                          Type;
    ULONG                           Flags;
    SE_ADT_PARAMETER_ARRAY_ENTRY    Parameters[SE_MAX_AUDIT_PARAMETERS];
} SE_ADT_PARAMETER_ARRAY;
typedef SE_ADT_PARAMETER_ARRAY  *PSE_ADT_PARAMETER_ARRAY;

/* Policy audit event types */
typedef enum _POLICY_AUDIT_EVENT_TYPE {
    AuditCategorySystem                 = 0,
    AuditCategoryLogon                  = 1,
    AuditCategoryObjectAccess           = 2,
    AuditCategoryPrivilegeUse           = 3,
    AuditCategoryDetailedTracking       = 4,
    AuditCategoryPolicyChange           = 5,
    AuditCategoryAccountManagement      = 6,
    AuditCategoryDirectoryServiceAccess = 7,
    AuditCategoryAccountLogon           = 8
} POLICY_AUDIT_EVENT_TYPE;
typedef POLICY_AUDIT_EVENT_TYPE *PPOLICY_AUDIT_EVENT_TYPE;

/* LSA Unicode string */
#ifdef _NTDEF_
typedef UNICODE_STRING      LSA_UNICODE_STRING;
#else
typedef struct _LSA_UNICODE_STRING {
    USHORT  Length;
    USHORT  MaximumLength;
    PWSTR   Buffer;
} LSA_UNICODE_STRING;
#endif
typedef LSA_UNICODE_STRING  *PLSA_UNICODE_STRING;
#ifndef _NTDEF_
typedef LSA_UNICODE_STRING  UNICODE_STRING;
typedef LSA_UNICODE_STRING  *PUNICODE_STRING;
#endif

/* LSA string */
#ifdef _NTDEF_
typedef STRING      LSA_STRING;
#else
typedef struct _LSA_STRING {
    USHORT  Length;
    USHORT  MaximumLength;
    PCHAR   Buffer;
} LSA_STRING;
#endif
typedef LSA_STRING  *PLSA_STRING;
#ifndef _NTDEF_
typedef LSA_STRING  STRING;
typedef LSA_STRING  *PSTRING;
#endif

/* LSA object attributes */
#ifdef _NTDEF_
typedef OBJECT_ATTRIBUTES       LSA_OBJECT_ATTRIBUTES;
#else
typedef struct _LSA_OBJECT_ATTRIBUTES {
    ULONG               Length;
    HANDLE              RootDirectory;
    PLSA_UNICODE_STRING ObjectName;
    ULONG               Attributes;
    PVOID               SecurityDescriptor;
    PVOID               SecurityQualityOfService;
} LSA_OBJECT_ATTRIBUTES;
#endif
typedef LSA_OBJECT_ATTRIBUTES   *PLSA_OBJECT_ATTRIBUTES;

/* LSA trust information */
typedef struct _LSA_TRUST_INFORMATION {
    LSA_UNICODE_STRING  Name;
    PSID                Sid;
} LSA_TRUST_INFORMATION;
typedef LSA_TRUST_INFORMATION   *PLSA_TRUST_INFORMATION;

/* LSA referenced domain list */
typedef struct _LSA_REFERENCED_DOMAIN_LIST {
    ULONG                   Entries;
    PLSA_TRUST_INFORMATION  Domains;
} LSA_REFERENCED_DOMAIN_LIST;
typedef LSA_REFERENCED_DOMAIN_LIST  *PLSA_REFERENCED_DOMAIN_LIST;

/* LSA translated SID */
typedef struct _LSA_TRANSLATED_SID {
    SID_NAME_USE    Use;
    ULONG           RelativeId;
    LONG            DomainIndex;
} LSA_TRANSLATED_SID;
typedef LSA_TRANSLATED_SID  *PLSA_TRANSLATED_SID;

/* LSA translated SID (version 2) */
#if (_WIN32_WINNT >= 0x0501)
typedef struct _LSA_TRANSLATED_SID2 {
    SID_NAME_USE    Use;
    PSID            Sid;
    LONG            DomainIndex;
    ULONG           Flags;
} LSA_TRANSLATED_SID2;
typedef LSA_TRANSLATED_SID2 *PLSA_TRANSLATED_SID2;
#endif

/* LSA translated name */
typedef struct _LSA_TRANSLATED_NAME {
    SID_NAME_USE        Use;
    LSA_UNICODE_STRING  Name;
    LONG                DomainIndex;
} LSA_TRANSLATED_NAME;
typedef LSA_TRANSLATED_NAME *PLSA_TRANSLATED_NAME;

/* Policy LSA server roles */
typedef enum _POLICY_LSA_SERVER_ROLE {
    PolicyServerRoleBackup  = 2,
    PolicyServerRolePrimary = 3
} POLICY_LSA_SERVER_ROLE;
typedef POLICY_LSA_SERVER_ROLE  *PPOLICY_LSA_SERVER_ROLE;

/* Policy server enable states */
#if (_WIN32_WINNT < 0x0502)
typedef enum _POLICY_SERVER_ENABLE_STATE {
    PolicyServerEnabled     = 2,
    PolicyServerDisabled    = 3
} POLICY_SERVER_ENABLE_STATE;
typedef POLICY_SERVER_ENABLE_STATE  *PPOLICY_SERVER_ENABLE_STATE;
#endif

/* Policy information classes */
typedef enum _POLICY_INFORMATION_CLASS {
    PolicyAuditLogInformation           = 1,
    PolicyAuditEventsInformation        = 2,
    PolicyPrimaryDomainInformation      = 3,
    PolicyPdAccountInformation          = 4,
    PolicyAccountDomainInformation      = 5,
    PolicyLsaServerRoleInformation      = 6,
    PolicyReplicaSourceInformation      = 7,
    PolicyDefaultQuotaInformation       = 8,
    PolicyModificationInformation       = 9,
    PolicyAuditFullSetInformation       = 10,
    PolicyAuditFullQueryInformation     = 11,
    PolicyDnsDomainInformation          = 12,
    PolicyDnsDomainInformationInt       = 13,
    PolicyLocalAccountDomainInformation = 14,
    PolicyLastEntry                     = 15
} POLICY_INFORMATION_CLASS;
typedef POLICY_INFORMATION_CLASS    *PPOLICY_INFORMATION_CLASS;

/* Policy audit log information */
typedef struct _POLICY_AUDIT_LOG_INFO {
    ULONG           AuditLogPercentFull;
    ULONG           MaximumLogSize;
    LARGE_INTEGER   AuditRetentionPeriod;
    BOOLEAN         AuditLogFullShutdownInProgress;
    LARGE_INTEGER   TimeToShutdown;
    ULONG           NextAuditRecordId;
} POLICY_AUDIT_LOG_INFO;
typedef POLICY_AUDIT_LOG_INFO   *PPOLICY_AUDIT_LOG_INFO;

/* Policy audit events information */
typedef struct _POLICY_AUDIT_EVENTS_INFO {
    BOOLEAN                     AuditingMode;
    PPOLICY_AUDIT_EVENT_OPTIONS EventAuditingOptions;
    ULONG                       MaximumAuditEventCount;
} POLICY_AUDIT_EVENTS_INFO;
typedef POLICY_AUDIT_EVENTS_INFO    *PPOLICY_AUDIT_EVENTS_INFO;

/* Policy audit subcategories information */
typedef struct _POLICY_AUDIT_SUBCATEGORIES_INFO {
    ULONG                       MaximumSubCategoryCount;
    PPOLICY_AUDIT_EVENT_OPTIONS EventAuditingOptions;
} POLICY_AUDIT_SUBCATEGORIES_INFO;
typedef POLICY_AUDIT_SUBCATEGORIES_INFO *PPOLICY_AUDIT_SUBCATEGORIES_INFO;

/* Policy audit categories information */
typedef struct _POLICY_AUDIT_CATEGORIES_INFO {
    ULONG                               MaximumCategoryCount;
    PPOLICY_AUDIT_SUBCATEGORIES_INFO    SubCategoriesInfo;
} POLICY_AUDIT_CATEGORIES_INFO;
typedef POLICY_AUDIT_CATEGORIES_INFO    *PPOLICY_AUDIT_CATEGORIES_INFO;

/* Policy account domain information */
typedef struct _POLICY_ACCOUNT_DOMAIN_INFO {
    LSA_UNICODE_STRING  DomainName;
    PSID                DomainSid;
} POLICY_ACCOUNT_DOMAIN_INFO;
typedef POLICY_ACCOUNT_DOMAIN_INFO  *PPOLICY_ACCOUNT_DOMAIN_INFO;

/* Policy primary domain information */
typedef struct _POLICY_PRIMARY_DOMAIN_INFO {
    LSA_UNICODE_STRING  Name;
    PSID                Sid;
} POLICY_PRIMARY_DOMAIN_INFO;
typedef POLICY_PRIMARY_DOMAIN_INFO  *PPOLICY_PRIMARY_DOMAIN_INFO;

/* Policy DNS domain information */
typedef struct _POLICY_DNS_DOMAIN_INFO {
    LSA_UNICODE_STRING  Name;
    LSA_UNICODE_STRING  DnsDomainName;
    LSA_UNICODE_STRING  DnsForestName;
    GUID                DomainGuid;
    PSID                Sid;
} POLICY_DNS_DOMAIN_INFO;
typedef POLICY_DNS_DOMAIN_INFO  *PPOLICY_DNS_DOMAIN_INFO;

/* Policy PD account information */
typedef struct _POLICY_PD_ACCOUNT_INFO {
    LSA_UNICODE_STRING  Name;
} POLICY_PD_ACCOUNT_INFO;
typedef POLICY_PD_ACCOUNT_INFO  *PPOLICY_PD_ACCOUNT_INFO;

/* Policy LSA server role information */
typedef struct _POLICY_LSA_SERVER_ROLE_INFO {
    POLICY_LSA_SERVER_ROLE  LsaServerRole;
} POLICY_LSA_SERVER_ROLE_INFO;
typedef POLICY_LSA_SERVER_ROLE_INFO *PPOLICY_LSA_SERVER_ROLE_INFO;

/* Policy replica source information */
typedef struct _POLICY_REPLICA_SOURCE_INFO {
    LSA_UNICODE_STRING  ReplicaSource;
    LSA_UNICODE_STRING  ReplicaAccountName;
} POLICY_REPLICA_SOURCE_INFO;
typedef POLICY_REPLICA_SOURCE_INFO  *PPOLICY_REPLICA_SOURCE_INFO;

/* Policy default quota information */
typedef struct _POLICY_DEFAULT_QUOTA_INFO {
    QUOTA_LIMITS    QuotaLimits;
} POLICY_DEFAULT_QUOTA_INFO;
typedef POLICY_DEFAULT_QUOTA_INFO   *PPOLICY_DEFAULT_QUOTA_INFO;

/* Policy modification information */
typedef struct _POLICY_MODIFICATION_INFO {
    LARGE_INTEGER   ModifiedId;
    LARGE_INTEGER   DatabaseCreationTime;
} POLICY_MODIFICATION_INFO;
typedef POLICY_MODIFICATION_INFO    *PPOLICY_MODIFICATION_INFO;

/* Policy audit full set information */
typedef struct _POLICY_AUDIT_FULL_SET_INFO {
    BOOLEAN ShutDownOnFull;
} POLICY_AUDIT_FULL_SET_INFO;
typedef POLICY_AUDIT_FULL_SET_INFO  *PPOLICY_AUDIT_FULL_SET_INFO;

/* Policy audit full query information */
typedef struct _POLICY_AUDIT_FULL_QUERY_INFO {
    BOOLEAN ShutDownOnFull;
    BOOLEAN LogIsFull;
} POLICY_AUDIT_FULL_QUERY_INFO;
typedef POLICY_AUDIT_FULL_QUERY_INFO    *PPOLICY_AUDIT_FULL_QUERY_INFO;

/* Policy domain information classes */
typedef enum _POLICY_DOMAIN_INFORMATION_CLASS {
#if (_WIN32_WINNT <= 0x0500)
    PolicyDomainQualityOfServiceInformation = 1,
#endif
    PolicyDomainEfsInformation              = 2,
    PolicyDomainKerberosTicketInformation   = 3
} POLICY_DOMAIN_INFORMATION_CLASS;
typedef POLICY_DOMAIN_INFORMATION_CLASS *PPOLICY_DOMAIN_INFORMATION_CLASS;

/* Policy domain quality of service information */
#if (_WIN32_WINNT == 0x0500)
typedef struct _POLICY_DOMAIN_QUALITY_OF_SERVICE_INFO {
    ULONG   QualityOfService;
} POLICY_DOMAIN_QUALITY_OF_SERVICE_INFO;
typedef POLICY_DOMAIN_QUALITY_OF_SERVICE_INFO   *PPOLICY_DOMAIN_QUALITY_OF_SERVICE_INFO;
#endif

/* Policy domain EFS information */
typedef struct _POLICY_DOMAIN_EFS_INFO {
    ULONG   InfoLength;
    PUCHAR  EfsBlob;
} POLICY_DOMAIN_EFS_INFO;
typedef POLICY_DOMAIN_EFS_INFO  *PPOLICY_DOMAIN_EFS_INFO;

/* Policy domain Kerberos ticket information */
typedef struct _POLICY_DOMAIN_KERBEROS_TICKET_INFO {
    ULONG           AuthenticationOptions;
    LARGE_INTEGER   MaxServiceTicketAge;
    LARGE_INTEGER   MaxTicketAge;
    LARGE_INTEGER   MaxRenewAge;
    LARGE_INTEGER   MaxClockSkew;
    LARGE_INTEGER   Reserved;
} POLICY_DOMAIN_KERBEROS_TICKET_INFO;
typedef POLICY_DOMAIN_KERBEROS_TICKET_INFO  *PPOLICY_DOMAIN_KERBEROS_TICKET_INFO;

/* Policy notification information classes */
typedef enum _POLICY_NOTIFICATION_INFORMATION_CLASS {
    PolicyNotifyAuditEventsInformation              = 1,
    PolicyNotifyAccountDomainInformation            = 2,
    PolicyNotifyServerRoleInformation               = 3,
    PolicyNotifyDnsDomainInformation                = 4,
    PolicyNotifyDomainEfsInformation                = 5,
    PolicyNotifyDomainKerberosTicketInformation     = 6,
    PolicyNotifyMachineAccountPasswordInformation   = 7,
    PolicyNotifyGlobalSaclInformation               = 8,
    PolicyNotifyMax                                 = 9
} POLICY_NOTIFICATION_INFORMATION_CLASS;
typedef POLICY_NOTIFICATION_INFORMATION_CLASS   *PPOLICY_NOTIFICATION_INFORMATION_CLASS;

/* Trusted information classes */
typedef enum _TRUSTED_INFORMATION_CLASS {
    TrustedDomainNameInformation            = 1,
    TrustedControllersInformation           = 2,
    TrustedPosixOffsetInformation           = 3,
    TrustedPasswordInformation              = 4,
    TrustedDomainInformationBasic           = 5,
    TrustedDomainInformationEx              = 6,
    TrustedDomainAuthInformation            = 7,
    TrustedDomainFullInformation            = 8,
    TrustedDomainAuthInformationInternal    = 9,
    TrustedDomainFullInformationInternal    = 10,
    TrustedDomainInformationEx2Internal     = 11,
    TrustedDomainFullInformation2Internal   = 12,
    TrustedDomainSupportedEncryptionTypes   = 13
} TRUSTED_INFORMATION_CLASS;
typedef TRUSTED_INFORMATION_CLASS   *PTRUSTED_INFORMATION_CLASS;

/* Trusted domain name information */
typedef struct _TRUSTED_DOMAIN_NAME_INFO {
    LSA_UNICODE_STRING  Name;
} TRUSTED_DOMAIN_NAME_INFO;
typedef TRUSTED_DOMAIN_NAME_INFO    *PTRUSTED_DOMAIN_NAME_INFO;

/* Trusted controllers information */
typedef struct _TRUSTED_CONTROLLERS_INFO {
    ULONG               Entries;
    PLSA_UNICODE_STRING Names;
} TRUSTED_CONTROLLERS_INFO;
typedef TRUSTED_CONTROLLERS_INFO    *PTRUSTED_CONTROLLERS_INFO;

/* Trusted POSIX offset information */
typedef struct _TRUSTED_POSIX_OFFSET_INFO {
    ULONG   Offset;
} TRUSTED_POSIX_OFFSET_INFO;
typedef TRUSTED_POSIX_OFFSET_INFO   *PTRUSTED_POSIX_OFFSET_INFO;

/* Trusted password information */
typedef struct _TRUSTED_PASSWORD_INFO {
    LSA_UNICODE_STRING  Password;
    LSA_UNICODE_STRING  OldPassword;
} TRUSTED_PASSWORD_INFO;
typedef TRUSTED_PASSWORD_INFO   *PTRUSTED_PASSWORD_INFO;

/* Trusted domain basic information */
typedef LSA_TRUST_INFORMATION   TRUSTED_DOMAIN_INFORMATION_BASIC;
typedef PLSA_TRUST_INFORMATION  PTRUSTED_DOMAIN_INFORMATION_BASIC;

/* Trusted domain information (extended version) */
typedef struct _TRUSTED_DOMAIN_INFORMATION_EX {
    LSA_UNICODE_STRING  Name;
    LSA_UNICODE_STRING  FlatName;
    PSID                Sid;
    ULONG               TrustDirection;
    ULONG               TrustType;
    ULONG               TrustAttributes;
} TRUSTED_DOMAIN_INFORMATION_EX;
typedef TRUSTED_DOMAIN_INFORMATION_EX   *PTRUSTED_DOMAIN_INFORMATION_EX;

/* Trusted domain information (extended version 2) */
typedef struct _TRUSTED_DOMAIN_INFORMATION_EX2 {
    LSA_UNICODE_STRING  Name;
    LSA_UNICODE_STRING  FlatName;
    PSID                Sid;
    ULONG               TrustDirection;
    ULONG               TrustType;
    ULONG               TrustAttributes;
    ULONG               ForestTrustLength;
    PUCHAR              ForestTrustInfo;
} TRUSTED_DOMAIN_INFORMATION_EX2;
typedef TRUSTED_DOMAIN_INFORMATION_EX2  *PTRUSTED_DOMAIN_INFORMATION_EX2;

/* LSA authentication information */
typedef struct _LSA_AUTH_INFORMATION {
    LARGE_INTEGER   LastUpdateTime;
    ULONG           AuthType;
    ULONG           AuthInfoLength;
    PUCHAR          AuthInfo;
} LSA_AUTH_INFORMATION;
typedef LSA_AUTH_INFORMATION    *PLSA_AUTH_INFORMATION;

/* Trusted domain authentication information */
typedef struct _TRUSTED_DOMAIN_AUTH_INFORMATION {
    ULONG                   IncomingAuthInfos;
    PLSA_AUTH_INFORMATION   IncomingAuthenticationInformation;
    PLSA_AUTH_INFORMATION   IncomingPreviousAuthenticationInformation;
    ULONG                   OutgoingAuthInfos;
    PLSA_AUTH_INFORMATION   OutgoingAuthenticationInformation;
    PLSA_AUTH_INFORMATION   OutgoingPreviousAuthenticationInformation;
} TRUSTED_DOMAIN_AUTH_INFORMATION;
typedef TRUSTED_DOMAIN_AUTH_INFORMATION *PTRUSTED_DOMAIN_AUTH_INFORMATION;

/* Trusted domain full information */
typedef struct _TRUSTED_DOMAIN_FULL_INFORMATION {
    TRUSTED_DOMAIN_INFORMATION_EX   Information;
    TRUSTED_POSIX_OFFSET_INFO       PosixOffset;
    TRUSTED_DOMAIN_AUTH_INFORMATION AuthInformation;
} TRUSTED_DOMAIN_FULL_INFORMATION;
typedef TRUSTED_DOMAIN_FULL_INFORMATION *PTRUSTED_DOMAIN_FULL_INFORMATION;

/* Trusted domain full information (version 2) */
typedef struct _TRUSTED_DOMAIN_FULL_INFORMATION2 {
    TRUSTED_DOMAIN_INFORMATION_EX2  Information;
    TRUSTED_POSIX_OFFSET_INFO       PosixOffset;
    TRUSTED_DOMAIN_AUTH_INFORMATION AuthInformation;
} TRUSTED_DOMAIN_FULL_INFORMATION2;
typedef TRUSTED_DOMAIN_FULL_INFORMATION2    *PTRUSTED_DOMAIN_FULL_INFORMATION2;

/* Trusted domain supported encryption types */
typedef struct _TRUSTED_DOMAIN_SUPPORTED_ENCRYPTION_TYPES {
    ULONG   SupportedEncryptionTypes;
} TRUSTED_DOMAIN_SUPPORTED_ENCRYPTION_TYPES;
typedef TRUSTED_DOMAIN_SUPPORTED_ENCRYPTION_TYPES   *PTRUSTED_DOMAIN_SUPPORTED_ENCRYPTION_TYPES;

/* LSA forest trust record type */
typedef enum {
    ForestTrustTopLevelName     = 0,
    ForestTrustTopLevelNameEx   = 1,
    ForestTrustDomainInfo       = 2,
    ForestTrustRecordTypeLast   = ForestTrustDomainInfo
} LSA_FOREST_TRUST_RECORD_TYPE;

/* LSA forest trust domain information */
typedef struct _LSA_FOREST_TRUST_DOMAIN_INFO {
    PSID                Sid;
    LSA_UNICODE_STRING  DnsName;
    LSA_UNICODE_STRING  NetbiosName;
} LSA_FOREST_TRUST_DOMAIN_INFO;
typedef LSA_FOREST_TRUST_DOMAIN_INFO    *PLSA_FOREST_TRUST_DOMAIN_INFO;

/* LSA forest trust binary data */
typedef struct _LSA_FOREST_TRUST_BINARY_DATA {
    ULONG   Length;
    PUCHAR  Buffer;
} LSA_FOREST_TRUST_BINARY_DATA;
typedef LSA_FOREST_TRUST_BINARY_DATA    *PLSA_FOREST_TRUST_BINARY_DATA;

/* LSA forest trust record */
typedef struct _LSA_FOREST_TRUST_RECORD {
    ULONG                           Flags;
    LSA_FOREST_TRUST_RECORD_TYPE    ForestTrustType;
    LARGE_INTEGER                   Time;
    union {
        LSA_UNICODE_STRING              TopLevelName;
        LSA_FOREST_TRUST_DOMAIN_INFO    DomainInfo;
        LSA_FOREST_TRUST_BINARY_DATA    Data;
    } ForestTrustData;
} LSA_FOREST_TRUST_RECORD;
typedef LSA_FOREST_TRUST_RECORD *PLSA_FOREST_TRUST_RECORD;

/* LSA forest trust information */
typedef struct _LSA_FOREST_TRUST_INFORMATION {
    ULONG                       RecordCount;
    PLSA_FOREST_TRUST_RECORD    *Entries;
} LSA_FOREST_TRUST_INFORMATION;
typedef LSA_FOREST_TRUST_INFORMATION    *PLSA_FOREST_TRUST_INFORMATION;

/* LSA forest trust collision record type */
typedef enum {
    CollisionTdo    = 0,
    CollisionXref   = 1,
    CollisionOther  = 2
} LSA_FOREST_TRUST_COLLISION_RECORD_TYPE;

/* LSA forest trust collision record */
typedef struct _LSA_FOREST_TRUST_COLLISION_RECORD {
    ULONG                                   Index;
    LSA_FOREST_TRUST_COLLISION_RECORD_TYPE  Type;
    ULONG                                   Flags;
    LSA_UNICODE_STRING                      Name;
} LSA_FOREST_TRUST_COLLISION_RECORD;
typedef LSA_FOREST_TRUST_COLLISION_RECORD   *PLSA_FOREST_TRUST_COLLISION_RECORD;

/* LSA forest trust collision information */
typedef struct _LSA_FOREST_TRUST_COLLISION_INFORMATION {
    ULONG                               RecordCount;
    PLSA_FOREST_TRUST_COLLISION_RECORD  *Entries;
} LSA_FOREST_TRUST_COLLISION_INFORMATION;
typedef LSA_FOREST_TRUST_COLLISION_INFORMATION  *PLSA_FOREST_TRUST_COLLISION_INFORMATION;

/* LSA enumeration information */
typedef struct _LSA_ENUMERATION_INFORMATION {
    PSID    Sid;
} LSA_ENUMERATION_INFORMATION;
typedef LSA_ENUMERATION_INFORMATION *PLSA_ENUMERATION_INFORMATION;

/* LSA last logon information */
#if (_WIN32_WINNT >= 0x0600)
typedef struct _LSA_LAST_INTER_LOGON_INFO {
    LARGE_INTEGER   LastSuccessfulLogon;
    LARGE_INTEGER   LastFailedLogon;
    ULONG           FailedAttemptCountSinceLastSuccessfulLogon;
} LSA_LAST_INTER_LOGON_INFO;
typedef LSA_LAST_INTER_LOGON_INFO   *PLSA_INTER_LOGON_INFO;
#endif

/* Security logon session data */
#if (_WIN32_WINNT >= 0x0501)
typedef struct _SECURITY_LOGON_SESSION_DATA {
    ULONG                       Size;
    LUID                        LogonId;
    LSA_UNICODE_STRING          UserName;
    LSA_UNICODE_STRING          LogonDomain;
    LSA_UNICODE_STRING          AuthenticationPackage;
    ULONG                       LogonType;
    ULONG                       Session;
    PSID                        Sid;
    LARGE_INTEGER               LogonTime;
    LSA_UNICODE_STRING          LogonServer;
    LSA_UNICODE_STRING          DnsDomainName;
    LSA_UNICODE_STRING          Upn;
#if (_WIN32_WINNT >= 0x0600)
    ULONG                       UserFlags;
    LSA_LAST_INTER_LOGON_INFO   LastLogonInfo;
    LSA_UNICODE_STRING          LogonScript;
    LSA_UNICODE_STRING          ProfilePath;
    LSA_UNICODE_STRING          HomeDirectory;
    LSA_UNICODE_STRING          HomeDirectoryDrive;
    LARGE_INTEGER               LogoffTime;
    LARGE_INTEGER               KickOffTime;
    LARGE_INTEGER               PasswordLastSet;
    LARGE_INTEGER               PasswordCanChange;
    LARGE_INTEGER               PasswordMustChange;
#endif
} SECURITY_LOGON_SESSION_DATA;
typedef SECURITY_LOGON_SESSION_DATA *PSECURITY_LOGON_SESSION_DATA;
#endif

/* Negotiate messages */
enum NEGOTIATE_MESSAGES {
    NegEnumPackagePrefixes  = 0,
    NegGetCallerName        = 1,
    NegCallPackageMax       = 2
};

/* Negotiate package prefix */
typedef struct _NEGOTIATE_PACKAGE_PREFIX {
    ULONG_PTR   PackageId;
    PVOID       PackageDataA;
    PVOID       PackageDataW;
    ULONG_PTR   PrefixLen;
    UCHAR       Prefix[NEGOTIATE_MAX_PREFIX];
} NEGOTIATE_PACKAGE_PREFIX;
typedef NEGOTIATE_PACKAGE_PREFIX    *PNEGOTIATE_PACKAGE_PREFIX;

/* Negotiate package prefixes */
typedef struct _NEGOTIATE_PACKAGE_PREFIXES {
    ULONG   MessageType;
    ULONG   PrefixCount;
    ULONG   Offset;
#if (_WIN32_WINNT >= 0x0502)
    ULONG   Pad;
#endif
} NEGOTIATE_PACKAGE_PREFIXES;
typedef NEGOTIATE_PACKAGE_PREFIXES  *PNEGOTIATE_PACKAGE_PREFIXES;

/* Negotiate caller name request */
typedef struct _NEGOTIATE_CALLER_NAME_REQUEST {
    ULONG   MessageType;
    LUID    LogonId;
} NEGOTIATE_CALLER_NAME_REQUEST;
typedef NEGOTIATE_CALLER_NAME_REQUEST   *PNEGOTIATE_CALLER_NAME_REQUEST;

/* Negotiate caller name response */
typedef struct _NEGOTIATE_CALLER_NAME_RESPONSE {
    ULONG   MessageType;
    PWSTR   CallaerName;
} NEGOTIATE_CALLER_NAME_RESPONSE;
typedef NEGOTIATE_CALLER_NAME_RESPONSE  *PNEGOTIATE_CALLER_NAME_RESPONSE;

/* Domain password information */
typedef struct _DOMAIN_PASSWORD_INFORMATION {
    USHORT          MinPasswordLength;
    USHORT          PasswordHistoryLength;
    ULONG           PasswordProperties;
    LARGE_INTEGER   MaxPasswordAge;
    LARGE_INTEGER   MinPasswordAge;
} DOMAIN_PASSWORD_INFORMATION;
typedef DOMAIN_PASSWORD_INFORMATION *PDOMAIN_PASSWORD_INFORMATION;

/* SAM callbacks */
typedef NTSTATUS (*PSAM_PASSWORD_NOTIFICATION_ROUTINE)( PUNICODE_STRING, ULONG, PUNICODE_STRING );
typedef BOOLEAN (*PSAM_INIT_NOTIFICATION_ROUTINE)();
typedef BOOLEAN (*PSAM_PASSWORD_FILTER_ROUTINE)( PUNICODE_STRING, PUNICODE_STRING, PUNICODE_STRING, BOOLEAN );

/* MSV1.0 logon submit types */
typedef enum _MSV1_0_LOGON_SUBMIT_TYPE {
    MsV1_0InteractiveLogon          = 2,
    MsV1_0Lm20Logon                 = 3,
    MsV1_0NetworkLogon              = 4,
    MsV1_0SubAuthLogon              = 5,
    MsV1_0WorkstationUnlockLogon    = 7,
    MsV1_0S4ULogon                  = 12,
    MsV1_0VirtualLogon              = 82
} MSV1_0_LOGON_SUBMIT_TYPE;
typedef MSV1_0_LOGON_SUBMIT_TYPE    *PMSV1_0_LOGON_SUBMIT_TYPE;

/* MSV1.0 profile buffer types */
typedef enum _MSV1_0_PROFILE_BUFFER_TYPE {
    MsV1_0InteractiveProfile    = 2,
    MsV1_0Lm20LogonProfile      = 3,
    MsV1_0SmartCardProfile      = 4
} MSV1_0_PROFILE_BUFFER_TYPE;
typedef MSV1_0_PROFILE_BUFFER_TYPE  *PMSV1_0_PROFILE_BUFFER_TYPE;

/* MSV1.0 interactive logon authentication information */
typedef struct _MSV1_0_INTERACTIVE_LOGON {
    MSV1_0_LOGON_SUBMIT_TYPE    MessageType;
    UNICODE_STRING              LogonDomainName;
    UNICODE_STRING              UserName;
    UNICODE_STRING              Password;
} MSV1_0_INTERACTIVE_LOGON;
typedef MSV1_0_INTERACTIVE_LOGON    *PMSV1_0_INTERACTIVE_LOGON;

/* MSV1.0 interactive profile buffer */
typedef struct _MSV1_0_INTERACTIVE_PROFILE {
    MSV1_0_PROFILE_BUFFER_TYPE  MessageType;
    USHORT                      LogonCount;
    USHORT                      BadPasswordCount;
    LARGE_INTEGER               LogonTime;
    LARGE_INTEGER               LogoffTime;
    LARGE_INTEGER               KickOffTime;
    LARGE_INTEGER               PasswordLastSet;
    LARGE_INTEGER               PasswordCanChange;
    LARGE_INTEGER               PasswordMustChange;
    UNICODE_STRING              LogonScript;
    UNICODE_STRING              HomeDirectory;
    UNICODE_STRING              FullName;
    UNICODE_STRING              ProfilePath;
    UNICODE_STRING              HomeDirectoryDrive;
    UNICODE_STRING              LogonServer;
    ULONG                       UserFlags;
} MSV1_0_INTERACTIVE_PROFILE;
typedef MSV1_0_INTERACTIVE_PROFILE  *PMSV1_0_INTERACTIVE_PROFILE;

/* MSV1.0 LAN Manager 2.0 logon authentication information */
typedef struct _MSV1_0_LM20_LOGON {
    MSV1_0_LOGON_SUBMIT_TYPE    MessageType;
    UNICODE_STRING              LogonDomainName;
    UNICODE_STRING              UserName;
    UNICODE_STRING              Workstation;
    UCHAR                       ChallengeToClient[MSV1_0_CHALLENGE_LENGTH];
    STRING                      CaseSensitiveChallengeResponse;
    STRING                      CaseInsensitiveChallengeResponse;
    ULONG                       ParameterControl;
} MSV1_0_LM20_LOGON;
typedef MSV1_0_LM20_LOGON   *PMSV1_0_LM20_LOGON;

/* MSV1.0 subauthentication logon authentication information */
typedef struct _MSV1_0_SUBAUTH_LOGON {
    MSV1_0_LOGON_SUBMIT_TYPE    MessageType;
    UNICODE_STRING              LogonDomainName;
    UNICODE_STRING              UserName;
    UNICODE_STRING              Workstation;
    UCHAR                       ChallengeToClient[MSV1_0_CHALLENGE_LENGTH];
    STRING                      AuthenticationInfo1;
    STRING                      AuthenticationInfo2;
    ULONG                       ParameterControl;
    ULONG                       SubAuthPackageId;
} MSV1_0_SUBAUTH_LOGON;
typedef MSV1_0_SUBAUTH_LOGON    *PMSV1_0_SUBAUTH_LOGON;

/* MSV1.0 S4U logon authentication information */
#if (_WIN32_WINNT >= 0x0600)
typedef struct _MSV1_0_S4U_LOGON {
    MSV1_0_LOGON_SUBMIT_TYPE    MessageType;
    ULONG                       Flags;
    UNICODE_STRING              UserPrincipalName;
    UNICODE_STRING              DomainName;
} MSV1_0_S4U_LOGON;
typedef MSV1_0_S4U_LOGON    *PMSV1_0_S4U_LOGON;
#endif

/* MSV1.0 LAN Manager 2.0 logon profile buffer */
typedef struct _MSV1_0_LM20_LOGON_PROFILE {
    MSV1_0_PROFILE_BUFFER_TYPE  MessageType;
    LARGE_INTEGER               KickOffTime;
    LARGE_INTEGER               LogoffTime;
    ULONG                       UserFlags;
    UCHAR                       UserSessionKey[MSV1_0_USER_SESSION_KEY_LENGTH];
    UNICODE_STRING              LogonDomainName;
    UCHAR                       LanmanSessionKey[MSV1_0_LANMAN_SESSION_KEY_LENGTH];
    UNICODE_STRING              LogonServer;
    UNICODE_STRING              UserParameters;
} MSV1_0_LM20_LOGON_PROFILE;
typedef MSV1_0_LM20_LOGON_PROFILE   *PMSV1_0_LM20_LOGON_PROFILE;

/* MSV1.0 supplemental credential */
typedef struct _MSV1_0_SUPPLEMENTAL_CREDENTIAL {
    ULONG   Version;
    ULONG   Flags;
    UCHAR   LmPassword[MSV1_0_OWF_PASSWORD_LENGTH];
    UCHAR   NtPassword[MSV1_0_OWF_PASSWORD_LENGTH];
} MSV1_0_SUPPLEMENTAL_CREDENTIAL;
typedef MSV1_0_SUPPLEMENTAL_CREDENTIAL  *PMSV1_0_SUPPLEMENTAL_CREDENTIAL;

/* MSV1.0 NTLM3 response */
typedef struct _MSV1_0_NTLM3_RESPONSE {
    UCHAR       Response[MSV1_0_NTLM3_RESPONSE_LENGTH];
    UCHAR       RespType;
    UCHAR       HiRespType;
    USHORT      Flags;
    ULONG       MsgWord;
    ULONGLONG   TimeStamp;
    UCHAR       ChallengeFromClient[MSV1_0_CHALLENGE_LENGTH];
    ULONG       AvPairsOff;
    UCHAR       Buffer[1];
} MSV1_0_NTLM3_RESPONSE;
typedef MSV1_0_NTLM3_RESPONSE   *PMSV1_0_NTLM3_RESPONSE;

/* MSV1.0 AV identifiers */
typedef enum {
    MsvAvEOL                = 0,
    MsvAvNbComputerName     = 1,
    MsvAvNbDomainName       = 2,
    MsvAvDnsComputerName    = 3,
#if (_WIN32_WINNT >= 0x0501)
    MsvAvDnsDomainName      = 4,
    MsvAvDnsTreeName        = 5,
#if (_WIN32_WINNT >= 0x0600)
    MsvAvFlags              = 6,
    MsvAvTimestamp          = 7,
    MsvAvRestrictions       = 8,
    MsvAvTargetName         = 9,
    MsvAvChannelBindings    = 10
#else
    MsvAvFlags              = 6
#endif
#else
    MsvAvDomainName         = 4
#endif
} MSV1_0_AVID;

/* MSV1.0 AV pair */
typedef struct _MSV1_0_AV_PAIR {
    USHORT  AvId;
    USHORT  AvLen;
} MSV1_0_AV_PAIR;
typedef MSV1_0_AV_PAIR  *PMSV1_0_AV_PAIR;

/* MSV1.0 protocol message types */
typedef enum _MSV1_0_PROTOCOL_MESSAGE_TYPE {
    MsV1_0Lm20ChallengeRequest      = 0,
    MsV1_0Lm20GetChallengeResponse  = 1,
    MsV1_0EnumerateUsers            = 2,
    MsV1_0GetUserInfo               = 3,
    MsV1_0ReLogonUsers              = 4,
    MsV1_0ChangePassword            = 5,
    MsV1_0ChangeCachedPassword      = 6,
    MsV1_0GenericPassthrough        = 7,
    MsV1_0CacheLogon                = 8,
    MsV1_0SubAuth                   = 9,
    MsV1_0DeriveCredential          = 10,
#if (_WIN32_WINNT >= 0x0501)
    MsV1_0CacheLookup               = 11,
#if (_WIN32_WINNT >= 0x0600)
    MsV1_0SetProcessOption          = 12,
    MsV1_0ConfigLocalAliases        = 13,
    MsV1_0ClearCachedCredentials    = 14
#else
    MsV1_0SetProcessOption          = 12
#endif
#else
    MsV1_0CacheLookup               = 11
#endif
} MSV1_0_PROTOCOL_MESSAGE_TYPE;

/* MSV1.0 change password request */
typedef struct _MSV1_0_CHANGEPASSWORD_REQUEST {
    MSV1_0_PROTOCOL_MESSAGE_TYPE    MessageType;
    UNICODE_STRING                  DomainName;
    UNICODE_STRING                  AccountName;
    UNICODE_STRING                  OldPassword;
    UNICODE_STRING                  NewPassword;
    BOOLEAN                         Impersonating;
} MSV1_0_CHANGEPASSWORD_REQUEST;
typedef MSV1_0_CHANGEPASSWORD_REQUEST   *PMSV1_0_CHANGEPASSWORD_REQUEST;

/* MSV1.0 change password response */
typedef struct _MSV1_0_CHANGEPASSWORD_RESPONSE {
    MSV1_0_PROTOCOL_MESSAGE_TYPE    MessageType;
    BOOLEAN                         PasswordInfoValid;
    DOMAIN_PASSWORD_INFORMATION     DomainPasswordInfo;
} MSV1_0_CHANGEPASSWORD_RESPONSE;
typedef MSV1_0_CHANGEPASSWORD_RESPONSE  *PMSV1_0_CHANGEPASSWORD_RESPONSE;

/* MSV1.0 passthrough request */
#if (_WIN32_WINNT >= 0x0502)
typedef struct _MSV1_0_PASSTHROUGH_REQUEST {
    MSV1_0_PROTOCOL_MESSAGE_TYPE    MessageType;
    UNICODE_STRING                  DomainName;
    UNICODE_STRING                  PackageName;
    ULONG                           DataLength;
    PUCHAR                          LogonData;
    ULONG                           Pad;
} MSV1_0_PASSTHROUGH_REQUEST;
typedef MSV1_0_PASSTHROUGH_REQUEST  *PMSV1_0_PASSTHROUGH_REQUEST;
#endif

/* MSV1.0 passthrough response */
#if (_WIN32_WINNT >= 0x0502)
typedef struct _MSV1_0_PASSTHROUGH_RESPONSE {
    MSV1_0_PROTOCOL_MESSAGE_TYPE    MessageType;
    ULONG                           Pad;
    ULONG                           DataLength;
    PUCHAR                          ValidationData;
} MSV1_0_PASSTHROUGH_RESPONSE;
typedef MSV1_0_PASSTHROUGH_RESPONSE *PMSV1_0_PASSTHROUGH_RESPONSE;
#endif

/* MSV1.0 subauthentication request */
typedef struct _MSV1_0_SUBAUTH_REQUEST {
    MSV1_0_PROTOCOL_MESSAGE_TYPE    MessageType;
    ULONG                           SubAuthPackageId;
    ULONG                           SubAuthInfoLength;
    PUCHAR                          SubAuthSubmitBuffer;
} MSV1_0_SUBAUTH_REQUEST;
typedef MSV1_0_SUBAUTH_REQUEST  *PMSV1_0_SUBAUTH_REQUEST;

/* MSV1.0 subauthentication response */
typedef struct _MSV1_0_SUBAUTH_RESPONSE {
    MSV1_0_PROTOCOL_MESSAGE_TYPE    MessageType;
    ULONG                           SubAuthInfoLength;
    PUCHAR                          SubAuthReturnBuffer;
} MSV1_0_SUBAUTH_RESPONSE;
typedef MSV1_0_SUBAUTH_RESPONSE *PMSV1_0_SUBAUTH_RESPONSE;

/* Kerberos logon submit types */
typedef enum _KERB_LOGON_SUBMIT_TYPE {
    KerbInteractiveLogon        = 2,
    KerbSmartCardLogon          = 6,
    KerbWorkstationUnlockLogon  = 7,
    KerbSmartCardUnlockLogon    = 8,
    KerbProxyLogon              = 9,
    KerbTicketLogon             = 10,
    KerbTicketUnlockLogon       = 11,
#if (_WIN32_WINNT >= 0x0600)
    KerbS4ULogon                = 12,
    KerbCertificateLogon        = 13,
    KerbCertificateS4ULogon     = 14,
    KerbCertificateUnlockLogon  = 15
#else
    KerbS4ULogon                = 12
#endif
} KERB_LOGON_SUBMIT_TYPE;
typedef KERB_LOGON_SUBMIT_TYPE  *PKERB_LOGON_SUBMIT_TYPE;

/* Kerberos interactive logon authentication information */
typedef struct _KERB_INTERACTIVE_LOGON {
    KERB_LOGON_SUBMIT_TYPE  MessageType;
    UNICODE_STRING          LogonDomainName;
    UNICODE_STRING          UserName;
    UNICODE_STRING          Password;
} KERB_INTERACTIVE_LOGON;
typedef KERB_INTERACTIVE_LOGON  *PKERB_INTERACTIVE_LOGON;

/* Kerberos interactive unlock logon authentication information */
typedef struct _KERB_INTERACTIVE_UNLOCK_LOGON {
    KERB_INTERACTIVE_LOGON  Logon;
    LUID                    LogonId;
} KERB_INTERACTIVE_UNLOCK_LOGON;
typedef KERB_INTERACTIVE_UNLOCK_LOGON   *PKERB_INTERACTIVE_UNLOCK_LOGON;

/* Kerberos smart card logon authentication information */
typedef struct _KERB_SMART_CARD_LOGON {
    KERB_LOGON_SUBMIT_TYPE  MessageType;
    UNICODE_STRING          Pin;
    ULONG                   CspDataLength;
    PUCHAR                  CspData;
} KERB_SMART_CARD_LOGON;
typedef KERB_SMART_CARD_LOGON   *PKERB_SMART_CARD_LOGON;

/* Kerberos smart card unlock logon authentication information */
typedef struct _KERB_SMART_CARD_UNLOCK_LOGON {
    KERB_SMART_CARD_LOGON   Logon;
    LUID                    LogonId;
} KERB_SMART_CARD_UNLOCK_LOGON;
typedef KERB_SMART_CARD_UNLOCK_LOGON    *PKERB_SMART_CARD_UNLOCK_LOGON;

/* Kerberos certificate logon authentication information */
#if (_WIN32_WINNT >= 0x0600)
typedef struct _KERB_CERTIFICATE_LOGON {
    KERB_LOGON_SUBMIT_TYPE  MessageType;
    UNICODE_STRING          DomainName;
    UNICODE_STRING          UserName;
    UNICODE_STRING          Pin;
    ULONG                   Flags;
    ULONG                   CspDataLength;
    PUCHAR                  CspData;
} KERB_CERTIFICATE_LOGON;
typedef KERB_CERTIFICATE_LOGON  *PKERB_CERTIFICATE_LOGON;
#endif

/* Kerberos certificate unlock logon authentication information */
#if (_WIN32_WINNT >= 0x0600)
typedef struct _KERB_CERTIFICATE_UNLOCK_LOGON {
    KERB_CERTIFICATE_LOGON  Logon;
    LUID                    LogonId;
} KERB_CERTIFICATE_UNLOCK_LOGON;
typedef KERB_CERTIFICATE_UNLOCK_LOGON   *PKERB_CERTIFICATE_UNLOCK_LOGON;
#endif

/* Kerberos certificate S4U logon authentication information */
#if (_WIN32_WINNT >= 0x0600)
typedef struct _KERB_CERTIFICATE_S4U_LOGON {
    KERB_LOGON_SUBMIT_TYPE  MessageType;
    ULONG                   Flags;
    UNICODE_STRING          UserPrincipalName;
    UNICODE_STRING          DomainName;
    ULONG                   CertificateLength;
    PUCHAR                  Certificate;
} KERB_CERTIFICATE_S4U_LOGON;
typedef KERB_CERTIFICATE_S4U_LOGON  *PKERB_CERTIFICATE_S4U_LOGON;
#endif

/* Kerberos ticket logon authentication information */
typedef struct _KERB_TICKET_LOGON {
    KERB_LOGON_SUBMIT_TYPE  MessageType;
    ULONG                   Flags;
    ULONG                   ServiceTicketLength;
    ULONG                   TicketGrantingTicketLength;
    PUCHAR                  ServiceTicket;
    PUCHAR                  TicketGrantingTicket;
} KERB_TICKET_LOGON;
typedef KERB_TICKET_LOGON   *PKERB_TICKET_LOGON;

/* Kerberos ticket unlock logon authentication information */
typedef struct _KERB_TICKET_UNLOCK_LOGON {
    KERB_TICKET_LOGON   Logon;
    LUID                LogonId;
} KERB_TICKET_UNLOCK_LOGON;
typedef KERB_TICKET_UNLOCK_LOGON    *PKERB_TICKET_UNLOCK_LOGON;

/* Kerberos S4U logon authentication information */
typedef struct _KERB_S4U_LOGON {
    KERB_LOGON_SUBMIT_TYPE  MessageType;
    ULONG                   Flags;
    UNICODE_STRING          ClientUpn;
    UNICODE_STRING          ClientRealm;
} KERB_S4U_LOGON;
typedef KERB_S4U_LOGON  *PKERB_S4U_LOGON;

/* Kerberos profile buffer types */
typedef enum _KERB_PROFILE_BUFFER_TYPE {
    KerbInteractiveProfile  = 2,
    KerbSmartCardProfile    = 4,
    KerbTicketProfile       = 6
} KERB_PROFILE_BUFFER_TYPE;
typedef KERB_PROFILE_BUFFER_TYPE    *PKERB_PROFILE_BUFFER_TYPE;

/* Kerberos interactive profile buffer */
typedef struct _KERB_INTERACTIVE_PROFILE {
    KERB_PROFILE_BUFFER_TYPE    MessageType;
    USHORT                      LogonCount;
    USHORT                      BadPasswordCount;
    LARGE_INTEGER               LogonTime;
    LARGE_INTEGER               LogoffTime;
    LARGE_INTEGER               KickOffTime;
    LARGE_INTEGER               PasswordLastSet;
    LARGE_INTEGER               PasswordCanChange;
    LARGE_INTEGER               PasswordMustChange;
    UNICODE_STRING              LogonScript;
    UNICODE_STRING              HomeDirectory;
    UNICODE_STRING              FullName;
    UNICODE_STRING              ProfilePath;
    UNICODE_STRING              HomeDirectoryDrive;
    UNICODE_STRING              LogonServer;
    ULONG                       UserFlags;
} KERB_INTERACTIVE_PROFILE;
typedef KERB_INTERACTIVE_PROFILE    *PKERB_INTERACTIVE_PROFILE;

/* Kerberos smart card profile buffer */
typedef struct _KERB_SMART_CARD_PROFILE {
    KERB_INTERACTIVE_PROFILE    Profile;
    ULONG                       CertificateSize;
    PUCHAR                      CertificateData;
} KERB_SMART_CARD_PROFILE;
typedef KERB_SMART_CARD_PROFILE *PKERB_SMART_CARD_PROFILE;

/* Kerberos cryptographic key */
typedef struct KERB_CRYPTO_KEY {
    LONG    KeyType;
    ULONG   Length;
    PUCHAR  Value;
} KERB_CRYPTO_KEY;
typedef KERB_CRYPTO_KEY *PKERB_CRYPTO_KEY;

/* Kerberos cryptographic key (32-bit version) */
typedef struct KERB_CRYPTO_KEY32 {
    LONG    KeyType;
    ULONG   Length;
    ULONG   Offset;
} KERB_CRYPTO_KEY32;
typedef KERB_CRYPTO_KEY32   *PKERB_CRYPTO_KEY32;

/* Kerberos ticket profile buffer */
typedef struct _KERB_TICKET_PROFILE {
    KERB_INTERACTIVE_PROFILE    Profile;
    KERB_CRYPTO_KEY             SessionKey;
} KERB_TICKET_PROFILE;
typedef KERB_TICKET_PROFILE *PKERB_TICKET_PROFILE;

/* Kerberos protocol message types */
typedef enum _KERB_PROTOCOL_MESSAGE_TYPE {
    KerbDebugRequestMessage                 = 0,
    KerbQueryTicketCacheMessage             = 1,
    KerbChangeMachinePasswordMessage        = 2,
    KerbVerifyPacMessage                    = 3,
    KerbRetrieveTicketMessage               = 4,
    KerbUpdateAddressesMessage              = 5,
    KerbPurgeTicketCacheMessage             = 6,
    KerbChangePasswordMessage               = 7,
    KerbRetrieveEncodedTicketMessage        = 8,
    KerbDecryptDataMessage                  = 9,
    KerbAddBindingCacheEntryMessage         = 10,
    KerbSetPasswordMessage                  = 11,
#if (_WIN32_WINNT >= 0x0500)
    KerbSetPasswordExMessage                = 12,
#else
    KerbSetPasswordExMessage                = 12
#endif
#if (_WIN32_WINNT == 0x0500)
    KerbAddExtraCredentialsMessage          = 17
#endif
#if (_WIN32_WINNT >= 0x0501)
    KerbVerifyCredentialsMessage            = 13,
    KerbQueryTicketCacheExMessage           = 14,
#if (_WIN32_WINNT >= 0x0502)
    KerbPurgeTicketCacheExMessage           = 15,
    KerbRefreshSmartcardCredentialsMessage  = 16,
    KerbAddExtraCredentialsMessage          = 17,
#if (_WIN32_WINNT >= 0x0600)
    KerbQuerySupplementalCredentialsMessage = 18,
    KerbTransferCredentialsMessage          = 19,
    KerbQueryTicketCacheEx2Message          = 20,
    KerbSubmitTicketMessage                 = 21,
    KerbAddExtraCredentialsExMessage        = 22
#else
    KerbQuerySupplementalCredentialsMessage = 18
#endif
#else
    KerbAddExtraCredentialsMessage          = 17
#endif
#endif
} KERB_PROTOCOL_MESSAGE_TYPE;
typedef KERB_PROTOCOL_MESSAGE_TYPE  *PKERB_PROTOCOL_MESSAGE_TYPE;

/* Kerberos query ticket cache request */
typedef struct _KERB_QUERY_TKT_CACHE_REQUEST {
    KERB_PROTOCOL_MESSAGE_TYPE  MessageType;
    LUID                        LogonId;
} KERB_QUERY_TKT_CACHE_REQUEST;
typedef KERB_QUERY_TKT_CACHE_REQUEST    *PKERB_QUERY_TKT_CACHE_REQUEST;

/* Kerberos ticket cache information */
typedef struct _KERB_TICKET_CACHE_INFO {
    UNICODE_STRING  ServerName;
    UNICODE_STRING  RealmName;
    LARGE_INTEGER   StartTime;
    LARGE_INTEGER   EndTime;
    LARGE_INTEGER   RenewTime;
    LONG            EncryptionType;
    ULONG           TicketFlags;
} KERB_TICKET_CACHE_INFO;
typedef KERB_TICKET_CACHE_INFO  *PKERB_TICKET_CACHE_INFO;

/* Kerberos ticket cache information (extended version) */
#if (_WIN32_WINNT >= 0x0501)
typedef struct _KERB_TICKET_CACHE_INFO_EX {
    UNICODE_STRING  ClientName;
    UNICODE_STRING  ClientRealm;
    UNICODE_STRING  ServerName;
    UNICODE_STRING  ServerRealm;
    LARGE_INTEGER   StartTime;
    LARGE_INTEGER   EndTime;
    LARGE_INTEGER   RenewTime;
    LONG            EncryptionType;
    ULONG           TicketFlags;
} KERB_TICKET_CACHE_INFO_EX;
typedef KERB_TICKET_CACHE_INFO_EX   *PKERB_TICKET_CACHE_INFO_EX;
#endif

/* Kerberos ticket cache information (extended version 2) */
typedef struct _KERB_TICKET_CACHE_INFO_EX2 {
    UNICODE_STRING  ClientName;
    UNICODE_STRING  ClientRealm;
    UNICODE_STRING  ServerName;
    UNICODE_STRING  ServerRealm;
    LARGE_INTEGER   StartTime;
    LARGE_INTEGER   EndTime;
    LARGE_INTEGER   RenewTime;
    LONG            EncryptionType;
    ULONG           TicketFlags;
    ULONG           SessionKeyType;
    ULONG           BranchId;
} KERB_TICKET_CACHE_INFO_EX2;
typedef KERB_TICKET_CACHE_INFO_EX2  *PKERB_TICKET_CACHE_INFO_EX2;

/* Kerberos query ticket cache response */
typedef struct _KERB_QUERY_TKT_CACHE_RESPONSE {
    KERB_PROTOCOL_MESSAGE_TYPE  MessageType;
    ULONG                       CountOfTickets;
    KERB_TICKET_CACHE_INFO      Tickets[ANYSIZE_ARRAY];
} KERB_QUERY_TKT_CACHE_RESPONSE;
typedef KERB_QUERY_TKT_CACHE_RESPONSE   *PKERB_QUERY_TKT_CACHE_RESPONSE;

/* Kerberos query ticket cache response (extended version) */
#if (_WIN32_WINNT >= 0x0502)
typedef struct _KERB_QUERY_TKT_CACHE_EX_RESPONSE {
    KERB_PROTOCOL_MESSAGE_TYPE  MessageType;
    ULONG                       CountOfTickets;
    KERB_TICKET_CACHE_INFO_EX   Tickets[ANYSIZE_ARRAY];
} KERB_QUERY_TKT_CACHE_EX_RESPONSE;
typedef KERB_QUERY_TKT_CACHE_EX_RESPONSE    *PKERB_QUERY_TKT_CACHE_EX_RESPONSE;
#endif

/* Kerb query ticket cache response (extended version 2) */
typedef struct _KERB_QUERY_TKT_CACHE_EX2_RESPONSE {
    KERB_PROTOCOL_MESSAGE_TYPE  MessageType;
    ULONG                       CountOfTickets;
    KERB_TICKET_CACHE_INFO_EX2  Tickets[ANYSIZE_ARRAY];
} KERB_QUERY_TKT_CACHE_EX2_RESPONSE;
typedef KERB_QUERY_TKT_CACHE_EX2_RESPONSE   *PKERB_QUERY_TKT_CACHE_EX2_RESPONSE;

/* Security handle */
#ifndef _SECHANDLE_DEFINED
#define _SECHANDLE_DEFINED
typedef struct _SecHandle {
    ULONG_PTR   dwLower;
    ULONG_PTR   dwUpper;
} SecHandle;
typedef SecHandle   *PSecHandle;
#endif

/* Kerberos authentication data */
#if (_WIN32_WINNT >= 0x0501)
typedef struct _KERB_AUTH_DATA {
    ULONG   Type;
    ULONG   Length;
    PUCHAR  Data;
} KERB_AUTH_DATA;
typedef KERB_AUTH_DATA  *PKERB_AUTH_DATA;
#endif

/* Kerberos network address */
#if (_WIN32_WINNT >= 0x0501)
typedef struct _KERB_NET_ADDRESS {
    ULONG   Family;
    ULONG   Length;
    PCHAR   Address;
} KERB_NET_ADDRESS;
typedef KERB_NET_ADDRESS    *PKERB_NET_ADDRESS;
#endif

/* Kerberos network addresses */
#if (_WIN32_WINNT >= 0x0501)
typedef struct _KERB_NET_ADDRESSES {
    ULONG               Number;
    KERB_NET_ADDRESS    Addresses[ANYSIZE_ARRAY];
} KERB_NET_ADDRESSES;
typedef KERB_NET_ADDRESSES  *PKERB_NET_ADDRESSES;
#endif

/* Kerberos external name */
typedef struct _KERB_EXTERNAL_NAME {
    SHORT           NameType;
    USHORT          NameCount;
    UNICODE_STRING  Names[ANYSIZE_ARRAY];
} KERB_EXTERNAL_NAME;
typedef KERB_EXTERNAL_NAME  *PKERB_EXTERNAL_NAME;

/* Kerberos external ticket */
typedef struct _KERB_EXTERNAL_TICKET {
    PKERB_EXTERNAL_NAME ServiceName;
    PKERB_EXTERNAL_NAME TargetName;
    PKERB_EXTERNAL_NAME ClientName;
    UNICODE_STRING      DomainName;
    UNICODE_STRING      TargetDomainName;
    UNICODE_STRING      AltTargetDomainName;
    KERB_CRYPTO_KEY     SessionKey;
    ULONG               TicketFlags;
    ULONG               Flags;
    LARGE_INTEGER       KeyExpirationTime;
    LARGE_INTEGER       StartTime;
    LARGE_INTEGER       EndTime;
    LARGE_INTEGER       RenewUntil;
    LARGE_INTEGER       TimeSkew;
    ULONG               EncodedTicketSize;
    PUCHAR              EncodedTicket;
} KERB_EXTERNAL_TICKET;
typedef KERB_EXTERNAL_TICKET    *PKERB_EXTERNAL_TICKET;

/* Kerberos retrieve ticket request */
typedef struct _KERB_RETRIEVE_TKT_REQUEST {
    KERB_PROTOCOL_MESSAGE_TYPE  MessageType;
    LUID                        LogonId;
    UNICODE_STRING              TargetName;
    ULONG                       TicketFlags;
    ULONG                       CacheOptions;
    LONG                        EncryptionType;
    SecHandle                   CredentialsHandle;
} KERB_RETRIEVE_TKT_REQUEST;
typedef KERB_RETRIEVE_TKT_REQUEST   *PKERB_RETRIEVE_TKT_REQUEST;

/* Kerberos retrieve ticket response */
typedef struct _KERB_RETRIEVE_TKT_RESPONSE {
    KERB_EXTERNAL_TICKET    Ticket;
} KERB_RETRIEVE_TKT_RESPONSE;
typedef KERB_RETRIEVE_TKT_RESPONSE  *PKERB_RETRIEVE_TKT_RESPONSE;

/* Kerberos purge ticket cache request */
typedef struct _KERB_PURGE_TKT_CACHE_REQUEST {
    KERB_PROTOCOL_MESSAGE_TYPE  MessageType;
    LUID                        LogonId;
    UNICODE_STRING              ServerName;
    UNICODE_STRING              RealmName;
} KERB_PURGE_TKT_CACHE_REQUEST;
typedef KERB_PURGE_TKT_CACHE_REQUEST    *PKERB_PURGE_TKT_CACHE_REQUEST;

/* Kerberos purge ticket cache request (extended version) */
#if (_WIN32_WINNT >= 0x0501)
typedef struct _KERB_PURGE_TKT_CACHE_EX_REQUEST {
    KERB_PROTOCOL_MESSAGE_TYPE  MessageType;
    LUID                        LogonId;
    ULONG                       Flags;
    KERB_TICKET_CACHE_INFO_EX   TicketTemplate;
} KERB_PURGE_TKT_CACHE_EX_REQUEST;
typedef KERB_PURGE_TKT_CACHE_EX_REQUEST *PKERB_PURGE_TKT_CACHE_EX_REQUEST;
#endif

/* Kerberos submit ticket request */
typedef struct _KERB_SUBMIT_TKT_REQUEST {
    KERB_PROTOCOL_MESSAGE_TYPE  MessageType;
    LUID                        LogonId;
    ULONG                       Flags;
    KERB_CRYPTO_KEY32           Key;
    ULONG                       KerbCredSize;
    ULONG                       KerbCredOffset;
} KERB_SUBMIT_TKT_REQUEST;
typedef KERB_SUBMIT_TKT_REQUEST *PKERB_SUBMIT_TKT_REQUEST;

/* Kerberos change password request */
typedef struct _KERB_CHANGEPASSWORD_REQUEST {
    KERB_PROTOCOL_MESSAGE_TYPE  MessageType;
    UNICODE_STRING              DomainName;
    UNICODE_STRING              AccountName;
    UNICODE_STRING              OldPassword;
    UNICODE_STRING              NewPassword;
    BOOLEAN                     Impersonating;
} KERB_CHANGEPASSWORD_REQUEST;
typedef KERB_CHANGEPASSWORD_REQUEST *PKERB_CHANGEPASSWORD_REQUEST;

/* Kerberos set password request */
typedef struct _KERB_SETPASSWORD_REQUEST {
    KERB_PROTOCOL_MESSAGE_TYPE  MessageType;
    LUID                        LogonId;
    SecHandle                   CredentialsHandle;
    ULONG                       Flags;
    UNICODE_STRING              DomainName;
    UNICODE_STRING              AccountName;
    UNICODE_STRING              Password;
} KERB_SETPASSWORD_REQUEST;
typedef KERB_SETPASSWORD_REQUEST    *PKERB_SETPASSWORD_REQUEST;

/* Kerberos set password request (extended version) */
typedef struct _KERB_SETPASSWORD_EX_REQUEST {
    KERB_PROTOCOL_MESSAGE_TYPE  MessageType;
    LUID                        LogonId;
    SecHandle                   CredentialsHandle;
    ULONG                       Flags;
    UNICODE_STRING              AccountRealm;
    UNICODE_STRING              AccountName;
    UNICODE_STRING              Password;
    UNICODE_STRING              ClientRealm;
    UNICODE_STRING              ClientName;
    BOOLEAN                     Impersonating;
    UNICODE_STRING              KdcAddress;
    ULONG                       KdcAddressType;
} KERB_SETPASSWORD_EX_REQUEST;
typedef KERB_SETPASSWORD_EX_REQUEST *PKERB_SETPASSWORD_EX_REQUEST;

/* Kerberos decrypt request */
typedef struct _KERB_DECRYPT_REQUEST {
    KERB_PROTOCOL_MESSAGE_TYPE  MessageType;
    LUID                        LogonId;
    ULONG                       Flags;
    LONG                        CryptoType;
    LONG                        KeyUsage;
    KERB_CRYPTO_KEY             Key;
    ULONG                       EncryptedDataSize;
    ULONG                       InitialVectorSize;
    PUCHAR                      InitialVector;
    PUCHAR                      EncryptedData;
} KERB_DECRYPT_REQUEST;
typedef KERB_DECRYPT_REQUEST    *PKERB_DECRYPT_REQUEST;

/* Kerberos decrypt response */
typedef struct _KERB_DECRYPT_RESPONSE {
    UCHAR   DecryptedData[ANYSIZE_ARRAY];
} KERB_DECRYPT_RESPONSE;
typedef KERB_DECRYPT_RESPONSE   *PKERB_DECRYPT_RESPONSE;

/* Kerberos add binding cache entry request */
typedef struct _KERB_ADD_BINDING_CACHE_ENTRY_REQUEST {
    KERB_PROTOCOL_MESSAGE_TYPE  MessageType;
    UNICODE_STRING              RealmName;
    UNICODE_STRING              KdcAddress;
    ULONG                       AddressType;
} KERB_ADD_BINDING_CACHE_ENTRY_REQUEST;
typedef KERB_ADD_BINDING_CACHE_ENTRY_REQUEST    *PKERB_ADD_BINDING_CACHE_ENTRY_REQUEST;

/* Kerberos refresh smart card credentials request */
#if (_WIN32_WINNT >= 0x0502)
typedef struct _KERB_REFRESH_SCCRED_REQUEST {
    KERB_PROTOCOL_MESSAGE_TYPE  MessageType;
    UNICODE_STRING              CredentialBlob;
    LUID                        LogonId;
    ULONG                       Flags;
} KERB_REFRESH_SCCRED_REQUEST;
typedef KERB_REFRESH_SCCRED_REQUEST *PKERB_REFRESH_SCCRED_REQUEST;
#endif

/* Kerberos add credentials request */
#if (_WIN32_WINNT != 0x0501)
typedef struct _KERB_ADD_CREDENTIALS_REQUEST {
    KERB_PROTOCOL_MESSAGE_TYPE  MessageType;
    UNICODE_STRING              UserName;
    UNICODE_STRING              DomainName;
    UNICODE_STRING              Password;
    LUID                        LogonId;
    ULONG                       Flags;
} KERB_ADD_CREDENTIALS_REQUEST;
typedef KERB_ADD_CREDENTIALS_REQUEST    *PKERB_ADD_CREDENTIALS_REQUEST;
#endif

/* Kerberos add credentials request (extended version) */
#if (_WIN32_WINNT >= 0x0600)
typedef struct _KERB_ADD_CREDENTIALS_REQUEST_EX {
    KERB_ADD_CREDENTIALS_REQUEST    Credentials;
    ULONG                           PrincipalNameCount;
    UNICODE_STRING                  PrincipalNames[ANYSIZE_ARRAY];
} KERB_ADD_CREDENTIALS_REQUEST_EX;
typedef KERB_ADD_CREDENTIALS_REQUEST_EX *PKERB_ADD_CREDENTIALS_REQUEST_EX;
#endif

/* Kerberos transfer credentials request */
typedef struct _KERB_TRANSFER_CRED_REQUEST {
    KERB_PROTOCOL_MESSAGE_TYPE  MessageType;
    LUID                        OriginLogonId;
    LUID                        DestinationLogonId;
    ULONG                       Flags;
} KERB_TRANSFER_CRED_REQUEST;
typedef KERB_TRANSFER_CRED_REQUEST  *PKERB_TRANSFER_CRED_REQUEST;

/* Policy audit SID array */
typedef struct _POLICY_AUDIT_SID_ARRAY {
    ULONG   UsersCount;
    PSID    *UserSidArray;
} POLICY_AUDIT_SID_ARRAY;
typedef POLICY_AUDIT_SID_ARRAY  *PPOLICY_AUDIT_SID_ARRAY;

/* Audit policy information */
typedef struct _AUDIT_POLICY_INFORMATION {
    GUID    AuditSubCategoryGuid;
    ULONG   AuditingInformation;
    GUID    AuditCategoryGuid;
} AUDIT_POLICY_INFORMATION;
typedef AUDIT_POLICY_INFORMATION        *PAUDIT_POLICY_INFORMATION;
typedef const AUDIT_POLICY_INFORMATION  *PCAUDIT_POLICY_INFORMATION;
typedef const AUDIT_POLICY_INFORMATION  *LPCAUDIT_POLICY_INFORMATION;

/* PKU2U certificate blob */
#if (_WIN32_WINNT >= 0x0601)
typedef struct _PKU2U_CERT_BLOB {
    ULONG   CertOffset;
    USHORT  CertLength;
} PKU2U_CERT_BLOB;
typedef PKU2U_CERT_BLOB *PPKU2U_CERT_BLOB;
#endif

/* PKU2U credential UI context */
#if (_WIN32_WINNT >= 0x0601)
typedef struct _PKU2U_CREDUI_CONTEXT {
    ULONG64 Version;
    USHORT  cbHeaderLength;
    ULONG   cbStructureLength;
    USHORT  CertArrayCount;
    ULONG   CertArrayOffset;
} PKU2U_CREDUI_CONTEXT;
typedef PKU2U_CREDUI_CONTEXT    *PPKU2U_CREDUI_CONTEXT;
#endif

/* PKU2U logon submit types */
#if (_WIN32_WINNT >= 0x0601)
typedef enum _PKU2U_LOGON_SUBMIT_TYPE {
    Pku2uCertificateS4ULogon    = 14
} PKU2U_LOGON_SUBMIT_TYPE;
typedef PKU2U_LOGON_SUBMIT_TYPE *PPKU2U_LOGON_SUBMIT_TYPE;
#endif

/* PKU2U certificate S4U logon */
#if (_WIN32_WINNT >= 0x0601)
typedef struct _PKU2U_CERTIFICATE_S4U_LOGON {
    PKU2U_LOGON_SUBMIT_TYPE MessageType;
    ULONG                   Flags;
    UNICODE_STRING          UserPrincipalName;
    UNICODE_STRING          DomainName;
    ULONG                   CertificateLength;
    PUCHAR                  Certificate;
} PKU2U_CERTIFICATE_S4U_LOGON;
typedef PKU2U_CERTIFICATE_S4U_LOGON *PPKU2U_CERTIFICATE_S4U_LOGON;
#endif

/* Functions in SECUR32.DLL */
NTSTATUS NTAPI  LsaCallAuthenticationPackage( HANDLE, ULONG, PVOID, ULONG, PVOID *, PULONG, PNTSTATUS );
NTSTATUS NTAPI  LsaConnectUntrusted( PHANDLE );
NTSTATUS NTAPI  LsaDeregisterLogonProcess( HANDLE );
NTSTATUS NTAPI  LsaFreeReturnBuffer( PVOID );
NTSTATUS NTAPI  LsaLogonUser( HANDLE, PLSA_STRING, SECURITY_LOGON_TYPE, ULONG, PVOID, ULONG, PTOKEN_GROUPS, PTOKEN_SOURCE, PVOID *, PULONG, PLUID, PHANDLE, PQUOTA_LIMITS, PNTSTATUS );
NTSTATUS NTAPI  LsaLookupAuthenticationPackage( HANDLE, PLSA_STRING, PULONG );
NTSTATUS NTAPI  LsaRegisterLogonProcess( PLSA_STRING, PHANDLE, PLSA_OPERATIONAL_MODE );
NTSTATUS NTAPI  LsaRegisterPolicyChangeNotification( POLICY_NOTIFICATION_INFORMATION_CLASS, HANDLE );
NTSTATUS NTAPI  LsaUnregisterPolicyChangeNotification( POLICY_NOTIFICATION_INFORMATION_CLASS, HANDLE );
#if (_WIN32_WINNT >= 0x0501)
NTSTATUS NTAPI  LsaEnumerateLogonSessions( PULONG, PLUID * );
NTSTATUS NTAPI  LsaGetLogonSessionData( PLUID, PSECURITY_LOGON_SESSION_DATA * );
#endif

/* Internal names of functions in ADVAPI32.DLL */
#if (_WIN32_WINNT >= 0x0501)
    #define RtlGenRandom        SystemFunction036
#endif
#if (_WIN32_WINNT >= 0x0500)
    #define RtlEncryptMemory    SystemFunction040
    #define RtlDecryptMemory    SystemFunction041
#endif

/* Functions in ADVAPI32.DLL */
BOOLEAN NTAPI   AuditComputeEffectivePolicyBySid( const PSID, const GUID *, ULONG, PAUDIT_POLICY_INFORMATION * );
BOOLEAN NTAPI   AuditComputeEffectivePolicyByToken( HANDLE, const GUID *, ULONG, PAUDIT_POLICY_INFORMATION * );
BOOLEAN NTAPI   AuditEnumerateCategories( GUID **, PULONG );
BOOLEAN NTAPI   AuditEnumeratePerUserPolicy( PPOLICY_AUDIT_SID_ARRAY * );
BOOLEAN NTAPI   AuditEnumerateSubCategories( const GUID *, BOOLEAN, GUID **, PULONG );
VOID NTAPI      AuditFree( PVOID );
BOOLEAN NTAPI   AuditLookupCategoryGuidFromCatgeoryId( POLICY_AUDIT_EVENT_TYPE, GUID * );
BOOLEAN NTAPI   AuditLookupCategoryIdFromCategoryGuid( const GUID *, PPOLICY_AUDIT_EVENT_TYPE );
BOOLEAN NTAPI   AuditLookupCategoryNameA( const GUID *, PSTR * );
BOOLEAN NTAPI   AuditLookupCategoryNameW( const GUID *, PWSTR * );
BOOLEAN NTAPI   AuditLookupSubCategoryNameA( const GUID *, PSTR * );
BOOLEAN NTAPI   AuditLookupSubCategoryNameW( const GUID *, PWSTR * );
BOOLEAN NTAPI   AuditQueryGlobalSaclA( PCSTR, PACL * );
BOOLEAN NTAPI   AuditQueryGlobalSaclW( PCWSTR, PACL * );
BOOLEAN NTAPI   AuditQueryPerUserPolicy( const PSID, const GUID *, ULONG, PAUDIT_POLICY_INFORMATION * );
BOOLEAN NTAPI   AuditQuerySecurity( SECURITY_INFORMATION, PSECURITY_DESCRIPTOR * );
BOOLEAN NTAPI   AuditQuerySystemPolicy( const GUID *, ULONG, PAUDIT_POLICY_INFORMATION * );
BOOLEAN NTAPI   AuditSetGlobalSaclA( PCSTR, PACL );
BOOLEAN NTAPI   AuditSetGlobalSaclW( PCWSTR, PACL );
BOOLEAN NTAPI   AuditSetPerUserPolicy( const PSID, PCAUDIT_POLICY_INFORMATION, ULONG );
BOOLEAN NTAPI   AuditSetSecurity( SECURITY_INFORMATION, PSECURITY_DESCRIPTOR );
BOOLEAN NTAPI   AuditSetSystemPolicy( PCAUDIT_POLICY_INFORMATION, ULONG );
NTSTATUS NTAPI  LsaAddAccountRights( LSA_HANDLE, PSID, PLSA_UNICODE_STRING, ULONG );
NTSTATUS NTAPI  LsaClose( LSA_HANDLE );
NTSTATUS NTAPI  LsaCreateTrustedDomainEx( LSA_HANDLE, PTRUSTED_DOMAIN_INFORMATION_EX, PTRUSTED_DOMAIN_AUTH_INFORMATION, ACCESS_MASK, PLSA_HANDLE );
NTSTATUS NTAPI  LsaDeleteTrustedDomain( LSA_HANDLE, PSID );
NTSTATUS NTAPI  LsaEnumerateAccountRights( LSA_HANDLE, PSID, PLSA_UNICODE_STRING *, PULONG );
NTSTATUS NTAPI  LsaEnumerateAccountsWithUserRight( LSA_HANDLE, PLSA_UNICODE_STRING, PVOID *, PULONG );
NTSTATUS NTAPI  LsaEnumerateTrustedDomains( LSA_HANDLE, PLSA_ENUMERATION_HANDLE, PVOID *, ULONG, PULONG );
NTSTATUS NTAPI  LsaEnumerateTrustedDomainsEx( LSA_HANDLE, PLSA_ENUMERATION_HANDLE, PVOID *, ULONG, PULONG );
NTSTATUS NTAPI  LsaFreeMemory( PVOID );
NTSTATUS NTAPI  LsaLookupNames( LSA_HANDLE, ULONG, PLSA_UNICODE_STRING, PLSA_REFERENCED_DOMAIN_LIST *, PLSA_TRANSLATED_SID * );
NTSTATUS NTAPI  LsaLookupSids( LSA_HANDLE, ULONG, PSID *, PLSA_REFERENCED_DOMAIN_LIST *, PLSA_TRANSLATED_NAME * );
ULONG NTAPI     LsaNtStatusToWinError( NTSTATUS );
NTSTATUS NTAPI  LsaOpenPolicy( PLSA_UNICODE_STRING, PLSA_OBJECT_ATTRIBUTES, ACCESS_MASK, PLSA_HANDLE );
NTSTATUS NTAPI  LsaOpenTrustedDomainByName( LSA_HANDLE, PLSA_UNICODE_STRING, ACCESS_MASK, PLSA_HANDLE );
NTSTATUS NTAPI  LsaQueryDomainInformationPolicy( LSA_HANDLE, POLICY_DOMAIN_INFORMATION_CLASS, PVOID * );
NTSTATUS NTAPI  LsaQueryInformationPolicy( LSA_HANDLE, POLICY_INFORMATION_CLASS, PVOID * );
NTSTATUS NTAPI  LsaQueryTrustedDomainInfo( LSA_HANDLE, PSID, TRUSTED_INFORMATION_CLASS, PVOID * );
NTSTATUS NTAPI  LsaQueryTrustedDomainInfoByName( LSA_HANDLE, PLSA_UNICODE_STRING, TRUSTED_INFORMATION_CLASS, PVOID * );
NTSTATUS NTAPI  LsaRemoveAccountRights( LSA_HANDLE, PSID, BOOLEAN, PLSA_UNICODE_STRING, ULONG );
NTSTATUS NTAPI  LsaRetrievePrivateData( LSA_HANDLE, PLSA_UNICODE_STRING, PLSA_UNICODE_STRING * );
NTSTATUS NTAPI  LsaSetDomainInformationPolicy( LSA_HANDLE, POLICY_DOMAIN_INFORMATION_CLASS, PVOID );
NTSTATUS NTAPI  LsaSetInformationPolicy( LSA_HANDLE, POLICY_INFORMATION_CLASS, PVOID );
NTSTATUS NTAPI  LsaSetTrustedDomainInfoByName( LSA_HANDLE, PLSA_UNICODE_STRING, TRUSTED_INFORMATION_CLASS, PVOID );
NTSTATUS NTAPI  LsaSetTrustedDomainInformation( LSA_HANDLE, PSID, TRUSTED_INFORMATION_CLASS, PVOID );
NTSTATUS NTAPI  LsaStorePrivateData( LSA_HANDLE, PLSA_UNICODE_STRING, PLSA_UNICODE_STRING );
NTSTATUS NTAPI  RtlDecryptMemory( PVOID, ULONG, ULONG );
NTSTATUS NTAPI  RtlEncryptMemory( PVOID, ULONG, ULONG );
#if (_WIN32_WINNT >= 0x0501)
NTSTATUS NTAPI  LsaLookupNames2( LSA_HANDLE, ULONG, ULONG, PLSA_UNICODE_STRING, PLSA_REFERENCED_DOMAIN_LIST *, PLSA_TRANSLATED_SID2 * );
NTSTATUS NTAPI  LsaQueryForestTrustInformation( LSA_HANDLE, PLSA_UNICODE_STRING, PLSA_FOREST_TRUST_INFORMATION * );
NTSTATUS NTAPI  LsaSetForestTrustInformation( LSA_HANDLE, PLSA_UNICODE_STRING, PLSA_FOREST_TRUST_INFORMATION, BOOLEAN, PLSA_FOREST_TRUST_COLLISION_INFORMATION * );
BOOLEAN NTAPI   RtlGenRandom( PVOID, ULONG );
#endif

/* Map generic function names to the appropriate ANSI or Unicode version. */
#ifdef UNICODE
    #define AuditLookupCategoryName     AuditLookupCategoryNameW
    #define AuditLookupSubCategoryName  AuditLookupSubCategoryNameW
    #define AuditQueryGlobalSacl        AuditQueryGlobalSaclW
    #define AuditSetGlobalSacl          AuditSetGlobalSaclW
#else
    #define AuditLookupCategoryName     AuditLookupCategoryNameA
    #define AuditLookupSubCategoryName  AuditLookupSubCategoryNameA
    #define AuditQueryGlobalSacl        AuditQueryGlobalSaclA
    #define AuditSetGlobalSacl          AuditSetGlobalSaclA
#endif

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* _NTSECAPI_ */
