/*
 * Microsoft Windows Installer declarations
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2014 The Open Watcom Contributors. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */

#ifndef _MSI_H_
#define _MSI_H_

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file;
#endif

#include <windows.h>

/* Define default version numbers. */
#ifndef WINVER
    #define WINVER          0x0400
#endif
#ifndef _WIN32_WINNT
    #define _WIN32_WINNT    0x0400
#endif
#ifndef _WIN32_IE
    #define _WIN32_IE       0x0400
#endif
#ifndef NTDDI_VERSION
    #define NTDDI_VERSION   0x05000000
#endif

#ifndef _WIN32_MSI
#if (defined(NTDDI_VERSION) && NTDDI_VERSION >= NTDDI_WS03SP1)
#define _WIN32_MSI 310
#elif (defined(NTDDI_VERSION) && NTDDI_VERSION >= NTDDI_WINXPSP2)
#define _WIN32_MSI 300
#else
#define _WIN32_MSI 200
#endif
#endif

#if (_WIN32_MSI >= 150)
#ifndef _MSI_NO_CRYPTO
#include <wincrypt.h>
#endif /* _MSI_NO_CRYPTO */
#endif /* _WIN32_MSI >= 150 */

typedef unsigned long MSIHANDLE;

typedef enum tagINSTALLMESSAGE {
    INSTALLMESSAGE_FATALEXIT        = 0x00000000L,
    INSTALLMESSAGE_ERROR            = 0x01000000L,
    INSTALLMESSAGE_WARNING          = 0x02000000L,
    INSTALLMESSAGE_USER             = 0x03000000L,
    INSTALLMESSAGE_INFO             = 0x04000000L,
    INSTALLMESSAGE_FILESINUSE       = 0x05000000L,
    INSTALLMESSAGE_RESOLVESOURCE    = 0x06000000L,
    INSTALLMESSAGE_OUTOFDISKSPACE   = 0x07000000L,
    INSTALLMESSAGE_ACTIONSTART      = 0x08000000L,
    INSTALLMESSAGE_ACTIONDATA       = 0x09000000L,
    INSTALLMESSAGE_PROGRESS         = 0x0A000000L,
    INSTALLMESSAGE_COMMONDATA       = 0x0B000000L,
    INSTALLMESSAGE_INITIALIZE       = 0x0C000000L,
    INSTALLMESSAGE_TERMINATE        = 0x0D000000L,
    INSTALLMESSAGE_SHOWDIALOG       = 0x0E000000L
} INSTALLMESSAGE;

typedef enum tagINSTALLUILEVEL {
    INSTALLUILEVEL_NOCHANGE         = 0,
    INSTALLUILEVEL_DEFAULT          = 1,
    INSTALLUILEVEL_NONE             = 2,
    INSTALLUILEVEL_BASIC            = 3,
    INSTALLUILEVEL_REDUCED          = 4,
    INSTALLUILEVEL_FULL             = 5,
    INSTALLUILEVEL_ENDDIALOG        = 0x80,
    INSTALLUILEVEL_PROGRESSONLY     = 0x40,
    INSTALLUILEVEL_HIDECANCEL       = 0x20,
    INSTALLUILEVEL_SOURCERESONLY    = 0x100
} INSTALLUILEVEL;

typedef int (WINAPI *INSTALLUI_HANDLERA)(LPVOID pvContext,UINT iMessageType,LPCSTR szMessage);
typedef int (WINAPI *INSTALLUI_HANDLERW)(LPVOID pvContext,UINT iMessageType,LPCWSTR szMessage);

#if (_WIN32_MSI >= 310)
typedef int (WINAPI *INSTALLUI_HANDLER_RECORD)(LPVOID pvContext,UINT iMessageType,MSIHANDLE hRecord);
typedef INSTALLUI_HANDLER_RECORD *PINSTALLUI_HANDLER_RECORD;
#endif

typedef enum tagINSTALLSTATE {
    INSTALLSTATE_NOTUSED        = -7,
    INSTALLSTATE_BADCONFIG      = -6,
    INSTALLSTATE_INCOMPLETE     = -5,
    INSTALLSTATE_SOURCEABSENT   = -4,
    INSTALLSTATE_MOREDATA       = -3,
    INSTALLSTATE_INVALIDARG     = -2,
    INSTALLSTATE_UNKNOWN        = -1,
    INSTALLSTATE_BROKEN         = 0,
    INSTALLSTATE_ADVERTISED     = 1,
    INSTALLSTATE_REMOVED        = 1,
    INSTALLSTATE_ABSENT         = 2,
    INSTALLSTATE_LOCAL          = 3,
    INSTALLSTATE_SOURCE         = 4,
    INSTALLSTATE_DEFAULT        = 5
} INSTALLSTATE;

typedef enum tagUSERINFOSTATE {
    USERINFOSTATE_MOREDATA      = -3,
    USERINFOSTATE_INVALIDARG    = -2,
    USERINFOSTATE_UNKNOWN       = -1,
    USERINFOSTATE_ABSENT        = 0,
    USERINFOSTATE_PRESENT       = 1
} USERINFOSTATE;

typedef enum tagINSTALLLEVEL {
    INSTALLLEVEL_DEFAULT = 0,
    INSTALLLEVEL_MINIMUM = 1,
    INSTALLLEVEL_MAXIMUM = 0xFFFF
} INSTALLLEVEL;

typedef enum tagREINSTALLMODE {
    REINSTALLMODE_REPAIR            = 0x00000001,
    REINSTALLMODE_FILEMISSING       = 0x00000002,
    REINSTALLMODE_FILEOLDERVERSION  = 0x00000004,
    REINSTALLMODE_FILEEQUALVERSION  = 0x00000008,
    REINSTALLMODE_FILEEXACT         = 0x00000010,
    REINSTALLMODE_FILEVERIFY        = 0x00000020,
    REINSTALLMODE_FILEREPLACE       = 0x00000040,
    REINSTALLMODE_MACHINEDATA       = 0x00000080,
    REINSTALLMODE_USERDATA          = 0x00000100,  
    REINSTALLMODE_SHORTCUT          = 0x00000200,
    REINSTALLMODE_PACKAGE           = 0x00000400
} REINSTALLMODE;

typedef enum tagINSTALLOGMODE {
    INSTALLLOGMODE_FATALEXIT        = (1 << (INSTALLMESSAGE_FATALEXIT >> 24)),
    INSTALLLOGMODE_ERROR            = (1 << (INSTALLMESSAGE_ERROR >> 24)),
    INSTALLLOGMODE_WARNING          = (1 << (INSTALLMESSAGE_WARNING >> 24)),
    INSTALLLOGMODE_USER             = (1 << (INSTALLMESSAGE_USER >> 24)),
    INSTALLLOGMODE_INFO             = (1 << (INSTALLMESSAGE_INFO >> 24)),
    INSTALLLOGMODE_RESOLVESOURCE    = (1 << (INSTALLMESSAGE_RESOLVESOURCE >> 24)),
    INSTALLLOGMODE_OUTOFDISKSPACE   = (1 << (INSTALLMESSAGE_OUTOFDISKSPACE >> 24)),
    INSTALLLOGMODE_ACTIONSTART      = (1 << (INSTALLMESSAGE_ACTIONSTART >> 24)),
    INSTALLLOGMODE_ACTIONDATA       = (1 << (INSTALLMESSAGE_ACTIONDATA >> 24)),
    INSTALLLOGMODE_COMMONDATA       = (1 << (INSTALLMESSAGE_COMMONDATA >> 24)),
    INSTALLLOGMODE_PROPERTYDUMP     = (1 << (INSTALLMESSAGE_PROGRESS >> 24)),
    INSTALLLOGMODE_VERBOSE          = (1 << (INSTALLMESSAGE_INITIALIZE >> 24)),
    INSTALLLOGMODE_EXTRADEBUG       = (1 << (INSTALLMESSAGE_TERMINATE >> 24)),
    INSTALLLOGMODE_LOGONLYONERROR   = (1 << (INSTALLMESSAGE_SHOWDIALOG >> 24)),
    INSTALLLOGMODE_PROGRESS         = (1 << (INSTALLMESSAGE_PROGRESS >> 24)),
    INSTALLLOGMODE_INITIALIZE       = (1 << (INSTALLMESSAGE_INITIALIZE >> 24)),
    INSTALLLOGMODE_TERMINATE        = (1 << (INSTALLMESSAGE_TERMINATE >> 24)),
    INSTALLLOGMODE_SHOWDIALOG       = (1 << (INSTALLMESSAGE_SHOWDIALOG >> 24)),
    INSTALLLOGMODE_FILESINUSE       = (1 << (INSTALLMESSAGE_FILESINUSE >> 24))
} INSTALLLOGMODE;

typedef enum tagINSTALLLOGATTRIBUTES {
    INSTALLLOGATTRIBUTES_APPEND         = (1 << 0),
    INSTALLLOGATTRIBUTES_FLUSHEACHLINE  = (1 << 1)
} INSTALLLOGATTRIBUTES;

typedef enum tagINSTALLFEATUREATTRIBUTE {
    INSTALLFEATUREATTRIBUTE_FAVORLOCAL              = 1 << 0,
    INSTALLFEATUREATTRIBUTE_FAVORSOURCE             = 1 << 1,
    INSTALLFEATUREATTRIBUTE_FOLLOWPARENT            = 1 << 2,
    INSTALLFEATUREATTRIBUTE_FAVORADVERTISE          = 1 << 3,
    INSTALLFEATUREATTRIBUTE_DISALLOWADVERTISE       = 1 << 4,
    INSTALLFEATUREATTRIBUTE_NOUNSUPPORTEDADVERTISE  = 1 << 5
} INSTALLFEATUREATTRIBUTE;

typedef enum tagINSTALLMODE {
#if (_WIN32_MSI >= 150)
    INSTALLMODE_NODETECTION_ANY     = -4,
#endif
    INSTALLMODE_NOSOURCERESOLUTION  = -3,
    INSTALLMODE_NODETECTION         = -2,
    INSTALLMODE_EXISTING            = -1,
    INSTALLMODE_DEFAULT             = 0
} INSTALLMODE;

#if (_WIN32_MSI >= 300)
typedef enum tagMSIPATCHSTATE {
    MSIPATCHSTATE_INVALID       = 0,
    MSIPATCHSTATE_APPLIED       = 1,
    MSIPATCHSTATE_SUPERSEDED    = 2,
    MSIPATCHSTATE_OBSOLETED     = 4,
    MSIPATCHSTATE_REGISTERED    = 8,
    MSIPATCHSTATE_ALL = (MSIPATCHSTATE_APPLIED | MSIPATCHSTATE_SUPERSEDED | MSIPATCHSTATE_OBSOLETED | MSIPATCHSTATE_REGISTERED)
} MSIPATCHSTATE;

typedef enum tagMSIINSTALLCONTEXT {
    MSIINSTALLCONTEXT_FIRSTVISIBLE      = 0,
    MSIINSTALLCONTEXT_NONE              = 0,
    MSIINSTALLCONTEXT_USERMANAGED       = 1,
    MSIINSTALLCONTEXT_USERUNMANAGED     = 2,
    MSIINSTALLCONTEXT_MACHINE           = 4,
    MSIINSTALLCONTEXT_ALL = (MSIINSTALLCONTEXT_USERMANAGED | MSIINSTALLCONTEXT_USERUNMANAGED | MSIINSTALLCONTEXT_MACHINE),
    MSIINSTALLCONTEXT_ALLUSERMANAGED    = 8
} MSIINSTALLCONTEXT;

typedef enum tagMSIPATCHDATATYPE {
    MSIPATCH_DATATYPE_PATCHFILE = 0,
    MSIPATCH_DATATYPE_XMLPATH   = 1,
    MSIPATCH_DATATYPE_XMLBLOB   = 2
} MSIPATCHDATATYPE,*PMSIPATCHDATATYPE;

typedef struct tagMSIPATCHSEQUENCEINFOA {
    LPCSTR szPatchData;
    MSIPATCHDATATYPE ePatchDataType;
    DWORD dwOrder;
    UINT uStatus;
} MSIPATCHSEQUENCEINFOA,*PMSIPATCHSEQUENCEINFOA;

typedef struct tagMSIPATCHSEQUENCEINFOW {
    LPCWSTR szPatchData;
    MSIPATCHDATATYPE ePatchDataType;
    DWORD dwOrder;
    UINT uStatus;
} MSIPATCHSEQUENCEINFOW,*PMSIPATCHSEQUENCEINFOW;

#ifdef UNICODE
    #define MSIPATCHSEQUENCEINFO    MSIPATCHSEQUENCEINFOW
    #define PMSIPATCHSEQUENCEINFO   PMSIPATCHSEQUENCEINFOW
#else
    #define MSIPATCHSEQUENCEINFO    MSIPATCHSEQUENCEINFOA
    #define PMSIPATCHSEQUENCEINFO   PMSIPATCHSEQUENCEINFOA
#endif

#endif

#define MAX_FEATURE_CHARS 38

typedef enum tagSCRIPTFLAGS {
    SCRIPTFLAGS_CACHEINFO                   = 0x00000001L,
    SCRIPTFLAGS_SHORTCUTS                   = 0x00000004L,
    SCRIPTFLAGS_MACHINEASSIGN               = 0x00000008L,
    SCRIPTFLAGS_REGDATA_CNFGINFO            = 0x00000020L,
    SCRIPTFLAGS_VALIDATE_TRANSFORMS_LIST    = 0x00000040L,
#if (_WIN32_MSI >= 110)
    SCRIPTFLAGS_REGDATA_CLASSINFO           = 0x00000080L,
    SCRIPTFLAGS_REGDATA_EXTENSIONINFO       = 0x00000100L,
    SCRIPTFLAGS_REGDATA_APPINFO = SCRIPTFLAGS_REGDATA_CLASSINFO | SCRIPTFLAGS_REGDATA_EXTENSIONINFO,
#else
    SCRIPTFLAGS_REGDATA_APPINFO             = 0x00000010L,
#endif
    SCRIPTFLAGS_REGDATA = SCRIPTFLAGS_REGDATA_APPINFO | SCRIPTFLAGS_REGDATA_CNFGINFO
} SCRIPTFLAGS;

typedef enum tagADVERTISEFLAGS {
    ADVERTISEFLAGS_MACHINEASSIGN    = 0,
    ADVERTISEFLAGS_USERASSIGN       = 1
} ADVERTISEFLAGS;

typedef enum tagINSTALLTYPE {
    INSTALLTYPE_DEFAULT         = 0,
    INSTALLTYPE_NETWORK_IMAGE   = 1,
    INSTALLTYPE_SINGLE_INSTANCE = 2
} INSTALLTYPE;

#if (_WIN32_MSI >= 150)
typedef struct _MSIFILEHASHINFO {
    ULONG dwFileHashInfoSize;
    ULONG dwData [4 ];
} MSIFILEHASHINFO,*PMSIFILEHASHINFO;

typedef enum tagMSIARCHITECTUREFLAGS {
    MSIARCHITECTUREFLAGS_X86    = 0x00000001L,
    MSIARCHITECTUREFLAGS_IA64   = 0x00000002L,
    MSIARCHITECTUREFLAGS_AMD64  = 0x00000004L
} MSIARCHITECTUREFLAGS;

typedef enum tagMSIOPENPACKAGEFLAGS {
    MSIOPENPACKAGEFLAGS_IGNOREMACHINESTATE = 0x00000001L
} MSIOPENPACKAGEFLAGS;

typedef enum tagMSIADVERTISEOPTIONFLAGS {
    MSIADVERTISEOPTIONFLAGS_INSTANCE = 0x00000001L
} MSIADVERTISEOPTIONFLAGS;
#endif

#if (_WIN32_MSI >= 300)
typedef enum tagMSISOURCETYPE {
    MSISOURCETYPE_UNKNOWN   = 0x00000000L,
    MSISOURCETYPE_NETWORK   = 0x00000001L,
    MSISOURCETYPE_URL       = 0x00000002L,
    MSISOURCETYPE_MEDIA     = 0x00000004L
} MSISOURCETYPE;

typedef enum tagMSICODE {
    MSICODE_PRODUCT = 0x00000000L,
    MSICODE_PATCH   = 0x40000000L
} MSICODE;
#endif

#define INSTALLPROPERTY_PACKAGENAME         __TEXT("PackageName")
#define INSTALLPROPERTY_TRANSFORMS          __TEXT("Transforms")
#define INSTALLPROPERTY_LANGUAGE            __TEXT("Language")
#define INSTALLPROPERTY_PRODUCTNAME         __TEXT("ProductName")
#define INSTALLPROPERTY_ASSIGNMENTTYPE      __TEXT("AssignmentType")
#define INSTALLPROPERTY_PACKAGECODE         __TEXT("PackageCode")
#define INSTALLPROPERTY_VERSION             __TEXT("Version")
#define INSTALLPROPERTY_INSTALLEDPRODUCTNAME __TEXT("InstalledProductName")
#define INSTALLPROPERTY_VERSIONSTRING       __TEXT("VersionString")
#define INSTALLPROPERTY_HELPLINK            __TEXT("HelpLink")
#define INSTALLPROPERTY_HELPTELEPHONE       __TEXT("HelpTelephone")
#define INSTALLPROPERTY_INSTALLLOCATION     __TEXT("InstallLocation")
#define INSTALLPROPERTY_INSTALLSOURCE       __TEXT("InstallSource")
#define INSTALLPROPERTY_INSTALLDATE         __TEXT("InstallDate")
#define INSTALLPROPERTY_PUBLISHER           __TEXT("Publisher")
#define INSTALLPROPERTY_LOCALPACKAGE        __TEXT("LocalPackage")
#define INSTALLPROPERTY_URLINFOABOUT        __TEXT("URLInfoAbout")
#define INSTALLPROPERTY_URLUPDATEINFO       __TEXT("URLUpdateInfo")
#define INSTALLPROPERTY_VERSIONMINOR        __TEXT("VersionMinor")
#define INSTALLPROPERTY_VERSIONMAJOR        __TEXT("VersionMajor")
#define INSTALLPROPERTY_PRODUCTID           __TEXT("ProductID")
#define INSTALLPROPERTY_REGCOMPANY          __TEXT("RegCompany")
#define INSTALLPROPERTY_REGOWNER            __TEXT("RegOwner")
#if (_WIN32_MSI >= 110)
#define INSTALLPROPERTY_PRODUCTICON         __TEXT("ProductIcon")
#endif
#if (_WIN32_MSI >= 150)
#define INSTALLPROPERTY_INSTANCETYPE        __TEXT("InstanceType")
#endif
#if (_WIN32_MSI >= 300)
#define INSTALLPROPERTY_AUTHORIZED_LUA_APP  __TEXT("AuthorizedLUAApp")
#define INSTALLPROPERTY_UNINSTALLABLE       __TEXT("Uninstallable")
#define INSTALLPROPERTY_PRODUCTSTATE        __TEXT("State")
#define INSTALLPROPERTY_PATCHSTATE          __TEXT("State")
#define INSTALLPROPERTY_PATCHTYPE           __TEXT("PatchType")
#define INSTALLPROPERTY_LUAENABLED          __TEXT("LUAEnabled")
#define INSTALLPROPERTY_DISPLAYNAME         __TEXT("DisplayName")
#define INSTALLPROPERTY_MOREINFOURL         __TEXT("MoreInfoURL")
#define INSTALLPROPERTY_LASTUSEDSOURCE      __TEXT("LastUsedSource")
#define INSTALLPROPERTY_LASTUSEDTYPE        __TEXT("LastUsedType")
#define INSTALLPROPERTY_MEDIAPACKAGEPATH    __TEXT("MediaPackagePath")
#define INSTALLPROPERTY_DISKPROMPT          __TEXT("DiskPrompt")
#endif

#ifdef __cplusplus
extern "C" {
#endif

UINT WINAPI             MsiCloseHandle( MSIHANDLE );
UINT WINAPI             MsiCloseAllHandles( );

INSTALLUILEVEL WINAPI       MsiSetInternalUI( INSTALLUILEVEL, HWND * );
INSTALLUI_HANDLERA WINAPI   MsiSetExternalUIA( INSTALLUI_HANDLERA, DWORD, LPVOID );
INSTALLUI_HANDLERA WINAPI   MsiSetExternalUIW( INSTALLUI_HANDLERW, DWORD, LPVOID );

UINT WINAPI             MsiEnableLogA( DWORD, LPCSTR, DWORD );
UINT WINAPI             MsiEnableLogW( DWORD, LPCWSTR, DWORD );
INSTALLSTATE WINAPI     MsiQueryProductStateA( LPCSTR szProduct);
INSTALLSTATE WINAPI     MsiQueryProductStateW( LPCWSTR szProduct);
UINT WINAPI             MsiGetProductInfoA( LPCSTR, LPCSTR, LPSTR, DWORD * );
UINT WINAPI             MsiGetProductInfoW( LPCWSTR, LPCWSTR, LPWSTR, DWORD * );
UINT WINAPI             MsiInstallProductA( LPCSTR, LPCSTR );
UINT WINAPI             MsiInstallProductW( LPCWSTR, LPCWSTR );
UINT WINAPI             MsiConfigureProductA( LPCSTR, int, INSTALLSTATE );
UINT WINAPI             MsiConfigureProductW( LPCWSTR, int, INSTALLSTATE );
UINT WINAPI             MsiConfigureProductExA( LPCSTR, int, INSTALLSTATE, LPCSTR );
UINT WINAPI             MsiConfigureProductExW( LPCWSTR, int, INSTALLSTATE, LPCWSTR );
UINT WINAPI             MsiReinstallProductA( LPCSTR, DWORD );
UINT WINAPI             MsiReinstallProductW( LPCWSTR, DWORD );
UINT WINAPI             MsiAdvertiseProductA( LPCSTR, LPCSTR, LPCSTR, LANGID );
UINT WINAPI             MsiAdvertiseProductW( LPCWSTR, LPCWSTR, LPCWSTR, LANGID );
UINT WINAPI             MsiAdvertiseScriptA( LPCSTR, DWORD, PHKEY, BOOL );
UINT WINAPI             MsiAdvertiseScriptW( LPCWSTR, DWORD, PHKEY, BOOL );
UINT WINAPI             MsiGetProductInfoFromScriptA( LPCSTR, LPSTR, LANGID *, DWORD *, LPSTR, DWORD *, LPSTR, DWORD * );
UINT WINAPI             MsiGetProductInfoFromScriptW( LPCWSTR, LPWSTR, LANGID *, DWORD *, LPWSTR, DWORD *, LPWSTR, DWORD * );
UINT WINAPI             MsiGetProductCodeA( LPCSTR, LPSTR );
UINT WINAPI             MsiGetProductCodeW( LPCWSTR, LPWSTR );
USERINFOSTATE WINAPI    MsiGetUserInfoA( LPCSTR, LPSTR, DWORD *, LPSTR, DWORD *, LPSTR, DWORD * );
USERINFOSTATE WINAPI    MsiGetUserInfoW( LPCWSTR, LPWSTR, DWORD *, LPWSTR, DWORD *, LPWSTR, DWORD * );
UINT WINAPI             MsiCollectUserInfoA( LPCSTR );
UINT WINAPI             MsiCollectUserInfoW( LPCWSTR );
UINT WINAPI             MsiApplyPatchA( LPCSTR, LPCSTR, INSTALLTYPE, LPCSTR );
UINT WINAPI             MsiApplyPatchW( LPCWSTR, LPCWSTR, INSTALLTYPE, LPCWSTR );
UINT WINAPI             MsiGetPatchInfoA( LPCSTR, LPCSTR, LPSTR, DWORD * );
UINT WINAPI             MsiGetPatchInfoW( LPCWSTR, LPCWSTR, LPWSTR, DWORD * );
UINT WINAPI             MsiEnumPatchesA( LPCSTR, DWORD, LPSTR, LPSTR, DWORD * );
UINT WINAPI             MsiEnumPatchesW( LPCWSTR, DWORD, LPWSTR, LPWSTR, DWORD * );
INSTALLSTATE WINAPI     MsiQueryFeatureStateA( LPCSTR, LPCSTR );
INSTALLSTATE WINAPI     MsiQueryFeatureStateW( LPCWSTR, LPCWSTR );
INSTALLSTATE WINAPI     MsiUseFeatureA( LPCSTR, LPCSTR );
INSTALLSTATE WINAPI     MsiUseFeatureW( LPCWSTR, LPCWSTR );
INSTALLSTATE WINAPI     MsiUseFeatureExA( LPCSTR, LPCSTR, DWORD, DWORD );
INSTALLSTATE WINAPI     MsiUseFeatureExW( LPCWSTR, LPCWSTR, DWORD, DWORD );
UINT WINAPI             MsiGetFeatureUsageA( LPCSTR, LPCSTR, DWORD *, WORD * );
UINT WINAPI             MsiGetFeatureUsageW( LPCWSTR, LPCWSTR, DWORD *, WORD * );
UINT WINAPI             MsiConfigureFeatureA( LPCSTR, LPCSTR, INSTALLSTATE );
UINT WINAPI             MsiConfigureFeatureW( LPCWSTR, LPCWSTR, INSTALLSTATE );
UINT WINAPI             MsiReinstallFeatureA( LPCSTR, LPCSTR, DWORD );
UINT WINAPI             MsiReinstallFeatureW( LPCWSTR, LPCWSTR, DWORD );
UINT WINAPI             MsiProvideComponentA( LPCSTR, LPCSTR, LPCSTR, DWORD, LPSTR, DWORD * );
UINT WINAPI             MsiProvideComponentW( LPCWSTR, LPCWSTR, LPCWSTR, DWORD, LPWSTR, DWORD * );
UINT WINAPI             MsiProvideQualifiedComponentA( LPCSTR, LPCSTR, DWORD, LPSTR, DWORD * );
UINT WINAPI             MsiProvideQualifiedComponentW( LPCWSTR, LPCWSTR, DWORD, LPWSTR, DWORD * );
UINT WINAPI             MsiProvideQualifiedComponentExA( LPCSTR, LPCSTR, DWORD, LPCSTR, DWORD, DWORD, LPSTR, DWORD * );
UINT WINAPI             MsiProvideQualifiedComponentExW( LPCWSTR, LPCWSTR, DWORD, LPCWSTR, DWORD, DWORD, LPWSTR, DWORD * );
INSTALLSTATE WINAPI     MsiGetComponentPathA( LPCSTR, LPCSTR, LPSTR, DWORD * );
INSTALLSTATE WINAPI     MsiGetComponentPathW( LPCWSTR, LPCWSTR, LPWSTR, DWORD * );
UINT WINAPI             MsiEnumProductsA( DWORD, LPSTR );
UINT WINAPI             MsiEnumProductsW( DWORD, LPWSTR );
UINT WINAPI             MsiEnumFeaturesA( LPCSTR, DWORD, LPSTR, LPSTR );
UINT WINAPI             MsiEnumFeaturesW( LPCWSTR, DWORD, LPWSTR, LPWSTR );
UINT WINAPI             MsiEnumComponentsA( DWORD, LPSTR );
UINT WINAPI             MsiEnumComponentsW( DWORD, LPWSTR );
UINT WINAPI             MsiEnumClientsA( LPCSTR, DWORD, LPSTR );
UINT WINAPI             MsiEnumClientsW( LPCWSTR, DWORD, LPWSTR );
UINT WINAPI             MsiEnumComponentQualifiersA( LPCSTR, DWORD, LPSTR, DWORD *, LPSTR, DWORD * );
UINT WINAPI             MsiEnumComponentQualifiersW( LPCWSTR, DWORD, LPWSTR, DWORD *, LPWSTR, DWORD * );
UINT WINAPI             MsiOpenProductA( LPCSTR, MSIHANDLE * );
UINT WINAPI             MsiOpenProductW( LPCWSTR, MSIHANDLE * );
UINT WINAPI             MsiOpenPackageA( LPCSTR, MSIHANDLE * );
UINT WINAPI             MsiOpenPackageW( LPCWSTR, MSIHANDLE * );
UINT WINAPI             MsiGetProductPropertyA( MSIHANDLE, LPCSTR, LPSTR, DWORD * );
UINT WINAPI             MsiGetProductPropertyW( MSIHANDLE, LPCWSTR, LPWSTR, DWORD * );
UINT WINAPI             MsiVerifyPackageA( LPCSTR );
UINT WINAPI             MsiVerifyPackageW( LPCWSTR );
UINT WINAPI             MsiGetFeatureInfoA( MSIHANDLE, LPCSTR, DWORD *, LPSTR, DWORD *, LPSTR, DWORD * );
UINT WINAPI             MsiGetFeatureInfoW( MSIHANDLE, LPCWSTR, DWORD *, LPWSTR, DWORD *, LPWSTR, DWORD * );
UINT WINAPI             MsiInstallMissingComponentA( LPCSTR, LPCSTR, INSTALLSTATE );
UINT WINAPI             MsiInstallMissingComponentW( LPCWSTR, LPCWSTR, INSTALLSTATE );
UINT WINAPI             MsiInstallMissingFileA( LPCSTR, LPCSTR );
UINT WINAPI             MsiInstallMissingFileW( LPCWSTR, LPCWSTR );
INSTALLSTATE WINAPI     MsiLocateComponentA( LPCSTR, LPSTR, DWORD * );
INSTALLSTATE WINAPI     MsiLocateComponentW( LPCWSTR, LPWSTR, DWORD * );
UINT WINAPI             MsiGetFileVersionA( LPCSTR, LPSTR, DWORD *, LPSTR, DWORD * );
UINT WINAPI             MsiGetFileVersionW( LPCWSTR, LPWSTR, DWORD *, LPWSTR, DWORD * );

#ifdef UNICODE
    #define MsiSetExternalUI                MsiSetExternalUIW
    #define MsiEnableLog                    MsiEnableLogW
    #define MsiQueryProductState            MsiQueryProductStateW
    #define MsiGetProductInfo               MsiGetProductInfoW
    #define MsiInstallProduct               MsiInstallProductW
    #define MsiConfigureProduct             MsiConfigureProductW
    #define MsiConfigureProductEx           MsiConfigureProductExW
    #define MsiReinstallProduct             MsiReinstallProductW
    #define MsiAdvertiseProduct             MsiAdvertiseProductW
    #define MsiAdvertiseScript              MsiAdvertiseScriptW
    #define MsiGetProductInfoFromScript     MsiGetProductInfoFromScriptW
    #define MsiGetProductCode               MsiGetProductCodeW
    #define MsiGetUserInfo                  MsiGetUserInfoW
    #define MsiCollectUserInfo              MsiCollectUserInfoW
    #define MsiApplyPatch                   MsiApplyPatchW
    #define MsiGetPatchInfo                 MsiGetPatchInfoW
    #define MsiEnumPatches                  MsiEnumPatchesW
    #define MsiQueryFeatureState            MsiQueryFeatureStateW
    #define MsiUseFeature                   MsiUseFeatureW
    #define MsiUseFeatureEx                 MsiUseFeatureExW
    #define MsiGetFeatureUsage              MsiGetFeatureUsageW
    #define MsiConfigureFeature             MsiConfigureFeatureW
    #define MsiReinstallFeature             MsiReinstallFeatureW
    #define MsiProvideComponent             MsiProvideComponentW
    #define MsiProvideQualifiedComponent    MsiProvideQualifiedComponentW
    #define MsiProvideQualifiedComponentEx  MsiProvideQualifiedComponentExW
    #define MsiGetComponentPath             MsiGetComponentPathW
    #define MsiEnumProducts                 MsiEnumProductsW
    #define MsiEnumFeatures                 MsiEnumFeaturesW
    #define MsiEnumComponents               MsiEnumComponentsW
    #define MsiEnumClients                  MsiEnumClientsW
    #define MsiEnumComponentQualifiers      MsiEnumComponentQualifiersW
    #define MsiOpenProduct                  MsiOpenProductW
    #define MsiOpenPackage                  MsiOpenPackageW
    #define MsiGetProductProperty           MsiGetProductPropertyW
    #define MsiVerifyPackage                MsiVerifyPackageW
    #define MsiGetFeatureInfo               MsiGetFeatureInfoW
    #define MsiInstallMissingComponent      MsiInstallMissingComponentW
    #define MsiInstallMissingFile           MsiInstallMissingFileW
    #define MsiLocateComponent              MsiLocateComponentW
    #define MsiGetFileVersion               MsiGetFileVersionW
#else
    #define MsiSetExternalUI                MsiSetExternalUIA
    #define MsiEnableLog                    MsiEnableLogA
    #define MsiQueryProductState            MsiQueryProductStateA
    #define MsiGetProductInfo               MsiGetProductInfoA
    #define MsiInstallProduct               MsiInstallProductA
    #define MsiConfigureProduct             MsiConfigureProductA
    #define MsiConfigureProductEx           MsiConfigureProductExA
    #define MsiReinstallProduct             MsiReinstallProductA
    #define MsiAdvertiseProduct             MsiAdvertiseProductA
    #define MsiAdvertiseScript              MsiAdvertiseScriptA
    #define MsiGetProductInfoFromScript     MsiGetProductInfoFromScriptA
    #define MsiGetProductCode               MsiGetProductCodeA
    #define MsiGetUserInfo                  MsiGetUserInfoA
    #define MsiCollectUserInfo              MsiCollectUserInfoA
    #define MsiApplyPatch                   MsiApplyPatchA
    #define MsiGetPatchInfo                 MsiGetPatchInfoA
    #define MsiEnumPatches                  MsiEnumPatchesA
    #define MsiQueryFeatureState            MsiQueryFeatureStateA
    #define MsiUseFeature                   MsiUseFeatureA
    #define MsiUseFeatureEx                 MsiUseFeatureExA
    #define MsiGetFeatureUsage              MsiGetFeatureUsageA
    #define MsiConfigureFeature             MsiConfigureFeatureA
    #define MsiReinstallFeature             MsiReinstallFeatureA
    #define MsiProvideComponent             MsiProvideComponentA
    #define MsiProvideQualifiedComponent    MsiProvideQualifiedComponentA
    #define MsiProvideQualifiedComponentEx  MsiProvideQualifiedComponentExA
    #define MsiGetComponentPath             MsiGetComponentPathA
    #define MsiEnumProducts                 MsiEnumProductsA
    #define MsiEnumFeatures                 MsiEnumFeaturesA
    #define MsiEnumComponents               MsiEnumComponentsA
    #define MsiEnumClients                  MsiEnumClientsA
    #define MsiEnumComponentQualifiers      MsiEnumComponentQualifiersA
    #define MsiOpenProduct                  MsiOpenProductA
    #define MsiOpenPackage                  MsiOpenPackageA
    #define MsiGetProductProperty           MsiGetProductPropertyA
    #define MsiVerifyPackage                MsiVerifyPackageA
    #define MsiGetFeatureInfo               MsiGetFeatureInfoA
    #define MsiInstallMissingComponent      MsiInstallMissingComponentA
    #define MsiInstallMissingFile           MsiInstallMissingFileA
    #define MsiLocateComponent              MsiLocateComponentA
    #define MsiGetFileVersion               MsiGetFileVersionA
#endif


#if (_WIN32_MSI >= 110)
UINT WINAPI             MsiGetShortcutTargetA( LPCSTR, LPSTR, LPSTR, LPSTR );
UINT WINAPI             MsiGetShortcutTargetW( LPCWSTR, LPWSTR, LPWSTR, LPWSTR );
UINT WINAPI             MsiIsProductElevatedA( LPCSTR, BOOL * );
UINT WINAPI             MsiIsProductElevatedW( LPCWSTR, BOOL * );
UINT WINAPI             MsiEnumRelatedProductsA( LPCSTR, DWORD, DWORD, LPSTR );
UINT WINAPI             MsiEnumRelatedProductsW( LPCWSTR, DWORD, DWORD, LPWSTR );
UINT WINAPI             MsiSourceListClearAllA( LPCSTR, LPCSTR, DWORD );
UINT WINAPI             MsiSourceListClearAllW( LPCWSTR, LPCWSTR, DWORD );
UINT WINAPI             MsiSourceListAddSourceA( LPCSTR, LPCSTR, DWORD, LPCSTR );
UINT WINAPI             MsiSourceListAddSourceW( LPCWSTR, LPCWSTR, DWORD, LPCWSTR );
UINT WINAPI             MsiSourceListForceResolutionA( LPCSTR, LPCSTR, DWORD );
UINT WINAPI             MsiSourceListForceResolutionW( LPCWSTR, LPCWSTR, DWORD );
  
#ifdef UNICODE
    #define MsiGetShortcutTarget            MsiGetShortcutTargetW
    #define MsiIsProductElevated            MsiIsProductElevatedW
    #define MsiEnumRelatedProducts          MsiEnumRelatedProductsW
    #define MsiSourceListClearAll           MsiSourceListClearAllW
    #define MsiSourceListAddSource          MsiSourceListAddSourceW
    #define MsiSourceListForceResolution    MsiSourceListForceResolutionW
#else
    #define MsiGetShortcutTarget            MsiGetShortcutTargetA
    #define MsiIsProductElevated            MsiIsProductElevatedA
    #define MsiEnumRelatedProducts          MsiEnumRelatedProductsA
    #define MsiSourceListClearAll           MsiSourceListClearAllA
    #define MsiSourceListAddSource          MsiSourceListAddSourceA
    #define MsiSourceListForceResolution    MsiSourceListForceResolutionA
#endif
  
#endif /* _WIN32_MSI >= 110 */

#if (_WIN32_MSI >= 150)
UINT WINAPI             MsiGetFileHashA( LPCSTR, DWORD, PMSIFILEHASHINFO );
UINT WINAPI             MsiGetFileHashW( LPCWSTR, DWORD, PMSIFILEHASHINFO );
UINT WINAPI             MsiAdvertiseProductExA( LPCSTR, LPCSTR, LPCSTR, LANGID, DWORD, DWORD );
UINT WINAPI             MsiAdvertiseProductExW( LPCWSTR, LPCWSTR, LPCWSTR, LANGID, DWORD, DWORD );
UINT WINAPI             MsiProcessAdvertiseScriptA( LPCSTR, LPCSTR, HKEY, BOOL, BOOL );
UINT WINAPI             MsiProcessAdvertiseScriptW( LPCWSTR, LPCWSTR, HKEY, BOOL, BOOL );

#define MSIASSEMBLYINFO_NETASSEMBLY 0
#define MSIASSEMBLYINFO_WIN32ASSEMBLY 1

UINT WINAPI             MsiProvideAssemblyA( LPCSTR, LPCSTR, DWORD, DWORD, LPSTR, DWORD * );
UINT WINAPI             MsiProvideAssemblyW( LPCWSTR, LPCWSTR, DWORD, DWORD, LPWSTR, DWORD * );
UINT WINAPI             MsiOpenPackageExA( LPCSTR, DWORD, MSIHANDLE * );
UINT WINAPI             MsiOpenPackageExW( LPCWSTR, DWORD, MSIHANDLE * );

#ifdef UNICODE
    #define MsiGetFileHash                  MsiGetFileHashW
    #define MsiAdvertiseProductEx           MsiAdvertiseProductExW
    #define MsiProcessAdvertiseScript       MsiProcessAdvertiseScriptW
    #define MsiProvideAssembly              MsiProvideAssemblyW
    #define MsiOpenPackageEx                MsiOpenPackageExW
#else
    #define MsiGetFileHash                  MsiGetFileHashA
    #define MsiAdvertiseProductEx           MsiAdvertiseProductExA
    #define MsiProcessAdvertiseScript       MsiProcessAdvertiseScriptA
    #define MsiProvideAssembly              MsiProvideAssemblyA
    #define MsiOpenPackageEx                MsiOpenPackageExA
#endif

#ifndef _MSI_NO_CRYPTO

HRESULT WINAPI          MsiGetFileSignatureInformationA( LPCSTR, DWORD, PCCERT_CONTEXT *, BYTE *, DWORD * );
HRESULT WINAPI          MsiGetFileSignatureInformationW( LPCWSTR, DWORD, PCCERT_CONTEXT *, BYTE *, DWORD * );

#ifdef UNICODE
    #define MsiGetFileSignatureInformation  MsiGetFileSignatureInformationW
#else
    #define MsiGetFileSignatureInformation  MsiGetFileSignatureInformationA
#endif

#define MSI_INVALID_HASH_IS_FATAL 0x1

#endif /* _MSI_NO_CRYPTO */
#endif /* _WIN32_MSI >= 150 */

#if (_WIN32_MSI >= 300)

UINT WINAPI             MsiGetProductInfoExA( LPCSTR, LPCSTR, MSIINSTALLCONTEXT, LPCSTR, LPSTR, LPDWORD );
UINT WINAPI             MsiGetProductInfoExW( LPCWSTR, LPCWSTR, MSIINSTALLCONTEXT, LPCWSTR, LPWSTR, LPDWORD );
UINT WINAPI             MsiRemovePatchesA( LPCSTR, LPCSTR, INSTALLTYPE, LPCSTR );
UINT WINAPI             MsiRemovePatchesW( LPCWSTR, LPCWSTR, INSTALLTYPE, LPCWSTR );
UINT WINAPI             MsiExtractPatchXMLDataA( LPCSTR, DWORD, LPSTR, DWORD * );
UINT WINAPI             MsiExtractPatchXMLDataW( LPCWSTR, DWORD, LPWSTR, DWORD * );
UINT WINAPI             MsiGetPatchInfoExA( LPCSTR, LPCSTR, LPCSTR, MSIINSTALLCONTEXT, LPCSTR, LPSTR, DWORD * );
UINT WINAPI             MsiGetPatchInfoExW( LPCWSTR, LPCWSTR, LPCWSTR, MSIINSTALLCONTEXT, LPCWSTR, LPWSTR, DWORD * );
UINT WINAPI             MsiApplyMultiplePatchesA( LPCSTR, LPCSTR, LPCSTR );
UINT WINAPI             MsiApplyMultiplePatchesW( LPCWSTR, LPCWSTR, LPCWSTR );
UINT WINAPI             MsiDeterminePatchSequenceA( LPCSTR, LPCSTR, MSIINSTALLCONTEXT, DWORD, PMSIPATCHSEQUENCEINFOA );
UINT WINAPI             MsiDeterminePatchSequenceW( LPCWSTR, LPCWSTR, MSIINSTALLCONTEXT, DWORD, PMSIPATCHSEQUENCEINFOW );
UINT WINAPI             MsiDetermineApplicablePatchesA( LPCSTR, DWORD, PMSIPATCHSEQUENCEINFOA );
UINT WINAPI             MsiDetermineApplicablePatchesW( LPCWSTR, DWORD, PMSIPATCHSEQUENCEINFOW );
UINT WINAPI             MsiEnumPatchesExA( LPCSTR, LPCSTR, DWORD, DWORD, DWORD, CHAR[39], CHAR[39], MSIINSTALLCONTEXT *, LPSTR, LPDWORD );
UINT WINAPI             MsiEnumPatchesExW( LPCWSTR, LPCWSTR, DWORD, DWORD, DWORD, WCHAR[39],WCHAR[39], MSIINSTALLCONTEXT *, LPWSTR, LPDWORD );
UINT WINAPI             MsiQueryFeatureStateExA( LPCSTR, LPCSTR, MSIINSTALLCONTEXT, LPCSTR, INSTALLSTATE * );
UINT WINAPI             MsiQueryFeatureStateExW( LPCWSTR, LPCWSTR, MSIINSTALLCONTEXT, LPCWSTR, INSTALLSTATE * );
UINT WINAPI             MsiQueryComponentStateA( LPCSTR, LPCSTR, MSIINSTALLCONTEXT, LPCSTR, INSTALLSTATE * );
UINT WINAPI             MsiQueryComponentStateW( LPCWSTR, LPCWSTR, MSIINSTALLCONTEXT, LPCWSTR, INSTALLSTATE * );
UINT WINAPI             MsiEnumProductsExA( LPCSTR, LPCSTR, DWORD, DWORD, CHAR[39], MSIINSTALLCONTEXT *, LPSTR, LPDWORD );
UINT WINAPI             MsiEnumProductsExW( LPCWSTR, LPCWSTR, DWORD, DWORD, WCHAR[39], MSIINSTALLCONTEXT *, LPWSTR, LPDWORD );
UINT WINAPI             MsiSourceListAddSourceExA( LPCSTR, LPCSTR, MSIINSTALLCONTEXT, DWORD, LPCSTR, DWORD );
UINT WINAPI             MsiSourceListAddSourceExW( LPCWSTR, LPCWSTR, MSIINSTALLCONTEXT, DWORD, LPCWSTR, DWORD );
UINT WINAPI             MsiSourceListAddMediaDiskA( LPCSTR, LPCSTR, MSIINSTALLCONTEXT, DWORD, DWORD, LPCSTR, LPCSTR );
UINT WINAPI             MsiSourceListAddMediaDiskW( LPCWSTR, LPCWSTR, MSIINSTALLCONTEXT, DWORD, DWORD, LPCWSTR, LPCWSTR );
UINT WINAPI             MsiSourceListClearSourceA( LPCSTR, LPCSTR, MSIINSTALLCONTEXT, DWORD, LPCSTR );
UINT WINAPI             MsiSourceListClearSourceW( LPCWSTR, LPCWSTR, MSIINSTALLCONTEXT, DWORD, LPCWSTR );
UINT WINAPI             MsiSourceListClearMediaDiskA( LPCSTR, LPCSTR, MSIINSTALLCONTEXT, DWORD, DWORD );
UINT WINAPI             MsiSourceListClearMediaDiskW( LPCWSTR, LPCWSTR, MSIINSTALLCONTEXT, DWORD, DWORD );
UINT WINAPI             MsiSourceListClearAllExA( LPCSTR, LPCSTR, MSIINSTALLCONTEXT, DWORD );
UINT WINAPI             MsiSourceListClearAllExW( LPCWSTR, LPCWSTR, MSIINSTALLCONTEXT, DWORD );
UINT WINAPI             MsiSourceListForceResolutionExA( LPCSTR, LPCSTR, MSIINSTALLCONTEXT, DWORD );
UINT WINAPI             MsiSourceListForceResolutionExW( LPCWSTR, LPCWSTR, MSIINSTALLCONTEXT, DWORD );
UINT WINAPI             MsiSourceListSetInfoA( LPCSTR, LPCSTR, MSIINSTALLCONTEXT, DWORD, LPCSTR, LPCSTR );
UINT WINAPI             MsiSourceListSetInfoW( LPCWSTR, LPCWSTR, MSIINSTALLCONTEXT, DWORD, LPCWSTR, LPCWSTR );
UINT WINAPI             MsiSourceListGetInfoA( LPCSTR, LPCSTR, MSIINSTALLCONTEXT, DWORD, LPCSTR, LPSTR, LPDWORD );
UINT WINAPI             MsiSourceListGetInfoW( LPCWSTR, LPCWSTR, MSIINSTALLCONTEXT, DWORD, LPCWSTR, LPWSTR, LPDWORD 
UINT WINAPI             MsiSourceListEnumSourcesA( LPCSTR, LPCSTR, MSIINSTALLCONTEXT, DWORD, DWORD, LPSTR, LPDWORD );
UINT WINAPI             MsiSourceListEnumSourcesW( LPCWSTR, LPCWSTR, MSIINSTALLCONTEXT, DWORD, DWORD, LPWSTR, LPDWORD );
UINT WINAPI             MsiSourceListEnumMediaDisksA( LPCSTR, LPCSTR, MSIINSTALLCONTEXT, DWORD, DWORD, LPDWORD, LPSTR, LPDWORD, LPSTR, LPDWORD );
UINT WINAPI             MsiSourceListEnumMediaDisksW( LPCWSTR, LPCWSTR, MSIINSTALLCONTEXT, DWORD, DWORD, LPDWORD, LPWSTR, LPDWORD, LPWSTR, LPDWORD );

#ifdef UNICODE
    #define INSTALLUI_HANDLER               INSTALLUI_HANDLERW
    
    #define MsiGetProductInfoEx             MsiGetProductInfoExW
    #define MsiRemovePatches                MsiRemovePatchesW
    #define MsiExtractPatchXMLData          MsiExtractPatchXMLDataW
    #define MsiGetPatchInfoEx               MsiGetPatchInfoExW
    #define MsiApplyMultiplePatches         MsiApplyMultiplePatchesW
    #define MsiDeterminePatchSequence       MsiDeterminePatchSequenceW
    #define MsiDetermineApplicablePatches   MsiDetermineApplicablePatchesW
    #define MsiEnumPatchesEx                MsiEnumPatchesExW
    #define MsiQueryFeatureStateEx          MsiQueryFeatureStateExW
    #define MsiQueryComponentState          MsiQueryComponentStateW
    #define MsiEnumProductsEx               MsiEnumProductsExW
    #define MsiSourceListAddSourceEx        MsiSourceListAddSourceExW
    #define MsiSourceListAddMediaDisk       MsiSourceListAddMediaDiskW
    #define MsiSourceListClearSource        MsiSourceListClearSourceW
    #define MsiSourceListClearMediaDisk     MsiSourceListClearMediaDiskW
    #define MsiSourceListClearAllEx         MsiSourceListClearAllExW
    #define MsiSourceListForceResolutionEx  MsiSourceListForceResolutionExW
    #define MsiSourceListSetInfo            MsiSourceListSetInfoW
    #define MsiSourceListGetInfo            MsiSourceListGetInfoW
    #define MsiSourceListEnumSources        MsiSourceListEnumSourcesW
    #define MsiSourceListEnumMediaDisks     MsiSourceListEnumMediaDisksW
#else
    #define INSTALLUI_HANDLER               INSTALLUI_HANDLERA
    
    #define MsiGetProductInfoEx             MsiGetProductInfoExA
    #define MsiRemovePatches                MsiRemovePatchesA
    #define MsiExtractPatchXMLData          MsiExtractPatchXMLDataA
    #define MsiGetPatchInfoEx               MsiGetPatchInfoExA
    #define MsiApplyMultiplePatches         MsiApplyMultiplePatchesA
    #define MsiDeterminePatchSequence       MsiDeterminePatchSequenceA
    #define MsiDetermineApplicablePatches   MsiDetermineApplicablePatchesA
    #define MsiEnumPatchesEx                MsiEnumPatchesExA
    #define MsiQueryFeatureStateEx          MsiQueryFeatureStateExA
    #define MsiQueryComponentState          MsiQueryComponentStateA
    #define MsiEnumProductsEx               MsiEnumProductsExA
    #define MsiSourceListAddSourceEx        MsiSourceListAddSourceExA
    #define MsiSourceListAddMediaDisk       MsiSourceListAddMediaDiskA
    #define MsiSourceListClearSource        MsiSourceListClearSourceA
    #define MsiSourceListClearMediaDisk     MsiSourceListClearMediaDiskA
    #define MsiSourceListClearAllEx         MsiSourceListClearAllExA
    #define MsiSourceListForceResolutionEx  MsiSourceListForceResolutionExA
    #define MsiSourceListSetInfo            MsiSourceListSetInfoA
    #define MsiSourceListGetInfo            MsiSourceListGetInfoA
    #define MsiSourceListEnumSources        MsiSourceListEnumSourcesA
    #define MsiSourceListEnumMediaDisks     MsiSourceListEnumMediaDisksA
#endif

#endif /* _WIN32_MSI >= 300 */

#if (_WIN32_MSI >= 310)
  
UINT WINAPI             MsiSetExternalUIRecord( INSTALLUI_HANDLER_RECORD, DWORD, LPVOID, PINSTALLUI_HANDLER_RECORD );
UINT WINAPI             MsiNotifySidChangeA( LPCSTR, LPCSTR );
UINT WINAPI             MsiNotifySidChangeW( LPCWSTR, LPCWSTR );
  
#ifdef UNICODE
    #define MsiNotifySidChange              MsiNotifySidChangeW
#else
    #define MsiNotifySidChange              MsiNotifySidChangeA
#endif

#endif /* _WIN32_MSI >= 310 */

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* _MSI_H_ */
