/*
 *  mprapi.h    Multiple Provider Router (MPR) functions
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2014 The Open Watcom Contributors. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */

#ifndef __ROUTING_MPRADMIN_H__
#define __ROUTING_MPRADMIN_H__

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file;
#endif

#include <lmcons.h>
#include <ras.h>
#include <in6addr.h>
#include <wincrypt.h>

#ifdef __cplusplus
extern "C" {
#endif

/* Server handles */
typedef HANDLE  RAS_SERVER_HANDLE;
typedef HANDLE  MPR_SERVER_HANDLE;
typedef HANDLE  MIB_SERVER_HANDLE;

/* Remoting and Remote Access Service (RRAS) name */
#define RRAS_SERVICE_NAME   TEXT("RemoteAccess")

/* Protocol identifiers */
#define PID_IPX     0x0000002BL
#define PID_IP      0x00000021L
#define PID_IPV6    0x00000057L
#define PID_NBF     0x0000003FL
#define PID_ATALK   0x00000029L

/* Maximum lengths */
#define MAX_INTERFACE_NAME_LEN  256
#define MAX_TRANSPORT_NAME_LEN  40
#define MAX_MEDIA_NAME          16
#define MAX_PORT_NAME           16
#define MAX_DEVICE_NAME         128
#define MAX_PHONE_NUMBER_LEN    128
#define MAX_DEVICETYPE_NAME     16

/* MPR interface flags */
#define MPR_INTERFACE_OUT_OF_RESOURCES          0x00000001L
#define MPR_INTERFACE_ADMIN_DISABLED            0x00000002L
#define MPR_INTERFACE_CONNECTION_FAILURE        0x00000004L
#define MPR_INTERFACE_SERVICE_PAUSED            0x00000008L
#define MPR_INTERFACE_DIALOUT_HOURS_RESTRICTION 0x00000010L
#define MPR_INTERFACE_NO_MEDIA_SENSE            0x00000020L
#define MPR_INTERFACE_NO_DEVICE                 0x00000040L

/* Aliases of maximum lengths from RAS */
#if (WINVER >= 0x0500)
    #define MPR_MaxDeviceType       RAS_MaxDeviceType
    #define MPR_MaxPhoneNumber      RAS_MaxPhoneNumber
    #define MPR_MaxIpAddress        RAS_MaxIpAddress
    #define MPR_MaxIpxAddress       RAS_MaxIpxAddress
    #define MPR_MaxEntryName        RAS_MaxEntryName
    #define MPR_MaxDeviceName       RAS_MaxDeviceName
    #define MPR_MaxCallbackNumber   RAS_MaxCallbackNumber
    #define MPR_MaxAreaCode         RAS_MaxAreaCode
    #define MPR_MaxPadType          RAS_MaxPadType
    #define MPR_MaxX25Address       RAS_MaxX25Address
    #define MPR_MaxFacilities       RAS_MaxFacilities
    #define MPR_MaxUserData         RAS_MaxUserData
#endif

/* MPR interface options */
#if (WINVER >= 0x0500)
    #define MPRIO_SpecificIpAddr        RASEO_SpecificIpAddr
    #define MPRIO_SpecificNameServers   RASEO_SpecificNameServers
    #define MPRIO_IpHeaderCompression   RASEO_IpHeaderCompression
    #define MPRIO_RemoteDefaultGateway  RASEO_RemoteDefaultGateway
    #define MPRIO_DisableLcpExtensions  RASEO_DisableLcpExtensions
    #define MPRIO_SwCompression         RASEO_SwCompression
    #define MPRIO_RequireEncryptedPw    RASEO_RequireEncryptedPw
    #define MPRIO_RequireMsEncryptedPw  RASEO_RequireMsEncryptedPw
    #define MPRIO_RequireDataEncryption RASEO_RequireDataEncryption
    #define MPRIO_NetworkLogon          RASEO_NetworkLogon
    #define MPRIO_PromoteAlternates     RASEO_PromoteAlternates
    #define MPRIO_SecureLocalFiles      RASEO_SecureLocalFiles
    #define MPRIO_RequireEAP            RASEO_RequireEAP
    #define MPRIO_RequirePAP            RASEO_RequirePAP
    #define MPRIO_RequireSPAP           RASEO_RequireSPAP
    #define MPRIO_SharedPhoneNumbers    RASEO_SharedPhoneNumbers
    #define MPRIO_RequireCHAP           RASEO_RequireCHAP
    #define MPRIO_RequireMsCHAP         RASEO_RequireMsCHAP
    #define MPRIO_RequireMsCHAP2        RASEO_RequireMsCHAP2
#endif
#if (WINVER >= 0x0501)
    #define MPRIO_IpSecPreSharedKey     0x80000000L
#endif

/* MPR interface protocols */
#if (WINVER >= 0x0500)
    #define MPRNP_Ipx   RASNP_Ipx
    #define MPRNP_Ip    RASNP_Ip
#endif
#if (WINVER >= 0x0600)
    #define MRPNP_IPv6  RASNP_Ipv6
#endif

/* MPR interface device types */
#if (WINVER >= 0x0500)
    #define MPRDT_Modem         RASDT_Modem
    #define MPRDT_Isdn          RASDT_Isdn
    #define MPRDT_X25           RASDT_X25
    #define MPRDT_Vpn           RASDT_Vpn
    #define MPRDT_Pad           RASDT_Pad
    #define MPRDT_Generic       RASDT_Generic
    #define MPRDT_Serial        RASDT_Serial
    #define MPRDT_FrameRelay    RASDT_FrameRelay
    #define MPRDT_Atm           RASDT_Atm
    #define MPRDT_Sonet         RASDT_Sonet
    #define MPRDT_SW56          RASDT_SW56
    #define MRPDT_Irda          RASDT_Irda
    #define MPRDT_Parallel      RASDT_Parallel
#endif

/* MPR interface types */
#if (WINVER >= 0x0500)
    #define MPRET_Phone     RASET_Phone
    #define MPRET_Vpn       RASET_Vpn
    #define MPRET_Direct    RASET_Direct
#endif

/* MPR interface dial modes */
#if (WINVER >= 0x0500)
    #define MPRDM_DialFirst     0L
    #define MPRDM_DialAll       RASEDM_DialAll
    #define MPRDM_DialAsNeeded  RASEDM_DialAsNeeded
#endif

/* MPR interface idle disconnect seconds special values */
#if (WINVER >= 0x0500)
    #define MPRIDS_Disabled         RASIDS_Disabled
    #define MPRIDS_UseGlobalValue   RASIDS_UseGlobalValue
#endif

/* MPR interface encryption types */
#if (WINVER >= 0x0500)
    #define MPR_ET_None         ET_None
    #define MPR_ET_Require      ET_Require
    #define MPR_ET_RequireMax   ET_RequireMax
    #define MPR_ET_Optional     ET_Optional
#endif

/* MPR interface VPN strategies */
#if (WINVER >= 0x0500)
    #define MPR_VS_Default      VS_Default
    #define MPR_VS_PptpOnly     VS_PptpOnly
    #define MPR_VS_PptpFirst    VS_PptpFirst
    #define MPR_VS_L2tpOnly     VS_L2tpOnly
    #define MPR_VS_L2tpFirst    VS_L2tpFirst
#endif

/* MPR server flags */
#if (WINVER >= 0x0501)
    #define MPR_ENABLE_RAS_ON_DEVICE        0x00000001L
    #define MPR_ENABLE_ROUTING_ON_DEVICE    0x00000002L
#endif

/* Address lengths */
#define IPADDRESSLEN    15
#define IPXADDRESSLEN   22
#define ATADDRESSLEN    32
#define MAXIPADRESSLEN  64

/* PPP IPCP options */
#define PPP_IPCP_VJ 0x00000001L

/* PPP compression control protocol compression algorithms */
#if (WINVER >= 0x0500)
    #define RASCCPCA_MPPC   0x00000006L
    #define RASCCPCA_STAC   0x00000005L
#endif

/* PPP compression control protocol options */
#if (WINVER >= 0x0500)
    #define PPP_CCP_COMPRESSION         0x00000001L
    #define PPP_CCP_ENCRYPTION40BITOLD  0x00000010L
    #define PPP_CPP_ENCRYPTION40BIT     0x00000020L
    #define PPP_CCP_ENCRYPTION128BIT    0x00000040L
    #define PPP_CCP_ENCRYPTION56BIT     0x00000080L
    #define PPP_CCP_HISTORYLESS         0x01000000L
#endif

/* PPP link control protocol authentication options */
#if (WINVER >= 0x0500)
    #define PPP_LCP_PAP     0xC023
    #define PPP_LCP_SPAP    0xC027
    #define PPP_LCP_CHAP    0xC223
    #define PPP_LCP_EAP     0xC227
#endif

/* PPP link control protocol authentication data */
#if (WINVER >= 0x0500)
    #define PPP_LCP_CHAP_MD5    0x05
    #define PPP_LCP_CHAP_MS     0x80
    #define PPP_LCP_CHAP_MSV2   0x81
#endif

/* PPP link control protocol options */
#if (WINVER >= 0x0500)
    #define PPP_LCP_MULTILINK_FRAMING   0x00000001L
    #define PPP_LCP_PFC                 0x00000002L
    #define PPP_LCP_ACFC                0x00000004L
    #define PPP_LCP_SSHF                0x00000008L
    #define PPP_LCP_DES_56              0x00000010L
    #define PPP_LCP_3_DES               0x00000020L
#endif
#if (WINVER >= 0x0600)
    #define PPP_LCP_AES_128             0x00000040L
    #define PPP_LCP_AES_256             0x00000080L
#endif

/* RAS connection flags */
#define RAS_FLAGS_PPP_CONNECTION        0x00000001L
#define RAS_FLAGS_MESSENGER_PRESENT     0x00000002L
#if (WINVER < 0x0501)
    #define RAS_FLAGS_RAS_CONNECTION    0x00000004L
#endif
#define RAS_FLAGS_QUARANTINE_PRESENT    0x00000008L
#if (WINVER >= 0x0601)
    #define RAS_FLAGS_DORMANT           0x00000020L
#endif

/* RAS privileges */
#define RASPRIV_NoCallback          0x01
#define RASPRIV_AdminSetCallback    0x02
#define RASPRIV_CallerSetCallback   0x04
#define RASPRIV_DialinPrivilege     0x08
#define RASPRIV_CallbackType \
    (RASPRIV_AdminSetCallback | RASPRIV_CallerSetCallback | RASPRIV_NoCallback)

/* RAS secondary privileges */
#define RASPRIV2_DialinPolicy       0x01

/* IKEv2 authentication types */
#if (WINVER >= 0x0601)
    #define MPRAPI_IKEV2_AUTH_USING_CERT    1L
    #define MPRAPI_IKEV2_AUTH_USING_EAP     2L
#endif

/* Projection information types */
#if (WINVER >= 0x0601)
    #define MPRAPI_PPP_PROJECTION_INFO_TYPE     1
    #define MPRAPI_IKEV2_PROJECTION_INFO_TYPE   2
#endif

/* MPRAPI object revision numbers */
#if (WINVER >= 0x0601)
    #define MPRAPI_RAS_CONNECTION_OBJECT_REVISION_1         0x01
    #define MPRAPI_MPR_SERVER_OBJECT_REVISION_1             0x01
    #define MPRAPI_MPR_SERVER_SET_CONFIG_OBJECT_REVISION_1  0x01
    #define MPRAPI_RAS_UPDATE_CONNECTION_OBJECT_REVISION_1  0x01
#endif

/* Tunnel configuration parameter flags */
#if (WINVER >= 0x0601)
    #define MPRAPI_IKEV2_SET_TUNNEL_CONFIG_PARAMS   0x00000001L
#endif

/* Maximum SSTP hash size */
#if (WINVER >= 0x0601)
    #define MAX_SSTP_HASH_SIZE  32
#endif

/* Configuration protocol tunnel types */
#if (WINVER >= 0x0601)
    #define MPRAPI_SET_CONFIG_PROTOCOL_FOR_PPTP     0x00000001L
    #define MPRAPI_SET_CONFIG_PROTOCOL_FOR_L2TP     0x00000002L
    #define MPRAPI_SET_CONFIG_PROTOCOL_FOR_SSTP     0x00000004L
    #define MPRAPI_SET_CONFIG_PROTOCOL_FOR_IKEV2    0x00000008L
#endif

/* Authentication constants */
#if (WINVER >= 0x0601)
    #define ALLOW_NO_AUTH           1
    #define DO_NOT_ALLOW_NO_AUTH    2
#endif

/* MPRAPI administration DLL version numbers */
#if (WINVER >= 0x0601)
    #define MPRAPI_ADMIN_DLL_VERSION_1  0x00000001L
    #define MPRAPI_ADMIN_DLL_VERSION_2  0x00000002L
#endif

/* Router interface types */
typedef enum _ROUTER_INTERFACE_TYPE {
    ROUTER_IF_TYPE_CLIENT       = 0,
    ROUTER_IF_TYPE_HOME_ROUTER  = 1,
    ROUTER_IF_TYPE_FULL_ROUTER  = 2,
    ROUTER_IF_TYPE_DEDICATED    = 3,
    ROUTER_IF_TYPE_INTERNAL     = 4,
    ROUTER_IF_TYPE_LOOPBACK     = 5,
    ROUTER_IF_TYPE_TUNNEL1      = 6,
    ROUTER_IF_TYPE_DIALOUT      = 7,
    ROUTER_IF_TYPE_MAX          = 8
} ROUTER_INTERFACE_TYPE;

/* Router connection states */
typedef enum _ROUTER_CONNECTION_STATE {
    ROUTER_IF_STATE_UNREACHABLE     = 0,
    ROUTER_IF_STATE_DISCONNECTED    = 1,
    ROUTER_IF_STATE_CONNECTING      = 2,
    ROUTER_IF_STATE_CONNECTED       = 3
} ROUTER_CONNECTION_STATE;

/* MPR interface (level 0) */
typedef struct _MPR_INTERFACE_0 {
    WCHAR                   wszInterfaceName[MAX_INTERFACE_NAME_LEN + 1];
    HANDLE                  hInterface;
    BOOL                    fEnabled;
    ROUTER_INTERFACE_TYPE   dwIfType;
    ROUTER_CONNECTION_STATE dwConnectionState;
    DWORD                   fUnReachabilityReasons;
    DWORD                   dwLastError;
} MPR_INTERFACE_0;
typedef MPR_INTERFACE_0 *PMPR_INTERFACE_0;

/* MPR interface (level 1) */
#if (WINVER >= 0x0500)
typedef struct _MPR_INTERFACE_1 {
    WCHAR                   wszInterfaceName[MAX_INTERFACE_NAME_LEN + 1];
    HANDLE                  hInterface;
    BOOL                    fEnabled;
    ROUTER_INTERFACE_TYPE   dwIfType;
    ROUTER_CONNECTION_STATE dwConnectionState;
    DWORD                   fUnReachabilityReasons;
    DWORD                   dwLastError;
    LPWSTR                  lpwsDialoutHoursRestriction;
} MPR_INTERFACE_1;
typedef MPR_INTERFACE_1 *PMPR_INTERFACE_1;
#endif

/* MPR interface (level 2) */
#if (WINVER >= 0x0500)
typedef struct _MPR_INTERFACE_2 {
    WCHAR                   wszInterfaceName[MAX_INTERFACE_NAME_LEN + 1];
    HANDLE                  hInterface;
    BOOL                    fEnabled;
    ROUTER_INTERFACE_TYPE   dwIfType;
    ROUTER_CONNECTION_STATE dwConnectionState;
    DWORD                   fUnReachabilityReasons;
    DWORD                   dwLastError;
    DWORD                   dwfOptions;
    WCHAR                   szLocalPhoneNumber[RAS_MaxPhoneNumber + 1];
    PWCHAR                  szAlternates;
    DWORD                   ipaddr;
    DWORD                   ipaddrDns;
    DWORD                   ipaddrDnsAlt;
    DWORD                   ipaddrWins;
    DWORD                   ipaddrWinsAlt;
    DWORD                   dwfNetProtocols;
    WCHAR                   szDeviceType[MPR_MaxDeviceType + 1];
    WCHAR                   szDeviceName[MPR_MaxDeviceName + 1];
    WCHAR                   szX25PadType[MPR_MaxPadType + 1];
    WCHAR                   szX25Address[MPR_MaxX25Address + 1];
    WCHAR                   szX25Facilities[MPR_MaxFacilities + 1];
    WCHAR                   szX25UserData[MPR_MaxUserData + 1];
    DWORD                   dwChannels;
    DWORD                   dwSubEntries;
    DWORD                   dwDialMode;
    DWORD                   dwDialExtraPercent;
    DWORD                   dwDialExtraSampleSeconds;
    DWORD                   dwHangUpExtraPercent;
    DWORD                   dwHangUpExtraSampleSeconds;
    DWORD                   dwIdleDisconnectSeconds;
    DWORD                   dwType;
    DWORD                   dwEncryptionType;
    DWORD                   dwCustomAuthKey;
    DWORD                   dwCustomAuthDataSize;
    LPBYTE                  lpbCustomAuthData;
    GUID                    guidId;
    DWORD                   dwVpnStrategy;
} MPR_INTERFACE_2;
typedef MPR_INTERFACE_2 *PMPR_INTERFACE_2;
#endif

/* MPR interface (level 3) */
#if (WINVER >= 0x0600)
typedef struct _MPR_INTERFACE_3 {
    WCHAR                   wszInterfaceName[MAX_INTERFACE_NAME_LEN + 1];
    HANDLE                  hInterface;
    BOOL                    fEnabled;
    ROUTER_INTERFACE_TYPE   dwIfType;
    ROUTER_CONNECTION_STATE dwConnectionState;
    DWORD                   fUnReachabilityReasons;
    DWORD                   dwLastError;
    DWORD                   dwfOptions;
    WCHAR                   szLocalPhoneNumber[RAS_MaxPhoneNumber + 1];
    PWCHAR                  szAlternates;
    DWORD                   ipaddr;
    DWORD                   ipaddrDns;
    DWORD                   ipaddrDnsAlt;
    DWORD                   ipaddrWins;
    DWORD                   ipaddrWinsAlt;
    DWORD                   dwfNetProtocols;
    WCHAR                   szDeviceType[MPR_MaxDeviceType + 1];
    WCHAR                   szDeviceName[MPR_MaxDeviceName + 1];
    WCHAR                   szX25PadType[MPR_MaxPadType + 1];
    WCHAR                   szX25Address[MPR_MaxX25Address + 1];
    WCHAR                   szX25Facilities[MPR_MaxFacilities + 1];
    WCHAR                   szX25UserData[MPR_MaxUserData + 1];
    DWORD                   dwChannels;
    DWORD                   dwSubEntries;
    DWORD                   dwDialMode;
    DWORD                   dwDialExtraPercent;
    DWORD                   dwDialExtraSampleSeconds;
    DWORD                   dwHangUpExtraPercent;
    DWORD                   dwHangUpExtraSampleSeconds;
    DWORD                   dwIdleDisconnectSeconds;
    DWORD                   dwType;
    DWORD                   dwEncryptionType;
    DWORD                   dwCustomAuthKey;
    DWORD                   dwCustomAuthDataSize;
    LPBYTE                  lpbCustomAuthData;
    GUID                    guidId;
    DWORD                   dwVpnStrategy;
    ULONG                   AddressCount;
    IN6_ADDR                ipv6addrDns;
    IN6_ADDR                ipv6addrDnsAlt;
    IN6_ADDR                *ipv6addr;
} MPR_INTERFACE_3;
typedef MPR_INTERFACE_3 *PMPR_INTERFACE_3;
#endif

/* MPR IP in IP interface (level 0) */
typedef struct _MPR_IPINIP_INTERFACE_0 {
    WCHAR   wszFriendlyName[MAX_INTERFACE_NAME_LEN + 1];
    GUID    Guid;
} MPR_IPINIP_INTERFACE_0;
typedef MPR_IPINIP_INTERFACE_0  *PMPR_IPINIP_INTERFACE_0;

/* MPR device (level 0) */
#if (WINVER >= 0x0500)
typedef struct _MPR_DEVICE_0 {
    WCHAR   szDeviceType[MPR_MaxDeviceType + 1];
    WCHAR   szDeviceName[MPR_MaxDeviceName + 1];
} MPR_DEVICE_0;
typedef MPR_DEVICE_0    *PMPR_DEVICE_0;
#endif

/* MPR device (level 1) */
#if (WINVER >= 0x0500)
typedef struct _MPR_DEVICE_1 {
    WCHAR   szDeviceType[MPR_MaxDeviceType + 1];
    WCHAR   szDeviceName[MPR_MaxDeviceName + 1];
    WCHAR   szLocalPhoneNumber[MPR_MaxPhoneNumber + 1];
    PWCHAR  szAlternates;
} MPR_DEVICE_1;
typedef MPR_DEVICE_1    *PMPR_DEVICE_1;
#endif

/* MPR extended credentials (level 0) */
#if (WINVER >= 0x0500)
typedef struct _MPR_CREDENTIALSEX_0 {
    DWORD   dwSize;
    LPBYTE  lpbCredentialsInfo;
} MPR_CREDENTIALSEX_0;
typedef MPR_CREDENTIALSEX_0 *PMPR_CREDENTIALSEX_0;
#endif

/* MPR extended credentials (level 1) */
#if (WINVER >= 0x0500)
typedef struct _MPR_CREDENTIALSEX_1 {
    DWORD   dwSize;
    LPBYTE  lpbCredentialsInfo;
} MPR_CREDENTIALSEX_1;
typedef MPR_CREDENTIALSEX_1 *PMPR_CREDENTIALSEX_1;
#endif

/* MPR transport (level 0) */
typedef struct _MPR_TRANSPORT_0 {
    DWORD   dwTransportId;
    HANDLE  hTransport;
    WCHAR   wszTransportName[MAX_TRANSPORT_NAME_LEN + 1];
} MPR_TRANSPORT_0;
typedef MPR_TRANSPORT_0 *PMPR_TRANSPORT_0;

/* MPR interface transport (level 0) */
typedef struct _MPR_IFTRANSPORT_0 {
    DWORD   dwTransportId;
    HANDLE  hIfTransport;
    WCHAR   wszIfTransportName[MAX_TRANSPORT_NAME_LEN + 1];
} MPR_IFTRANSPORT_0;
typedef MPR_IFTRANSPORT_0   *PMPR_IFTRANSPORT_0;

/* MPR server (level 0) */
typedef struct _MPR_SERVER_0 {
    BOOL    fLanOnlyMode;
    DWORD   dwUpTime;
    DWORD   dwTotalPorts;
    DWORD   dwPortsInUse;
} MPR_SERVER_0;
typedef MPR_SERVER_0    *PMPR_SERVER_0;

/* MPR server (level 1) */
#if (WINVER >= 0x0501)
typedef struct _MPR_SERVER_1 {
    DWORD   dwNumPptpPorts;
    DWORD   dwPptpPortFlags;
    DWORD   dwNumL2tpPorts;
    DWORD   dwL2tpPortFlags;
} MPR_SERVER_1;
typedef MPR_SERVER_1    *PMPR_SERVER_1;
#endif

/* MPR server (level 2) */
#if (WINVER >= 0x0600)
typedef struct _MPR_SERVER_2 {
    DWORD   dwNumPptpPorts;
    DWORD   dwPptpPortFlags;
    DWORD   dwNumL2tpPorts;
    DWORD   dwL2tpPortFlags;
    DWORD   dwNumSstpPorts;
    DWORD   dwSstpPortFlags;
} MPR_SERVER_2;
typedef MPR_SERVER_2    *PMPR_SERVER_2;
#endif

/* RAS port conditions */
typedef enum _RAS_PORT_CONDITION {
    RAS_PORT_NON_OPERATIONAL    = 0,
    RAS_PORT_DISCONNECTED       = 1,
    RAS_PORT_CALLING_BACK       = 2,
    RAS_PORT_LISTENING          = 3,
    RAS_PORT_AUTHENTICATING     = 4,
    RAS_PORT_AUTHENTICATED      = 5,
    RAS_PORT_INITIALIZING       = 6
} RAS_PORT_CONDITION;

/* RAS hardware conditions */
typedef enum _RAS_HARDWARE_CONDITION {
    RAS_HARDWARE_OPERATIONAL    = 0,
    RAS_HARDWARE_FAILURE        = 1
} RAS_HARDWARE_CONDITION;

/* RAS port (level 0) */
typedef struct _RAS_PORT_0 {
    HANDLE              hPort;
    HANDLE              hConnection;
    RAS_PORT_CONDITION  dwPortCondition;
    DWORD               dwTotalNumberOfCalls;
    DWORD               dwConnectDuration;
    WCHAR               wszPortName[MAX_PORT_NAME + 1];
    WCHAR               wszMediaName[MAX_MEDIA_NAME + 1];
    WCHAR               wszDeviceName[MAX_DEVICE_NAME + 1];
    WCHAR               wszDeviceType[MAX_DEVICETYPE_NAME + 1];
} RAS_PORT_0;
typedef RAS_PORT_0  *PRAS_PORT_0;

/* RAS port (level 1) */
typedef struct _RAS_PORT_1 {
    HANDLE                  hPort;
    HANDLE                  hConnection;
    RAS_HARDWARE_CONDITION  dwHardwareCondition;
    DWORD                   dwLineSpeed;
    DWORD                   dwBytesXmitted;
    DWORD                   dwBytesRcved;
    DWORD                   dwFramesXmitted;
    DWORD                   dwFramesRcved;
    DWORD                   dwCrcErr;
    DWORD                   dwTimeoutErr;
    DWORD                   dwAlignmentErr;
    DWORD                   dwHardwareOverrunErr;
    DWORD                   dwFramingErr;
    DWORD                   dwBufferOverrunErr;
    DWORD                   dwCompressionRatioIn;
    DWORD                   dwCompressionRatioOut;
} RAS_PORT_1;
typedef RAS_PORT_1  *PRAS_PORT_1;

/* PPP NBFCP information */
typedef struct _PPP_NBFCP_INFO {
    DWORD   dwError;
    WCHAR   wszWksta[NETBIOS_NAME_LEN + 1];
} PPP_NBFCP_INFO;

/* PPP IPCP information */
typedef struct _PPP_IPCP_INFO {
    DWORD   dwError;
    WCHAR   wszAddress[IPADDRESSLEN + 1];
    WCHAR   wszRemoteAddress[IPADDRESSLEN + 1];
} PPP_IPCP_INFO;

/* PPP IPCP information (version 2) */
typedef struct _PPP_IPCP_INFO2 {
    DWORD   dwError;
    WCHAR   wszAddress[IPADDRESSLEN + 1];
    WCHAR   wszRemoteAddress[IPADDRESSLEN + 1];
    DWORD   dwOptions;
    DWORD   dwRemoteOptions;
} PPP_IPCP_INFO2;

/* PPP IPXCP information */
typedef struct _PPP_IPXCP_INFO {
    DWORD   dwError;
    WCHAR   wszAddress[IPXADDRESSLEN + 1];
} PPP_IPXCP_INFO;

/* PPP ATCP information */
typedef struct _PPP_ATCP_INFO {
    DWORD   dwError;
    WCHAR   wszAddress[ATADDRESSLEN + 1];
} PPP_ATCP_INFO;

/* PPP IPv6 CP information */
#if (WINVER >= 0x0600)
typedef struct _PPP_IPV6_CP_INFO {
    DWORD   dwVersion;
    DWORD   dwSize;
    DWORD   dwError;
    BYTE    bInterfaceIdentifier[8];
    BYTE    bRemoteInterfaceIdentifier[8];
    DWORD   dwOptions;
    DWORD   dwRemoteOptions;
    BYTE    bPrefix[8];
    DWORD   dwPrefixLength;
} PPP_IPV6_CP_INFO;
#endif

/* PPP information */
typedef struct _PPP_INFO {
    PPP_NBFCP_INFO  nbf;
    PPP_IPCP_INFO   ip;
    PPP_IPXCP_INFO  ipx;
    PPP_ATCP_INFO   at;
} PPP_INFO;

/* PPP compression control protocol information */
#if (WINVER >= 0x0500)
typedef struct _PPP_CCP_INFO {
    DWORD   dwError;
    DWORD   dwCompressionAlgorithm;
    DWORD   dwOptions;
    DWORD   dwRemoteCompressionAlgorithm;
    DWORD   dwRemoteOptions;
} PPP_CCP_INFO;
#endif

/* PPP link control protocol information */
#if (WINVER >= 0x0500)
typedef struct _PPP_LCP_INFO {
    DWORD   dwError;
    DWORD   dwAuthenticationProtocol;
    DWORD   dwAuthenticationData;
    DWORD   dwRemoteAuthenticationProtocol;
    DWORD   dwRemoteAuthenticationData;
    DWORD   dwTerminateReason;
    DWORD   dwRemoteTerminateReason;
    DWORD   dwOptions;
    DWORD   dwRemoteOptions;
    DWORD   dwEapTypeId;
    DWORD   dwRemoteEapTypeId;
} PPP_LCP_INFO;
#endif

/* PPP information (version 2) */
#if (WINVER >= 0x0500)
typedef struct _PPP_INFO_2 {
    PPP_NBFCP_INFO  nbf;
    PPP_IPCP_INFO   ip;
    PPP_IPXCP_INFO  ipx;
    PPP_ATCP_INFO   at;
    PPP_CCP_INFO    ccp;
    PPP_LCP_INFO    lcp;
} PPP_INFO_2;
#endif

/* PPP information (version 3) */
#if (WINVER >= 0x0600)
typedef struct _PPP_INFO_3 {
    PPP_NBFCP_INFO      nbf;
    PPP_IPCP_INFO2      ip;
    PPP_IPV6_CP_INFO    ipv6;
    PPP_CCP_INFO        ccp;
    PPP_LCP_INFO        lcp;
} PPP_INFO_3;
#endif

/* RAS connection (level 0) */
typedef struct _RAS_CONNECTION_0 {
    HANDLE                  hConnection;
    HANDLE                  hInterface;
    DWORD                   dwConnectDuration;
    ROUTER_INTERFACE_TYPE   dwInterfaceType;
    DWORD                   dwConnectionFlags;
    WCHAR                   wszInterfaceName[MAX_INTERFACE_NAME_LEN + 1];
    WCHAR                   wszUserName[UNLEN + 1];
    WCHAR                   wszLogonDomain[DNLEN + 1];
    WCHAR                   wszRemoteComputer[NETBIOS_NAME_LEN + 1];
} RAS_CONNECTION_0;
typedef RAS_CONNECTION_0    *PRAS_CONNECTION_0;

/* RAS connection (level 1) */
typedef struct _RAS_CONNECTION_1 {
    HANDLE      hConnection;
    HANDLE      hInterface;
    PPP_INFO    PppInfo;
    DWORD       dwBytesXmitted;
    DWORD       dwBytesRcved;
    DWORD       dwFramesXmitted;
    DWORD       dwFramesRcved;
    DWORD       dwCrcErr;
    DWORD       dwTimeoutErr;
    DWORD       dwAlignmentErr;
    DWORD       dwHardwareOverrunErr;
    DWORD       dwFramingErr;
    DWORD       dwBufferOverrunErr;
    DWORD       dwCompressionRatioIn;
    DWORD       dwCompressionRatioOut;
} RAS_CONNECTION_1;
typedef RAS_CONNECTION_1    *PRAS_CONNECTION_1;

/* RAS connection (level 2) */
#if (WINVER >= 0x0500)
typedef struct _RAS_CONNECTION_2 {
    HANDLE                  hConnection;
    WCHAR                   wszUserName[UNLEN + 1];
    ROUTER_INTERFACE_TYPE   dwInterfaceType;
    GUID                    guid;
    PPP_INFO_2              PppInfo2;
} RAS_CONNECTION_2;
typedef RAS_CONNECTION_2    *PRAS_CONNECTION_2;
#endif

/* RAS quarantine states */
#if (WINVER >= 0x0500)
typedef enum _RAS_QUARANTINE_STATE {
    RAS_QUAR_STATE_NORMAL       = 0,
    RAS_QUAR_STATE_QUARANTINE   = 1,
    RAS_QUAR_STATE_PROBATION    = 2,
    RAS_QUAR_STATE_NOT_CAPABLE  = 3
} RAS_QUARANTINE_STATE;
#endif

/* RAS connection (level 3) */
#if (WINVER >= 0x0600)
typedef struct _RAS_CONNECTION_3 {
    DWORD                   dwVersion;
    DWORD                   dwSize;
    HANDLE                  hConnection;
    WCHAR                   wszUserName[UNLEN + 1];
    ROUTER_INTERFACE_TYPE   dwInterfaceType;
    GUID                    guid;
    PPP_INFO_3              PppInfo3;
    RAS_QUARANTINE_STATE    rasQuarState;
    FILETIME                timer;
} RAS_CONNECTION_3;
typedef RAS_CONNECTION_3    *PRAS_CONNECTION_3;
#endif

/* RAS user (level 0) */
typedef struct _RAS_USER_0 {
    BYTE    bfPrivilege;
    WCHAR   wszPhoneNumber[MAX_PHONE_NUMBER_LEN + 1];
} RAS_USER_0;
typedef RAS_USER_0  *PRAS_USER_0;

/* RAS user (level 1) */
typedef struct _RAS_USER_1 {
    BYTE    bfPrivilege;
    WCHAR   wszPhoneNumber[MAX_PHONE_NUMBER_LEN + 1];
    BYTE    bfPrivilege2;
} RAS_USER_1;
typedef RAS_USER_1  *PRAS_USER_1;

/* MPR filter (level 0) */
#if (WINVER >= 0x0600)
typedef struct _MPR_FILTER_0 {
    BOOL    fEnable;
} MPR_FILTER_0;
typedef MPR_FILTER_0    *PMPR_FILTER_0;
#endif

/* MPRAPI object header */
#if (WINVER >= 0x0601)
typedef struct _MPRAPI_OBJECT_HEADER {
    UCHAR   revision;
    UCHAR   type;
    USHORT  size;
} MPRAPI_OBJECT_HEADER;
typedef MPRAPI_OBJECT_HEADER    *PMPRAPI_OBJECT_HEADER;
#endif

/* MPRAPI object types */
#if (WINVER >= 0x0601)
typedef enum _MPRAPI_OBJECT_TYPE {
    MPRAPI_OBJECT_TYPE_RAS_CONNECTION_OBJECT        = 1,
    MPRAPI_OBJECT_TYPE_MPR_SERVER_OBJECT            = 2,
    MPRAPI_OBJECT_TYPE_MPR_SERVER_SET_CONFIG_OBJECT = 3,
    MPRAPI_OBJECT_TYPE_AUTH_VALIDATION_OBJECT       = 4,
    MPRAPI_OBJECT_TYPE_UPDATE_CONNECTION_OBJECT     = 5
} MPRAPI_OBJECT_TYPE;
typedef MPRAPI_OBJECT_TYPE  *PMPRAPI_OBJECT_TYPE;
#endif

/* PPP projection information */
#if (WINVER >= 0x0601)
typedef struct _PPP_PROJECTION_INFO {
    DWORD   dwIPv4NegotiationError;
    WCHAR   wszAddress[IPADDRESSLEN + 1];
    WCHAR   wszRemoteAddress[IPADDRESSLEN + 1];
    DWORD   dwIPv4Options;
    DWORD   dwIPv4RemoteOptions;
    ULONG64 IPv4SubInterfaceIndex;
    DWORD   dwIPv6NegotiationError;
    BYTE    bInterfaceIdentifier[8];
    BYTE    bRemoteInterfaceIdentifier[8];
    BYTE    bPrefix[8];
    DWORD   dwPrefixLength;
    ULONG64 IPv6SubInterfaceIndex;
    DWORD   dwLcpError;
    DWORD   dwAuthenticationProtocol;
    DWORD   dwAuthenticationData;
    DWORD   dwRemoteAuthenticationProtocol;
    DWORD   dwRemoteAuthenticationData;
    DWORD   dwLcpTerminateReason;
    DWORD   dwLcpRemoteTerminateReason;
    DWORD   dwLcpOptions;
    DWORD   dwLcpRemoteOptions;
    DWORD   dwEapTypeId;
    DWORD   dwRemoteEapTypeId;
    DWORD   dwCcpError;
    DWORD   dwCompressionAlgorithm;
    DWORD   dwCcpOptions;
    DWORD   dwRemoteCompressionAlgorithm;
    DWORD   dwCcpRemoteOptions;
} PPP_PROJECTION_INFO;
typedef PPP_PROJECTION_INFO *PPPP_PROJECTION_INFO;
#endif

/* IKEv2 projection information */
#if (WINVER >= 0x0601)
typedef struct _IKEV2_PROJECTION_INFO {
    DWORD   dwIPv4NegotiationError;
    WCHAR   wszAddress[IPADDRESSLEN + 1];
    WCHAR   wszRemoteAddress[IPADDRESSLEN + 1];
    ULONG64 IPv4SubInterfaceIndex;
    DWORD   dwIPv6NegotiationError;
    BYTE    bInterfaceIdentifier[8];
    BYTE    bRemoteInterfaceIdentifier[8];
    BYTE    bPrefix[8];
    DWORD   dwPrefixLength;
    ULONG64 IPv6SubInterfaceIndex;
    DWORD   dwOptions;
    DWORD   dwAuthenticationProtocol;
    DWORD   dwEapTypeId;
    DWORD   dwCompressionAlgorithm;
    DWORD   dwEncryptionMethod;
} IKEV2_PROJECTION_INFO;
typedef IKEV2_PROJECTION_INFO   *PIKEV2_PROJECTION_INFO;
#endif

/* Projection information */
#if (WINVER >= 0x0601)
typedef struct _PROJECTION_INFO {
    UCHAR   projectionInfoType;
    union {
        PPP_PROJECTION_INFO     PppProjectionInfo;
        IKEV2_PROJECTION_INFO   Ikev2ProjectionInfo;
    };
} PROJECTION_INFO;
typedef PROJECTION_INFO *PPROJECTION_INFO;
#endif

/* RAS connection (extended version) */
#if (WINVER >= 0x0601)
typedef struct _RAS_CONNECTION_EX {
    MPRAPI_OBJECT_HEADER    Header;
    DWORD                   dwConnectDuration;
    ROUTER_INTERFACE_TYPE   dwInterfaceType;
    DWORD                   dwConnectionFlags;
    WCHAR                   wszInterfaceName[MAX_INTERFACE_NAME_LEN + 1];
    WCHAR                   wszUserName[UNLEN + 1];
    WCHAR                   wszLogonDomain[DNLEN + 1];
    WCHAR                   wszRemoteComputer[NETBIOS_NAME_LEN + 1];
    GUID                    guid;
    RAS_QUARANTINE_STATE    rasQuarState;
    FILETIME                probationTime;
    DWORD                   dwBytesXmited;
    DWORD                   dwBytesRcved;
    DWORD                   dwFramesXmited;
    DWORD                   dwFramesRcved;
    DWORD                   dwCrcErr;
    DWORD                   dwTimeoutErr;
    DWORD                   dwAlignmentErr;
    DWORD                   dwHardwareOverrunErr;
    DWORD                   dwFramingErr;
    DWORD                   dwBufferOverrunErr;
    DWORD                   dwCompressionRatioIn;
    DWORD                   dwCompressionRatioOut;
    DWORD                   dwNumSwitchOvers;
    WCHAR                   wszRemoteEndpointAddress[MAXIPADRESSLEN + 1];
    WCHAR                   wszLocalEndpointAddress[MAXIPADRESSLEN + 1];
    PROJECTION_INFO         ProjectionInfo;
    HANDLE                  hConnection;
    HANDLE                  hInterface;
} RAS_CONNECTION_EX;
typedef RAS_CONNECTION_EX   *PRAS_CONNECTION_EX;
#endif

/* IKEv2 tunnel configuration parameters */
#if (WINVER >= 0x0601)
typedef struct _IKEV2_TUNNEL_CONFIG_PARAMS {
    DWORD           dwIdleTimeout;
    DWORD           dwNetworkBlackoutTime;
    DWORD           dwSaLifeTime;
    DWORD           dwSaDataSizeForRenegotiation;
    DWORD           dwConfigOptions;
    DWORD           dwTotalCertificates;
    CERT_NAME_BLOB  *certificateNames;
} IKEV2_TUNNEL_CONFIG_PARAMS;
typedef IKEV2_TUNNEL_CONFIG_PARAMS  *PIKEV2_TUNNEL_CONFIG_PARAMS;
#endif

/* IKEv2 configuration parameters */
#if (WINVER >= 0x0601)
typedef struct _IKEV2_CONFIG_PARAMS {
    DWORD                       dwNumPorts;
    DWORD                       dwPortFlags;
    DWORD                       dwTunnelConfigParamFlags;
    IKEV2_TUNNEL_CONFIG_PARAMS  TunnelConfigParams;
} IKEV2_CONFIG_PARAMS;
typedef IKEV2_CONFIG_PARAMS *PIKEV2_CONFIG_PARAMS;
#endif

/* PPTP configuration parameters */
#if (WINVER >= 0x0601)
typedef struct _PPTP_CONFIG_PARAMS {
    DWORD   dwNumPorts;
    DWORD   dwPortFlags;
} PPTP_CONFIG_PARAMS;
typedef PPTP_CONFIG_PARAMS  *PPPTP_CONFIG_PARAMS;
#endif

/* L2TP configuration parameters */
#if (WINVER >= 0x0601)
typedef struct _L2TP_CONFIG_PARAMS {
    DWORD   dwNumPorts;
    DWORD   dwPortFlags;
} L2TP_CONFIG_PARAMS;
typedef L2TP_CONFIG_PARAMS  *PL2TP_CONFIG_PARAMS;
#endif

/* SSTP certificate information */
#if (WINVER >= 0x0601)
typedef struct _SSTP_CERT_INFO {
    BOOL            isDefault;
    CRYPT_HASH_BLOB certBlob;
} SSTP_CERT_INFO;
typedef SSTP_CERT_INFO  *PSSTP_CERT_INFO;
#endif

/* SSTP configuration parameters */
#if (WINVER >= 0x0601)
typedef struct _SSTP_CONFIG_PARAMS {
    DWORD           dwNumPorts;
    DWORD           dwPortFlags;
    BOOL            isUseHttps;
    DWORD           certAlgorithm;
    SSTP_CERT_INFO  sstpCertDetails;
} SSTP_CONFIG_PARAMS;
typedef SSTP_CONFIG_PARAMS  *PSSTP_CONFIG_PARAMS;
#endif

/* MPRAPI tunnel configuration parameters */
#if (WINVER >= 0x0601)
typedef struct _MPRAPI_TUNNEL_CONFIG_PARAMS {
    IKEV2_CONFIG_PARAMS IkeConfigParams;
    PPTP_CONFIG_PARAMS  PptpConfigParams;
    L2TP_CONFIG_PARAMS  L2tpConfigParams;
    SSTP_CONFIG_PARAMS  SstpConfigParams;
} MPRAPI_TUNNEL_CONFIG_PARAMS;
typedef MPRAPI_TUNNEL_CONFIG_PARAMS *PMPRAPI_TUNNEL_CONFIG_PARAMS;
#endif

/* MPR server (extended version) */
#if (WINVER >= 0x0601)
typedef struct _MPR_SERVER_EX {
    MPRAPI_OBJECT_HEADER        Header;
    DWORD                       fLanOnlyMode;
    DWORD                       dwUpTime;
    DWORD                       dwTotalPorts;
    DWORD                       dwPortsInUse;
    DWORD                       Reserved;
    MPRAPI_TUNNEL_CONFIG_PARAMS ConfigParams;
} MPR_SERVER_EX;
typedef MPR_SERVER_EX   *PMPR_SERVER_EX;
#endif

/* MPR server set configuration (extended version) */
#if (WINVER >= 0x0601)
typedef struct _MPR_SERVER_SET_CONFIG_EX {
    MPRAPI_OBJECT_HEADER        Header;
    DWORD                       setConfigForProtocols;
    MPRAPI_TUNNEL_CONFIG_PARAMS ConfigParams;
} MPR_SERVER_SET_CONFIG_EX;
typedef MPR_SERVER_SET_CONFIG_EX    *PMPR_SERVER_SET_CONFIG_EX;
#endif

/* Authentication validation (extended version) */
#if (WINVER >= 0x0601)
typedef struct _AUTH_VALIDATION_EX {
    MPRAPI_OBJECT_HEADER    Header;
    HANDLE                  hRasConnection;
    WCHAR                   wszUserName[UNLEN + 1];
    WCHAR                   wszLogonDomain[DNLEN + 1];
    DWORD                   AuthInfoSize;
    BYTE                    AuthInfo[1];
} AUTH_VALIDATION_EX;
#endif

/* RAS update connection */
#if (WINVER >= 0x0601)
typedef struct RAS_UPDATE_CONNECTION_ {
    MPRAPI_OBJECT_HEADER    Header;
    DWORD                   dwIfIndex;
    WCHAR                   wszLocalEndpointAddress[MAXIPADRESSLEN + 1];
    WCHAR                   wszRemoteEndpointAddress[MAXIPADRESSLEN + 1];
} RAS_UPDATE_CONNECTION;
typedef RAS_UPDATE_CONNECTION   *PRAS_UPDATE_CONNECTION;
#endif

/* MPRAPI administration DLL function templates */
#if (WINVER >= 0x0601)
typedef DWORD   (APIENTRY *PMPRADMINGETIPADDRESSFORUSER)( WCHAR *, WCHAR *, DWORD *, BOOL * );
typedef VOID    (APIENTRY *PMPRADMINRELEASEIPADRESS)( WCHAR *, WCHAR *, DWORD * );
typedef DWORD   (APIENTRY *PMPRADMINGETIPV6ADDRESSFORUSER)( WCHAR *, WCHAR *, IN6_ADDR *, BOOL * );
typedef VOID    (APIENTRY *PMPRADMINRELEASEIPV6ADDRESSFORUSER)( WCHAR *, WCHAR *, IN6_ADDR * );
typedef BOOL    (APIENTRY *PMPRADMINACCEPTNEWCONNECTION)( RAS_CONNECTION_0 *, RAS_CONNECTION_1 * );
typedef BOOL    (APIENTRY *PMPRADMINACCEPTNEWCONNECTION2)( RAS_CONNECTION_0 *, RAS_CONNECTION_1 *, RAS_CONNECTION_2 * );
typedef BOOL    (APIENTRY *PMPRADMINACCEPTNEWCONNECTION3)( RAS_CONNECTION_0 *, RAS_CONNECTION_1 *, RAS_CONNECTION_2 *, RAS_CONNECTION_3 * );
typedef BOOL    (APIENTRY *PMPRADMINACCEPTNEWLINK)( RAS_PORT_0 *, RAS_PORT_1 * );
typedef VOID    (APIENTRY *PMPRADMINCONNECTIONHANGUPNOTIFICATION)( RAS_CONNECTION_0 *, RAS_CONNECTION_1 * );
typedef VOID    (APIENTRY *PMPRADMINCONNECTIONHANGUPNOTIFICATION2)( RAS_CONNECTION_0 *, RAS_CONNECTION_1 *, RAS_CONNECTION_2 * );
typedef VOID    (APIENTRY *PMPRADMINCONNECTIONHANGUPNOTIFICATION3)( RAS_CONNECTION_0 *, RAS_CONNECTION_1 *, RAS_CONNECTION_2 *, RAS_CONNECTION_3 * );
typedef VOID    (APIENTRY *PMPRADMINLINKHANGUPNOTIFICATION)( RAS_PORT_0 *, RAS_PORT_1 * );
typedef DWORD   (APIENTRY *PMPRADMINTERMINATEDLL)();
typedef BOOL    (APIENTRY *PMPRADMINACCEPTREAUTHENTICATION)( RAS_CONNECTION_0 *, RAS_CONNECTION_1 *, RAS_CONNECTION_2 *, RAS_CONNECTION_3 * );
typedef BOOL    (APIENTRY *PMPRADMINACCEPTNEWCONNECTIONEX)( RAS_CONNECTION_EX * );
typedef BOOL    (APIENTRY *PMPRADMINACCEPTREAUTHENTICATIONEX)( RAS_CONNECTION_EX * );
typedef BOOL    (APIENTRY *PMPRADMINACCEPTTUNNELENDPOINTCHANGEEX)( RAS_CONNECTION_EX * );
typedef VOID    (APIENTRY *PMPRADMINCONNECTIONHANGUPNOTIFICATIONEX)( RAS_CONNECTION_EX * );
typedef DWORD   (APIENTRY *PMPRADMINRASVALIDATEPREAUTHENTICATEDCONNECTIONEX)( AUTH_VALIDATION_EX * );
#endif

/* MPRAPI administration DLL callbacks */
#if (WINVER >= 0x0601)
typedef struct _MPRAPI_ADMIN_DLL_CALLBACKS {
    UCHAR                                   revision;
    PMPRADMINGETIPADDRESSFORUSER            lpfnMprAdminGetIpAddressForUser;
    PMPRADMINRELEASEIPADRESS                lpfnMprAdminReleaseIpAddress;
    PMPRADMINGETIPV6ADDRESSFORUSER          lpfnMprAdminGetIpv6AddressForUser;
    PMPRADMINRELEASEIPV6ADDRESSFORUSER      lpfnMprAdminReleaseIpv6AddressForUser;
    PMPRADMINACCEPTNEWLINK                  lpfnRasAdminAcceptNewLink;
    PMPRADMINLINKHANGUPNOTIFICATION         lpfnRasAdminLinkHangupNotification;
    PMPRADMINTERMINATEDLL                   lpfnRasAdminTerminateDll;
    PMPRADMINACCEPTNEWCONNECTIONEX          lpfnRasAdminAcceptNewConnectionEx;
    PMPRADMINACCEPTTUNNELENDPOINTCHANGEEX   lpfnRasAdminAcceptEndpointChangeEx;
    PMPRADMINACCEPTREAUTHENTICATIONEX       lpfnRasAdminAcceptReauthenticationEx;
    PMPRADMINCONNECTIONHANGUPNOTIFICATIONEX lpfnRasAdminConnectionHangupNotificationEx;
    PMPRADMINRASVALIDATEPREAUTHENTICATEDCONNECTIONEX    lpfnRASValidatePreAuthenticatedConnectionEx;
} MPRAPI_ADMIN_DLL_CALLBACKS;
typedef MPRAPI_ADMIN_DLL_CALLBACKS  *PMPRAPI_ADMIN_DLL_CALLBACKS;
#endif

/* Functions in MPRAPI.DLL */
DWORD APIENTRY  MprAdminBufferFree( LPVOID );
DWORD APIENTRY  MprAdminConnectionClearStatus( RAS_SERVER_HANDLE, HANDLE );
DWORD APIENTRY  MprAdminConnectionEnum( RAS_SERVER_HANDLE, DWORD, LPBYTE *, DWORD, LPDWORD, LPDWORD, LPDWORD );
DWORD APIENTRY  MprAdminConnectionGetInfo( RAS_SERVER_HANDLE, DWORD, HANDLE, LPBYTE * );
DWORD APIENTRY  MprAdminGetErrorString( DWORD, LPWSTR * );
DWORD APIENTRY  MprAdminGetPDCServer( const WCHAR *, const WCHAR *, LPWSTR );
DWORD APIENTRY  MprAdminInterfaceConnect( MPR_SERVER_HANDLE, HANDLE, HANDLE, BOOL );
DWORD APIENTRY  MprAdminInterfaceCreate( MPR_SERVER_HANDLE, DWORD, LPBYTE, HANDLE * );
DWORD APIENTRY  MprAdminInterfaceDelete( MPR_SERVER_HANDLE, HANDLE );
DWORD APIENTRY  MprAdminInterfaceDisconnect( MPR_SERVER_HANDLE, HANDLE );
DWORD APIENTRY  MprAdminInterfaceGetCredentials( LPWSTR, LPWSTR, LPWSTR, LPWSTR, LPWSTR );
DWORD APIENTRY  MprAdminInterfaceGetHandle( MPR_SERVER_HANDLE, LPWSTR, HANDLE *, BOOL );
DWORD APIENTRY  MprAdminInterfaceGetInfo( MPR_SERVER_HANDLE, HANDLE, DWORD, LPBYTE * );
DWORD APIENTRY  MprAdminInterfaceQueryUpdateResult( MPR_SERVER_HANDLE, HANDLE, DWORD, LPDWORD );
DWORD APIENTRY  MprAdminInterfaceSetCredentials( LPWSTR, LPWSTR, LPWSTR, LPWSTR, LPWSTR );
DWORD APIENTRY  MprAdminInterfaceSetInfo( MPR_SERVER_HANDLE, HANDLE, DWORD, LPBYTE );
DWORD APIENTRY  MprAdminInterfaceTransportAdd( MPR_SERVER_HANDLE, HANDLE, DWORD, LPBYTE, DWORD );
DWORD APIENTRY  MprAdminInterfaceTransportGetInfo( MPR_SERVER_HANDLE, HANDLE, DWORD, LPBYTE *, LPDWORD );
DWORD APIENTRY  MprAdminInterfaceTransportRemove( MPR_SERVER_HANDLE, HANDLE, DWORD );
DWORD APIENTRY  MprAdminInterfaceTransportSetInfo( MPR_SERVER_HANDLE, HANDLE, DWORD, LPBYTE, DWORD );
DWORD APIENTRY  MprAdminInterfaceUpdatePhonebookInfo( MPR_SERVER_HANDLE, HANDLE );
DWORD APIENTRY  MprAdminInterfaceUpdateRoutes( MPR_SERVER_HANDLE, HANDLE, DWORD, HANDLE );
BOOL APIENTRY   MprAdminIsServiceRunning( LPWSTR );
DWORD APIENTRY  MprAdminMIBBufferFree( LPVOID );
DWORD APIENTRY  MprAdminMIBEntryCreate( MIB_SERVER_HANDLE, DWORD, DWORD, LPVOID, DWORD );
DWORD APIENTRY  MprAdminMIBEntryDelete( MIB_SERVER_HANDLE, DWORD, DWORD, LPVOID, DWORD );
DWORD APIENTRY  MprAdminMIBEntryGet( MIB_SERVER_HANDLE, DWORD, DWORD, LPVOID, DWORD, LPVOID *, LPDWORD );
DWORD APIENTRY  MprAdminMIBEntryGetFirst( MIB_SERVER_HANDLE, DWORD, DWORD, LPVOID, DWORD, LPVOID *, LPDWORD );
DWORD APIENTRY  MprAdminMIBEntryGetNext( MIB_SERVER_HANDLE, DWORD, DWORD, LPVOID, DWORD, LPVOID *, LPDWORD );
DWORD APIENTRY  MprAdminMIBEntrySet( MIB_SERVER_HANDLE, DWORD, DWORD, LPVOID, DWORD );
DWORD APIENTRY  MprAdminMIBServerConnect( LPWSTR, MIB_SERVER_HANDLE * );
VOID APIENTRY   MprAdminMIBServerDisconnect( MIB_SERVER_HANDLE );
DWORD APIENTRY  MprAdminPortClearStatus( RAS_SERVER_HANDLE, HANDLE );
DWORD APIENTRY  MprAdminPortDisconnect( RAS_SERVER_HANDLE, HANDLE );
DWORD APIENTRY  MprAdminPortEnum( RAS_SERVER_HANDLE, DWORD, HANDLE, LPBYTE *, DWORD, LPDWORD, LPDWORD, LPDWORD );
DWORD APIENTRY  MprAdminPortGetInfo( RAS_SERVER_HANDLE, DWORD, HANDLE, LPBYTE * );
DWORD APIENTRY  MprAdminPortReset( RAS_SERVER_HANDLE, HANDLE );
DWORD APIENTRY  MprAdminServerConnect( LPWSTR, MPR_SERVER_HANDLE * );
VOID APIENTRY   MprAdminServerDisconnect( MPR_SERVER_HANDLE );
DWORD APIENTRY  MprAdminServerGetInfo( MPR_SERVER_HANDLE, DWORD, LPBYTE * );
DWORD APIENTRY  MprAdminTransportGetInfo( MPR_SERVER_HANDLE, DWORD, LPBYTE *, LPDWORD, LPBYTE *, LPDWORD );
DWORD APIENTRY  MprAdminTransportSetInfo( MPR_SERVER_HANDLE, DWORD, LPBYTE, DWORD, LPBYTE, DWORD );
DWORD APIENTRY  MprAdminUserGetInfo( const WCHAR *, const WCHAR *, DWORD, LPBYTE );
DWORD APIENTRY  MprAdminUserSetInfo( const WCHAR *, const WCHAR *, DWORD, const LPBYTE );
DWORD APIENTRY  MprConfigGetFriendlyName( HANDLE, PWCHAR, PWCHAR, DWORD );
DWORD APIENTRY  MprConfigGetGuidName( HANDLE, PWCHAR, PWCHAR, DWORD );
DWORD APIENTRY  MprConfigInterfaceCreate( HANDLE, DWORD, LPBYTE, HANDLE * );
DWORD APIENTRY  MprConfigInterfaceDelete( HANDLE, HANDLE );
DWORD APIENTRY  MprConfigInterfaceEnum( HANDLE, DWORD, LPBYTE *, DWORD, LPDWORD, LPDWORD, LPDWORD );
DWORD APIENTRY  MprConfigInterfaceGetHandle( HANDLE, LPWSTR, HANDLE * );
DWORD APIENTRY  MprConfigInterfaceGetInfo( HANDLE, HANDLE, DWORD, LPBYTE *, LPDWORD );
DWORD APIENTRY  MprConfigInterfaceSetInfo( HANDLE, HANDLE, DWORD, LPBYTE );
DWORD APIENTRY  MprConfigInterfaceTransportAdd( HANDLE, HANDLE, DWORD, LPWSTR, LPBYTE, DWORD, HANDLE * );
DWORD APIENTRY  MprConfigInterfaceTransportEnum( HANDLE, HANDLE, DWORD, LPBYTE *, DWORD, LPDWORD, LPDWORD, LPDWORD );
DWORD APIENTRY  MprConfigInterfaceTransportGetHandle( HANDLE, HANDLE, DWORD, HANDLE * );
DWORD APIENTRY  MprConfigInterfaceTransportGetInfo( HANDLE, HANDLE, HANDLE, LPBYTE *, LPDWORD );
DWORD APIENTRY  MprConfigInterfaceTransportRemove( HANDLE, HANDLE, HANDLE );
DWORD APIENTRY  MprConfigInterfaceTransportSetInfo( HANDLE, HANDLE, HANDLE, LPBYTE, DWORD );
DWORD APIENTRY  MprConfigServerBackup( HANDLE, LPWSTR );
DWORD APIENTRY  MprConfigServerConnect( LPWSTR, HANDLE * );
VOID APIENTRY   MprConfigServerDisconnect( HANDLE );
DWORD APIENTRY  MprConfigServerFree( LPVOID );
DWORD APIENTRY  MprConfigServerGetInfo( HANDLE, DWORD, LPBYTE * );
DWORD APIENTRY  MprConfigServerInstall( DWORD, PVOID );
DWORD APIENTRY  MprConfigServerRefresh( HANDLE );
DWORD APIENTRY  MprConfigServerRestore( HANDLE, LPWSTR );
DWORD APIENTRY  MprConfigTransportCreate( HANDLE, DWORD, LPWSTR, LPBYTE, DWORD, LPBYTE, DWORD, LPWSTR, HANDLE * );
DWORD APIENTRY  MprConfigTransportDelete( HANDLE, HANDLE );
DWORD APIENTRY  MprConfigTransportEnum( HANDLE, DWORD, LPBYTE *, DWORD, LPDWORD, LPDWORD, LPDWORD );
DWORD APIENTRY  MprConfigTransportGetHandle( HANDLE, DWORD, HANDLE * );
DWORD APIENTRY  MprConfigTransportGetInfo( HANDLE, HANDLE, LPBYTE *, LPDWORD, LPBYTE *, LPDWORD, LPWSTR * );
DWORD APIENTRY  MprConfigTransportSetInfo( HANDLE, HANDLE, LPBYTE, DWORD, LPBYTE, DWORD, LPWSTR );
DWORD APIENTRY  MprInfoBlockAdd( LPVOID, DWORD, DWORD, DWORD, LPBYTE, LPVOID * );
DWORD APIENTRY  MprInfoBlockFind( LPVOID, DWORD, LPDWORD, LPDWORD, LPBYTE * );
DWORD APIENTRY  MprInfoBlockQuerySize( LPVOID );
DWORD APIENTRY  MprInfoBlockRemove( LPVOID, DWORD, LPVOID * );
DWORD APIENTRY  MprInfoBlockSet( LPVOID, DWORD, DWORD, DWORD, LPBYTE, LPVOID * );
DWORD APIENTRY  MprInfoCreate( DWORD, LPVOID * );
DWORD APIENTRY  MprInfoDelete( LPVOID );
DWORD APIENTRY  MprInfoDuplicate( LPVOID, LPVOID * );
DWORD APIENTRY  MprInfoRemoveAll( LPVOID, LPVOID * );
DWORD APIENTRY  MprSetupIpInIpInterfaceFriendlyNameCreate( PWCHAR, PMPR_IPINIP_INTERFACE_0 );
DWORD APIENTRY  MprSetupIpInIpInterfaceFriendlyNameDelete( PWCHAR, GUID * );
DWORD APIENTRY  MprSetupIpInIpInterfaceFriendlyNameEnum( PWCHAR, LPBYTE *, LPDWORD );
DWORD APIENTRY  MprSetupIpInIpInterfaceFriendlyNameFree( LPVOID );
#if (WINVER >= 0x0500)
DWORD APIENTRY  MprAdminDeregisterConnectionNotification( MPR_SERVER_HANDLE, HANDLE );
DWORD APIENTRY  MprAdminDeviceEnum( MPR_SERVER_HANDLE, DWORD, LPBYTE *, LPDWORD );
DWORD APIENTRY  MprAdminInterfaceDeviceGetInfo( MPR_SERVER_HANDLE, HANDLE, DWORD, DWORD, LPBYTE * );
DWORD APIENTRY  MprAdminInterfaceDeviceSetInfo( MPR_SERVER_HANDLE, HANDLE, DWORD, DWORD, LPBYTE );
DWORD APIENTRY  MprAdminInterfaceGetCredentialsEx( MPR_SERVER_HANDLE, HANDLE, DWORD, LPBYTE * );
DWORD APIENTRY  MprAdminInterfaceSetCredentialsEx( MPR_SERVER_HANDLE, HANDLE, DWORD, LPBYTE );
DWORD APIENTRY  MprAdminRegisterConnectionNotification( MPR_SERVER_HANDLE, HANDLE );
DWORD APIENTRY  MprAdminSendUserMessage( MPR_SERVER_HANDLE, HANDLE, LPWSTR );
DWORD APIENTRY  MprAdminTransportCreate( MPR_SERVER_HANDLE, DWORD, LPWSTR, LPBYTE, DWORD, LPBYTE, DWORD, LPWSTR );
#endif
#if (WINVER >= 0x0501)
DWORD APIENTRY  MprAdminConnectionRemoveQuarantine( HANDLE, HANDLE, BOOL );
DWORD APIENTRY  MprAdminEstablishDomainRasServer( PWCHAR, PWCHAR, BOOL );
DWORD APIENTRY  MprAdminIsDomainRasServer( PWCHAR, PWCHAR, PBOOL );
DWORD APIENTRY  MprAdminServerGetCredentials( MPR_SERVER_HANDLE, DWORD, LPBYTE * );
DWORD APIENTRY  MprAdminServerSetCredentials( MPR_SERVER_HANDLE, DWORD, LPBYTE );
DWORD APIENTRY  MprAdminServerSetInfo( MPR_SERVER_HANDLE, DWORD, LPBYTE );
DWORD APIENTRY  MprConfigServerSetInfo( MPR_SERVER_HANDLE, DWORD, LPBYTE );
#endif
#if (WINVER >= 0x0600)
DWORD APIENTRY  MprConfigFilterGetInfo( HANDLE, DWORD, LPBYTE );
DWORD APIENTRY  MprConfigFilterSetInfo( HANDLE, DWORD, LPBYTE );
#endif
#if (WINVER >= 0x0601)
DWORD APIENTRY  MprAdminConnectionEnumEx( RAS_SERVER_HANDLE, PMPRAPI_OBJECT_HEADER, DWORD, LPDWORD, LPDWORD, PRAS_CONNECTION_EX *, LPDWORD );
DWORD APIENTRY  MprAdminConnectionGetInfoEx( RAS_SERVER_HANDLE, HANDLE, PRAS_CONNECTION_EX );
DWORD APIENTRY  MprAdminIsServiceInitialized( LPWSTR, BOOL * );
DWORD APIENTRY  MprAdminServerGetInfoEx( MPR_SERVER_HANDLE, MPR_SERVER_EX * );
DWORD APIENTRY  MprAdminServerSetInfoEx( MPR_SERVER_HANDLE, MPR_SERVER_SET_CONFIG_EX * );
DWORD APIENTRY  MprAdminUpdateConnection( RAS_SERVER_HANDLE, HANDLE, PRAS_UPDATE_CONNECTION );
DWORD APIENTRY  MprConfigServerGetInfoEx( HANDLE, MPR_SERVER_EX * );
DWORD APIENTRY  MprConfigServerSetInfoEx( HANDLE, MPR_SERVER_SET_CONFIG_EX * );
#endif

/* Functions implemented by administration providers */
BOOL APIENTRY   MprAdminAcceptNewConnection( RAS_CONNECTION_0 *, RAS_CONNECTION_1 * );
BOOL APIENTRY   MprAdminAcceptNewLink( RAS_PORT_0 *, RAS_PORT_1 * );
VOID APIENTRY   MprAdminConnectionHangupNotification( RAS_CONNECTION_0 *, RAS_CONNECTION_1 * );
DWORD APIENTRY  MprAdminGetIpAddressForUser( WCHAR *, WCHAR *, DWORD *, BOOL * );
VOID APIENTRY   MprAdminLinkHangupNotification( RAS_PORT_0 *, RAS_PORT_1 * );
VOID APIENTRY   MprAdminReleaseIpAddress( WCHAR *, WCHAR *, DWORD * );
#if (WINVER >= 0x0500)
BOOL APIENTRY   MprAdminAcceptNewConnection2( RAS_CONNECTION_0 *, RAS_CONNECTION_1 *, RAS_CONNECTION_2 * );
VOID APIENTRY   MprAdminConnectionHangupNotification2( RAS_CONNECTION_0 *, RAS_CONNECTION_1 *, RAS_CONNECTION_2 * );
DWORD APIENTRY  MprAdminInitializeDll( VOID );
DWORD APIENTRY  MprAdminTerminateDll( VOID );
#endif
#if (WINVER >= 0x0600)
BOOL APIENTRY   MprAdminAcceptNewConnection3( RAS_CONNECTION_0 *, RAS_CONNECTION_1 *, RAS_CONNECTION_2 *, RAS_CONNECTION_3 * );
BOOL APIENTRY   MprAdminAcceptReauthentication( RAS_CONNECTION_0 *, RAS_CONNECTION_1 *, RAS_CONNECTION_2 *, RAS_CONNECTION_3 * );
VOID APIENTRY   MprAdminConnectionHangupNotification3( RAS_CONNECTION_0 *, RAS_CONNECTION_1 *, RAS_CONNECTION_2 *,  RAS_CONNECTION_3 * );
DWORD APIENTRY  MprAdminGetIpv6AddressForUser( WCHAR *, WCHAR *, IN6_ADDR *, BOOL * );
VOID APIENTRY   MprAdminReleaseIpv6AddressForUser( WCHAR *, WCHAR *, IN6_ADDR * );
#endif
#if (WINVER >= 0x0601)
BOOL APIENTRY   MprAdminAcceptNewConnectionEx( RAS_CONNECTION_EX * );
BOOL APIENTRY   MprAdminAcceptReauthenticationEx( RAS_CONNECTION_EX * );
void APIENTRY   MprAdminConnectionHangupNotificationEx( RAS_CONNECTION_EX * );
DWORD APIENTRY  MprAdminInitializeDllEx( PMPRAPI_ADMIN_DLL_CALLBACKS );
#endif

/* Functions implemented as macros */
#define MprInfoBlockExists( p1, p2 ) \
    (MprInfoBlockFind( p1, p2, NULL, NULL, NULL ) == NO_ERROR)

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* __ROUTING_MPRADMIN_H__ */
