/*
 *  ks.h        Kernel streaming functions
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2014 The Open Watcom Contributors. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */

#ifndef _KS_
#define _KS_

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file;
#endif

#ifdef __cplusplus
extern "C" {
#endif

/* Macro to specify kernel streaming functions */
#define KSDDKAPI    DECLSPEC_IMPORT

/* Kernel streaming primitive data types */
typedef PVOID   PKSWORKER;
#ifdef _NTDDK_
typedef PVOID   PKSDEFAULTCLOCK;
typedef PVOID   KSDEVICE_HEADER;
typedef PVOID   KSOBJECT_HEADER;
typedef PVOID   KSOBJECT_BAG;
#endif

/* Forward declarations */
#ifdef _NTDDK_
#if (NTDDI_VERSION >= 0x05010000)
typedef struct _KSDEVICE_DESCRIPTOR     KSDEVICE_DESCRIPTOR;
typedef struct _KSDEVICE_DESCRIPTOR     *PKSDEVICE_DESCRIPTOR;
typedef struct _KSDEVICE_DISPATCH       KSDEVICE_DISPATCH;
typedef struct _KSDEVICE_DISPATCH       *PKSDEVICE_DISPATCH;
typedef struct _KSDEVICE                KSDEVICE;
typedef struct _KSDEVICE                *PKSDEVICE;
typedef struct _KSFILTERFACTORY         KSFILTERFACTORY;
typedef struct _KSFILTERFACTORY         *PKSFILTERFACTORY;
typedef struct _KSFILTER_DESCRIPTOR     KSFILTER_DESCRIPTOR;
typedef struct _KSFILTER_DESCRIPTOR     *PKSFILTER_DESCRIPTOR;
typedef struct _KSFILTER_DISPATCH       KSFILTER_DISPATCH;
typedef struct _KSFILTER_DISPATCH       *PKSFILTER_DISPATCH;
typedef struct _KSFILTER                KSFILTER;
typedef struct _KSFILTER                *PKSFILTER;
typedef struct _KSPIN_DESCRIPTOR_EX     KSPIN_DESCRIPTOR_EX;
typedef struct _KSPIN_DESCRIPTOR_EX     *PKSPIN_DESCRIPTOR_EX;
typedef struct _KSPIN_DISPATCH          KSPIN_DISPATCH;
typedef struct _KSPIN_DISPATCH          *PKSPIN_DISPATCH;
typedef struct _KSCLOCK_DISPATCH        KSCLOCK_DISPATCH;
typedef struct _KSCLOCK_DISPATCH        *PKSCLOCK_DISPATCH;
typedef struct _KSALLOCATOR_DISPATCH    KSALLOCATOR_DISPATCH;
typedef struct _KSALLOCATOR_DISPATCH    *PKSALLOCATOR_DISPATCH;
typedef struct _KSPIN                   KSPIN;
typedef struct _KSPIN                   *PKSPIN;
typedef struct _KSNODE_DESCRIPTOR       KSNODE_DESCRIPTOR;
typedef struct _KSNODE_DESCRIPTOR       *PKSNODE_DESCRIPTOR;
typedef struct _KSSTREAM_POINTER_OFFSET KSSTREAM_POINTER_OFFSET;
typedef struct _KSSTREAM_POINTER_OFFSET *PKSSTREAM_POINTER_OFFSET;
typedef struct _KSSTREAM_POINTER        KSSTREAM_POINTER;
typedef struct _KSSTREAM_POINTER        *PKSSTREAM_POINTER;
typedef struct _KSMAPPING               KSMAPPING;
typedef struct _KSMAPPING               *PKSMAPPING;
typedef struct _KSPROCESSPIN            KSPROCESSPIN;
typedef struct _KSPROCESSPIN            *PKSPROCESSPIN;
typedef struct _KSPROCESSPIN_INDEXENTRY KSPROCESSPIN_INDEXENTRY;
typedef struct _KSPROCESSPIN_INDEXENTRY *PKSPROCESSPIN_INDEXENTRY;
#endif
#endif

/* Kernel streaming I/O control codes */
#define IOCTL_KS_PROPERTY \
    CTL_CODE( FILE_DEVICE_KS, 0x0000, METHOD_NEITHER, FILE_ANY_ACCESS )
#define IOCTL_KS_ENABLE_EVENT \
    CTL_CODE( FILE_DEVICE_KS, 0x0001, METHOD_NEITHER, FILE_ANY_ACCESS )
#define IOCTL_KS_DISABLE_EVENT \
    CTL_CODE( FILE_DEVICE_KS, 0x0002, METHOD_NEITHER, FILE_ANY_ACCESS )
#define IOCTL_KS_METHOD \
    CTL_CODE( FILE_DEVICE_KS, 0x0003, METHOD_NEITHER, FILE_ANY_ACCESS )
#define IOCTL_KS_WRITE_STREAM \
    CTL_CODE( FILE_DEVICE_KS, 0x0004, METHOD_NEITHER, FILE_WRITE_ACCESS )
#define IOCTL_KS_READ_STREAM \
    CTL_CODE( FILE_DEVICE_KS, 0x0005, METHOD_NEITHER, FILE_READ_ACCESS )
#define IOCTL_KS_RESET_STATE \
    CTL_CODE( FILE_DEVICE_KS, 0x0006, METHOD_NEITHER, FILE_ANY_ACCESS )
#ifdef _NTDDK_
    #if (NTDDI_VERSION >= 0x05010000)
        #define IOCTL_KS_HANDSHAKE \
            CTL_CODE( FILE_DEVICE_KS, 0x0007, METHOD_NEITHER, FILE_ANY_ACCESS )
    #endif
#endif

/* Kernel streaming priority values */
#define KSPRIORITY_LOW          0x00000001L
#define KSPRIORITY_NORMAL       0x40000000L
#define KSPRIORITY_HIGH         0x80000000L
#define KSPRIORITY_EXCLUSIVE    0xFFFFFFFFL

/* Kernel streaming method types */
#define KSMETHOD_TYPE_NONE          0x00000000L
#define KSMETHOD_TYPE_READ          0x00000001L
#define KSMETHOD_TYPE_WRITE         0x00000002L
#define KSMETHOD_TYPE_MODIFY        0x00000003L
#define KSMETHOD_TYPE_SOURCE        0x00000004L
#define KSMETHOD_TYPE_SEND          0x00000001L
#define KSMETHOD_TYPE_SETSUPPORT    0x00000100L
#define KSMETHOD_TYPE_BASICSUPPORT  0x00000200L
#define KSMETHOD_TYPE_TOPOLOGY      0x10000000L

/* Kernel streaming property types */
#define KSPROPERTY_TYPE_GET             0x00000001L
#define KSPROPERTY_TYPE_SET             0x00000002L
#define KSPROPERTY_TYPE_SETSUPPORT      0x00000100L
#define KSPROPERTY_TYPE_BASICSUPPORT    0x00000200L
#define KSPROPERTY_TYPE_RELATIONS       0x00000400L
#define KSPROPERTY_TYPE_SERIALIZESET    0x00000800L
#define KSPROPERTY_TYPE_UNSERIALIZESET  0x00001000L
#define KSPROPERTY_TYPE_SERIALIZERAW    0x00002000L
#define KSPROPERTY_TYPE_UNSERIALIZERAW  0x00004000L
#define KSPROPERTY_TYPE_SERIALIZESIZE   0x00008000L
#define KSPROPERTY_TYPE_DEFAULTVALUES   0x00010000L
#define KSPROPERTY_TYPE_TOPOLOGY        0x10000000L

/* Kernel streaming property member flags */
#define KSPROPERTY_MEMBER_RANGES        0x00000001L
#define KSPROPERTY_MEMBER_STEPPEDRANGES 0x00000002L
#define KSPROPERTY_MEMBER_VALUES        0x00000003L

/* Kernel streaming property members header flags */
#define KSPROPERTY_MEMBER_FLAG_DEFAULT                          0x00000001L
#if (NTDDI_VERSION >= 0x05010000)
    #define KSPROPERTY_MEMBER_FLAG_BASICSUPPORT_MULTICHANNEL    0x00000002L
    #define KSPROPERTY_MEMBER_FLAG_BASICSUPPORT_UNIFORM         0x00000004L
#endif

/* Kernel streaming event flags */
#define KSEVENTF_EVENT_HANDLE           0x00000001L
#define KSEVENTF_SEMAPHORE_HANDLE       0x00000002L
#ifdef _NTDDK_
    #define KSEVENTF_EVENT_OBJECT       0x00000004L
    #define KSEVENTF_SEMAPHORE_OBJECT   0x00000008L
    #define KSEVENTF_DPC                0x00000010L
    #define KSEVENTF_WORKITEM           0x00000020L
    #define KSEVENTF_KSWORKITEM         0x00000080L
#endif

/* Kernel streaming event types */
#define KSEVENT_TYPE_ENABLE         0x00000001L
#define KSEVENT_TYPE_ONESHOT        0x00000002L
#define KSEVENT_TYPE_ENABLEBUFFERED 0x00000004L
#define KSEVENT_TYPE_SETSUPPORT     0x00000100L
#define KSEVENT_TYPE_BASICSUPPORT   0x00000200L
#define KSEVENT_TYPE_QUERYBUFFER    0x00000400L
#define KSEVENT_TYPE_TOPOLOGY       0x10000000L

/* Kernel streaming relative event flags */
#define KSRELATIVEEVENT_FLAG_HANDLE     0x00000001L
#define KSRELATIVEEVENT_FLAG_POINTER    0x00000002L

/* Kernel streaming node special values */
#define KSFILTER_NODE   0xFFFFFFFFL
#define KSALL_NODES     0xFFFFFFFFL

/* Kernel streaming media types */
#define KSMEDIUM_TYPE_ANYINSTANCE   0L
#define KSMEDIUM_STANDARD_DEVIO     KSMEDIUM_TYPE_ANYINSTANCE

/* Kernel streaming instance special value */
#define KSINSTANCE_INDETERMINATE    0xFFFFFFFFL

/* Kernel streaming data format bits */
#define KSDATAFORMAT_BIT_TEMPORAL_COMPRESSION   0
#define KSDATAFORMAT_BIT_ATTRIBUTES             1

/* Kernel streaming data format flags */
#define KSDATAFORMAT_TEMPORAL_COMPRESSION   0x00000001L
#define KSDATAFORMAT_ATTRIBUTES             0x00000002L

/* Kernel streaming data range bits */
#define KSDATARANGE_BIT_ATTRIBUTES          1
#define KSDATARANGE_BIT_REQUIRED_ATTRIBUTES 2

/* Kernel streaming data range flags */
#define KSDATARANGE_ATTRIBUTES          0x00000001L
#define KSDATARANGE_REQUIRED_ATTRIBUTES 0x00000002L

/* Kernel streaming attributes */
#define KSATTRIBUTE_REQUIRED    0x00000001L

/* Kernel streaming allocator requirement flags */
#define KSALLOCATOR_REQUIREMENTF_INPLACE_MODIFIER   0x00000001L
#define KSALLOCATOR_REQUIREMENTF_SYSTEM_MEMORY      0x00000002L
#define KSALLOCATOR_REQUIREMENTF_FRAME_INTEGRITY    0x00000004L
#define KSALLOCATOR_REQUIREMENTF_MUST_ALLOCATE      0x00000008L
#define KSALLOCATOR_REQUIREMENTF_PREFERENCES_ONLY   0x80000000L

/* Kernel streaming allocator option flags */
#define KSALLOCATOR_OPTIONF_COMPATIBLE      0x00000001L
#define KSALLOCATOR_OPTIONF_SYSTEM_MEMORY   0x00000002L
#define KSALLOCATOR_OPTIONF_VALID           0x00000003L

/* Kernel streaming allocator flags */
#define KSALLOCATOR_FLAG_PARTIAL_READ_SUPPORT       0x00000010L
#define KSALLOCATOR_FLAG_DEVICE_SPECIFIC            0x00000020L
#define KSALLOCATOR_FLAG_CAN_ALLOCATE               0x00000040L
#define KSALLOCATOR_FLAG_INSIST_ON_FRAMESIZE_RATIO  0x00000080L
#define KSALLOCATOR_FLAG_NO_FRAME_INTEGRITY         0x00000100L
#define KSALLOCATOR_FLAG_MULTIPLE_OUTPUT            0x00000200L
#define KSALLOCATOR_FLAG_CYCLE                      0x00000400L
#define KSALLOCATOR_FLAG_ALLOCATOR_EXISTS           0x00000800L
#define KSALLOCATOR_FLAG_INDEPENDENT_RANGES         0x00001000L
#define KSALLOCATOR_FLAG_ATTENTION_STEPPING         0x00002000L

/* Kernel streaming stream header options flags */
#define KSSTREAM_HEADER_OPTIONSF_SPLICEPOINT        0x00000001L
#define KSSTREAM_HEADER_OPTIONSF_PREROLL            0x00000002L
#define KSSTREAM_HEADER_OPTIONSF_DATADISCONTINUITY  0x00000004L
#define KSSTREAM_HEADER_OPTIONSF_TYPECHANGED        0x00000008L
#define KSSTREAM_HEADER_OPTIONSF_TIMEVALID          0x00000010L
#define KSSTREAM_HEADER_OPTIONSF_TIMEDISCONTINUITY  0x00000040L
#define KSSTREAM_HEADER_OPTIONSF_FLUSHONPAUSE       0x00000080L
#define KSSTREAM_HEADER_OPTIONSF_DURATIONVALID      0x00000100L
#define KSSTREAM_HEADER_OPTIONSF_ENDOFSTREAM        0x00000200L
#define KSSTREAM_HEADER_OPTIONSF_BUFFEREDTRANSFER   0x00000400L
#define KSSTREAM_HEADER_OPTIONSF_VRAM_DATA_TRANSFER 0x00000800L
#define KSSTREAM_HEADER_OPTIONSF_LOOPEDDATA         0x80000000L

/* Kernel streaming frame time flags */
#define KSFRAMETIME_VARIABLESIZE    0x00000001L

/* Kernel streaming rate flags */
#define KSRATE_NOPRESENTATIONSTART      0x00000001L
#define KSRATE_NOPRESENTATIONDURATION   0x00000002L

/* Kernel streaming probe flags */
#ifdef _NTDDK_
    #define KSPROBE_STREAMREAD           0x00000000L
    #define KSPROBE_STREAMWRITE          0x00000001L
    #define KSPROBE_ALLOCATEMDL          0x00000010L
    #define KSPROBE_PROBEANDLOCK         0x00000020L
    #define KSPROBE_SYSTEMADDRESS        0x00000040L
    #define KSPROBE_ALLOWFORMATCHANGE    0x00000080L
    #define KSPROBE_MODIFY               0x00000200L
    #define KSPROBE_STREAMWRITEMODIFY    (KSPROBE_MODIFY | KSPROBE_STREAMWRITE)
#endif

/* Kernel streaming stream flags */
#ifdef _NTDDK_
    #define KSSTREAM_READ               KSPROBE_STREAMREAD
    #define KSSTREAM_WRITE              KSPROBE_STREAMWRITE
    #define KSSTREAM_PAGED_DATA         0x00000000L
    #define KSSTREAM_NONPAGED_DATA      0x00000100L
    #define KSSTREAM_SYNCHRONOUS        0x00001000L
    #define KSSTREAM_FAILUREEXCEPTION   0x00002000L
#endif

/* Kernel streaming event entry flags */
#ifdef _NTDDK_
    #define KSEVENT_ENTRY_DELETED   0x00000001L
    #define KSEVENT_ENTRY_ONESHOT   0x00000002L
    #define KSEVENT_ENTRY_BUFFERED  0x00000004L
#endif

/* Kernel streaming dispatch flags */
#ifdef _NTDDK_
    #define KSDISPATCH_FASTIO   0x80000000L
#endif

/* Kernel streaming object create item flags */
#ifdef _NTDDK_
    #define KSCREATE_ITEM_SECURITYCHANGED   0x00000001L
    #define KSCREATE_ITEM_WILDCARD          0x00000002L
    #define KSCREATE_ITEM_NOPARAMETERS      0x00000004L
    #define KSCREATE_ITEM_FREEONSTOP        0x00000008L
#endif

/* Bus interface reference version number */
#ifdef _NTDDK_
    #define BUS_INTERFACE_REFERENCE_VERSION 0x0100
#endif

/* Kernel streaming device descriptor version numbers */
#ifdef _NTDDK_
    #if (NTDDI_VERSION >= 0x05010000)
        #define KSDEVICE_DESCRIPTOR_VERSION     0x00000100L
    #endif
    #if (NTDDI_VERSION >= 0x06000000)
        #define KSDEVICE_DESCRIPTOR_VERSION_2   0x00000110L
    #endif
#endif

/* Kernel streaming device flags */
#ifdef _NTDDK_
    #if (NTDDI_VERSION >= 0x06000000)
        #define KSDEVICE_FLAG_ENABLE_REMOTE_WAKEUP  0x00000001L
        #define KSDEVICE_FLAG_LOWPOWER_PASSTHROUGH  0x00000002L
    #endif
#endif

/* Kernel streaming filter descriptor version number */
#ifdef _NTDDK_
    #if (NTDDI_VERSION >= 0x05010000)
        #define KSFILTER_DESCRIPTOR_VERSION 0xFFFFFFFFL
    #endif
#endif

/* Kernel streaming filter flags */
#ifdef _NTDDK_
    #if (NTDDI_VERSION >= 0x05010000)
        #define KSFILTER_FLAG_DISPATCH_LEVEL_PROCESSING     0x00000001L
        #define KSFILTER_FLAG_CRITICAL_PROCESSING           0x00000002L
        #define KSFILTER_FLAG_HYPERCRITICAL_PROCESSING      0x00000004L
        #define KSFILTER_FLAG_RECEIVE_ZERO_LENGTH_SAMPLES   0x00000008L
    #endif
    #if (NTDDI_VERSION >= 0x06000000)
        #define KSFILTER_FLAG_DENY_USERMODE_ACCESS          0x80000000L
    #endif
#endif

/* Kernel streaming pin flags */
#ifdef _NTDDK_
    #if (NTDDI_VERSION >= 0x05010000)
        #define KSPIN_FLAG_DISPATCH_LEVEL_PROCESSING \
            KSFILTER_FLAG_DISPATCH_LEVEL_PROCESSING
        #define KSPIN_FLAG_CRITICAL_PROCESSING \
            KSFILTER_FLAG_CRITICAL_PROCESSING
        #define KSPIN_FLAG_HYPERCRITICAL_PROCESSING \
            KSFILTER_FLAG_HYPERCRITICAL_PROCESSING
        #define KSPIN_FLAG_ASYNCHRONOUS_PROCESSING              0x00000008L
        #define KSPIN_FLAG_DO_NOT_INITIATE_PROCESSING           0x00000010L
        #define KSPIN_FLAG_INITIATE_PROCESSING_ON_EVERY_ARRIVAL 0x00000020L
        #define KSPIN_FLAG_FRAMES_NOT_REQUIRED_FOR_PROCESSING   0x00000040L
        #define KSPIN_FLAG_ENFORCE_FIFO                         0x00000080L
        #define KSPIN_FLAG_GENERATE_MAPPINGS                    0x00000100L
        #define KSPIN_FLAG_DISTINCT_TRAILING_EDGE               0x00000200L
        #define KSPIN_FLAG_PROCESS_IN_RUN_STATE_ONLY            0x00010000L
        #define KSPIN_FLAG_SPLITTER                             0x00020000L
        #define KSPIN_FLAG_USE_STANDARD_TRANSPORT               0x00040000L
        #define KSPIN_FLAG_DO_NOT_USE_STANDARD_TRANSPORT        0x00080000L
        #define KSPIN_FLAG_FIXED_FORMAT                         0x00100000L
        #define KSPIN_FLAG_GENERATE_EOS_EVENTS                  0x00200000L
        #define KSPIN_FLAG_RENDERER \
            (KSPIN_FLAG_PROCESS_IN_RUN_STATE_ONLY | KSPIN_FLAG_GENERATE_EOS_EVENTS)
        #define KSPIN_FLAG_IMPLEMENT_CLOCK                      0x00400000L
        #define KSPIN_FLAG_SOME_FRAMES_REQUIRED_FOR_PROCESSING  0x00800000L
        #define KSPIN_FLAG_PROCESS_IF_ANY_IN_RUN_STATE          0x01000000L
    #endif
    #if (NTDDI_VERSION >= 0x05010200)
        #define KSPIN_FLAG_DENY_USERMODE_ACCESS                 0x80000000L
    #endif
#endif

/* Definitions from winuser.h for device drivers */
#ifdef _NTDDK_
    #define MAKEINTRESOURCE( x )    ((ULONG_PTR)(USHORT)x)
    #define RT_STRING               MAKEINTRESOURCE( 6 )
    #define RT_RCDATA               MAKEINTRESOURCE( 10 )
#endif

/* Kernel streaming reset constants */
typedef enum {
    KSRESET_BEGIN   = 0,
    KSRESET_END     = 1
} KSRESET;

/* Kernel streaming states */
typedef enum {
    KSSTATE_STOP    = 0,
    KSSTATE_ACQUIRE = 1,
    KSSTATE_PAUSE   = 2,
    KSSTATE_RUN     = 3
} KSSTATE;
typedef KSSTATE *PKSSTATE;

/* Kernel streaming priority */
typedef struct {
    ULONG   PriorityClass;
    ULONG   PrioritySubClass;
} KSPRIORITY;
typedef KSPRIORITY  *PKSPRIORITY;

/* Kernel streaming identifier */
typedef struct {
    union {
        struct {
            GUID    Set;
            ULONG   Id;
            ULONG   Flags;
        };
        LONGLONG    Alignment;
    };
} KSIDENTIFIER;
typedef KSIDENTIFIER    *PKSIDENTIFIER;
typedef KSIDENTIFIER    KSPROPERTY;
typedef KSIDENTIFIER    *PKSPROPERTY;
typedef KSIDENTIFIER    KSMETHOD;
typedef KSIDENTIFIER    *PKSMETHOD;
typedef KSIDENTIFIER    KSEVENT;
typedef KSIDENTIFIER    *PKSEVENT;
typedef KSIDENTIFIER    KSPIN_INTERFACE;
typedef KSIDENTIFIER    *PKSPIN_INTERFACE;
typedef KSIDENTIFIER    KSPIN_MEDIUM;
typedef KSIDENTIFIER    *PKSPIN_MEDIUM;
typedef KSIDENTIFIER    KSDEGRADE;
typedef KSIDENTIFIER    *PKSDEGRADE;

/* Kernel streaming property node */
typedef struct {
    KSPROPERTY  Property;
    ULONG       NodeId;
    ULONG       Reserved;
} KSP_NODE;
typedef KSP_NODE    *PKSP_NODE;

/* Kernel streaming method node */
typedef struct {
    KSMETHOD    Method;
    ULONG       NodeId;
    ULONG       Reserved;
} KSM_NODE;
typedef KSM_NODE    *PKSM_NODE;

/* Kernel streaming event node */
typedef struct {
    KSEVENT Event;
    ULONG   NodeId;
    ULONG   Reserved;
} KSE_NODE;
typedef KSE_NODE    *PKSE_NODE;

/* Variant types */
#ifndef __wtypes_h__
enum VARENUM {
    VT_EMPTY            = 0,
    VT_NULL             = 1,
    VT_I2               = 2,
    VT_I4               = 3,
    VT_R4               = 4,
    VT_R8               = 5,
    VT_CY               = 6,
    VT_DATE             = 7,
    VT_BSTR             = 8,
    VT_DISPATCH         = 9,
    VT_ERROR            = 10,
    VT_BOOL             = 11,
    VT_VARIANT          = 12,
    VT_UNKNOWN          = 13,
    VT_DECIMAL          = 14,
    VT_I1               = 16,
    VT_UI1              = 17,
    VT_UI2              = 18,
    VT_UI4              = 19,
    VT_I8               = 20,
    VT_UI8              = 21,
    VT_INT              = 22,
    VT_UINT             = 23,
    VT_VOID             = 24,
    VT_HRESULT          = 25,
    VT_PTR              = 26,
    VT_SAFEARRAY        = 27,
    VT_CARRAY           = 28,
    VT_USERDEFINED      = 29,
    VT_LPSTR            = 30,
    VT_LPWSTR           = 31,
    VT_RECORD           = 36,
    VT_INT_PTR          = 37,
    VT_UINT_PTR         = 38,
    VT_FILETIME         = 64,
    VT_BLOB             = 65,
    VT_STREAM           = 66,
    VT_STORAGE          = 67,
    VT_STREAMED_OBJECT  = 68,
    VT_STORED_OBJECT    = 69,
    VT_BLOB_OBJECT      = 70,
    VT_CF               = 71,
    VT_CLSID            = 72,
    VT_VERSIONED_STREAM = 73,
    VT_BSTR_BLOB        = 0x0FFF,
    VT_VECTOR           = 0x1000,
    VT_ARRAY            = 0x2000,
    VT_BYREF            = 0x4000,
    VT_RESERVED         = 0x8000,
    VT_ILLEGAL          = 0xFFFF,
    VT_ILLEGALMASKED    = 0x0FFF,
    VT_TYPEMASK         = 0x0FFF
};
#endif

/* Kernel streaming multiple item */
typedef struct {
    ULONG   Size;
    ULONG   Count;
} KSMULTIPLE_ITEM;
typedef KSMULTIPLE_ITEM *PKSMULTIPLE_ITEM;

/* Kernel streaming property description */
typedef struct {
    ULONG           AccessFlags;
    ULONG           DescriptionSize;
    KSIDENTIFIER    PropTypeSet;
    ULONG           MembersListCount;
    ULONG           Reserved;
} KSPROPERTY_DESCRIPTION;
typedef KSPROPERTY_DESCRIPTION  *PKSPROPERTY_DESCRIPTION;

/* Kernel streaming property members header */
typedef struct {
    ULONG   MembersFlags;
    ULONG   MembersSize;
    ULONG   MembersCount;
    ULONG   Flags;
} KSPROPERTY_MEMBERSHEADER;
typedef KSPROPERTY_MEMBERSHEADER    *PKSPROPERTY_MEMBERSHEADER;

/* Kernel streaming property bounds (32-bit version) */
typedef union {
    struct {
        LONG    SignedMinimum;
        LONG    SignedMaximum;
    };
    struct {
        ULONG   UnsignedMinimum;
        ULONG   UnsignedMaximum;
    };
} KSPROPERTY_BOUNDS_LONG;
typedef KSPROPERTY_BOUNDS_LONG  *PKSPROPERTY_BOUNDS_LONG;

/* Kernel streaming property bounds (64-bit version) */
typedef union {
    struct {
        LONGLONG    SignedMinimum;
        LONGLONG    SignedMaximum;
    };
    struct {
#ifdef _NTDDK_
        ULONGLONG   UnsignedMinimum;
        ULONGLONG   UnsignedMaximum;
#else
        DWORDLONG   UnsignedMinimum;
        DWORDLONG   UnsignedMaximum;
#endif
    };
} KSPROPERTY_BOUNDS_LONGLONG;
typedef KSPROPERTY_BOUNDS_LONGLONG  *PKSPROPERTY_BOUNDS_LONGLONG;

/* Kernel streaming property stepping (32-bit version) */
typedef struct {
    ULONG                   SteppingDelta;
    ULONG                   Reserved;
    KSPROPERTY_BOUNDS_LONG  Bounds;
} KSPROPERTY_STEPPING_LONG;
typedef KSPROPERTY_STEPPING_LONG    *PKSPROPERTY_STEPPING_LONG;

/* Kernel streaming property stepping (64-bit version) */
typedef struct {
#ifdef _NTDDK_
    ULONGLONG                   SteppingDelta;
#else
    DWORDLONG                   SteppingDelta;
#endif
    KSPROPERTY_BOUNDS_LONGLONG  Bounds;
} KSPROPERTY_STEPPING_LONGLONG;
typedef KSPROPERTY_STEPPING_LONGLONG    *PKSPROPERTY_STEPPING_LONGLONG;

/* Kernel streaming event data */
typedef struct {
    ULONG   NotificationType;
    union {
        struct {
            HANDLE      Event;
            ULONG_PTR   Reserved[2];
        } EventHandle;
        struct {
            HANDLE      Semaphore;
            ULONG       Reserved;
            LONG        Adjustment;
        } SemaphoreHandle;
#ifdef _NTDDK_
        struct {
            PVOID       Event;
            KPRIORITY   Increment;
            ULONG_PTR   Reserved;
        } EventObject;
        struct {
            PVOID       Semaphore;
            KPRIORITY   Increment;
            LONG        Adjustment;
        } SemaphoreObject;
        struct {
            PKDPC       Dpc;
            ULONG       ReferenceCount;
            ULONG_PTR   Reserved;
        } Dpc;
        struct {
            PWORK_QUEUE_ITEM    WorkQueueItem;
            WORK_QUEUE_TYPE     WorkQueueType;
            ULONG_PTR           Reserved;
        } WorkItem;
        struct {
            PWORK_QUEUE_ITEM    WorkQueueItem;
            PKSWORKER           KsWorkerObject;
            ULONG_PTR           Reserved;
        } KsWorkItem;
#endif
        struct {
            PVOID       Unused;
            LONG_PTR    Alignment[2];
        } Alignment;
    };
} KSEVENTDATA;
typedef KSEVENTDATA *PKSEVENTDATA;

/* Kernel streaming query buffer */
typedef struct {
    KSEVENT         Event;
    PKSEVENTDATA    EventData;
    PVOID           Reserved;
} KSQUERYBUFFER;
typedef KSQUERYBUFFER   *PKSQUERYBUFFER;

/* Kernel streaming relative event */
typedef struct {
    ULONG       Size;
    ULONG       Flags;
    union {
        HANDLE  ObjectHandle;
        PVOID   ObjectPointer;
    };
    PVOID       Reserved;
    KSEVENT     Event;
    KSEVENTDATA EventData;
} KSRELATIVEEVENT;

/* Kernel streaming event time mark */
typedef struct {
    KSEVENTDATA EventData;
    LONGLONG    MarkTime;
} KSEVENT_TIME_MARK;
typedef KSEVENT_TIME_MARK   *PKSEVENT_TIME_MARK;

/* Kernel streaming event time interval */
typedef struct {
    KSEVENTDATA EventData;
    LONGLONG    TimeBase;
    LONGLONG    Interval;
} KSEVENT_TIME_INTERVAL;
typedef KSEVENT_TIME_INTERVAL   *PKSEVENT_TIME_INTERVAL;

/* Kernel streaming interval */
typedef struct {
    LONGLONG    TimeBase;
    LONGLONG    Interval;
} KSINTERVAL;

/* Kernel streaming general properties */
typedef enum {
    KSPROPERTY_GENERAL_COMPONENTID  = 0
} KSPROPERTY_GENERAL;

/* Kernel streaming component identifier */
typedef struct {
    GUID    Manufacturer;
    GUID    Product;
    GUID    Component;
    GUID    Name;
    ULONG   Version;
    ULONG   Revision;
} KSCOMPONENTID;
typedef KSCOMPONENTID   *PKSCOMPONENTID;

/* Kernel streaming stream I/O methods */
typedef enum {
    KSMETHOD_STREAMIO_READ  = 0,
    KSMETHOD_STREAMIO_WRITE = 1
} KSMETHOD_STREAMIO;

/* Kernel streaming media seeking properties */
typedef enum {
    KSPROPERTY_MEDIASEEKING_CAPABILITIES        = 0,
    KSPROPERTY_MEDIASEEKING_FORMATS             = 1,
    KSPROPERTY_MEDIASEEKING_TIMEFORMAT          = 2,
    KSPROPERTY_MEDIASEEKING_POSITION            = 3,
    KSPROPERTY_MEDIASEEKING_STEPPOSITION        = 4,
    KSPROPERTY_MEDIASEEKING_POSITIONS           = 5,
    KSPROPERTY_MEDIASEEKING_DURATION            = 6,
    KSPROPERTY_MEDIASEEKING_AVAILABLE           = 7,
    KSPROPERTY_MEDIASEEKING_PREROLL             = 8,
    KSPROPERTY_MEDIASEEKING_CONVERTTIMEFORMAT   = 9
} KSPROPERTY_MEDIASEEKING;

/* Kernel streaming seeking flags */
typedef enum {
    KS_SEEKING_NoPositioning            = 0x00000000,
    KS_SEEKING_AbsolutePositioning      = 0x00000001,
    KS_SEEKING_RelativePositioning      = 0x00000002,
    KS_SEEKING_IncrementalPositioning   = 0x00000003,
    KS_SEEKING_PositioningBitsMask      = 0x00000003,
    KS_SEEKING_SeekToKeyFrame           = 0x00000004,
    KS_SEEKING_ReturnTime               = 0x00000008
} KS_SEEKING_FLAGS;

/* Kernel streaming seeking capabilities */
typedef enum {
    KS_SEEKING_CanSeekAbsolute  = 0x00000001,
    KS_SEEKING_CanSeekForwards  = 0x00000002,
    KS_SEEKING_CanSeekBackwards = 0x00000004,
    KS_SEEKING_CanGetCurrentPos = 0x00000008,
    KS_SEEKING_CanGetStopPos    = 0x00000010,
    KS_SEEKING_CanGetDuration   = 0x00000020,
    KS_SEEKING_CanPlayBackwards = 0x00000040
} KS_SEEKING_CAPABILITIES;

/* Kernel streaming positions property */
typedef struct {
    LONGLONG            Current;
    LONGLONG            Stop;
    KS_SEEKING_FLAGS    CurrentFlags;
    KS_SEEKING_FLAGS    StopFlags;
} KSPROPERTY_POSITIONS;
typedef KSPROPERTY_POSITIONS    *PKSPROPERTY_POSITIONS;

/* Kernel streaming media available property */
typedef struct {
    LONGLONG    Earliest;
    LONGLONG    Latest;
} KSPROPERTY_MEDIAAVAILABLE;
typedef KSPROPERTY_MEDIAAVAILABLE   *PKSPROPERTY_MEDIAAVAILABLE;

/* Kernel streaming property time format */
typedef struct {
    KSPROPERTY  Property;
    GUID        SourceFormat;
    GUID        TargetFormat;
    LONGLONG    Time;
} KSP_TIMEFORMAT;
typedef KSP_TIMEFORMAT  *PKSP_TIMEFORMAT;

/* Kernel streaming topology properties */
typedef enum {
    KSPROPERTY_TOPOLOGY_CATEGORIES  = 0,
    KSPROPERTY_TOPOLOGY_NODES       = 1,
    KSPROPERTY_TOPOLOGY_CONNECTIONS = 2,
    KSPROPERTY_TOPOLOGY_NAME        = 3
} KSPROPERTY_TOPOLOGY;

/* Kernel streaming graph manager notification callback */
#ifdef _NTDDK_
typedef VOID (NTAPI *PFNKSGRAPHMANAGER_NOTIFY)( PFILE_OBJECT, ULONG, PVOID, PVOID, PVOID, ULONG );
#endif

/* Kernel streaming graph manager function table */
#ifdef _NTDDK_
typedef struct KSGRAPHMANAGER_FUNCTIONTABLE {
    PFNKSGRAPHMANAGER_NOTIFY    NotifyEvent;
} KSGRAPHMANAGER_FUNCTIONTABLE;
typedef KSGRAPHMANAGER_FUNCTIONTABLE    *PKSGRAPHMANAGER_FUNCTIONTABLE;
#endif

/* Kernel streaming graph manager interface property */
#ifdef _NTDDK_
typedef struct _KSPROPERTY_GRAPHMANAGER_INTERFACE {
    PFILE_OBJECT                    GraphManager;
    PKSGRAPHMANAGER_FUNCTIONTABLE   FunctionTable;
} KSPROPERTY_GRAPHMANAGER_INTERFACE;
typedef KSPROPERTY_GRAPHMANAGER_INTERFACE   *PKSPROPERTY_GRAPHMANAGER_INTERFACE;
#endif

/* Kernel streaming graph manager commands */
#ifdef _NTDDK_
typedef enum {
    KSPROPERTY_GM_GRAPHMANAGER      = 0,
    KSPROPERTY_GM_TIMESTAMP_CLOCK   = 1,
    KSPROPERTY_GM_RATEMATCH         = 2,
    KSPROPERTY_GM_RENDER_CLOCK      = 3
} KSPROPERTY_GM;
#endif

/* Kernel streaming topology connection */
typedef struct {
    ULONG   FromNode;
    ULONG   FromNodePin;
    ULONG   ToNode;
    ULONG   ToNodePin;
} KSTOPOLOGY_CONNECTION;
typedef KSTOPOLOGY_CONNECTION   *PKSTOPOLOGY_CONNECTION;

/* Kernel streaming topology */
typedef struct {
    ULONG       CategoriesCount;
    const GUID  *Categories;
    ULONG       TopologyNodesCount;
    const GUID  *TopologyNodes;
    ULONG       TopologyConnectionsCount;
    const KSTOPOLOGY_CONNECTION *TopologyConnections;
    const GUID  *TopologyNodesNames;
    ULONG       Reserved;
} KSTOPOLOGY;
typedef KSTOPOLOGY  *PKSTOPOLOGY;

/* Kernel streaming node creation parameters */
typedef struct {
    ULONG   CreateFlags;
    ULONG   Node;
} KSNODE_CREATE;
typedef KSNODE_CREATE   *PKSNODE_CREATE;

/* Kernel streaming standard interfaces */
typedef enum {
    KSINTERFACE_STANDARD_STREAMING          = 0,
    KSINTERFACE_STANDARD_LOOPED_STREAMING   = 1,
    KSINTERFACE_STANDARD_CONTROL            = 2
} KSINTERFACE_STANDARD;

/* Kernel streaming file I/O interfaces */
typedef enum {
    KSINTERFACE_FILEIO_STREAMING    = 0
} KSINTERFACE_FILEIO;

/* Kernel streaming pin properties */
typedef enum {
    KSPROPERTY_PIN_CINSTANCES               = 0,
    KSPROPERTY_PIN_CTYPES                   = 1,
    KSPROPERTY_PIN_DATAFLOW                 = 2,
    KSPROPERTY_PIN_DATARANGES               = 3,
    KSPROPERTY_PIN_DATAINTERSECTION         = 4,
    KSPROPERTY_PIN_INTERFACES               = 5,
    KSPROPERTY_PIN_MEDIUMS                  = 6,
    KSPROPERTY_PIN_COMMUNICATIONS           = 7,
    KSPROPERTY_PIN_GLOBALCINSTANCES         = 8,
    KSPROPERTY_PIN_NECESSARYINSTANCES       = 9,
    KSPROPERTY_PIN_PHYSICALCONNECTION       = 10,
    KSPROPERTY_PIN_CATEGORY                 = 11,
    KSPROPERTY_PIN_NAME                     = 12,
    KSPROPERTY_PIN_CONSTRAINEDDATARANGES    = 13,
    KSPROPERTY_PIN_PROPOSEDATAFORMAT        = 14
} KSPROPERTY_PIN;

/* Kernel streaming pin property */
typedef struct {
    KSPROPERTY  Property;
    ULONG       PinId;
    ULONG       Reserved;
} KSP_PIN;
typedef KSP_PIN *PKSP_PIN;

/* Kernel stream pin event */
typedef struct {
    KSEVENT Event;
    ULONG   PinId;
    ULONG   Reserved;
} KSE_PIN;
typedef KSE_PIN *PKSE_PIN;

/* Kernel streaming pin instance count property */
typedef struct {
    ULONG   PossibleCount;
    ULONG   CurrentCount;
} KSPIN_CINSTANCES;
typedef KSPIN_CINSTANCES    *PKSPIN_CINSTANCES;

/* Kernel streaming pin dataflow property */
typedef enum {
    KSPIN_DATAFLOW_IN   = 1,
    KSPIN_DATAFLOW_OUT  = 2
} KSPIN_DATAFLOW;
typedef KSPIN_DATAFLOW  *PKSPIN_DATAFLOW;

/* Kernel streaming data format */
typedef union {
    struct {
        ULONG   FormatSize;
        ULONG   Flags;
        ULONG   SampleSize;
        ULONG   Reserved;
        GUID    MajorFormat;
        GUID    SubFormat;
        GUID    Specifier;
    };
    LONGLONG    Alignment;
} KSDATAFORMAT;
typedef KSDATAFORMAT    *PKSDATAFORMAT;
typedef KSDATAFORMAT    KSDATARANGE;
typedef KSDATAFORMAT    *PKSDATARANGE;

/* Kernel streaming attribute */
typedef struct {
    ULONG   Size;
    ULONG   Flags;
    GUID    Attribute;
} KSATTRIBUTE;
typedef KSATTRIBUTE *PKSATTRIBUTE;

/* Kernel streaming attribute list */
#ifdef _NTDDK_
typedef struct {
    ULONG           Count;
    PKSATTRIBUTE    *Attributes;
} KSATTRIBUTE_LIST;
typedef KSATTRIBUTE_LIST    *PKSATTRIBUTE_LIST;
#endif

/* Kernel streaming pin communication constants */
typedef enum {
    KSPIN_COMMUNICATION_NONE    = 0,
    KSPIN_COMMUNICATION_SINK    = 1,
    KSPIN_COMMUNICATION_SOURCE  = 2,
    KSPIN_COMMUNICATION_BOTH    = 3,
    KSPIN_COMMUNICATION_BRIDGE  = 4,
} KSPIN_COMMUNICATION;
typedef KSPIN_COMMUNICATION *PKSPIN_COMMUNICATION;

/* Kernel streaming pin connect information */
typedef struct {
    KSPIN_INTERFACE Interface;
    KSPIN_MEDIUM    Medium;
    ULONG           PinId;
    HANDLE          PinToHandle;
    KSPRIORITY      Priority;
} KSPIN_CONNECT;
typedef KSPIN_CONNECT   *PKSPIN_CONNECT;

/* Kernel streaming pin physical connection */
typedef struct {
    ULONG   Size;
    ULONG   Pin;
    WCHAR   SymbolicLinkName[1];
} KSPIN_PHYSICALCONNECTION;
typedef KSPIN_PHYSICALCONNECTION    *PKSPIN_PHYSICALCONNECTION;

/* Kernel streaming intersect handler callback */
#ifdef _NTDDK_
typedef NTSTATUS (NTAPI *PFNKSINTERSECTHANDLER)( PIRP, PKSP_PIN, PKSDATARANGE, PVOID );
typedef NTSTATUS (NTAPI *PFNKSINTERSECTHANDLEREX)( PVOID, PIRP, PKSP_PIN, PKSDATARANGE, PKSDATARANGE, ULONG, PVOID, PULONG );
#endif

/* Kernel streaming pin capabilities change notifications */
typedef enum {
    KSEVENT_PINCAPS_FORMATCHANGE    = 0,
    KSEVENT_PINCAPS_JACKINFOCHANGE  = 1
} KSEVENT_PINCAPS_CHANGENOTIFICATIONS;

/* Kernel streaming pin descriptor */
#ifdef _NTDDK_
typedef struct {
    ULONG                   InterfacesCount;
    const KSPIN_INTERFACE   *Interfaces;
    ULONG                   MediumsCount;
    const KSPIN_MEDIUM      *Mediums;
    ULONG                   DataRangesCount;
    const PKSDATARANGE      *DataRanges;
    KSPIN_DATAFLOW          DataFlow;
    KSPIN_COMMUNICATION     Communication;
    const GUID              *Category;
    const GUID              *Name;
    union {
        LONGLONG    Reserved;
        struct {
            ULONG           ConstrainedDataRangesCount;
            PKSDATARANGE    *ConstrainedDataRanges;
        };
    };
} KSPIN_DESCRIPTOR;
typedef KSPIN_DESCRIPTOR        *PKSPIN_DESCRIPTOR;
typedef const KSPIN_DESCRIPTOR  *PCKSPIN_DESCRIPTOR;
#endif

/* Kernel streaming quality properties */
typedef enum {
    KSPROPERTY_QUALITY_REPORT   = 0,
    KSPROPERTY_QUALITY_ERROR    = 1
} KSPROPERTY_QUALITY;

/* Kernel streaming connection properties */
typedef enum {
    KSPROPERTY_CONNECTION_STATE                 = 0,
    KSPROPERTY_CONNECTION_PRIORITY              = 1,
    KSPROPERTY_CONNECTION_DATAFORMAT            = 2,
    KSPROPERTY_CONNECTION_ALLOCATORFRAMING      = 3,
    KSPROPERTY_CONNECTION_PROPOSEDATAFORMAT     = 4,
    KSPROPERTY_CONNECTION_ACQUIREORDERING       = 5,
    KSPROPERTY_CONNECTION_ALLOCATORFRAMING_EX   = 6,
    KSPROPERTY_CONNECTION_STARTAT               = 7
} KSPROPERTY_CONNECTION;

/* Kernel streaming memory transport properties */
enum {
    KSPROPERTY_MEMORY_TRANSPORT = 1
};

/* Kernel streaming allocator framing */
typedef struct {
    union {
        ULONG   OptionsFlags;
        ULONG   RequirementsFlags;
    };
#ifdef _NTDDK_
    POOL_TYPE   PoolType;
#else
    ULONG       PoolType;
#endif
    ULONG       Frames;
    ULONG       FrameSize;
    ULONG       FileAlignment;
    ULONG       Reserved;
} KSALLOCATOR_FRAMING;
typedef KSALLOCATOR_FRAMING *PKSALLOCATOR_FRAMING;

/* Kernel streaming allocator callbacks */
#ifdef _NTDDK_
typedef PVOID (NTAPI *PFNKSDEFAULTALLOCATE)( PVOID );
typedef VOID (NTAPI *PFNKSDEFAULTFREE)( PVOID, PVOID );
typedef NTSTATUS (NTAPI *PFNKSINITIALIZEALLOCATOR)( PVOID, PKSALLOCATOR_FRAMING, PVOID * );
typedef VOID (NTAPI *PFNKSDELETEALLOCATOR)( PVOID );
#endif

/* Kernel streaming framing range */
typedef struct {
    ULONG   MinFrameSize;
    ULONG   MaxFrameSize;
    ULONG   Stepping;
} KS_FRAMING_RANGE;
typedef KS_FRAMING_RANGE    *PKS_FRAMING_RANGE;

/* Kernel streaming weighted framing range */
typedef struct {
    KS_FRAMING_RANGE    Range;
    ULONG               InPlaceWeight;
    ULONG               NotInPlaceWeight;
} KS_FRAMING_RANGE_WEIGHTED;
typedef KS_FRAMING_RANGE_WEIGHTED   *PKS_FRAMING_RANGE_WEIGHTED;

/* Kernel streaming compression */
typedef struct {
    ULONG   RatioNumerator;
    ULONG   RatioDenominator;
    ULONG   RatioConstantMargin;
} KS_COMPRESSION;
typedef KS_COMPRESSION  *PKS_COMPRESSION;

/* Kernel streaming framing item */
typedef struct {
    GUID                        MemoryType;
    GUID                        BusType;
    ULONG                       MemoryFlags;
    ULONG                       BusFlags;
    ULONG                       Flags;
    ULONG                       Frames;
    ULONG                       FileAlignment;
    ULONG                       MemoryTypeWeight;
    KS_FRAMING_RANGE            PhysicalRange;
    KS_FRAMING_RANGE_WEIGHTED   FramingRange;
} KS_FRAMING_ITEM;
typedef KS_FRAMING_ITEM *PKS_FRAMING_ITEM;

/* Kernel streaming allocator framing (extended version) */
typedef struct {
    ULONG           CountItems;
    ULONG           PinFlags;
    KS_COMPRESSION  OutputCompression;
    ULONG           PinWeight;
    KS_FRAMING_ITEM FramingItem[1];
} KSALLOCATOR_FRAMING_EX;
typedef KSALLOCATOR_FRAMING_EX  *PKSALLOCATOR_FRAMING_EX;

/* Kernel streaming stream allocator events */
typedef enum {
    KSEVENT_STREAMALLOCATOR_INTERNAL_FREEFRAME  = 0,
    KSEVENT_STREAMALLOCATOR_FREEFRAME           = 1
} KSEVENT_STREAMALLOCATOR;

/* Kernel streaming stream allocator methods */
typedef enum {
    KSMETHOD_STREAMALLOCATOR_ALLOC  = 0,
    KSMETHOD_STREAMALLOCATOR_FREE   = 1
} KSMETHOD_STREAMALLOCATOR;

/* Kernel streaming stream allocator properties */
#ifdef _NTDDK_
typedef enum {
    KSPROPERTY_STREAMALLOCATOR_FUNCTIONTABLE    = 0,
    KSPROPERTY_STREAMALLOCATOR_STATUS           = 1
} KSPROPERTY_STREAMALLOCATOR;
#endif

/* Kernel streaming stream allocator callbacks */
#ifdef _NTDDK_
typedef NTSTATUS (NTAPI *PFNALLOCATOR_ALLOCATEFRAME)( PFILE_OBJECT, PVOID * );
typedef VOID (NTAPI *PFNALLOCATOR_FREEFRAME)( PFILE_OBJECT, PVOID );
#endif

/* Kernel streaming stream allocator function table */
#ifdef _NTDDK_
typedef struct {
    PFNALLOCATOR_ALLOCATEFRAME  AllocateFrame;
    PFNALLOCATOR_FREEFRAME      FreeFrame;
} KSSTREAMALLOCATOR_FUNCTIONTABLE;
typedef KSSTREAMALLOCATOR_FUNCTIONTABLE *PKSSTREAMALLOCATOR_FUNCTIONTABLE;
#endif

/* Kernel streaming stream allocator status */
typedef struct {
    KSALLOCATOR_FRAMING Framing;
    ULONG               AllocatedFrames;
    ULONG               Reserved;
} KSSTREAMALLOCATOR_STATUS;
typedef KSSTREAMALLOCATOR_STATUS    *PKSSTREAMALLOCATOR_STATUS;

/* Kernel streaming stream allocator status (extended version) */
typedef struct {
    KSALLOCATOR_FRAMING_EX  Framing;
    ULONG                   AllocatedFrames;
    ULONG                   Reserved;
} KSSTREAMALLOCATOR_STATUS_EX;
typedef KSSTREAMALLOCATOR_STATUS_EX *PKSSTREAMALLOCATOR_STATUS_EX;

/* Kernel streaming time */
typedef struct {
    LONGLONG    Time;
    ULONG       Numerator;
    ULONG       Denominator;
} KSTIME;
typedef KSTIME  *PKSTIME;

/* Kernel streaming stream header */
typedef struct {
    ULONG       Size;
    ULONG       TypeSpecificFlags;
    KSTIME      PresentationTime;
    LONGLONG    Duration;
    ULONG       FrameExtent;
    ULONG       DataUsed;
    PVOID       Data;
    ULONG       OptionsFlags;
} KSSTREAM_HEADER;
typedef KSSTREAM_HEADER *PKSSTREAM_HEADER;

/* Kernel streaming stream interface properties */
typedef enum {
    KSPROPERTY_STREAMINTERFACE_HEADERSIZE   = 0
} KSPROPERTY_STREAMINTERFACE;

/* Kernel streaming stream properties */
typedef enum {
    KSPROPERTY_STREAM_ALLOCATOR             = 0,
    KSPROPERTY_STREAM_QUALITY               = 1,
    KSPROPERTY_STREAM_DEGRADATION           = 2,
    KSPROPERTY_STREAM_MASTERCLOCK           = 3,
    KSPROPERTY_STREAM_TIMEFORMAT            = 4,
    KSPROPERTY_STREAM_PRESENTATIONTIME      = 5,
    KSPROPERTY_STREAM_PRESENTATIONEXTENT    = 6,
    KSPROPERTY_STREAM_FRAMETIME             = 7,
    KSPROPERTY_STREAM_RATECAPABILITY        = 8,
    KSPROPERTY_STREAM_RATE                  = 9,
    KSPROPERTY_STREAM_PIPE_ID               = 10
} KSPROPERTY_STREAM;

/* Kernel streaming quality manager */
typedef struct {
    HANDLE  QualityManager;
    PVOID   Context;
} KSQUALITY_MANAGER;
typedef KSQUALITY_MANAGER   *PKSQUALITY_MANAGER;

/* Kernel streaming frame time */
typedef struct {
    LONGLONG    Duration;
    ULONG       FrameFlags;
    ULONG       Reserved;
} KSFRAMETIME;
typedef KSFRAMETIME *PKSFRAMETIME;

/* Kernel streaming rate */
typedef struct {
    LONGLONG        PresentationStart;
    LONGLONG        Duration;
    KSPIN_INTERFACE Interface;
    LONG            Rate;
    ULONG           Flags;
} KSRATE;
typedef KSRATE  *PKSRATE;

/* Kernel streaming rate capability */
typedef struct {
    KSPROPERTY  Property;
    KSRATE      Rate;
} KSRATE_CAPABILITY;
typedef KSRATE_CAPABILITY   *PKSRATE_CAPABILITY;

/* Kernel streaming clock creation information */
typedef struct {
    ULONG   CreateFlags;
} KSCLOCK_CREATE;
typedef KSCLOCK_CREATE  *PKSCLOCK_CREATE;

/* Kernel streaming correlated time */
typedef struct {
    LONGLONG    Time;
    LONGLONG    SystemTime;
} KSCORRELATED_TIME;
typedef KSCORRELATED_TIME   *PKSCORRELATED_TIME;

/* Kernel streaming resolution */
typedef struct {
    LONGLONG    Granularity;
    LONGLONG    Error;
} KSRESOLUTION;
typedef KSRESOLUTION    *PKSRESOLUTION;

/* Kernel streaming clock properties */
typedef enum {
    KSPROPERTY_CLOCK_TIME                   = 0,
    KSPROPERTY_CLOCK_PHYSICALTIME           = 1,
    KSPROPERTY_CLOCK_CORRELATEDTIME         = 2,
    KSPROPERTY_CLOCK_CORRELATEDPHYSICALTIME = 3,
    KSPROPERTY_CLOCK_RESOLUTION             = 4,
#ifdef _NTDDK_
    KSPROPERTY_CLOCK_STATE                  = 5,
    KSPROPERTY_CLOCK_FUNCTIONTABLE          = 6
#else
    KSPROPERTY_CLOCK_STATE                  = 5
#endif
} KSPROPERTY_CLOCK;

/* Kernel streaming clock callbacks */
#ifdef _NTDDK_
typedef LONGLONG (FASTCALL *PFNKSCLOCK_GETTIME)( PFILE_OBJECT );
typedef LONGLONG (FASTCALL *PFNKSCLOCK_CORRELATEDTIME)( PFILE_OBJECT, PLONGLONG );
#endif

/* Kernel streaming clock function table */
#ifdef _NTDDK_
typedef struct {
    PFNKSCLOCK_GETTIME          GetTime;
    PFNKSCLOCK_GETTIME          GetPhysicalTime;
    PFNKSCLOCK_CORRELATEDTIME   GetCorrelatedTime;
    PFNKSCLOCK_CORRELATEDTIME   GetCorrelatedPhysicalTime;
} KSCLOCK_FUNCTIONTABLE;
typedef KSCLOCK_FUNCTIONTABLE   *PKSCLOCK_FUNCTIONTABLE;
#endif

/* Kernel streaming timer callbacks */
#ifdef _NTDDK_
#if (NTDDI_VERSION >= 0x05010000)
typedef BOOLEAN (NTAPI *PFNKSSETTIMER)( PVOID, PKTIMER, LARGE_INTEGER, PKDPC );
typedef BOOLEAN (NTAPI *PFNKSCANCELTIMER)( PVOID, PKTIMER );
typedef LONGLONG (FASTCALL *PFNKSCORRELATEDTIME)( PVOID, PLONGLONG );
#endif
#endif

/* Kernel streaming clock position events */
typedef enum {
    KSEVENT_CLOCK_INTERVAL_MARK = 0,
    KSEVENT_CLOCK_POSITION_MARK = 1
} KSEVENT_CLOCK_POSITION;

/* Kernel streaming connection events */
typedef enum {
    KSEVENT_CONNECTION_POSITIONUPDATE       = 0,
    KSEVENT_CONNECTION_DATADISCONTINUITY    = 1,
    KSEVENT_CONNECTION_TIMEDISCONTINUITY    = 2,
    KSEVENT_CONNECTION_PRIORITY             = 3,
    KSEVENT_CONNECTION_ENDOFSTREAM          = 4
} KSEVENT_CONNECTION;

/* Kernel streaming quality */
typedef struct {
    PVOID       Context;
    ULONG       Proportion;
    LONGLONG    DeltaTime;
} KSQUALITY;
typedef KSQUALITY   *PKSQUALITY;

/* Kernel streaming error */
typedef struct {
    PVOID   Context;
    ULONG   Status;
} KSERROR;
typedef KSERROR *PKSERROR;

/* Kernel streaming standard degrades */
typedef enum {
    KSDEGRADE_STANDARD_SIMPLE       = 0,
    KSDEGRADE_STANDARD_QUALITY      = 1,
    KSDEGRADE_STANDARD_COMPUTATION  = 2,
    KSDEGRADE_STANDARD_SKIP         = 3
} KSDEGRADE_STANDARD;

/* Kernel streaming callbacks */
#ifdef _NTDDK_
typedef NTSTATUS (NTAPI *PFNKSCONTEXT_DISPATCH)( PVOID, PIRP );
typedef NTSTATUS (NTAPI *PFNKSHANDLER)( PIRP, PKSIDENTIFIER, PVOID );
typedef BOOLEAN (NTAPI *PFNKSFASTHANDLER)( PFILE_OBJECT, PKSIDENTIFIER, ULONG, PVOID, ULONG, PIO_STATUS_BLOCK );
typedef NTSTATUS (NTAPI *PFNKSALLOCATOR)( PIRP, ULONG, BOOLEAN );
#endif

/* Kernel streaming property members list */
#ifdef _NTDDK_
typedef struct {
    KSPROPERTY_MEMBERSHEADER    MembersHeader;
    const VOID                  *Members;
} KSPROPERTY_MEMBERSLIST;
typedef KSPROPERTY_MEMBERSLIST  *PKSPROPERTY_MEMBERSLIST;
#endif

/* Kernel streaming property values */
#ifdef _NTDDK_
typedef struct {
    KSIDENTIFIER                    PropTypeSet;
    ULONG                           MembersListCount;
    const KSPROPERTY_MEMBERSLIST    *MembersList;
} KSPROPERTY_VALUES;
typedef KSPROPERTY_VALUES   *PKSPROPERTY_VALUES;
#endif

/* Kernel streaming property item */
#ifdef _NTDDK_
typedef struct {
    ULONG                   PropertyId;
    union {
        PFNKSHANDLER    GetPropertyHandler;
        BOOLEAN         GetSupported;
    };
    ULONG                   MinProperty;
    ULONG                   MinData;
    union {
        PFNKSHANDLER    SetPropertyHandler;
        BOOLEAN         SetSupported;
    };
    const KSPROPERTY_VALUES *Values;
    ULONG                   RelationsCount;
    const KSPROPERTY        *Relations;
    PFNKSHANDLER            SupportHandler;
    ULONG                   SerializedSize;
} KSPROPERTY_ITEM;
typedef KSPROPERTY_ITEM *PKSPROPERTY_ITEM;
#endif

/* Kernel streaming fast property item */
#ifdef _NTDDK_
typedef struct {
    ULONG   PropertyId;
    union {
        PFNKSFASTHANDLER    GetPropertyHandler;
        BOOLEAN             GetSupported;
    };
    union {
        PFNKSFASTHANDLER    SetPropertyHandler;
        BOOLEAN             SetSupported;
    };
    ULONG   Reserved;
} KSFASTPROPERTY_ITEM;
typedef KSFASTPROPERTY_ITEM *PKSFASTPROPERTY_ITEM;
#endif

/* Kernel streaming property set */
#ifdef _NTDDK_
typedef struct {
    const GUID                  *Set;
    ULONG                       PropertiesCount;
    const KSPROPERTY_ITEM       *PropertyItem;
    ULONG                       FastIoCount;
    const KSFASTPROPERTY_ITEM   *FastIoTable;
} KSPROPERTY_SET;
typedef KSPROPERTY_SET  *PKSPROPERTY_SET;
#endif

/* Kernel streaming method item */
#ifdef _NTDDK_
typedef struct {
    ULONG           MethodId;
    union {
        PFNKSHANDLER    MethodHandler;
        BOOLEAN         MethodSupported;
    };
    ULONG           MinMethod;
    ULONG           MinData;
    PFNKSHANDLER    SupportHandler;
    ULONG           Flags;
} KSMETHOD_ITEM;
typedef KSMETHOD_ITEM   *PKSMETHOD_ITEM;
#endif

/* Kernel streaming fast method item */
#ifdef _NTDDK_
typedef struct {
    ULONG   MethodId;
    union {
        PFNKSFASTHANDLER    MethodHandler;
        BOOLEAN             MethodSupported;
    };
} KSFASTMETHOD_ITEM;
typedef KSFASTMETHOD_ITEM   *PKSFASTMETHOD_ITEM;
#endif

/* Kernel streaming method set */
#ifdef _NTDDK_
typedef struct {
    const GUID              *Set;
    ULONG                   MethodsCount;
    const KSMETHOD_ITEM     *MethodItem;
    ULONG                   FastIoCount;
    const KSFASTMETHOD_ITEM *FastIoTable;
} KSMETHOD_SET;
typedef KSMETHOD_SET    *PKSMETHOD_SET;
#endif

/* Kernel streaming event callbacks */
#ifdef _NTDDK_
typedef NTSTATUS (NTAPI *PFNKSADDEVENT)( PIRP, PKSEVENTDATA, struct _KSEVENT_ENTRY * );
typedef VOID (NTAPI *PFNKSREMOVEEVENT)( PFILE_OBJECT, struct _KSEVENT_ENTRY * );
#endif

/* Kernel streaming event item */
#ifdef _NTDDK_
typedef struct {
    ULONG               EventId;
    ULONG               DataInput;
    ULONG               ExtraEntryData;
    PFNKSADDEVENT       AddHandler;
    PFNKSREMOVEEVENT    RemoveHandler;
    PFNKSHANDLER        SupportHandler;
} KSEVENT_ITEM;
typedef KSEVENT_ITEM    *PKSEVENT_ITEM;
#endif

/* Kernel streaming event set */
#ifdef _NTDDK_
typedef struct {
    const GUID          *Set;
    ULONG               EventsCount;
    const KSEVENT_ITEM  *EventItem;
} KSEVENT_SET;
typedef KSEVENT_SET *PKSEVENT_SET;
#endif

/* Kernel streaming DPC item */
#ifdef _NTDDK_
typedef struct {
    KDPC        Dpc;
    ULONG       ReferenceCount;
    KSPIN_LOCK  AccessLock;
} KSDPC_ITEM;
typedef KSDPC_ITEM  *PKSDPC_ITEM;
#endif

/* Kernel streaming buffer item */
#ifdef _NTDDK_
typedef struct {
    KSDPC_ITEM  DpcItem;
    LIST_ENTRY  BufferList;
} KSBUFFER_ITEM;
typedef KSBUFFER_ITEM   *PKSBUFFER_ITEM;
#endif

/* Kernel streaming event entry */
#ifdef _NTDDK_
typedef struct _KSEVENT_ENTRY {
    LIST_ENTRY          ListEntry;
    PVOID               Object;
    union {
        PKSDPC_ITEM     DpcItem;
        PKSBUFFER_ITEM  BufferItem;
    };
    PKSEVENTDATA        EventData;
    ULONG               NotificationType;
    const KSEVENT_SET   *EventSet;
    const KSEVENT_ITEM  *EventItem;
    PFILE_OBJECT        FileObject;
    ULONG               SemaphoreAdjustment;
    ULONG               Reserved;
    ULONG               Flags;
} KSEVENT_ENTRY;
typedef KSEVENT_ENTRY   *PKSEVENT_ENTRY;
#endif

/* Kernel streaming events lock types */
#ifdef _NTDDK_
typedef enum {
    KSEVENTS_NONE           = 0,
    KSEVENTS_SPINLOCK       = 1,
    KSEVENTS_MUTEX          = 2,
    KSEVENTS_FMUTEX         = 3,
    KSEVENTS_FMUTEXUNSAFE   = 4,
    KSEVENTS_INTERRUPT      = 5,
    KSEVENTS_ERESOURCE      = 6
} KSEVENTS_LOCKTYPE;
#endif

/* Kernel streaming object create item */
#ifdef _NTDDK_
typedef struct {
    PDRIVER_DISPATCH        Create;
    PVOID                   Context;
    UNICODE_STRING          ObjectClass;
    PSECURITY_DESCRIPTOR    SecurityDescriptor;
    ULONG                   Flags;
} KSOBJECT_CREATE_ITEM;
typedef KSOBJECT_CREATE_ITEM    *PKSOBJECT_CREATE_ITEM;
#endif

/* Kernel streaming item free callback */
#ifdef _NTDDK_
typedef VOID (NTAPI *PFNKSITEMFREECALLBACK)( PKSOBJECT_CREATE_ITEM );
#endif

/* Kernel streaming object create information */
#ifdef _NTDDK_
typedef struct {
    ULONG                   CreateItemsCount;
    PKSOBJECT_CREATE_ITEM   CreateItemsList;
} KSOBJECT_CREATE;
typedef KSOBJECT_CREATE *PKSOBJECT_CREATE;
#endif

/* Kernel streaming dispatch table */
#ifdef _NTDDK_
typedef struct {
    PDRIVER_DISPATCH        DeviceIoControl;
    PDRIVER_DISPATCH        Read;
    PDRIVER_DISPATCH        Write;
    PDRIVER_DISPATCH        Flush;
    PDRIVER_DISPATCH        Close;
    PDRIVER_DISPATCH        QuerySecurity;
    PDRIVER_DISPATCH        SetSecurity;
    PFAST_IO_DEVICE_CONTROL FastDeviceIoControl;
    PFAST_IO_READ           FastRead;
    PFAST_IO_WRITE          FastWrite;
} KSDISPATCH_TABLE;
typedef KSDISPATCH_TABLE    *PKSDISPATCH_TABLE;
#endif

/* Kernel streaming completion invocations */
#ifdef _NTDDK_
typedef enum {
    KsInvokeOnSuccess   = 1,
    KsInvokeOnError     = 2,
    KsInvokeOnCancel    = 4
} KSCOMPLETION_INVOCATION;
#endif

/* Kernel streaming list entry locations */
#ifdef _NTDDK_
typedef enum {
    KsListEntryTail = 1,
    KsListEntryHead = 2
} KSLIST_ENTRY_LOCATION;
#endif

/* Kernel streaming IRP removal operation */
#ifdef _NTDDK_
typedef enum {
    KsAcquireOnly                       = 0,
    KsAcquireAndRemove                  = 1,
    KsAcquireOnlySingleItem             = 2,
    KsAcquireAndRemoveOnlySingleItem    = 3
} KSIRP_REMOVAL_OPERATION;
#endif

/* Kernel streaming stack uses */
#ifdef _NTDDK_
typedef enum {
    KsStackCopyToNewLocation    = 0,
    KsStackReuseCurrentLocation = 1,
    KsStackUseNewLocation       = 2
} KSSTACK_USE;
#endif

/* Kernel streaming target states */
#ifdef _NTDDK_
typedef enum {
    KSTARGET_STATE_DISABLED = 0,
    KSTARGET_STATE_ENABLED  = 1
} KSTARGET_STATE;
#endif

/* Reference callbacks */
#ifdef _NTDDK_
typedef NTSTATUS (NTAPI *PFNKSIRPLISTCALLBACK)( PIRP, PVOID );
typedef VOID (NTAPI *PFNREFERENCEDEVICEOBJECT)( PVOID );
typedef VOID (NTAPI *PFNDEREFERENCEDEVICEOBJECT)( PVOID );
typedef NTSTATUS (NTAPI *PFNQUERYREFERENCESTRING)( PVOID, PWCHAR * );
#endif

/* Bus interface reference */
#ifdef _NTDDK_
typedef struct {
    INTERFACE                   Interface;
    PFNREFERENCEDEVICEOBJECT    ReferenceDeviceObject;
    PFNDEREFERENCEDEVICEOBJECT  DereferenceDeviceObject;
    PFNQUERYREFERENCESTRING     QueryReferenceString;
} BUS_INTERFACE_REFERENCE;
typedef BUS_INTERFACE_REFERENCE *PBUS_INTERFACE_REFERENCE;
#endif

/* Query mediums list callback */
#ifdef _NTDDK_
typedef NTSTATUS (NTAPI *PFNQUERYMEDIUMSLIST)( PVOID, ULONG *, KSPIN_MEDIUM * );
#endif

/* Bus interface mediums */
#ifdef _NTDDK_
typedef struct {
    INTERFACE           Interface;
    PFNQUERYMEDIUMSLIST QueryMediumsList;
} BUS_INTERFACE_MEDIUMS;
typedef BUS_INTERFACE_MEDIUMS   *PBUS_INTERFACE_MEDIUMS;
#endif

/* Kernel streaming property serial header */
#include <pshpack1.h>
typedef struct {
    GUID    PropertySet;
    ULONG   Count;
} KSPROPERTY_SERIALHDR;
typedef KSPROPERTY_SERIALHDR    *PKSPROPERTY_SERIALHDR;
#include <poppack.h>

/* Kernel streaming property serial */
typedef struct {
    KSIDENTIFIER    PropTypeSet;
    ULONG           Id;
    ULONG           PropertyLength;
} KSPROPERTY_SERIAL;
typedef KSPROPERTY_SERIAL   *PKSPROPERTY_SERIAL;

/* Kernel streaming handshake */
#ifdef _NTDDK_
#if (NTDDI_VERSION >= 0x05010000)
typedef struct {
    GUID    ProtocolId;
    PVOID   Argument1;
    PVOID   Argument2;
} KSHANDSHAKE;
typedef KSHANDSHAKE *PKSHANDSHAKE;
#endif
#endif

/* Kernel streaming gate */
#ifdef _NTDDK_
#if (NTDDI_VERSION >= 0x05010000)
typedef struct _KSGATE {
    LONG            Count;
    struct _KSGATE  *NextGate;
} KSGATE;
typedef KSGATE  *PKSGATE;
#endif
#endif

/* Kernel streaming dispatch callbacks */
#ifdef _NTDDK_
#if (NTDDI_VERSION >= 0x05010000)
typedef BOOLEAN (NTAPI *PFNKSGENERATEEVENTCALLBACK)( PVOID, PKSEVENT_ENTRY );
typedef NTSTATUS (NTAPI *PFNKSDEVICECREATE)( PKSDEVICE );
typedef NTSTATUS (NTAPI *PFNKSDEVICEPNPSTART)( PKSDEVICE, PIRP, PCM_RESOURCE_LIST, PCM_RESOURCE_LIST );
typedef NTSTATUS (NTAPI *PFNKSDEVICE)( PKSDEVICE );
typedef NTSTATUS (NTAPI *PFNKSDEVICEIRP)( PKSDEVICE, PIRP );
typedef void (NTAPI *PFNKSDEVICEIRPVOID)( PKSDEVICE, PIRP );
typedef NTSTATUS (NTAPI *PFNKSDEVICEQUERYCAPABILITIES)( PKSDEVICE, PIRP, PDEVICE_CAPABILITIES );
typedef NTSTATUS (NTAPI *PFNKSDEVICEQUERYPOWER)( PKSDEVICE, PIRP, DEVICE_POWER_STATE, DEVICE_POWER_STATE, SYSTEM_POWER_STATE, SYSTEM_POWER_STATE, POWER_ACTION );
typedef void (NTAPI *PFNKSDEVICESETPOWER)( PKSDEVICE, PIRP, DEVICE_POWER_STATE, DEVICE_POWER_STATE );
typedef NTSTATUS (NTAPI *PFNKSFILTERFACTORYVOID)( PKSFILTERFACTORY );
typedef void (NTAPI *PFNKSFILTERFACTORYPOWER)( PKSFILTERFACTORY, DEVICE_POWER_STATE );
typedef NTSTATUS (NTAPI *PFNKSFILTERIRP)( PKSFILTER, PIRP );
typedef NTSTATUS (NTAPI *PFNKSFILTERPROCESS)( PKSFILTER, PKSPROCESSPIN_INDEXENTRY );
typedef NTSTATUS (NTAPI *PFNKSFILTERVOID)( PKSFILTER );
typedef void (NTAPI *PFNKSFILTERPOWER)( PKSFILTER, DEVICE_POWER_STATE );
typedef NTSTATUS (NTAPI *PFNKSPINIRP )( PKSPIN, PIRP );
typedef NTSTATUS (NTAPI *PFNKSPINSETDEVICESTATE)( PKSPIN, KSSTATE, KSSTATE );
typedef NTSTATUS (NTAPI *PFNKSPINSETDATAFORMAT)( PKSPIN, PKSDATAFORMAT, PKSMULTIPLE_ITEM, const KSDATARANGE *, const KSATTRIBUTE_LIST * );
typedef NTSTATUS (NTAPI *PFNKSPINHANDSHAKE)( PKSPIN, PKSHANDSHAKE, PKSHANDSHAKE );
typedef NTSTATUS (NTAPI *PFNKSPIN)( PKSPIN );
typedef void (NTAPI *PFNKSPINVOID)( PKSPIN );
typedef void (NTAPI *PFNKSPINPOWER)( PKSPIN, DEVICE_POWER_STATE );
typedef BOOLEAN (NTAPI *PFNKSPINSETTIMER)( PKSPIN, PKTIMER, LARGE_INTEGER, PKDPC );
typedef BOOLEAN (NTAPI *PFNKSPINCANCELTIMER)( PKSPIN, PKTIMER );
typedef LONGLONG (FASTCALL *PFNKSPINCORRELATEDTIME)( PKSPIN, PLONGLONG );
typedef void (NTAPI *PFNKSPINRESOLUTION)( PKSPIN, PKSRESOLUTION );
typedef NTSTATUS (NTAPI *PFNKSPININITIALIZEALLOCATOR)( KSPIN, PKSALLOCATOR_FRAMING, PVOID * );
typedef void (NTAPI *PFNKSSTREAMPOINTER)( PKSSTREAM_POINTER );
#endif
#endif

/* Kernel streaming automation table */
#ifdef _NTDDK_
#if (NTDDI_VERSION >= 0x05010000)
typedef struct KSAUTOMATION_TABLE_ {
    ULONG                   PropertySetsCount;
    ULONG                   PropertyItemSize;
    const KSPROPERTY_SET    *PropertySets;
    ULONG                   MethodSetsCount;
    ULONG                   MethodItemSize;
    const KSMETHOD_SET      *MethodSets;
    ULONG                   EventSetsCount;
    ULONG                   EventItemSize;
    const KSEVENT_SET       *EventSets;
    PVOID                   Alignment;
} KSAUTOMATION_TABLE;
typedef KSAUTOMATION_TABLE  *PKSAUTOMATION_TABLE;
#endif
#endif

/* Kernel streaming device dispatch */
#ifdef _NTDDK_
#if (NTDDI_VERSION >= 0x05010000)
struct _KSDEVICE_DISPATCH {
    PFNKSDEVICECREATE               Add;
    PFNKSDEVICEPNPSTART             Start;
    PFNKSDEVICE                     PostStart;
    PFNKSDEVICEIRP                  QueryStop;
    PFNKSDEVICEIRPVOID              CancelStop;
    PFNKSDEVICEIRPVOID              Stop;
    PFNKSDEVICEIRP                  QueryRemove;
    PFNKSDEVICEIRPVOID              CancelRemove;
    PFNKSDEVICEIRPVOID              Remove;
    PFNKSDEVICEQUERYCAPABILITIES    QueryCapabilities;
    PFNKSDEVICEIRPVOID              SurpriseRemoval;
    PFNKSDEVICEQUERYPOWER           QueryPower;
    PFNKSDEVICESETPOWER             SetPower;
    PFNKSDEVICEIRP                  QueryInterface;
};
#endif
#endif

/* Kernel streaming filter dispatch */
#ifdef _NTDDK_
#if (NTDDI_VERSION >= 0x05010000)
struct _KSFILTER_DISPATCH {
    PFNKSFILTERIRP      Create;
    PFNKSFILTERIRP      Close;
    PFNKSFILTERPROCESS  Process;
    PFNKSFILTERVOID     Reset;
};
#endif
#endif

/* Kernel streaming pin dispatch */
#ifdef _NTDDK_
#if (NTDDI_VERSION >= 0x05010000)
struct _KSPIN_DISPATCH {
    PFNKSPINIRP                 Create;
    PFNKSPINIRP                 Close;
    PFNKSPIN                    Process;
    PFNKSPINVOID                Reset;
    PFNKSPINSETDATAFORMAT       SetDataFormat;
    PFNKSPINSETDEVICESTATE      SetDeviceState;
    PFNKSPIN                    Connect;
    PFNKSPINVOID                Disconnect;
    const KSCLOCK_DISPATCH      *Clock;
    const KSALLOCATOR_DISPATCH  *Allocator;
};
#endif
#endif

/* Kernel streaming clock dispatch */
#ifdef _NTDDK_
#if (NTDDI_VERSION >= 0x05010000)
struct _KSCLOCK_DISPATCH {
    PFNKSPINSETTIMER        SetTimer;
    PFNKSPINCANCELTIMER     CancelTimer;
    PFNKSPINCORRELATEDTIME  CorrelatedTime;
    PFNKSPINRESOLUTION      Resolution;
};
#endif
#endif

/* Kernel streaming allocator dispatch */
#ifdef _NTDDK_
#if (NTDDI_VERSION >= 0x05010000)
struct _KSALLOCATOR_DISPATCH {
    PFNKSPININITIALIZEALLOCATOR InitializeAllocator;
    PFNKSDELETEALLOCATOR        DeleteAllocator;
    PFNKSDEFAULTALLOCATE        Allocate;
    PFNKSDEFAULTFREE            Free;
};
#endif
#endif

/* Kernel streaming device descriptor */
#ifdef _NTDDK_
#if (NTDDI_VERSION >= 0x05010000)
struct _KSDEVICE_DESCRIPTOR {
    const KSDEVICE_DISPATCH     *Dispatch;
    ULONG                       FilterDescriptorsCount;
    const KSFILTER_DESCRIPTOR   **FilterDescriptors;
    ULONG                       Version;
#if (NTDDI_VERSION >= 0x06000000)
    ULONG                       Flags;
    PVOID                       Alignment;
#endif
};
#endif
#endif

/* Kernel streaming filter descriptor */
#ifdef _NTDDK_
#if (NTDDI_VERSION >= 0x05010000)
struct _KSFILTER_DESCRIPTOR {
    const KSFILTER_DISPATCH     *Dispatch;
    const KSAUTOMATION_TABLE    *AutomationTable;
    ULONG                       Version;
    ULONG                       Flags;
    const GUID                  *ReferenceGuid;
    ULONG                       PinDescriptorsCount;
    ULONG                       PinDescriptorSize;
    const KSPIN_DESCRIPTOR_EX   *PinDescriptors;
    ULONG                       CategoriesCount;
    const GUID                  *Categories;
    ULONG                       NodeDescriptorsCount;
    ULONG                       NodeDescriptorSize;
    const KSNODE_DESCRIPTOR     *NodeDescriptors;
    ULONG                       ConnectionsCount;
    const KSTOPOLOGY_CONNECTION *Connections;
    const KSCOMPONENTID         *ComponentId;
};
#endif
#endif

/* Kernel streaming pin descriptor (extended version) */
#ifdef _NTDDK_
#if (NTDDI_VERSION >= 0x05010000)
struct _KSPIN_DESCRIPTOR_EX {
    const KSPIN_DISPATCH            *Dispatch;
    const KSAUTOMATION_TABLE        *AutomationTable;
    KSPIN_DESCRIPTOR                PinDescriptor;
    ULONG                           Flags;
    ULONG                           InstancesPossible;
    ULONG                           InstancesNecessary;
    const KSALLOCATOR_FRAMING_EX    *AllocatorFraming;
    PFNKSINTERSECTHANDLEREX         IntersectHandler;
};
#endif
#endif

/* Kernel streaming node descriptor */
#ifdef _NTDDK_
#if (NTDDI_VERSION >= 0x05010000)
struct _KSNODE_DESCRIPTOR {
    const KSAUTOMATION_TABLE    *AutomationTable;
    const GUID                  *Type;
    const GUID                  *Name;
    PVOID                       Alignment;
};
#endif
#endif

/* Kernel streaming device */
#ifdef _NTDDK_
#if (NTDDI_VERSION >= 0x05010000)
struct _KSDEVICE {
    const KSDEVICE_DESCRIPTOR   *Descriptor;
    KSOBJECT_BAG                Bag;
    PVOID                       Context;
    PDEVICE_OBJECT              FunctionalDeviceObject;
    PDEVICE_OBJECT              PhysicalDeviceObject;
    PDEVICE_OBJECT              NextDeviceObject;
    BOOLEAN                     Started;
    SYSTEM_POWER_STATE          SystemPowerState;
    DEVICE_POWER_STATE          DevicePowerState;
};
#endif
#endif

/* Kernel streaming filter factory */
#ifdef _NTDDK_
#if (NTDDI_VERSION >= 0x05010000)
struct _KSFILTERFACTORY {
    const KSFILTER_DESCRIPTOR   *FilterDescriptor;
    KSOBJECT_BAG                Bag;
    PVOID                       Context;
};
#endif
#endif

/* Kernel streaming filter */
#ifdef _NTDDK_
#if (NTDDI_VERSION >= 0x05010000)
struct _KSFILTER {
    const KSFILTER_DESCRIPTOR   *Descriptor;
    KSOBJECT_BAG                Bag;
    PVOID                       Context;
};
#endif
#endif

/* Kernel streaming pin */
#ifdef _NTDDK_
#if (NTDDI_VERSION >= 0x05010000)
struct _KSPIN {
    const KSPIN_DESCRIPTOR_EX   *Descriptor;
    KSOBJECT_BAG                Bag;
    PVOID                       Context;
    ULONG                       Id;
    KSPIN_COMMUNICATION         Communication;
    BOOLEAN                     ConnectionIsExternal;
    KSPIN_INTERFACE             ConnectionInterface;
    KSPIN_MEDIUM                ConnectionMedium;
    KSPRIORITY                  ConnectionPriority;
    PKSDATAFORMAT               ConnectionFormat;
    PKSMULTIPLE_ITEM            AttributeList;
    ULONG                       StreamHeaderSize;
    KSPIN_DATAFLOW              DataFlow;
    KSSTATE                     DeviceState;
    KSRESET                     ResetState;
    KSSTATE                     ClientState;
};
#endif
#endif

/* Kernel streaming mapping */
#ifdef _NTDDK_
#if (NTDDI_VERSION >= 0x05010000)
struct _KSMAPPING {
    PHYSICAL_ADDRESS    PhysicalAddress;
    ULONG               ByteCount;
    ULONG               Alignment;
};
#endif
#endif

/* Kernel streaming stream pointer offset */
#ifdef _NTDDK_
#if (NTDDI_VERSION >= 0x05010000)
struct _KSSTREAM_POINTER_OFFSET {
    union {
        PUCHAR      Data;
        PKSMAPPING  Mappings;
    };
    PVOID   Alignment;
    ULONG   Count;
    ULONG   Remaining;
};
#endif
#endif

/* Kernel streaming stream pointer */
#ifdef _NTDDK_
#if (NTDDI_VERSION >= 0x05010000)
struct _KSSTREAM_POINTER {
    PVOID                       Context;
    PKSPIN                      Pin;
    PKSSTREAM_HEADER            StreamHeader;
    PKSSTREAM_POINTER_OFFSET    Offset;
    KSSTREAM_POINTER_OFFSET     OffsetIn;
    KSSTREAM_POINTER_OFFSET     OffsetOut;
};
#endif
#endif

/* Kernel streaming process pin */
#ifdef _NTDDK_
#if (NTDDI_VERSION >= 0x05010000)
struct _KSPROCESSPIN {
    PKSPIN              Pin;
    PKSSTREAM_POINTER   StreamPointer;
    PKSPROCESSPIN       InPlaceCounterpart;
    PKSPROCESSPIN       DelegateBranch;
    PKSPROCESSPIN       CopySource;
    PVOID               Data;
    ULONG               BytesAvailable;
    ULONG               BytesUsed;
    ULONG               Flags;
    BOOLEAN             Terminate;
};
#endif
#endif

/* Kernel streaming process pin index entry */
#ifdef _NTDDK_
#if (NTDDI_VERSION >= 0x05010000)
struct _KSPROCESSPIN_INDEXENTRY {
    PKSPROCESSPIN   *Pins;
    ULONG           Count;
};
#endif
#endif

/* Kernel streaming object types */
#ifdef _NTDDK_
#if (NTDDI_VERSION >= 0x05010000)
typedef enum {
    KsObjectTypeDevice          = 0,
    KsObjectTypeFilterFactory   = 1,
    KsObjectTypeFilter          = 2,
    KsObjectTypePin             = 3
} KSOBJECTTYPE;
#endif
#endif

/* More kernel streaming callbacks */
#ifdef _NTDDK_
#if (NTDDI_VERSION >= 0x05010000)
typedef void (NTAPI *PFNKSFREE)( PVOID );
typedef void (NTAPI *PFNKSPINFRAMERETURN)( PKSPIN, PVOID, ULONG, PMDL, PVOID, NTSTATUS );
typedef void (NTAPI *PFNKSPINIRPCOMPLETION)( PKSPIN, PIRP );
#endif
#endif

/* Kernel streaming stream pointer states */
#ifdef _NTDDK_
#if (NTDDI_VERSION >= 0x05010000)
typedef enum {
    KSSTREAM_POINTER_STATE_UNLOCKED = 0,
    KSSTREAM_POINTER_STATE_LOCKED   = 1
} KSSTREAM_POINTER_STATE;
#endif
#endif

/* Macro to define IUnknown methods */
#ifdef _NTDDK_
    #ifdef _UNKNOWN_H_
        #if (NTDDI_VERSION >= 0x05010000)
            #define DEFINE_ABSTRACT_UNKNOWN() \
                STDMETHOD_( NTSTATUS, QueryInterface )( THIS_ REFIID, PVOID * ) PURE; \
                STDMETHOD_( ULONG, AddRef )( THIS ) PURE; \
                STDMETHOD_( ULONG, Release )( THIS ) PURE;
        #endif
    #endif
#endif

/* IKsControl interface */
#ifdef _NTDDK_
#ifdef _UNKNOWN_H_
#if (NTDDI_VERSION >= 0x05010000)
#undef INTERFACE
#define INTERFACE   IKsControl
DECLARE_INTERFACE_( IKsControl, IUnknown ) {
    /* IUnknown methods */
    DEFINE_ABSTRACT_UNKNOWN()
    
    /* IKsControl methods */
    STDMETHOD_( NTSTATUS, KsProperty )( THIS_ PKSPROPERTY, ULONG, PVOID, ULONG, ULONG * ) PURE;
    STDMETHOD_( NTSTATUS, KsMethod )( THIS_ PKSMETHOD, ULONG, PVOID, ULONG, ULONG * ) PURE;
    STDMETHOD_( NTSTATUS, KsEvent )( THIS_ PKSEVENT, ULONG, PVOID, ULONG, ULONG * ) PURE;
};
typedef IKsControl  *PIKSCONTROL;
#endif
#endif
#endif

/* IKsReferenceClock interface */
#ifdef _NTDDK_
#ifdef _UNKNOWN_H_
#if (NTDDI_VERSION >= 0x05010000)
#undef INTERFACE
#define INTERFACE   IKsReferenceClock
DECLARE_INTERFACE_( IKsReferenceClock, IUnknown ) {
    /* IUnknown methods */
    DEFINE_ABSTRACT_UNKNOWN()
    
    /* IKsReferenceClock methods */
    STDMETHOD_( LONGLONG, GetTime )( THIS ) PURE;
    STDMETHOD_( LONGLONG, GetPhysicalTime )( THIS ) PURE;
    STDMETHOD_( LONGLONG, GetCorrelatedTime )( THIS_ PLONGLONG ) PURE;
    STDMETHOD_( LONGLONG, GetCorrelatedPhysicalTime )( THIS_ PLONGLONG ) PURE;
    STDMETHOD_( NTSTATUS, GetResolution )( THIS_ PKSRESOLUTION ) PURE;
    STDMETHOD_( NTSTATUS, GetState )( THIS_ PKSSTATE ) PURE;
};
typedef IKsReferenceClock   *PIKSREFERENCECLOCK;
#endif
#endif
#endif

/* IKsDeviceFunctions interface */
#ifdef _NTDDK_
#ifdef _UNKNOWN_H_
#if (NTDDI_VERSION >= 0x05020100)
#undef INTERFACE
#define INTERFACE   IKsDeviceFunctions
DECLARE_INTERFACE_( IKsDeviceFunctions, IUnknown ) {
    /* IUnknown methods */
    DEFINE_ABSTRACT_UNKNOWN()
    
    /* IKsDeviceFunctions methods */
    STDMETHOD_( NTSTATUS, RegisterAdapterObjectEx )( THIS_ PADAPTER_OBJECT, PDEVICE_DESCRIPTION, ULONG, ULONG, ULONG ) PURE;
};
#endif
#endif
#endif

/* The name INTERFACE is used for a structure in ntddk.h, so if it was defined in order
 * to declare a COM interface, undefine it so that the structure is accessible.
 */
#ifdef _NTDDK_
    #ifdef _UNKNOWN_H_
        #if (NTDDI_VERSION >= 0x05010000)
            #undef INTERFACE
        #endif
    #endif
#endif

/* Variables in KS.SYS */
#ifdef _NTDDK_
KSDDKAPI DRIVER_CANCEL  __cdecl KsCancelRoutine;
#endif

/* Functions in KS.SYS */
#ifdef _NTDDK_
KSDDKAPI VOID NTAPI     KsAcquireDeviceSecurityLock( KSDEVICE_HEADER, BOOLEAN );
KSDDKAPI NTSTATUS NTAPI KsAcquireResetValue( PIRP, KSRESET * );
KSDDKAPI VOID NTAPI     KsAddIrpToCancelableQueue( PLIST_ENTRY, PKSPIN_LOCK, PIRP, KSLIST_ENTRY_LOCATION, PDRIVER_CANCEL );
KSDDKAPI NTSTATUS NTAPI KsAddObjectCreateItemToDeviceHeader( KSDEVICE_HEADER, PDRIVER_DISPATCH, PVOID, PWSTR, PSECURITY_DESCRIPTOR );
KSDDKAPI NTSTATUS NTAPI KsAddObjectCreateItemToObjectHeader( KSOBJECT_HEADER, PDRIVER_DISPATCH, PVOID, PWSTR, PSECURITY_DESCRIPTOR );
KSDDKAPI NTSTATUS NTAPI KsAllocateDefaultClock( PKSDEFAULT_CLOCK * );
KSDDKAPI NTSTATUS NTAPI KsAllocateDeviceHeader( KSDEVICE_HEADER *, ULONG, PKSOBJECT_CREATE_ITEM );
KSDDKAPI NTSTATUS NTAPI KsAllocateExtraData( PIRP, ULONG, PVOID * );
KSDDKAPI NTSTATUS NTAPI KsAllocateObjectCreateItem( KSDEVICE_HEADER, PKSOBJECT_CREATE_ITEM, BOOLEAN, PFNKSITEMFREECALLBACK );
KSDDKAPI NTSTATUS NTAPI KsAllocateObjectHeader( KSOBJECT_HEADER *, ULONG, PKSOBJECT_CREATE_ITEM, PIRP, const KSDISPATCH_TABLE * );
KSDDKAPI VOID NTAPI     KsCancelIo( PLIST_ENTRY, PKSPIN_LOCK );
KSDDKAPI NTSTATUS NTAPI KsCreateAllocator( HANDLE, PKSALLOCATOR_FRAMING, PHANDLE );
KSDDKAPI NTSTATUS NTAPI KsCreateClock( HANDLE, PKSCLOCK_CREATE, PHANDLE );
KSDDKAPI NTSTATUS NTAPI KsCreateDefaultAllocator( PIRP );
KSDDKAPI NTSTATUS NTAPI KsCreateDefaultAllocatorEx( PIRP, PVOID, PFNKSDEFAULTALLOCATE, PFNKSDEFAULTFREE, PFNKSINITIALIZEALLOCATOR, PFNKSDELETEALLOCATOR );
KSDDKAPI NTSTATUS NTAPI KsCreateDefaultClock( PIRP, PKSDEFAULTCLOCK );
KSDDKAPI NTSTATUS NTAPI KsCreateDefaultSecurity( PSECURITY_DESCRIPTOR, PSECURITY_DESCRIPTOR * );
KSDDKAPI NTSTATUS NTAPI KsCreatePin( HANDLE, PKSPIN_CONNECT, ACCESS_MASK, PHANDLE );
KSDDKAPI NTSTATUS NTAPI KsCreateTopologyNode( HANDLE, PKSNODE_CREATE, ACCESS_MASK, PHANDLE );
KSDDKAPI ULONG NTAPI    KsDecrementCountedWorker( PKSWORKER );
KSDDKAPI NTSTATUS NTAPI KsDefaultDeviceIoCompletion( PDEVICE_OBJECT, PIRP );
KSDDKAPI NTSTATUS NTAPI KsDefaultDispatchPnp( PDEVICE_OBJECT, PIRP );
KSDDKAPI NTSTATUS NTAPI KsDefaultDispatchPower( PDEVICE_OBJECT, PIRP );
KSDDKAPI NTSTATUS NTAPI KsDefaultForwardIrp( PDEVICE_OBJECT, PIRP );
KSDDKAPI VOID NTAPI     KsDereferenceBusObject( KSDEVICE_HEADER );
KSDDKAPI NTSTATUS NTAPI KsDisableEvent( PIRP, PLIST_ENTRY, KSEVENTS_LOCKTYPE, PVOID );
KSDDKAPI VOID NTAPI     KsDiscardEvent( PKSEVENT_ENTRY );
KSDDKAPI BOOLEAN NTAPI  KsDispatchFastIoDeviceControlFailure( PFILE_OBJECT, BOOLEAN, PVOID, ULONG, PVOID, ULONG, ULONG, PIO_STATUS_BLOCK, PDEVICE_OBJECT );
KSDDKAPI BOOLEAN NTAPI  KsDispatchFastReadFailure( PFILE_OBJECT, PLARGE_INTEGER, ULONG, BOOLEAN, ULONG, PVOID, PIO_STATUS_BLOCK, PDEVICE_OBJECT );
KSDDKAPI NTSTATUS NTAPI KsDispatchInvalidDeviceRequest( PDEVICE_OBJECT, PIRP );
KSDDKAPI NTSTATUS NTAPI KsDispatchIrp( PDEVICE_OBJECT, PIRP );
KSDDKAPI NTSTATUS NTAPI KsDispatchQuerySecurity( PDEVICE_OBJECT, PIRP );
KSDDKAPI NTSTATUS NTAPI KsDispatchSetSecurity( PDEVICE_OBJECT, PIRP );
KSDDKAPI NTSTATUS NTAPI KsDispatchSpecificMethod( PIRP, PFNKSHANDLER );
KSDDKAPI NTSTATUS NTAPI KsDispatchSpecificProperty( PIRP, PFNKSHANDLER );
KSDDKAPI NTSTATUS NTAPI KsEnableEvent( PIRP, ULONG, const KSEVENT_SET *, PLIST_ENTRY, KSEVENTS_LOCKTYPE, PVOID );
KSDDKAPI NTSTATUS NTAPI KsEnableEventWithAllocator( PIRP, ULONG, const KSEVENT_SET *, PLIST_ENTRY, KSEVENTS_LOCKTYPE, PVOID, PFNKSALLOCATOR, ULONG );
KSDDKAPI BOOLEAN NTAPI  KsFastMethodHandler( PFILE_OBJECT, PKSMETHOD, ULONG, PVOID, ULONG, PIO_STATUS_BLOCK, ULONG, const KSMETHOD_SET * );
KSDDKAPI BOOLEAN NTAPI  KsFastPropertyHandler( PFILE_OBJECT, PKSPROPERTY, ULONG, PVOID, ULONG, PIO_STATUS_BLOCK, ULONG, const KSPROPERTY_SET * );
KSDDKAPI NTSTATUS NTAPI KsForwardAndCatchIrp( PDEVICE_OBJECT, PIRP, PFILE_OBJECT, KSSTACK_USE );
KSDDKAPI NTSTATUS NTAPI KsForwardIrp( PIRP, PFILE_OBJECT, BOOLEAN );
KSDDKAPI VOID NTAPI     KsFreeDefaultClock( PKSDEFAULTCLOCK );
KSDDKAPI VOID NTAPI     KsFreeDeviceHeader( KSDEVICE_HEADER );
KSDDKAPI VOID NTAPI     KsFreeEventList( PFILE_OBJECT, PLIST_ENTRY, KSEVENTS_LOCKTYPE, PVOID );
KSDDKAPI NTSTATUS NTAPI KsFreeObjectCreateItem( KSDEVICE_HEADER, PUNICODE_STRING );
KSDDKAPI NTSTATUS NTAPI KsFreeObjectCreateItemsByContext( KSDEVICE_HEADER, PVOID );
KSDDKAPI VOID NTAPI     KsFreeObjectHeader( KSOBJECT_HEADER );
KSDDKAPI NTSTATUS NTAPI KsGenerateDataEvent( PKSEVENT_ENTRY, ULONG, PVOID );
KSDDKAPI NTSTATUS NTAPI KsGenerateEvent( PKSEVENT_ENTRY );
KSDDKAPI VOID NTAPI     KsGenerateEventList( GUID *, ULONG, PLIST_ENTRY, KSEVENTS_LOCKTYPE, PVOID );
KSDDKAPI KSSTATE NTAPI  KsGetDefaultClockState( PKSDEFAULTCLOCK );
KSDDKAPI LONGLONG NTAPI KsGetDefaultClockTime( PKSDEFAULTCLOCK );
KSDDKAPI NTSTATUS NTAPI KsGetImageNameAndResourceId( HANDLE, PUNICODE_STRING, PULONG_PTR, PULONG );
KSDDKAPI NTSTATUS NTAPI KsHandleSizedListQuery( PIRP, ULONG, ULONG, const VOID * );
KSDDKAPI ULONG NTAPI    KsIncrementCountedWorker( PKSWORKER );
KSDDKAPI NTSTATUS NTAPI KsLoadResource( PVOID, POOL_TYPE, ULONG_PTR, ULONG, PVOID *, PULONG );
KSDDKAPI NTSTATUS NTAPI KsMapModuleName( PDEVICE_OBJECT, PUNICODE_STRING, PUNICODE_STRING, PULONG_PTR, PULONG );
KSDDKAPI NTSTATUS NTAPI KsMethodHandler( PIRP, ULONG, const KSMETHOD_SET * );
KSDDKAPI NTSTATUS NTAPI KsMethodHandlerWithAllocator( PIRP, ULONG, const KSMETHOD_SET *, PFNKSALLOCATOR, ULONG );
KSDDKAPI NTSTATUS NTAPI KsMoveIrpsOnCancelableQueue( PLIST_ENTRY, PKSPIN_LOCK, PLIST_ENTRY, PKSPIN_LOCK, KSLIST_ENTRY_LOCATION, PFNKSIRPLISTCALLBACK, PVOID );
KSDDKAPI VOID NTAPI     KsNullDriverUnload( PDRIVER_OBJECT );
KSDDKAPI NTSTATUS NTAPI KsPinDataIntersection( PIRP, PKSP_PIN, PVOID, ULONG, const KSPIN_DESCRIPTOR *, PFNKSINTERSECTHANDLER );
KSDDKAPI NTSTATUS NTAPI KsPinPropertyHandler( PIRP, PKSPROPERTY, PVOID, ULONG, const KSPIN_DESCRIPTOR * );
KSDDKAPI NTSTATUS NTAPI KsProbeStreamIrp( PIRP, ULONG, ULONG );
KSDDKAPI NTSTATUS NTAPI KsPropertyHandler( PIRP, ULONG, const KSPROPERTY_SET * );
KSDDKAPI NTSTATUS NTAPI KsPropertyHandlerWithAllocator( PIRP, ULONG, const KSPROPERTY_SET *, PFNKSALLOCATOR, ULONG );
KSDDKAPI PDEVICE_OBJECT NTAPI   KsQueryDevicePnpObject( KSDEVICE_HEADER );
KSDDKAPI NTSTATUS NTAPI KsQueryInformationFile( PFILE_OBJECT, PVOID, ULONG, FILE_INFORMATION_CLASS );
KSDDKAPI ACCESS_MASK NTAPI  KsQueryObjectAccessMask( KSOBJECT_HEADER );
KSDDKAPI PKSOBJECT_CREATE_ITEM  KsQueryObjectCreateItem( KSOBJECT_HEADER );
KSDDKAPI NTSTATUS NTAPI KsQueueWorkItem( PKSWORKER, PWORK_QUEUE_ITEM );
KSDDKAPI NTSTATUS NTAPI KsReadFile( PFILE_OBJECT, PKEVENT, PVOID, PIO_STATUS_BLOCK, PVOID, ULONG, ULONG, KPROCESSOR_MODE );
KSDDKAPI VOID NTAPI     KsRecalculateStackDepth( KSDEVICE_HEADER, BOOLEAN );
KSDDKAPI NTSTATUS NTAPI KsReferenceBusObject( KSDEVICE_HEADER );
KSDDKAPI NTSTATUS NTAPI KsRegisterCountedWorker( WORK_QUEUE_TYPE, PWORK_QUEUE_ITEM, PKSWORKER * );
KSDDKAPI NTSTATUS NTAPI KsRegisterWorker( WORK_QUEUE_TYPE, PKSWORKER * );
KSDDKAPI VOID NTAPI     KsReleaseDeviceSecurityLock( KSDEVICE_HEADER );
KSDDKAPI VOID NTAPI     KsReleaseIrpOnCancelableQueue( PIRP, PDRIVER_CANCEL );
KSDDKAPI PIRP NTAPI     KsRemoveIrpFromCancelableQueue( PLIST_ENTRY, PKSPIN_LOCK, KSLIST_ENTRY_LOCATION, PSIRP_REMOVAL_OPERATION );
KSDDKAPI VOID NTAPI     KsRemoveSpecificIrpFromCancelableQueue( PIRP );
KSDDKAPI VOID NTAPI     KsSetDefaultClockState( PKSDEFAULTCLOCK, KSSTATE );
KSDDKAPI VOID NTAPI     KsSetDefaultClockTime( PKSDEFAULTCLOCK, LONGLONG );
KSDDKAPI VOID NTAPI     KsSetDevicePnpAndBaseObject( KSDEVICE_HEADER, PDEVICE_OBJECT, PDEVICE_OBJECT );
KSDDKAPI NTSTATUS NTAPI KsSetInformationFile( PFILE_OBJECT, PVOID, ULONG, FILE_INFORMATION_CLASS );
KSDDKAPI NTSTATUS NTAPI KsSetMajorFunctionHandler( PDRIVER_OBJECT, ULONG );
KSDDKAPI VOID NTAPI     KsSetPowerDispatch( KSOBJECT_HEADER, PFNKSCONTEXT_DISPATCH, PVOID );
KSDDKAPI VOID NTAPI     KsSetTargetDeviceObject( KSOBJECT_HEADER, PDEVICE_OBJECT );
KSDDKAPI VOID NTAPI     KsSetTargetState( KSOBJECT_HEADER, KSTARGET_STATE );
KSDDKAPI NTSTATUS NTAPI KsStreamIo( PFILE_OBJECT, PKEVENT, PVOID, PIO_COMPLETION_ROUTINE, PVOID, KSCOMPLETION_INVOCATION, PIO_STATUS_BLOCK, PVOID, ULONG, ULONG, KPROCESSOR_MODE );
KSDDKAPI NTSTATUS NTAPI KsSynchronousIoControlDevice( PFILE_OBJECT, KPROCESSOR_MODE, ULONG, PVOID, ULONG, PVOID, ULONG, PULONG );
KSDDKAPI NTSTATUS NTAPI KsTopologyPropertyHandler( PIRP, PKSPROPERTY, PVOID, const KSTOPOLOGY * );
KSDDKAPI VOID NTAPI     KsUnregisterWorker( PKSWORKER );
KSDDKAPI NTSTATUS NTAPI KsUnserializeObjectPropertiesFromRegistry( PFILE_OBJECT, HANDLE, PUNICODE_STRING );
KSDDKAPI NTSTATUS NTAPI KsValidateAllocatorCreateRequest( PIRP, PKSALLOCATOR_FRAMING * );
KSDDKAPI NTSTATUS NTAPI KsValidateAllocatorFramingEx( PKSALLOCATOR_FRAMING_EX, ULONG, const KSALLOCATOR_FRAMING_EX * );
KSDDKAPI NTSTATUS NTAPI KsValidateClockCreateRequest( PIRP, PKSCLOCK_CREATE * );
KSDDKAPI NTSTATUS NTAPI KsValidateConnectRequest( PIRP, ULONG, const KSPIN_DESCRIPTOR *, PKSPIN_CONNECT * );
KSDDKAPI NTSTATUS NTAPI KsValidateTopologyNodeCreateRequest( PIRP, PKSTOPOLOGY, PKSNODE_CREATE * );
KSDDKAPI NTSTATUS NTAPI KsWriteFile( PFILE_OBJECT, PKEVENT, PVOID, PIO_STATUS_BLOCK, PVOID, ULONG, ULONG, KPROCESSOR_MODE );
#if (NTDDI_VERSION >= 0x05010000)
KSDDKAPI void NTAPI     KsAcquireControl( PVOID );
KSDDKAPI void NTAPI     KsAcquireDevice( PKSDEVICE );
KSDDKAPI NTSTATUS NTAPI KsAddDevice( PDRIVER_OBJECT, PDEVICE_OBJECT );
KSDDKAPI void NTAPI     KsAddEvent( PVOID, PKSEVENT_ENTRY );
KSDDKAPI NTSTATUS NTAPI KsAddItemToObjectBag( KSOBJECT_BAG, PVOID, PFNKSFREE );
KSDDKAPI NTSTATUS NTAPI KsAllocateDefaultClockEx( PKSDEFAULTCLOCK *, PVOID, PFNKSSETTIMER, PFNKSCANCELTIMER, PFNKSCORRELATEDTIME, const KSRESOLUTION *, ULONG );
KSDDKAPI NTSTATUS NTAPI KsAllocateObjectBag( PKSDEVICE, KSOBJECT_BAG * );
KSDDKAPI NTSTATUS NTAPI KsCacheMedium( PUNICODE_STRING, PKSPIN_MEDIUM, ULONG );
KSDDKAPI void NTAPI     KsCompletePendingRequest( PIRP );
KSDDKAPI NTSTATUS NTAPI KsCopyObjectBagItems( KSOBJECT_BAG, KSOBJECT_BAG );
KSDDKAPI NTSTATUS NTAPI KsCreateDevice( PDRIVER_OBJECT, PDEVICE_OBJECT, const KSDEVICE_DESCRIPTOR *, ULONG, PKSDEVICE * );
KSDDKAPI NTSTATUS NTAPI KsCreateFilterFactory( PDEVICE_OBJECT, const KSFILTER_DESCRIPTOR *, PWSTR, PSECURITY_DESCRIPTOR, ULONG, PFNKSFILTERFACTORYPOWER, PFNKSFILTERFACTORYPOWER, PKSFILTERFACTORY * );
KSDDKAPI NTSTATUS NTAPI KsDefaultAddEventHandler( PIRP, PKSEVENTDATA, PKSEVENT_ENTRY );
KSDDKAPI ULONG NTAPI    KsDeviceGetBusData( PKSDEVICE, ULONG, PVOID, ULONG, ULONG );
KSDDKAPI void NTAPI     KsDeviceRegisterAdapterObject( PKSDEVICE, PADAPTER_OBJECT, ULONG, ULONG );
KSDDKAPI ULONG NTAPI    KsDeviceSetBusData( PKSDEVICE, ULONG, PVOID, ULONG, ULONG );
KSDDKAPI void NTAPI     KsFilterAcquireProcessingMutex( PKSFILTER );
KSDDKAPI NTSTATUS NTAPI KsFilterAddTopologyConnections( PKSFILTER, ULONG, const KSTOPOLOGY_CONNECTION * );
KSDDKAPI void NTAPI     KsFilterAttemptProcessing( PKSFILTER, BOOLEAN );
KSDDKAPI NTSTATUS NTAPI KsFilterCreateNode( PKSFILTER, const KSNODE_DESCRIPTOR *, PULONG );
KSDDKAPI NTSTATUS NTAPI KsFilterCreatePinFactory( PKSFILTER, const KSPIN_DESCRIPTOR_EX *, PULONG );
KSDDKAPI NTSTATUS NTAPI KsFilterFactoryAddCreateItem( PKSFILTERFACTORY, PWSTR, PSECURITY_DESCRIPTOR, ULONG );
KSDDKAPI PUNICODE_STRING NTAPI  KsFilterFactoryGetSymbolicLink( PKSFILTERFACTORY );
KSDDKAPI NTSTATUS NTAPI KsFilterFactorySetDeviceClassesState( PKSFILTERFACTORY, BOOLEAN );
KSDDKAPI NTSTATUS NTAPI KsFilterFactoryUpdateCacheData( PKSFILTERFACTORY, const KSFILTER_DESCRIPTOR * );
KSDDKAPI PKSGATE NTAPI  KsFilterGetAndGate( PKSFILTER );
KSDDKAPI ULONG NTAPI    KsFilterGetChildPinCount( PKSFILTER, ULONG );
KSDDKAPI PKSPIN NTAPI   KsFilterGetFirstChildPin( PKSFILTER, ULONG );
KSDDKAPI void NTAPI     KsFilterRegisterPowerCallbacks( PKSFILTER, PFNKSFILTERPOWER, PFNKSFILTERPOWER );
KSDDKAPI void NTAPI     KsFilterReleaseProcessingMutex( PKSFILTER );
KSDDKAPI void NTAPI     KsFreeObjectBag( KSOBJECT_BAG );
KSDDKAPI void NTAPI     KsGenerateEvents( PVOID, const GUID *, ULONG, ULONG, PVOID, PFNKSGENERATEEVENTCALLBACK, PVOID );
KSDDKAPI PKSDEVICE NTAPI    KsGetDevice( PVOID );
KSDDKAPI PKSDEVICE NTAPI    KsGetDeviceForDeviceObject( PDEVICE_OBJECT );
KSDDKAPI PKSFILTER NTAPI    KsGetFilterFromIrp( PIRP );
KSDDKAPI PVOID NTAPI    KsGetFirstChild( PVOID );
KSDDKAPI PVOID NTAPI    KsGetNextSibling( PVOID );
KSDDKAPI ULONG NTAPI    KsGetNodeIdFromIrp( PIRP );
KSDDKAPI PVOID NTAPI    KsGetObjectFromFileObject( PFILE_OBJECT );
KSDDKAPI KSOBJECTTYPE NTAPI KsGetObjectTypeFromFileObject( PFILE_OBJECT );
KSDDKAPI KSOBJECTTYPE NTAPI KsGetObjectTypeFromIrp( PIRP );
KSDDKAPI PVOID NTAPI    KsGetParent( PVOID );
KSDDKAPI PKSPIN NTAPI   KsGetPinFromIrp( PIRP );
KSDDKAPI NTSTATUS NTAPI KsInitializeDevice( PDEVICE_OBJECT, PDEVICE_OBJECT, PDEVICE_OBJECT, const KSDEVICE_DESCRIPTOR * );
KSDDKAPI NTSTATUS NTAPI KsInitializeDriver( PDRIVER_OBJECT, PUNICODE_STRING, const KSDEVICE_DESCRIPTOR * );
KSDDKAPI NTSTATUS NTAPI KsMergeAutomationTables( PKSAUTOMATION_TABLE *, PKSAUTOMATION_TABLE, PKSAUTOMATION_TABLE, KSOBJECT_BAG );
KSDDKAPI void NTAPI     KsPinAcquireProcessingMutex( PKSPIN );
KSDDKAPI void NTAPI     KsPinAttachAndGate( PKSPIN, PKSGATE );
KSDDKAPI void NTAPI     KsPinAttachOrGate( PKSPIN, PKSGATE );
KSDDKAPI void NTAPI     KsPinAttemptProcessing( PKSPIN, BOOLEAN );
KSDDKAPI PKSGATE NTAPI  KsPinGetAndGate( PKSPIN );
KSDDKAPI NTSTATUS NTAPI KsPinGetAvailableByteCount( PKSPIN, PLONG, PLONG );
KSDDKAPI PDEVICE_OBJECT NTAPI   KsPinGetConnectedPinDeviceObject( PKSPIN );
KSDDKAPI PFILE_OBJECT NTAPI KsPinGetConnectedPinFileObject( PKSPIN );
KSDDKAPI NTSTATUS NTAPI KsPinGetConnettedPinFilterInterface( PKSPIN, const GUID *, PVOID * );
KSDDKAPI NTSTATUS NTAPI KsPinGetConnectedPinInterface( PKSPIN, const GUID *, PVOID * );
KSDDKAPI void NTAPI     KsPinGetCopyRelationships( PKSPIN, PKSPIN *, PKSPIN * );
KSDDKAPI PKSSTREAM_POINTER NTAPI    KsPinGetFirstCloneStreamPointer( PKSPIN );
KSDDKAPI PKSSTREAM_POINTER NTAPI    KsPinGetLeadingEdgeStreamPointer( PKSPIN, KSSTREAM_POINTER_STATE );
KSDDKAPI PKSPIN NTAPI   KsPinGetNextSiblingPin( PKSPIN );
KSDDKAPI PKSFILTER NTAPI    KsPinGetParentFilter( PKSPIN );
KSDDKAPI PKSSTREAM_POINTER NTAPI    KsPinGetTrailingEdgeStreamPointer( PKSPIN, KSSTREAM_POINTER_STATE );
KSDDKAPI void NTAPI     KsPinRegisterFrameReturnCallback( PKSPIN, PFNKSPINFRAMERETURN );
KSDDKAPI void NTAPI     KsPinRegisterHandshakeCallback( PKSPIN, PFNKSPINHANDSHAKE );
KSDDKAPI void NTAPI     KsPinRegisterIrpCompletionCallback( PKSPIN, PFNKSPINIRPCOMPLETION );
KSDDKAPI void NTAPI     KsPinRegisterPowerCallbacks( PKSPIN, PFNKSPINPOWER, PFNKSPINPOWER );
KSDDKAPI void NTAPI     KsPinReleaseProcessingMutex( PKSPIN );
KSDDKAPI VOID NTAPI     KsPinSetPinClockTime( PKSPIN, LONGLONG );
KSDDKAPI NTSTATUS NTAPI KsPinSubmitFrame( PKSPIN, PVOID, ULONG, PKSSTREAM_HEADER, PVOID );
KSDDKAPI NTSTATUS NTAPI KsPinSubmitFrameMdl( PKSPIN, PMDL, KSSTREAM_HEADER, PVOID );
KSDDKAPI BOOLEAN NTAPI  KsProcessPinUpdate( PKSPROCESSPIN );
KSDDKAPI NTSTATUS NTAPI KsRegisterFilterWithNoKSPins( PDEVICE_OBJECT, const GUID *, ULONG, BOOL *, KSPIN_MEDIUM *, GUID * );
KSDDKAPI void NTAPI     KsReleaseControl( PVOID );
KSDDKAPI void NTAPI     KsReleaseDevice( PKSDEVICE );
KSDDKAPI ULONG NTAPI    KsRemoveItemFromObjectBag( KSOBJECT_BAG, PVOID, BOOLEAN );
KSDDKAPI NTSTATUS NTAPI KsStreamPointerAdvance( PKSSTREAM_POINTER );
KSDDKAPI NTSTATUS NTAPI KsStreamPointerAdvanceOffsets( PKSSTREAM_POINTER, ULONG, ULONG, BOOLEAN );
KSDDKAPI void NTAPI     KsStreamPointerAdvanceOffsetsAndUnlock( PKSSTREAM_POINTER, ULONG, ULONG, BOOLEAN );
KSDDKAPI void NTAPI     KsStreamPointerCancelTimeout( PKSSTREAM_POINTER );
KSDDKAPI NTSTATUS NTAPI KsStreamPointerClone( PKSSTREAM_POINTER, PFNKSSTREAMPOINTER, ULONG, PKSSTREAM_POINTER * );
KSDDKAPI void NTAPI     KsStreamPointerDelete( PKSSTREAM_POINTER );
KSDDKAPI PIRP NTAPI     KsStreamPointerGetIrp( PKSSTREAM_POINTER, PBOOLEAN, PBOOLEAN );
KSDDKAPI PMDL NTAPI     KsStreamPointerGetMdl( PKSSTREAM_POINTER );
KSDDKAPI PKSSTREAM_POINTER NTAPI    KsStreamPointerGetNextClone( PKSSTREAM_POINTER );
KSDDKAPI NTSTATUS NTAPI KsStreamPointerLock( PKSSTREAM_POINTER );
KSDDKAPI void NTAPI     KsStreamPointerScheduleTimeout( PKSSTREAM_POINTER, PFNKSSTREAMPOINTER, ULONGLONG );
KSDDKAPI NTSTATUS NTAPI KsStreamPointerSetStatusCode( PKSSTREAM_POINTER, NTSTATUS );
KSDDKAPI void NTAPI     KsStreamPointerUnlock( PKSSTREAM_POINTER, BOOLEAN );
KSDDKAPI void NTAPI     KsTerminateDevice( PDEVICE_OBJECT );
KSDDKAPI NTSTATUS NTAPI _KsEdit( KSOBJECT_BAG, PVOID *, ULONG, ULONG, ULONG );
#ifdef _UNKNOWN_H_
KSDDKAPI PUNKNOWN NTAPI KsGetOuterUnknown( PVOID );
KSDDKAPI NTSTATUS NTAPI KsGetReferenceClockInterface( PKSPIN, PIKSREFERENCECLOCK * );
KSDDKAPI PUNKNOWN NTAPI KsRegisterAggregatedClientUnknown( PVOID, PUNKNOWN );
#endif
#endif
#endif

/* Functions in KSUSER.DLL */
#ifndef _NTDDK_
KSDDKAPI DWORD WINAPI   KsCreateAllocator( HANDLE, PKSALLOCATOR_FRAMING, PHANDLE );
KSDDKAPI DWORD WINAPI   KsCreateClock( HANDLE, PKSCLOCK_CREATE, PHANDLE );
KSDDKAPI DWORD WINAPI   KsCreatePin( HANDLE, PKSPIN_CONNECT, ACCESS_MASK, PHANDLE );
KSDDKAPI DWORD WINAPI   KsCreateTopologyNode( HANDLE, PKSNODE_CREATE, ACCESS_MASK, PHANDLE );
#endif

/* Functions implemented as macros */
#define SetDefaultKsCompression( x ) \
    { \
        (x)->RatioNumerator = 1; \
        (x)->RatioDenominator = 1; \
        (x)->RatioConstantMargin = 0; \
    }
#define SetDontCareKsFramingRange( x ) \
    { \
        (x)->MinFrameSize = 0; \
        (x)->MaxFrameSize = 0xFFFFFFFFL; \
        (x)->Stepping = 1; \
    }
#define SetKsFramingRange( x, p1, p2 ) \
    { \
        (x)->MinFrameSize = p1; \
        (x)->MaxFrameSize = p2; \
        (x)->Stepping = 1; \
    }
#define SetKsFramingRangeWeighted( x, p1, p2 ) \
    { \
        KS_FRAMING_RANGE    *unweighted = &(x)->Range; \
        SetKsFramingRange( unweighted, p1, p2 ); \
        (x)->InPlaceWeight = 0; \
        (x)->NotInPlaceWeight = 0; \
    }
#ifdef _NTDDK_
    #if (NTDDI_VERSION >= 0x05010000)
        #define KsDeleteFilterFactory( x ) \
            KsFreeObjectCreateItemsByContext( *(KSDEVICE_HEADER *) \
            (KsFilterFactoryGetParentDevice( x )->FunctionalDeviceObject-> \
            DeviceExtension), x )
        #define KsGetFilterFromFileObject( x ) \
            ((PKSFILTER)KsGetObjectFromFileObject( x ))
        #define KsGetPinFromFileObject( x ) \
            ((PKSPIN)KsGetObjectFromFileObject( x ))
        #define KsFilterFactoryGetParentDevice( x ) \
            ((PKSDEVICE)KsGetParent( (PVOID)(x) ))
        #define KsFilterGetParentFilterFactory( x ) \
            ((PKSFILTERFACTORY)KsGetParent( (PVOID)(x) ))
        #define KsDeviceGetFirstChildFilterFactory( x ) \
            ((PKSFILTERFACTORY)KsGetFirstChild( (PVOID)(x) ))
        #define KsFilterFactoryGetFirstChildFilter( x ) \
            ((PKSFILTER)KsGetFirstChild( (PVOID)(x) ))
        #define KsFilterFactoryGetNextSiblingFilterFactory( x ) \
            ((PKSFILTERFACTORY)KsGetNextSibling( (PVOID)(x) ))
        #define KsFilterGetNextSiblingFilter( x ) \
            ((PKSFILTER)KsGetNextSibling( (PVOID)(x) ))
        #define KsFilterFactoryGetDevice( x ) \
            KsGetDevice( (PVOID)(x) )
        #define KsFilterGetDevice( x ) \
            KsGetDevice( (PVOID)(x) )
        #define KsPinGetDevice( x ) \
            KsGetDevice( (PVOID)(x) )
        #define KsFilterAcquireControl( x ) \
            KsAcquireControl( (PVOID)(x) )
        #define KsFilterReleaseControl( x ) \
            KsReleaseControl( (PVOID)(x) )
        #define KsPinAcquireControl( x ) \
            KsAcquireControl( (PVOID)(x) )
        #define KsPinReleaseControl( x ) \
            KsReleaseControl( (PVOID)(x) )
        #define KsDiscard( p1, p2 ) \
            KsRemoveItemFromObjectBag( (p1)->Bag, (PVOID)(p2), TRUE )
        #define KsEdit( p1, p2, p3 ) \
            _KsEdit( (p1)->Bag, (PVOID *)(p2), sizeof( **(p2) ), sizeof( **(p2) ), p3 )
        #define KsEditSized( p1, p2, p3, p4, p5 ) \
            _KsEdit( (p1)->Bag, (PVOID *)(p2), p3, p4, p5 )
        #ifdef _UNKNOWN_H_
            #define KsDeviceRegisterAggregatedClientUnknown( p1, p2 ) \
                KsRegisterAggregatedClientUnknown( (PVOID)(p1), p2 )
            #define KsDeviceGetOuterUnknown( x ) \
                KsGetOuterUnknown( (PVOID)(x) )
            #define KsFilterFactoryRegisterAggregatedClientUnknown( p1, p2 ) \
                KsRegisterAggregatedClientUnknown( (PVOID)(p1), p2 )
            #define KsFilterFactoryGetOuterUnknown( x ) \
                KsGetOuterUnknown( (PVOID)(x) )
            #define KsFilterRegisterAggregatedClientUnknown( p1, p2 ) \
                KsRegisterAggregatedClientUnknown( (PVOID)(p1), p2 )
            #define KsFilterGetOuterUnknown( x ) \
                KsGetOuterUnknown( (PVOID)(x) )
            #define KsPinRegisterAggregatedClientUnknown( p1, p2 ) \
                KsRegisterAggregatedClientUnknown( (PVOID)(p1), p2 )
            #define KsPinGetOuterUnknown( x ) \
                KsGetOuterUnknown( (PVOID)(x) )
        #endif
    #endif
#endif

/* Aliases */
#define KsDispatchFastWriteFailure      KsDispatchFastReadFailure
#ifdef _NTDDK_
    #if (NTDDI_VERSION >= 0x05010000)
        #define KsFilterAddEvent        KsAddEvent
        #define KsFilterGenerateEvents  KsGenerateEvents
        #define KsPinAddEvent           KsAddEvent
        #define KsPinGenerateEvents     KsGenerateEvents
    #endif
#endif

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* _KS_ */
