/*
 *  ipxrip.h    IPX RIP structures
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2014 The Open Watcom Contributors. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */

#ifndef _IPXRIP_
#define _IPXRIP_

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file;
#endif

#include <ipxconst.h>

#ifdef __cplusplus
extern "C" {
#endif

/* IPX route filter actions */
#define IPX_ROUTE_FILTER_PERMIT 1L
#define IPX_ROUTE_FILTER_DENY   2L

/* RIP table identifiers */
#define RIP_BASE_ENTRY      0
#define RIP_INTERFACE_TABLE 1

/* RIP global information */
typedef struct _RIP_GLOBAL_INFO {
    DWORD   EventLogMask;
} RIP_GLOBAL_INFO;
typedef RIP_GLOBAL_INFO *PRIP_GLOBAL_INFO;

/* RIP interface information */
typedef struct _RIP_IF_INFO {
    ULONG   AdminState;
    ULONG   UpdateMode;
    ULONG   PacketType;
    ULONG   Supply;
    ULONG   Listen;
    ULONG   PeriodicUpdateInterval;
    ULONG   AgeIntervalMultiplier;
} RIP_IF_INFO;
typedef RIP_IF_INFO *PRIP_IF_INFO;

/* RIP route filter information */
typedef struct _RIP_ROUTE_FILTER_INFO {
    UCHAR   Network[4];
    UCHAR   Mask[4];
} RIP_ROUTE_FILTER_INFO;
typedef RIP_ROUTE_FILTER_INFO   *PRIP_ROUTE_FILTER_INFO;

/* RIP interface filters */
typedef struct _RIP_IF_FILTERS {
    ULONG                   SupplyFilterAction;
    ULONG                   SupplyFilterCount;
    ULONG                   ListenFilterAction;
    ULONG                   ListenFilterCount;
    RIP_ROUTE_FILTER_INFO   RouteFilter[1];
} RIP_IF_FILTERS;
typedef RIP_IF_FILTERS  *PRIP_IF_FILTERS;

/* RIP interface configuration information */
typedef struct _RIP_IF_CONFIG {
    RIP_IF_INFO     RipIfInfo;
    RIP_IF_FILTERS  RipIfFilters;
} RIP_IF_CONFIG;
typedef RIP_IF_CONFIG   *PRIP_IF_CONFIG;

/* RIP MIB base */
typedef struct _RIPMIB_BASE {
    ULONG   RIPOperState;
} RIPMIB_BASE;
typedef RIPMIB_BASE *PRIPMIB_BASE;

/* RIP interface statistics */
typedef struct _RIP_IF_STATS {
    ULONG   RipIfOperState;
    ULONG   RipIfInputPackets;
    ULONG   RipIfOutputPackets;
} RIP_IF_STATS;
typedef RIP_IF_STATS    *PRIP_IF_STATS;

/* RIP interface */
typedef struct _RIP_INTERFACE {
    ULONG           InterfaceIndex;
    RIP_IF_INFO     RipIfInfo;
    RIP_IF_STATS    RipIfStats;
} RIP_INTERFACE;
typedef RIP_INTERFACE   *PRIP_INTERFACE;

/* RIP MIB input data */
typedef struct _RIP_MIB_GET_INPUT_DATA {
    ULONG   TableId;
    ULONG   InterfaceIndex;
} RIP_MIB_GET_INPUT_DATA;
typedef RIP_MIB_GET_INPUT_DATA  *PRIP_MIB_GET_INPUT_DATA;
typedef struct _RIP_MIB_SET_INPUT_DATA {
    ULONG           TableId;
    RIP_INTERFACE   RipInterface;
} RIP_MIB_SET_INPUT_DATA;
typedef RIP_MIB_SET_INPUT_DATA  *PRIP_MIB_SET_INPUT_DATA;

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* _IPXRIP_ */
