/*
 *  iptypes.h   IP types
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2014 The Open Watcom Contributors. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */

#ifndef IP_TYPES_INCLUDED
#define IP_TYPES_INCLUDED

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file;
#endif

#include <time.h>
#include <ifdef.h>
#include <nldef.h>

#ifdef __cplusplus
extern "C" {
#endif

/* Lengths */
#define MAX_ADAPTER_DESCRIPTION_LENGTH  128
#define MAX_ADAPTER_NAME_LENGTH         256
#define MAX_ADAPTER_ADDRESS_LENGTH      8
#define DEFAULT_MINIMUM_ENTITIES        32
#define MAX_HOSTNAME_LEN                128
#define MAX_DOMAIN_NAME_LEN             128
#define MAX_SCOPE_ID_LEN                256
#define MAX_DHCPV6_DUID_LENGTH          130
#define MAX_DNS_SUFFIX_STRING_LENGTH    256

/* Node types */
#define BROADCAST_NODETYPE      1
#define PEER_TO_PEER_NODETYPE   2
#define MIXED_NODETYPE          4
#define HYBRID_NODETYPE         8

/* IP adapter address flags */
#ifdef _WINSOCK2API_
    #define IP_ADAPTER_ADDRESS_DNS_ELIGIBLE 0x00000001L
    #define IP_ADAPTER_ADDRESS_TRANSIENT    0x00000002L
#endif

/* IP adapter flags */
#ifdef _WINSOCK2API_
    #define IP_ADAPTER_DDNS_ENABLED                 0x00000001L
    #define IP_ADAPTER_REGISTER_ADAPTER_SUFFIX      0x00000002L
    #define IP_ADAPTER_DHCP_ENABLED                 0x00000004L
    #define IP_ADAPTER_RECEIVE_ONLY                 0x00000008L
    #define IP_ADAPTER_NO_MULTICAST                 0x00000010L
    #define IP_ADAPTER_IPV6_OTHER_STATEFUL_CONFIG   0x00000020L
    #define IP_ADAPTER_NETBIOS_OVER_TCPIP_ENABLED   0x00000040L
    #define IP_ADAPTER_IPV4_ENABLED                 0x00000080L
    #define IP_ADAPTER_IPV6_ENABLED                 0x00000100L
    #define IP_ADAPTER_IPV6_MANAGE_ADDRESS_CONFIG   0x00000200L
#endif

/* GetAdaptersAddresses() flags */
#ifdef _WINSOCK2API_
    #define GAA_FLAG_SKIP_UNICAST                   0x00000001L
    #define GAA_FLAG_SKIP_ANYCAST                   0x00000002L
    #define GAA_FLAG_SKIP_MULTICAST                 0x00000004L
    #define GAA_FLAG_SKIP_DNS_SERVER                0x00000008L
    #define GAA_FLAG_INCLUDE_PREFIX                 0x00000010L
    #define GAA_FLAG_SKIP_FRIENDLY_NAME             0x00000020L
    #define GAA_FLAG_INCLUDE_WINS_INFO              0x00000040L
    #define GAA_FLAG_INCLUDE_GATEWAYS               0x00000080L
    #define GAA_FLAG_INCLUDE_ALL_INTERFACES         0x00000100L
    #define GAA_FLAG_INCLUDE_ALL_COMPARTMENTS       0x00000200L
    #define GAA_FLAG_INCLUDE_TUNNEL_BINDINGORDER    0x00000400L
#endif

/* IP address string */
typedef struct {
    char    String[16];
} IP_ADDRESS_STRING;
typedef IP_ADDRESS_STRING   *PIP_ADDRESS_STRING;
typedef IP_ADDRESS_STRING   IP_MASK_STRING;
typedef IP_ADDRESS_STRING   *PIP_MASK_STRING;
typedef struct _IP_ADDR_STRING {
    struct _IP_ADDR_STRING  *Next;
    IP_ADDRESS_STRING       IpAddress;
    IP_MASK_STRING          IpMask;
    DWORD                   Context;
} IP_ADDR_STRING;
typedef IP_ADDR_STRING  *PIP_ADDR_STRING;

/* IP adapter information */
typedef struct _IP_ADAPTER_INFO {
    struct _IP_ADAPTER_INFO *Next;
    DWORD                   ComboIndex;
    char                    AdapterName[MAX_ADAPTER_NAME_LENGTH + 4];
    char                    Description[MAX_ADAPTER_DESCRIPTION_LENGTH + 4];
    UINT                    AddressLength;
    BYTE                    Address[MAX_ADAPTER_ADDRESS_LENGTH];
    DWORD                   Index;
    UINT                    Type;
    UINT                    DhcpEnabled;
    PIP_ADDR_STRING         CurrentIpAddress;
    IP_ADDR_STRING          IpAddressList;
    IP_ADDR_STRING          GatewayList;
    IP_ADDR_STRING          DhcpServer;
    BOOL                    HaveWins;
    IP_ADDR_STRING          PrimaryWinsServer;
    IP_ADDR_STRING          SecondaryWinsServer;
    time_t                  LeaseObtained;
    time_t                  LeaseExpires;
} IP_ADAPTER_INFO;
typedef IP_ADAPTER_INFO *PIP_ADAPTER_INFO;

/* Aliases of types in nldef.h */
#ifdef _WINSOCK2API_
typedef NL_PREFIX_ORIGIN    IP_PREFIX_ORIGIN;
typedef NL_SUFFIX_ORIGIN    IP_SUFFIX_ORIGIN;
typedef NL_DAD_STATE        IP_DAD_STATE;
#endif

/* IP adapter unicast address */
#ifdef _WINSOCK2API_
typedef struct _IP_ADAPTER_UNICAST_ADDRESS_LH {
    union {
        ULONGLONG   Alignment;
        struct {
            ULONG   Length;
            DWORD   Flags;
        };
    };
    struct _IP_ADAPTER_UNICAST_ADDRESS_LH   *Next;
    SOCKET_ADDRESS                          Address;
    IP_PREFIX_ORIGIN                        PrefixOrigin;
    IP_SUFFIX_ORIGIN                        SuffixOrigin;
    IP_DAD_STATE                            DadState;
    ULONG                                   ValidLifetime;
    ULONG                                   PreferredLifetime;
    ULONG                                   LeaseLifetime;
    UINT8                                   OnLinkPrefixLength;
} IP_ADAPTER_UNICAST_ADDRESS_LH;
typedef IP_ADAPTER_UNICAST_ADDRESS_LH   *PIP_ADAPTER_UNICAST_ADDRESS_LH;
typedef struct _IP_ADAPTER_UNICAST_ADDRESS_XP {
    union {
        ULONGLONG   Alignment;
        struct {
            ULONG   Length;
            DWORD   Flags;
        };
    };
    struct _IP_ADAPTER_UNICAST_ADDRESS_XP   *Next;
    SOCKET_ADDRESS                          Address;
    IP_PREFIX_ORIGIN                        PrefixOrigin;
    IP_SUFFIX_ORIGIN                        SuffixOrigin;
    IP_DAD_STATE                            DadState;
    ULONG                                   ValidLifetime;
    ULONG                                   PreferredLifetime;
    ULONG                                   LeaseLifetime;
} IP_ADAPTER_UNICAST_ADDRESS_XP;
typedef IP_ADAPTER_UNICAST_ADDRESS_XP   *PIP_ADAPTER_UNICAST_ADDRESS_XP;
#if (NTDDI_VERSION >= 0x06000000)
typedef IP_ADAPTER_UNICAST_ADDRESS_LH   IP_ADAPTER_UNICAST_ADDRESS;
typedef IP_ADAPTER_UNICAST_ADDRESS_LH   *PIP_ADAPTER_UNICAST_ADDRESS;
#elif (NTDDI_VERSION >= 0x05010000)
typedef IP_ADAPTER_UNICAST_ADDRESS_XP   IP_ADAPTER_UNICAST_ADDRESS;
typedef IP_ADAPTER_UNICAST_ADDRESS_XP   *PIP_ADAPTER_UNICAST_ADDRESS;
#endif
#endif

/* IP adapter anycast address */
#ifdef _WINSOCK2API_
typedef struct _IP_ADAPTER_ANYCAST_ADDRESS_XP {
    union {
        ULONGLONG   Alignment;
        struct {
            ULONG   Length;
            DWORD   Flags;
        };
    };
    struct _IP_ADAPTER_ANYCAST_ADDRESS_XP   *Next;
    SOCKET_ADDRESS                          Address;
} IP_ADAPTER_ANYCAST_ADDRESS_XP;
typedef IP_ADAPTER_ANYCAST_ADDRESS_XP   *PIP_ADAPTER_ANYCAST_ADDRESS_XP;
#if (NTDDI_VERSION >= 0x05010000)
typedef IP_ADAPTER_ANYCAST_ADDRESS_XP   IP_ADAPTER_ANYCAST_ADDRESS;
typedef IP_ADAPTER_ANYCAST_ADDRESS_XP   *PIP_ADAPTER_ANYCAST_ADDRESS;
#endif
#endif

/* IP adapter multicast address */
#ifdef _WINSOCK2API_
typedef struct _IP_ADAPTER_MULTICAST_ADDRESS_XP {
    union {
        ULONGLONG   Alignment;
        struct {
            ULONG   Length;
            DWORD   Flags;
        };
    };
    struct _IP_ADAPTER_MULTICAST_ADDRESS_XP *Next;
    SOCKET_ADDRESS                          Address;
} IP_ADAPTER_MULTICAST_ADDRESS_XP;
typedef IP_ADAPTER_MULTICAST_ADDRESS_XP *PIP_ADAPTER_MULTICAST_ADDRESS_XP;
#if (NTDDI_VERSION >= 0x05010000)
typedef IP_ADAPTER_MULTICAST_ADDRESS_XP IP_ADAPTER_MULTICAST_ADDRESS;
typedef IP_ADAPTER_MULTICAST_ADDRESS_XP *PIP_ADAPTER_MULTICAST_ADDRESS;
#endif
#endif

/* IP adapter DNS server address */
#ifdef _WINSOCK2API_
typedef struct _IP_ADAPTER_DNS_SERVER_ADDRESS_XP {
    union {
        ULONGLONG   Alignment;
        struct {
            ULONG   Length;
            DWORD   Reserved;
        };
    };
    struct _IP_ADAPTER_DNS_SERVER_ADDRESS_XP    *Next;
    SOCKET_ADDRESS                              Address;
} IP_ADAPTER_DNS_SERVER_ADDRESS_XP;
typedef IP_ADAPTER_DNS_SERVER_ADDRESS_XP    *PIP_ADAPTER_DNS_SERVER_ADDRESS_XP;
#if (NTDDI_VERSION >= 0x05010000)
typedef IP_ADAPTER_DNS_SERVER_ADDRESS_XP    IP_ADAPTER_DNS_SERVER_ADDRESS;
typedef IP_ADAPTER_DNS_SERVER_ADDRESS_XP    *PIP_ADAPTER_DNS_SERVER_ADDRESS;
#endif
#endif

/* IP adapter WINS server address */
#ifdef _WINSOCK2API_
typedef struct _IP_ADAPTER_WINS_SERVER_ADDRESS_LH {
    union {
        ULONGLONG   Alignment;
        struct {
            ULONG   Length;
            DWORD   Reserved;
        };
    };
    struct _IP_ADAPTER_WINS_SERVER_ADDRESS_LH   *Next;
    SOCKET_ADDRESS                              Address;
} IP_ADAPTER_WINS_SERVER_ADDRESS_LH;
typedef IP_ADAPTER_WINS_SERVER_ADDRESS_LH   *PIP_ADAPTER_WINS_SERVER_ADDRESS_LH;
#if (NTDDI_VERSION >= 0x06000000)
typedef IP_ADAPTER_WINS_SERVER_ADDRESS_LH   IP_ADAPTER_WINS_SERVER_ADDRESS;
typedef IP_ADAPTER_WINS_SERVER_ADDRESS_LH   *PIP_ADAPTER_WINS_SERVER_ADDRESS;
#endif
#endif

/* IP adapter gateway address */
#ifdef _WINSOCK2API_
typedef struct _IP_ADAPTER_GATEWAY_ADDRESS_LH {
    union {
        ULONGLONG   Alignment;
        struct {
            ULONG   Length;
            DWORD   Reserved;
        };
    };
    struct _IP_ADAPTER_GATEWAY_ADDRESS_LH   *Next;
    SOCKET_ADDRESS                          Address;
} IP_ADAPTER_GATEWAY_ADDRESS_LH;
typedef IP_ADAPTER_GATEWAY_ADDRESS_LH   *PIP_ADAPTER_GATEWAY_ADDRESS_LH;
#if (NTDDI_VERSION >= 0x06000000)
typedef IP_ADAPTER_GATEWAY_ADDRESS_LH   IP_ADAPTER_GATEWAY_ADDRESS;
typedef IP_ADAPTER_GATEWAY_ADDRESS_LH   *PIP_ADAPTER_GATEWAY_ADDRESS;
#endif
#endif

/* IP adapter prefix */
#ifdef _WINSOCK2API_
typedef struct _IP_ADAPTER_PREFIX_XP {
    union {
        ULONGLONG   Alignment;
        struct {
            ULONG   Length;
            DWORD   Flags;
        };
    };
    struct _IP_ADAPTER_PREFIX_XP    *Next;
    SOCKET_ADDRESS                  Address;
    ULONG                           PrefixLength;
} IP_ADAPTER_PREFIX_XP;
typedef IP_ADAPTER_PREFIX_XP    *PIP_ADAPTER_PREFIX_XP;
#if (NTDDI_VERSION >= 0x05010000)
typedef IP_ADAPTER_PREFIX_XP    IP_ADAPTER_PREFIX;
typedef IP_ADAPTER_PREFIX_XP    *PIP_ADAPTER_PREFIX;
#endif
#endif

/* IP adapter DNS suffix */
#ifdef _WINSOCK2API_
typedef struct _IP_ADAPTER_DNS_SUFFIX {
    struct _IP_ADAPTER_DNS_SUFFIX   *Next;
    WCHAR                           String[MAX_DNS_SUFFIX_STRING_LENGTH];
} IP_ADAPTER_DNS_SUFFIX;
typedef IP_ADAPTER_DNS_SUFFIX   *PIP_ADAPTER_DNS_SUFFIX;
#endif

/* IP adapter addresses */
#ifdef _WINSOCK2API_
typedef struct _IP_ADAPTER_ADDRESSES_LH {
    union {
        ULONGLONG   Alignment;
        struct {
            ULONG       Length;
            IF_INDEX    IfIndex;
        };
    };
    struct _IP_ADAPTER_ADDRESSES_LH     *Next;
    PCHAR                               AdapterName;
    PIP_ADAPTER_UNICAST_ADDRESS_LH      FirstUnicastAddress;
    PIP_ADAPTER_ANYCAST_ADDRESS_XP      FirstAnycastAddress;
    PIP_ADAPTER_MULTICAST_ADDRESS_XP    FirstMulticastAddress;
    PIP_ADAPTER_DNS_SERVER_ADDRESS_XP   FirstDnsServerAddress;
    PWCHAR                              DnsSuffix;
    PWCHAR                              Description;
    PWCHAR                              FriendlyName;
    BYTE                                PhysicalAddress[MAX_ADAPTER_ADDRESS_LENGTH];
    ULONG                               PhysicalAddressLength;
    union {
        ULONG   Flags;
        struct {
            ULONG   DdnsEnabled                                 : 1;
            ULONG   RegisterAdapterSuffix                       : 1;
            ULONG   Dhcpv4Enabled                               : 1;
            ULONG   ReceiveOnly                                 : 1;
            ULONG   NoMulticast                                 : 1;
            ULONG   Ipv6OtherStatefulConfig                     : 1;
            ULONG   NetbiosOverTcpipEnabled                     : 1;
            ULONG   Ipv4Enabled                                 : 1;
            ULONG   Ipv6Enabled                                 : 1;
            ULONG   Ipv6ManagedAddressConfigurationSupported    : 1;
        };
    };
    ULONG                               Mtu;
    IFTYPE                              IfType;
    IF_OPER_STATUS                      OperStatus;
    IF_INDEX                            Ipv6IfIndex;
    ULONG                               ZoneIndices[16];
    PIP_ADAPTER_PREFIX_XP               FirstPrefix;
    ULONG64                             TransmitLinkSpeed;
    ULONG64                             ReceiveLinkSpeed;
    PIP_ADAPTER_WINS_SERVER_ADDRESS_LH  FirstWinsServerAddress;
    PIP_ADAPTER_GATEWAY_ADDRESS_LH      FirstGatewayAddress;
    ULONG                               Ipv4Metric;
    ULONG                               Ipv6Metric;
    IF_LUID                             Luid;
    SOCKET_ADDRESS                      Dhcpv4Server;
    NET_IF_COMPARTMENT_ID               CompartmentId;
    NET_IF_NETWORK_GUID                 NetworkGuid;
    NET_IF_CONNECTION_TYPE              ConnectionType;
    TUNNEL_TYPE                         TunnelType;
    SOCKET_ADDRESS                      Dhcpv6Server;
    BYTE                                Dhcpv6ClientDuid[MAX_DHCPV6_DUID_LENGTH];
    ULONG                               Dhcpv6ClientDuidLength;
    ULONG                               Dhcpv6Iaid;
#if (NTDDI_VERSION >= 0x06000100)
    PIP_ADAPTER_DNS_SUFFIX              FirstDnsSuffix;
#endif
} IP_ADAPTER_ADDRESSES_LH;
typedef IP_ADAPTER_ADDRESSES_LH *PIP_ADAPTER_ADDRESSES_LH;
typedef struct _IP_ADAPTER_ADDRESSES_XP {
    union {
        ULONGLONG   Alignment;
        struct {
            ULONG   Length;
            DWORD   IfIndex;
        };
    };
    struct _IP_ADAPTER_ADDRESSES_XP     *Next;
    PCHAR                               AdapterName;
    PIP_ADAPTER_UNICAST_ADDRESS_XP      FirstUnicastAddress;
    PIP_ADAPTER_ANYCAST_ADDRESS_XP      FirstAnycastAddress;
    PIP_ADAPTER_MULTICAST_ADDRESS_XP    FirstMulticastAddress;
    PIP_ADAPTER_DNS_SERVER_ADDRESS_XP   FirstDnsServerAddress;
    PWCHAR                              DnsSuffix;
    PWCHAR                              Description;
    PWCHAR                              FriendlyName;
    BYTE                                PhysicalAddress[MAX_ADAPTER_ADDRESS_LENGTH];
    DWORD                               PhysicalAddressLength;
    DWORD                               Flags;
    DWORD                               Mtu;
    DWORD                               IfType;
    IF_OPER_STATUS                      OperStatus;
    DWORD                               Ipv6IfIndex;
    DWORD                               ZoneIndices[16];
    PIP_ADAPTER_PREFIX_XP               FirstPrefix;
} IP_ADAPTER_ADDRESSES_XP;
typedef IP_ADAPTER_ADDRESSES_XP *PIP_ADAPTER_ADDRESSES_XP;
#if (NTDDI_VERSION >= 0x06000000)
typedef IP_ADAPTER_ADDRESSES_LH IP_ADAPTER_ADDRESSES;
typedef IP_ADAPTER_ADDRESSES_LH *PIP_ADAPTER_ADDRESSES;
#else
typedef IP_ADAPTER_ADDRESSES_XP IP_ADAPTER_ADDRESSES;
typedef IP_ADAPTER_ADDRESSES_XP *PIP_ADAPTER_ADDRESSES;
#endif
#endif

/* IP per adapter information */
typedef struct _IP_PER_ADAPTER_INFO_W2KSP1 {
    UINT            AutoconfigEnabled;
    UINT            AutoconfigActive;
    PIP_ADDR_STRING CurrentDnsServer;
    IP_ADDR_STRING  DnsServerList;
} IP_PER_ADAPTER_INFO_W2KSP1;
typedef IP_PER_ADAPTER_INFO_W2KSP1  *PIP_PER_ADAPTER_INFO_W2KSP1;
#if (NTDDI_VERSION >= 0x05000100)
typedef IP_PER_ADAPTER_INFO_W2KSP1  IP_PER_ADAPTER_INFO;
typedef IP_PER_ADAPTER_INFO_W2KSP1  *PIP_PER_ADAPTER_INFO;
#endif

/* Fixed information */
typedef struct {
    char            HostName[MAX_HOSTNAME_LEN + 4];
    char            DomainName[MAX_DOMAIN_NAME_LEN + 4];
    PIP_ADDR_STRING CurrentDnsServer;
    IP_ADDR_STRING  DnsServerList;
    UINT            NodeType;
    char            ScopeId[MAX_SCOPE_ID_LEN + 4];
    UINT            EnableRouting;
    UINT            EnableProxy;
    UINT            EnableDns;
} FIXED_INFO_W2KSP1;
typedef FIXED_INFO_W2KSP1   *PFIXED_INFO_W2KSP1;
#if (NTDDI_VERSION >= 0x05000100)
typedef FIXED_INFO_W2KSP1   FIXED_INFO;
typedef FIXED_INFO_W2KSP1   *PFIXED_INFO;
#endif

/* IP interface name information */
typedef struct ip_interface_name_info_w2ksp1 {
    ULONG   Index;
    ULONG   MediaType;
    UCHAR   ConnectionType;
    UCHAR   AccessType;
    GUID    DeviceGuid;
    GUID    InterfaceGuid;
} IP_INTERFACE_NAME_INFO_W2KSP1;
typedef IP_INTERFACE_NAME_INFO_W2KSP1   *PIP_INTERFACE_NAME_INFO_W2KSP1;
#if (NTDDI_VERSION >= 0x05000100)
typedef IP_INTERFACE_NAME_INFO_W2KSP1   IP_INTERFACE_NAME_INFO;
typedef IP_INTERFACE_NAME_INFO_W2KSP1   *PIP_INTERFACE_NAME_INFO;
#endif

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* IP_TYPES_INCLUDED */
