/*
 *  imagehlp.h  Image helper functions
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2014 The Open Watcom Contributors. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */

#ifndef _IMAGEHLP_
#define _IMAGEHLP_

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file;
#endif

#include <wintrust.h>

#ifdef __cplusplus
extern "C" {
#endif

/* Macros to specify image and debug helper functions */
#define IMAGEAPI    DECLSPEC_IMPORT __stdcall
#define DBHLPAPI    IMAGEAPI

/* Digest handle */
typedef PVOID   DIGEST_HANDLE;

/* Image helper context */
typedef VOID    IMAGEHLP_CONTEXT;
typedef VOID    *PIMAGEHLP_CONTEXT;

/* Relative virtual address */
typedef DWORD   RVA;
typedef ULONG64 RVA64;

/* Image separation */
#define IMAGE_SEPARATION    65536

/* Maximum symbol name size */
#define MAX_SYM_NAME    2000

/* BindImageEx() flags */
#define BIND_NO_BOUND_UPDATES   0x00000001L
#define BIND_NO_UPDATE          0x00000002L
#define BIND_ALL_IMAGES         0x00000004L
#define BIND_CACHE_IMPORT_DLLS  0x00000008L
#define BIND_REPORT_64BIT_VA    0x00000010L

/* Checksum return codes */
#define CHECKSUM_SUCCESS            0
#define CHECKSUM_OPEN_FAILURE       1
#define CHECKSUM_MAP_FAILURE        2
#define CHECKSUM_MAPVIEW_FAILURE    3
#define CHECKSUM_UNICODE_FAILURE    4

/* SplitSymbols() flags */
#define SPLITSYM_REMOVE_PRIVATE     0x00000001L
#define SPLITSYM_EXTRACT_ALL        0x00000002L
#define SPLITSYM_SYMBOLPATH_IS_SRC  0x00000004L

/* Image certificate digest flags */
#define CERT_PE_IMAGE_DIGEST_DEBUG_INFO         0x00000001L
#define CERT_PE_IMAGE_DIGEST_RESOURCES          0x00000002L
#define CERT_PE_IMAGE_DIGEST_ALL_IMPORT_INFO    0x00000004L
#define CERT_PE_IMAGE_DIGEST_NON_PE_INFO        0x00000008L

/* Certificate section types */
#define CERT_SECTION_TYPE_ANY   0xFF

/* Debug helper error codes */
#define ERROR_IMAGE_NOT_STRIPPED    0x8800
#define ERROR_NO_DBG_POINTER        0x8801
#define ERROR_NO_PDB_POINTER        0x8802

/* UnDecorateSymbolName() flags */
#define UNDNAME_COMPLETE                0x00000000L
#define UNDNAME_NO_LEADING_UNDERSCORES  0x00000001L
#define UNDNAME_NO_MS_KEYWORDS          0x00000002L
#define UNDNAME_NO_FUNCTION_RETURNS     0x00000004L
#define UNDNAME_NO_ALLOCATION_MODEL     0x00000008L
#define UNDNAME_NO_ALLOCATION_LANGUAGE  0x00000010L
#define UNDNAME_NO_MS_THISTYPE          0x00000020L
#define UNDNAME_NO_CV_THISTYPE          0x00000040L
#define UNDNAME_NO_THISTYPE             0x00000060L
#define UNDNAME_NO_ACCESS_SPECIFIERS    0x00000080L
#define UNDNAME_NO_THROW_SIGNATURES     0x00000100L
#define UNDNAME_NO_MEMBER_TYPE          0x00000200L
#define UNDNAME_NO_RETURN_UDT_MODEL     0x00000400L
#define UNDNAME_32_BIT_DECODE           0x00000800L
#define UNDNAME_NAME_ONLY               0x00001000L
#define UNDNAME_NO_ARGUMENTS            0x00002000L
#define UNDNAME_NO_SPECIAL_SYMS         0x00004000L

/* Module load data types */
#define DBHHEADER_DEBUGDIRS 0x00000001L
#define DBHHEADER_CVMISC    0x00000002L
#define DBHHEADER_PDBGUID   0x00000003L


/* API version number */
#define API_VERSION_NUMBER  11

/* Symbol flags */
#define SYMFLAG_VALUEPRESENT    0x00000001L
#define SYMFLAG_REGISTER        0x00000008L
#define SYMFLAG_REGREL          0x00000010L
#define SYMFLAG_FRAMEREL        0x00000020L
#define SYMFLAG_PARAMETER       0x00000040L
#define SYMFLAG_LOCAL           0x00000080L
#define SYMFLAG_CONSTANT        0x00000100L
#define SYMFLAG_EXPORT          0x00000200L
#define SYMFLAG_FORWARDER       0x00000400L
#define SYMFLAG_FUNCTION        0x00000800L
#define SYMFLAG_VIRTUAL         0x00001000L
#define SYMFLAG_THUNK           0x00002000L
#define SYMFLAG_TLSREL          0x00004000L
#define SYMFLAG_SLOT            0x00008000L
#define SYMFLAG_ILREL           0x00010000L
#define SYMFLAG_METADATA        0x00020000L
#define SYMFLAG_CLR_TOKEN       0x00040000L
#define SYMFLAG_RESET           0x80000000L

/* Callback action codes */
#define CBA_DEFERRED_SYMBOL_LOAD_START      0x00000001L
#define CBA_DEFERRED_SYMBOL_LOAD_COMPLETE   0x00000002L
#define CBA_DEFERRED_SYMBOL_LOAD_FAILURE    0x00000003L
#define CBA_SYMBOLS_UNLOADED                0x00000004L
#define CBA_DUPLICATE_SYMBOL                0x00000005L
#define CBA_READ_MEMORY                     0x00000006L
#define CBA_DEFERRED_SYMBOL_LOAD_CANCEL     0x00000007L
#define CBA_SET_OPTIONS                     0x00000008L
#define CBA_EVENT                           0x00000010L
#define CBA_DEFERRED_SYMBOL_LOAD_PARTIAL    0x00000020L
#define CBA_DEBUG_INFO                      0x10000000L
#define CBA_SRCSRV_INFO                     0x20000000L
#define CBA_SRCSRV_EVENT                    0x40000000L

/* Deferred symbol load flags */
#define DSLFLAG_MISMATCHED_PDB  0x00000001L
#define DSLFLAG_MISMATCHED_DBG  0x00000002L

/* Symbol types */
#define SYMOPT_CASE_INSENSITIVE             0x00000001L
#define SYMOPT_UNDNAME                      0x00000002L
#define SYMOPT_DEFERRED_LOADS               0x00000004L
#define SYMOPT_NO_CPP                       0x00000008L
#define SYMOPT_LOAD_LINES                   0x00000010L
#define SYMOPT_OMAP_FIND_NEAREST            0x00000020L
#define SYMOPT_LOAD_ANYTHING                0x00000040L
#define SYMOPT_IGNORE_CVREC                 0x00000080L
#define SYMOPT_NO_UNQUALIFIED_LOADS         0x00000100L
#define SYMOPT_FAIL_CRITICAL_ERRORS         0x00000200L
#define SYMOPT_EXACT_SYMBOLS                0x00000400L
#define SYMOPT_ALLOW_ABSOLUTE_SYMBOLS       0x00000800L
#define SYMOPT_IGNORE_NT_SYMPATH            0x00001000L
#define SYMOPT_INCLUDE_32BIT_MODULES        0x00002000L
#define SYMOPT_PUBLICS_ONLY                 0x00004000L
#define SYMOPT_NO_PUBLICS                   0x00008000L
#define SYMOPT_AUTO_PUBLICS                 0x00010000L
#define SYMOPT_NO_IMAGE_SEARCH              0x00020000L
#define SYMOPT_SECURE                       0x00040000L
#define SYMOPT_NO_PROMPTS                   0x00080000L
#define SYMOPT_OVERWRITE                    0x00100000L
#define SYMOPT_IGNORE_IMAGEDIR              0x00200000L
#define SYMOPT_FLAT_DIRECTORY               0x00400000L
#define SYMOPT_FAVOR_COMPRESSED             0x00800000L
#define SYMOPT_ALLOW_ZERO_ADDRESS           0x01000000L
#define SYMOPT_DISABLE_SYMSRV_AUTODETECT    0x02000000L
#define SYMOPT_DEBUG                        0x80000000L

/* SymEnumSourceLines() flags */
#define ESLFLAG_FULLPATH    0x00000001L
#define ESLFLAG_NEAREST     0x00000002L
#define ESLFLAG_PREV        0x00000004L
#define ESLFLAG_NEXT        0x00000008L

/* SymLoadModuleEx() flags */
#define SLMFLAG_VIRTUAL     0x00000001L
#define SLMFLAG_ALT_INDEX   0x00000002L
#define SLMFLAG_NO_SYMBOLS  0x00000004L

/* SymSearch() flags */
#define SYMSEARCH_MASKOBJS      0x00000001L
#define SYMSEARCH_RECURSE       0x00000002L
#define SYMSEARCH_GLOBALSONLY   0x00000004L
#define SYMSEARCH_ALLITEMS      0x00000008L

/* SymGetTypeInfo() type identifiers */
#define IMAGEHLP_GET_TYPE_INFO_UNCACHED 0x00000001L
#define IMAGEHLP_GET_TYPE_INFO_CHILDREN 0x00000002L

/* Symbol server version */
#define SYMSRV_VERSION  2

/* Symbol server options */
#define SSRVOPT_CALLBACK            0x00000001L
#define SSRVOPT_DWORD               0x00000002L
#define SSRVOPT_DWORDPTR            0x00000004L
#define SSRVOPT_GUIDPTR             0x00000008L
#define SSRVOPT_OLDGUIDPTR          0x00000010L
#define SSRVOPT_UNATTENDED          0x00000020L
#define SSRVOPT_NOCOPY              0x00000040L
#define SSRVOPT_GETPATH             0x00000040L
#define SSRVOPT_PARENTWIN           0x00000080L
#define SSRVOPT_PARAMTYPE           0x00000100L
#define SSRVOPT_SECURE              0x00000200L
#define SSRVOPT_TRACE               0x00000400L
#define SSRVOPT_SETCONTEXT          0x00000800L
#define SSRVOPT_PROXY               0x00001000L
#define SSRVOPT_DOWNSTREAM_STORE    0x00002000L
#define SSRVOPT_OVERWRITE           0x00004000L
#define SSRVOPT_RESETTOU            0x00008000L
#define SSRVOPT_CALLBACKW           0x00010000L
#define SSRVOPT_FLAT_DEFAULT_STORE  0x00020000L
#define SSRVOPT_PROXYW              0x00040000L
#define SSRVOPT_MESSAGE             0x00080000L
#define SSRVOPT_SERVICE             0x00100000L
#define SSRVOPT_FAVOR_COMPRESSED    0x00200000L
#define SSRVOPT_STRING              0x00400000L
#define SSRVOPT_WINHTTP             0x00800000L
#define SSRVOPT_WININET             0x01000000L
#define SSRVOPT_MAX                 0x01000000L
#define SSRVOPT_RESET               ((ULONG_PTR)-1)
#define NUM_SSRVOPTS                30

/* Symbol server actions */
#define SSRVACTION_TRACE        1
#define SSRVACTION_QUERYCANCEL  2
#define SSRVACTION_EVENT        3
#define SSRVACTION_EVENTW       4
#define SSRVACTION_SIZE         5

/* Symbol store options */
#define SYMSTOREOPT_COMPRESS        0x00000001L
#define SYMSTOREOPT_OVERWRITE       0x00000002L
#define SYMSTOREOPT_RETURNINDEX     0x00000004L
#define SYMSTOREOPT_POINTER         0x00000008L
#define SYMSTOREOPT_ALT_INDEX       0x00000010L
#define SYMSTOREOPT_UNICODE         0x00000020L
#define SYMSTOREOPT_PASS_IF_EXISTS  0x00000040L

/* Old symbol flags */
#define SYMF_OMAP_GENERATED 0x00000001L
#define SYMF_OMAP_MODIFIED  0x00000002L
#define SYMF_REGISTER       0x00000008L
#define SYMF_REGREL         0x00000010L
#define SYMF_FRAMEREL       0x00000020L
#define SYMF_PARAMETER      0x00000040L
#define SYMF_LOCAL          0x00000080L
#define SYMF_CONSTANT       0x00000100L
#define SYMF_EXPORT         0x00000200L
#define SYMF_FORWARDER      0x00000400L
#define SYMF_FUNCTION       0x00000800L
#define SYMF_VIRTUAL        0x00001000L
#define SYMF_THUNK          0x00002000L
#define SYMF_TLSREL         0x00004000L

/* Image helper symbol flags */
#define IMAGEHLP_SYMBOL_INFO_VALUEPRESENT   0x00000001L
#define IMAGEHLP_SYMBOL_INFO_REGISTER       SYMF_REGISTER
#define IMAGEHLP_SYMBOL_INFO_REGRELATIVE    SYMF_REGREL
#define IMAGEHLP_SYMBOL_INFO_FRAMERELATIVE  SYMF_FRAMEREL
#define IMAGEHLP_SYMBOL_INFO_PARAMETER      SYMF_PARAMETER
#define IMAGEHLP_SYMBOL_INFO_LOCAL          SYMF_LOCAL
#define IMAGEHLP_SYMBOL_INFO_CONSTANT       SYMF_CONSTANT
#define IMAGEHLP_SYMBOL_FUNCTION            SYMF_FUNCTION
#define IMAGEHLP_SYMBOL_VIRTUAL             SYMF_VIRTUAL
#define IMAGEHLP_SYMBOL_THUNK               SYMF_THUNK
#define IMAGEHLP_SYMBOL_INFO_TLSRELATIVE    SYMF_TLSREL

/* Minidump signature and version */
#define MINIDUMP_SIGNATURE  'PMDM'
#define MINIDUMP_VERSION    42899

/* Minidump miscellaneous information flags */
#define MINIDUMP_MISC1_PROCESS_ID               0x00000001L
#define MINIDUMP_MISC1_PROCESS_TIMES            0x00000002L
#define MINIDUMP_MISC1_PROCESSOR_POWER_INFO     0x00000004L
#define MINIDUMP_MISC3_PROCESS_INTEGRITY        0x00000010L
#define MINIDUMP_MISC3_PROCESS_EXECUTE_FLAGS    0x00000020L
#define MINIDUMP_MISC3_TIMEZONE                 0x00000040L
#define MINIDUMP_MISC3_PROTECTED_PROCESS        0x00000080L

/* Minidump thread information flags */
#define MINIDUMP_THREAD_INFO_ERROR_THREAD       0x00000001L
#define MINIDUMP_THREAD_INFO_WARNING_THREAD     0x00000002L
#define MINIDUMP_THREAD_INFO_EXITED_THREAD      0x00000004L
#define MINIDUMP_THREAD_INFO_INVALID_INFO       0x00000008L
#define MINIDUMP_THREAD_INFO_INVALID_CONTEXT    0x00000010L
#define MINIDUMP_THREAD_INFO_INVALID_TEB        0x00000020L

/* Loaded image */
typedef struct _LOADED_IMAGE {
    PSTR                    ModuleName;
    HANDLE                  hFile;
    PUCHAR                  MappedAddress;
#ifdef _IMAGEHLP64
    PIMAGE_NT_HEADERS64     FileHeader;
#else
    PIMAGE_NT_HEADERS32     FileHeader;
#endif
    PIMAGE_SECTION_HEADER   LastRvaSection;
    ULONG                   NumberOfSections;
    PIMAGE_SECTION_HEADER   Sections;
    ULONG                   Characteristics;
    BOOLEAN                 fSystemImage;
    BOOLEAN                 fDOSImage;
    BOOLEAN                 fReadOnly;
    UCHAR                   Version;
    LIST_ENTRY              Links;
    ULONG                   SizeOfImage;
} LOADED_IMAGE;
typedef LOADED_IMAGE    *PLOADED_IMAGE;

/* Image helper status reasons */
typedef enum _IMAGEHLP_STATUS_REASON {
    BindOutOfMemory             = 0,
    BindRvaToVaFailed           = 1,
    BindNoRoomInImage           = 2,
    BindImportModuleFailed      = 3,
    BindImportProcedureFailed   = 4,
    BindImportModule            = 5,
    BindImportProcedure         = 6,
    BindForwarder               = 7,
    BindForwarderNOT            = 8,
    BindImageModified           = 9,
    BindExportFileHeaders       = 10,
    BindImageComplete           = 11,
    BindMismatchedSymbols       = 12,
    BindSymbolsNotUpdated       = 13,
    BindImportProcedure32       = 14,
    BindImportProcedure64       = 15,
    BindForwarder32             = 16,
    BindForwarder64             = 17,
    BindForwarderNOT32          = 18,
    BindForwarderNOT64          = 19
} IMAGEHLP_STATUS_REASON;

/* Image helper status routine */
typedef BOOL (__stdcall *PIMAGEHLP_STATUS_ROUTINE)( IMAGEHLP_STATUS_REASON, PCSTR, PCSTR, ULONG_PTR, ULONG_PTR );
typedef BOOL (__stdcall *PIMAGEHLP_STATUS_ROUTINE32)( IMAGEHLP_STATUS_REASON, PCSTR, PCSTR, ULONG, ULONG_PTR );
typedef BOOL (__stdcall *PIMAGEHLP_STATUS_ROUTINE64)( IMAGEHLP_STATUS_REASON, PCSTR, PCSTR, ULONG64, ULONG_PTR );

/* Digest function */
typedef BOOL (WINAPI *DIGEST_FUNCTION)( DIGEST_HANDLE, PBYTE, DWORD );

/* Find file callbacks */
typedef BOOL (CALLBACK *PFIND_DEBUG_FILE_CALLBACK)( HANDLE, PCSTR, PVOID );
typedef BOOL (CALLBACK *PFIND_DEBUG_FILE_CALLBACKW)( HANDLE, PCWSTR, PVOID );
typedef BOOL (CALLBACK *PFINDFILEINPATHCALLBACK)( PCSTR, PVOID );
typedef BOOL (CALLBACK *PFINDFILEINPATHCALLBACKW)( PCWSTR, PVOID );
typedef BOOL (CALLBACK *PFIND_EXE_FILE_CALLBACK)( HANDLE, PCSTR, PVOID );
typedef BOOL (CALLBACK *PFIND_EXE_FILE_CALLBACKW)( HANDLE, PCWSTR, PVOID );
typedef BOOL (CALLBACK *PENUMDIRTREE_CALLBACK)( PCSTR, PVOID );
typedef BOOL (CALLBACK *PENUMDIRTREE_CALLBACKW)( PCWSTR, PVOID );

/* Address/RVA conversion macro */
#define RVA_TO_ADDR( p1, p2 )   ((PVOID)(((ULONG_PTR)(p1)) + (p2)))

/* Image debug information */
typedef struct _IMAGE_DEBUG_INFORMATION {
    LIST_ENTRY                  List;
    DWORD                       ReservedSize;
    PVOID                       ReservedMappedBase;
    USHORT                      ReservedMachine;
    USHORT                      ReservedCharacteristics;
    DWORD                       ReservedCheckSum;
    DWORD                       ImageBase;
    DWORD                       SizeOfImage;
    DWORD                       ReservedNumberOfSections;
    PIMAGE_SECTION_HEADER       ReservedSections;
    DWORD                       ReservedExportedNamesSize;
    PSTR                        ReservedExportedNames;
    DWORD                       ReservedNumberOfFunctionTableEntries;
    PIMAGE_FUNCTION_ENTRY       ReservedFunctionTableEntries;
    DWORD                       ReservedLowestFunctionStartingAddress;
    DWORD                       ReservedHighestFunctionStartingAddress;
    DWORD                       ReservedNumberOfFpoTableEntries;
    PFPO_DATA                   ReservedFpoTableEntries;
    DWORD                       SizeOfCoffSymbols;
    PIMAGE_COFF_SYMBOLS_HEADER  CoffSymbols;
    DWORD                       ReservedSizeOfCodeViewSymbols;
    PVOID                       ReservedCodeViewSymbols;
    PSTR                        ImageFilePath;
    PSTR                        ImageFileName;
    PSTR                        ReservedDebugFilePath;
    DWORD                       ReservedTimeDateStamp;
    BOOL                        ReservedRomImage;
    PIMAGE_DEBUG_DIRECTORY      ReservedDebugDirectory;
    DWORD                       ReservedNumberOfDebugDirectories;
    DWORD                       ReservedOriginalFunctionTableBaseAddress;
    DWORD                       Reserved[2];
} IMAGE_DEBUG_INFORMATION;
typedef IMAGE_DEBUG_INFORMATION *PIMAGE_DEBUG_INFORMATION;

/* Module load data */
typedef struct _MODLOAD_DATA {
    DWORD   ssize;
    DWORD   ssig;
    PVOID   data;
    DWORD   size;
    DWORD   flags;
} MODLOAD_DATA;
typedef MODLOAD_DATA    *PMODLOAD_DATA;

/* Module load CodeView miscellaneous data */
typedef struct _MODLOAD_CVMISC {
    DWORD   oCV;
    size_t  cCV;
    DWORD   oMisc;
    size_t  cMisc;
    DWORD   dtImage;
    DWORD   cImage;
} MODLOAD_CVMISC;
typedef MODLOAD_CVMISC  *PMODLOAD_CVMISC;

/* Module load PDB GUID data */
typedef struct _MODLOAD_PDBGUID_PDBAGE {
    GUID    PdbGuid;
    DWORD   PdbAge;
} MODLOAD_PDBGUID_PDBAGE;
typedef MODLOAD_PDBGUID_PDBAGE  *PMODLOAD_PDBGUID_PDBAGE;

/* Address modes */
typedef enum {
    AddrMode1616    = 0,
    AddrMode1632    = 1,
    AddrModeReal    = 2,
    AddrModeFlat    = 3
} ADDRESS_MODE;

/* Address (64-bit version) */
typedef struct _tagADDRESS64 {
    DWORD64         Offset;
    WORD            Segment;
    ADDRESS_MODE    Mode;
} ADDRESS64;
typedef ADDRESS64   *LPADDRESS64;

/* Address */
#ifdef _IMAGEHLP64
typedef ADDRESS64   ADDRESS;
typedef LPADDRESS64 LPADDRESS;
#else
typedef struct _tagADDRESS {
    DWORD           Offset;
    WORD            Segment;
    ADDRESS_MODE    Mode;
} ADDRESS;
typedef ADDRESS     *LPADDRESS;
#endif

/* Kernel debugger help (64-bit version) */
typedef struct _KDHELP64 {
    DWORD64 Thread;
    DWORD   ThCallbackStack;
    DWORD   ThCallbackBStore;
    DWORD   NextCallback;
    DWORD   FramePointer;
    DWORD64 KiCallUserMode;
    DWORD64 KeUserCallbackDispatcher;
    DWORD64 SystemRangeStart;
    DWORD64 KiUserExceptionDispatcher;
    DWORD64 StackBase;
    DWORD64 StackLimit;
    DWORD64 Reserved[5];
} KDHELP64;
typedef KDHELP64    *PKDHELP64;

/* Kernel debugger help */
#ifdef _IMAGEHLP64
typedef KDHELP64    KDHELP;
typedef PKDHELP64   PKDHELP;
#else
typedef struct _KDHELP {
    DWORD   Thread;
    DWORD   ThCallbackStack;
    DWORD   NextCallback;
    DWORD   FramePointer;
    DWORD   KiCallUserMode;
    DWORD   KeUserCallbackDispatcher;
    DWORD   SystemRangeStart;
    DWORD   ThCallbackBStore;
    DWORD   KiUserExceptionDispatcher;
    DWORD   StackBase;
    DWORD   StackLimit;
    DWORD   Reserved[5];
} KDHELP;
typedef KDHELP      *PKDHELP;
#endif

/* Stack frame (64-bit version) */
typedef struct _tagSTACKFRAME64 {
    ADDRESS64   AddrPC;
    ADDRESS64   AddrReturn;
    ADDRESS64   AddrFrame;
    ADDRESS64   AddrStack;
    ADDRESS64   AddrBStore;
    PVOID       FuncTableEntry;
    DWORD64     Params[4];
    BOOL        Far;
    BOOL        Virtual;
    DWORD64     Reserved[3];
    KDHELP64    KdHelp;
} STACKFRAME64;
typedef STACKFRAME64    *LPSTACKFRAME64;

/* Stack frame */
#ifdef _IMAGEHLP64
typedef STACKFRAME64    STACKFRAME;
typedef LPSTACKFRAME64  LPSTACKFRAME;
#else
typedef struct _tagSTACKFRAME {
    ADDRESS AddrPC;
    ADDRESS AddrReturn;
    ADDRESS AddrFrame;
    ADDRESS AddrStack;
    PVOID   FuncTableEntry;
    DWORD   Params[4];
    BOOL    Far;
    BOOL    Virtual;
    DWORD   Reserved[3];
    KDHELP  KdHelp;
    ADDRESS AddrBStore;
} STACKFRAME;
typedef STACKFRAME      *LPSTACKFRAME;
#endif

/* Stack walking routines (64-bit versions) */
typedef BOOL (__stdcall *PREAD_PROCESS_MEMORY_ROUTINE64)( HANDLE, DWORD64, PVOID, DWORD, LPDWORD );
typedef PVOID (__stdcall *PFUNCTION_TABLE_ACCESS_ROUTINE64)( HANDLE, DWORD64 );
typedef DWORD64 (__stdcall *PGET_MODULE_BASE_ROUTINE64)( HANDLE, DWORD64 );
typedef DWORD64 (__stdcall *PTRANSLATE_ADDRESS_ROUTINE64)( HANDLE, HANDLE, LPADDRESS64 );
#ifdef _IMAGEHLP64
typedef PREAD_PROCESS_MEMORY_ROUTINE64      PREAD_PROCESS_MEMORY_ROUTINE;
typedef PFUNCTION_TABLE_ACCESS_ROUTINE64    PFUNCTION_TABLE_ACCESS_ROUTINE;
typedef PGET_MODULE_BASE_ROUTINE64          PGET_MODULE_BASE_ROUTINE;
typedef PTRANSLATE_ADDRESS_ROUTINE64        PTRANSLATE_ADDRESS_ROUTINE;
#else
typedef BOOL (__stdcall *PREAD_PROCESS_MEMORY_ROUTINE)( HANDLE, DWORD, PVOID, DWORD, PDWORD );
typedef PVOID (__stdcall *PFUNCTION_TABLE_ACCESS_ROUTINE)( HANDLE, DWORD );
typedef DWORD (__stdcall *PGET_MODULE_BASE_ROUTINE)( HANDLE, DWORD );
typedef DWORD (__stdcall *PTRANSLATE_ADDRESS_ROUTINE)( HANDLE, HANDLE, LPADDRESS );
#endif

/* API version */
typedef struct API_VERSION {
    USHORT  MajorVersion;
    USHORT  MinorVersion;
    USHORT  Revision;
    USHORT  Reserved;
} API_VERSION;
typedef API_VERSION *LPAPI_VERSION;

/* Symbol callbacks */
typedef BOOL (CALLBACK *PSYM_ENUMMODULES_CALLBACK64)( PCSTR, DWORD64, PVOID );
typedef BOOL (CALLBACK *PSYM_ENUMMODULES_CALLBACKW64)( PCWSTR, DWORD64, PVOID );
typedef BOOL (CALLBACK *PENUMLOADED_MODULES_CALLBACK64)( PCSTR, DWORD64, ULONG, PVOID );
typedef BOOL (CALLBACK *PENUMLOADED_MODULES_CALLBACKW64)( PCWSTR, DWORD64, ULONG, PVOID );
typedef BOOL (CALLBACK *PSYM_ENUMSYMBOLS_CALLBACK64)( PCSTR, DWORD64, ULONG, PVOID );
typedef BOOL (CALLBACK *PSYM_ENUMSYMBOLS_CALLBACK64W)( PCWSTR, DWORD64, ULONG, PVOID );
typedef BOOL (CALLBACK *PSYMBOL_REGISTERED_CALLBACK64)( HANDLE, ULONG, ULONG64, ULONG64 );
typedef PVOID (CALLBACK *PSYMBOL_FUNCENTRY_CALLBACK64)( HANDLE, ULONG64, ULONG64 );
#ifdef _IMAGEHLP64
typedef PSYM_ENUMMODULES_CALLBACK64     PSYM_ENUMMODULES_CALLBACK;
typedef PSYM_ENUMSYMBOLS_CALLBACK64     PSYM_ENUMSYMBOLS_CALLBACK;
typedef PSYM_ENUMSYMBOLS_CALLBACK64W    PSYM_ENUMSYMBOLS_CALLBACKW;
typedef PENUMLOADED_MODULES_CALLBACK64  PENUMLOADED_MODULES_CALLBACK;
typedef PSYMBOL_REGISTERED_CALLBACK64   PSYMBOL_REGISTERED_CALLBACK;
typedef PSYMBOL_FUNCENTRY_CALLBACK64    PSYMBOL_FUNCENTRY_CALLBACK;
#else
typedef BOOL (CALLBACK *PSYM_ENUMMODULES_CALLBACK)( PCSTR, ULONG, PVOID );
typedef BOOL (CALLBACK *PSYM_ENUMSYMBOLS_CALLBACK)( PCSTR, ULONG, ULONG, PVOID );
typedef BOOL (CALLBACK *PSYM_ENUMSYMBOLS_CALLBACKW)( PCWSTR, ULONG, ULONG, PVOID );
typedef BOOL (CALLBACK *PENUMLOADED_MODULES_CALLBACK)( PCSTR, ULONG, ULONG, PVOID );
typedef BOOL (CALLBACK *PSYMBOL_REGISTERED_CALLBACK)( HANDLE, ULONG, PVOID, PVOID );
typedef PVOID (CALLBACK *PSYMBOL_FUNCENTRY_CALLBACK)( HANDLE, DWORD, PVOID );
#endif

/* Symbol types */
typedef enum {
    SymNone     = 0,
    SymCoff     = 1,
    SymCv       = 2,
    SymPdb      = 3,
    SymExport   = 4,
    SymDeferred = 5,
    SymSym      = 6,
    SymDia      = 7,
    SymVirtual  = 8,
    NumSymTypes = 9,
} SYM_TYPE;

/* Image helper symbol (64-bit version) */
typedef struct _IMAGEHLP_SYMBOL64 {
    DWORD   SizeOfStruct;
    DWORD64 Address;
    DWORD   Size;
    DWORD   Flags;
    DWORD   MaxNameLength;
    CHAR    Name[1];
} IMAGEHLP_SYMBOL64;
typedef IMAGEHLP_SYMBOL64   *PIMAGEHLP_SYMBOL64;

/* Image helper symbol package (64-bit version) */
typedef struct _IMAGEHLP_SYMBOL64_PACKAGE {
    IMAGEHLP_SYMBOL64   sym;
    CHAR                name[MAX_SYM_NAME + 1];
} IMAGEHLP_SYMBOL64_PACKAGE;
typedef IMAGEHLP_SYMBOL64_PACKAGE   *PIMAGEHLP_SYMBOL64_PACKAGE;

/* Unicode image helper symbol (64-bit version) */
typedef struct _IMAGEHLP_SYMBOLW64 {
    DWORD   SizeOfStruct;
    DWORD64 Address;
    DWORD   Size;
    DWORD   Flags;
    DWORD   MaxNameLength;
    WCHAR   Name[1];
} IMAGEHLP_SYMBOLW64;
typedef IMAGEHLP_SYMBOLW64  *PIMAGEHLP_SYMBOLW64;

/* Unicode image helper symbol package (64-bit version) */
typedef struct _IMAGEHLP_SYMBOLW64_PACKAGE {
    IMAGEHLP_SYMBOLW64  sym;
    WCHAR               name[MAX_SYM_NAME + 1];
} IMAGEHLP_SYMBOLW64_PACKAGE;
typedef IMAGEHLP_SYMBOLW64_PACKAGE  *PIMAGEHLP_SYMBOLW64_PACKAGE;

/* Image helper symbol */
#ifdef _IMAGEHLP64
typedef IMAGEHLP_SYMBOL64   IMAGEHLP_SYMBOL;
typedef PIMAGEHLP_SYMBOL64  PIMAGEHLP_SYMBOL;
#else
typedef struct _IMAGEHLP_SYMBOL {
    DWORD   SizeOfStruct;
    DWORD   Address;
    DWORD   Size;
    DWORD   Flags;
    DWORD   MaxNameLength;
    CHAR    Name[1];
} IMAGEHLP_SYMBOL;
typedef IMAGEHLP_SYMBOL     *PIMAGEHLP_SYMBOL;
#endif

/* Image helper symbol package */
#ifdef _IMAGEHLP64
typedef IMAGEHLP_SYMBOL64_PACKAGE   IMAGEHLP_SYMBOL_PACKAGE;
typedef PIMAGEHLP_SYMBOL64_PACKAGE  PIMAGEHLP_SYMBOL_PACKAGE;
#else
typedef struct _IMAGEHLP_SYMBOL_PACKAGE {
    IMAGEHLP_SYMBOL sym;
    CHAR            name[MAX_SYM_NAME + 1];
} IMAGEHLP_SYMBOL_PACKAGE;
typedef IMAGEHLP_SYMBOL_PACKAGE *PIMAGEHLP_SYMBOL_PACKAGE;
#endif

/* Unicode image helper symbol */
#ifdef _IMAGEHLP64
typedef IMAGEHLP_SYMBOLW64  IMAGEHLP_SYMBOLW;
typedef PIMAGEHLP_SYMBOLW64 PIMAGEHLP_SYMBOLW;
#else
typedef struct _IMAGEHLP_SYMBOLW {
    DWORD   SizeOfStruct;
    DWORD   Address;
    DWORD   Size;
    DWORD   Flags;
    DWORD   MaxNameLength;
    WCHAR   Name[1];
} IMAGEHLP_SYMBOLW;
typedef IMAGEHLP_SYMBOLW    *PIMAGEHLP_SYMBOLW;
#endif

/* Unicode image helper symbol package */
#ifdef _IMAGEHLP64
typedef IMAGEHLP_SYMBOLW64_PACKAGE  IMAGEHLP_SYMBOLW_PACKAGE;
typedef PIMAGEHLP_SYMBOLW64_PACKAGE PIMAGEHLP_SYMBOLW_PACKAGE;
#else
typedef struct _IMAGEHLP_SYMBOLW_PACKAGE {
    IMAGEHLP_SYMBOLW    sym;
    WCHAR               name[MAX_SYM_NAME + 1];
} IMAGEHLP_SYMBOLW_PACKAGE;
typedef IMAGEHLP_SYMBOLW_PACKAGE    *PIMAGEHLP_SYMBOLW_PACKAGE;
#endif

/* Image helper module (64-bit version) */
typedef struct _IMAGEHLP_MODULE64 {
    DWORD       SizeOfStruct;
    DWORD64     BaseOfImage;
    DWORD       ImageSize;
    DWORD       TimeDateStamp;
    DWORD       CheckSum;
    DWORD       NumSyms;
    SYM_TYPE    SymType;
    CHAR        ModuleName[32];
    CHAR        ImageName[256];
    CHAR        LoadedImageName[256];
    CHAR        LoadedPdbName[256];
    DWORD       CVSig;
    CHAR        CVData[MAX_PATH * 3];
    DWORD       PdbSig;
    GUID        PdbSig70;
    DWORD       PdbAge;
    BOOL        PdbUnmatched;
    BOOL        DbgUnmatched;
    BOOL        LineNumbers;
    BOOL        GlobalSymbols;
    BOOL        TypeInfo;
    BOOL        SourceIndexed;
    BOOL        Publics;
} IMAGEHLP_MODULE64;
typedef IMAGEHLP_MODULE64   *PIMAGEHLP_MODULE64;

/* Unicode image helper module (64-bit version) */
typedef struct _IMAGEHLP_MODULEW64 {
    DWORD       SizeOfStruct;
    DWORD64     BaseOfImage;
    DWORD       ImageSize;
    DWORD       TimeDateStamp;
    DWORD       CheckSum;
    DWORD       NumSyms;
    SYM_TYPE    SymType;
    WCHAR       ModuleName[32];
    WCHAR       ImageName[256];
    WCHAR       LoadedImageName[256];
    WCHAR       LoadedPdbName[256];
    DWORD       CVSig;
    WCHAR       CVData[MAX_PATH * 3];
    DWORD       PdbSig;
    GUID        PdbSig70;
    DWORD       PdbAge;
    BOOL        PdbUnmatched;
    BOOL        DbgUnmatched;
    BOOL        LineNumbers;
    BOOL        GlobalSymbols;
    BOOL        TypeInfo;
    BOOL        SourceIndexed;
    BOOL        Publics;
} IMAGEHLP_MODULEW64;
typedef IMAGEHLP_MODULEW64  *PIMAGEHLP_MODULEW64;

/* Image helper module */
#ifdef _IMAGEHLP64
typedef IMAGEHLP_MODULE64   IMAGEHLP_MODULE;
typedef PIMAGEHLP_MODULE64  PIMAGEHLP_MODULE;
#else
typedef struct _IMAGEHLP_MODULE {
    DWORD       SizeOfStruct;
    DWORD       BaseOfImage;
    DWORD       ImageSize;
    DWORD       TimeDateStamp;
    DWORD       CheckSum;
    DWORD       NumSyms;
    SYM_TYPE    SymType;
    CHAR        ModuleName[32];
    CHAR        ImageName[256];
    CHAR        LoadedImageName[256];
} IMAGEHLP_MODULE;
typedef IMAGEHLP_MODULE     *PIMAGEHLP_MODULE;
#endif

/* Unicode image helper module */
#ifdef _IMAGEHLP64
typedef IMAGEHLP_MODULEW64  IMAGEHLP_MODULEW;
typedef PIMAGEHLP_MODULEW64 PIMAGEHLP_MODULEW;
#else
typedef struct _IMAGEHLP_MODULEW {
    DWORD       SizeOfStruct;
    DWORD       BaseOfImage;
    DWORD       ImageSize;
    DWORD       TimeDateStamp;
    DWORD       CheckSum;
    DWORD       NumSyms;
    SYM_TYPE    SymType;
    WCHAR       ModuleName[32];
    WCHAR       ImageName[256];
    WCHAR       LoadedImageName[256];
} IMAGEHLP_MODULEW;
typedef IMAGEHLP_MODULEW    *PIMAGEHLP_MODULEW;
#endif

/* Image helper line (64-bit version) */
typedef struct _IMAGEHLP_LINE64 {
    DWORD   SizeOfStruct;
    PVOID   Key;
    DWORD   LineNumber;
    PCHAR   FileName;
    DWORD64 Address;
} IMAGEHLP_LINE64;
typedef IMAGEHLP_LINE64 *PIMAGEHLP_LINE64;

/* Unicode image helper line (64-bit version) */
typedef struct _IMAGEHLP_LINEW64 {
    DWORD   SizeOfStruct;
    PVOID   Key;
    DWORD   LineNumber;
    PWSTR   FileName;
    DWORD64 Address;
} IMAGEHLP_LINEW64;
typedef IMAGEHLP_LINEW64    *PIMAGEHLP_LINEW64;

/* Image helper line */
#ifdef _IMAGEHLP64
typedef IMAGEHLP_LINE64     IMAGEHLP_LINE;
typedef PIMAGEHLP_LINE64    PIMAGEHLP_LINE;
#else
typedef struct _IMAGEHLP_LINE {
    DWORD   SizeOfStruct;
    PVOID   Key;
    DWORD   LineNumber;
    PCHAR   FileName;
    DWORD   Address;
} IMAGEHLP_LINE;
typedef IMAGEHLP_LINE       *PIMAGEHLP_LINE;
#endif

/* Unicode image helper line */
#ifdef _IMAGEHLP64
typedef IMAGEHLP_LINEW64    IMAGEHLP_LINEW;
typedef PIMAGEHLP_LINEW64   PIMAGEHLP_LINEW;
#else
typedef struct _IMAGEHLP_LINEW {
    DWORD   SizeOfStruct;
    PVOID   Key;
    DWORD   LineNumber;
    PCHAR   FileName;
    DWORD64 Address;
} IMAGEHLP_LINEW;
typedef IMAGEHLP_LINEW      *PIMAGEHLP_LINEW;
#endif

/* Source file */
typedef struct _SOURCEFILE {
    DWORD64 ModBase;
    PCHAR   FileName;
} SOURCEFILE;
typedef SOURCEFILE  *PSOURCEFILE;

/* Unicode source file */
typedef struct _SOURCEFILEW {
    DWORD64 ModBase;
    PWSTR   FileName;
} SOURCEFILEW;
typedef SOURCEFILEW *PSOURCEFILEW;

/* CBA_READ_MEMORY parameters */
typedef struct _IMAGEHLP_CBA_READ_MEMORY {
    DWORD64 addr;
    PVOID   buf;
    DWORD   bytes;
    DWORD   *bytesread;
} IMAGEHLP_CBA_READ_MEMORY;
typedef IMAGEHLP_CBA_READ_MEMORY    *PIMAGEHLP_CBA_READ_MEMORY;

/* Severities */
enum {
    sevInfo     = 0,
    sevProblem  = 1,
    sevAttn     = 2,
    sevFatal    = 3,
    sevMax      = 4
};

/* CBA_EVENT parameters */
typedef struct _IMAGEHLP_CBA_EVENT {
    DWORD   severity;
    DWORD   code;
    PCHAR   desc;
    PVOID   object;
} IMAGEHLP_CBA_EVENT;
typedef IMAGEHLP_CBA_EVENT  *PIMAGEHLP_CBA_EVENT;

/* Unicode CBA_EVENT parameters */
typedef struct _IMAGEHLP_CBA_EVENTW {
    DWORD   severity;
    DWORD   code;
    PCWSTR  desc;
    PVOID   object;
} IMAGEHLP_CBA_EVENTW;
typedef IMAGEHLP_CBA_EVENTW *PIMAGEHLP_CBA_EVENTW;

/* Image helper deferred symbol load (64-bit version) */
typedef struct _IMAGEHLP_DEFERRED_SYMBOL_LOAD64 {
    DWORD   SizeOfStruct;
    DWORD64 BaseOfImage;
    DWORD   CheckSum;
    DWORD   TimeDateStamp;
    CHAR    FileName[MAX_PATH];
    BOOLEAN Reparse;
    HANDLE  hFile;
    DWORD   Flags;
} IMAGEHLP_DEFERRED_SYMBOL_LOAD64;
typedef IMAGEHLP_DEFERRED_SYMBOL_LOAD64 *PIMAGEHLP_DEFERRED_SYMBOL_LOAD64;

/* Unicode image helper deferred symbol load (64-bit version) */
typedef struct _IMAGEHLP_DEFERRED_SYMBOL_LOADW64 {
    DWORD   SizeOfStruct;
    DWORD64 BaseOfImage;
    DWORD   CheckSum;
    DWORD   TimeDateStamp;
    WCHAR   FileName[MAX_PATH + 1];
    BOOLEAN Reparse;
    HANDLE  hFile;
    DWORD   Flags;
} IMAGEHLP_DEFERRED_SYMBOL_LOADW64;
typedef IMAGEHLP_DEFERRED_SYMBOL_LOADW64    *PIMAGEHLP_DEFERRED_SYMBOL_LOADW64;

/* Image helper deferred symbol load */
#ifdef _IMAGEHLP64
typedef IMAGEHLP_DEFERRED_SYMBOL_LOAD64     IMAGEHLP_DEFERRED_SYMBOL_LOAD;
typedef PIMAGEHLP_DEFERRED_SYMBOL_LOAD64    PIMAGEHLP_DEFERRED_SYMBOL_LOAD;
#else
typedef struct _IMAGEHLP_DEFERRED_SYMBOL_LOAD {
    DWORD   SizeOfStruct;
    DWORD   BaseOfImage;
    DWORD   CheckSum;
    DWORD   TimeDateStamp;
    CHAR    FileName[MAX_PATH];
    BOOLEAN Reparse;
    HANDLE  hFile;
} IMAGEHLP_DEFERRED_SYMBOL_LOAD;
typedef IMAGEHLP_DEFERRED_SYMBOL_LOAD       *PIMAGEHLP_DEFERED_SYMBOL_LOAD;
#endif

/* Image helper duplicate symbol (64-bit version) */
typedef struct _IMAGEHLP_DUPLICATE_SYMBOL64 {
    DWORD               SizeOfStruct;
    DWORD               NumberOfDups;
    PIMAGEHLP_SYMBOL64  Symbol;
    DWORD               SelectedSymbol;
} IMAGEHLP_DUPLICATE_SYMBOL64;
typedef IMAGEHLP_DUPLICATE_SYMBOL64 *PIMAGEHLP_DUPLICATE_SYMBOL64;

/* Image helper duplicate symbol */
#ifdef _IMAGEHLP64
typedef IMAGEHLP_DUPLICATE_SYMBOL64     IMAGEHLP_DUPLICATE_SYMBOL;
typedef PIMAGEHLP_DUPLICATE_SYMBOL64    PIMAGEHLP_DUPLICATE_SYMBOL;
#else
typedef struct _IMAGEHLP_DUPLICATE_SYMBOL {
    DWORD               SizeOfStruct;
    DWORD               NumberOfDups;
    PIMAGEHLP_SYMBOL    Symbol;
    DWORD               SelectedSymbol;
} IMAGEHLP_DUPLICATE_SYMBOL;
typedef IMAGEHLP_DUPLICATE_SYMBOL   *PIMAGEHLP_DUPLICATE_SYMBOL;
#endif

/* Home directory types */
enum {
    hdBase  = 0,
    hdSym   = 1,
    hdSrc   = 2,
    hdMax   = 3
};

/* Address map entry */
typedef struct _OMAP {
    ULONG   rva;
    ULONG   rvaTo;
} OMAP;
typedef OMAP    *POMAP;

/* Source code information */
typedef struct _SRCCODEINFO {
    DWORD   SizeOfStruct;
    PVOID   Key;
    DWORD64 ModBase;
    CHAR    Obj[MAX_PATH + 1];
    CHAR    FileName[MAX_PATH + 1];
    DWORD   LineNumber;
    DWORD64 Address;
} SRCCODEINFO;
typedef SRCCODEINFO *PSRCCODEINFO;

/* Unicode source code information */
typedef struct _SRCCODEINFOW {
    DWORD   SizeOfStruct;
    PVOID   Key;
    DWORD64 ModBase;
    WCHAR   Obj[MAX_PATH + 1];
    WCHAR   FileName[MAX_PATH + 1];
    DWORD   LineNumber;
    DWORD64 Address;
} SRCCODEINFOW;
typedef SRCCODEINFOW    *PSRCCODEINFOW;

/* Additional symbol callbacks */
typedef BOOL (CALLBACK *PSYM_ENUMSOURCEFILES_CALLBACK)( PSOURCEFILE, PVOID );
typedef BOOL (CALLBACK *PSYM_ENUMSOURCEFILES_CALLBACKW)( PSOURCEFILEW, PVOID );
typedef BOOL (CALLBACK *PSYM_ENUMLINES_CALLBACK)( PSRCCODEINFO, PVOID );
typedef BOOL (CALLBACK *PSYM_ENUMLINES_CALLBACKW)( PSRCCODEINFOW, PVOID );
typedef BOOL (CALLBACK *PSYM_ENUMPROCESSES_CALLBACK)( HANDLE, PVOID );
typedef BOOL (CALLBACK *PENUMSOURCEFILETOKENSCALLBACK)( PVOID, size_t );
typedef PSYM_ENUMSOURCEFILES_CALLBACK   PSYM_ENUMSOURCFILES_CALLBACK;

/* Image helper symbol source */
typedef struct _IMAGEHLP_SYMBOL_SRC {
    DWORD   sizeofstruct;
    DWORD   type;
    char    file[MAX_PATH];
} IMAGEHLP_SYMBOL_SRC;
typedef IMAGEHLP_SYMBOL_SRC *PIMAGEHLP_SYMBOL_SRC;

/* Module type information */
typedef struct _MODULE_TYPE_INFO {
    USHORT  dataLength;
    USHORT  leaf;
    BYTE    data[1];
} MODULE_TYPE_INFO;
typedef MODULE_TYPE_INFO    *PMODULE_TYPE_INFO;

/* Symbol information */
typedef struct _SYMBOL_INFO {
    ULONG   SizeOfStruct;
    ULONG   TypeIndex;
    ULONG64 Reserved[2];
    ULONG   Index;
    ULONG   Size;
    ULONG64 ModBase;
    ULONG   Flags;
    ULONG64 Value;
    ULONG64 Address;
    ULONG   Register;
    ULONG   Scope;
    ULONG   Tag;
    ULONG   NameLen;
    ULONG   MaxNameLen;
    CHAR    Name[1];
} SYMBOL_INFO;
typedef SYMBOL_INFO *PSYMBOL_INFO;

/* Symbol information package */
typedef struct _SYMBOL_INFO_PACKAGE {
    SYMBOL_INFO si;
    CHAR        name[MAX_SYM_NAME + 1];
} SYMBOL_INFO_PACKAGE;
typedef SYMBOL_INFO_PACKAGE *PSYMBOL_INFO_PACKAGE;

/* Unicode symbol information */
typedef struct _SYMBOL_INFOW {
    ULONG   SizeOfStruct;
    ULONG   TypeIndex;
    ULONG64 Reserved[2];
    ULONG   Index;
    ULONG   Size;
    ULONG64 ModBase;
    ULONG   Flags;
    ULONG64 Value;
    ULONG64 Address;
    ULONG   Register;
    ULONG   Scope;
    ULONG   Tag;
    ULONG   NameLen;
    ULONG   MaxNameLen;
    WCHAR   Name[1];
} SYMBOL_INFOW;
typedef SYMBOL_INFOW    *PSYMBOL_INFOW;

/* Unicode symbol information package */
typedef struct _SYMBOL_INFO_PACKAGEW {
    SYMBOL_INFOW    si;
    WCHAR           name[MAX_SYM_NAME + 1];
} SYMBOL_INFO_PACKAGEW;
typedef SYMBOL_INFO_PACKAGEW    *PSYMBOL_INFO_PACKAGEW;

/* Image helper stack frame */
typedef struct _IMAGEHLP_STACK_FRAME {
    ULONG64 InstructionOffset;
    ULONG64 ReturnOffset;
    ULONG64 FrameOffset;
    ULONG64 StackOffset;
    ULONG64 BackingStoreOffset;
    ULONG64 FuncTableEntry;
    ULONG64 Params[4];
    ULONG64 Reserved[5];
    BOOL    Virtual;
    ULONG   Reserved2;
} IMAGEHLP_STACK_FRAME;
typedef IMAGEHLP_STACK_FRAME    *PIMAGEHLP_STACK_FRAME;

/* Symbol enumeration callback */
typedef BOOL (CALLBACK *PSYM_ENUMERATESYMBOLS_CALLBACK)( PSYMBOL_INFO, ULONG, PVOID );
typedef BOOL (CALLBACK *PSYM_ENUMERATESYMBOLS_CALLBACKW)( PSYMBOL_INFOW, ULONG, PVOID );

/* Image helper symbol type information */
typedef enum _IMAGEHLP_SYMBOL_TYPE_INFO {
    TI_GET_SYMTAG                   = 0,
    TI_GET_SYMNAME                  = 1,
    TI_GET_LENGTH                   = 2,
    TI_GET_TYPE                     = 3,
    TI_GET_TYPEID                   = 4,
    TI_GET_BASETYPE                 = 5,
    TI_GET_ARRAYINDEXTYPEID         = 6,
    TI_FINDCHILDREN                 = 7,
    TI_GET_DATAKIND                 = 8,
    TI_GET_ADDRESSOFFSET            = 9,
    TI_GET_OFFSET                   = 10,
    TI_GET_VALUE                    = 11,
    TI_GET_COUNT                    = 12,
    TI_GET_CHILDRENCOUNT            = 13,
    TI_GET_BITPOSITION              = 14,
    TI_GET_VIRTUALBASECLASS         = 15,
    TI_GET_VIRTUALTABLESHAPEID      = 16,
    TI_GET_VIRTUALBASEPOINTEROFFSET = 17,
    TI_GET_CLASSPARENTID            = 18,
    TI_GET_NESTED                   = 19,
    TI_GET_SYMINDEX                 = 20,
    TI_GET_LEXICALPARENT            = 21,
    TI_GET_ADDRESS                  = 22,
    TI_GET_THISADJUST               = 23,
    TI_GET_UDTKIND                  = 24,
    TI_IS_EQUIV_TO                  = 25,
    TI_GET_CALLING_CONVENTION       = 26,
    TI_IS_CLOSE_EQUIV_TO            = 27,
    TI_GTIEX_REQS_VALID             = 28,
    TI_GET_VIRTUALBASEOFFSET        = 29,
    TI_GET_VIRTUALBASEDISPINDEX     = 30,
    TI_GET_IS_REFERENCE             = 31,
    TI_GET_INDIRECTVIRTUALBASECLASS = 32,
    IMAGEHLP_SYMBOL_TYPE_INFO_MAX   = 33
} IMAGEHLP_SYMBOL_TYPE_INFO;

/* TI_FINDCHILDREN parameters */
typedef struct _TI_FINDCHILDREN_PARAMS {
    ULONG   Count;
    ULONG   Start;
    ULONG   ChildId[1];
} TI_FINDCHILDREN_PARAMS;

/* SymGetTypeInfoEx() parameters */
typedef struct _IMAGEHLP_GET_TYPE_INFO_PARAMS {
    ULONG                       SizeOfStruct;
    ULONG                       Flags;
    ULONG                       NumIds;
    PULONG                      TypeIds;
    ULONG64                     TagFilter;
    ULONG                       NumReqs;
    IMAGEHLP_SYMBOL_TYPE_INFO   *ReqKinds;
    PULONG_PTR                  ReqOffsets;
    PULONG                      ReqSizes;
    ULONG_PTR                   ReqStride;
    ULONG_PTR                   BufferSize;
    PVOID                       Buffer;
    ULONG                       EntriesMatched;
    ULONG                       EntriesFilled;
    ULONG64                     TagsFound;
    ULONG64                     AllReqsValid;
    ULONG                       NumReqsValid;
    PULONG64                    ReqsValid;
} IMAGEHLP_GET_TYPE_INFO_PARAMS;
typedef IMAGEHLP_GET_TYPE_INFO_PARAMS   *PIMAGEHLP_GET_TYPE_INFO_PARAMS;

/* Symbol server index information */
typedef struct {
    DWORD   sizeofstruct;
    char    file[MAX_PATH + 1];
    BOOL    stripped;
    DWORD   timestamp;
    DWORD   size;
    char    dbgfile[MAX_PATH + 1];
    char    pdbfile[MAX_PATH + 1];
    GUID    guid;
    DWORD   sig;
    DWORD   age;
} SYMSRV_INDEX_INFO;
typedef SYMSRV_INDEX_INFO   *PSYMSRV_INDEX_INFO;

/* Unicode symbol server index information */
typedef struct {
    DWORD   sizeofstruct;
    WCHAR   file[MAX_PATH + 1];
    BOOL    stripped;
    DWORD   timestamp;
    DWORD   size;
    WCHAR   dbgfile[MAX_PATH + 1];
    WCHAR   pdbfile[MAX_PATH + 1];
    GUID    guid;
    DWORD   sig;
    DWORD   age;
} SYMSRV_INDEX_INFOW;
typedef SYMSRV_INDEX_INFOW  *PSYMSRV_INDEX_INFOW;

/* SymGetSymbolFile() types */
enum {
    sfImage = 0,
    sfDbg   = 1,
    sfPdb   = 2,
    sfMpd   = 3,
    sfMax   = 4
};

/* User dump callbacks */
typedef BOOL (WINAPI *PDBGHELP_CREATE_USER_DUMP_CALLBACK)( DWORD, PVOID *, LPDWORD, PVOID );

/* Symbol server procedures */
typedef BOOL (WINAPI *PSYMBOLSERVERPROC)( PCSTR, PCSTR, PVOID, DWORD, DWORD, PSTR );
typedef BOOL (WINAPI *PSYMBOLSERVERPROCA)( PCSTR, PCSTR, PVOID, DWORD, DWORD, PSTR );
typedef BOOL (WINAPI *PSYMBOLSERVERPROCW)( PCWSTR, PCWSTR, PVOID, DWORD, DWORD, PWSTR );
typedef BOOL (WINAPI *PSYMBOLSERVERBYINDEXPROC)( PCSTR, PCSTR, PCSTR, PSTR );
typedef BOOL (WINAPI *PSYMBOLSERVERBYINDEXPROCA)( PCSTR, PCSTR, PCSTR, PSTR );
typedef BOOL (WINAPI *PSYMBOLSERVERBYINDEXPROCW)( PCWSTR, PCWSTR, PCWSTR, PWSTR );
typedef BOOL (WINAPI *PSYMBOLSERVEROPENPROC)( VOID );
typedef BOOL (WINAPI *PSYMBOLSERVERCLOSEPROC)( VOID );
typedef BOOL (WINAPI *PSYMBOLSERVERSETOPTIONSPROC)( UINT_PTR, ULONG64 );
typedef BOOL (WINAPI *PSYMBOLSERVERSETOPTIONSWPROC)( UINT_PTR, ULONG64 );
typedef BOOL (WINAPI *PSYMBOLSERVERCALLBACKPROC)( UINT_PTR, ULONG64, ULONG64 );
typedef UINT_PTR (WINAPI *PSYMBOLSERVERGETOPTIONSPROC)();
typedef BOOL (WINAPI *PSYMBOLSERVERPINGPROC)( PCSTR );
typedef BOOL (WINAPI *PSYMBOLSERVERPINGPROCA)( PCSTR );
typedef BOOL (WINAPI *PSYMBOLSERVERPINGPROCW)( PCWSTR );
typedef BOOL (WINAPI *PSYMBOLSERVERGETVERSION)( LPAPI_VERSION );
typedef BOOL (WINAPI *PSYMBOLSERVERDELTANAME)( PCSTR, PVOID, DWORD, DWORD, PVOID, DWORD, DWORD, PSTR, size_t );
typedef BOOL (WINAPI *PSYMBOLSERVERDELTANAMEW)( PCWSTR, PVOID, DWORD, DWORD, PVOID, DWORD, DWORD, PWSTR, size_t );
typedef BOOL (WINAPI *PSYMBOLSERVERGETSUPPLEMENT)( PCSTR, PCSTR, PCSTR, PSTR, size_t );
typedef BOOL (WINAPI *PSYMBOLSERVERGETSUPPLEMENTW)( PCWSTR, PCWSTR, PCWSTR, PWSTR, size_t );
typedef BOOL (WINAPI *PSYMBOLSERVERSTORESUPPLEMENT)( PCSTR, PCSTR, PCSTR, PSTR, size_t, DWORD );
typedef BOOL (WINAPI *PSYMBOLSERVERSTORESUPPLEMENTW)( PCWSTR, PCWSTR, PCWSTR, PWSTR, size_t, DWORD );
typedef BOOL (WINAPI *PSYMBOLSERVERGETINDEXSTRING)( PVOID, DWORD, DWORD, PSTR, size_t );
typedef BOOL (WINAPI *PSYMBOLSERVERGETINDEXSTRINGW)( PVOID, DWORD, DWORD, PWSTR, size_t );
typedef BOOL (WINAPI *PSYMBOLSERVERSTOREFILE)( PCSTR, PCSTR, PVOID, DWORD, DWORD, PSTR, size_t, DWORD );
typedef BOOL (WINAPI *PSYMBOLSERVERSTOREFILEW)( PCWSTR, PCWSTR, PVOID, DWORD, DWORD, PWSTR, size_t, DWORD );
typedef BOOL (WINAPI *PSYMBOLSERVERISSTORE)( PCSTR );
typedef BOOL (WINAPI *PSYMBOLSERVERISSTOREW)( PCWSTR );
typedef DWORD (WINAPI *PSYMBOLSERVERVERSION)();
typedef BOOL (WINAPI *PSYMBOLSERVERMESSAGEPROC)( UINT_PTR, ULONG64, ULONG64 );

/* Minidump location descriptor */
typedef struct _MINIDUMP_LOCATION_DESCRIPTOR {
    ULONG32 DataSize;
    RVA     Rva;
} MINIDUMP_LOCATION_DESCRIPTOR;

/* Minidump location descriptor (64-bit version) */
typedef struct _MINIDUMP_LOCATION_DESCRIPTOR64 {
    ULONG64 DataSize;
    RVA64   Rva;
} MINIDUMP_LOCATION_DESCRIPTOR64;

/* Minidump memory descriptor */
typedef struct _MINIDUMP_MEMORY_DESCRIPTOR {
    ULONG64                         StartOfMemoryRange;
    MINIDUMP_LOCATION_DESCRIPTOR    Memory;
} MINIDUMP_MEMORY_DESCRIPTOR;
typedef MINIDUMP_MEMORY_DESCRIPTOR  *PMINIDUMP_MEMORY_DESCRIPTOR;

/* Minidump memory descriptor (64-bit version) */
typedef struct _MINIDUMP_MEMORY_DESCRIPTOR64 {
    ULONG64 StartOfMemoryRange;
    ULONG64 DataSize;
} MINIDUMP_MEMORY_DESCRIPTOR64;
typedef MINIDUMP_MEMORY_DESCRIPTOR64    *PMINIDUMP_MEMORY_DESCRIPTOR64;

/* Minidump header */
typedef struct _MINIDUMP_HEADER {
    ULONG32 Signature;
    ULONG32 Version;
    ULONG32 NumberOfStreams;
    RVA     StreamDirectoryRva;
    ULONG32 CheckSum;
    union {
        ULONG32 Reserved;
        ULONG32 TimeDateStamp;
    };
    ULONG64 Flags;
} MINIDUMP_HEADER;
typedef MINIDUMP_HEADER *PMINIDUMP_HEADER;

/* Minidump directory */
typedef struct _MINIDUMP_DIRECTORY {
    ULONG32                         StreamType;
    MINIDUMP_LOCATION_DESCRIPTOR    Location;
} MINIDUMP_DIRECTORY;
typedef MINIDUMP_DIRECTORY  *PMINIDUMP_DIRECTORY;

/* Minidump string */
typedef struct _MINIDUMP_STRING {
    ULONG32 Length;
    WCHAR   Buffer[1];
} MINIDUMP_STRING;
typedef MINIDUMP_STRING *PMINIDUMP_STRING;

/* Minidump stream types */
typedef enum _MINIDUMP_STREAM_TYPE {
    UnusedStream                = 0,
    ThreadListStream            = 3,
    ModuleListStream            = 4,
    MemoryListStream            = 5,
    ExceptionStream             = 6,
    SystemInfoStream            = 7,
    ThreadExListStream          = 8,
    Memory64ListStream          = 9,
    CommentStreamA              = 10,
    CommentStreamW              = 11,
    HandleDataStream            = 12,
    FunctionTableStream         = 13,
    UnloadedModuleListStream    = 14,
    MiscInfoStream              = 15,
    MemoryInfoListStream        = 16,
    ThreadInfoListStream        = 17,
    HandleOperationListStream   = 18,
    TokenStream                 = 19,
    ceStreamNull                = 0x8000,
    ceStreamSystemInfo          = 0x8001,
    ceStreamException           = 0x8002,
    ceStreamModuleList          = 0x8003,
    ceStreamProcessList         = 0x8004,
    ceStreamThreadList          = 0x8005,
    ceStreamThreadContextList   = 0x8006,
    ceStreamThreadCallStackList = 0x8007,
    ceStreamMemoryVirtualList   = 0x8008,
    ceStreamMemoryPhysicalList  = 0x8009,
    ceStreamBucketParameters    = 0x800A,
    ceStreamProcessModuleMap    = 0x800B,
    ceStreamDiagnosisList       = 0x800C,
    LastReservedStream          = 0xFFFF
} MINIDUMP_STREAM_TYPE;

/* CPU information */
typedef union _CPU_INFORMATION {
    struct {
        ULONG32 VendorId[3];
        ULONG32 VersionInformation;
        ULONG32 FeatureInformation;
        ULONG32 AMDExtendedCpuFeatures;
    } X86CpuInfo;
    struct {
        ULONG64 ProcessorFeatures[2];
    } OtherCpuInfo;
} CPU_INFORMATION;
typedef CPU_INFORMATION *PCPU_INFORMATION;

/* Minidump system information */
typedef struct _MINIDUMP_SYSTEM_INFO {
    USHORT          ProcessorArchitecture;
    USHORT          ProcessorLevel;
    USHORT          ProcessorRevision;
    union {
        USHORT  Reserved0;
        struct {
            UCHAR   NumberOfProcessors;
            UCHAR   ProductType;
        };
    };
    ULONG32         MajorVersion;
    ULONG32         MinorVersion;
    ULONG32         BuildNumber;
    ULONG32         PlatformId;
    RVA             CSDVersionRva;
    union {
        ULONG32 Reserved1;
        struct {
            USHORT  SuiteMask;
            USHORT  Reserved2;
        };
    };
    CPU_INFORMATION Cpu;
} MINIDUMP_SYSTEM_INFO;
typedef MINIDUMP_SYSTEM_INFO    *PMINIDUMP_SYSTEM_INFO;

/* Minidump thread */
typedef struct _MINIDUMP_THREAD {
    ULONG32                         ThreadId;
    ULONG32                         SuspendCount;
    ULONG32                         PriorityClass;
    ULONG32                         Priority;
    ULONG64                         Teb;
    MINIDUMP_MEMORY_DESCRIPTOR      Stack;
    MINIDUMP_LOCATION_DESCRIPTOR    ThreadContext;
} MINIDUMP_THREAD;
typedef MINIDUMP_THREAD *PMINIDUMP_THREAD;

/* Minidump thread list */
typedef struct _MINIDUMP_THREAD_LIST {
    ULONG32         NumberOfThreads;
    MINIDUMP_THREAD Threads[1];
} MINIDUMP_THREAD_LIST;
typedef MINIDUMP_THREAD_LIST    *PMINIDUMP_THREAD_LIST;

/* Minidump thread (extended version) */
typedef struct _MINIDUMP_THREAD_EX {
    ULONG32                         ThreadId;
    ULONG32                         SuspendCount;
    ULONG32                         PriorityClass;
    ULONG32                         Priority;
    ULONG64                         Teb;
    MINIDUMP_MEMORY_DESCRIPTOR      Stack;
    MINIDUMP_LOCATION_DESCRIPTOR    ThreadContext;
    MINIDUMP_MEMORY_DESCRIPTOR      BackingStore;
} MINIDUMP_THREAD_EX;
typedef MINIDUMP_THREAD_EX  *PMINIDUMP_THREAD_EX;

/* Minidump thread list (extended version) */
typedef struct _MINIDUMP_THREAD_EX_LIST {
    ULONG32             NumberOfThreads;
    MINIDUMP_THREAD_EX  Threads[1];
} MINIDUMP_THREAD_EX_LIST;
typedef MINIDUMP_THREAD_EX_LIST *PMINIDUMP_THREAD_EX_LIST;

/* Minidump exception */
typedef struct _MINIDUMP_EXCEPTION {
    ULONG32 ExceptionCode;
    ULONG32 ExceptionFlags;
    ULONG64 ExceptionRecord;
    ULONG64 ExceptionAddress;
    ULONG32 NumberParameters;
    ULONG32 __unusedAlignment;
    ULONG64 ExceptionInformation[EXCEPTION_MAXIMUM_PARAMETERS];
} MINIDUMP_EXCEPTION;
typedef MINIDUMP_EXCEPTION  *PMINIDUMP_EXCEPTION;

/* Minidump exception stream */
typedef struct _MINIDUMP_EXCEPTION_STREAM {
    ULONG32                         ThreadId;
    ULONG32                         __alignment;
    MINIDUMP_EXCEPTION              ExceptionRecord;
    MINIDUMP_LOCATION_DESCRIPTOR    ThreadContext;
} MINIDUMP_EXCEPTION_STREAM;
typedef MINIDUMP_EXCEPTION_STREAM   *PMINIDUMP_EXCEPTION_STREAM;

/* Minidump module */
typedef struct _MINIDUMP_MODULE {
    ULONG64                         BaseOfImage;
    ULONG32                         SizeOfImage;
    ULONG32                         CheckSum;
    ULONG32                         TimeDateStamp;
    RVA                             ModuleNameRva;
    VS_FIXEDFILEINFO                VersionInfo;
    MINIDUMP_LOCATION_DESCRIPTOR    CvRecord;
    MINIDUMP_LOCATION_DESCRIPTOR    MiscRecord;
    ULONG64                         Reserved0;
    ULONG64                         Reserved1;
} MINIDUMP_MODULE;
typedef MINIDUMP_MODULE *PMINIDUMP_MODULE;

/* Minidump module list */
typedef struct _MINIDUMP_MODULE_LIST {
    ULONG32         NumberOfModules;
    MINIDUMP_MODULE Modules[1];
} MINIDUMP_MODULE_LIST;
typedef MINIDUMP_MODULE_LIST    *PMINIDUMP_MODULE_LIST;

/* Minidump memory list */
typedef struct _MINIDUMP_MEMORY_LIST {
    ULONG32                     NumberOfMemoryRanges;
    MINIDUMP_MEMORY_DESCRIPTOR  MemoryRanges[1];
} MINIDUMP_MEMORY_LIST;
typedef MINIDUMP_MEMORY_LIST    *PMINIDUMP_MEMORY_LIST;

/* Minidump memory list (64-bit version) */
typedef struct _MINIDUMP_MEMORY64_LIST {
    ULONG64                         NumberOfMemoryRanges;
    RVA64                           BaseRva;
    MINIDUMP_MEMORY_DESCRIPTOR64    MemoryRanges[1];
} MINIDUMP_MEMORY64_LIST;
typedef MINIDUMP_MEMORY64_LIST  *PMINIDUMP_MEMORY64_LIST;

/* Minidump exception information */
typedef struct _MINIDUMP_EXCEPTION_INFORMATION {
    DWORD               ThreadId;
    PEXCEPTION_POINTERS ExceptionPointers;
    BOOL                ClientPointers;
} MINIDUMP_EXCEPTION_INFORMATION;
typedef MINIDUMP_EXCEPTION_INFORMATION  *PMINIDUMP_EXCEPTION_INFORMATION;

/* Minidump exception information (64-bit version) */
typedef struct _MINIDUMP_EXCEPTION_INFORMATION64 {
    DWORD   ThreadId;
    ULONG64 ExceptionRecord;
    ULONG64 ContextRecord;
    BOOL    ClientPointers;
} MINIDUMP_EXCEPTION_INFORMATION64;
typedef MINIDUMP_EXCEPTION_INFORMATION64    *PMINIDUMP_EXCEPTION_INFORMATION64;

/* Minidump handle object information types */
typedef enum _MINIDUMP_HANDLE_OBJECT_INFORMATION_TYPE {
    MiniHandleObjectInformationNone     = 0,
    MiniThreadInformation1              = 1,
    MiniMutantInformation1              = 2,
    MiniMutantInformation2              = 3,
    MiniProcessInformation1             = 4,
    MiniProcessInformation2             = 5,
    MiniHandleObjectInformationTypeMax  = 6
} MINIDUMP_HANDLE_OBJECT_INFORMATION_TYPE;

/* Minidump handle object information */
typedef struct _MINIDUMP_HANDLE_OBJECT_INFORMATION {
    RVA     NextInfoRva;
    ULONG32 InfoType;
    ULONG32 SizeOfInfo;
} MINIDUMP_HANDLE_OBJECT_INFORMATION;

/* Minidump handle descriptor */
typedef struct _MINIDUMP_HANDLE_DESCRIPTOR {
    ULONG64 Handle;
    RVA     TypeNameRva;
    RVA     ObjectNameRva;
    ULONG32 Attributes;
    ULONG32 GrantedAccess;
    ULONG32 HandleCount;
    ULONG32 PointerCount;
} MINIDUMP_HANDLE_DESCRIPTOR;
typedef MINIDUMP_HANDLE_DESCRIPTOR  *PMINIDUMP_HANDLE_DESCRIPTOR;

/* Minidump handle descriptor (version 2) */
typedef struct _MINIDUMP_HANDLE_DESCRIPTOR_2 {
    ULONG64 Handle;
    RVA     TypeNameRva;
    RVA     ObjectNameRva;
    ULONG32 Attributes;
    ULONG32 GrantedAccess;
    ULONG32 HandleCount;
    ULONG32 PointerCount;
    RVA     ObjectInfoRva;
    ULONG32 Reserved0;
} MINIDUMP_HANDLE_DESCRIPTOR_2;
typedef MINIDUMP_HANDLE_DESCRIPTOR_2    *PMINIDUMP_HANDLE_DESCRIPTOR_2;
typedef MINIDUMP_HANDLE_DESCRIPTOR_2    MINIDUMP_HANDLE_DESCRIPTOR_N;
typedef MINIDUMP_HANDLE_DESCRIPTOR_N    *PMINIDUMP_HANDLE_DESCRIPTOR_N;

/* Minidump handle data stream */
typedef struct _MINIDUMP_HANDLE_DATA_STREAM {
    ULONG32 SizeOfHeader;
    ULONG32 SizeOfDescriptor;
    ULONG32 NumberOfDescriptors;
    ULONG32 Reserved;
} MINIDUMP_HANDLE_DATA_STREAM;
typedef MINIDUMP_HANDLE_DATA_STREAM *PMINIDUMP_HANDLE_DATA_STREAM;

/* Minidump handle operation list */
typedef struct _MINIDUMP_HANDLE_OPERATION_LIST {
    ULONG32 SizeOfHeader;
    ULONG32 SizeOfEntry;
    ULONG32 NumberOfEntries;
    ULONG32 Reserved;
} MINIDUMP_HANDLE_OPERATION_LIST;
typedef MINIDUMP_HANDLE_OPERATION_LIST  *PMINIDUMP_HANDLE_OPERATION_LIST;

/* Minidump function table descriptor */
typedef struct _MINIDUMP_FUNCTION_TABLE_DESCRIPTOR {
    ULONG64 MinimumAddress;
    ULONG64 MaximumAddress;
    ULONG64 BaseAddress;
    ULONG32 EntryCount;
    ULONG32 SizeOfAlignPad;
} MINIDUMP_FUNCTION_TABLE_DESCRIPTOR;
typedef MINIDUMP_FUNCTION_TABLE_DESCRIPTOR  *PMINIDUMP_FUNCTION_TABLE_DESCRIPTOR;

/* Minidump function table stream */
typedef struct _MINIDUMP_FUNCTION_TABLE_STREAM {
    ULONG32 SizeOfHeader;
    ULONG32 SizeOfDescriptor;
    ULONG32 SizeOfNativeDescriptor;
    ULONG32 SizeOfFunctionEntry;
    ULONG32 NumberOfDescriptors;
    ULONG32 SizeOfAlignPad;
} MINIDUMP_FUNCTION_TABLE_STREAM;
typedef MINIDUMP_FUNCTION_TABLE_STREAM  *PMINIDUMP_FUNCTION_TABLE_STREAM;

/* Minidump unloaded module */
typedef struct _MINIDUMP_UNLOADED_MODULE {
    ULONG64 BaseOfImage;
    ULONG32 SizeOfImage;
    ULONG32 CheckSum;
    ULONG32 TimeDateStamp;
    RVA     ModuleNameRva;
} MINIDUMP_UNLOADED_MODULE;
typedef MINIDUMP_UNLOADED_MODULE    *PMINIDUMP_UNLOADED_MODULE;

/* Minidump unloaded module list */
typedef struct _MINIDUMP_UNLOADED_MODULE_LIST {
    ULONG32 SizeOfHeader;
    ULONG32 SizeOfEntry;
    ULONG32 NumberOfEntries;
} MINIDUMP_UNLOADED_MODULE_LIST;
typedef MINIDUMP_UNLOADED_MODULE_LIST   *PMINIDUMP_UNLOADED_MODULE_LIST;

/* Minidump miscellaneous information */
typedef struct _MINIDUMP_MISC_INFO {
    ULONG32 SizeOfInfo;
    ULONG32 Flags1;
    ULONG32 ProcessId;
    ULONG32 ProcessCreateTime;
    ULONG32 ProcessUserTime;
    ULONG32 ProcessKernelTime;
} MINIDUMP_MISC_INFO;
typedef MINIDUMP_MISC_INFO  *PMINIDUMP_MISC_INFO;

/* Minidump miscellaneous information (version 2) */
typedef struct _MINIDUMP_MISC_INFO_2 {
    ULONG32 SizeOfInfo;
    ULONG32 Flags1;
    ULONG32 ProcessId;
    ULONG32 ProcessCreateTime;
    ULONG32 ProcessUserTime;
    ULONG32 ProcessKernelTime;
    ULONG32 ProcessorMaxMhz;
    ULONG32 ProcessorCurrentMhz;
    ULONG32 ProcessorMhzLimit;
    ULONG32 ProcessorMaxIdleState;
    ULONG32 ProcessorCurrentIdleState;
} MINIDUMP_MISC_INFO_2;
typedef MINIDUMP_MISC_INFO_2    *PMINIDUMP_MISC_INFO_2;

/* Minidump miscellaneous information (version 3) */
typedef struct _MINIDUMP_MISC_INFO_3 {
    ULONG32                 SizeOfInfo;
    ULONG32                 Flags1;
    ULONG32                 ProcessId;
    ULONG32                 ProcessCreateTime;
    ULONG32                 ProcessUserTime;
    ULONG32                 ProcessKernelTime;
    ULONG32                 ProcessorMaxMhz;
    ULONG32                 ProcessorCurrentMhz;
    ULONG32                 ProcessorMhzLimit;
    ULONG32                 ProcessorMaxIdleState;
    ULONG32                 ProcessorCurrentIdleState;
    ULONG32                 ProcessIntegrityLevel;
    ULONG32                 ProcessExecuteFlags;
    ULONG32                 ProtectedProcess;
    ULONG32                 TimeZoneId;
    TIME_ZONE_INFORMATION   TimeZone;
} MINIDUMP_MISC_INFO_3;
typedef MINIDUMP_MISC_INFO_3    *PMINIDUMP_MISC_INFO_3;
typedef MINIDUMP_MISC_INFO_3    MINIDUMP_MISC_INFO_N;
typedef MINIDUMP_MISC_INFO_N    *PMINIDUMP_MISC_INFO_N;

/* Minidump memory information */
typedef struct _MINIDUMP_MEMORY_INFO {
    ULONG64 BaseAddress;
    ULONG64 AllocationBase;
    ULONG32 AllocationProtect;
    ULONG32 __alignment1;
    ULONG64 RegionSize;
    ULONG32 State;
    ULONG32 Protect;
    ULONG32 Type;
    ULONG32 __alignment2;
} MINIDUMP_MEMORY_INFO;
typedef MINIDUMP_MEMORY_INFO    *PMINIDUMP_MEMORY_INFO;

/* Minidump memory information list */
typedef struct _MINIDUMP_MEMORY_INFO_LIST {
    ULONG   SizeOfHeader;
    ULONG   SizeOfEntry;
    ULONG64 NumberOfEntries;
} MINIDUMP_MEMORY_INFO_LIST;
typedef MINIDUMP_MEMORY_INFO_LIST   *PMINIDUMP_MEMORY_INFO_LIST;

/* Minidump thread information */
typedef struct _MINIDUMP_THREAD_INFO {
    ULONG32 ThreadId;
    ULONG32 DumpFlags;
    ULONG32 DumpError;
    ULONG32 ExitStatus;
    ULONG64 CreateTime;
    ULONG64 ExitTime;
    ULONG64 KernelTime;
    ULONG64 UserTime;
    ULONG64 StartAddress;
    ULONG64 Affinity;
} MINIDUMP_THREAD_INFO;
typedef MINIDUMP_THREAD_INFO    *PMINIDUMP_THREAD_INFO;

/* Minidump thread information list */
typedef struct _MINIDUMP_THREAD_INFO_LIST {
    ULONG   SizeOfHeader;
    ULONG   SizeOfEntry;
    ULONG   NumberOfEntries;
} MINIDUMP_THREAD_INFO_LIST;
typedef MINIDUMP_THREAD_INFO_LIST   *PMINIDUMP_THREAD_INFO_LIST;

/* Minidump token information header */
typedef struct _MINIDUMP_TOKEN_INFO_HEADER {
    ULONG   TokenSize;
    ULONG   TokenId;
    ULONG64 TokenHandle;
} MINIDUMP_TOKEN_INFO_HEADER;
typedef MINIDUMP_TOKEN_INFO_HEADER  *PMINIDUMP_TOKEN_INFO_HEADER;

/* Minidump token information list */
typedef struct _MINIDUMP_TOKEN_INFO_LIST {
    ULONG   TokenListSize;
    ULONG   TokenListEntries;
    ULONG   ListHeaderSize;
    ULONG   ElementHeaderSize;
} MINIDUMP_TOKEN_INFO_LIST;
typedef MINIDUMP_TOKEN_INFO_LIST    *PMINIDUMP_TOKEN_INFO_LIST;

/* Minidump user record */
typedef struct _MINIDUMP_USER_RECORD {
    ULONG32                         Type;
    MINIDUMP_LOCATION_DESCRIPTOR    Memory;
} MINIDUMP_USER_RECORD;
typedef MINIDUMP_USER_RECORD    *PMINIDUMP_USER_RECORD;

/* Minidump user stream */
typedef struct _MINIDUMP_USER_STREAM {
    ULONG32 Type;
    ULONG   BufferSize;
    PVOID   Buffer;
} MINIDUMP_USER_STREAM;
typedef MINIDUMP_USER_STREAM    *PMINIDUMP_USER_STREAM;

/* Minidump user stream information */
typedef struct _MINIDUMP_USER_STREAM_INFORMATION {
    ULONG                   UserStreamCount;
    PMINIDUMP_USER_STREAM   UserStreamArray;
} MINIDUMP_USER_STREAM_INFORMATION;
typedef MINIDUMP_USER_STREAM_INFORMATION    *PMINIDUMP_USER_STREAM_INFORMATION;

/* Minidump callback types */
typedef enum _MINIDUMP_CALLBACK_TYPE {
    ModuleCallback                  = 0,
    ThreadCallback                  = 1,
    ThreadExCallback                = 2,
    IncludeThreadCallback           = 3,
    IncludeModuleCallback           = 4,
    MemoryCallback                  = 5,
    CancelCallback                  = 6,
    WriteKernelMinidumpCallback     = 7,
    KernelMinidumpStatusCallback    = 8,
    RemoveMemoryCallback            = 9,
    IncludeVmRegionCallback         = 10,
    IoStartCallback                 = 11,
    IoWriteAllCallback              = 12,
    IoFinishCallback                = 13,
    ReadMemoryFailureCallback       = 14,
    SecondaryFlagsCallback          = 15,
} MINIDUMP_CALLBACK_TYPE;

/* Minidump thread callback */
typedef struct _MINIDUMP_THREAD_CALLBACK {
    ULONG   ThreadId;
    HANDLE  ThreadHandle;
    CONTEXT Context;
    ULONG   SizeOfContext;
    ULONG64 StackBase;
    ULONG64 StackEnd;
} MINIDUMP_THREAD_CALLBACK;
typedef MINIDUMP_THREAD_CALLBACK    *PMINIDUMP_THREAD_CALLBACK;

/* Minidump thread callback (extended version) */
typedef struct _MINIDUMP_THREAD_EX_CALLBACK {
    ULONG   ThreadId;
    HANDLE  ThreadHandle;
    CONTEXT Context;
    ULONG   SizeOfContext;
    ULONG64 StackBase;
    ULONG64 StackEnd;
    ULONG64 BackingStoreBase;
    ULONG64 BackingStoreEnd;
} MINIDUMP_THREAD_EX_CALLBACK;
typedef MINIDUMP_THREAD_EX_CALLBACK *PMINIDUMP_THREAD_EX_CALLBACK;

/* Minidump include thread callback */
typedef struct _MINIDUMP_INCLUDE_THREAD_CALLBACK {
    ULONG   ThreadId;
} MINIDUMP_INCLUDE_THREAD_CALLBACK;
typedef MINIDUMP_INCLUDE_THREAD_CALLBACK    *PMINIDUMP_INCLUDE_THREAD_CALLBACK;

/* Thread write flags */
typedef enum _THREAD_WRITE_FLAGS {
    ThreadWriteThread               = 0x0001,
    ThreadWriteStack                = 0x0002,
    ThreadWriteContext              = 0x0004,
    ThreadWriteBackingStore         = 0x0008,
    ThreadWriteInstructionWindow    = 0x0010,
    ThreadWriteThreadData           = 0x0020,
    ThreadWriteThreadInfo           = 0x0040
} THREAD_WRITE_FLAGS;

/* Minidump module callback */
typedef struct _MINIDUMP_MODULE_CALLBACK {
    PWCHAR              FullPath;
    ULONG64             BaseOfImage;
    ULONG               SizeOfImage;
    ULONG               CheckSum;
    ULONG               TimeDateStamp;
    VS_FIXEDFILEINFO    VersionInfo;
    PVOID               CvRecord;
    ULONG               SizeOfCvRecord;
    PVOID               MiscRecord;
    ULONG               SizeOfMiscRecord;
} MINIDUMP_MODULE_CALLBACK;
typedef MINIDUMP_MODULE_CALLBACK    *PMINIDUMP_MODULE_CALLBACK;

/* Minidump include module callback */
typedef struct _MINIDUMP_INCLUDE_MODULE_CALLBACK {
    ULONG64 BaseOfImage;
} MINIDUMP_INCLUDE_MODULE_CALLBACK;
typedef MINIDUMP_INCLUDE_MODULE_CALLBACK    *PMINIDUMP_INCLUDE_MODULE_CALLBACK;

/* Module write flags */
typedef enum _MODULE_WRITE_FLAGS {
    ModuleWriteModule           = 0x0001,
    ModuleWriteDataSeg          = 0x0002,
    ModuleWriteMiscRecord       = 0x0004,
    ModuleWriteCvRecord         = 0x0008,
    ModuleReferencedByMemory    = 0x0010,
    ModuleWriteTlsData          = 0x0020,
    ModuleWriteCodeSegs         = 0x0040
} MODULE_WRITE_FLAGS;

/* Minidump I/O callback */
typedef struct _MINIDUMP_IO_CALLBACK {
    HANDLE  Handle;
    ULONG64 Offset;
    PVOID   Buffer;
    ULONG   BufferBytes;
} MINIDUMP_IO_CALLBACK;
typedef MINIDUMP_IO_CALLBACK    *PMINIDUMP_IO_CALLBACK;

/* Minidump read memory failure callback */
typedef struct _MINIDUMP_READ_MEMORY_FAILURE_CALLBACK {
    ULONG64 Offset;
    ULONG   Bytes;
    HRESULT FailureStatus;
} MINIDUMP_READ_MEMORY_FAILURE_CALLBACK;
typedef MINIDUMP_READ_MEMORY_FAILURE_CALLBACK   *PMINIDUMP_READ_MEMORY_FAILURE_CALLBACK;

/* Minidump callback input */
typedef struct _MINIDUMP_CALLBACK_INPUT {
    ULONG   ProcessId;
    HANDLE  ProcessHandle;
    ULONG   CallbackType;
    union {
        HRESULT                                 Status;
        MINIDUMP_THREAD_CALLBACK                Thread;
        MINIDUMP_THREAD_EX_CALLBACK             ThreadEx;
        MINIDUMP_MODULE_CALLBACK                Module;
        MINIDUMP_INCLUDE_THREAD_CALLBACK        IncludeThread;
        MINIDUMP_INCLUDE_MODULE_CALLBACK        IncludeModule;
        MINIDUMP_IO_CALLBACK                    Io;
        MINIDUMP_READ_MEMORY_FAILURE_CALLBACK   ReadMemoryFailure;
        ULONG                                   SecondaryFlags;
    };
} MINIDUMP_CALLBACK_INPUT;
typedef MINIDUMP_CALLBACK_INPUT *PMINIDUMP_CALLBACK_INPUT;

/* Minidump callback output */
typedef struct _MINIDUMP_CALLBACK_OUTPUT {
    union {
        ULONG   ModuleWriteFlags;
        ULONG   ThreadWriteFlags;
        ULONG   SecondaryFlags;
        struct {
            ULONG64 MemoryBase;
            ULONG   MemorySize;
        };
        struct {
            BOOL    CheckCancel;
            BOOL    Cancel;
        };
        HANDLE  Handle;
        struct {
            MINIDUMP_MEMORY_INFO    VmRegion;
            BOOL                    Continue;
        };
        HRESULT Status;
    };
} MINIDUMP_CALLBACK_OUTPUT;
typedef MINIDUMP_CALLBACK_OUTPUT    *PMINIDUMP_CALLBACK_OUTPUT;

/* Minidump types */
typedef enum _MINIDUMP_TYPE {
    MiniDumpNormal                          = 0x00000000,
    MiniDumpWithDataSegs                    = 0x00000001,
    MiniDumpWithFullMemory                  = 0x00000002,
    MiniDumpWithHandleData                  = 0x00000004,
    MiniDumpFilterMemory                    = 0x00000008,
    MiniDumpScanMemory                      = 0x00000010,
    MiniDumpWithUnloadedModules             = 0x00000020,
    MiniDumpWithIndirectlyReferencedMemory  = 0x00000040,
    MiniDumpFilterModulePaths               = 0x00000080,
    MiniDumpWithProcessThreadData           = 0x00000100,
    MiniDumpWithPrivateReadWriteMemory      = 0x00000200,
    MiniDumpWithoutOptionalData             = 0x00000400,
    MiniDumpWithFullMemoryInfo              = 0x00000800,
    MiniDumpWithThreadInfo                  = 0x00001000,
    MiniDumpWithCodeSegs                    = 0x00002000,
    MiniDumpWithoutAuxiliaryState           = 0x00004000,
    MiniDumpWithFullAuxiliaryState          = 0x00008000,
    MiniDumpWithPrivateWriteCopyMemory      = 0x00010000,
    MiniDumpIgnoreInaccessibleMemory        = 0x00020000,
    MiniDumpWithTokenInformation            = 0x00040000,
    MiniDumpValidTypeFlags                  = 0x0007FFFF
} MINIDUMP_TYPE;

/* Minidump secondary flags */
typedef enum _MINIDUMP_SECONDARY_FLAGS {
    MiniSecondaryWithoutPowerInfo   = 0x00000001,
    MiniSecondaryValidFlags         = 0x00000001
} MINIDUMP_SECONDARY_FLAGS;

/* Minidump callback routine */
typedef BOOL (WINAPI *MINIDUMP_CALLBACK_ROUTINE)( PVOID, PMINIDUMP_CALLBACK_INPUT, PMINIDUMP_CALLBACK_OUTPUT );

/* Minidump callback information */
typedef struct _MINIDUMP_CALLBACK_INFORMATION {
    MINIDUMP_CALLBACK_ROUTINE   CallbackRoutine;
    PVOID                       CallbackParam;
} MINIDUMP_CALLBACK_INFORMATION;
typedef MINIDUMP_CALLBACK_INFORMATION   *PMINIDUMP_CALLBACK_INFORMATION;

/* Functions in IMAGEHLP.DLL and DBGHELP.DLL */
BOOL IMAGEAPI               BindImage( PCSTR, PCSTR, PCSTR );
BOOL IMAGEAPI               BindImageEx( DWORD, PCSTR, PCSTR, PCSTR, PIMAGEHLP_STATUS_ROUTINE );
PIMAGE_NT_HEADERS IMAGEAPI  CheckSumMappedFile( PVOID, DWORD, PDWORD, PDWORD );
BOOL IMAGEAPI               EnumDirTree( HANDLE, PCSTR, PCSTR, PSTR, PENUMDIRTREE_CALLBACK, PVOID );
BOOL IMAGEAPI               EnumDirTreeW( HANDLE, PCWSTR, PCWSTR, PWSTR, PENUMDIRTREE_CALLBACKW, PVOID );
BOOL IMAGEAPI               EnumerateLoadedModules64( HANDLE, PENUMLOADED_MODULES_CALLBACK64, PVOID );
BOOL IMAGEAPI               EnumerateLoadedModulesW64( HANDLE, PENUMLOADED_MODULES_CALLBACKW64, PVOID );
BOOL IMAGEAPI               EnumerateLoadedModulesEx( HANDLE, PENUMLOADED_MODULES_CALLBACK64, PVOID );
BOOL IMAGEAPI               EnumerateLoadedModulesExW( HANDLE, PENUMLOADED_MODULES_CALLBACKW64, PVOID );
HANDLE IMAGEAPI             FindDebugInfoFile( PCSTR, PCSTR, PSTR );
HANDLE IMAGEAPI             FindDebugInfoFileEx( PCSTR, PCSTR, PSTR, PFIND_DEBUG_FILE_CALLBACK, PVOID );
HANDLE IMAGEAPI             FindDebugInfoFileExW( PCWSTR, PCWSTR, PWSTR, PFIND_DEBUG_FILE_CALLBACKW, PVOID );
HANDLE IMAGEAPI             FindExecutableImage( PCSTR, PCSTR, PSTR );
HANDLE IMAGEAPI             FindExecutableImageEx( PCSTR, PCSTR, PSTR, PFIND_EXE_FILE_CALLBACK, PVOID );
HANDLE IMAGEAPI             FindExecutableImageExW( PCWSTR, PCWSTR, PWSTR, PFIND_EXE_FILE_CALLBACKW, PVOID );
BOOL IMAGEAPI               FindFileInPath( HANDLE, PCSTR, PCSTR, PVOID, DWORD, DWORD, DWORD, PSTR );
BOOL IMAGEAPI               FindFileInSearchPath( HANDLE, PCSTR, PCSTR, DWORD, DWORD, DWORD, PSTR );
BOOL IMAGEAPI               GetImageConfigInformation( PLOADED_IMAGE, PIMAGE_LOAD_CONFIG_DIRECTORY );
DWORD IMAGEAPI              GetImageUnusedHeaderBytes( PLOADED_IMAGE, PDWORD );
DWORD IMAGEAPI              GetTimestampForLoadedLibrary( HMODULE );
BOOL IMAGEAPI               ImageAddCertificate( HANDLE, LPWIN_CERTIFICATE, PDWORD );
PVOID IMAGEAPI              ImageDirectoryEntryToData( PVOID, BOOLEAN, USHORT, PULONG );
PVOID IMAGEAPI              ImageDirectoryEntryToDataEx( PVOID, BOOLEAN, USHORT, PULONG, PIMAGE_SECTION_HEADER * );
BOOL IMAGEAPI               ImageEnumerateCertificates( HANDLE, WORD, PDWORD, PDWORD, DWORD );
BOOL IMAGEAPI               ImageGetCertificateData( HANDLE, DWORD, LPWIN_CERTIFICATE, PDWORD );
BOOL IMAGEAPI               ImageGetCertificateHeader( HANDLE, DWORD, LPWIN_CERTIFICATE );
BOOL IMAGEAPI               ImageGetDigestStream( HANDLE, DWORD, DIGEST_FUNCTION, DIGEST_HANDLE );
PLOADED_IMAGE IMAGEAPI      ImageLoad( PCSTR, PCSTR );
PIMAGE_NT_HEADERS IMAGEAPI  ImageNtHeader( PVOID );
BOOL IMAGEAPI               ImageRemoveCertificate( HANDLE, DWORD );
PIMAGE_SECTION_HEADER IMAGEAPI  ImageRvaToSection( PIMAGE_NT_HEADERS, PVOID, ULONG );
PVOID IMAGEAPI              ImageRvaToVa( PIMAGE_NT_HEADERS, PVOID, ULONG, PIMAGE_SECTION_HEADER * );
BOOL IMAGEAPI               ImageUnload( PLOADED_IMAGE );
LPAPI_VERSION IMAGEAPI      ImagehlpApiVersion( VOID );
LPAPI_VERSION IMAGEAPI      ImagehlpApiVersionEx( LPAPI_VERSION );
BOOL IMAGEAPI               MakeSureDirectoryPathExists( PCSTR );
BOOL IMAGEAPI               MapAndLoad( PCSTR, PCSTR, PLOADED_IMAGE, BOOL, BOOL );
PIMAGE_DEBUG_INFORMATION IMAGEAPI   MapDebugInformation( HANDLE, PCSTR, PCSTR, ULONG );
DWORD IMAGEAPI              MapFileAndCheckSumA( PCSTR, PDWORD, PDWORD );
DWORD IMAGEAPI              MapFileAndCheckSumW( PCWSTR, PDWORD, PDWORD );
BOOL IMAGEAPI               ReBaseImage( PCSTR, PCSTR, BOOL, BOOL, BOOL, ULONG, ULONG *, ULONG_PTR *, ULONG *, ULONG_PTR *, ULONG );
BOOL IMAGEAPI               ReBaseImage64( PCSTR, PCSTR, BOOL, BOOL, BOOL, ULONG, ULONG *, ULONG64 *, ULONG *, ULONG64 *, ULONG );
BOOL IMAGEAPI               SearchTreeForFile( PCSTR, PCSTR, PSTR );
BOOL IMAGEAPI               SearchTreeForFileW( PCWSTR, PCWSTR, PWSTR );
BOOL IMAGEAPI               SetImageConfigInformation( PLOADED_IMAGE, PIMAGE_LOAD_CONFIG_DIRECTORY );
BOOL IMAGEAPI               SplitSymbols( PSTR, PCSTR, PSTR, ULONG );
BOOL IMAGEAPI               StackWalk64( DWORD, HANDLE, HANDLE, LPSTACKFRAME64, PVOID, PREAD_PROCESS_MEMORY_ROUTINE64, PFUNCTION_TABLE_ACCESS_ROUTINE64, PGET_MODULE_BASE_ROUTINE64, PTRANSLATE_ADDRESS_ROUTINE64 );
BOOL IMAGEAPI               SymAddSourceStream( HANDLE, ULONG64, PCSTR, PBYTE, size_t );
BOOL IMAGEAPI               SymAddSourceStreamA( HANDLE, ULONG64, PCSTR, PBYTE, size_t );
BOOL IMAGEAPI               SymAddSourceStreamW( HANDLE, ULONG64, PCWSTR, PBYTE, size_t );
BOOL IMAGEAPI               SymAddSymbol( HANDLE, ULONG64, PCSTR, DWORD64, DWORD, DWORD );
BOOL IMAGEAPI               SymAddSymbolW( HANDLE, ULONG64, PCWSTR, DWORD64, DWORD, DWORD );
BOOL IMAGEAPI               SymCleanup( HANDLE );
BOOL IMAGEAPI               SymDeleteSymbol( HANDLE, ULONG64, PCSTR, DWORD64, DWORD );
BOOL IMAGEAPI               SymDeleteSymbolW( HANDLE, ULONG64, PCWSTR, DWORD64, DWORD );
BOOL IMAGEAPI               SymEnumLines( HANDLE, ULONG64, PCSTR, PCSTR, PSYM_ENUMLINES_CALLBACK, PVOID );
BOOL IMAGEAPI               SymEnumLinesW( HANDLE, ULONG64, PCWSTR, PCWSTR, PSYM_ENUMLINES_CALLBACKW, PVOID );
BOOL IMAGEAPI               SymEnumProcesses( PSYM_ENUMPROCESSES_CALLBACK, PVOID );
BOOL IMAGEAPI               SymEnumSourceFileTokens( HANDLE, ULONG64, PENUMSOURCEFILETOKENSCALLBACK );
BOOL IMAGEAPI               SymEnumSourceFiles( HANDLE, ULONG64, PCSTR, PSYM_ENUMSOURCEFILES_CALLBACK, PVOID );
BOOL IMAGEAPI               SymEnumSourceFilesW( HANDLE, ULONG64, PCWSTR, PSYM_ENUMSOURCEFILES_CALLBACKW, PVOID );
BOOL IMAGEAPI               SymEnumSourceLines( HANDLE, ULONG64, PCSTR, PCSTR, DWORD, DWORD, PSYM_ENUMLINES_CALLBACK, PVOID );
BOOL IMAGEAPI               SymEnumSourceLinesW( HANDLE, ULONG64, PCWSTR, PCWSTR, DWORD, DWORD, PSYM_ENUMLINES_CALLBACKW, PVOID );
BOOL IMAGEAPI               SymEnumSym( HANDLE, ULONG64, PSYM_ENUMERATESYMBOLS_CALLBACK, PVOID );
BOOL IMAGEAPI               SymEnumSymbols( HANDLE, ULONG64, PCSTR, PSYM_ENUMERATESYMBOLS_CALLBACK, PVOID );
BOOL IMAGEAPI               SymEnumSymbolsForAddr( HANDLE, DWORD64, PSYM_ENUMERATESYMBOLS_CALLBACK, PVOID );
BOOL IMAGEAPI               SymEnumSymbolsForAddrW( HANDLE, DWORD64, PSYM_ENUMERATESYMBOLS_CALLBACKW, PVOID );
BOOL IMAGEAPI               SymEnumSymbolsW( HANDLE, ULONG64, PCWSTR, PSYM_ENUMERATESYMBOLS_CALLBACKW, PVOID );
BOOL IMAGEAPI               SymEnumTypes( HANDLE, ULONG64, PSYM_ENUMERATESYMBOLS_CALLBACK, PVOID );
BOOL IMAGEAPI               SymEnumTypesByName( HANDLE, ULONG64, PCSTR, PSYM_ENUMERATESYMBOLS_CALLBACK, PVOID );
BOOL IMAGEAPI               SymEnumTypesByNameW( HANDLE, ULONG64, PCWSTR, PSYM_ENUMERATESYMBOLS_CALLBACK, PVOID );
BOOL IMAGEAPI               SymEnumTypesW( HANDLE, ULONG64, PSYM_ENUMERATESYMBOLS_CALLBACKW, PVOID );
BOOL IMAGEAPI               SymEnumerateModules64( HANDLE, PSYM_ENUMMODULES_CALLBACK64, PVOID );
BOOL IMAGEAPI               SymEnumerateModulesW64( HANDLE, PSYM_ENUMMODULES_CALLBACKW64, PVOID );
BOOL IMAGEAPI               SymEnumerateSymbols64( HANDLE, ULONG64, PSYM_ENUMSYMBOLS_CALLBACK64, PVOID );
BOOL IMAGEAPI               SymEnumerateSymbolsW64( HANDLE, ULONG64, PSYM_ENUMSYMBOLS_CALLBACK64W, PVOID );
HANDLE IMAGEAPI             SymFindDebugInfoFile( HANDLE, PCSTR, PSTR, PFIND_DEBUG_FILE_CALLBACK, PVOID );
HANDLE IMAGEAPI             SymFindDebugInfoFileW( HANDLE, PCWSTR, PWSTR, PFIND_DEBUG_FILE_CALLBACKW, PVOID );
HANDLE IMAGEAPI             SymFindExecutableImage( HANDLE, PCSTR, PSTR, PFIND_EXE_FILE_CALLBACK, PVOID );
HANDLE IMAGEAPI             SymFindExecutableImageW( HANDLE, PCWSTR, PWSTR, PFIND_EXE_FILE_CALLBACKW, PVOID );
BOOL IMAGEAPI               SymFindFileInPath( HANDLE, PCSTR, PCSTR, PVOID, DWORD, DWORD, DWORD, PSTR, PFINDFILEINPATHCALLBACK, PVOID );
BOOL IMAGEAPI               SymFindFileInPathW( HANDLE, PCWSTR, PCWSTR, PVOID, DWORD, DWORD, DWORD, PWSTR, PFINDFILEINPATHCALLBACKW, PVOID );
BOOL IMAGEAPI               SymFromAddr( HANDLE, DWORD64, PDWORD64, PSYMBOL_INFO );
BOOL IMAGEAPI               SymFromAddrW( HANDLE, DWORD64, PDWORD64, PSYMBOL_INFOW );
BOOL IMAGEAPI               SymFromIndex( HANDLE, ULONG64, DWORD, PSYMBOL_INFO );
BOOL IMAGEAPI               SymFromIndexW( HANDLE, ULONG64, DWORD, PSYMBOL_INFOW );
BOOL IMAGEAPI               SymFromName( HANDLE, PCSTR, PSYMBOL_INFO );
BOOL IMAGEAPI               SymFromNameW( HANDLE, PCWSTR, PSYMBOL_INFOW );
BOOL IMAGEAPI               SymFromToken( HANDLE, DWORD64, DWORD, PSYMBOL_INFO );
BOOL IMAGEAPI               SymFromTokenW( HANDLE, DWORD64, DWORD, PSYMBOL_INFOW );
PVOID IMAGEAPI              SymFunctionTableAccess64( HANDLE, DWORD64 );
ULONG IMAGEAPI              SymGetFileLineOffsets64( HANDLE, PCSTR, PCSTR, PDWORD64, ULONG );
PCHAR IMAGEAPI              SymGetHomeDirectory( DWORD, PSTR, size_t );
PWSTR IMAGEAPI              SymGetHomeDirectoryW( DWORD, PWSTR, size_t );
BOOL IMAGEAPI               SymGetLineFromAddr64( HANDLE, DWORD64, PDWORD, PIMAGEHLP_LINE64 );
BOOL IMAGEAPI               SymGetLineFromAddrW64( HANDLE, DWORD64, PDWORD, PIMAGEHLP_LINEW64 );
BOOL IMAGEAPI               SymGetLineFromName64( HANDLE, PCSTR, PCSTR, DWORD, PLONG, PIMAGEHLP_LINE64 );
BOOL IMAGEAPI               SymGetLineFromNameW64( HANDLE, PCWSTR, PCWSTR, DWORD, PLONG, PIMAGEHLP_LINEW64 );
BOOL IMAGEAPI               SymGetLineNext64( HANDLE, PIMAGEHLP_LINE64 );
BOOL IMAGEAPI               SymGetLineNextW64( HANDLE, PIMAGEHLP_LINEW64 );
BOOL IMAGEAPI               SymGetLinePrev64( HANDLE, PIMAGEHLP_LINE64 );
BOOL IMAGEAPI               SymGetLinePrevW64( HANDLE, PIMAGEHLP_LINEW64 );
DWORD64 IMAGEAPI            SymGetModuleBase64( HANDLE, DWORD64 );
BOOL IMAGEAPI               SymGetModuleInfo64( HANDLE, DWORD64, PIMAGEHLP_MODULE64 );
BOOL IMAGEAPI               SymGetModuleInfoW64( HANDLE, DWORD64, PIMAGEHLP_MODULE64 );
BOOL IMAGEAPI               SymGetOmaps( HANDLE, DWORD64, POMAP *, PDWORD64, POMAP *, PDWORD64 );
DWORD IMAGEAPI              SymGetOptions( VOID );
BOOL IMAGEAPI               SymGetScope( HANDLE, ULONG64, DWORD, PSYMBOL_INFO );
BOOL IMAGEAPI               SymGetScopeW( HANDLE, ULONG64, DWORD, PSYMBOL_INFOW );
BOOL IMAGEAPI               SymGetSearchPath( HANDLE, PSTR, DWORD );
BOOL IMAGEAPI               SymGetSearchPathW( HANDLE, PWSTR, DWORD );
BOOL IMAGEAPI               SymGetSourceFile( HANDLE, ULONG64, PCSTR, PCSTR, PSTR, DWORD );
BOOL IMAGEAPI               SymGetSourceFileFromToken( HANDLE, PVOID, PCSTR, PSTR, DWORD );
BOOL IMAGEAPI               SymGetSourceFileFromTokenW( HANDLE, PVOID, PCWSTR, PWSTR, DWORD );
BOOL IMAGEAPI               SymGetSourceFileToken( HANDLE, ULONG64, PCSTR, PVOID *, DWORD * );
BOOL IMAGEAPI               SymGetSourceFileTokenW( HANDLE, ULONG64, PCWSTR, PVOID *, DWORD * );
BOOL IMAGEAPI               SymGetSourceFileW( HANDLE, ULONG64, PCWSTR, PCWSTR, PWSTR, DWORD );
BOOL IMAGEAPI               SymGetSourceVarFromToken( HANDLE, PVOID, PCSTR, PCSTR, PSTR, DWORD );
BOOL IMAGEAPI               SymGetSourceVarFromTokenW( HANDLE, PVOID, PCWSTR, PCWSTR, PWSTR, DWORD );
BOOL IMAGEAPI               SymGetSymFromAddr64( HANDLE, DWORD64, PDWORD64, PIMAGEHLP_SYMBOL64 );
BOOL IMAGEAPI               SymGetSymFromName64( HANDLE, PCSTR, PIMAGEHLP_SYMBOL64 );
BOOL IMAGEAPI               SymGetSymNext64( HANDLE, PIMAGEHLP_SYMBOL64 );
BOOL IMAGEAPI               SymGetSymPrev64( HANDLE, PIMAGEHLP_SYMBOL64 );
BOOL IMAGEAPI               SymGetSymbolFile( HANDLE, PCSTR, PCSTR, DWORD, PSTR, size_t, PSTR, size_t );
BOOL IMAGEAPI               SymGetSymbolFileW( HANDLE, PCWSTR, PCWSTR, DWORD, PWSTR, size_t, PWSTR, size_t );
BOOL IMAGEAPI               SymGetTypeFromName( HANDLE, ULONG64, PCSTR, PSYMBOL_INFO );
BOOL IMAGEAPI               SymGetTypeFromNameW( HANDLE, ULONG64, PCWSTR, PSYMBOL_INFOW );
BOOL IMAGEAPI               SymGetTypeInfo( HANDLE, DWORD64, ULONG, IMAGEHLP_SYMBOL_TYPE_INFO, PVOID );
BOOL IMAGEAPI               SymGetTypeInfoEx( HANDLE, DWORD64, PIMAGEHLP_GET_TYPE_INFO_PARAMS );
BOOL IMAGEAPI               SymGetUnwindInfo( HANDLE, DWORD64, PVOID, PULONG );
BOOL IMAGEAPI               SymInitialize( HANDLE, PCSTR, BOOL );
BOOL IMAGEAPI               SymInitializeW( HANDLE, PCWSTR, BOOL );
DWORD64 IMAGEAPI            SymLoadModule64( HANDLE, HANDLE, PCSTR, PCSTR, DWORD64, DWORD );
DWORD64 IMAGEAPI            SymLoadModuleEx( HANDLE, HANDLE, PCSTR, PCSTR, DWORD64, DWORD, PMODLOAD_DATA, DWORD );
DWORD64 IMAGEAPI            SymLoadModuleExW( HANDLE, HANDLE, PCWSTR, PCWSTR, DWORD64, DWORD, PMODLOAD_DATA, DWORD );
BOOL IMAGEAPI               SymMatchFileName( PCSTR, PCSTR, PSTR *, PSTR * );
BOOL IMAGEAPI               SymMatchFileNameW( PCWSTR, PCWSTR, PWSTR *, PWSTR * );
BOOL IMAGEAPI               SymMatchString( PCSTR, PCSTR, BOOL );
BOOL IMAGEAPI               SymMatchStringA( PCSTR, PCSTR, BOOL );
BOOL IMAGEAPI               SymMatchStringW( PCWSTR, PCWSTR, BOOL );
BOOL IMAGEAPI               SymNext( HANDLE, PSYMBOL_INFO );
BOOL IMAGEAPI               SymNextW( HANDLE, PSYMBOL_INFOW );
BOOL IMAGEAPI               SymPrev( HANDLE, PSYMBOL_INFO );
BOOL IMAGEAPI               SymPrevW( HANDLE, PSYMBOL_INFOW );
BOOL IMAGEAPI               SymRefreshModuleList( HANDLE );
BOOL IMAGEAPI               SymRegisterCallback64( HANDLE, PSYMBOL_REGISTERED_CALLBACK64, ULONG64 );
BOOL IMAGEAPI               SymRegisterCallbackW64( HANDLE, PSYMBOL_REGISTERED_CALLBACK64, ULONG64 );
BOOL IMAGEAPI               SymRegisterFunctionEntryCallback64( HANDLE, PSYMBOL_FUNCENTRY_CALLBACK64, ULONG64 );
BOOL IMAGEAPI               SymSearch( HANDLE, ULONG64, DWORD, DWORD, PCSTR, DWORD64, PSYM_ENUMERATESYMBOLS_CALLBACK, PVOID, DWORD );
BOOL IMAGEAPI               SymSearchW( HANDLE, ULONG64, DWORD, DWORD, PCWSTR, DWORD64, PSYM_ENUMERATESYMBOLS_CALLBACKW, PVOID, DWORD );
BOOL IMAGEAPI               SymSetContext( HANDLE, PIMAGEHLP_STACK_FRAME, PIMAGEHLP_CONTEXT );
PCHAR IMAGEAPI              SymSetHomeDirectory( HANDLE, PCSTR );
PWSTR IMAGEAPI              SymSetHomeDirectoryW( HANDLE, PCWSTR );
DWORD IMAGEAPI              SymSetOptions( DWORD );
BOOL IMAGEAPI               SymSetParentWindow( HWND );
BOOL IMAGEAPI               SymSetScopeFromAddr( HANDLE, ULONG64 );
BOOL IMAGEAPI               SymSetScopeFromIndex( HANDLE, ULONG64, DWORD );
BOOL IMAGEAPI               SymSetSearchPath( HANDLE, PCSTR );
BOOL IMAGEAPI               SymSetSearchPathW( HANDLE, PCWSTR );
PCSTR IMAGEAPI              SymSrvDeltaName( HANDLE, PCSTR, PCSTR, PCSTR, PCSTR );
PCWSTR IMAGEAPI             SymSrvDeltaNameW( HANDLE, PCWSTR, PCWSTR, PCWSTR, PCWSTR );
BOOL IMAGEAPI               SymSrvGetFileIndexInfo( PCSTR, PSYMSRV_INDEX_INFO, DWORD );
BOOL IMAGEAPI               SymSrvGetFileIndexInfoW( PCWSTR, PSYMSRV_INDEX_INFOW, DWORD );
BOOL IMAGEAPI               SymSrvGetFileIndexString( HANDLE, PCSTR, PCSTR, PSTR, size_t, DWORD );
BOOL IMAGEAPI               SymSrvGetFileIndexStringW( HANDLE, PCWSTR, PCWSTR, PWSTR, size_t, DWORD );
BOOL IMAGEAPI               SymSrvGetFileIndexes( PCSTR, GUID *, PDWORD, PDWORD, DWORD );
BOOL IMAGEAPI               SymSrvGetFileIndexesW( PCWSTR, GUID *, PDWORD, PDWORD, DWORD );
PCSTR IMAGEAPI              SymSrvGetSupplement( HANDLE, PCSTR, PCSTR, PCSTR );
PCWSTR IMAGEAPI             SymSrvGetSupplementW( HANDLE, PCWSTR, PCWSTR, PCWSTR );
BOOL IMAGEAPI               SymSrvIsStore( HANDLE, PCSTR );
BOOL IMAGEAPI               SymSrvIsStoreW( HANDLE, PCWSTR );
PCSTR IMAGEAPI              SymSrvStoreFile( HANDLE, PCSTR, PCSTR, DWORD );
PCWSTR IMAGEAPI             SymSrvStoreFileW( HANDLE, PCWSTR, PCWSTR, DWORD );
PCSTR IMAGEAPI              SymSrvStoreSupplement( HANDLE, PCSTR, PCSTR, PCSTR, DWORD );
PCWSTR IMAGEAPI             SymSrvStoreSupplementW( HANDLE, PCWSTR, PCWSTR, PCWSTR, DWORD );
BOOL IMAGEAPI               SymUnDName64( PIMAGEHLP_SYMBOL64, PSTR, DWORD );
BOOL IMAGEAPI               SymUnloadModule64( HANDLE, DWORD64 );
BOOL IMAGEAPI               TouchFileTimes( HANDLE, PSYSTEMTIME );
DWORD IMAGEAPI              UnDecorateSymbolName( PCSTR, PSTR, DWORD, DWORD );
DWORD IMAGEAPI              UnDecorateSymbolNameW( PCWSTR, PWSTR, DWORD, DWORD );
BOOL IMAGEAPI               UnMapAndLoad( PLOADED_IMAGE );
BOOL IMAGEAPI               UnmapDebugInformation( PIMAGE_DEBUG_INFORMATION );
BOOL IMAGEAPI               UpdateDebugInfoFile( PCSTR, PCSTR, PSTR, PIMAGE_NT_HEADERS32 );
BOOL IMAGEAPI               UpdateDebugInfoFileEx( PCSTR, PCSTR, PSTR, PIMAGE_NT_HEADERS32, DWORD );
#ifndef _IMAGEHLP64
BOOL IMAGEAPI               EnumerateLoadedModules( HANDLE, PENUMLOADED_MODULES_CALLBACK, PVOID );
BOOL IMAGEAPI               StackWalk( DWORD, HANDLE, HANDLE, LPSTACKFRAME, PVOID, PREAD_PROCESS_MEMORY_ROUTINE, PFUNCTION_TABLE_ACCESS_ROUTINE, PGET_MODULE_BASE_ROUTINE, PTRANSLATE_ADDRESS_ROUTINE );
BOOL IMAGEAPI               SymEnumerateModules( HANDLE, PSYM_ENUMMODULES_CALLBACK, PVOID );
BOOL IMAGEAPI               SymEnumerateSymbols( HANDLE, ULONG, PSYM_ENUMSYMBOLS_CALLBACK, PVOID );
BOOL IMAGEAPI               SymEnumerateSymbolsW( HANDLE, ULONG, PSYM_ENUMSYMBOLS_CALLBACKW, PVOID );
PVOID IMAGEAPI              SymFunctionTableAccess( HANDLE, DWORD );
BOOL IMAGEAPI               SymGetLineFromAddr( HANDLE, DWORD, PDWORD, PIMAGEHLP_LINE );
BOOL IMAGEAPI               SymGetLineFromName( HANDLE, PCSTR, PCSTR, DWORD, PLONG, PIMAGEHLP_LINE );
BOOL IMAGEAPI               SymGetLineNext( HANDLE, PIMAGEHLP_LINE );
BOOL IMAGEAPI               SymGetLinePrev( HANDLE, PIMAGEHLP_LINE );
DWORD IMAGEAPI              SymGetModuleBase( HANDLE, DWORD );
BOOL IMAGEAPI               SymGetModuleInfo( HANDLE, DWORD, PIMAGEHLP_MODULE );
BOOL IMAGEAPI               SymGetModuleInfoW( HANDLE, DWORD, PIMAGEHLP_MODULEW );
BOOL IMAGEAPI               SymGetSymFromAddr( HANDLE, DWORD, PDWORD, PIMAGEHLP_SYMBOL );
BOOL IMAGEAPI               SymGetSymFromName( HANDLE, PCSTR, PIMAGEHLP_SYMBOL );
BOOL IMAGEAPI               SymGetSymNext( HANDLE, PIMAGEHLP_SYMBOL );
BOOL IMAGEAPI               SymGetSymPrev( HANDLE, PIMAGEHLP_SYMBOL );
DWORD IMAGEAPI              SymLoadModule( HANDLE, HANDLE, PCSTR, PCSTR, DWORD, DWORD );
BOOL IMAGEAPI               SymRegisterCallback( HANDLE, PSYMBOL_REGISTERED_CALLBACK, PVOID );
BOOL IMAGEAPI               SymRegisterFunctionEntryCallback( HANDLE, PSYMBOL_FUNCENTRY_CALLBACK, PVOID );
BOOL IMAGEAPI               SymUnDName( PIMAGEHLP_SYMBOL, PSTR, DWORD );
BOOL IMAGEAPI               SymUnloadModule( HANDLE, DWORD );
#endif

/* Functions in DBGHELP.DLL */
BOOL WINAPI DbgHelpCreateUserDump( LPCSTR, PDBGHELP_CREATE_USER_DUMP_CALLBACK, PVOID );
BOOL WINAPI DbgHelpCreateUserDumpW( LPCWSTR, PDBGHELP_CREATE_USER_DUMP_CALLBACK, PVOID );
BOOL WINAPI MiniDumpReadDumpStream( PVOID, ULONG, PMINIDUMP_DIRECTORY *, PVOID *, ULONG * );
BOOL WINAPI MiniDumpWriteDump( HANDLE, DWORD, HANDLE, MINIDUMP_TYPE, PMINIDUMP_EXCEPTION_INFORMATION, PMINIDUMP_USER_STREAM_INFORMATION, PMINIDUMP_CALLBACK_INFORMATION );

/* Functions implemented as macros */
#ifndef _IMAGEHLP64
    #define Address32To64( p1, p2 ) \
        { \
            (p2)->Offset = (ULONG64)(LONG64)(LONG)((p1)->Offset); \
            (p2)->Segment = (p1)->Segment; \
            (p2)->Mode = (p1)->Mode; \
        }
    #define Address64To32( p1, p2 ) \
        { \
            (p2)->Offset = (ULONG)((p1)->Offset); \
            (p2)->Segment = (p1)->Segment; \
            (p2)->Mode = (p1)->Mode; \
        }
    #define KdHelp32To64( p1, p2 ) \
        { \
            (p2)->Thread = (p1)->Thread; \
            (p2)->ThCallbackStack = (p1)->ThCallbackStack; \
            (p2)->NextCallback = (p1)->NextCallback; \
            (p2)->FramePointer = (p1)->FramePointer; \
            (p2)->KiCallUserMode = (p1)->KiCallUserMode; \
            (p2)->KeUserCallbackDispatcher = (p1)->KeUserCallbackDispatcher; \
            (p2)->SystemRangeStart = (p1)->SystemRangeStart; \
            (p2)->KiUserExceptionDispatcher = (p1)->KiUserExceptionDispatcher; \
            (p2)->StackBase = (p1)->StackBase; \
            (p2)->StackLimit = (p1)->StackLimit; \
        }
#endif

/* Aliases for 64-bit image helper */
#ifdef _IMAGEHLP64
    #define StackWalk                           StackWalk64
    #define SymEnumerateLoadedModules           SymEnumerateLoadedModules64
    #define SymEnumerateModules                 SymEnumerateModules64
    #define SymEnumerateSymbols                 SymEnumerateSymbols64
    #define SymEnumerateSymbolsW                SymEnumerateSymbolsW64
    #define SymFunctionTableAccess              SymFunctionTableAccess64
    #define SymGetLineFromAddr                  SymGetLineFromAddr64
    #define SymGetLineFromAddrW                 SymGetLineFromAddrW64
    #define SymGetLineFromName                  SymGetLineFromName64
    #define SymGetLineNext                      SymGetLineNext64
    #define SymGetLinePrev                      SymGetLinePrev64
    #define SymGetModuleBase                    SymGetModuleBase64
    #define SymGetModuleInfo                    SymGetModuleInfo64
    #define SymGetModuleInfoW                   SymGetModuleInfoW64
    #define SymGetSymFromAddr                   SymGetSymFromAddr64
    #define SymGetSymFromName                   SymGetSymFromName64
    #define SymGetSymNext                       SymGetSymNext64
    #define SymGetSymPrev                       SymGetSymPrev64
    #define SymLoadModule                       SymLoadModule64
    #define SymRegisterCallback                 SymRegisterCallback64
    #define SymRegisterFunctionEntryCallback    SymRegisterFunctionEntryCallback64
    #define SymUnDName                          SymUnDName64
    #define SymUnloadModule                     SymUnloadModule64
#endif

/* Map generic function names to the appropriate ANSI or Unicode version. */
#ifdef UNICODE
    #define MapFileAndCheckSum          MapFileAndCheckSumW
#else
    #define MapFileAndCheckSum          MapFileAndCheckSumA
#endif
#ifdef DBGHELP_TRANSLATE_TCHAR
    #define EnumDirTree                 EnumDirTreeW
    #define EnumerateLoadedModules64    EnumerateLoadedModulesW64
    #define EnumerateLoadedModulesEx    EnumerateLoadedModulesExW
    #define FindDebugInfoFileEx         FindDebugInfoFileExW
    #define FindExecutableImageEx       FindExecutableImageExW
    #define SearchTreeForFile           SearchTreeForFileW
    #define SymAddSymbol                SymAddSymbolW
    #define SymDeleteSymbol             SymDeleteSymbolW
    #define SymEnumLines                SymEnumLinesW
    #define SymEnumSourceFiles          SymEnumSourceFilesW
    #define SymEnumSourceLines          SymEnumSourceLinesW
    #define SymEnumSymbols              SymEnumSymbolsW
    #define SymEnumSymbolsForAddr       SymEnumSymbolsForAddrW
    #define SymEnumTypes                SymEnumTypesW
    #define SymEnumTypesByName          SymEnumTypesByNameW
    #define SymEnumerateModules64       SymEnumerateModulesW64
    #define SymFindDebugInfoFile        SymFindDebugInfoFileW
    #define SymFindExecutableImage      SymFindExecutableImageW
    #define SymFindFileInPath           SymFindFileInPathW
    #define SymFromAddr                 SymFromAddrW
    #define SymFromIndex                SymFromIndexW
    #define SymFromName                 SymFromNameW
    #define SymFromToken                SymFromTokenW
    #define SymGetFileLineOffsets64     SymGetFileLineOffsetsW64
    #define SymGetHomeDirectory         SymGetHomeDirectoryW
    #define SymGetLineFromAddr64        SymGetLineFromAddrW64
    #define SymGetLineFromName64        SymGetLineFromNameW64
    #define SymGetLineNext64            SymGetLineNextW64
    #define SymGetLinePrev64            SymGetLinePrevW64
    #define SymGetModuleInfo64          SymGetModuleInfoW64
    #define SymGetScope                 SymGetScopeW
    #define SymGetSearchPath            SymGetSearchPathW
    #define SymGetSourceFile            SymGetSourceFileW
    #define SymGetSourceFileFromToken   SymGetSourceFileFromTokenW
    #define SymGetSourceFileToken       SymGetSourceFileTokenW
    #define SymGetSourceVarFromToken    SymGetSourceVarFromTokenW
    #define SymGetSymbolFile            SymGetSymbolFileW
    #define SymGetTypeFromName          SymGetTypeFromNameW
    #define SymInitialize               SymInitializeW
    #define SymLoadModuleEx             SymLoadModuleExW
    #define SymMatchFileName            SymMatchFileNameW
    #define SymMatchString              SymMatchStringW
    #define SymNext                     SymNextW
    #define SymPrev                     SymPrevW
    #define SymRegisterCallback64       SymRegisterCallbackW64
    #define SymSearch                   SymSearchW
    #define SymSetHomeDirectory         SymSetHomeDirectoryW
    #define SymSetSearchPath            SymSetSearchPathW
    #define SymSrvDeltaName             SymSrvDeltaNameW
    #define SymSrvGetFileIndexInfo      SymSrvGetFileIndexInfoW
    #define SymSrvGetFileIndexString    SymSrvGetFileIndexStringW
    #define SymSrvGetFileIndexes        SymSrvGetFileIndexesW
    #define SymSrvGetSupplement         SymSrvGetSupplementW
    #define SymSrvIsStore               SymSrvIsStoreW
    #define SymSrvStoreFile             SymSrvStoreFileW
    #define SymSrvStoreSupplement       SymSrvStoreSupplementW
    #define UnDecorateSymbolName        UnDecorateSymbolNameW
#endif

/* Map generic type names to the appropriate ANSI or Unicode version. */
#ifdef DBGHELP_TRANSLATE_TCHAR
    #define IMAGEHLP_LINE64                     IMAGEHLP_LINEW64
    #define PIMAGEHLP_LINE64                    PIMAGEHLP_LINEW64
    #define SYMBOL_INFO                         SYMBOL_INFOW
    #define PSYMBOL_INFO                        PSYMBOL_INFOW
    #define SYMBOL_INFO_PACKAGE                 SYMBOL_INFO_PACKAGEW
    #define PSYMBOL_INFO_PACKAGE                PSYMBOL_INFO_PACKAGEW
    #define FIND_EXE_FILE_CALLBACK              FIND_EXE_FILE_CALLBACKW
    #define PFIND_EXE_FILE_CALLBACK             PFIND_EXE_FILE_CALLBACKW
    #define SYM_ENUMERATESYMBOLS_CALLBACK       SYM_ENUMERATESYMBOLS_CALLBACKW
    #define PSYM_ENUMERATESYMBOLS_CALLBACK      PSYM_ENUMERATESYMBOLS_CALLBACKW
    #define SRCCODEINFO                         SRCCODEINFOW
    #define PSRCCODEINFO                        PSRCCODEINFOW
    #define SOURCEFILE                          SOURCEFILEW
    #define PSOURCEFILE                         PSOURCEFILEW
    #define SYM_ENUMSOURCEFILES_CALLBACK        SYM_ENUMSOURCEFILES_CALLBACKW
    #define PSYM_ENUMSOURCEFILES_CALLBACK       PSYM_ENUMSOURCEFILES_CALLBACKW
    #define IMAGEHLP_CBA_EVENT                  IMAGEHLP_CBA_EVENTW
    #define PIMAGEHLP_CBA_EVENT                 PIMAGEHLP_CBA_EVENTW
    #define PENUMDIRTREE_CALLBACK               PENUMDIRTREE_CALLBACKW
    #define IMAGEHLP_DEFERRED_SYMBOL_LOAD64     IMAGEHLP_DEFERRED_SYMBOL_LOADW64
    #define PIMAGEHLP_DEFERRED_SYMBOL_LOAD64    PIMAGEHLP_DEFERRED_SYMBOL_LOADW64
    #define PFIND_DEBUG_FILE_CALLBACK           PFIND_DEBUG_FILE_CALLBACKW
    #define PFINDFILEINPATHCALLBACK             PFINDFILEINPATHCALLBACKW
    #define IMAGEHLP_MODULE64                   IMAGEHLP_MODULEW64
    #define PIMAGEHLP_MODULE64                  PIMAGEHLP_MODULEW64
    #define SYMSRV_INDEX_INFO                   SYMSRV_INDEX_INFOW
    #define PSYMSRV_INDEX_INFO                  PSYMSRV_INDEX_INFOW
    #define PSYMBOLSERVERPROC                   PSYMBOLSERVERPROCW
    #define PSYMBOLSERVERPINGPROC               PSYMBOLSERVERPINGPROCW
#endif

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* _IMAGEHLP_ */
