/*
 *  guiddef.h   Globally unique identifier definitions
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2014 The Open Watcom Contributors. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file;
#endif

/* Macro used to specify extern "C" */
#ifdef __cplusplus
    #define EXTERN_C    extern "C"
#else
    #define EXTERN_C    extern
#endif

/* Macro to define a GUID */
#ifdef DEFINE_GUID
    #undef DEFINE_GUID
#endif
#ifdef INITGUID
    #define DEFINE_GUID( x, p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11 ) \
        EXTERN_C const GUID __cdecl x = { p1, p2, p3, { p4, p5, p6, p7, p8, p9, p10, p11 } }
#else
    #define DEFINE_GUID( x, p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11 ) \
        EXTERN_C const GUID __cdecl x
#endif

#ifndef _GUIDDEF_H_
#define _GUIDDEF_H_

#include <string.h>

/* Null values */
#define IID_NULL    GUID_NULL
#define CLSID_NULL  GUID_NULL
#define FMTID_NULL  GUID_NULL

/* Globally unique identifier */
#ifndef GUID_DEFINED
#define GUID_DEFINED
typedef struct _GUID {
    unsigned long   Data1;
    unsigned short  Data2;
    unsigned short  Data3;
    unsigned char   Data4[8];
} GUID;
#endif

#ifndef __LPGUID_DEFINED__
#define __LPGUID_DEFINED__
typedef GUID        *LPGUID;
#endif
#ifndef __LPCGUID_DEFINED__
#define __LPCGUID_DEFINED__
typedef const GUID  *LPCGUID;
#endif

/* Interface identifier */
typedef GUID    IID;
typedef IID     *LPIID;

/* Class identifier */
typedef GUID    CLSID;
typedef CLSID   *LPCLSID;

/* Format identifier */
typedef GUID    FMTID;
typedef FMTID   *LPFMTID;

/* Reference data types */
#ifdef __cplusplus
    #define REFGUID     const GUID &
    #define REFIID      const IID &
    #define REFCLSID    const CLSID &
    #define REFFMTID    const FMTID &
#else
    #define REFGUID     const GUID *const
    #define REFIID      const IID *const
    #define REFCLSID    const CLSID *const
    #define REFFMTID    const FMTID *const
#endif

/* Macro used to define a standard GUID */
#define DEFINE_OLEGUID( x, p1, p2, p3 ) \
    DEFINE_GUID( x, p1, p2, p3, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46 )

/* GUID comparison macros */
#ifndef __cplusplus
    #define IsEqualGUID( p1, p2 )   (!memcmp( p1, p2, sizeof( GUID ) ))
#endif
#define IsEqualIID( p1, p2 )        IsEqualGUID( p1, p2 )
#define IsEqualCLSID( p1, p2 )      IsEqualGUID( p1, p2 )
#define IsEqualFMTID( p1, p2 )      IsEqualGUID( p1, p2 )

#ifdef __cplusplus

__inline int IsEqualGUID( REFGUID p1, REFGUID p2 )
{
    return( !memcmp( &p1, &p2, sizeof( GUID ) ) );
}

__inline int operator==( REFGUID p1, REFGUID p2 )
{
    return( IsEqualGUID( p1, p2 ) );
}

__inline int operator!=( REFGUID p1, REFGUID p2 )
{
    return( !(p1 == p2) );
}

#endif /* __cplusplus */

#endif /* _GUIDDEF_H_ */
