/*
 *  evntrace.h  Event tracing functions
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2014 The Open Watcom Contributors. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */

#ifndef _EVNTRACE_
#define _EVNTRACE_

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file;
#endif

#ifdef __cplusplus
extern "C" {
#endif

/* Macro to specify WMI functions */
#define WMIAPI  DECLSPEC_IMPORT __stdcall

/* Primitive data types */
typedef ULONG64 TRACEHANDLE;
typedef ULONG64 *PTRACEHANDLE;

/* Logger names */
#define KERNEL_LOGGER_NAMEA     "NT Kernel Logger"
#define KERNEL_LOGGER_NAMEW     L"NT Kernel Logger"
#define GLOBAL_LOGGER_NAMEA     "GlobalLogger"
#define GLOBAL_LOGGER_NAMEW     L"GlobalLogger"
#define EVENT_LOGGER_NAMEA      "EventLog"
#define EVENT_LOGGER_NAMEW      L"EventLog"
#define DIAG_LOGGER_NAMEA       "DiagLog"
#define DIAG_LOGGER_NAMEW       L"DiagLog"
#ifdef UNICODE
    #define KERNEL_LOGGER_NAME  KERNEL_LOGGER_NAMEW
    #define GLOBAL_LOGGER_NAME  GLOBAL_LOGGER_NAMEW
    #define EVENT_LOGGER_NAME   EVENT_LOGGER_NAMEW
#else
    #define KERNEL_LOGGER_NAME  KERNEL_LOGGER_NAMEA
    #define GLOBAL_LOGGER_NAME  GLOBAL_LOGGER_NAMEA
    #define EVENT_LOGGER_NAME   EVENT_LOGGER_NAMEA
#endif

/* Maximum number of MOF fields */
#define MAX_MOF_FIELDS  16

/* System event type */
#define SYSTEM_EVENT_TYPE   1

/* Event trace types */
#define EVENT_TRACE_TYPE_INFO                   0x00
#define EVENT_TRACE_TYPE_START                  0x01
#define EVENT_TRACE_TYPE_END                    0x02
#define EVENT_TRACE_TYPE_STOP                   0x02
#define EVENT_TRACE_TYPE_DC_START               0x03
#define EVENT_TRACE_TYPE_DC_END                 0x04
#define EVENT_TRACE_TYPE_EXTENSION              0x05
#define EVENT_TRACE_TYPE_REPLY                  0x06
#define EVENT_TRACE_TYPE_DEQUEUE                0x07
#define EVENT_TRACE_TYPE_RESUME                 0x07
#define EVENT_TRACE_TYPE_CHECKPOINT             0x08
#define EVENT_TRACE_TYPE_SUSPEND                0x08
#define EVENT_TRACE_TYPE_WINEVT_SEND            0x09
#define EVENT_TRACE_TYPE_WINEVT_RECEIVE         0xF0
#define EVENT_TRACE_TYPE_LOAD                   0x0A
#define EVENT_TRACE_TYPE_IO_READ                0x0A
#define EVENT_TRACE_TYPE_IO_WRITE               0x0B
#define EVENT_TRACE_TYPE_IO_READ_INIT           0x0C
#define EVENT_TRACE_TYPE_IO_WRITE_INIT          0x0D
#define EVENT_TRACE_TYPE_IO_FLUSH               0x0E
#define EVENT_TRACE_TYPE_IO_FLUSH_INIT          0x0F
#define EVENT_TRACE_TYPE_MM_TF                  0x0A
#define EVENT_TRACE_TYPE_MM_DZF                 0x0B
#define EVENT_TRACE_TYPE_MM_COW                 0x0C
#define EVENT_TRACE_TYPE_MM_GPF                 0x0D
#define EVENT_TRACE_TYPE_MM_HPF                 0x0E
#define EVENT_TRACE_TYPE_MM_AV                  0x0F
#define EVENT_TRACE_TYPE_SEND                   0x0A
#define EVENT_TRACE_TYPE_RECEIVE                0x0B
#define EVENT_TRACE_TYPE_CONNECT                0x0C
#define EVENT_TRACE_TYPE_DISCONNECT             0x0D
#define EVENT_TRACE_TYPE_RETRANSMIT             0x0E
#define EVENT_TRACE_TYPE_ACCEPT                 0x0F
#define EVENT_TRACE_TYPE_RECONNECT              0x10
#define EVENT_TRACE_TYPE_CONNFAIL               0x11
#define EVENT_TRACE_TYPE_COPY_TCP               0x12
#define EVENT_TRACE_TYPE_COPY_ARP               0x13
#define EVENT_TRACE_TYPE_ACKFULL                0x14
#define EVENT_TRACE_TYPE_ACKPART                0x15
#define EVENT_TRACE_TYPE_ACKDUP                 0x16
#define EVENT_TRACE_TYPE_GUIDMAP                0x0A
#define EVENT_TRACE_TYPE_CONFIG                 0x0B
#define EVENT_TRACE_TYPE_SIDINFO                0x0C
#define EVENT_TRACE_TYPE_SECURITY               0x0D
#define EVENT_TRACE_TYPE_REGCREATE              0x0A
#define EVENT_TRACE_TYPE_REGOPEN                0x0B
#define EVENT_TRACE_TYPE_REGDELETE              0x0C
#define EVENT_TRACE_TYPE_REGQUERY               0x0D
#define EVENT_TRACE_TYPE_REGSETVALUE            0x0E
#define EVENT_TRACE_TYPE_REGDELETEVALUE         0x0F
#define EVENT_TRACE_TYPE_REGQUERYVALUE          0x10
#define EVENT_TRACE_TYPE_REGENUMERATEKEY        0x11
#define EVENT_TRACE_TYPE_REGENUMERATEVALUEKEY   0x12
#define EVENT_TRACE_TYPE_REGQUERYMULTIPLEVALUE  0x13
#define EVENT_TRACE_TYPE_REGSETINFORMATION      0x14
#define EVENT_TRACE_TYPE_REGFLUSH               0x15
#define EVENT_TRACE_TYPE_REGKCBCREATE           0x16
#define EVENT_TRACE_TYPE_REGKCBDELETE           0x17
#define EVENT_TRACE_TYPE_REGKCBRUNDOWNBEGIN     0x18
#define EVENT_TRACE_TYPE_REGKCBRUNDOWNEND       0x19
#define EVENT_TRACE_TYPE_REGVIRTUALIZE          0x1A
#define EVENT_TRACE_TYPE_REGCLOSE               0x1B
#define EVENT_TRACE_TYPE_REGSETSECURITY         0x1C
#define EVENT_TRACE_TYPE_REGQUERYSECURITY       0x1D
#define EVENT_TRACE_TYPE_REGCOMMIT              0x1E
#define EVENT_TRACE_TYPE_REGPREPARE             0x1F
#define EVENT_TRACE_TYPE_REGROLLBACK            0x20
#define EVENT_TRACE_TYPE_REGMOUNTHIVE           0x21
#define EVENT_TRACE_TYPE_CONFIG_CPU             0x0A
#define EVENT_TRACE_TYPE_CONFIG_PHYSICALDISK    0x0B
#define EVENT_TRACE_TYPE_CONFIG_LOGICALDISK     0x0C
#define EVENT_TRACE_TYPE_CONFIG_NIC             0x0D
#define EVENT_TRACE_TYPE_CONFIG_VIDEO           0x0E
#define EVENT_TRACE_TYPE_CONFIG_SERVICES        0x0F
#define EVENT_TRACE_TYPE_CONFIG_POWER           0x10
#define EVENT_TRACE_TYPE_CONFIG_NETINFO         0x11
#define EVENT_TRACE_TYPE_CONFIG_IRQ             0x15
#define EVENT_TRACE_TYPE_CONFIG_PNP             0x16
#define EVENT_TRACE_TYPE_CONFIG_IDECHANNEL      0x17
#define EVENT_TRACE_TYPE_CONFIG_PLATFORM        0x19

/* Trace levels */
#define TRACE_LEVEL_NONE        0
#define TRACE_LEVEL_CRITICAL    1
#define TRACE_LEVEL_FATAL       1
#define TRACE_LEVEL_ERROR       2
#define TRACE_LEVEL_WARNING     3
#define TRACE_LEVEL_INFORMATION 4
#define TRACE_LEVEL_VERBOSE     5

/* Event trace flags */
#define EVENT_TRACE_FLAG_PROCESS            0x00000001L
#define EVENT_TRACE_FLAG_THREAD             0x00000002L
#define EVENT_TRACE_FLAG_IMAGE_LOAD         0x00000004L
#define EVENT_TRACE_FLAG_PROCESS_COUNTERS   0x00000008L
#define EVENT_TRACE_FLAG_CSWITCH            0x00000010L
#define EVENT_TRACE_FLAG_DPC                0x00000020L
#define EVENT_TRACE_FLAG_INTERRUPT          0x00000040L
#define EVENT_TRACE_FLAG_SYSTEMCALL         0x00000080L
#define EVENT_TRACE_FLAG_DISK_IO            0x00000100L
#define EVENT_TRACE_FLAG_DISK_FILE_IO       0x00000200L
#define EVENT_TRACE_FLAG_DISK_IO_INIT       0x00000400L
#define EVENT_TRACE_FLAG_DISPATCHER         0x00000800L
#define EVENT_TRACE_FLAG_MEMORY_PAGE_FAULTS 0x00001000L
#define EVENT_TRACE_FLAG_MEMORY_HARD_FAULTS 0x00002000L
#define EVENT_TRACE_FLAG_VIRTUAL_ALLOC      0x00004000L
#define EVENT_TRACE_FLAG_NETWORK_TCPIP      0x00010000L
#define EVENT_TRACE_FLAG_REGISTRY           0x00020000L
#define EVENT_TRACE_FLAG_DBGPRINT           0x00040000L
#define EVENT_TRACE_FLAG_ALPC               0x00100000L
#define EVENT_TRACE_FLAG_SPLIT_IO           0x00200000L
#define EVENT_TRACE_FLAG_DRIVER             0x00800000L
#define EVENT_TRACE_FLAG_PROFILE            0x01000000L
#define EVENT_TRACE_FLAG_FILE_IO            0x02000000L
#define EVENT_TRACE_FLAG_FILE_IO_INIT       0x04000000L
#define EVENT_TRACE_FLAG_ENABLE_RESERVE     0x20000000L
#define EVENT_TRACE_FLAG_FORWARD_WMI        0x40000000L
#define EVENT_TRACE_FLAG_EXTENSION          0x80000000L

/* Event trace file modes */
#define EVENT_TRACE_FILE_MODE_NONE              0x00000000L
#define EVENT_TRACE_FILE_MODE_SEQUENTIAL        0x00000001L
#define EVENT_TRACE_FILE_MODE_CIRCULAR          0x00000002L
#define EVENT_TRACE_FILE_MODE_APPEND            0x00000004L
#define EVENT_TRACE_FILE_MODE_NEWFILE           0x00000008L
#define EVENT_TRACE_FILE_MODE_PREALLOCATE       0x00000020L
#define EVENT_TRACE_NONSTOPPABLE_MODE           0x00000040L
#define EVENT_TRACE_SECURE_MODE                 0x00000080L
#define EVENT_TRACE_REAL_TIME_MODE              0x00000100L
#define EVENT_TRACE_DELAY_OPEN_FILE_MODE        0x00000200L
#define EVENT_TRACE_BUFFERING_MODE              0x00000400L
#define EVENT_TRACE_PRIVATE_LOGGER_MODE         0x00000800L
#define EVENT_TRACE_ADD_HEADER_MODE             0x00001000L
#define EVENT_TRACE_USE_KBYTES_FOR_SIZE         0x00002000L
#define EVENT_TRACE_USE_GLOBAL_SEQUENCE         0x00004000L
#define EVENT_TRACE_USE_LOCAL_SEQUENCE          0x00008000L
#define EVENT_TRACE_RELOG_MODE                  0x00010000L
#define EVENT_TRACE_PRIVATE_IN_PROC             0x00020000L
#define EVENT_TRACE_USE_PAGED_MEMORY            0x01000000L
#define EVENT_TRACE_NO_PER_PROCESSOR_BUFFERING  0x10000000L

/* Event trace control codes */
#define EVENT_TRACE_CONTROL_QUERY   0
#define EVENT_TRACE_CONTROL_STOP    1
#define EVENT_TRACE_CONTROL_UPDATE  2
#define EVENT_TRACE_CONTROL_FLUSH   3

/* Trace message flags */
#define TRACE_MESSAGE_SEQUENCE              0x0001
#define TRACE_MESSAGE_GUID                  0x0002
#define TRACE_MESSAGE_COMPONENTID           0x0004
#define TRACE_MESSAGE_TIMESTAMP             0x0008
#define TRACE_MESSAGE_PERFORMANCE_TIMESTAMP 0x0010
#define TRACE_MESSAGE_SYSTEMINFO            0x0020
#define TRACE_MESSAGE_POINTER32             0x0040
#define TRACE_MESSAGE_POINTER64             0x0080
#define TRACE_MESSAGE_FLAG_MASK             0xFFFF

/* Trace message maximum size */
#define TRACE_MESSAGE_MAXIMUM_SIZE  8192

/* Event trace header field type flags */
#define EVENT_TRACE_USE_PROCTIME    0x0001
#define EVENT_TRACE_USE_NOCPUTIME   0x0002

/* Trace header flags */
#define TRACE_HEADER_FLAG_USE_TIMESTAMP 0x00000200L
#define TRACE_HEADER_FLAG_TRACED_GUID   0x00020000L
#define TRACE_HEADER_FLAG_LOG_WNODE     0x00040000L
#define TRACE_HEADER_FLAG_USE_GUID_PTR  0x00080000L
#define TRACE_HEADER_FLAG_USE_MOF_PTR   0x00100000L

/* Event tracing data types */
#define ETW_NULL_TYPE_VALUE                         0
#define ETW_OBJECT_TYPE_VALUE                       1
#define ETW_STRING_TYPE_VALUE                       2
#define ETW_SBYTE_TYPE_VALUE                        3
#define ETW_BYTE_TYPE_VALUE                         4
#define ETW_INT16_TYPE_VALUE                        5
#define ETW_UINT16_TYPE_VALUE                       6
#define ETW_INT32_TYPE_VALUE                        7
#define ETW_UINT32_TYPE_VALUE                       8
#define ETW_INT64_TYPE_VALUE                        9
#define ETW_UINT64_TYPE_VALUE                       10
#define ETW_CHAR_TYPE_VALUE                         11
#define ETW_SINGLE_TYPE_VALUE                       12
#define ETW_DOUBLE_TYPE_VALUE                       13
#define ETW_BOOLEAN_TYPE_VALUE                      14
#define ETW_DECIMAL_TYPE_VALUE                      15
#define ETW_GUID_TYPE_VALUE                         101
#define ETW_ASCIICHAR_TYPE_VALUE                    102
#define ETW_ASCIISTRING_TYPE_VALUE                  103
#define ETW_COUNTED_STRING_TYPE_VALUE               104
#define ETW_POINTER_TYPE_VALUE                      105
#define ETW_SIZET_TYPE_VALUE                        106
#define ETW_HIDDEN_TYPE_VALUE                       107
#define ETW_BOOL_TYPE_VALUE                         108
#define ETW_COUNTED_ANSISTRING_TYPE_VALUE           109
#define ETW_REVERSED_COUNTED_STRING_TYPE_VALUE      110
#define ETW_REVERSED_COUNTED_ANSISTRING_TYPE_VALUE  111
#define ETW_NON_NULL_TERMINATED_STRING_TYPE_VALUE   112
#define ETW_REDUCED_ANSISTRING_TYPE_VALUE           113
#define ETW_REDUCED_STRING_TYPE_VALUE               114
#define ETW_SID_TYPE_VALUE                          115
#define ETW_VARIANT_TYPE_VALUE                      116
#define ETW_PTVECTOR_TYPE_VALUE                     117
#define ETW_WMITIME_TYPE_VALUE                      118
#define ETW_DATETIME_TYPE_VALUE                     119
#define ETW_REFRENCE_TYPE_VALUE                     120

/* Trace provider flags */
#define TRACE_PROVIDER_FLAG_LEGACY      0x00000001L
#define TRACE_PROVIDER_FLAG_PRE_ENABLE  0x00000002L

/* Event control codes */
#define EVENT_CONTROL_CODE_DISABLE_PROVIDER 0
#define EVENT_CONTROL_CODE_ENABLE_PROVIDER  1
#define EVENT_CONTROL_CODE_CAPTURE_STATE    2

/* Event trace parameters version number */
#ifndef _WDMDDK_
    #define EVENT_TRACE_PARAMETERS_VERSION  1L
#endif

/* Trace handle special value */
#ifndef _WDMDDK_
    #define INVALID_PROCESSTRACE_HANDLE ((TRACEHANDLE)INVALID_HANDLE_VALUE)
#endif

/* Opaque data types */
#ifndef _WDMDDK_
typedef struct _EVENT_FILTER_DESCRIPTOR EVENT_FILTER_DESCRIPTOR;
typedef struct _EVENT_FILTER_DESCRIPTOR *PEVENT_FILTER_DESCRIPTOR;
#endif

/* Event trace header */
typedef struct _EVENT_TRACE_HEADER {
    USHORT          Size;
    union {
        USHORT  FieldTypeFlags;
        struct {
            UCHAR   HeaderType;
            UCHAR   MarkerFlags;
        };
    };
    union {
        ULONG   Version;
        struct {
            UCHAR   Type;
            UCHAR   Level;
            USHORT  Version;
        } Class;
    };
    ULONG           ThreadId;
    ULONG           ProcessId;
    LARGE_INTEGER   TimeStamp;
    union {
        GUID        Guid;
        ULONGLONG   GuidPtr;
    };
    union {
        struct {
            ULONG   KernelTime;
            ULONG   UserTime;
        };
        ULONG64 ProcessorTime;
        struct {
            ULONG   ClientContext;
            ULONG   Flags;
        };
    };
} EVENT_TRACE_HEADER;
typedef EVENT_TRACE_HEADER  *PEVENT_TRACE_HEADER;

/* Event instance header */
typedef struct _EVENT_INSTANCE_HEADER {
    USHORT          Size;
    union {
        USHORT  FieldTypeFlags;
        struct {
            UCHAR   HeaderType;
            UCHAR   MarkerFlags;
        };
    };
    union {
        ULONG   Version;
        struct {
            UCHAR   Type;
            UCHAR   Level;
            USHORT  Version;
        } Class;
    };
    ULONG           ThreadId;
    ULONG           ProcessId;
    LARGE_INTEGER   TimeStamp;
    ULONGLONG       RegHandle;
    ULONG           InstanceId;
    ULONG           ParentInstanceId;
    union {
        struct {
            ULONG   KernelTime;
            ULONG   UserTime;
        };
        ULONG64 ProcessorTime;
        struct {
            ULONG   EventId;
            ULONG   Flags;
        };
    };
    ULONGLONG       ParentRegHandle;
} EVENT_INSTANCE_HEADER;
typedef EVENT_INSTANCE_HEADER   *PEVENT_INSTANCE_HEADER;

/* MOF field */
typedef struct _MOF_FIELD {
    ULONG64 DataPtr;
    ULONG   Length;
    ULONG   DataType;
} MOF_FIELD;
typedef MOF_FIELD   *PMOF_FIELD;

/* Macro to define an MOF field */
#define DEFINE_TRACE_MOF_FIELD( x, p1, p2, p3 ) \
    (x)->DataPtr = (ULONG64)(ULONG_PTR)(p1); \
    (x)->Length = (ULONG)(p2); \
    (x)->DataType = (ULONG)(p3);

/* Trace log file header */
#ifndef _WDMDDK_
typedef struct _TRACE_LOGFILE_HEADER {
    ULONG           BufferSize;
    union {
        ULONG   Version;
        struct {
            UCHAR   MajorVersion;
            UCHAR   MinorVersion;
            UCHAR   SubVersion;
            UCHAR   SubMinorVersion;
        } VersionDetail;
    };
    ULONG           ProviderVersion;
    ULONG           NumberOfProcessors;
    LARGE_INTEGER   EndTime;
    ULONG           TimerResolution;
    ULONG           MaximumFileSize;
    ULONG           LogFileMode;
    ULONG           BuffersWritten;
    union {
        GUID    LogInstanceGuid;
        struct {
            ULONG   StartBuffers;
            ULONG   PointerSize;
            ULONG   EventsLost;
            ULONG   CpuSpeedInMHz;
        };
    };
    LPWSTR          LoggerName;
    LPWSTR          LogFileName;
    TIME_ZONE_INFORMATION   TimeZone;
    LARGE_INTEGER   BootTime;
    LARGE_INTEGER   PerfFreq;
    LARGE_INTEGER   StartTime;
    ULONG           ReservedFlags;
    ULONG           BuffersLost;
} TRACE_LOGFILE_HEADER;
typedef TRACE_LOGFILE_HEADER    *PTRACE_LOGFILE_HEADER;
#endif

/* Trace log file header (32-bit version) */
#ifndef _WDMDDK_
typedef struct _TRACE_LOGFILE_HEADER32 {
    ULONG           BufferSize;
    union {
        ULONG   Version;
        struct {
            UCHAR   MajorVersion;
            UCHAR   MinorVersion;
            UCHAR   SubVersion;
            UCHAR   SubMinorVersion;
        } VersionDetail;
    };
    ULONG           ProviderVersion;
    ULONG           NumberOfProcessors;
    LARGE_INTEGER   EndTime;
    ULONG           TimerResolution;
    ULONG           MaximumFileSize;
    ULONG           LogFileMode;
    ULONG           BuffersWritten;
    union {
        GUID    LogInstanceGuid;
        struct {
            ULONG   StartBuffers;
            ULONG   PointerSize;
            ULONG   EventsLost;
            ULONG   CpuSpeedInMHz;
        };
    };
    ULONG32         LoggerName;
    ULONG32         LogFileName;
    TIME_ZONE_INFORMATION   TimeZone;
    LARGE_INTEGER   BootTime;
    LARGE_INTEGER   PerfFreq;
    LARGE_INTEGER   StartTime;
    ULONG           ReservedFlags;
    ULONG           BuffersLost;
} TRACE_LOGFILE_HEADER32;
typedef TRACE_LOGFILE_HEADER32  *PTRACE_LOGFILE_HEADER32;
#endif

/* Trace log file header (64-bit version) */
#ifndef _WDMDDK_
typedef struct _TRACE_LOGFILE_HEADER64 {
    ULONG           BufferSize;
    union {
        ULONG   Version;
        struct {
            UCHAR   MajorVersion;
            UCHAR   MinorVersion;
            UCHAR   SubVersion;
            UCHAR   SubMinorVersion;
        } VersionDetail;
    };
    ULONG           ProviderVersion;
    ULONG           NumberOfProcessors;
    LARGE_INTEGER   EndTime;
    ULONG           TimerResolution;
    ULONG           MaximumFileSize;
    ULONG           LogFileMode;
    ULONG           BuffersWritten;
    union {
        GUID    LogInstanceGuid;
        struct {
            ULONG   StartBuffers;
            ULONG   PointerSize;
            ULONG   EventsLost;
            ULONG   CpuSpeedInMHz;
        };
    };
    ULONG64         LoggerName;
    ULONG64         LogFileName;
    TIME_ZONE_INFORMATION   TimeZone;
    LARGE_INTEGER   BootTime;
    LARGE_INTEGER   PerfFreq;
    LARGE_INTEGER   StartTime;
    ULONG           ReservedFlags;
    ULONG           BuffersLost;
} TRACE_LOGFILE_HEADER64;
typedef TRACE_LOGFILE_HEADER64  *PTRACE_LOGFILE_HEADER64;
#endif

/* Event instance information */
typedef struct EVENT_INSTANCE_INFO {
    HANDLE  RegHandle;
    ULONG   InstanceId;
} EVENT_INSTANCE_INFO;
typedef EVENT_INSTANCE_INFO *PEVENT_INSTANCE_INFO;

/* Event trace properties */
#ifndef _WDMDDK_
typedef struct _EVENT_TRACE_PROPERTIES {
    WNODE_HEADER    Wnode;
    ULONG           BufferSize;
    ULONG           MinimumBuffers;
    ULONG           MaximumBuffers;
    ULONG           MaximumFileSize;
    ULONG           LogFileMode;
    ULONG           FlushTimer;
    ULONG           EnableFlags;
    LONG            AgeLimit;
    ULONG           NumberOfBuffers;
    ULONG           FreeBuffers;
    ULONG           EventsLost;
    ULONG           BuffersWritten;
    ULONG           LogBuffersLost;
    ULONG           RealTimeBuffersLost;
    HANDLE          LoggerThreadId;
    ULONG           LogFileNameOffset;
    ULONG           LoggerNameOffset;
} EVENT_TRACE_PROPERTIES;
typedef EVENT_TRACE_PROPERTIES  *PEVENT_TRACE_PROPERTIES;
#endif

/* Trace GUID registration */
#ifndef _WDMDDK_
typedef struct _TRACE_GUID_REGISTRATION {
    LPCGUID Guid;
    HANDLE  RegHandle;
} TRACE_GUID_REGISTRATION;
typedef TRACE_GUID_REGISTRATION *PTRACE_GUID_REGISTRATION;
#endif

/* Trace GUID properties */
typedef struct _TRACE_GUID_PROPERTIES {
    GUID    Guid;
    ULONG   GuidType;
    ULONG   LoggerId;
    ULONG   EnableLevel;
    ULONG   EnableFlags;
    BOOLEAN IsEnable;
} TRACE_GUID_PROPERTIES;
typedef TRACE_GUID_PROPERTIES   *PTRACE_GUID_PROPERTIES;

/* Event tracing buffer context */
typedef struct _ETW_BUFFER_CONTEXT {
    UCHAR   ProcessorNumber;
    UCHAR   Alignment;
    USHORT  LoggerId;
} ETW_BUFFER_CONTEXT;
typedef ETW_BUFFER_CONTEXT  *PETW_BUFFER_CONTEXT;

/* Trace enable information */
typedef struct _TRACE_ENABLE_INFO {
    ULONG       IsEnabled;
    UCHAR       Level;
    UCHAR       Reserved1;
    USHORT      LoggerId;
    ULONG       EnableProperty;
    ULONG       Reserved2;
    ULONGLONG   MatchAnyKeyword;
    ULONGLONG   MatchAllKeyword;
} TRACE_ENABLE_INFO;
typedef TRACE_ENABLE_INFO   *PTRACE_ENABLE_INFO;

/* Trace provider instance information */
typedef struct _TRACE_PROVIDER_INSTANCE_INFO {
    ULONG   NextOffset;
    ULONG   EnableCount;
    ULONG   Pid;
    ULONG   Flags;
} TRACE_PROVIDER_INSTANCE_INFO;
typedef TRACE_PROVIDER_INSTANCE_INFO    *PTRACE_PROVIDER_INSTANCE_INFO;

/* Trace GUID information */
typedef struct _TRACE_GUID_INFO {
    ULONG   InstanceCount;
    ULONG   Reserved;
} TRACE_GUID_INFO;
typedef TRACE_GUID_INFO *PTRACE_GUID_INFO;

/* Event trace */
typedef struct _EVENT_TRACE {
    EVENT_TRACE_HEADER  Header;
    ULONG               InstanceId;
    ULONG               ParentInstanceId;
    GUID                ParentGuid;
    PVOID               MofData;
    ULONG               MofLength;
    union {
        ULONG               ClientContext;
        ETW_BUFFER_CONTEXT  BufferContext;
    };
} EVENT_TRACE;
typedef EVENT_TRACE *PEVENT_TRACE;

/* Event tracing callbacks */
#ifndef _WDMDDK_
typedef ULONG (WINAPI *PEVENT_TRACE_BUFFER_CALLBACKA)( struct _EVENT_TRACE_LOGFILEA * );
typedef ULONG (WINAPI *PEVENT_TRACE_BUFFER_CALLBACKW)( struct _EVENT_TRACE_LOGFILEW * );
typedef VOID (WINAPI *PEVENT_CALLBACK)( PEVENT_TRACE );
typedef VOID (WINAPI *PEVENT_RECORD_CALLBACK)( struct _EVENT_RECORD * );
typedef ULONG (WINAPI *WMIDPREQUEST)( WMIDPREQUESTCODE, PVOID, ULONG *, PVOID );
#ifdef UNICODE
typedef PEVENT_TRACE_BUFFER_CALLBACKW   PEVENT_TRACE_BUFFER_CALLBACK;
#else
typedef PEVENT_TRACE_BUFFER_CALLBACKA   PEVENT_TRACE_BUFFER_CALLBACK;
#endif
#endif

/* Event trace log file */
#ifndef _WDMDDK_
typedef struct _EVENT_TRACE_LOGFILEA {
    LPSTR                           LogFileName;
    LPSTR                           LoggerName;
    LONGLONG                        CurrentTime;
    ULONG                           BuffersRead;
    union {
        ULONG   LogFileMode;
        ULONG   ProcessTraceMode;
    };
    EVENT_TRACE                     CurrentEvent;
    TRACE_LOGFILE_HEADER            LogfileHeader;
    PEVENT_TRACE_BUFFER_CALLBACKA   BufferCallback;
    ULONG                           BufferSize;
    ULONG                           Filled;
    ULONG                           EventsLost;
    union {
        PEVENT_CALLBACK         EventCallback;
        PEVENT_RECORD_CALLBACK  EventRecordCallback;
    };
    ULONG                           IsKernelTrace;
    PVOID                           Context;
} EVENT_TRACE_LOGFILEA;
typedef EVENT_TRACE_LOGFILEA    *PEVENT_TRACE_LOGFILEA;
typedef struct _EVENT_TRACE_LOGFILEW {
    LPWSTR                          LogFileName;
    LPWSTR                          LoggerName;
    LONGLONG                        CurrentTime;
    ULONG                           BuffersRead;
    union {
        ULONG   LogFileMode;
        ULONG   ProcessTraceMode;
    };
    EVENT_TRACE                     CurrentEvent;
    TRACE_LOGFILE_HEADER            LogfileHeader;
    PEVENT_TRACE_BUFFER_CALLBACKW   BufferCallback;
    ULONG                           BufferSize;
    ULONG                           Filled;
    ULONG                           EventsLost;
    union {
        PEVENT_CALLBACK         EventCallback;
        PEVENT_RECORD_CALLBACK  EventRecordCallback;
    };
    ULONG                           IsKernelTrace;
    PVOID                           Context;
} EVENT_TRACE_LOGFILEW;
typedef EVENT_TRACE_LOGFILEW    *PEVENT_TRACE_LOGFILEW;
#ifdef UNICODE
typedef EVENT_TRACE_LOGFILEW    EVENT_TRACE_LOGFILE;
typedef PEVENT_TRACE_LOGFILEW   PEVENT_TRACE_LOGFILE;
#else
typedef EVENT_TRACE_LOGFILEA    EVENT_TRACE_LOGFILE;
typedef PEVENT_TRACE_LOGFILEA   PEVENT_TRACE_LOGFILE;
#endif
#endif

/* EnableTraceEx2() parameters */
#ifndef _WDMDDK_
typedef struct _ENABLE_TRACE_PARAMETERS {
    ULONG                   Version;
    ULONG                   EnableProperty;
    ULONG                   ControlFlags;
    GUID                    SourceId;
    PEVENT_FILTER_DESCRIPTOR    EnableFilterDesc;
} ENABLE_TRACE_PARAMETERS;
typedef ENABLE_TRACE_PARAMETERS *PENABLE_TRACE_PARAMETERS;
#endif

/* Trace query information classes */
#ifndef _WDMDDK_
typedef enum _TRACE_QUERY_INFO_CLASS {
    TraceGuidQueryList      = 0,
    TraceGuidQueryInfo      = 1,
    TraceGuidQueryProcess   = 2,
    TraceStackTracingInfo   = 3,
    MaxTraceSetInfoClass    = 4
} TRACE_QUERY_INFO_CLASS;
#endif

/* Classic event identifier */
#ifndef _WDMDDK_
typedef struct _CLASSIC_EVENT_ID {
    GUID    EventGuid;
    UCHAR   Type;
    UCHAR   Reserved[7];
} CLASSIC_EVENT_ID;
typedef CLASSIC_EVENT_ID    *PCLASSIC_EVENT_ID;
#endif

/* Functions in ADVAPI32.DLL */
#ifndef _WDMDDK_
EXTERN_C ULONG WMIAPI   CloseTrace( TRACEHANDLE );
EXTERN_C ULONG WMIAPI   ControlTraceA( TRACEHANDLE, LPCSTR, PEVENT_TRACE_PROPERTIES, ULONG );
EXTERN_C ULONG WMIAPI   ControlTraceW( TRACEHANDLE, LPCWSTR, PEVENT_TRACE_PROPERTIES, ULONG );
EXTERN_C ULONG WMIAPI   CreateTraceInstanceId( HANDLE, PEVENT_INSTANCE_INFO );
EXTERN_C ULONG WMIAPI   EnableTrace( ULONG, ULONG, ULONG, LPCGUID, TRACEHANDLE );
EXTERN_C ULONG WMIAPI   GetTraceEnableFlags( TRACEHANDLE );
EXTERN_C UCHAR WMIAPI   GetTraceEnableLevel( TRACEHANDLE );
EXTERN_C TRACEHANDLE WMIAPI GetTraceLoggerHandle( PVOID );
EXTERN_C TRACEHANDLE WMIAPI OpenTraceA( PEVENT_TRACE_LOGFILEA );
EXTERN_C TRACEHANDLE WMIAPI OpenTraceW( PEVENT_TRACE_LOGFILEW );
EXTERN_C ULONG WMIAPI   ProcessTrace( PTRACEHANDLE, ULONG, LPFILETIME, LPFILETIME );
EXTERN_C ULONG WMIAPI   QueryAllTracesA( PEVENT_TRACE_PROPERTIES *, ULONG, PULONG );
EXTERN_C ULONG WMIAPI   QueryAllTracesW( PEVENT_TRACE_PROPERTIES *, ULONG, PULONG );
EXTERN_C ULONG WMIAPI   QueryTraceA( TRACEHANDLE, LPCSTR, PEVENT_TRACE_PROPERTIES );
EXTERN_C ULONG WMIAPI   QueryTraceW( TRACEHANDLE, LPCWSTR, PEVENT_TRACE_PROPERTIES );
EXTERN_C ULONG WMIAPI   RegisterTraceGuidsA( WMIDPREQUEST, PVOID, LPCGUID, ULONG, PTRACE_GUID_REGISTRATION, LPCSTR, LPCSTR, PTRACEHANDLE );
EXTERN_C ULONG WMIAPI   RegisterTraceGuidsW( WMIDPREQUEST, PVOID, LPCGUID, ULONG, PTRACE_GUID_REGISTRATION, LPCWSTR, LPCWSTR, PTRACEHANDLE );
EXTERN_C ULONG WMIAPI   RemoveTraceCallback( LPCGUID );
EXTERN_C ULONG WMIAPI   SetTraceCallback( LPCGUID, PEVENT_CALLBACK );
EXTERN_C ULONG WMIAPI   StartTraceA( PTRACEHANDLE, LPCSTR, PEVENT_TRACE_PROPERTIES );
EXTERN_C ULONG WMIAPI   StartTraceW( PTRACEHANDLE, LPCWSTR, PEVENT_TRACE_PROPERTIES );
EXTERN_C ULONG WMIAPI   StopTraceA( TRACEHANDLE, LPCSTR, PEVENT_TRACE_PROPERTIES );
EXTERN_C ULONG WMIAPI   StopTraceW( TRACEHANDLE, LPCWSTR, PEVENT_TRACE_PROPERTIES );
EXTERN_C ULONG WMIAPI   TraceEvent( TRACEHANDLE, PEVENT_TRACE_HEADER );
EXTERN_C ULONG WMIAPI   TraceEventInstance( TRACEHANDLE, PEVENT_INSTANCE_HEADER, PEVENT_INSTANCE_INFO, PEVENT_INSTANCE_INFO );
EXTERN_C ULONG __cdecl  TraceMessage( TRACEHANDLE, ULONG, LPCGUID, USHORT, ... );
EXTERN_C ULONG WMIAPI   TraceMessageVa( TRACEHANDLE, ULONG, LPCGUID, USHORT, void * );
EXTERN_C ULONG WMIAPI   UnregisterTraceGuids( TRACEHANDLE );
EXTERN_C ULONG WMIAPI   UpdateTraceA( TRACEHANDLE, LPCSTR, PEVENT_TRACE_PROPERTIES );
EXTERN_C ULONG WMIAPI   UpdateTraceW( TRACEHANDLE, LPCWSTR, PEVENT_TRACE_PROPERTIES );
#if (WINVER >= 0x0501)
EXTERN_C ULONG WMIAPI   EnumerateTraceGuids( PTRACE_GUID_PROPERTIES *, ULONG, PULONG );
EXTERN_C ULONG WMIAPI   FlushTraceA( TRACEHANDLE, LPCSTR, PEVENT_TRACE_PROPERTIES );
EXTERN_C ULONG WMIAPI   FlushTraceW( TRACEHANDLE, LPCWSTR, PEVENT_TRACE_PROPERTIES );
#endif
#if (WINVER >= 0x0600)
EXTERN_C ULONG WMIAPI   EnableTraceEx( LPCGUID, LPCGUID, TRACEHANDLE, ULONG, UCHAR, ULONGLONG, ULONGLONG, ULONG, PEVENT_FILTER_DESCRIPTOR );
EXTERN_C ULONG WMIAPI   EnumerateTraceGuidsEx( TRACE_QUERY_INFO_CLASS, PVOID, ULONG, PVOID, ULONG, PULONG );
#endif
#if (WINVER >= 0x0601)
EXTERN_C ULONG WMIAPI   EnableTraceEx2( TRACEHANDLE, LPCGUID, ULONG, UCHAR, ULONGLONG, ULONGLONG, ULONG, PENABLE_TRACE_PARAMETERS );
EXTERN_C ULONG WMIAPI   TraceSetInformation( TRACEHANDLE, TRACE_INFO_CLASS, PVOID, ULONG );
#endif
#endif

/* Microsoft defines va_list differently from Open Watcom, so it must be indexed
 * before being passed to any Win32 API functions.
 */
#define TraceMessageVa( p1, p2, p3, p4, p5 )    TraceMessageVa( p1, p2, p3, p4, (p5)[0] )

/* Map generic function names to the appropriate ANSI or Unicode version. */
#ifndef _WDMDDK_
    #ifdef UNICODE
        #define ControlTrace        ControlTraceW
        #define OpenTrace           OpenTraceW
        #define QueryAllTraces      QueryAllTracesW
        #define QueryTrace          QueryTraceW
        #define RegisterTraceGuids  RegisterTraceGuidsW
        #define StartTrace          StartTraceW
        #define StopTrace           StopTraceW
        #define UpdateTrace         UpdateTraceW
        #if (NTDDI_VERSION >= 0x05010000)
            #define FlushTrace      FlushTraceW
        #endif
    #else
        #define ControlTrace        ControlTraceA
        #define OpenTrace           OpenTraceA
        #define QueryAllTraces      QueryAllTracesA
        #define QueryTrace          QueryTraceA
        #define RegisterTraceGuids  RegisterTraceGuidsA
        #define StartTrace          StartTraceA
        #define StopTrace           StopTraceA
        #define UpdateTrace         UpdateTraceA
        #if (NTDDI_VERSION >= 0x05010000)
            #define FlushTrace      FlushTraceA
        #endif
    #endif
#endif

#ifdef __cplusplus
} /* extern "C" */
#endif

/* GUIDs */
EXTERN_C const GUID __cdecl EventTraceGuid;
EXTERN_C const GUID __cdecl SystemTraceControlGuid;
EXTERN_C const GUID __cdecl EventTraceConfigGuid;
EXTERN_C const GUID __cdecl DefaultTraceSecurityGuid;

#endif /* _EVNTRACE_ */
