/*
 *  dsquery.h   Directory Service query definitions
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2014 The Open Watcom Contributors. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */

#ifndef __dsquery_h
#define __dsquery_h

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file;
#endif

#ifdef __cplusplus
extern "C" {
#endif

/* Directory Service query initialization parameter flags */
#define DSQPF_NOSAVE                    0x00000001L
#define DSQPF_SAVELOCATION              0x00000002L
#define DSQPF_SHOWHIDDENOBJECTS         0x00000004L
#define DSQPF_ENABLEADMINFEATURES       0x00000008L
#define DSQPF_ENABLEADVANCEDFEATURES    0x00000010L
#define DSQPF_HASCREDENTIALS            0x00000020L
#define DSQPF_NOCHOOSECOLUMNS           0x00000040L

/* Directory Service clipboard format strings */
#define CFSTR_DSQUERYPARAMS TEXT("DsQueryParameters")
#define CFSTR_DSQUERYSCOPE  TEXT("DsQueryScope")

/* Directory Service column properties */
#define DSCOLUMNPROP_ADSPATH        (-1L)
#define DSCOLUMNPROP_OBJECTCLASS    (-2L)

/* Directory Service query provider messages */
#define DSQPM_GETCLASSLIST  (CQPM_HANDLERSPECIFIC + 0)
#define DSQPM_HELPTOPICS    (CQPM_HANDLERSPECIFIC + 1)

/* Directory Service query initialization parameters */
typedef struct {
    DWORD   cbStruct;
    DWORD   dwFlags;
    LPWSTR  pDefaultScope;
    LPWSTR  pDefaultSaveLocation;
    LPWSTR  pUserName;
    LPWSTR  pPassword;
    LPWSTR  pServer;
} DSQUERYINITPARAMS;
typedef DSQUERYINITPARAMS   *LPDSQUERYINITPARAMS;

/* Directory Service column */
typedef struct {
    DWORD   dwFlags;
    INT     fmt;
    INT     cx;
    INT     idsName;
    LONG    offsetProperty;
    DWORD   dwReserved;
} DSCOLUMN;
typedef DSCOLUMN    *LPDSCOLUMN;

/* Directory Service query parameters */
typedef struct {
    DWORD       cbStruct;
    DWORD       dwFlags;
    HINSTANCE   hInstance;
    LONG        offsetQuery;
    LONG        iColumns;
    DWORD       dwReserved;
    DSCOLUMN    aColumns[1];
} DSQUERYPARAMS;
typedef DSQUERYPARAMS   *LPDSQUERYPARAMS;

/* Directory Service query class list */
typedef struct {
    DWORD   cbStruct;
    LONG    cClasses;
    DWORD   offsetClass[1];
} DSQUERYCLASSLIST;
typedef DSQUERYCLASSLIST    *LPDSQUERYCLASSINIT;

#ifdef __cplusplus
} /* extern "C" */
#endif

/* GUIDs */
EXTERN_C const CLSID    __cdecl CLSID_DsQuery;
EXTERN_C const CLSID    __cdecl CLSID_DsFindObjects;
EXTERN_C const CLSID    __cdecl CLSID_DsFindPeople;
EXTERN_C const CLSID    __cdecl CLSID_DsFindPrinter;
EXTERN_C const CLSID    __cdecl CLSID_DsFindComputer;
EXTERN_C const CLSID    __cdecl CLSID_DsFindVolume;
EXTERN_C const CLSID    __cdecl CLSID_DsFindContainer;
EXTERN_C const CLSID    __cdecl CLSID_DsFindAdvanced;
EXTERN_C const CLSID    __cdecl CLSID_DsFindDomainController;
EXTERN_C const CLSID    __cdecl CLSID_DsFindWriteableDomainController;
EXTERN_C const CLSID    __cdecl CLSID_DsFindFrsMembers;

#endif /* __dsquery_h */
