/*
 *  ntddtape.h  Tape device I/O control codes
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2014 The Open Watcom Contributors. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */

#ifndef _NTDDTAPE_
#define _NTDDTAPE_

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file;
#endif

#include <ntddstor.h>

#ifdef __cplusplus
extern "C" {
#endif

/* Tape device name */
#define DD_TAPE_DEVICE_NAME "\\Device\\Tape"

/* Tape device I/O control codes */
#define IOCTL_TAPE_BASE FILE_DEVICE_TAPE
#define IOCTL_TAPE_ERASE \
    CTL_CODE( IOCTL_TAPE_BASE, 0x0000, METHOD_BUFFERED, FILE_READ_ACCESS | \
    FILE_WRITE_ACCESS )
#define IOCTL_TAPE_PREPARE \
    CTL_CODE( IOCTL_TAPE_BASE, 0x0001, METHOD_BUFFERED, FILE_READ_ACCESS | \
    FILE_WRITE_ACCESS )
#define IOCTL_TAPE_WRITE_MARKS \
    CTL_CODE( IOCTL_TAPE_BASE, 0x0002, METHOD_BUFFERED, FILE_READ_ACCESS | \
    FILE_WRITE_ACCESS )
#define IOCTL_TAPE_GET_POSITION \
    CTL_CODE( IOCTL_TAPE_BASE, 0x0003, METHOD_BUFFERED, FILE_READ_ACCESS )
#define IOCTL_TAPE_SET_POSITION \
    CTL_CODE( IOCTL_TAPE_BASE, 0x0004, METHOD_BUFFERED, FILE_READ_ACCESS )
#define IOCTL_TAPE_GET_DRIVE_PARAMS \
    CTL_CODE( IOCTL_TAPE_BASE, 0x0005, METHOD_BUFFERED, FILE_READ_ACCESS )
#define IOCTL_TAPE_SET_DRIVE_PARAMS \
    CTL_CODE( IOCTL_TAPE_BASE, 0x0006, METHOD_BUFFERED, FILE_READ_ACCESS | \
    FILE_WRITE_ACCESS )
#define IOCTL_TAPE_GET_MEDIA_PARAMS \
    CTL_CODE( IOCTL_TAPE_BASE, 0x0007, METHOD_BUFFERED, FILE_READ_ACCESS )
#define IOCTL_TAPE_SET_MEDIA_PARAMS \
    CTL_CODE( IOCTL_TAPE_BASE, 0x0008, METHOD_BUFFERED, FILE_READ_ACCESS )
#define IOCTL_TAPE_GET_STATUS \
    CTL_CODE( IOCTL_TAPE_BASE, 0x0009, METHOD_BUFFERED, FILE_READ_ACCESS )
#define IOCTL_TAPE_CREATE_PARTITION \
    CTL_CODE( IOCTL_TAPE_BASE, 0x000A, METHOD_BUFFERED, FILE_READ_ACCESS | \
    FILE_WRITE_ACCESS )
#define IOCTL_TAPE_MEDIA_REMOVAL \
    CTL_CODE( IOCTL_TAPE_BASE, 0x0201, METHOD_BUFFERED, FILE_READ_ACCESS )
#define IOCTL_TAPE_EJECT_MEDIA \
    CTL_CODE( IOCTL_TAPE_BASE, 0x0202, METHOD_BUFFERED, FILE_READ_ACCESS )
#define IOCTL_TAPE_LOAD_MEDIA \
    CTL_CODE( IOCTL_TAPE_BASE, 0x0203, METHOD_BUFFERED, FILE_READ_ACCESS )
#define IOCTL_TAPE_RESERVE \
    CTL_CODE( IOCTL_TAPE_BASE, 0x0204, METHOD_BUFFERED, FILE_READ_ACCESS )
#define IOCTL_TAPE_RELEASE \
    CTL_CODE( IOCTL_TAPE_BASE, 0x0205, METHOD_BUFFERED, FILE_READ_ACCESS )
#if (NTDDI_VERSION < 0x05020000)
    #define IOCTL_TAPE_CHECK_VERIFY \
        CTL_CODE( IOCTL_TAPE_BASE, 0x0200, METHOD_BUFFERED, FILE_READ_ACCESS )
    #define IOCTL_TAPE_FIND_NEW_DEVICES \
        CTL_CODE( IOCTL_DISK_BASE, 0x0206, METHOD_BUFFERED, FILE_READ_ACCESS )
#endif

/* Tape erase modes */
#define TAPE_ERASE_SHORT    0L
#define TAPE_ERASE_LONG     1L

/* Tape preparation types */
#define TAPE_LOAD       0L
#define TAPE_UNLOAD     1L
#define TAPE_TENSION    2L
#define TAPE_LOCK       3L
#define TAPE_UNLOCK     4L
#define TAPE_FORMAT     5L

/* Tapemark types */
#define TAPE_SETMARKS           0L
#define TAPE_FILEMARKS          1L
#define TAPE_SHORT_FILEMARKS    2L
#define TAPE_LONG_FILEMARKS     3L

/* Tape get position modes */
#define TAPE_ABSOLUTE_POSITION          0L
#define TAPE_LOGICAL_POSITION           1L
#define TAPE_PSEUDO_LOGICAL_POSITION    2L

/* Tape set position modes */
#define TAPE_REWIND                 0L
#define TAPE_ABSOLUTE_BLOCK         1L
#define TAPE_LOGICAL_BLOCK          2L
#define TAPE_PSEUDO_LOGICAL_BLOCK   3L
#define TAPE_SPACE_END_OF_DATA      4L
#define TAPE_SPACE_RELATIVE_BLOCKS  5L
#define TAPE_SPACE_FILEMARKS        6L
#define TAPE_SPACE_SEQUENTIAL_FMKS  7L
#define TAPE_SPACE_SETMARKS         8L
#define TAPE_SPACE_SEQUENTIAL_SMKS  9L

/* Tape drive features (low) */
#define TAPE_DRIVE_FIXED            0x00000001L
#define TAPE_DRIVE_SELECT           0x00000002L
#define TAPE_DRIVE_INITIATOR        0x00000004L
#define TAPE_DRIVE_ERASE_SHORT      0x00000010L
#define TAPE_DRIVE_ERASE_LONG       0x00000020L
#define TAPE_DRIVE_ERASE_BOP_ONLY   0x00000040L
#define TAPE_DRIVE_ERASE_IMMEDIATE  0x00000080L
#define TAPE_DRIVE_TAPE_CAPACITY    0x00000100L
#define TAPE_DRIVE_TAPE_REMAINING   0x00000200L
#define TAPE_DRIVE_FIXED_BLOCK      0x00000400L
#define TAPE_DRIVE_VARIABLE_BLOCK   0x00000800L
#define TAPE_DRIVE_WRITE_PROTECT    0x00001000L
#define TAPE_DRIVE_EOT_WZ_SIZE      0x00002000L
#define TAPE_DRIVE_ECC              0x00010000L
#define TAPE_DRIVE_COMPRESSION      0x00020000L
#define TAPE_DRIVE_PADDING          0x00040000L
#define TAPE_DRIVE_REPORT_SMKS      0x00080000L
#define TAPE_DRIVE_GET_ABSOLUTE_BLK 0x00100000L
#define TAPE_DRIVE_GET_LOGICAL_BLK  0x00200000L
#define TAPE_DRIVE_SET_EOT_WZ_SIZE  0x00400000L
#define TAPE_DRIVE_EJECT_MEDIA      0x01000000L
#define TAPE_DRIVE_CLEAN_REQUESTS   0x02000000L
#define TAPE_DRIVE_SET_CMP_BOP_ONLY 0x04000000L

/* Tape drive features (high) */
#define TAPE_DRIVE_LOAD_UNLOAD      0x80000001L
#define TAPE_DRIVE_TENSION          0x80000002L
#define TAPE_DRIVE_LOCK_UNLOCK      0x80000004L
#define TAPE_DRIVE_REWIND_IMMEDIATE 0x80000008L
#define TAPE_DRIVE_SET_BLOCK_SIZE   0x80000010L
#define TAPE_DRIVE_LOAD_UNLD_IMMED  0x80000020L
#define TAPE_DRIVE_TENSION_IMMED    0x80000040L
#define TAPE_DRIVE_LOCK_UNLK_IMMED  0x80000080L
#define TAPE_DRIVE_SET_ECC          0x80000100L
#define TAPE_DRIVE_SET_COMPRESSION  0x80000200L
#define TAPE_DRIVE_SET_PADDING      0x80000400L
#define TAPE_DRIVE_SET_REPORT_SMKS  0x80000800L
#define TAPE_DRIVE_ABSOLUTE_BLK     0x80001000L
#define TAPE_DRIVE_ABS_BLK_IMMED    0x80002000L
#define TAPE_DRIVE_LOGICAL_BLK      0x80004000L
#define TAPE_DRIVE_LOG_BLK_IMMED    0x80008000L
#define TAPE_DRIVE_END_OF_DATA      0x80010000L
#define TAPE_DRIVE_RELATIVE_BLKS    0x80020000L
#define TAPE_DRIVE_FILEMARKS        0x80040000L
#define TAPE_DRIVE_SEQUENTIAL_FMKS  0x80080000L
#define TAPE_DRIVE_SETMARKS         0x80100000L
#define TAPE_DRIVE_SEQUENTIAL_SMKS  0x80200000L
#define TAPE_DRIVE_REVERSE_POSITION 0x80400000L
#define TAPE_DRIVE_SPACE_IMMEDIATE  0x80800000L
#define TAPE_DRIVE_WRITE_SETMARKS   0x81000000L
#define TAPE_DRIVE_WRITE_FILEMARKS  0x82000000L
#define TAPE_DRIVE_WRITE_SHORT_FMKS 0x84000000L
#define TAPE_DRIVE_WRITE_LONG_FMKS  0x88000000L
#define TAPE_DRIVE_WRITE_MARK_IMMED 0x90000000L
#define TAPE_DRIVE_FORMAT           0xA0000000L
#define TAPE_DRIVE_FORMAT_IMMEDIATE 0xB0000000L
#define TAPE_DRIVE_HIGH_FEATURES    0x80000000L

/* Tape partition types */
#define TAPE_FIXED_PARTITIONS       0L
#define TAPE_SELECT_PARTITIONS      1L
#define TAPE_INITIATOR_PARTITIONS   2L

/* Tape drive WMI methods */
#define TAPE_QUERY_DRIVE_PARAMETERS     0L
#define TAPE_QUERY_MEDIA_CAPACITY       1L
#define TAPE_CHECK_FOR_DRIVE_PROBLEM    2L
#define TAPE_QUERY_IO_ERROR_DATA        3L
#define TAPE_QUERY_DEVICE_ERROR_DATA    4L

/* Structure used with IOCTL_TAPE_ERASE */
typedef struct _TAPE_ERASE {
    ULONG   Type;
    BOOLEAN Immediate;
} TAPE_ERASE;
typedef TAPE_ERASE  *PTAPE_ERASE;

/* Structure used with IOCTL_TAPE_PREPARE */
typedef struct _TAPE_PREPARE {
    ULONG   Operation;
    BOOLEAN Immediate;
} TAPE_PREPARE;
typedef TAPE_PREPARE    *PTAPE_PREPARE;

/* Structure used with IOCTL_TAPE_WRITE_MARKS */
typedef struct _TAPE_WRITE_MARKS {
    ULONG   Type;
    ULONG   Count;
    BOOLEAN Immediate;
} TAPE_WRITE_MARKS;
typedef TAPE_WRITE_MARKS    *PTAPE_WRITE_MARKS;

/* Structure used with IOCTL_TAPE_GET_POSITION */
typedef struct _TAPE_GET_POSITION {
    ULONG           Type;
    ULONG           Partition;
    LARGE_INTEGER   Offset;
} TAPE_GET_POSITION;
typedef TAPE_GET_POSITION   *PTAPE_GET_POSITION;

/* Structure used with IOCTL_TAPE_SET_POSITION */
typedef struct _TAPE_SET_POSITION {
    ULONG           Method;
    ULONG           Partition;
    LARGE_INTEGER   Offset;
    BOOLEAN         Immediate;
} TAPE_SET_POSITION;
typedef TAPE_SET_POSITION   *PTAPE_SET_POSITION;

/* Structure used with IOCTL_TAPE_GET_DRIVE_PARAMETERS */
typedef struct _TAPE_GET_DRIVE_PARAMETERS {
    BOOLEAN ECC;
    BOOLEAN Compression;
    BOOLEAN DataPadding;
    BOOLEAN ReportSetmarks;
    ULONG   DefaultBlockSize;
    ULONG   MaximumBlockSize;
    ULONG   MinimumBlockSize;
    ULONG   MaximumPartitionCount;
    ULONG   FeaturesLow;
    ULONG   FeaturesHigh;
    ULONG   EOTWarningZoneSize;
} TAPE_GET_DRIVE_PARAMETERS;
typedef TAPE_GET_DRIVE_PARAMETERS   *PTAPE_GET_DRIVE_PARAMETERS;

/* Structure used with IOCTL_TAPE_SET_DRIVE_PARAMETERS */
typedef struct _TAPE_SET_DRIVE_PARAMETERS {
    BOOLEAN ECC;
    BOOLEAN Compression;
    BOOLEAN DataPadding;
    BOOLEAN ReportSetmarks;
    ULONG   EOTWarningZoneSize;
} TAPE_SET_DRIVE_PARAMETERS;
typedef TAPE_SET_DRIVE_PARAMETERS   *PTAPE_SET_DRIVE_PARAMETERS;

/* Structure used with IOCTL_TAPE_GET_MEDIA_PARAMETERS */
typedef struct _TAPE_GET_MEDIA_PARAMETERS {
    LARGE_INTEGER   Capacity;
    LARGE_INTEGER   Remaining;
    ULONG           BlockSize;
    ULONG           PartitionCount;
    BOOLEAN         WriteProtected;
} TAPE_GET_MEDIA_PARAMETERS;
typedef TAPE_GET_MEDIA_PARAMETERS   *PTAPE_GET_MEDIA_PARAMETERS;

/* Structure used with IOCTL_TAPE_SET_MEDIA_PARAMETERS */
typedef struct _TAPE_SET_MEDIA_PARAMETERS {
    ULONG   BlockSize;
} TAPE_SET_MEDIA_PARAMETERS;
typedef TAPE_SET_MEDIA_PARAMETERS   *PTAPE_SET_MEDIA_PARAMETERS;

/* Structure used with IOCTL_TAPE_CREATE_PARTITION */
typedef struct _TAPE_CREATE_PARTITION {
    ULONG   Method;
    ULONG   Count;
    ULONG   Size;
} TAPE_CREATE_PARTITION;
typedef TAPE_CREATE_PARTITION   *PTAPE_CREATE_PARTITION;

/* Structure used with WMI for tape drives */
typedef struct _TAPE_WMI_OPERATIONS {
    ULONG   Method;
    ULONG   DataBufferSize;
    PVOID   DataBuffer;
} TAPE_WMI_OPERATIONS;
typedef TAPE_WMI_OPERATIONS *PTAPE_WMI_OPERATIONS;

/* Tape drive problem types */
typedef enum _TAPE_DRIVE_PROBLEM_TYPE {
    TapeDriveProblemNone,
    TapeDriveReadWriteWarning,
    TapeDriveReadWriteError,
    TapeDriveReadWarning,
    TapeDriveWriteWarning,
    TapeDriveReadError,
    TapeDriveWriteError,
    TapeDriveHardwareError,
    TapeDriveUnsupportedMedia,
    TapeDriveScsiConnectionError,
    TapeDriveTimetoClean,
    TapeDriveCleanDriveNow,
    TapeDriveMediaLifeExpired,
    TapeDriveSnappedTape
} TAPE_DRIVE_PROBLEM_TYPE;

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* _NTDDTAPE_ */
