/*
 *  adsprop.h   Active Directory Service (ADS) property sheet functions
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2014 The Open Watcom Contributors. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */

#ifndef _ADSPROP_H_
#define _ADSPROP_H_

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file;
#endif

#ifdef __cplusplus
extern "C" {
#endif

/* ADS property sheet messages */
#define WM_ADSPROP_NOTIFY_PAGEINIT      (WM_USER + 1101)
#define WM_ADSPROP_NOTIFY_PAGEHWND      (WM_USER + 1102)
#define WM_ADSPROP_NOTIFY_CHANGE        (WM_USER + 1103)
#define WM_ADSPROP_NOTIFY_APPLY         (WM_USER + 1104)
#define WM_ADSPROP_NOTIFY_SETFOCUS      (WM_USER + 1105)
#define WM_ADSPROP_NOTIFY_FOREGROUND    (WM_USER + 1106)
#define WM_ADSPROP_NOTIFY_EXIT          (WM_USER + 1107)
#define WM_ADSPROP_NOTIFY_ERROR         (WM_USER + 1110)

/* ADS property sheet initialization parameters */
typedef struct _ADSPROPINITPARAMS {
    DWORD               dwSize;
    DWORD               dwFlags;
    HRESULT             hr;
    IDirectoryObject    *pDsObj;
    LPWSTR              pwzCN;
    PADS_ATTR_INFO      pWritableAttrs;
} ADSPROPINITPARAMS;
typedef ADSPROPINITPARAMS   *PADSPROPINITPARAMS;

/* ADS property sheet error */
typedef struct _ADSPROPERROR {
    HWND    hwndPage;
    PWSTR   pszPageTitle;
    PWSTR   pszObjPath;
    PWSTR   pszObjClass;
    HRESULT hr;
    PWSTR   pszError;
} ADSPROPERROR;
typedef ADSPROPERROR    *PADSPROPERROR;

/* Functions in DSPROP.DLL */
STDAPI_( BOOL ) ADsPropCheckIfWritable( const PWSTR, const PADS_ATTR_INFO );
STDAPI          ADsPropCreateNotifyObj( LPDATAOBJECT, PWSTR, HWND * );
STDAPI_( BOOL ) ADsPropGetInitInfo( HWND, PADSPROPINITPARAMS );
STDAPI_( BOOL ) ADsPropSendErrorMessage( HWND, PADSPROPERROR );
STDAPI_( BOOL ) ADsPropSetHwnd( HWND, HWND );
STDAPI_( BOOL ) ADsPropSetHwndWithTitle( HWND, HWND, PTSTR );
STDAPI_( BOOL ) ADsPropShowErrorDialog( HWND, HWND );

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* _ADSPROP_H_ */
