/*
 *  rpcndr.h    RPC Network Data Respresentation (NDR) functions
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2010 The Open Watcom Contributors. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */

/* Version of this header */
#ifndef __RPCNDR_H_VERSION__
    #define __RPCNDR_H_VERSION__    500
#endif

#ifndef __RPCNDR_H__
#define __RPCNDR_H__

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file;
#endif

#include <basetsd.h>
#include <rpcnsip.h>

#ifdef __cplusplus
extern "C" {
#endif

/* Calling convention for RPC functions with variable argument lists */
#define RPC_VAR_ENTRY   __cdecl

/* MIDL base data types */
#define small           char
typedef unsigned char   byte;
typedef byte            cs_byte;
typedef unsigned char   boolean;
#define hyper           __int64

/* Error status */
typedef unsigned long   error_status_t;

/* Stub helper data types */
typedef unsigned char       *RPC_BUFPTR;
typedef unsigned long       RPC_LENGTH;
typedef const unsigned char *PFORMAT_STRING;

/* MIDL transmit type */
typedef void    *PMIDL_XMIT_TYPE;

/* Offsetable parameter */
typedef unsigned short  *PARAM_OFFSETABLE;
typedef unsigned short  *PPARAM_OFFSETABLE;

/* RPC SS thread handle */
typedef void    *RPC_SS_THREAD_HANDLE;

/* NDR flags */
#define NDR_CHAR_REP_MASK               0x0000000FL
#define NDR_INT_REP_MASK                0x000000F0L
#define NDR_FLOAT_REP_MASK              0x0000FF00L
#define NDR_LITTLE_ENDIAN               0x00000010L
#define NDR_BIG_ENDIAN                  0x00000000L
#define NDR_IEEE_FLOAT                  0x00000000L
#define NDR_VAX_FLOAT                   0x00000100L
#define NDR_IBM_FLOAT                   0x00000300L
#define NDR_ASCII_CHAR                  0x00000000L
#define NDR_EBCDIC_CHAR                 0x00000001L
#define NDR_LOCAL_DATA_REPRESENTATION   0x00000010L
#define NDR_LOCAL_ENDIAN                NDR_LITTLE_ENDIAN

/* NDR server context size */
#define cbNDRContext    20

/* User marshal callback signature */
#define USER_MARSHAL_CB_SIGNATURE   'USRC'

/* User marshal flags */
#define USER_CALL_IS_ASYNC              0x00000100L
#define USER_CALL_NEW_CORRELATION_DESC  0x00000200L

/* Macros to manipulate user marshal flags */
#define USER_CALL_CTXT_MASK( x )    ((x) & 0x000000FFL)
#define USER_CALL_AUX_MASK( x )     ((x) & 0x0000FF00L)
#define GET_USER_DATA_REP( x )      ((x) >> 16)

/* User marshal format characters */
#define USER_MARSHAL_FC_BYTE    1
#define USER_MARSHAL_FC_CHAR    2
#define USER_MARSHAL_FC_SMALL   3
#define USER_MARSHAL_FC_USMALL  4
#define USER_MARSHAL_FC_WCHAR   5
#define USER_MARSHAL_FC_SHORT   6
#define USER_MARSHAL_FC_USHORT  7
#define USER_MARSHAL_FC_LONG    8
#define USER_MARSHAL_FC_ULONG   9
#define USER_MARSHAL_FC_FLOAT   10
#define USER_MARSHAL_FC_HYPER   11
#define USER_MARSHAL_FC_DOUBLE  12

/* Macro used by MIDL to declare an interface - ignore the UUID because the
 * __declspec(uuid) attribute is Microsoft-specific.
 */
#define MIDL_INTERFACE( x ) struct

/* Abstract data types */
typedef struct _NDR_ASYNC_MESSAGE       *PNDR_ASYNC_MESSAGE;
typedef struct _NDR_CORRELATION_INFO    *PNDR_CORRELATION_INFO;

/* NDR client context */
typedef void    *NDR_CCONTEXT;

/* NDR server context */
typedef struct {
    void    *pad[2];
    void    *userContext;
} *NDR_SCONTEXT;

/* NDR callbacks */
typedef void (RPC_ENTRY *NDR_RUNDOWN)( void * );
typedef void (RPC_ENTRY *NDR_NOTIFY_ROUTINE)( void );
typedef void (RPC_ENTRY *NDR_NOTIFY2_ROUTINE)( boolean );

/* NDR server context queue */
typedef struct _SCONTEXT_QUEUE {
    unsigned long   NumberOfObjects;
    NDR_SCONTEXT    *ArrayOfObjects;
} SCONTEXT_QUEUE;
typedef SCONTEXT_QUEUE  *PSCONTEXT_QUEUE;

/* Expression evaluation callback */
typedef void (RPC_ENTRY *EXPR_EVAL)( struct _MIDL_STUB_MESSAGE * );

/* Array information */
typedef struct {
    long            Dimension;
    unsigned long   *BufferConformanceMark;
    unsigned long   *BufferVarianceMark;
    unsigned long   *MaxCountArray;
    unsigned long   *OffsetArray;
    unsigned long   *ActualCountArray;
} ARRAY_INFO;
typedef ARRAY_INFO  *PARRAY_INFO;

/* MIDL stub message */
typedef struct _MIDL_STUB_MESSAGE {
    PRPC_MESSAGE                        RpcMsg;
    unsigned char                       *Buffer;
    unsigned char                       *BufferStart;
    unsigned char                       *BufferEnd;
    unsigned char                       *BufferMark;
    unsigned long                       BufferLength;
    unsigned long                       MemorySize;
    unsigned char                       *Memory;
    unsigned char                       IsClient;
    unsigned char                       Pad;
    unsigned short                      uFlags2;
    int                                 ReuseBuffer;
    struct NDR_ALLOC_ALL_NODES_CONTEXT  *pAllocAllNodesContext;
    struct NDR_POINTER_QUEUE_STATE      *pPointerQueueState;
    int                                 IgnoreEmbeddedPointers;
    unsigned char                       *PointerBufferMark;
    unsigned char                       CorrDespIncrement;
    unsigned char                       uFlags;
    unsigned short                      UniquePtrCount;
    ULONG_PTR                           MaxCount;
    unsigned long                       Offset;
    unsigned long                       ActualCount;
    void                                *(RPC_ENTRY *pfnAllocate)( size_t );
    void                                (RPC_ENTRY *pfnFree)( void * );
    unsigned char                       *StackTop;
    unsigned char                       *pPresentedType;
    unsigned char                       *pTransmitType;
    handle_t                            SavedHandle;
    const struct _MIDL_STUB_DESC        *StubDesc;
    struct _FULL_PTR_XLAT_TABLES        *FullPtrXlatTables;
    unsigned long                       FullPtrRefId;
    unsigned long                       PointerLength;
    int                                 fInDontFree                 : 1;
    int                                 fDontCallFreeInst           : 1;
    int                                 fInOnlyParam                : 1;
    int                                 fHasReturn                  : 1;
    int                                 fHasExtensions              : 1;
    int                                 fHasNewCorrDesc             : 1;
    int                                 fIsIn                       : 1;
    int                                 fIsOut                      : 1;
    int                                 fIsOicf                     : 1;
    int                                 fBufferValid                : 1;
    int                                 fHasMemoryValidateCallback  : 1;
    int                                 fInFree                     : 1;
    int                                 fNeedMCCP                   : 1;
    int                                 fUnused                     : 3;
    int                                 fUnused2                    : 16;
    unsigned long                       dwDestContext;
    void                                *pvDestContext;
    NDR_SCONTEXT                        *SavedContextHandles;
    long                                ParamNumber;
    struct IRpcChannelBuffer            *pRpcChannelBuffer;
    PARRAY_INFO                         pArrayInfo;
    unsigned long                       *SizePtrCountArray;
    unsigned long                       *SizePtrOffsetArray;
    unsigned long                       *SizePtrLengthArray;
    void                                *pArgQueue;
    unsigned long                       dwStubPhase;
    void                                *LowStackMark;
    PNDR_ASYNC_MESSAGE                  pAsyncMsg;
    PNDR_CORRELATION_INFO               pCorrInfo;
    unsigned char                       *pCorrMemory;
    void                                *pMemoryList;
#if (NTDDI_VERSION >= 0x05000000)
    INT_PTR                             pCSInfo;
    unsigned char                       *ConformanceMark;
    unsigned char                       *VarianceMark;
    INT_PTR                             Unused;
    struct _NDR_PROC_CONTEXT            *pContext;
    void                                *ContextHandleHash;
    void                                *pUserMarshalList;
    INT_PTR                             Reserved51_3;
    INT_PTR                             Reserved51_4;
    INT_PTR                             Reserved51_5;
#endif
} MIDL_STUB_MESSAGE;
typedef MIDL_STUB_MESSAGE   *PMIDL_STUB_MESSAGE;

/* Generic binding routines */
typedef void *(RPC_ENTRY *GENERIC_BINDING_ROUTINE)( void * );
typedef void (RPC_ENTRY *GENERIC_UNBIND_ROUTINE)( void *, unsigned char * );

/* Generic binding routine pair */
typedef struct _GENERIC_BINDING_ROUTINE_PAIR {
    GENERIC_BINDING_ROUTINE pfnBind;
    GENERIC_UNBIND_ROUTINE  pfnUnbind;
} GENERIC_BINDING_ROUTINE_PAIR;
typedef GENERIC_BINDING_ROUTINE_PAIR    *PGENERIC_BINDING_ROUTINE_PAIR;

/* Generic binding information */
typedef struct __GENERIC_BINDING_INFO {
    void                    *pObj;
    unsigned int            Size;
    GENERIC_BINDING_ROUTINE pfnBind;
    GENERIC_UNBIND_ROUTINE  pfnUnbind;
} GENERIC_BINDING_INFO;
typedef GENERIC_BINDING_INFO    *PGENERIC_BINDING_INFO;

/* Transmit helper routine */
typedef void (RPC_ENTRY *XMIT_HELPER_ROUTINE)( PMIDL_STUB_MESSAGE );

/* Transmit routine quintuple */
typedef struct _XMIT_ROUTINE_QUINTUPLE {
    XMIT_HELPER_ROUTINE pfnTranslateToXmit;
    XMIT_HELPER_ROUTINE pfnTranslateFromXmit;
    XMIT_HELPER_ROUTINE pfnFreeXmit;
    XMIT_HELPER_ROUTINE pfnFreeInst;
} XMIT_ROUTINE_QUINTUPLE;
typedef XMIT_ROUTINE_QUINTUPLE  *PXMIT_ROUTINE_QUINTUPLE;

/* User marshal routines */
typedef unsigned long (RPC_ENTRY *USER_MARSHAL_SIZING_ROUTINE)( unsigned long *, unsigned long, void * );
typedef unsigned char *(RPC_ENTRY *USER_MARSHAL_MARSHALLING_ROUTINE)( unsigned long *, unsigned char *, void * );
typedef unsigned char *(RPC_ENTRY *USER_MARSHAL_UNMARSHALLING_ROUTINE)( unsigned long *, unsigned char *, void * );
typedef void (RPC_ENTRY *USER_MARSHAL_FREEING_ROUTINE)( unsigned long *, void * );

/* User marshal routine quadruple */
typedef struct _USER_MARSHAL_ROUTINE_QUADRUPLE {
    USER_MARSHAL_SIZING_ROUTINE         pfnBufferSize;
    USER_MARSHAL_MARSHALLING_ROUTINE    pfnMarshall;
    USER_MARSHAL_UNMARSHALLING_ROUTINE  pfnUnmarshal;
    USER_MARSHAL_FREEING_ROUTINE        pfnFree;
} USER_MARSHAL_ROUTINE_QUADRUPLE;

/* User marshal callback types */
typedef enum _USER_MARSHAL_CB_TYPE {
    USER_MARSHAL_CB_BUFFER_SIZE = 0,
    USER_MARSHAL_CB_MARSHALL    = 1,
    USER_MARSHAL_CB_UNMARSHALL  = 2,
    USER_MARSHAL_CB_FREE        = 3
} USER_MARSHAL_CB_TYPE;

/* User marshall callback */
typedef struct _USER_MARSHAL_CB {
    unsigned long           Flags;
    PMIDL_STUB_MESSAGE      pStubMsg;
    PFORMAT_STRING          pReserve;
    unsigned long           Signature;
    USER_MARSHAL_CB_TYPE    CBType;
    PFORMAT_STRING          pFormat;
    PFORMAT_STRING          pTypeFormat;
} USER_MARSHAL_CB;

/* Allocate/free structure */
typedef struct _MALLOC_FREE_STRUCT {
    void    *(RPC_ENTRY *pfnAllocate)( size_t );
    void    (RPC_ENTRY *pfnFree)( void * );
} MALLOC_FREE_STRUCT;

/* Communication and fault offsets */
typedef struct _COMM_FAULT_OFFSETS {
    short   CommOffset;
    short   FaultOffset;
} COMM_FAULT_OFFSETS;

/* IDL character set conversions */
typedef enum _IDL_CS_CONVERT {
    IDL_CS_NO_CONVERT           = 0,
    IDL_CS_IN_PLACE_CONVERT     = 1,
    IDL_CS_NEW_BUFFER_CONVERT   = 2
} IDL_CS_CONVERT;

/* Character set routines */
typedef void (RPC_ENTRY *CS_TYPE_NET_SIZE_ROUTINE)( RPC_BINDING_HANDLE, unsigned long, unsigned long, IDL_CS_CONVERT *, unsigned long *, error_status_t * );
typedef void (RPC_ENTRY *CS_TYPE_LOCAL_SIZE_ROUTINE)( RPC_BINDING_HANDLE, unsigned long, unsigned long, IDL_CS_CONVERT *, unsigned long *, error_status_t * );
typedef void (RPC_ENTRY *CS_TYPE_TO_NETCS_ROUTINE)( RPC_BINDING_HANDLE, unsigned long, void *, unsigned long, byte *, unsigned long *, error_status_t * );
typedef void (RPC_ENTRY *CS_TYPE_FROM_NETCS_ROUTINE)( RPC_BINDING_HANDLE, unsigned long, byte *, unsigned long, unsigned long, void *, unsigned long *, error_status_t * );
typedef void (RPC_ENTRY *CS_TAG_GETTING_ROUTINE)( RPC_BINDING_HANDLE, int, unsigned long *, unsigned long *, unsigned long *, error_status_t * );

/* NDR character set size conversion routines */
typedef struct _NDR_CS_SIZE_CONVERT_ROUTINES {
    CS_TYPE_NET_SIZE_ROUTINE    pfnNetSize;
    CS_TYPE_TO_NETCS_ROUTINE    pfnToNetCs;
    CS_TYPE_LOCAL_SIZE_ROUTINE  pfnLocalSize;
    CS_TYPE_FROM_NETCS_ROUTINE  pfnFromNetCs;
} NDR_CS_SIZE_CONVERT_ROUTINES;

/* NDR character set routines */
typedef struct _NDR_CS_ROUTINES {
    NDR_CS_SIZE_CONVERT_ROUTINES    *pSizeConvertRoutines;
    CS_TAG_GETTING_ROUTINE          *pTagGettingRoutines;
} NDR_CS_ROUTINES;

/* NDR expression description */
typedef struct _NDR_EXPR_DESC {
    const unsigned short    *pOffset;
    PFORMAT_STRING          pFormatExpr;
} NDR_EXPR_DESC;

/* MIDL stub description */
typedef struct _MIDL_STUB_DESC {
    void                                    *RpcInterfaceInformation;
    void                                    *(RPC_ENTRY *pfnAllocate)( size_t );
    void                                    (RPC_ENTRY *pfnFree)( void * );
    union {
        handle_t                *pAutoHandle;
        handle_t                *pPrimitiveHandle;
        PGENERIC_BINDING_INFO   pGenericBindingInfo;
    } IMPLICIT_HANDLE_INFO;
    const NDR_RUNDOWN                       *apfnNdrRundownRoutines;
    const GENERIC_BINDING_ROUTINE_PAIR      *aGenericBindingRoutinePairs;
    const EXPR_EVAL                         *apfnExprEval;
    const XMIT_ROUTINE_QUINTUPLE            *aXmitQuintuple;
    const unsigned char                     *pFormatTypes;
    int                                     fCheckBounds;
    unsigned long                           Version;
    MALLOC_FREE_STRUCT                      *pMallocFreeStruct;
    long                                    MIDLVersion;
    const COMM_FAULT_OFFSETS                *CommFaultOffsets;
    const USER_MARSHAL_ROUTINE_QUADRUPLE    *aUserMarshalQuadruple;
    const NDR_NOTIFY_ROUTINE                *NotifyRoutineTable;
    ULONG_PTR                               mFlags;
    const NDR_CS_ROUTINES                   *CsRoutineTables;
    void                                    *ProxyServerInfo;
    const NDR_EXPR_DESC                     *pExprInfo;
} MIDL_STUB_DESC;
typedef const MIDL_STUB_DESC    *PMIDL_STUB_DESC;

/* MIDL format string */
typedef struct _MIDL_FORMAT_STRING {
    short           Pad;
    unsigned char   Format[1];
} MIDL_FORMAT_STRING;

/* Stub thunk */
typedef void (RPC_ENTRY *STUB_THUNK)( PMIDL_STUB_MESSAGE );

/* Server routine */
typedef long (RPC_ENTRY *SERVER_ROUTINE)();

/* MIDL server information */
typedef struct _MIDL_SERVER_INFO {
    PMIDL_STUB_DESC             pStubDesc;
    const SERVER_ROUTINE        *DispatchTable;
    PFORMAT_STRING              ProcString;
    const unsigned short        *FmtStringOffset;
    const STUB_THUNK            *ThunkTable;
    PRPC_SYNTAX_IDENTIFIER      pTransferSyntax;
    ULONG_PTR                   nCount;
    struct _MIDL_SYNTAX_INFO    *pSyntaxInfo;
} MIDL_SERVER_INFO;
typedef MIDL_SERVER_INFO    *PMIDL_SERVER_INFO;

/* MIDL stubless proxy information */
typedef struct _MIDL_STUBLESS_PROXY_INFO {
    PMIDL_STUB_DESC             pStubDesc;
    PFORMAT_STRING              ProcFormatString;
    const unsigned short        *FormatStringOffset;
    PRPC_SYNTAX_IDENTIFIER      pTransferSyntax;
    ULONG_PTR                   nCount;
    struct _MIDL_SYNTAX_INFO    *pSyntaxInfo;
} MIDL_STUBLESS_PROXY_INFO;
typedef MIDL_STUBLESS_PROXY_INFO    *PMIDL_STUBLESS_PROXY_INFO;

/* MIDL syntax information */
typedef struct _MIDL_SYNTAX_INFO {
    RPC_SYNTAX_IDENTIFIER   TransferSyntax;
    RPC_DISPATCH_TABLE      *DispatchTable;
    PFORMAT_STRING          ProcString;
    const unsigned short    *FmtStringOffset;
    PFORMAT_STRING          TypeString;
    const void              *aUserMarshalQuadruple;
    ULONG_PTR               pReserved1;
    ULONG_PTR               pReserved2;
} MIDL_SYNTAX_INFO;
typedef MIDL_SYNTAX_INFO    *PMIDL_SYNTAX_INFO;

/* NdrClientCall() returned data */
typedef union _CLIENT_CALL_RETURN {
    void        *Pointer;
    LONG_PTR    Simple;
} CLIENT_CALL_RETURN;
typedef CLIENT_CALL_RETURN  *PCLIENT_CALL_RETURN;

/* Translation side */
typedef enum {
    XLAT_SERVER = 1,
    XLAT_CLIENT = 2
} XLAT_SIDE;

/* Full pointer translation tables */
typedef struct _FULL_PTR_XLAT_TABLES {
    void            *RefIdToPointer;
    void            *PointerToRefId;
    unsigned long   NextRefId;
    XLAT_SIDE       XlatSide;
} FULL_PTR_XLAT_TABLES;
typedef FULL_PTR_XLAT_TABLES    *PFULL_PTR_XLAT_TABLES;

/* Stub phases */
typedef enum {
    STUB_UNMARSHAL              = 0,
    STUB_CALL_SERVER            = 1,
    STUB_MARSHAL                = 2,
    STUB_CALL_SERVER_NO_HRESULT = 3
} STUB_PHASE;

/* Proxy phases */
typedef enum {
    PROXY_CALCSIZE      = 0,
    PROXY_GETBUFFER     = 1,
    PROXY_MARSHAL       = 2,
    PROXY_SENDRECEIVE   = 3,
    PROXY_UNMARSHAL     = 4
} PROXY_PHASE;

/* RPC client memory allocation callbacks */
typedef void * RPC_ENTRY    RPC_CLIENT_ALLOC( size_t );
typedef void RPC_ENTRY      RPC_CLIENT_FREE( void * );

/* NDR user marshal information (level 1) */
typedef struct _NDR_USER_MARSHAL_INFO_LEVEL1 {
    void                        *Buffer;
    unsigned long               BufferSize;
    void                        *(RPC_ENTRY *pfnAllocate)( size_t );
    void                        (RPC_ENTRY *pfnFree)( void * );
    struct IRpcChannelBuffer    *pRpcChannelBuffer;
    ULONG_PTR                   Reserved[5];
} NDR_USER_MARSHAL_INFO_LEVEL1;

/* NDR user marshal information */
typedef struct _NDR_USER_MARSHAL_INFO {
    unsigned long   InformationLevel;
    union {
        NDR_USER_MARSHAL_INFO_LEVEL1    Level1;
    };
} NDR_USER_MARSHAL_INFO;

/* Functions in RPCRT4.DLL */
RPCRTAPI RPC_BINDING_HANDLE RPC_ENTRY   NDRCContextBinding( NDR_CCONTEXT );
RPCRTAPI void RPC_ENTRY                 NDRCContextMarshall( NDR_CCONTEXT, void * );
RPCRTAPI void RPC_ENTRY                 NDRCContextUnmarshall( NDR_CCONTEXT *, RPC_BINDING_HANDLE, void *, unsigned long * );
RPCRTAPI void RPC_ENTRY                 NDRSContextMarshall( NDR_SCONTEXT, void *, NDR_RUNDOWN );
RPCRTAPI void RPC_ENTRY                 NDRSContextMarshall2( RPC_BINDING_HANDLE, NDR_SCONTEXT, void *, NDR_RUNDOWN, void *, unsigned long );
RPCRTAPI void RPC_ENTRY                 NDRSContextMarshallEx( RPC_BINDING_HANDLE, NDR_SCONTEXT, void *, NDR_RUNDOWN );
RPCRTAPI NDR_SCONTEXT RPC_ENTRY         NDRSContextUnmarshall( void *, unsigned long );
RPCRTAPI NDR_SCONTEXT RPC_ENTRY         NDRSContextUnmarshall2( RPC_BINDING_HANDLE, void *, unsigned long, void *, unsigned long );
RPCRTAPI NDR_SCONTEXT RPC_ENTRY         NDRSContextUnmarshallEx( RPC_BINDING_HANDLE, void *, unsigned long );
RPCRTAPI void * RPC_ENTRY               NdrAllocate( PMIDL_STUB_MESSAGE, size_t );
RPCRTAPI CLIENT_CALL_RETURN RPC_VAR_ENTRY   NdrAsyncClientCall( PMIDL_STUB_DESC, PFORMAT_STRING, ... );
RPCRTAPI void RPC_ENTRY                 NdrAsyncServerCall( PRPC_MESSAGE );
RPCRTAPI long RPC_ENTRY                 NdrAsyncStubCall( struct IRpcStubBuffer *, struct IRpcChannelBuffer *, PRPC_MESSAGE, unsigned long * );
RPCRTAPI void RPC_ENTRY                 NdrByteCountPointerBufferSize( PMIDL_STUB_MESSAGE, unsigned char *, PFORMAT_STRING );
RPCRTAPI void RPC_ENTRY                 NdrByteCountPointerFree( PMIDL_STUB_MESSAGE, unsigned char *, PFORMAT_STRING );
RPCRTAPI unsigned char * RPC_ENTRY      NdrByteCountPointerMarshall( PMIDL_STUB_MESSAGE, unsigned char *, PFORMAT_STRING );
RPCRTAPI unsigned char * RPC_ENTRY      NdrByteCountPointerUnmarshall( PMIDL_STUB_MESSAGE, unsigned char **, PFORMAT_STRING, unsigned char );
RPCRTAPI void RPC_ENTRY                 NdrClearOutParameters( PMIDL_STUB_MESSAGE, PFORMAT_STRING, void * );
RPCRTAPI CLIENT_CALL_RETURN RPC_VAR_ENTRY   NdrClientCall( PMIDL_STUB_DESC, PFORMAT_STRING, ... );
RPCRTAPI CLIENT_CALL_RETURN RPC_VAR_ENTRY   NdrClientCall2( PMIDL_STUB_DESC, PFORMAT_STRING, ... );
RPCRTAPI void RPC_ENTRY                 NdrClientContextMarshall( PMIDL_STUB_MESSAGE, NDR_CCONTEXT, int );
RPCRTAPI void RPC_ENTRY                 NdrClientContextUnmarshall( PMIDL_STUB_MESSAGE, NDR_CCONTEXT *, RPC_BINDING_HANDLE );
RPCRTAPI void RPC_ENTRY                 NdrClientInitialize( PRPC_MESSAGE, PMIDL_STUB_MESSAGE, PMIDL_STUB_DESC, unsigned int );
RPCRTAPI void RPC_ENTRY                 NdrClientInitializeNew( PRPC_MESSAGE, PMIDL_STUB_MESSAGE, PMIDL_STUB_DESC, unsigned int );
RPCRTAPI void RPC_ENTRY                 NdrComplexArrayBufferSize( PMIDL_STUB_MESSAGE, unsigned char *, PFORMAT_STRING );
RPCRTAPI void RPC_ENTRY                 NdrComplexArrayFree( PMIDL_STUB_MESSAGE, unsigned char *, PFORMAT_STRING );
RPCRTAPI unsigned char * RPC_ENTRY      NdrComplexArrayMarshall( PMIDL_STUB_MESSAGE, unsigned char *, PFORMAT_STRING );
RPCRTAPI unsigned long RPC_ENTRY        NdrComplexArrayMemorySize( PMIDL_STUB_MESSAGE, PFORMAT_STRING );
RPCRTAPI unsigned char * RPC_ENTRY      NdrComplexArrayUnmarshall( PMIDL_STUB_MESSAGE, unsigned char **, PFORMAT_STRING, unsigned char );
RPCRTAPI void RPC_ENTRY                 NdrComplexStructBufferSize( PMIDL_STUB_MESSAGE, unsigned char *, PFORMAT_STRING );
RPCRTAPI void RPC_ENTRY                 NdrComplexStructFree( PMIDL_STUB_MESSAGE, unsigned char *, PFORMAT_STRING );
RPCRTAPI unsigned char * RPC_ENTRY      NdrComplexStructMarshall( PMIDL_STUB_MESSAGE, unsigned char *, PFORMAT_STRING );
RPCRTAPI unsigned long RPC_ENTRY        NdrComplexStructMemorySize( PMIDL_STUB_MESSAGE, unsigned long );
RPCRTAPI unsigned char * RPC_ENTRY      NdrComplexStructUnmarshall( PMIDL_STUB_MESSAGE, unsigned char **, PFORMAT_STRING, unsigned char );
RPCRTAPI void RPC_ENTRY                 NdrConformantArrayBufferSize( PMIDL_STUB_MESSAGE, unsigned char *, PFORMAT_STRING );
RPCRTAPI void RPC_ENTRY                 NdrConformantArrayFree( PMIDL_STUB_MESSAGE, unsigned char *, PFORMAT_STRING );
RPCRTAPI unsigned char * RPC_ENTRY      NdrConformantArrayMarshall( PMIDL_STUB_MESSAGE, unsigned char *, PFORMAT_STRING );
RPCRTAPI unsigned long RPC_ENTRY        NdrConformantArrayMemorySize( PMIDL_STUB_MESSAGE, PFORMAT_STRING );
RPCRTAPI unsigned char * RPC_ENTRY      NdrConformantArrayUnmarshall( PMIDL_STUB_MESSAGE, unsigned char **, PFORMAT_STRING, unsigned char );
RPCRTAPI void RPC_ENTRY                 NdrConformantStringBufferSize( PMIDL_STUB_MESSAGE, unsigned char *, PFORMAT_STRING );
RPCRTAPI unsigned char * RPC_ENTRY      NdrConformantStringMarshall( PMIDL_STUB_MESSAGE, unsigned char *, PFORMAT_STRING );
RPCRTAPI unsigned long RPC_ENTRY        NdrConformantStringMemorySize( PMIDL_STUB_MESSAGE, PFORMAT_STRING );
RPCRTAPI unsigned char * RPC_ENTRY      NdrConformantStringUnmarshall( PMIDL_STUB_MESSAGE, unsigned char **, PFORMAT_STRING, unsigned char );
RPCRTAPI void RPC_ENTRY                 NdrConformantStructBufferSize( PMIDL_STUB_MESSAGE, unsigned char *, PFORMAT_STRING );
RPCRTAPI void RPC_ENTRY                 NdrConformantStructFree( PMIDL_STUB_MESSAGE, unsigned char *, PFORMAT_STRING );
RPCRTAPI unsigned char * RPC_ENTRY      NdrConformantStructMarshall( PMIDL_STUB_MESSAGE, unsigned char *, PFORMAT_STRING );
RPCRTAPI unsigned long RPC_ENTRY        NdrConformantStructMemorySize( PMIDL_STUB_MESSAGE, PFORMAT_STRING );
RPCRTAPI unsigned char * RPC_ENTRY      NdrConformantStructUnmarshall( PMIDL_STUB_MESSAGE, unsigned char **, PFORMAT_STRING, unsigned char );
RPCRTAPI void RPC_ENTRY                 NdrConformantVaryingArrayBufferSize( PMIDL_STUB_MESSAGE, unsigned char *, PFORMAT_STRING );
RPCRTAPI void RPC_ENTRY                 NdrConformantVaryingArrayFree( PMIDL_STUB_MESSAGE, unsigned char *, PFORMAT_STRING );
RPCRTAPI unsigned char * RPC_ENTRY      NdrConformantVaryingArrayMarshall( PMIDL_STUB_MESSAGE, unsigned char *, PFORMAT_STRING );
RPCRTAPI unsigned long RPC_ENTRY        NdrConformantVaryingArrayMemorySize( PMIDL_STUB_MESSAGE, PFORMAT_STRING );
RPCRTAPI unsigned char * RPC_ENTRY      NdrConformantVaryingArrayUnmarshall( PMIDL_STUB_MESSAGE, unsigned char **, PFORMAT_STRING, unsigned char );
RPCRTAPI void RPC_ENTRY                 NdrConformantVaryingStructBufferSize( PMIDL_STUB_MESSAGE, unsigned char *, PFORMAT_STRING );
RPCRTAPI void RPC_ENTRY                 NdrConformantVaryingStructFree( PMIDL_STUB_MESSAGE, unsigned char *, PFORMAT_STRING );
RPCRTAPI unsigned char * RPC_ENTRY      NdrConformantVaryingStructMarshall( PMIDL_STUB_MESSAGE, unsigned char *, PFORMAT_STRING );
RPCRTAPI unsigned long RPC_ENTRY        NdrConformantVaryingStructMemorySize( PMIDL_STUB_MESSAGE, PFORMAT_STRING );
RPCRTAPI unsigned char * RPC_ENTRY      NdrConformantVaryingStructUnmarshall( PMIDL_STUB_MESSAGE, unsigned char **, PFORMAT_STRING, unsigned char );
RPCRTAPI NDR_SCONTEXT RPC_ENTRY         NdrContextHandleInitialize( PMIDL_STUB_MESSAGE, PFORMAT_STRING );
RPCRTAPI void RPC_ENTRY                 NdrContextHandleSize( PMIDL_STUB_MESSAGE, unsigned char *, PFORMAT_STRING );
RPCRTAPI void RPC_ENTRY                 NdrConvert( PMIDL_STUB_MESSAGE, PFORMAT_STRING );
RPCRTAPI void RPC_ENTRY                 NdrConvert2( PMIDL_STUB_MESSAGE, PFORMAT_STRING, long );
RPCRTAPI void RPC_ENTRY                 NdrCorrelationFree( PMIDL_STUB_MESSAGE );
RPCRTAPI void RPC_ENTRY                 NdrCorrelationInitialize( PMIDL_STUB_MESSAGE, void *, unsigned long, unsigned long );
RPCRTAPI void RPC_ENTRY                 NdrCorrelationPass( PMIDL_STUB_MESSAGE );
RPCRTAPI RPC_STATUS RPC_ENTRY           NdrCreateServerInterfaceFromStub( struct IRpcStubBuffer *, RPC_SERVER_INTERFACE * );
RPCRTAPI CLIENT_CALL_RETURN RPC_VAR_ENTRY   NdrDcomAsyncClientCall( PMIDL_STUB_DESC, PFORMAT_STRING, ... );
RPCRTAPI long RPC_ENTRY                 NdrDcomAsyncStubCall( struct IRpcStubBuffer *, struct IRpcChannelBuffer *, PRPC_MESSAGE, unsigned long * );
RPCRTAPI void RPC_ENTRY                 NdrEncapsulatedUnionBufferSize( PMIDL_STUB_MESSAGE, unsigned char *, PFORMAT_STRING );
RPCRTAPI void RPC_ENTRY                 NdrEncapsulatedUnionSize( PMIDL_STUB_MESSAGE, unsigned char *, PFORMAT_STRING );
RPCRTAPI unsigned char * RPC_ENTRY      NdrEncapsulatedUnionMarshall( PMIDL_STUB_MESSAGE, unsigned char *, PFORMAT_STRING );
RPCRTAPI unsigned long RPC_ENTRY        NdrEncapsulatedUnionMemorySize( PMIDL_STUB_MESSAGE, PFORMAT_STRING );
RPCRTAPI unsigned char * RPC_ENTRY      NdrEncapsulatedUnionUnmarshall( PMIDL_STUB_MESSAGE, unsigned char **, PFORMAT_STRING, unsigned char );
RPCRTAPI void RPC_ENTRY                 NdrFixedArrayBufferSize( PMIDL_STUB_MESSAGE, unsigned char *, PFORMAT_STRING );
RPCRTAPI void RPC_ENTRY                 NdrFixedArrayFree( PMIDL_STUB_MESSAGE, unsigned char *, PFORMAT_STRING );
RPCRTAPI unsigned char * RPC_ENTRY      NdrFixedArrayMarshall( PMIDL_STUB_MESSAGE, unsigned char *, PFORMAT_STRING );
RPCRTAPI unsigned long RPC_ENTRY        NdrFixedArrayMemorySize( PMIDL_STUB_MESSAGE, PFORMAT_STRING );
RPCRTAPI unsigned char * RPC_ENTRY      NdrFixedArrayUnmarshall( PMIDL_STUB_MESSAGE, unsigned char **, PFORMAT_STRING, unsigned char );
RPCRTAPI void RPC_ENTRY                 NdrFreeBuffer( PMIDL_STUB_MESSAGE );
RPCRTAPI void RPC_ENTRY                 NdrFullPointerXlatFree( PFULL_PTR_XLAT_TABLES );
RPCRTAPI PFULL_PTR_XLAT_TABLES RPC_ENTRY    NdrFullPointerXlatInit( unsigned long, XLAT_SIDE );
RPCRTAPI unsigned char * RPC_ENTRY      NdrGetBuffer( PMIDL_STUB_MESSAGE, unsigned long, RPC_BINDING_HANDLE );
RPCRTAPI RPC_STATUS RPC_ENTRY           NdrGetDcomProtocolVersion( PMIDL_STUB_MESSAGE, RPC_VERSION * );
RPCRTAPI RPC_STATUS RPC_ENTRY           NdrGetUserMarshalInfo( unsigned long *, unsigned long, NDR_USER_MARSHAL_INFO * );
RPCRTAPI void RPC_ENTRY                 NdrInterfacePointerBufferSize( PMIDL_STUB_MESSAGE, unsigned char *, PFORMAT_STRING );
RPCRTAPI void RPC_ENTRY                 NdrInterfacePointerFree( PMIDL_STUB_MESSAGE, unsigned char *, PFORMAT_STRING );
RPCRTAPI unsigned char * RPC_ENTRY      NdrInterfacePointerMarshall( PMIDL_STUB_MESSAGE, unsigned char *, PFORMAT_STRING );
RPCRTAPI unsigned long RPC_ENTRY        NdrInterfacePointerMemorySize( PMIDL_STUB_MESSAGE, PFORMAT_STRING );
RPCRTAPI unsigned char * RPC_ENTRY      NdrInterfacePointerUnmarshall( PMIDL_STUB_MESSAGE, unsigned char **, PFORMAT_STRING, unsigned char );
RPCRTAPI RPC_STATUS RPC_ENTRY           NdrMapCommAndFaultStatus( PMIDL_STUB_MESSAGE, unsigned long *, unsigned long *, RPC_STATUS );
RPCRTAPI void RPC_ENTRY                 NdrNonConformantStringBufferSize( PMIDL_STUB_MESSAGE, unsigned char *, PFORMAT_STRING );
RPCRTAPI unsigned char * RPC_ENTRY      NdrNonConformantStringMarshall( PMIDL_STUB_MESSAGE, unsigned char *, PFORMAT_STRING );
RPCRTAPI unsigned long RPC_ENTRY        NdrNonConformantStringMemorySize( PMIDL_STUB_MESSAGE, PFORMAT_STRING );
RPCRTAPI unsigned char * RPC_ENTRY      NdrNonConformantStringUnmarshall( PMIDL_STUB_MESSAGE, unsigned char **, PFORMAT_STRING, unsigned char );
RPCRTAPI void RPC_ENTRY                 NdrNonEncapsulatedUnionBufferSize( PMIDL_STUB_MESSAGE, unsigned char *, PFORMAT_STRING );
RPCRTAPI void RPC_ENTRY                 NdrNonEncapsulatedUnionFree( PMIDL_STUB_MESSAGE, unsigned char *, PFORMAT_STRING );
RPCRTAPI unsigned char * RPC_ENTRY      NdrNonEncapsulatedUnionMarshall( PMIDL_STUB_MESSAGE, unsigned char *, PFORMAT_STRING );
RPCRTAPI unsigned long RPC_ENTRY        NdrNonEncapsulatedUnionMemorySize( PMIDL_STUB_MESSAGE, PFORMAT_STRING );
RPCRTAPI unsigned char * RPC_ENTRY      NdrNonEncapsulatedUnionUnmarshall( PMIDL_STUB_MESSAGE, unsigned char **, PFORMAT_STRING, unsigned char );
RPCRTAPI unsigned char * RPC_ENTRY      NdrNsGetBuffer( PMIDL_STUB_MESSAGE, unsigned long, RPC_BINDING_HANDLE );
RPCRTAPI unsigned char * RPC_ENTRY      NdrNsSendReceive( PMIDL_STUB_MESSAGE, unsigned char *, RPC_BINDING_HANDLE * );
RPCRTAPI void * RPC_ENTRY               NdrOleAllocate( size_t );
RPCRTAPI void RPC_ENTRY                 NdrOleFree( void * );
RPCRTAPI void RPC_ENTRY                 NdrPartialIgnoreClientBufferSize( PMIDL_STUB_MESSAGE, void * );
RPCRTAPI void RPC_ENTRY                 NdrPartialIgnoreClientMarshall( PMIDL_STUB_MESSAGE, void * );
RPCRTAPI void RPC_ENTRY                 NdrPartialIgnoreServerInitialize( PMIDL_STUB_MESSAGE, void **, PFORMAT_STRING );
RPCRTAPI void RPC_ENTRY                 NdrPartialIgnoreServerUnmarshall( PMIDL_STUB_MESSAGE, void ** );
RPCRTAPI void RPC_ENTRY                 NdrPointerBufferSize( PMIDL_STUB_MESSAGE, unsigned char *, PFORMAT_STRING );
RPCRTAPI void RPC_ENTRY                 NdrPointerFree( PMIDL_STUB_MESSAGE, unsigned char *, PFORMAT_STRING );
RPCRTAPI unsigned char * RPC_ENTRY      NdrPointerMarshall( PMIDL_STUB_MESSAGE, unsigned char *, PFORMAT_STRING );
RPCRTAPI unsigned long RPC_ENTRY        NdrPointerMemorySize( PMIDL_STUB_MESSAGE, PFORMAT_STRING );
RPCRTAPI unsigned char * RPC_ENTRY      NdrPointerUnmarshall( PMIDL_STUB_MESSAGE, unsigned char **, PFORMAT_STRING, unsigned char );
RPCRTAPI unsigned char * RPC_ENTRY      NdrRangeUnmarshall( PMIDL_STUB_MESSAGE, unsigned char **, PFORMAT_STRING, unsigned char );
RPCRTAPI void * RPC_ENTRY               NdrRpcSmClientAllocate( size_t );
RPCRTAPI void RPC_ENTRY                 NdrRpcSmClientFree( void * );
RPCRTAPI void RPC_ENTRY                 NdrRpcSmSetClientToOsf( PMIDL_STUB_MESSAGE );
RPCRTAPI void * RPC_ENTRY               NdrRpcSsDefaultAllocate( size_t );
RPCRTAPI void RPC_ENTRY                 NdrRpcSsDefaultFree( void * );
RPCRTAPI void RPC_ENTRY                 NdrRpcSsDisableAllocate( PMIDL_STUB_MESSAGE );
RPCRTAPI void RPC_ENTRY                 NdrRpcSsEnableAllocate( PMIDL_STUB_MESSAGE );
RPCRTAPI unsigned char * RPC_ENTRY      NdrSendReceive( PMIDL_STUB_MESSAGE, unsigned char * );
RPCRTAPI void RPC_ENTRY                 NdrServerCall( PRPC_MESSAGE );
RPCRTAPI void RPC_ENTRY                 NdrServerCall2( PRPC_MESSAGE );
RPCRTAPI void RPC_ENTRY                 NdrServerContextMarshall( PMIDL_STUB_MESSAGE, NDR_SCONTEXT, NDR_RUNDOWN );
RPCRTAPI void RPC_ENTRY                 NdrServerContextNewMarshall( PMIDL_STUB_MESSAGE, NDR_SCONTEXT, NDR_RUNDOWN, PFORMAT_STRING );
RPCRTAPI NDR_SCONTEXT RPC_ENTRY         NdrServerContextNewUnmarshall( PMIDL_STUB_MESSAGE, PFORMAT_STRING );
RPCRTAPI NDR_SCONTEXT RPC_ENTRY         NdrServerContextUnmarshall( PMIDL_STUB_MESSAGE );
RPCRTAPI unsigned char * RPC_ENTRY      NdrServerInitialize( PRPC_MESSAGE, PMIDL_STUB_MESSAGE, PMIDL_STUB_DESC );
RPCRTAPI void RPC_ENTRY                 NdrServerInitializeMarshall( PRPC_MESSAGE, PMIDL_STUB_MESSAGE );
RPCRTAPI unsigned char * RPC_ENTRY      NdrServerInitializeNew( PRPC_MESSAGE, PMIDL_STUB_MESSAGE, PMIDL_STUB_DESC );
RPCRTAPI void RPC_ENTRY                 NdrServerInitializePartial( PRPC_MESSAGE, PMIDL_STUB_MESSAGE, PMIDL_STUB_DESC );
RPCRTAPI unsigned char * RPC_ENTRY      NdrServerInitializeUnmarshall( PMIDL_STUB_MESSAGE, PMIDL_STUB_DESC, PRPC_MESSAGE );
RPCRTAPI void RPC_ENTRY                 NdrServerMarshall( void *, void *, PMIDL_STUB_MESSAGE, PFORMAT_STRING );
RPCRTAPI int RPC_ENTRY                  NdrServerUnmarshall( void *, PRPC_MESSAGE, PMIDL_STUB_MESSAGE, PMIDL_STUB_DESC, PFORMAT_STRING, void * );
RPCRTAPI void RPC_ENTRY                 NdrSimpleStructBufferSize( PMIDL_STUB_MESSAGE, unsigned char *, PFORMAT_STRING );
RPCRTAPI void RPC_ENTRY                 NdrSimpleStructFree( PMIDL_STUB_MESSAGE, unsigned char *, PFORMAT_STRING );
RPCRTAPI unsigned char * RPC_ENTRY      NdrSimpleStructMarshall( PMIDL_STUB_MESSAGE, unsigned char *, PFORMAT_STRING );
RPCRTAPI unsigned long RPC_ENTRY        NdrSimpleStructMemorySize( PMIDL_STUB_MESSAGE, PFORMAT_STRING );
RPCRTAPI unsigned char * RPC_ENTRY      NdrSimpleStructUnmarshall( PMIDL_STUB_MESSAGE, unsigned char **, PFORMAT_STRING, unsigned char );
RPCRTAPI void RPC_ENTRY                 NdrSimpleTypeMarshall( PMIDL_STUB_MESSAGE, unsigned char *, unsigned char );
RPCRTAPI void RPC_ENTRY                 NdrSimpleTypeUnmarshall( PMIDL_STUB_MESSAGE, unsigned char *, unsigned char );
RPCRTAPI long RPC_ENTRY                 NdrStubCall( void *, void *, PRPC_MESSAGE, unsigned long * );
RPCRTAPI long RPC_ENTRY                 NdrStubCall2( void *, void *, PRPC_MESSAGE, unsigned long * );
RPCRTAPI void RPC_ENTRY                 NdrUserMarshalBufferSize( PMIDL_STUB_MESSAGE, unsigned char *, PFORMAT_STRING );
RPCRTAPI void RPC_ENTRY                 NdrUserMarshalFree( PMIDL_STUB_MESSAGE, unsigned char *, PFORMAT_STRING );
RPCRTAPI unsigned char * RPC_ENTRY      NdrUserMarshalMarshall( PMIDL_STUB_MESSAGE, unsigned char *, PFORMAT_STRING );
RPCRTAPI unsigned long RPC_ENTRY        NdrUserMarshalMemorySize( PMIDL_STUB_MESSAGE, PFORMAT_STRING );
RPCRTAPI unsigned char * RPC_ENTRY      NdrUserMarshalSimpleTypeConvert( unsigned long *, unsigned char *, unsigned char );
RPCRTAPI unsigned char * RPC_ENTRY      NdrUserMarshalUnmarshall( PMIDL_STUB_MESSAGE, unsigned char **, PFORMAT_STRING, unsigned char );
RPCRTAPI void RPC_ENTRY                 NdrVaryingArrayBufferSize( PMIDL_STUB_MESSAGE, unsigned char *, PFORMAT_STRING );
RPCRTAPI void RPC_ENTRY                 NdrVaryingArrayFree( PMIDL_STUB_MESSAGE, unsigned char *, PFORMAT_STRING );
RPCRTAPI unsigned char * RPC_ENTRY      NdrVaryingArrayMarshall( PMIDL_STUB_MESSAGE, unsigned char *, PFORMAT_STRING );
RPCRTAPI unsigned long RPC_ENTRY        NdrVaryingArrayMemorySize( PMIDL_STUB_MESSAGE, PFORMAT_STRING );
RPCRTAPI unsigned char * RPC_ENTRY      NdrVaryingArrayUnmarshall( PMIDL_STUB_MESSAGE, unsigned char **, PFORMAT_STRING, unsigned char );
RPCRTAPI void RPC_ENTRY                 NdrXmitOrRepAsBufferSize( PMIDL_STUB_MESSAGE, unsigned char *, PFORMAT_STRING );
RPCRTAPI void RPC_ENTRY                 NdrXmitOrRepAsFree( PMIDL_STUB_MESSAGE, unsigned char *, PFORMAT_STRING );
RPCRTAPI unsigned char * RPC_ENTRY      NdrXmitOrRepAsMarshall( PMIDL_STUB_MESSAGE, unsigned char *, PFORMAT_STRING );
RPCRTAPI unsigned long RPC_ENTRY        NdrXmitOrRepAsMemorySize( PMIDL_STUB_MESSAGE, PFORMAT_STRING );
RPCRTAPI unsigned char * RPC_ENTRY      NdrXmitOrRepAsUnmarshall( PMIDL_STUB_MESSAGE, unsigned char **, PFORMAT_STRING, unsigned char );
RPCRTAPI void * RPC_ENTRY               RpcSmAllocate( size_t, RPC_STATUS * );
RPCRTAPI RPC_STATUS RPC_ENTRY           RpcSmClientFree( void * );
RPCRTAPI RPC_STATUS RPC_ENTRY           RpcSmDestroyClientContext( void ** );
RPCRTAPI RPC_STATUS RPC_ENTRY           RpcSmDisableAllocate( void );
RPCRTAPI RPC_STATUS RPC_ENTRY           RpcSmEnableAllocate( void );
RPCRTAPI RPC_STATUS RPC_ENTRY           RpsSmFree( void * );
RPCRTAPI RPC_SS_THREAD_HANDLE RPC_ENTRY RpcSmGetThreadHandle( RPC_STATUS * );
RPCRTAPI RPC_STATUS RPC_ENTRY           RpcSmSetClientAllocFree( RPC_CLIENT_ALLOC *, RPC_CLIENT_FREE * );
RPCRTAPI RPC_STATUS RPC_ENTRY           RpcSmSetThreadHandle( RPC_SS_THREAD_HANDLE );
RPCRTAPI RPC_STATUS RPC_ENTRY           RpcSmSwapClientAllocFree( RPC_CLIENT_ALLOC *, RPC_CLIENT_FREE *, RPC_CLIENT_ALLOC **, RPC_CLIENT_FREE ** );
RPCRTAPI void * RPC_ENTRY               RpcSsAllocate( size_t );
RPCRTAPI void RPC_ENTRY                 RpcSsDestroyClientContext( void ** );
RPCRTAPI void RPC_ENTRY                 RpcSsDisableAllocate( void );
RPCRTAPI void RPC_ENTRY                 RpcSsEnableAllocate( void );
RPCRTAPI void RPC_ENTRY                 RpcSsFree( void * );
RPCRTAPI RPC_SS_THREAD_HANDLE RPC_ENTRY RpcSsGetThreadHandle( void );
RPCRTAPI void RPC_ENTRY                 RpcSsSetClientAllocFree( RPC_CLIENT_ALLOC *, RPC_CLIENT_FREE * );
RPCRTAPI void RPC_ENTRY                 RpcSsSetThreadHandle( RPC_SS_THREAD_HANDLE );
RPCRTAPI void RPC_ENTRY                 RpcSsSwapClientAllocFree( RPC_CLIENT_ALLOC *, RPC_CLIENT_FREE *, RPC_CLIENT_ALLOC **, RPC_CLIENT_FREE ** );
RPCRTAPI void RPC_ENTRY                 RpcUserFree( handle_t, void * );

/* Functions implemented as macros */
#define NDRSContextValue( x )   (&(x)->userContext)

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* __RPCNDR_H__ */
