/*
 *  ncrypt.h    Cryptography Next Generation (CNG) key storage functions
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2010 The Open Watcom Contributors. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */

#ifndef __NCRYPT_H__
#define __NCRYPT_H__

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file;
#endif

#ifdef __cplusplus
extern "C" {
#endif

#ifndef __BCRYPT_H__
    #include <bcrypt.h>
#endif

/* Security status data type */
#ifndef __SECSTATUS_DEFINED__
#define __SECSTATUS_DEFINED__
typedef LONG    SECURITY_STATUS;
#endif

/* Key storage handle data types */
typedef ULONG_PTR   NCRYPT_HANDLE;
typedef ULONG_PTR   NCRYPT_PROV_HANDLE;
typedef ULONG_PTR   NCRYPT_KEY_HANDLE;
typedef ULONG_PTR   NCRYPT_HASH_HANDLE;
typedef ULONG_PTR   NCRYPT_SECRET_HANDLE;

/* Key storage providers */
#define MS_KEY_STORAGE_PROVIDER             L"Microsoft Software Key Storage Provider"
#define MS_SMART_CARD_KEY_STORAGE_PROVIDER  L"Microsoft Smart Card Key Storage Provider"

/* Alternate names of algorithms in bcrypt.h */
#define NCRYPT_RSA_ALGORITHM        BCRYPT_RSA_ALGORITHM
#define NCRYPT_RSA_SIGN_ALGORITHM   BCRYPT_RSA_SIGN_ALGORITHM
#define NCRYPT_DH_ALGORITHM         BCRYPT_DH_ALGORITHM
#define NCRYPT_DSA_ALGORITHM        BCRYPT_DSA_ALGORITHM
#define NCRYPT_MD2_ALGORITHM        BCRYPT_MD2_ALGORITHM
#define NCRYPT_MD4_ALGORITHM        BCRYPT_MD4_ALGORITHM
#define NCRYPT_MD5_ALGORITHM        BCRYPT_MD5_ALGORITHM
#define NCRYPT_SHA1_ALGORITHM       BCRYPT_SHA1_ALGORITHM
#define NCRYPT_SHA256_ALGORITHM     BCRYPT_SHA256_ALGORITHM
#define NCRYPT_SHA384_ALGORITHM     BCRYPT_SHA384_ALGORITHM
#define NCRYPT_SHA512_ALGORITHM     BCRYPT_SHA512_ALGORITHM
#define NCRYPT_ECDSA_P256_ALGORITHM BCRYPT_ECDSA_P256_ALGORITHM
#define NCRYPT_ECDSA_P384_ALGORITHM BCRYPT_ECDSA_P384_ALGORITHM
#define NCRYPT_ECDSA_P521_ALGORITHM BCRYPT_ECDSA_P521_ALGORITHM
#define NCRYPT_ECDH_P256_ALGORITHM  BCRYPT_ECDH_P256_ALGORITHM
#define NCRYPT_ECDH_P384_ALGORITHM  BCRYPT_ECDH_P384_ALGORITHM
#define NCRYPT_ECDH_P521_ALGORITHM  BCRYPT_ECDH_P521_ALGORITHM

/* Additional algorithms */
#define NCRYPT_KEY_STORAGE_ALGORITHM    L"KEY_STORAGE"

/* Alternate names of interfaces in bcrypt.h */
#define NCRYPT_HASH_INTERFACE                   BCRYPT_HASH_INTERFACE
#define NCRYPT_ASYMMETRIC_ENCRYPTION_INTERFACE  BCRYPT_ASYMMETRIC_ENCRYPTION_INTERFACE
#define NCRYPT_SECRET_AGREEMENT_INTERFACE       BCRYPT_SECRET_AGREEMENT_INTERFACE
#define NCRYPT_SIGNATURE_INTERFACE              BCRYPT_SIGNATURE_INTERFACE

/* Additional interfaces */
#define NCRYPT_KEY_STORAGE_INTERFACE        0x00010001L
#define NCRYPT_SCHANNEL_INTERFACE           0x00010002L
#define NCRYPT_SCHANNEL_SIGNATURE_INTERFACE 0x00010003L

/* Algorithm groups */
#define NCRYPT_RSA_ALGORITHM_GROUP      NCRYPT_RSA_ALGORITHM
#define NCRYPT_DH_ALGORITHM_GROUP       NCRYPT_DH_ALGORITHM
#define NCRYPT_DSA_ALGORITHM_GROUP      NCRYPT_DSA_ALGORITHM
#define NCRYPT_ECDSA_ALGORITHM_GROUP    L"ECDSA"
#define NCRYPT_ECDH_ALGORITHM_GROUP     L"ECDH"

/* Key storage buffer version */
#define NCRYPTBUFFER_VERSION    0L

/* Key storage buffer types */
#define NCRYPTBUFFER_EMPTY                  0L
#define NCRYPTBUFFER_DATA                   1L
#define NCRYPTBUFFER_SSL_CLIENT_RANDOM      20L
#define NCRYPTBUFFER_SSL_SERVER_RANDOM      21L
#define NCRYPTBUFFER_SSL_HIGHEST_VERSION    22L
#define NCRYPTBUFFER_SSL_CLEAR_KEY          23L
#define NCRYPTBUFFER_SSL_KEY_ARG_DATA       24L
#define NCRYPTBUFFER_PKCS_OID               40L
#define NCRYPTBUFFER_PKCS_ALG_OID           41L
#define NCRYPTBUFFER_PKCS_ALG_PARAM         42L
#define NCRYPTBUFFER_PKCS_ALG_ID            43L
#define NCRYPTBUFFER_PKCS_ATTRS             44L
#define NCRYPTBUFFER_PKCS_KEY_NAME          45L
#define NCRYPTBUFFER_PKCS_SECRET            46L
#define NCRYPTBUFFER_CERT_BLOB              47L

/* Flags for various functions */
#define NCRYPT_NO_PADDING_FLAG          BCRYPT_PAD_NONE
#define NCRYPT_PAD_PKCS1_FLAG           BCRYPT_PAD_PKCS1
#define NCRYPT_PAD_OAEP_FLAG            BCRYPT_PAD_OAEP
#define NCRYPT_PAD_PSS_FLAG             BCRYPT_PAD_PSS
#define NCRYPT_NO_KEY_VALIDATION        BCRYPT_NO_KEY_VALIDATION
#define NCRYPT_MACHINE_KEY_FLAG         0x00000020L
#define NCRYPT_SILENT_FLAG              0x00000040L
#define NCRYPT_OVERWRITE_KEY_FLAG       0x00000080L
#define NCRYPT_WRITE_KEY_TO_LEGACY_STORE_FLAG   0x00000200L
#define NCRYPT_DO_NOT_FINALIZE_FLAG     0x00000400L
#define NCRYPT_PERSIST_ONLY_FLAG        0x40000000L
#define NCRYPT_PERSIST_FLAG             0x80000000L
#define NCRYPT_REGISTER_NOTIFY_FLAG     0x00000001L
#define NCRYPT_UNREGISTER_NOTIFY_FLAG   0x00000002L

/* NCryptEnumAlgorithms() flags */
#define NCRYPT_CIPHER_OPERATION                 BCRYPT_CIPHER_OPERATION
#define NCRYPT_HASH_OPERATION                   BCRYPT_HASH_OPERATION
#define NCRYPT_ASYMMETRIC_ENCRYPTION_OPERATION  BCRYPT_ASYMMETRIC_ENCRYPTION_OPERATION
#define NCRYPT_SECRET_AGREEMENT_OPERATION       BCRYPT_SECRET_AGREEMENT_OPERATION
#define NCRYPT_SIGNATURE_OPERATION              BCRYPT_SIGNATURE_OPERATION
#define NCRYPT_RNG_OPERATION                    BCRYPT_RNG_OPERATION

/* NCryptEnumKeys() flags */
#define NCRYPT_MACHINE_KEY_FLAG 0x00000020L

/* NCryptOpenKey() flags */
#define NCRYPT_SILENT_FLAG  0x00000040L

/* NCryptCreatePersistedKey() flags */
#define NCRYPT_MACHINE_KEY_FLAG     0x00000020L
#define NCRYPT_OVERWRITE_KEY_FLAG   0x00000080L

/* Key storage property names */
#define NCRYPT_NAME_PROPERTY                    L"Name"
#define NCRYPT_UNIQUE_NAME_PROPERTY             L"Unique Name"
#define NCRYPT_ALGORITHM_PROPERTY               L"Algorithm Name"
#define NCRYPT_LENGTH_PROPERTY                  L"Length"
#define NCRYPT_LENGTHS_PROPERTY                 L"Lengths"
#define NCRYPT_BLOCK_LENGTH_PROPERTY            L"Block Length"
#define NCRYPT_UI_POLICY_PROPERTY               L"UI Policy"
#define NCRYPT_EXPORT_POLICY_PROPERTY           L"Export Policy"
#define NCRYPT_WINDOW_HANDLE_PROPERTY           L"HWND Handle"
#define NCRYPT_USE_CONTEXT_PROPERTY             L"Use Context"
#define NCRYPT_IMPL_TYPE_PROPERTY               L"Impl Type"
#define NCRYPT_KEY_USAGE_PROPERTY               L"Key Usage"
#define NCRYPT_KEY_TYPE_PROPERTY                L"Key Type"
#define NCRYPT_VERSION_PROPERTY                 L"Version"
#define NCRYPT_SECURITY_DESCR_SUPPORT_PROPERTY  L"Security Descr Support"
#define NCRYPT_SECURITY_DESCR_PROPERTY          L"Security Descr"
#define NCRYPT_USE_COUNT_ENABLED_PROPERTY       L"Enabled Use Count"
#define NCRYPT_USE_COUNT_PROPERTY               L"Use Count"
#define NCRYPT_LAST_MODIFIED_PROPERTY           L"Modified"
#define NCRYPT_MAX_NAME_LENGTH_PROPERTY         L"Max Name Length"
#define NCRYPT_ALGORITHM_GROUP_PROPERTY         L"Algorithm Group"
#define NCRYPT_DH_PARAMETERS_PROPERTY           BCRYPT_DH_PARAMETERS
#define NCRYPT_PROVIDER_HANDLE_PROPERTY         L"Provider Handle"
#define NCRYPT_PIN_PROPERTY                     L"SmartCardPin"
#define NCRYPT_READER_PROPERTY                  L"SmartCardReader"
#define NCRYPT_SMARTCARD_GUID_PROPERTY          L"SmartCardGuid"
#define NCRYPT_CERTIFICATE_PROPERTY             L"SmartCardKeyCertificate"
#define NCRYPT_PIN_PROMPT_PROPERTY              L"SmartCardPinPrompt"
#define NCRYPT_USER_CERTSTORE_PROPERTY          L"SmartCardUserCertStore"
#define NCRYPT_ROOT_CERTSTORE_PROPERTY          L"SmartcardRootCertStore"
#define NCRYPT_SECURE_PIN_PROPERTY              L"SmartCardSecurePin"
#define NCRYPT_ASSOCIATED_ECDH_KEY              L"SmartCardAssociatedECDHKey"
#define NCRYPT_SCARD_PIN_ID                     L"SmartCardPinId"
#define NCRYPT_SCARD_PIN_INFO                   L"SmartCardPinInfo"

/* Property name maximum length */
#define NCRYPT_MAX_PROPERTY_NAME    64

/* Property data maximum length */
#define NCRYPT_MAX_PROPERTY_DATA    0x00100000

/* Export policy property flags */
#define NCRYPT_ALLOW_EXPORT_FLAG                0x00000001L
#define NCRYPT_ALLOW_PLAINTEXT_EXPORT_FLAG      0x00000002L
#define NCRYPT_ALLOW_ARCHIVING_FLAG             0x00000004L
#define NCRYPT_ALLOW_PLAINTEXT_ARCHIVING_FLAG   0x00000008L

/* Implementation type property flags */
#define NCRYPT_IMPL_HARDWARE_FLAG       0x00000001L
#define NCRYPT_IMPL_SOFTWARE_FLAG       0x00000002L
#define NCRYPT_IMPL_REMOVABLE_FLAG      0x00000008L
#define NCRYPT_IMPL_HARDWARE_RNG_FLAG   0x000000010L

/* Key usage property flags */
#define NCRYPT_ALLOW_DECRYPT_FLAG       0x00000001L
#define NCRYPT_ALLOW_SIGNING_FLAG       0x00000002L
#define NCRYPT_ALLOW_KEY_AGREEMENT_FLAG 0x00000004L
#define NCRYPT_ALLOW_ALL_USAGES         0x00FFFFFFL

/* UI policy property flags */
#define NCRYPT_UI_PROTECT_KEY_FLAG          0x00000001L
#define NCRYPT_UI_FORCE_HIGH_PROECTION_FLAG 0x00000002L

/* NCryptGetProperty() flags */
#define NCRYPT_PERSIST_ONLY_FLAG    0x40000000L

/* NCryptSetProperty() flags */
#define NCRYPT_PERSIST_FLAG         0x80000000L

/* NCryptFinalizeKey() flags */
#define NCRYPT_WRITE_KEY_TO_LEGACY_STORE_FLAG   0x00000200L

/* Key storage blobs */
#define NCRYPT_PKCS7_ENVELOPE_BLOB      L"PKCS7_ENVELOPE"
#define NCRYPT_PKCS8_PRIVATE_KEY_BLOB   L"PKCS8_PRIVATEKEY"
#define NCRYPT_OPAQUETRANSPORT_BLOB     L"OpaqueTransport"

/* Flags for various functions */
#define NCRYPT_MACHINE_KEY_FLAG     0x00000020L
#define NCRYPT_DO_NOT_FINALIZE_FLAG 0x00000400L
#define NCRYPT_EXPORT_LEGACY_FLAG   0x00000800L

/* NCryptNotifyChangeKey() flags */
#define NCRYPT_REGISTER_NOTIFY_FLAG     0x00000001L
#define NCRYPT_UNREGISTER_NOTIFY_FLAG   0x00000002L
#define NCRYPT_MACHINE_KEY_FLAG         0x00000020L

/* Key storage interface version */
#define NCRYPT_KEY_STORAGE_INTERFACE_VERSION    BCRYPT_MAKE_INTERFACE_VERSION( 1, 0 )

/* Key storage buffer */
typedef BCryptBuffer        NCryptBuffer;
typedef BCryptBuffer        *PNCryptBuffer;
typedef BCryptBufferDesc    NCryptBufferDesc;
typedef BCryptBufferDesc    *PNCryptBufferDesc;

/* Key storage algorithm name */
typedef struct _NCryptAlgorithmName {
    LPWSTR  pszName;
    DWORD   dwClass;
    DWORD   dwAlgOperations;
    DWORD   dwFlags;
} NCryptAlgorithmName;

/* Key storage key name */
typedef struct NCryptKeyName {
    LPWSTR  pszName;
    LPWSTR  pszAlgid;
    DWORD   dwLegacyKeySpec;
    DWORD   dwFlags;
} NCryptKeyName;

/* Key storage provider name */
typedef struct NCryptProviderName {
    LPWSTR  pszName;
    LPWSTR  pszComment;
} NCryptProviderName;

/* UI policy blob */
typedef struct __NCRYPT_UI_POLICY_BLOB {
    DWORD   dwVersion;
    DWORD   dwFlags;
    DWORD   cbCreationTitle;
    DWORD   cbFriendlyName;
    DWORD   cbDescription;
} NCRYPT_UI_POLICY_BLOB;

/* UI policy */
typedef struct __NCRYPT_UI_POLICY {
    DWORD   dwVersion;
    DWORD   dwFlags;
    LPCWSTR pszCreationTitle;
    LPCWSTR pszFriendlyName;
    LPCWSTR pszDescription;
} NCRYPT_UI_POLICY;

/* Key storage supported lengths */
typedef struct __NCRYPT_SUPPORTED_LENGTHS {
    DWORD   dwMinLength;
    DWORD   dwMaxLength;
    DWORD   dwIncrement;
    DWORD   dwDefaultLength;
} NCRYPT_SUPPORTED_LENGTHS;

/* Functions in NCRYPT.DLL */
SECURITY_STATUS WINAPI  NCryptCreatePersistedKey( NCRYPT_PROV_HANDLE, NCRYPT_KEY_HANDLE *, LPCWSTR, LPCWSTR, DWORD, DWORD );
SECURITY_STATUS WINAPI  NCryptDecrypt( NCRYPT_KEY_HANDLE, PBYTE, DWORD, VOID *, PBYTE, DWORD, DWORD *, DWORD );
SECURITY_STATUS WINAPI  NCryptDeleteKey( NCRYPT_KEY_HANDLE, DWORD );
SECURITY_STATUS WINAPI  NCryptDeriveKey( NCRYPT_SECRET_HANDLE, LPCWSTR, NCryptBufferDesc *, PBYTE, DWORD, DWORD *, ULONG );
SECURITY_STATUS WINAPI  NCryptEncrypt( NCRYPT_KEY_HANDLE, PBYTE, DWORD, VOID *, PBYTE, DWORD, DWORD *, DWORD );
SECURITY_STATUS WINAPI  NCryptEnumAlgorithms( NCRYPT_PROV_HANDLE, DWORD, DWORD *, NCryptAlgorithmName **,  DWORD );
SECURITY_STATUS WINAPI  NCryptEnumKeys( NCRYPT_PROV_HANDLE, LPCWSTR, NCryptKeyName **, PVOID *, DWORD );
SECURITY_STATUS WINAPI  NCryptEnumStorageProviders( DWORD *, NCryptProviderName **, DWORD );
SECURITY_STATUS WINAPI  NCryptExportKey( NCRYPT_KEY_HANDLE, NCRYPT_KEY_HANDLE, LPCWSTR, NCryptBufferDesc *, PBYTE, DWORD, DWORD *, DWORD );
SECURITY_STATUS WINAPI  NCryptFinalizeKey( NCRYPT_KEY_HANDLE, DWORD );
SECURITY_STATUS WINAPI  NCryptFreeBuffer( PVOID );
SECURITY_STATUS WINAPI  NCryptFreeObject( NCRYPT_HANDLE );
SECURITY_STATUS WINAPI  NCryptGetProperty( NCRYPT_HANDLE, LPCWSTR, PBYTE, DWORD, DWORD *, DWORD );
SECURITY_STATUS WINAPI  NCryptImportKey( NCRYPT_PROV_HANDLE, NCRYPT_KEY_HANDLE, LPCWSTR, NCryptBufferDesc *, NCRYPT_KEY_HANDLE *, PBYTE, DWORD, DWORD );
SECURITY_STATUS WINAPI  NCryptIsAlgSupported( NCRYPT_PROV_HANDLE, LPCWSTR, DWORD );
SECURITY_STATUS WINAPI  NCryptIsKeyHandle( NCRYPT_KEY_HANDLE );
SECURITY_STATUS WINAPI  NCryptNotifyChangeKey( NCRYPT_PROV_HANDLE, HANDLE *, DWORD );
SECURITY_STATUS WINAPI  NCryptOpenKey( NCRYPT_PROV_HANDLE, NCRYPT_KEY_HANDLE *, LPCWSTR, DWORD, DWORD );
SECURITY_STATUS WINAPI  NCryptOpenStorageProvider( NCRYPT_PROV_HANDLE *, LPCWSTR, DWORD );
SECURITY_STATUS WINAPI  NCryptSecretAgreement( NCRYPT_KEY_HANDLE, NCRYPT_KEY_HANDLE, NCRYPT_SECRET_HANDLE *, DWORD );
SECURITY_STATUS WINAPI  NCryptSetProperty( NCRYPT_HANDLE, LPCWSTR, PBYTE, DWORD, DWORD );
SECURITY_STATUS WINAPI  NCryptSignHash( NCRYPT_KEY_HANDLE, VOID *, PBYTE, DWORD, PBYTE, DWORD, DWORD *, DWORD );
SECURITY_STATUS WINAPI  NCryptTranslateHandle( NCRYPT_PROV_HANDLE *, NCRYPT_KEY_HANDLE *, HCRYPTPROV, HCRYPTKEY, DWORD, DWORD );
SECURITY_STATUS WINAPI  NCryptVerifySignature( NCRYPT_KEY_HANDLE, VOID *, PBYTE, DWORD, PBYTE, DWORD, DWORD );

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* __NCRYPT_H__ */
