/*
 * Decompiled with CFR 0.152.
 */
package me.qintinator.sleepmost;

import java.util.stream.Collectors;
import me.qintinator.sleepmost.Main;
import me.qintinator.sleepmost.statics.ConfigMessageMapper;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerBedEnterEvent;

public class OnSleep
implements Listener {
    private final Main main;
    private final ConfigMessageMapper messageMapper;

    public OnSleep(Main main) {
        this.main = main;
        this.messageMapper = new ConfigMessageMapper(this.main);
    }

    @EventHandler
    public void onPlayerSleep(PlayerBedEnterEvent e) {
        if (this.main.getConfig().get("sleep.percentage-required") == null) {
            return;
        }
        float percentageRequired = this.main.getConfig().getInt("sleep.percentage-required");
        float onlinePlayers = Bukkit.getOnlinePlayers().size();
        float playersSleepRequired = (int)Math.ceil(onlinePlayers / 100.0f * percentageRequired);
        int sleepingPlayers = Bukkit.getOnlinePlayers().stream().filter(p -> p.isSleeping()).collect(Collectors.toList()).size() + 1;
        float percentageSleeping = (float)sleepingPlayers / onlinePlayers * 100.0f;
        for (Player player : Bukkit.getOnlinePlayers()) {
            player.sendMessage(this.messageMapper.getMessage(ConfigMessageMapper.ConfigMessage.PLAYERS_LEFT_TO_SKIP_NIGHT, true).replaceFirst("%sleeping%", Integer.toString(sleepingPlayers)).replaceAll("%required%", Integer.toString(Math.round(playersSleepRequired))));
        }
        if (!(percentageSleeping >= percentageRequired)) {
            return;
        }
        ((World)Bukkit.getWorlds().get(0)).setTime(0L);
        for (Player p2 : Bukkit.getOnlinePlayers()) {
            p2.sendMessage(this.messageMapper.getMessage(ConfigMessageMapper.ConfigMessage.NIGHT_SKIPPED, true));
        }
    }
}

