/***********************************************************************
 *
 *	Copyright (c) 1995-1997, Palm Computing Inc., All Rights Reserved
 *
 * PROJECT:  Pilot
 * FILE:     Category.h
 * AUTHOR:	 Art Lamb: March 7, 1995
 *
 * DECLARER: UI
 *
 * DESCRIPTION:
 *	  This file defines category structures and routines.
 *
 ***********************************************************************/
#ifndef __CATEGORY_H__
#define __CATEGORY_H__


typedef struct {
   Word	renamedCategories;
	Char	categoryLabels [dmRecNumCategories] [dmCategoryLength];
	Byte	categoryUniqIDs[dmRecNumCategories];
	Byte	lastUniqID;	// Uniq IDs generated by the device are between
							// 0 - 127.  Those from the PC are 128 - 255.
} AppInfoType;

typedef AppInfoType * AppInfoPtr;



extern void CategoryCreateListV10 (DmOpenRef db, ListPtr lst, 
	Word currentCategory, Boolean showAll)
							SYS_TRAP(sysTrapCategoryCreateListV10);

extern void CategoryCreateList (DmOpenRef db, ListPtr listP, 
	Word currentCategory, Boolean showAll, 
	Boolean showUneditables, Byte numUneditableCategories, 
	DWord editingStrID, Boolean resizeList)
							SYS_TRAP(sysTrapCategoryCreateList);


extern void CategoryFreeListV10 (DmOpenRef db, ListPtr lst)
							SYS_TRAP(sysTrapCategoryFreeListV10);

extern void CategoryFreeList (DmOpenRef db, ListPtr listP, 
	Boolean showAll, DWord editingStrID)
							SYS_TRAP(sysTrapCategoryFreeList);

extern Word CategoryFind (DmOpenRef db, CharPtr name)
							SYS_TRAP(sysTrapCategoryFind);

extern void CategoryGetName (DmOpenRef db, Word index, CharPtr name)
							SYS_TRAP(sysTrapCategoryGetName);

extern Boolean CategoryEditV10 (DmOpenRef db, WordPtr category)
							SYS_TRAP(sysTrapCategoryEditV10);

extern Boolean CategoryEdit (DmOpenRef db, WordPtr category, DWord titleStrID)
							SYS_TRAP(sysTrapCategoryEdit);

extern Boolean CategorySelectV10 (DmOpenRef db, FormPtr frm, Word ctlID, 
	Word lstID,	Boolean title, WordPtr categoryP, CharPtr categoryName)
							SYS_TRAP(sysTrapCategorySelectV10);

extern Boolean CategorySelect (DmOpenRef db, FormPtr frm, Word ctlID, 
	Word lstID,	Boolean title, WordPtr categoryP, CharPtr categoryName, 
	Byte numUneditableCategories, DWord editingStrID)
							SYS_TRAP(sysTrapCategorySelect);

extern Word CategoryGetNext (DmOpenRef db, Word index)
							SYS_TRAP(sysTrapCategoryGetNext);

extern void CategorySetTriggerLabel (ControlPtr ctl, CharPtr name)
							SYS_TRAP(sysTrapCategorySetTriggerLabel);

extern void CategoryTruncateName (CharPtr name, Word maxWidth)
							SYS_TRAP(sysTrapCategoryTruncateName);

extern void CategoryInitialize (AppInfoPtr appInfoP, Word localizedAppInfoStrID)
							SYS_TRAP(sysTrapCategoryInitialize);


extern void CategorySetName (DmOpenRef db, Word index, CharPtr nameP)
							SYS_TRAP(sysTrapCategorySetName);

#endif // __CATEGORY_H__
