/******************************************************************************
 *
 * Copyright (c) 2002-2004 PalmSource, Inc. All rights reserved.
 *
 * File: CharGB.h
 *
 * Release: eclipse 5 SDK (68K) R4.
 *
 * Description:
 *         	Header file for GB (Simplified Chinese) coded character set.
 *
 *****************************************************************************/

#ifndef __CHARGB_H__
#define __CHARGB_H__

/***********************************************************************
 * Public macros
 ***********************************************************************/

#define	TxtCharIsZhuyin(ch)		(	(TxtCharXAttr(ch) & charXClassGBMask)	\
								==	charXClassGBZhuyin)

/***********************************************************************
 * Public constants
 ***********************************************************************/

// Transliteration operations that are not universal, but can be applied
// to Simplified Chinese text.

#define	translitOpGBFullToHalfAscii	(translitOpCustomBase+0)
#define	translitOpGBHalfToFullAscii	(translitOpCustomBase+1)

// Extended character attributes for the GB2312 character set.
// Note that these attributes have to be on an encoding basis, since
// they're shared across all languages which use this encoding. For
// GB there's only one language, so we're OK to encode wrapping
// info here, which is often language-dependent.

#define	charXAttrGBMask				0x00ff
#define	charXAttrGBFollowing		0x0001
#define	charXAttrGBLeading			0x0002
#define	charXAttrGBBreak			0x0004

#define	charXClassGBMask			0x0f00
#define	charXClassGBAscii			0x0100
#define	charXClassGBHiragana		0x0200
#define	charXClassGBKatakana		0x0300
#define	charXClassGBGreek			0x0400
#define	charXClassGBCyrillic		0x0500
#define	charXClassGBPinyin			0x0600
#define	charXClassGBZhuyin			0x0700
#define	charXClassGBHanziL1			0x0800
#define	charXClassGBHanziL2			0x0900
#define	charXClassGBHanziOther		0x0a00
#define	charXClassGBOther			0x0b00
#define	charXClassGBUndefined		0x0c00

// Note that these values, as well as the first/last double byte
// constants defined below, are for GBK (Windows CP936). We treat
// the entire GBK range as "valid", though our font, character
// attributes, sorting, etc. only has defined values for GB2312.
#define kGBFirstHighByte									0x81
#define kGBLastHighByte										0xFE
#define kGBFirstLowByte										0x40
#define kGBLastLowByte										0xFE

// Character codes that are specific to GB. These names
// are generated from the Unicode 3.1 data files.

#define	chrGBReverseSolidus									0x005c	// Is yen char in Japanese fonts.
#define	chrGBEuroSign										0x0080

#define	chrGBFirstDoubleByte								0x8140

#define	chrGBIdeographicSpace								0xa1a1
#define	chrGBIdeographicComma								0xa1a2
#define	chrGBIdeographicFullStop							0xa1a3
#define	chrGBMiddleDot										0xa1a4
#define	chrGBModifierMacron									0xa1a5
#define	chrGBCaron											0xa1a6
#define	chrGBDiaeresis										0xa1a7
#define	chrGBDittoMark										0xa1a8
#define	chrGBIdeographicIterationMark						0xa1a9
#define	chrGBEmDash											0xa1aa
#define	chrGBFullwidthTilde									0xa1ab
#define	chrGBDoubleVerticalLine								0xa1ac
#define	chrGBHorizontalEllipsis								0xa1ad
#define	chrGBLeftSingleQuotationMark						0xa1ae
#define	chrGBRightSingleQuotationMark						0xa1af
#define	chrGBLeftDoubleQuotationMark						0xa1b0
#define	chrGBRightDoubleQuotationMark						0xa1b1
#define	chrGBLeftTortoiseShellBracket						0xa1b2
#define	chrGBRightTortoiseShellBracket						0xa1b3
#define	chrGBLeftAngleBracket								0xa1b4
#define	chrGBRightAngleBracket								0xa1b5
#define	chrGBLeftDoubleAngleBracket							0xa1b6
#define	chrGBRightDoubleAngleBracket						0xa1b7
#define	chrGBLeftCornerBracket								0xa1b8
#define	chrGBRightCornerBracket								0xa1b9
#define	chrGBLeftWhiteCornerBracket							0xa1ba
#define	chrGBRightWhiteCornerBracket						0xa1bb
#define	chrGBLeftWhiteLenticularBracket						0xa1bc
#define	chrGBRightWhiteLenticularBracket					0xa1bd
#define	chrGBLeftBlackLenticularBracket						0xa1be
#define	chrGBRightBlackLenticularBracket					0xa1bf
#define	chrGBPlusMinusSign									0xa1c0
#define	chrGBMultiplicationSign								0xa1c1
#define	chrGBDivisionSign									0xa1c2
#define	chrGBRatio											0xa1c3
#define	chrGBLogicalAnd										0xa1c4
#define	chrGBLogicalOr										0xa1c5
#define	chrGBNArySummation									0xa1c6
#define	chrGBNAryProduct									0xa1c7
#define	chrGBUnion											0xa1c8
#define	chrGBIntersection									0xa1c9
#define	chrGBElementOf										0xa1ca
#define	chrGBProportion										0xa1cb
#define	chrGBSquareRoot										0xa1cc
#define	chrGBUpTack											0xa1cd
#define	chrGBParallelTo										0xa1ce
#define	chrGBAngle											0xa1cf
#define	chrGBArc											0xa1d0
#define	chrGBCircledDotOperator								0xa1d1
#define	chrGBIntegral										0xa1d2
#define	chrGBContourIntegral								0xa1d3
#define	chrGBIdenticalTo									0xa1d4
#define	chrGBAllEqualTo										0xa1d5
#define	chrGBAlmostEqualTo									0xa1d6
#define	chrGBReversedTilde									0xa1d7
#define	chrGBProportionalTo									0xa1d8
#define	chrGBNotEqualTo										0xa1d9
#define	chrGBNotLessThan									0xa1da
#define	chrGBNotGreaterThan									0xa1db
#define	chrGBLessThanOrEqualTo								0xa1dc
#define	chrGBGreaterThanOrEqualTo							0xa1dd
#define	chrGBInfinity										0xa1de
#define	chrGBBecause										0xa1df
#define	chrGBTherefore										0xa1e0
#define	chrGBMaleSign										0xa1e1
#define	chrGBFemaleSign										0xa1e2
#define	chrGBDegreeSign										0xa1e3
#define	chrGBPrime											0xa1e4
#define	chrGBDoublePrime									0xa1e5
#define	chrGBDegreeCelsius									0xa1e6
#define	chrGBFullwidthDollarSign							0xa1e7
#define	chrGBCurrencySign									0xa1e8
#define	chrGBFullwidthCentSign								0xa1e9
#define	chrGBFullwidthPoundSign								0xa1ea
#define	chrGBPerMilleSign									0xa1eb
#define	chrGBSectionSign									0xa1ec
#define	chrGBNumeroSign										0xa1ed
#define	chrGBWhiteStar										0xa1ee
#define	chrGBBlackStar										0xa1ef
#define	chrGBWhiteCircle									0xa1f0
#define	chrGBBlackCircle									0xa1f1
#define	chrGBBullseye										0xa1f2
#define	chrGBWhiteDiamond									0xa1f3
#define	chrGBBlackDiamond									0xa1f4
#define	chrGBWhiteSquare									0xa1f5
#define	chrGBBlackSquare									0xa1f6
#define	chrGBWhiteUpPointingTriangle						0xa1f7
#define	chrGBBlackUpPointingTriangle						0xa1f8
#define	chrGBReferenceMark									0xa1f9
#define	chrGBRightwardsArrow								0xa1fa
#define	chrGBLeftwardsArrow									0xa1fb
#define	chrGBUpwardsArrow									0xa1fc
#define	chrGBDownwardsArrow									0xa1fd
#define	chrGBGetaMark										0xa1fe
#define	chrGBSmallRomanNumeralOne							0xa2a1
#define	chrGBSmallRomanNumeralTwo							0xa2a2
#define	chrGBSmallRomanNumeralThree							0xa2a3
#define	chrGBSmallRomanNumeralFour							0xa2a4
#define	chrGBSmallRomanNumeralFive							0xa2a5
#define	chrGBSmallRomanNumeralSix							0xa2a6
#define	chrGBSmallRomanNumeralSeven							0xa2a7
#define	chrGBSmallRomanNumeralEight							0xa2a8
#define	chrGBSmallRomanNumeralNine							0xa2a9
#define	chrGBSmallRomanNumeralTen							0xa2aa
#define	chrGBDigitOneFullStop								0xa2b1
#define	chrGBDigitTwoFullStop								0xa2b2
#define	chrGBDigitThreeFullStop								0xa2b3
#define	chrGBDigitFourFullStop								0xa2b4
#define	chrGBDigitFiveFullStop								0xa2b5
#define	chrGBDigitSixFullStop								0xa2b6
#define	chrGBDigitSevenFullStop								0xa2b7
#define	chrGBDigitEightFullStop								0xa2b8
#define	chrGBDigitNineFullStop								0xa2b9
#define	chrGBNumberTenFullStop								0xa2ba
#define	chrGBNumberElevenFullStop							0xa2bb
#define	chrGBNumberTwelveFullStop							0xa2bc
#define	chrGBNumberThirteenFullStop							0xa2bd
#define	chrGBNumberFourteenFullStop							0xa2be
#define	chrGBNumberFifteenFullStop							0xa2bf
#define	chrGBNumberSixteenFullStop							0xa2c0
#define	chrGBNumberSeventeenFullStop						0xa2c1
#define	chrGBNumberEighteenFullStop							0xa2c2
#define	chrGBNumberNineteenFullStop							0xa2c3
#define	chrGBNumberTwentyFullStop							0xa2c4
#define	chrGBParenthesizedDigitOne							0xa2c5
#define	chrGBParenthesizedDigitTwo							0xa2c6
#define	chrGBParenthesizedDigitThree						0xa2c7
#define	chrGBParenthesizedDigitFour							0xa2c8
#define	chrGBParenthesizedDigitFive							0xa2c9
#define	chrGBParenthesizedDigitSix							0xa2ca
#define	chrGBParenthesizedDigitSeven						0xa2cb
#define	chrGBParenthesizedDigitEight						0xa2cc
#define	chrGBParenthesizedDigitNine							0xa2cd
#define	chrGBParenthesizedNumberTen							0xa2ce
#define	chrGBParenthesizedNumberEleven						0xa2cf
#define	chrGBParenthesizedNumberTwelve						0xa2d0
#define	chrGBParenthesizedNumberThirteen					0xa2d1
#define	chrGBParenthesizedNumberFourteen					0xa2d2
#define	chrGBParenthesizedNumberFifteen						0xa2d3
#define	chrGBParenthesizedNumberSixteen						0xa2d4
#define	chrGBParenthesizedNumberSeventeen					0xa2d5
#define	chrGBParenthesizedNumberEighteen					0xa2d6
#define	chrGBParenthesizedNumberNineteen					0xa2d7
#define	chrGBParenthesizedNumberTwenty						0xa2d8
#define	chrGBCircledDigitOne								0xa2d9
#define	chrGBCircledDigitTwo								0xa2da
#define	chrGBCircledDigitThree								0xa2db
#define	chrGBCircledDigitFour								0xa2dc
#define	chrGBCircledDigitFive								0xa2dd
#define	chrGBCircledDigitSix								0xa2de
#define	chrGBCircledDigitSeven								0xa2df
#define	chrGBCircledDigitEight								0xa2e0
#define	chrGBCircledDigitNine								0xa2e1
#define	chrGBCircledNumberTen								0xa2e2
#define chrGBFullwidthCopyrightSign							0xa2e3
#define	chrGBParenthesizedIdeographOne						0xa2e5
#define	chrGBParenthesizedIdeographTwo						0xa2e6
#define	chrGBParenthesizedIdeographThree					0xa2e7
#define	chrGBParenthesizedIdeographFour						0xa2e8
#define	chrGBParenthesizedIdeographFive						0xa2e9
#define	chrGBParenthesizedIdeographSix						0xa2ea
#define	chrGBParenthesizedIdeographSeven					0xa2eb
#define	chrGBParenthesizedIdeographEight					0xa2ec
#define	chrGBParenthesizedIdeographNine						0xa2ed
#define	chrGBParenthesizedIdeographTen						0xa2ee
#define chrGBFullwidthRegisteredSign						0xa2ef
#define chrGBFullwidthTradeMarkSign							0xa2f0
#define	chrGBRomanNumeralOne								0xa2f1
#define	chrGBRomanNumeralTwo								0xa2f2
#define	chrGBRomanNumeralThree								0xa2f3
#define	chrGBRomanNumeralFour								0xa2f4
#define	chrGBRomanNumeralFive								0xa2f5
#define	chrGBRomanNumeralSix								0xa2f6
#define	chrGBRomanNumeralSeven								0xa2f7
#define	chrGBRomanNumeralEight								0xa2f8
#define	chrGBRomanNumeralNine								0xa2f9
#define	chrGBRomanNumeralTen								0xa2fa
#define	chrGBRomanNumeralEleven								0xa2fb
#define	chrGBRomanNumeralTwelve								0xa2fc
#define	chrGBFullwidthExclamationMark						0xa3a1
#define	chrGBFullwidthQuotationMark							0xa3a2
#define	chrGBFullwidthNumberSign							0xa3a3
#define	chrGBFullwidthYenSign								0xa3a4
#define	chrGBFullwidthPercentSign							0xa3a5
#define	chrGBFullwidthAmpersand								0xa3a6
#define	chrGBFullwidthApostrophe							0xa3a7
#define	chrGBFullwidthLeftParenthesis						0xa3a8
#define	chrGBFullwidthRightParenthesis						0xa3a9
#define	chrGBFullwidthAsterisk								0xa3aa
#define	chrGBFullwidthPlusSign								0xa3ab
#define	chrGBFullwidthComma									0xa3ac
#define	chrGBFullwidthHyphenMinus							0xa3ad
#define	chrGBFullwidthFullStop								0xa3ae
#define	chrGBFullwidthSolidus								0xa3af
#define	chrGBFullwidthDigitZero								0xa3b0
#define	chrGBFullwidthDigitOne								0xa3b1
#define	chrGBFullwidthDigitTwo								0xa3b2
#define	chrGBFullwidthDigitThree							0xa3b3
#define	chrGBFullwidthDigitFour								0xa3b4
#define	chrGBFullwidthDigitFive								0xa3b5
#define	chrGBFullwidthDigitSix								0xa3b6
#define	chrGBFullwidthDigitSeven							0xa3b7
#define	chrGBFullwidthDigitEight							0xa3b8
#define	chrGBFullwidthDigitNine								0xa3b9
#define	chrGBFullwidthColon									0xa3ba
#define	chrGBFullwidthSemicolon								0xa3bb
#define	chrGBFullwidthLessThanSign							0xa3bc
#define	chrGBFullwidthEqualsSign							0xa3bd
#define	chrGBFullwidthGreaterThanSign						0xa3be
#define	chrGBFullwidthQuestionMark							0xa3bf
#define	chrGBFullwidthCommercialAt							0xa3c0
#define	chrGBFullwidthCapital_A								0xa3c1
#define	chrGBFullwidthCapital_B								0xa3c2
#define	chrGBFullwidthCapital_C								0xa3c3
#define	chrGBFullwidthCapital_D								0xa3c4
#define	chrGBFullwidthCapital_E								0xa3c5
#define	chrGBFullwidthCapital_F								0xa3c6
#define	chrGBFullwidthCapital_G								0xa3c7
#define	chrGBFullwidthCapital_H								0xa3c8
#define	chrGBFullwidthCapital_I								0xa3c9
#define	chrGBFullwidthCapital_J								0xa3ca
#define	chrGBFullwidthCapital_K								0xa3cb
#define	chrGBFullwidthCapital_L								0xa3cc
#define	chrGBFullwidthCapital_M								0xa3cd
#define	chrGBFullwidthCapital_N								0xa3ce
#define	chrGBFullwidthCapital_O								0xa3cf
#define	chrGBFullwidthCapital_P								0xa3d0
#define	chrGBFullwidthCapital_Q								0xa3d1
#define	chrGBFullwidthCapital_R								0xa3d2
#define	chrGBFullwidthCapital_S								0xa3d3
#define	chrGBFullwidthCapital_T								0xa3d4
#define	chrGBFullwidthCapital_U								0xa3d5
#define	chrGBFullwidthCapital_V								0xa3d6
#define	chrGBFullwidthCapital_W								0xa3d7
#define	chrGBFullwidthCapital_X								0xa3d8
#define	chrGBFullwidthCapital_Y								0xa3d9
#define	chrGBFullwidthCapital_Z								0xa3da
#define	chrGBFullwidthLeftSquareBracket						0xa3db
#define	chrGBFullwidthReverseSolidus						0xa3dc
#define	chrGBFullwidthRightSquareBracket					0xa3dd
#define	chrGBFullwidthCircumflexAccent						0xa3de
#define	chrGBFullwidthLowLine								0xa3df
#define	chrGBFullwidthGraveAccent							0xa3e0
#define	chrGBFullwidthSmall_A								0xa3e1
#define	chrGBFullwidthSmall_B								0xa3e2
#define	chrGBFullwidthSmall_C								0xa3e3
#define	chrGBFullwidthSmall_D								0xa3e4
#define	chrGBFullwidthSmall_E								0xa3e5
#define	chrGBFullwidthSmall_F								0xa3e6
#define	chrGBFullwidthSmall_G								0xa3e7
#define	chrGBFullwidthSmall_H								0xa3e8
#define	chrGBFullwidthSmall_I								0xa3e9
#define	chrGBFullwidthSmall_J								0xa3ea
#define	chrGBFullwidthSmall_K								0xa3eb
#define	chrGBFullwidthSmall_L								0xa3ec
#define	chrGBFullwidthSmall_M								0xa3ed
#define	chrGBFullwidthSmall_N								0xa3ee
#define	chrGBFullwidthSmall_O								0xa3ef
#define	chrGBFullwidthSmall_P								0xa3f0
#define	chrGBFullwidthSmall_Q								0xa3f1
#define	chrGBFullwidthSmall_R								0xa3f2
#define	chrGBFullwidthSmall_S								0xa3f3
#define	chrGBFullwidthSmall_T								0xa3f4
#define	chrGBFullwidthSmall_U								0xa3f5
#define	chrGBFullwidthSmall_V								0xa3f6
#define	chrGBFullwidthSmall_W								0xa3f7
#define	chrGBFullwidthSmall_X								0xa3f8
#define	chrGBFullwidthSmall_Y								0xa3f9
#define	chrGBFullwidthSmall_Z								0xa3fa
#define	chrGBFullwidthLeftCurlyBracket						0xa3fb
#define	chrGBFullwidthVerticalLine							0xa3fc
#define	chrGBFullwidthRightCurlyBracket						0xa3fd
#define	chrGBFullwidthMacron								0xa3fe
#define	chrGBHiraganaSmall_A								0xa4a1
#define	chrGBHiragana_A										0xa4a2
#define	chrGBHiraganaSmall_I								0xa4a3
#define	chrGBHiragana_I										0xa4a4
#define	chrGBHiraganaSmall_U								0xa4a5
#define	chrGBHiragana_U										0xa4a6
#define	chrGBHiraganaSmall_E								0xa4a7
#define	chrGBHiragana_E										0xa4a8
#define	chrGBHiraganaSmall_O								0xa4a9
#define	chrGBHiragana_O										0xa4aa
#define	chrGBHiragana_KA									0xa4ab
#define	chrGBHiragana_GA									0xa4ac
#define	chrGBHiragana_KI									0xa4ad
#define	chrGBHiragana_GI									0xa4ae
#define	chrGBHiragana_KU									0xa4af
#define	chrGBHiragana_GU									0xa4b0
#define	chrGBHiragana_KE									0xa4b1
#define	chrGBHiragana_GE									0xa4b2
#define	chrGBHiragana_KO									0xa4b3
#define	chrGBHiragana_GO									0xa4b4
#define	chrGBHiragana_SA									0xa4b5
#define	chrGBHiragana_ZA									0xa4b6
#define	chrGBHiragana_SI									0xa4b7
#define	chrGBHiragana_ZI									0xa4b8
#define	chrGBHiragana_SU									0xa4b9
#define	chrGBHiragana_ZU									0xa4ba
#define	chrGBHiragana_SE									0xa4bb
#define	chrGBHiragana_ZE									0xa4bc
#define	chrGBHiragana_SO									0xa4bd
#define	chrGBHiragana_ZO									0xa4be
#define	chrGBHiragana_TA									0xa4bf
#define	chrGBHiragana_DA									0xa4c0
#define	chrGBHiragana_TI									0xa4c1
#define	chrGBHiragana_DI									0xa4c2
#define	chrGBHiraganaSmall_TU								0xa4c3
#define	chrGBHiragana_TU									0xa4c4
#define	chrGBHiragana_DU									0xa4c5
#define	chrGBHiragana_TE									0xa4c6
#define	chrGBHiragana_DE									0xa4c7
#define	chrGBHiragana_TO									0xa4c8
#define	chrGBHiragana_DO									0xa4c9
#define	chrGBHiragana_NA									0xa4ca
#define	chrGBHiragana_NI									0xa4cb
#define	chrGBHiragana_NU									0xa4cc
#define	chrGBHiragana_NE									0xa4cd
#define	chrGBHiragana_NO									0xa4ce
#define	chrGBHiragana_HA									0xa4cf
#define	chrGBHiragana_BA									0xa4d0
#define	chrGBHiragana_PA									0xa4d1
#define	chrGBHiragana_HI									0xa4d2
#define	chrGBHiragana_BI									0xa4d3
#define	chrGBHiragana_PI									0xa4d4
#define	chrGBHiragana_HU									0xa4d5
#define	chrGBHiragana_BU									0xa4d6
#define	chrGBHiragana_PU									0xa4d7
#define	chrGBHiragana_HE									0xa4d8
#define	chrGBHiragana_BE									0xa4d9
#define	chrGBHiragana_PE									0xa4da
#define	chrGBHiragana_HO									0xa4db
#define	chrGBHiragana_BO									0xa4dc
#define	chrGBHiragana_PO									0xa4dd
#define	chrGBHiragana_MA									0xa4de
#define	chrGBHiragana_MI									0xa4df
#define	chrGBHiragana_MU									0xa4e0
#define	chrGBHiragana_ME									0xa4e1
#define	chrGBHiragana_MO									0xa4e2
#define	chrGBHiraganaSmall_YA								0xa4e3
#define	chrGBHiragana_YA									0xa4e4
#define	chrGBHiraganaSmall_YU								0xa4e5
#define	chrGBHiragana_YU									0xa4e6
#define	chrGBHiraganaSmall_YO								0xa4e7
#define	chrGBHiragana_YO									0xa4e8
#define	chrGBHiragana_RA									0xa4e9
#define	chrGBHiragana_RI									0xa4ea
#define	chrGBHiragana_RU									0xa4eb
#define	chrGBHiragana_RE									0xa4ec
#define	chrGBHiragana_RO									0xa4ed
#define	chrGBHiraganaSmall_WA								0xa4ee
#define	chrGBHiragana_WA									0xa4ef
#define	chrGBHiragana_WI									0xa4f0
#define	chrGBHiragana_WE									0xa4f1
#define	chrGBHiragana_WO									0xa4f2
#define	chrGBHiragana_N										0xa4f3
#define	chrGBKatakanaSmall_A								0xa5a1
#define	chrGBKatakana_A										0xa5a2
#define	chrGBKatakanaSmall_I								0xa5a3
#define	chrGBKatakana_I										0xa5a4
#define	chrGBKatakanaSmall_U								0xa5a5
#define	chrGBKatakana_U										0xa5a6
#define	chrGBKatakanaSmall_E								0xa5a7
#define	chrGBKatakana_E										0xa5a8
#define	chrGBKatakanaSmall_O								0xa5a9
#define	chrGBKatakana_O										0xa5aa
#define	chrGBKatakana_KA									0xa5ab
#define	chrGBKatakana_GA									0xa5ac
#define	chrGBKatakana_KI									0xa5ad
#define	chrGBKatakana_GI									0xa5ae
#define	chrGBKatakana_KU									0xa5af
#define	chrGBKatakana_GU									0xa5b0
#define	chrGBKatakana_KE									0xa5b1
#define	chrGBKatakana_GE									0xa5b2
#define	chrGBKatakana_KO									0xa5b3
#define	chrGBKatakana_GO									0xa5b4
#define	chrGBKatakana_SA									0xa5b5
#define	chrGBKatakana_ZA									0xa5b6
#define	chrGBKatakana_SI									0xa5b7
#define	chrGBKatakana_ZI									0xa5b8
#define	chrGBKatakana_SU									0xa5b9
#define	chrGBKatakana_ZU									0xa5ba
#define	chrGBKatakana_SE									0xa5bb
#define	chrGBKatakana_ZE									0xa5bc
#define	chrGBKatakana_SO									0xa5bd
#define	chrGBKatakana_ZO									0xa5be
#define	chrGBKatakana_TA									0xa5bf
#define	chrGBKatakana_DA									0xa5c0
#define	chrGBKatakana_TI									0xa5c1
#define	chrGBKatakana_DI									0xa5c2
#define	chrGBKatakanaSmall_TU								0xa5c3
#define	chrGBKatakana_TU									0xa5c4
#define	chrGBKatakana_DU									0xa5c5
#define	chrGBKatakana_TE									0xa5c6
#define	chrGBKatakana_DE									0xa5c7
#define	chrGBKatakana_TO									0xa5c8
#define	chrGBKatakana_DO									0xa5c9
#define	chrGBKatakana_NA									0xa5ca
#define	chrGBKatakana_NI									0xa5cb
#define	chrGBKatakana_NU									0xa5cc
#define	chrGBKatakana_NE									0xa5cd
#define	chrGBKatakana_NO									0xa5ce
#define	chrGBKatakana_HA									0xa5cf
#define	chrGBKatakana_BA									0xa5d0
#define	chrGBKatakana_PA									0xa5d1
#define	chrGBKatakana_HI									0xa5d2
#define	chrGBKatakana_BI									0xa5d3
#define	chrGBKatakana_PI									0xa5d4
#define	chrGBKatakana_HU									0xa5d5
#define	chrGBKatakana_BU									0xa5d6
#define	chrGBKatakana_PU									0xa5d7
#define	chrGBKatakana_HE									0xa5d8
#define	chrGBKatakana_BE									0xa5d9
#define	chrGBKatakana_PE									0xa5da
#define	chrGBKatakana_HO									0xa5db
#define	chrGBKatakana_BO									0xa5dc
#define	chrGBKatakana_PO									0xa5dd
#define	chrGBKatakana_MA									0xa5de
#define	chrGBKatakana_MI									0xa5df
#define	chrGBKatakana_MU									0xa5e0
#define	chrGBKatakana_ME									0xa5e1
#define	chrGBKatakana_MO									0xa5e2
#define	chrGBKatakanaSmall_YA								0xa5e3
#define	chrGBKatakana_YA									0xa5e4
#define	chrGBKatakanaSmall_YU								0xa5e5
#define	chrGBKatakana_YU									0xa5e6
#define	chrGBKatakanaSmall_YO								0xa5e7
#define	chrGBKatakana_YO									0xa5e8
#define	chrGBKatakana_RA									0xa5e9
#define	chrGBKatakana_RI									0xa5ea
#define	chrGBKatakana_RU									0xa5eb
#define	chrGBKatakana_RE									0xa5ec
#define	chrGBKatakana_RO									0xa5ed
#define	chrGBKatakanaSmall_WA								0xa5ee
#define	chrGBKatakana_WA									0xa5ef
#define	chrGBKatakana_WI									0xa5f0
#define	chrGBKatakana_WE									0xa5f1
#define	chrGBKatakana_WO									0xa5f2
#define	chrGBKatakana_N										0xa5f3
#define	chrGBKatakana_VU									0xa5f4
#define	chrGBKatakanaSmall_KA								0xa5f5
#define	chrGBKatakanaSmall_KE								0xa5f6
#define	chrGBGreekCapital_ALPHA								0xa6a1
#define	chrGBGreekCapital_BETA								0xa6a2
#define	chrGBGreekCapital_GAMMA								0xa6a3
#define	chrGBGreekCapital_DELTA								0xa6a4
#define	chrGBGreekCapital_EPSILON							0xa6a5
#define	chrGBGreekCapital_ZETA								0xa6a6
#define	chrGBGreekCapital_ETA								0xa6a7
#define	chrGBGreekCapital_THETA								0xa6a8
#define	chrGBGreekCapital_IOTA								0xa6a9
#define	chrGBGreekCapital_KAPPA								0xa6aa
#define	chrGBGreekCapital_LAMDA								0xa6ab
#define	chrGBGreekCapital_MU								0xa6ac
#define	chrGBGreekCapital_NU								0xa6ad
#define	chrGBGreekCapital_XI								0xa6ae
#define	chrGBGreekCapital_OMICRON							0xa6af
#define	chrGBGreekCapital_PI								0xa6b0
#define	chrGBGreekCapital_RHO								0xa6b1
#define	chrGBGreekCapital_SIGMA								0xa6b2
#define	chrGBGreekCapital_TAU								0xa6b3
#define	chrGBGreekCapital_UPSILON							0xa6b4
#define	chrGBGreekCapital_PHI								0xa6b5
#define	chrGBGreekCapital_CHI								0xa6b6
#define	chrGBGreekCapital_PSI								0xa6b7
#define	chrGBGreekCapital_OMEGA								0xa6b8
#define	chrGBGreekSmall_ALPHA								0xa6c1
#define	chrGBGreekSmall_BETA								0xa6c2
#define	chrGBGreekSmall_GAMMA								0xa6c3
#define	chrGBGreekSmall_DELTA								0xa6c4
#define	chrGBGreekSmall_EPSILON								0xa6c5
#define	chrGBGreekSmall_ZETA								0xa6c6
#define	chrGBGreekSmall_ETA									0xa6c7
#define	chrGBGreekSmall_THETA								0xa6c8
#define	chrGBGreekSmall_IOTA								0xa6c9
#define	chrGBGreekSmall_KAPPA								0xa6ca
#define	chrGBGreekSmall_LAMDA								0xa6cb
#define	chrGBGreekSmall_MU									0xa6cc
#define	chrGBGreekSmall_NU									0xa6cd
#define	chrGBGreekSmall_XI									0xa6ce
#define	chrGBGreekSmall_OMICRON								0xa6cf
#define	chrGBGreekSmall_PI									0xa6d0
#define	chrGBGreekSmall_RHO									0xa6d1
#define	chrGBGreekSmall_SIGMA								0xa6d2
#define	chrGBGreekSmall_TAU									0xa6d3
#define	chrGBGreekSmall_UPSILON								0xa6d4
#define	chrGBGreekSmall_PHI									0xa6d5
#define	chrGBGreekSmall_CHI									0xa6d6
#define	chrGBGreekSmall_PSI									0xa6d7
#define	chrGBGreekSmall_OMEGA								0xa6d8
#define	chrGBVerticalFormLeftParenthesis					0xa6e0
#define	chrGBVerticalFormRightParenthesis					0xa6e1
#define	chrGBVerticalFormLeftTortoiseShellBracket			0xa6e2
#define	chrGBVerticalFormRightTortoiseShellBracket			0xa6e3
#define	chrGBVerticalFormLeftAngleBracket					0xa6e4
#define	chrGBVerticalFormRightAngleBracket					0xa6e5
#define	chrGBVerticalFormLeftDoubleAngleBracket				0xa6e6
#define	chrGBVerticalFormRightDoubleAngleBracket			0xa6e7
#define	chrGBVerticalFormLeftCornerBracket					0xa6e8
#define	chrGBVerticalFormRightCornerBracket					0xa6e9
#define	chrGBVerticalFormLeftWhiteCornerBracket				0xa6ea
#define	chrGBVerticalFormRightWhiteCornerBracket			0xa6eb
#define	chrGBVerticalFormLeftBlackLenticularBracket			0xa6ee
#define	chrGBVerticalFormRightBlackLenticularBracket		0xa6ef
#define	chrGBVerticalFormLeftCurlyBracket					0xa6f0
#define	chrGBVerticalFormRightCurlyBracket					0xa6f1
#define	chrGBVerticalFormEmDash								0xa6f2
#define	chrGBVerticalFormLowLine							0xa6f4
#define	chrGBVerticalFormWavyLowLine						0xa6f5
#define	chrGBCyrillicCapital_A								0xa7a1
#define	chrGBCyrillicCapital_BE								0xa7a2
#define	chrGBCyrillicCapital_VE								0xa7a3
#define	chrGBCyrillicCapital_GHE							0xa7a4
#define	chrGBCyrillicCapital_DE								0xa7a5
#define	chrGBCyrillicCapital_IE								0xa7a6
#define	chrGBCyrillicCapital_IO								0xa7a7
#define	chrGBCyrillicCapital_ZHE							0xa7a8
#define	chrGBCyrillicCapital_ZE								0xa7a9
#define	chrGBCyrillicCapital_I								0xa7aa
#define	chrGBCyrillicCapitalShort_I							0xa7ab
#define	chrGBCyrillicCapital_KA								0xa7ac
#define	chrGBCyrillicCapital_EL								0xa7ad
#define	chrGBCyrillicCapital_EM								0xa7ae
#define	chrGBCyrillicCapital_EN								0xa7af
#define	chrGBCyrillicCapital_O								0xa7b0
#define	chrGBCyrillicCapital_PE								0xa7b1
#define	chrGBCyrillicCapital_ER								0xa7b2
#define	chrGBCyrillicCapital_ES								0xa7b3
#define	chrGBCyrillicCapital_TE								0xa7b4
#define	chrGBCyrillicCapital_U								0xa7b5
#define	chrGBCyrillicCapital_EF								0xa7b6
#define	chrGBCyrillicCapital_HA								0xa7b7
#define	chrGBCyrillicCapital_TSE							0xa7b8
#define	chrGBCyrillicCapital_CHE							0xa7b9
#define	chrGBCyrillicCapital_SHA							0xa7ba
#define	chrGBCyrillicCapital_SHCHA							0xa7bb
#define	chrGBCyrillicCapitalHardSign						0xa7bc
#define	chrGBCyrillicCapital_YERU							0xa7bd
#define	chrGBCyrillicCapitalSoftSign						0xa7be
#define	chrGBCyrillicCapital_E								0xa7bf
#define	chrGBCyrillicCapital_YU								0xa7c0
#define	chrGBCyrillicCapital_YA								0xa7c1
#define	chrGBCyrillicSmall_A								0xa7d1
#define	chrGBCyrillicSmall_BE								0xa7d2
#define	chrGBCyrillicSmall_VE								0xa7d3
#define	chrGBCyrillicSmall_GHE								0xa7d4
#define	chrGBCyrillicSmall_DE								0xa7d5
#define	chrGBCyrillicSmall_IE								0xa7d6
#define	chrGBCyrillicSmall_IO								0xa7d7
#define	chrGBCyrillicSmall_ZHE								0xa7d8
#define	chrGBCyrillicSmall_ZE								0xa7d9
#define	chrGBCyrillicSmall_I								0xa7da
#define	chrGBCyrillicSmallShort_I							0xa7db
#define	chrGBCyrillicSmall_KA								0xa7dc
#define	chrGBCyrillicSmall_EL								0xa7dd
#define	chrGBCyrillicSmall_EM								0xa7de
#define	chrGBCyrillicSmall_EN								0xa7df
#define	chrGBCyrillicSmall_O								0xa7e0
#define	chrGBCyrillicSmall_PE								0xa7e1
#define	chrGBCyrillicSmall_ER								0xa7e2
#define	chrGBCyrillicSmall_ES								0xa7e3
#define	chrGBCyrillicSmall_TE								0xa7e4
#define	chrGBCyrillicSmall_U								0xa7e5
#define	chrGBCyrillicSmall_EF								0xa7e6
#define	chrGBCyrillicSmall_HA								0xa7e7
#define	chrGBCyrillicSmall_TSE								0xa7e8
#define	chrGBCyrillicSmall_CHE								0xa7e9
#define	chrGBCyrillicSmall_SHA								0xa7ea
#define	chrGBCyrillicSmall_SHCHA							0xa7eb
#define	chrGBCyrillicSmallHardSign							0xa7ec
#define	chrGBCyrillicSmall_YERU								0xa7ed
#define	chrGBCyrillicSmallSoftSign							0xa7ee
#define	chrGBCyrillicSmall_E								0xa7ef
#define	chrGBCyrillicSmall_YU								0xa7f0
#define	chrGBCyrillicSmall_YA								0xa7f1
#define	chrGBModifierAcute									0xa840
#define	chrGBModifierGrave									0xa841
#define	chrGBDotAbove										0xa842
#define	chrGBEnDash											0xa843
#define	chrGBHorizontalBar									0xa844
#define	chrGBTwoDotLeader									0xa845
#define	chrGBReversedPrime									0xa846
#define	chrGBCareOf											0xa847
#define	chrGBDegreeFahrenheit								0xa848
#define	chrGBNorthWestArrow									0xa849
#define	chrGBNorthEastArrow									0xa84a
#define	chrGBSouthEastArrow									0xa84b
#define	chrGBSouthWestArrow									0xa84c
#define	chrGBDivisionSlash									0xa84d
#define	chrGBRightAngle										0xa84e
#define	chrGBDivides										0xa84f
#define	chrGBApproximatelyEqualToOrTheImageOf				0xa850
#define	chrGBLessThanOverEqualTo							0xa851
#define	chrGBGreaterThanOverEqualTo							0xa852
#define	chrGBRightTriangle									0xa853
#define	chrGBBoxDrawingsDoubleHorizontal					0xa854
#define	chrGBBoxDrawingsDoubleVertical						0xa855
#define	chrGBBoxDrawingsDownSingleAndRightDouble			0xa856
#define	chrGBBoxDrawingsDownDoubleAndRightSingle			0xa857
#define	chrGBBoxDrawingsDoubleDownAndRight					0xa858
#define	chrGBBoxDrawingsDownSingleAndLeftDouble				0xa859
#define	chrGBBoxDrawingsDownDoubleAndLeftSingle				0xa85a
#define	chrGBBoxDrawingsDoubleDownAndLeft					0xa85b
#define	chrGBBoxDrawingsUpSingleAndRightDouble				0xa85c
#define	chrGBBoxDrawingsUpDoubleAndRightSingle				0xa85d
#define	chrGBBoxDrawingsDoubleUpAndRight					0xa85e
#define	chrGBBoxDrawingsUpSingleAndLeftDouble				0xa85f
#define	chrGBBoxDrawingsUpDoubleAndLeftSingle				0xa860
#define	chrGBBoxDrawingsDoubleUpAndLeft						0xa861
#define	chrGBBoxDrawingsVerticalSingleAndRightDouble		0xa862
#define	chrGBBoxDrawingsVerticalDoubleAndRightSingle		0xa863
#define	chrGBBoxDrawingsDoubleVerticalAndRight				0xa864
#define	chrGBBoxDrawingsVerticalSingleAndLeftDouble			0xa865
#define	chrGBBoxDrawingsVerticalDoubleAndLeftSingle			0xa866
#define	chrGBBoxDrawingsDoubleVerticalAndLeft				0xa867
#define	chrGBBoxDrawingsDownSingleAndHorizontalDouble		0xa868
#define	chrGBBoxDrawingsDownDoubleAndHorizontalSingle		0xa869
#define	chrGBBoxDrawingsDoubleDownAndHorizontal				0xa86a
#define	chrGBBoxDrawingsUpSingleAndHorizontalDouble			0xa86b
#define	chrGBBoxDrawingsUpDoubleAndHorizontalSingle			0xa86c
#define	chrGBBoxDrawingsDoubleUpAndHorizontal				0xa86d
#define	chrGBBoxDrawingsVerticalSingleAndHorizontalDouble	0xa86e
#define	chrGBBoxDrawingsVerticalDoubleAndHorizontalSingle	0xa86f
#define	chrGBBoxDrawingsDoubleVerticalAndHorizontal			0xa870
#define	chrGBBoxDrawingsLightArcDownAndRight				0xa871
#define	chrGBBoxDrawingsLightArcDownAndLeft					0xa872
#define	chrGBBoxDrawingsLightArcUpAndLeft					0xa873
#define	chrGBBoxDrawingsLightArcUpAndRight					0xa874
#define	chrGBBoxDrawingsLightDiagonalUpperRightToLowerLeft	0xa875
#define	chrGBBoxDrawingsLightDiagonalUpperLeftToLowerRight	0xa876
#define	chrGBBoxDrawingsLightDiagonalCross					0xa877
#define	chrGBLowerOneEighthBlock							0xa878
#define	chrGBLowerOneQuarterBlock							0xa879
#define	chrGBLowerThreeEighthsBlock							0xa87a
#define	chrGBLowerHalfBlock									0xa87b
#define	chrGBLowerFiveEighthsBlock							0xa87c
#define	chrGBLowerThreeQuartersBlock						0xa87d
#define	chrGBLowerSevenEighthsBlock							0xa87e
#define	chrGBFullBlock										0xa880
#define	chrGBLeftSevenEighthsBlock							0xa881
#define	chrGBLeftThreeQuartersBlock							0xa882
#define	chrGBLeftFiveEighthsBlock							0xa883
#define	chrGBLeftHalfBlock									0xa884
#define	chrGBLeftThreeEighthsBlock							0xa885
#define	chrGBLeftOneQuarterBlock							0xa886
#define	chrGBLeftOneEighthBlock								0xa887
#define	chrGBDarkShade										0xa888
#define	chrGBUpperOneEighthBlock							0xa889
#define	chrGBRightOneEighthBlock							0xa88a
#define	chrGBBlackDownPointingTriangle						0xa88b
#define	chrGBWhiteDownPointingTriangle						0xa88c
#define	chrGBBlackLowerRightTriangle						0xa88d
#define	chrGBBlackLowerLeftTriangle							0xa88e
#define	chrGBBlackUpperLeftTriangle							0xa88f
#define	chrGBBlackUpperRightTriangle						0xa890
#define	chrGBSun											0xa891
#define	chrGBCircledPlus									0xa892
#define	chrGBPostalMark										0xa893
#define	chrGBReversedDoublePrimeQuotationMark				0xa894
#define	chrGBDoublePrimeQuotationMark						0xa895
#define	chrGBSmall_A_Macron									0xa8a1
#define	chrGBSmall_A_Acute									0xa8a2
#define	chrGBSmall_A_Caron									0xa8a3
#define	chrGBSmall_A_Grave									0xa8a4
#define	chrGBSmall_E_Macron									0xa8a5
#define	chrGBSmall_E_Acute									0xa8a6
#define	chrGBSmall_E_Caron									0xa8a7
#define	chrGBSmall_E_Grave									0xa8a8
#define	chrGBSmall_I_Macron									0xa8a9
#define	chrGBSmall_I_Acute									0xa8aa
#define	chrGBSmall_I_Caron									0xa8ab
#define	chrGBSmall_I_Grave									0xa8ac
#define	chrGBSmall_O_Macron									0xa8ad
#define	chrGBSmall_O_Acute									0xa8ae
#define	chrGBSmall_O_Caron									0xa8af
#define	chrGBSmall_O_Grave									0xa8b0
#define	chrGBSmall_U_Macron									0xa8b1
#define	chrGBSmall_U_Acute									0xa8b2
#define	chrGBSmall_U_Caron									0xa8b3
#define	chrGBSmall_U_Grave									0xa8b4
#define	chrGBSmall_U_DiaeresisAndMacron						0xa8b5
#define	chrGBSmall_U_DiaeresisAndAcute						0xa8b6
#define	chrGBSmall_U_DiaeresisAndCaron						0xa8b7
#define	chrGBSmall_U_DiaeresisAndGrave						0xa8b8
#define	chrGBSmall_U_Diaeresis								0xa8b9
#define	chrGBSmall_E_Circumflex								0xa8ba
#define	chrGBSmall_ALPHA									0xa8bb
#define	chrGBSmall_N_Acute									0xa8bd
#define	chrGBSmall_N_Caron									0xa8be
#define	chrGBSmallScript_G									0xa8c0
#define	chrGBBopomofo_B										0xa8c5
#define	chrGBBopomofo_P										0xa8c6
#define	chrGBBopomofo_M										0xa8c7
#define	chrGBBopomofo_F										0xa8c8
#define	chrGBBopomofo_D										0xa8c9
#define	chrGBBopomofo_T										0xa8ca
#define	chrGBBopomofo_N										0xa8cb
#define	chrGBBopomofo_L										0xa8cc
#define	chrGBBopomofo_G										0xa8cd
#define	chrGBBopomofo_K										0xa8ce
#define	chrGBBopomofo_H										0xa8cf
#define	chrGBBopomofo_J										0xa8d0
#define	chrGBBopomofo_Q										0xa8d1
#define	chrGBBopomofo_X										0xa8d2
#define	chrGBBopomofo_ZH									0xa8d3
#define	chrGBBopomofo_CH									0xa8d4
#define	chrGBBopomofo_SH									0xa8d5
#define	chrGBBopomofo_R										0xa8d6
#define	chrGBBopomofo_Z										0xa8d7
#define	chrGBBopomofo_C										0xa8d8
#define	chrGBBopomofo_S										0xa8d9
#define	chrGBBopomofo_A										0xa8da
#define	chrGBBopomofo_O										0xa8db
#define	chrGBBopomofo_E										0xa8dc
#define	chrGBBopomofo_EH									0xa8dd
#define	chrGBBopomofo_AI									0xa8de
#define	chrGBBopomofo_EI									0xa8df
#define	chrGBBopomofo_AU									0xa8e0
#define	chrGBBopomofo_OU									0xa8e1
#define	chrGBBopomofo_AN									0xa8e2
#define	chrGBBopomofo_EN									0xa8e3
#define	chrGBBopomofo_ANG									0xa8e4
#define	chrGBBopomofo_ENG									0xa8e5
#define	chrGBBopomofo_ER									0xa8e6
#define	chrGBBopomofo_I										0xa8e7
#define	chrGBBopomofo_U										0xa8e8
#define	chrGBBopomofo_IU									0xa8e9
#define	chrGBHangzhouNumeralOne								0xa940
#define	chrGBHangzhouNumeralTwo								0xa941
#define	chrGBHangzhouNumeralThree							0xa942
#define	chrGBHangzhouNumeralFour							0xa943
#define	chrGBHangzhouNumeralFive							0xa944
#define	chrGBHangzhouNumeralSix								0xa945
#define	chrGBHangzhouNumeralSeven							0xa946
#define	chrGBHangzhouNumeralEight							0xa947
#define	chrGBHangzhouNumeralNine							0xa948
#define	chrGBCircledIdeographCorrect						0xa949
#define	chrGBSquareMg										0xa94a
#define	chrGBSquareKg										0xa94b
#define	chrGBSquareMm										0xa94c
#define	chrGBSquareCm										0xa94d
#define	chrGBSquareKm										0xa94e
#define	chrGBSquareMSquared									0xa94f
#define	chrGBSquareCc										0xa950
#define	chrGBSquareKmCapital								0xa951
#define	chrGBSquareLn										0xa952
#define	chrGBSquareLog										0xa953
#define	chrGBSquareMil										0xa954
#define	chrGBVerticalFormTwo								0xa955
#define	chrGBFullwidthNotSign								0xa956
#define	chrGBFullwidthBrokenBar								0xa957
#define	chrGBTelephoneSign									0xa959
#define	chrGBParenthesizedIdeographStock					0xa95a
#define	chrGBHyphen											0xa95c
#define	chrGBKatakanaHiraganaProlongedSoundMark				0xa960
#define	chrGBKatakanaHiraganaVoicedSoundMark				0xa961
#define	chrGBKatakanaHiraganaSemiVoicedSoundMark			0xa962
#define	chrGBKatakanaIterationMark							0xa963
#define	chrGBKatakanaVoicedIterationMark					0xa964
#define	chrGBIdeographicClosingMark							0xa965
#define	chrGBHiraganaIterationMark							0xa966
#define	chrGBHiraganaVoicedIterationMark					0xa967
#define	chrGBDashedOverline									0xa968
#define	chrGBCentrelineOverline								0xa969
#define	chrGBWavyOverline									0xa96a
#define	chrGBDoubleWavyOverline								0xa96b
#define	chrGBDashedLowLine									0xa96c
#define	chrGBCentrelineLowLine								0xa96d
#define	chrGBWavyLowLine									0xa96e
#define	chrGBSmallComma										0xa96f
#define	chrGBSmallIdeographicComma							0xa970
#define	chrGBSmallFullStop									0xa971
#define	chrGBSmallSemicolon									0xa972
#define	chrGBSmallColon										0xa973
#define	chrGBSmallQuestionMark								0xa974
#define	chrGBSmallExclamationMark							0xa975
#define	chrGBSmallLeftParenthesis							0xa976
#define	chrGBSmallRightParenthesis							0xa977
#define	chrGBSmallLeftCurlyBracket							0xa978
#define	chrGBSmallRightCurlyBracket							0xa979
#define	chrGBSmallLeftTortoiseShellBracket					0xa97a
#define	chrGBSmallRightTortoiseShellBracket					0xa97b
#define	chrGBSmallNumberSign								0xa97c
#define	chrGBSmallAmpersand									0xa97d
#define	chrGBSmallAsterisk									0xa97e
#define	chrGBSmallPlusSign									0xa980
#define	chrGBSmallHyphenMinus								0xa981
#define	chrGBSmallLessThanSign								0xa982
#define	chrGBSmallGreaterThanSign							0xa983
#define	chrGBSmallEqualsSign								0xa984
#define	chrGBSmallReverseSolidus							0xa985
#define	chrGBSmallDollarSign								0xa986
#define	chrGBSmallPercentSign								0xa987
#define	chrGBSmallCommercialAt								0xa988
#define	chrGBIdeographicNumberZero							0xa996
#define	chrGBBoxDrawingsLightHorizontal						0xa9a4
#define	chrGBBoxDrawingsHeavyHorizontal						0xa9a5
#define	chrGBBoxDrawingsLightVertical						0xa9a6
#define	chrGBBoxDrawingsHeavyVertical						0xa9a7
#define	chrGBBoxDrawingsLightTripleDashHorizontal			0xa9a8
#define	chrGBBoxDrawingsHeavyTripleDashHorizontal			0xa9a9
#define	chrGBBoxDrawingsLightTripleDashVertical				0xa9aa
#define	chrGBBoxDrawingsHeavyTripleDashVertical				0xa9ab
#define	chrGBBoxDrawingsLightQuadrupleDashHorizontal		0xa9ac
#define	chrGBBoxDrawingsHeavyQuadrupleDashHorizontal		0xa9ad
#define	chrGBBoxDrawingsLightQuadrupleDashVertical			0xa9ae
#define	chrGBBoxDrawingsHeavyQuadrupleDashVertical			0xa9af
#define	chrGBBoxDrawingsLightDownAndRight					0xa9b0
#define	chrGBBoxDrawingsDownLightAndRightHeavy				0xa9b1
#define	chrGBBoxDrawingsDownHeavyAndRightLight				0xa9b2
#define	chrGBBoxDrawingsHeavyDownAndRight					0xa9b3
#define	chrGBBoxDrawingsLightDownAndLeft					0xa9b4
#define	chrGBBoxDrawingsDownLightAndLeftHeavy				0xa9b5
#define	chrGBBoxDrawingsDownHeavyAndLeftLight				0xa9b6
#define	chrGBBoxDrawingsHeavyDownAndLeft					0xa9b7
#define	chrGBBoxDrawingsLightUpAndRight						0xa9b8
#define	chrGBBoxDrawingsUpLightAndRightHeavy				0xa9b9
#define	chrGBBoxDrawingsUpHeavyAndRightLight				0xa9ba
#define	chrGBBoxDrawingsHeavyUpAndRight						0xa9bb
#define	chrGBBoxDrawingsLightUpAndLeft						0xa9bc
#define	chrGBBoxDrawingsUpLightAndLeftHeavy					0xa9bd
#define	chrGBBoxDrawingsUpHeavyAndLeftLight					0xa9be
#define	chrGBBoxDrawingsHeavyUpAndLeft						0xa9bf
#define	chrGBBoxDrawingsLightVerticalAndRight				0xa9c0
#define	chrGBBoxDrawingsVerticalLightAndRightHeavy			0xa9c1
#define	chrGBBoxDrawingsUpHeavyAndRightDownLight			0xa9c2
#define	chrGBBoxDrawingsDownHeavyAndRightUpLight			0xa9c3
#define	chrGBBoxDrawingsVerticalHeavyAndRightLight			0xa9c4
#define	chrGBBoxDrawingsDownLightAndRightUpHeavy			0xa9c5
#define	chrGBBoxDrawingsUpLightAndRightDownHeavy			0xa9c6
#define	chrGBBoxDrawingsHeavyVerticalAndRight				0xa9c7
#define	chrGBBoxDrawingsLightVerticalAndLeft				0xa9c8
#define	chrGBBoxDrawingsVerticalLightAndLeftHeavy			0xa9c9
#define	chrGBBoxDrawingsUpHeavyAndLeftDownLight				0xa9ca
#define	chrGBBoxDrawingsDownHeavyAndLeftUpLight				0xa9cb
#define	chrGBBoxDrawingsVerticalHeavyAndLeftLight			0xa9cc
#define	chrGBBoxDrawingsDownLightAndLeftUpHeavy				0xa9cd
#define	chrGBBoxDrawingsUpLightAndLeftDownHeavy				0xa9ce
#define	chrGBBoxDrawingsHeavyVerticalAndLeft				0xa9cf
#define	chrGBBoxDrawingsLightDownAndHorizontal				0xa9d0
#define	chrGBBoxDrawingsLeftHeavyAndRightDownLight			0xa9d1
#define	chrGBBoxDrawingsRightHeavyAndLeftDownLight			0xa9d2
#define	chrGBBoxDrawingsDownLightAndHorizontalHeavy			0xa9d3
#define	chrGBBoxDrawingsDownHeavyAndHorizontalLight			0xa9d4
#define	chrGBBoxDrawingsRightLightAndLeftDownHeavy			0xa9d5
#define	chrGBBoxDrawingsLeftLightAndRightDownHeavy			0xa9d6
#define	chrGBBoxDrawingsHeavyDownAndHorizontal				0xa9d7
#define	chrGBBoxDrawingsLightUpAndHorizontal				0xa9d8
#define	chrGBBoxDrawingsLeftHeavyAndRightUpLight			0xa9d9
#define	chrGBBoxDrawingsRightHeavyAndLeftUpLight			0xa9da
#define	chrGBBoxDrawingsUpLightAndHorizontalHeavy			0xa9db
#define	chrGBBoxDrawingsUpHeavyAndHorizontalLight			0xa9dc
#define	chrGBBoxDrawingsRightLightAndLeftUpHeavy			0xa9dd
#define	chrGBBoxDrawingsLeftLightAndRightUpHeavy			0xa9de
#define	chrGBBoxDrawingsHeavyUpAndHorizontal				0xa9df
#define	chrGBBoxDrawingsLightVerticalAndHorizontal			0xa9e0
#define	chrGBBoxDrawingsLeftHeavyAndRightVerticalLight		0xa9e1
#define	chrGBBoxDrawingsRightHeavyAndLeftVerticalLight		0xa9e2
#define	chrGBBoxDrawingsVerticalLightAndHorizontalHeavy		0xa9e3
#define	chrGBBoxDrawingsUpHeavyAndDownHorizontalLight		0xa9e4
#define	chrGBBoxDrawingsDownHeavyAndUpHorizontalLight		0xa9e5
#define	chrGBBoxDrawingsVerticalHeavyAndHorizontalLight		0xa9e6
#define	chrGBBoxDrawingsLeftUpHeavyAndRightDownLight		0xa9e7
#define	chrGBBoxDrawingsRightUpHeavyAndLeftDownLight		0xa9e8
#define	chrGBBoxDrawingsLeftDownHeavyAndRightUpLight		0xa9e9
#define	chrGBBoxDrawingsRightDownHeavyAndLeftUpLight		0xa9ea
#define	chrGBBoxDrawingsDownLightAndUpHorizontalHeavy		0xa9eb
#define	chrGBBoxDrawingsUpLightAndDownHorizontalHeavy		0xa9ec
#define	chrGBBoxDrawingsRightLightAndLeftVerticalHeavy		0xa9ed
#define	chrGBBoxDrawingsLeftLightAndRightVerticalHeavy		0xa9ee
#define	chrGBBoxDrawingsHeavyVerticalAndHorizontal			0xa9ef

#define chrGBLastDoubleByte									0xfefe


#endif // __CHARGB_H__
