/******************************************************************************
 *
 * Copyright (c) 1996-2003 PalmSource, Inc. All rights reserved.
 *
 * File: sys_errno.h
 *
 * Release: Palm OS 5 SDK (68K) R3.
 *
 * Description:
 *	  This module contains the equivalent of the unix header <sys/errno.h>
 *	for use in Pilot applications that wish to use the Berkeley sockets API
 *
 *****************************************************************************/

/*      @(#)errno.h 2.14 90/01/23 SMI; from UCB 4.1 82/12/28    */

/*
 * If error codes are added or changed here, they should be updated in
 * /usr/src/lib/libc/gen/common/errlst.c as well.
 */


#ifndef _sys_errno_h
#define _sys_errno_h

#define EPERM           1               /* Not owner */
#define ENOENT          2               /* No such file or directory */
#define ESRCH           3               /* No such process */
#define EINTR           netErrTimeout	 /* Interrupted system call */
#define EIO             5               /* I/O error */
#define ENXIO           6               /* No such device or address */
#define E2BIG           7               /* Arg list too long */
#define ENOEXEC         8               /* Exec format error */
#define EBADF           9               /* Bad file number */
#define ECHILD          10              /* No children */
#define EAGAIN          11              /* No more processes */
#define ENOMEM          12              /* Not enough core */
#define EACCES          13              /* Permission denied */
#define EFAULT          14              /* Bad address */
#define ENOTBLK         15              /* Block device required */
#define EBUSY           16              /* Mount device busy */
#define EEXIST          17              /* File exists */
#define EXDEV           18              /* Cross-device link */
#define ENODEV          19              /* No such device */
#define ENOTDIR         20              /* Not a directory*/
#define EISDIR          21              /* Is a directory */
#define EINVAL          22              /* Invalid argument */
#define ENFILE          23              /* File table overflow */
#define EMFILE          24              /* Too many open files */
#define ENOTTY          25              /* Not a typewriter */
#define ETXTBSY         26              /* Text file busy */
#define EFBIG           27              /* File too large */
#define ENOSPC          28              /* No space left on device */
#define ESPIPE          29              /* Illegal seek */
#define EROFS           30              /* Read-only file system */
#define EMLINK          31              /* Too many links */
#define EPIPE           32              /* Broken pipe */

/* math software */
#define EDOM            33              /* Argument too large */
#define ERANGE          34              /* Result too large */

/* non-blocking and interrupt i/o */
#define EWOULDBLOCK     netErrWouldBlock  	 	/* Operation would block */
#define EINPROGRESS     netErrSocketBusy   		/* Operation now in progress */
#define EALREADY        netErrAlreadyInProgress   	/* Operation already in progress */
/* ipc/network software */

        /* argument errors */
#define ENOTSOCK        38              /* Socket operation on non-socket */
#define EDESTADDRREQ    39              /* Destination address required */
#define EMSGSIZE        40              /* Message too long */
#define EPROTOTYPE      41              /* Protocol wrong type for socket */
#define ENOPROTOOPT     42              /* Protocol not available */
#define EPROTONOSUPPORT 43              /* Protocol not supported */
#define ESOCKTNOSUPPORT 44              /* Socket type not supported */
#define EOPNOTSUPP      45              /* Operation not supported on socket */
#define EPFNOSUPPORT    46              /* Protocol family not supported */
#define EAFNOSUPPORT    47              /* Address family not supported by proto
col family */
#define EADDRINUSE      netErrPortInUse /* Address already in use */
#define EADDRNOTAVAIL   49              /* Can't assign requested address */

        /* operational errors */
#define ENETDOWN        50              /* Network is down */
#define ENETUNREACH     netErrNoInterfaces              /* Network is unreachable */
#define ENETRESET       52              /* Network dropped connection on reset */
#define ECONNABORTED    53              /* Software caused connection abort */
#define ECONNRESET      54              /* Connection reset by peer */
#define ENOBUFS         55              /* No buffer space available */
#define EISCONN         netErrSocketAlreadyConnected  /* Socket is already connected */
#define ENOTCONN        57              /* Socket is not connected */
#define ESHUTDOWN       58              /* Can't send after socket shutdown */
#define ETOOMANYREFS    59              /* Too many references: can't splice */
#define ETIMEDOUT       netErrTimeout   /* Connection timed out */
#define ECONNREFUSED    61              /* Connection refused */

        /* */
#define ELOOP           62              /* Too many levels of symbolic links */
#define ENAMETOOLONG    63              /* File name too long */

/* should be rearranged */
#define EHOSTDOWN       64              /* Host is down */
#define EHOSTUNREACH    65              /* No route to host */
#define ENOTEMPTY       66              /* Directory not empty */

/* quotas & mush */
#define EPROCLIM        67              /* Too many processes */
#define EUSERS          68              /* Too many users */
#define EDQUOT          69              /* Disc quota exceeded */

/* Network File System */
#define ESTALE          70              /* Stale NFS file handle */
#define EREMOTE         71              /* Too many levels of remote in path */

/* streams */
#define ENOSTR          72              /* Device is not a stream */
#define ETIME           73              /* Timer expired */
#define ENOSR           74              /* Out of streams resources */
#define ENOMSG          75              /* No message of desired type */
#define EBADMSG         76              /* Trying to read unreadable message */

/* SystemV IPC */
#define EIDRM           77              /* Identifier removed */

/* SystemV Record Locking */
#define EDEADLK         78              /* Deadlock condition. */
#define ENOLCK          79              /* No record locks available. */

/* RFS */
#define ENONET          80              /* Machine is not on the network */
#define ERREMOTE        81              /* Object is remote */
#define ENOLINK         82              /* the link has been severed */
#define EADV            83              /* advertise error */
#define ESRMNT          84              /* srmount error */
#define ECOMM           85              /* Communication error on send */
#define EPROTO          86              /* Protocol error */
#define EMULTIHOP       87              /* multihop attempted */
#define EDOTDOT         88              /* Cross mount point (not an error) */
#define EREMCHG         89              /* Remote address changed */

/* POSIX */
#define ENOSYS          90              /* function not implemented */

#endif /*!_sys_errno_h*/
