/******************************************************************************
 *
 * Copyright (c) 1995-2002 PalmSource, Inc. All rights reserved.
 *
 * File: SampleDB.h
 *
 * Release: Palm OS 5 SDK (68K) R3.
 *
 * Description:
 *		Header for the Sample datebase access layer
 *
 *****************************************************************************/

#ifndef __SAMPLEDB_H__
#define __SAMPLEDB_H__

#define LocalizedAppInfoStr			1000

typedef struct {
   UInt16	renamedCategories;		// bitfield of categories with a different name
	char	categoryLabels[dmRecNumCategories][dmCategoryLength];
	UInt8	categoryUniqIDs[dmRecNumCategories];
	UInt8	lastUniqID;			// Uniq IDs generated by the device are between
									// 0 - 127.  Those from the PC are 128 - 255.
	UInt8	reserved1;			// from the compiler word aligning things
	UInt16	reserved2;
	UInt16	reserved3;
	UInt8	sortOrder;
	UInt8	reserved;
} SampleAppInfoType;

typedef SampleAppInfoType * SampleAppInfoPtr;


// Sort orders
#define soUnsorted		0
#define soAlphabetic		1


typedef struct {
	char 	note;		// null terminated
	UInt8	reserved;
} ItemDBRecordType;

typedef ItemDBRecordType * ItemDBRecordPtr;

typedef struct {
	Char *				note;
} SampleItemType;

typedef SampleItemType * SampleItemPtr;


#ifdef __cplusplus
extern "C" {
#endif


//-------------------------------------------------------------------
// Routines
//-------------------------------------------------------------------
extern Err		SampleAppInfoInit(DmOpenRef dbP);

extern Err		SampleNewRecord(DmOpenRef dbP, SampleItemPtr item, UInt16 *index);

extern Err		SampleChangeSortOrder(DmOpenRef dbP, UInt8 sortOrder);

extern UInt8	SampleGetSortOrder (DmOpenRef dbP);

extern void		SampleSort (DmOpenRef dbP);

extern Err		SampleSortRecord (DmOpenRef dbP, UInt16 * indexP);

extern Err		SampleGetDatabase (DmOpenRef *dbPP, UInt16 mode);

#ifdef __cplusplus
}
#endif


#endif
