/******************************************************************************
 * Copyright (c) 2005 palmOne, Inc. or its subsidiaries.
 * All rights reserved.
 *****************************************************************************/
/**
 *@ingroup System
 *
 */

/**
 * @file 	palmOneChars.h
 * @version 1.0
 * @date 	03/03/2004
 *
 * @brief Contains palmOne-specific virtual characters.
 *
 * 	  Five-way navigation macros and values for key states are included
 * 	  in this file.
 *
 * <hr>
 */


#ifndef __PALMONECHARS_H__
#define __PALMONECHARS_H__

#include <Chars.h>



#if (vchrPalmMin != 0x0500) || (vchrPalmMax != 0x05FF)
#error "please check Palm vchr range or update the above assertion"
#endif

#ifndef vchrHard5
#define vchrHard5				0x0214		/**< To match PalmOS 5.1 definition in Chars.h.	*/
#endif

#ifndef vchrHard6
#define	vchrHard6					0x0215
#endif

#ifndef keyBitHard5
#define keyBitHard5				0x2000		/**< The keyBit mask used for polling the 5th hard key.	*/
#endif

/**
 * @name
 *
 */
/*@{*/
#define vchrSilkClock           	(vchrPalmMin + 0)	/**< Silk screen clock button virtual character.
 								  *< When handled by the system, it will launch the clock pop-up dialog.
                                                                  */

#define vchrClock               	(vchrPalmMin + 1)	/**< Clock virtual character.
 								  *< When handled by the system, it will launch the clock pop-up dialog.
                                                                  */

#define vchrPopupBrightness     	(vchrPalmMin + 2)	/**< Pop-up brightness virtual character.
 								  *< When handled by the system, it will launch the brightness pop-up dialog.
                                                                  */

#define vchrNavChange           	(vchrPalmMin + 3)	/**< Five way navigation virtual character.
 								  *< This character indicates that the five way navigation states have changed.
                                                                  */

#define vchrCameraShutter		(vchrPalmMin + 8)	/**< Camera shutter virtual character.
					 			  *< Generated by the camera shutter button. Currently only available on Zire71.
                                                                  */

#define vchrHardRecord				(vchrHard5)	/**< Record button virtual character.
 								  *< On Tungsten T, this button is located below the microphone. On Tungsten W
 								  *< and Tungsten C, the button is generally placed on the headset.
                                                                  */
/*@}*/

/**
 * @name The following group of characters are specific for Tungsten W
 *
 */
/*@{*/
#define	vchrDeviceSpecificChar		(vchrPalmMin+20)			/**< 		*/

#define	vchrHard3Down			(vchrDeviceSpecificChar + 0)		/**< Tungsten W virtual character.
 										  *< This character indicates that 3rd Hard key is down.  Used to check for press and hold event.
                                                                                  */

#define	vchrHard4Down			(vchrDeviceSpecificChar + 1)		/**< Tungsten W virtual character.
 										  *< This character indicates that 4th Hard key is down.  Used to check for press and hold event.
                                                                                  */

#define vchrDeviceIncomingCall		(vchrDeviceSpecificChar + 2)		/**< Tungsten W virtual character.
 										  *< This character indicates that there is an incoming call.
                                                                                  */

#define vchrTelDevicePowerOn		(vchrDeviceSpecificChar + 3)		/**< Tungsten W virtual character.
 										  *< This character indicates that the phone has been powered on
                                                                                  */

#define vchrMyFavoriteApplication       (vchrDeviceSpecificChar + 4)	        /**< Tungsten W virtual character.
 										  *< This character indicates that the Favorite Application button has been pressed.
 										  *< The button is UP at this point.
                                                                                  */

#define vchrTelDevicePowerFinished	(vchrDeviceSpecificChar + 5)		/**< Tungsten W virtual character.
 										  *< This character indicates that the backlight has been toggled.
                                                                                  */

#define vchrBacklightToggled        	(vchrDeviceSpecificChar + 6)		/**< Tungsten W virtual character.
 										  *< This character indicates that the backlight has been toggled.
                                                                                  */

#define vchrKeyboardSymbol		(vchrDeviceSpecificChar + 9)		/**< Tungsten W virtual character.
 										  *< This character indicates that the space key has been pressed with the function key.
                                                                                  */

#define vchrReplaceLastChar		(vchrDeviceSpecificChar + 10)		/**< Tungsten W virtual character.
 										  *< This character indicates that a replace last char event has been triggered.
 										  *< This occurs when an alpha numeric key is pressed and held.
                                                                                  */

#define vchrFunctionFiveWay		(vchrDeviceSpecificChar + 11)		/**< Tungsten W virtual character.
 										  *< This character indicates that a 5-way event has been triggered.
                                                                                  */

#define vchrEmergencyCall		(vchrDeviceSpecificChar + 12)		/**< Tungsten W virtual character.
 										  *< This character indicates that an emergency call is being placed.
	 									  *< This occurs when the 4 hard keys are all pressed at once.
                                                                                  */

#define vchrPowerOnPhone		(vchrDeviceSpecificChar + 14)		/**< Tungsten W virtual character.
										  *< This character indicates that a request to toggle the phone on or off has been made.
                                                                                  */
/*@}*/

/**
 * From Handspring ARM SDK, System/HsKey.h
 * Most of these will be moved into the PalmSource SDK as of R3 and later,
 * but we still need to compile on earlier SDKs, so here are guarded definitions.
 *
 * The following vchrThumbWheel/Rocker values exist to allow all hardware
 * that has these (optional) control clusters to emit the same key codes.
 **/

#ifndef vchrThumbWheelUp
/**
 * @name Character codes for thumb-wheel keys
 *
 */
/*@{*/
#define vchrThumbWheelUp			0x012E		/**< optional thumb-wheel up */
#define vchrThumbWheelDown			0x012F		/**< optional thumb-wheel down */
#define vchrThumbWheelPush			0x0130		/**< optional thumb-wheel press/center */
#define vchrThumbWheelBack			0x0131		/**< optional thumb-wheel cluster back */
/*@}*/
#endif // ndef vchrThumbWheelUp


#ifndef vchrRockerUp
/**
 * @name Character codes for rocker keys
 *
 */
/*@{*/
#define vchrRockerUp				0x0132		/**< 5-way rocker up */
#define vchrRockerDown				0x0133		/**< 5-way rocker down */
#define vchrRockerLeft				0x0134		/**< 5-way rocker left */
#define vchrRockerRight				0x0135		/**< 5-way rocker right */
#define vchrRockerCenter			0x0136		/**< 5-way rocker center/press */
/*@}*/
#endif // ndef vchrRockerUp

// End from Handspring ARM SDK, System/HsKey.h

#define vchrRockerSelect            vchrRockerCenter

#endif // __PALMONECHARS_H__
