/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalfoundation.init;

import cofh.core.fluid.BlockFluidCore;
import cofh.core.fluid.FluidCore;
import cofh.core.render.IModelRegister;
import cofh.core.util.core.IInitializer;
import cofh.thermalfoundation.ThermalFoundation;
import cofh.thermalfoundation.fluid.BlockFluidAerotheum;
import cofh.thermalfoundation.fluid.BlockFluidCrudeOil;
import cofh.thermalfoundation.fluid.BlockFluidCryotheum;
import cofh.thermalfoundation.fluid.BlockFluidEnder;
import cofh.thermalfoundation.fluid.BlockFluidGlowstone;
import cofh.thermalfoundation.fluid.BlockFluidMana;
import cofh.thermalfoundation.fluid.BlockFluidPetrotheum;
import cofh.thermalfoundation.fluid.BlockFluidPyrotheum;
import cofh.thermalfoundation.fluid.BlockFluidRedstone;
import cofh.thermalfoundation.fluid.FluidPotion;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.init.Items;
import net.minecraft.init.PotionTypes;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class TFFluids {
    public static final TFFluids INSTANCE = new TFFluids();
    private static ArrayList<IInitializer> initList = new ArrayList();
    public static Fluid fluidSteam;
    public static Fluid fluidCreosote;
    public static Fluid fluidCoal;
    public static Fluid fluidCrudeOil;
    public static Fluid fluidRefinedOil;
    public static Fluid fluidFuel;
    public static Fluid fluidSap;
    public static Fluid fluidSyrup;
    public static Fluid fluidResin;
    public static Fluid fluidTreeOil;
    public static Fluid fluidSeedOil;
    public static Fluid fluidBiocrude;
    public static Fluid fluidBiofuel;
    public static Fluid fluidMushroomStew;
    public static Fluid fluidExperience;
    public static Fluid fluidPotion;
    public static Fluid fluidPotionSplash;
    public static Fluid fluidPotionLingering;
    public static Fluid fluidRedstone;
    public static Fluid fluidGlowstone;
    public static Fluid fluidEnder;
    public static Fluid fluidPyrotheum;
    public static Fluid fluidCryotheum;
    public static Fluid fluidAerotheum;
    public static Fluid fluidPetrotheum;
    public static Fluid fluidMana;
    public static BlockFluidCore blockFluidCrudeOil;
    public static BlockFluidCore blockFluidRedstone;
    public static BlockFluidCore blockFluidGlowstone;
    public static BlockFluidCore blockFluidEnder;
    public static BlockFluidCore blockFluidPyrotheum;
    public static BlockFluidCore blockFluidCryotheum;
    public static BlockFluidCore blockFluidAerotheum;
    public static BlockFluidCore blockFluidPetrotheum;
    public static BlockFluidCore blockFluidMana;

    private TFFluids() {
    }

    public static void preInit() {
        TFFluids.registerAllFluids();
        TFFluids.registerAllFluidBlocks();
        TFFluids.createBuckets();
        TFFluids.refreshReferences();
        for (IInitializer init : initList) {
            init.preInit();
        }
    }

    public static void registerAllFluids() {
        fluidSteam = new FluidCore("steam", "thermalfoundation").setDensity(-1000).setViscosity(200).setTemperature(750).setGaseous(true);
        fluidCreosote = new FluidCore("creosote", "thermalfoundation").setDensity(1100).setViscosity(2000);
        fluidCoal = new FluidCore("coal", "thermalfoundation").setDensity(900).setViscosity(2000);
        fluidCrudeOil = new FluidCore("crude_oil", "thermalfoundation").setDensity(900).setViscosity(2000);
        fluidRefinedOil = new FluidCore("refined_oil", "thermalfoundation").setDensity(800).setViscosity(1400);
        fluidFuel = new FluidCore("refined_fuel", "thermalfoundation").setDensity(750).setViscosity(800);
        fluidSap = new FluidCore("sap", "thermalfoundation").setDensity(1050).setViscosity(1500);
        fluidSyrup = new FluidCore("syrup", "thermalfoundation").setDensity(1400).setViscosity(2500);
        fluidResin = new FluidCore("resin", "thermalfoundation").setDensity(900).setViscosity(3000);
        fluidTreeOil = new FluidCore("tree_oil", "thermalfoundation").setDensity(900).setViscosity(1200);
        fluidSeedOil = new FluidCore("seed_oil", "thermalfoundation").setDensity(950).setViscosity(1300);
        fluidBiocrude = new FluidCore("biocrude", "thermalfoundation").setDensity(1500).setViscosity(2500);
        fluidBiofuel = new FluidCore("refined_biofuel", "thermalfoundation").setDensity(750).setViscosity(800);
        fluidMushroomStew = new FluidCore("mushroom_stew", "thermalfoundation").setDensity(2000).setViscosity(2000);
        fluidExperience = new FluidCore("experience", "thermalfoundation").setLuminosity(12).setDensity(-200).setViscosity(200).setGaseous(true).setRarity(EnumRarity.UNCOMMON);
        fluidPotion = new FluidPotion("potion", "thermalfoundation", "potion.effect.").setLuminosity(3).setDensity(500).setViscosity(1500).setRarity(EnumRarity.UNCOMMON);
        fluidPotionSplash = new FluidPotion("potion_splash", "thermalfoundation", "splash_potion.effect.").setLuminosity(3).setDensity(500).setViscosity(1500).setRarity(EnumRarity.UNCOMMON);
        fluidPotionLingering = new FluidPotion("potion_lingering", "thermalfoundation", "lingering_potion.effect.").setLuminosity(3).setDensity(500).setViscosity(1500).setRarity(EnumRarity.UNCOMMON);
        fluidRedstone = new FluidCore("redstone", "thermalfoundation").setLuminosity(7).setDensity(1200).setViscosity(1500).setRarity(EnumRarity.UNCOMMON);
        fluidGlowstone = new FluidCore("glowstone", "thermalfoundation").setLuminosity(15).setDensity(-500).setViscosity(100).setGaseous(true).setRarity(EnumRarity.UNCOMMON);
        fluidEnder = new FluidCore("ender", "thermalfoundation").setLuminosity(3).setDensity(4000).setViscosity(2500).setRarity(EnumRarity.UNCOMMON);
        fluidPyrotheum = new FluidCore("pyrotheum", "thermalfoundation").setLuminosity(15).setDensity(2000).setViscosity(1200).setTemperature(4000).setRarity(EnumRarity.RARE);
        fluidCryotheum = new FluidCore("cryotheum", "thermalfoundation").setDensity(4000).setViscosity(4000).setTemperature(50).setRarity(EnumRarity.RARE);
        fluidAerotheum = new FluidCore("aerotheum", "thermalfoundation").setDensity(-800).setViscosity(100).setGaseous(true).setRarity(EnumRarity.RARE);
        fluidPetrotheum = new FluidCore("petrotheum", "thermalfoundation").setDensity(4000).setViscosity(1500).setTemperature(350).setRarity(EnumRarity.RARE);
        fluidMana = new FluidCore("mana", "thermalfoundation").setLuminosity(15).setDensity(600).setViscosity(6000).setTemperature(350).setRarity(EnumRarity.EPIC);
        FluidRegistry.registerFluid((Fluid)fluidSteam);
        FluidRegistry.registerFluid((Fluid)fluidCreosote);
        FluidRegistry.registerFluid((Fluid)fluidCoal);
        FluidRegistry.registerFluid((Fluid)fluidCrudeOil);
        FluidRegistry.registerFluid((Fluid)fluidRefinedOil);
        FluidRegistry.registerFluid((Fluid)fluidFuel);
        FluidRegistry.registerFluid((Fluid)fluidSap);
        FluidRegistry.registerFluid((Fluid)fluidSyrup);
        FluidRegistry.registerFluid((Fluid)fluidResin);
        FluidRegistry.registerFluid((Fluid)fluidTreeOil);
        FluidRegistry.registerFluid((Fluid)fluidSeedOil);
        FluidRegistry.registerFluid((Fluid)fluidBiocrude);
        FluidRegistry.registerFluid((Fluid)fluidBiofuel);
        FluidRegistry.registerFluid((Fluid)fluidMushroomStew);
        FluidRegistry.registerFluid((Fluid)fluidExperience);
        FluidRegistry.registerFluid((Fluid)fluidPotion);
        FluidRegistry.registerFluid((Fluid)fluidPotionSplash);
        FluidRegistry.registerFluid((Fluid)fluidPotionLingering);
        FluidRegistry.registerFluid((Fluid)fluidRedstone);
        FluidRegistry.registerFluid((Fluid)fluidGlowstone);
        FluidRegistry.registerFluid((Fluid)fluidEnder);
        FluidRegistry.registerFluid((Fluid)fluidPyrotheum);
        FluidRegistry.registerFluid((Fluid)fluidCryotheum);
        FluidRegistry.registerFluid((Fluid)fluidAerotheum);
        FluidRegistry.registerFluid((Fluid)fluidPetrotheum);
        FluidRegistry.registerFluid((Fluid)fluidMana);
    }

    public static void registerAllFluidBlocks() {
        blockFluidCrudeOil = new BlockFluidCrudeOil(fluidCrudeOil);
        blockFluidRedstone = new BlockFluidRedstone(fluidRedstone);
        blockFluidGlowstone = new BlockFluidGlowstone(fluidGlowstone);
        blockFluidEnder = new BlockFluidEnder(fluidEnder);
        blockFluidPyrotheum = new BlockFluidPyrotheum(fluidPyrotheum);
        blockFluidCryotheum = new BlockFluidCryotheum(fluidCryotheum);
        blockFluidAerotheum = new BlockFluidAerotheum(fluidAerotheum);
        blockFluidPetrotheum = new BlockFluidPetrotheum(fluidPetrotheum);
        blockFluidMana = new BlockFluidMana(fluidMana);
        initList.add((IInitializer)blockFluidCrudeOil);
        initList.add((IInitializer)blockFluidRedstone);
        initList.add((IInitializer)blockFluidGlowstone);
        initList.add((IInitializer)blockFluidEnder);
        initList.add((IInitializer)blockFluidPyrotheum);
        initList.add((IInitializer)blockFluidCryotheum);
        initList.add((IInitializer)blockFluidAerotheum);
        initList.add((IInitializer)blockFluidPetrotheum);
        initList.add((IInitializer)blockFluidMana);
        ThermalFoundation.proxy.addIModelRegister((IModelRegister)blockFluidCrudeOil);
        ThermalFoundation.proxy.addIModelRegister((IModelRegister)blockFluidRedstone);
        ThermalFoundation.proxy.addIModelRegister((IModelRegister)blockFluidGlowstone);
        ThermalFoundation.proxy.addIModelRegister((IModelRegister)blockFluidEnder);
        ThermalFoundation.proxy.addIModelRegister((IModelRegister)blockFluidPyrotheum);
        ThermalFoundation.proxy.addIModelRegister((IModelRegister)blockFluidCryotheum);
        ThermalFoundation.proxy.addIModelRegister((IModelRegister)blockFluidAerotheum);
        ThermalFoundation.proxy.addIModelRegister((IModelRegister)blockFluidPetrotheum);
        ThermalFoundation.proxy.addIModelRegister((IModelRegister)blockFluidMana);
    }

    public static void createBuckets() {
        FluidRegistry.addBucketForFluid((Fluid)fluidSteam);
        FluidRegistry.addBucketForFluid((Fluid)fluidCreosote);
        FluidRegistry.addBucketForFluid((Fluid)fluidCoal);
        FluidRegistry.addBucketForFluid((Fluid)fluidCrudeOil);
        FluidRegistry.addBucketForFluid((Fluid)fluidRefinedOil);
        FluidRegistry.addBucketForFluid((Fluid)fluidFuel);
        FluidRegistry.addBucketForFluid((Fluid)fluidSap);
        FluidRegistry.addBucketForFluid((Fluid)fluidSyrup);
        FluidRegistry.addBucketForFluid((Fluid)fluidResin);
        FluidRegistry.addBucketForFluid((Fluid)fluidTreeOil);
        FluidRegistry.addBucketForFluid((Fluid)fluidSeedOil);
        FluidRegistry.addBucketForFluid((Fluid)fluidBiocrude);
        FluidRegistry.addBucketForFluid((Fluid)fluidBiofuel);
        FluidRegistry.addBucketForFluid((Fluid)fluidMushroomStew);
        FluidRegistry.addBucketForFluid((Fluid)fluidExperience);
        FluidRegistry.addBucketForFluid((Fluid)fluidPotion);
        FluidRegistry.addBucketForFluid((Fluid)fluidPotionSplash);
        FluidRegistry.addBucketForFluid((Fluid)fluidPotionLingering);
        FluidRegistry.addBucketForFluid((Fluid)fluidRedstone);
        FluidRegistry.addBucketForFluid((Fluid)fluidGlowstone);
        FluidRegistry.addBucketForFluid((Fluid)fluidEnder);
        FluidRegistry.addBucketForFluid((Fluid)fluidPyrotheum);
        FluidRegistry.addBucketForFluid((Fluid)fluidCryotheum);
        FluidRegistry.addBucketForFluid((Fluid)fluidAerotheum);
        FluidRegistry.addBucketForFluid((Fluid)fluidPetrotheum);
        FluidRegistry.addBucketForFluid((Fluid)fluidMana);
    }

    public static void refreshReferences() {
        fluidSteam = FluidRegistry.getFluid((String)"steam");
        fluidCreosote = FluidRegistry.getFluid((String)"creosote");
        fluidCoal = FluidRegistry.getFluid((String)"coal");
        fluidCrudeOil = FluidRegistry.getFluid((String)"crude_oil");
        fluidRefinedOil = FluidRegistry.getFluid((String)"refined_oil");
        fluidFuel = FluidRegistry.getFluid((String)"refined_fuel");
        fluidSap = FluidRegistry.getFluid((String)"sap");
        fluidSyrup = FluidRegistry.getFluid((String)"syrup");
        fluidResin = FluidRegistry.getFluid((String)"resin");
        fluidTreeOil = FluidRegistry.getFluid((String)"tree_oil");
        fluidSeedOil = FluidRegistry.getFluid((String)"seed_oil");
        fluidBiofuel = FluidRegistry.getFluid((String)"refined_biofuel");
        fluidMushroomStew = FluidRegistry.getFluid((String)"mushroom_stew");
        fluidExperience = FluidRegistry.getFluid((String)"experience");
        fluidPotion = FluidRegistry.getFluid((String)"potion");
        fluidPotionSplash = FluidRegistry.getFluid((String)"potion_splash");
        fluidPotionLingering = FluidRegistry.getFluid((String)"potion_lingering");
        fluidRedstone = FluidRegistry.getFluid((String)"redstone");
        fluidGlowstone = FluidRegistry.getFluid((String)"glowstone");
        fluidEnder = FluidRegistry.getFluid((String)"ender");
        fluidPyrotheum = FluidRegistry.getFluid((String)"pyrotheum");
        fluidCryotheum = FluidRegistry.getFluid((String)"cryotheum");
        fluidAerotheum = FluidRegistry.getFluid((String)"aerotheum");
        fluidPetrotheum = FluidRegistry.getFluid((String)"petrotheum");
        fluidMana = FluidRegistry.getFluid((String)"mana");
    }

    public static boolean isPotion(@Nonnull FluidStack stack) {
        return stack.getFluid().getName().equals(fluidPotion.getName());
    }

    public static boolean isSplashPotion(@Nonnull FluidStack stack) {
        return stack.getFluid().getName().equals(fluidPotionSplash.getName());
    }

    public static boolean isLingeringPotion(@Nonnull FluidStack stack) {
        return stack.getFluid().getName().equals(fluidPotionLingering.getName());
    }

    public static FluidStack getPotion(int amount, PotionType type) {
        if (type == null || type == PotionTypes.field_185229_a) {
            return null;
        }
        if (type == PotionTypes.field_185230_b) {
            return new FluidStack(FluidRegistry.WATER, amount);
        }
        return TFFluids.addPotionToFluidStack(new FluidStack(fluidPotion, amount), type);
    }

    public static FluidStack getSplashPotion(int amount, PotionType type) {
        if (type == null || type == PotionTypes.field_185229_a) {
            return null;
        }
        return TFFluids.addPotionToFluidStack(new FluidStack(fluidPotionSplash, amount), type);
    }

    public static FluidStack getLingeringPotion(int amount, PotionType type) {
        if (type == null || type == PotionTypes.field_185229_a) {
            return null;
        }
        return TFFluids.addPotionToFluidStack(new FluidStack(fluidPotionLingering, amount), type);
    }

    public static FluidStack addPotionToFluidStack(FluidStack stack, PotionType type) {
        ResourceLocation resourcelocation = (ResourceLocation)PotionType.field_185176_a.func_177774_c((Object)type);
        if (resourcelocation == null) {
            return null;
        }
        if (type == PotionTypes.field_185229_a) {
            if (stack.tag != null) {
                stack.tag.func_82580_o("Potion");
                if (stack.tag.func_82582_d()) {
                    stack.tag = null;
                }
            }
        } else {
            if (stack.tag == null) {
                stack.tag = new NBTTagCompound();
            }
            stack.tag.func_74778_a("Potion", resourcelocation.toString());
        }
        return stack;
    }

    public static FluidStack getPotionFluid(int amount, ItemStack stack) {
        Item item = stack.func_77973_b();
        if (item.equals(Items.field_151068_bn)) {
            return TFFluids.getPotion(amount, PotionUtils.func_185191_c((ItemStack)stack));
        }
        if (item.equals(Items.field_185155_bH)) {
            return TFFluids.getSplashPotion(amount, PotionUtils.func_185191_c((ItemStack)stack));
        }
        if (item.equals(Items.field_185156_bI)) {
            return TFFluids.getLingeringPotion(amount, PotionUtils.func_185191_c((ItemStack)stack));
        }
        return null;
    }

    public static FluidStack getXPFluid(FluidStack stack) {
        if (stack == null) {
            return null;
        }
        if (stack.getFluid().equals(fluidExperience)) {
            return stack;
        }
        String name = stack.getFluid().getName();
        if (name.equals("essence") || name.equals("xpjuice")) {
            return new FluidStack(fluidExperience, stack.amount);
        }
        return null;
    }
}

