/*
 * Decompiled with CFR 0.152.
 */
package jeresources.compatibility;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import jeresources.api.IPlantRegistry;
import jeresources.api.drop.PlantDrop;
import jeresources.entry.PlantEntry;
import jeresources.registry.PlantRegistry;
import jeresources.util.LogHelper;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Tuple;
import net.minecraftforge.common.IPlantable;

public class PlantRegistryImpl
implements IPlantRegistry {
    private static List<PlantEntry> registers = new ArrayList<PlantEntry>();
    private static List<Tuple<ItemStack, PlantDrop[]>> addedDrops = new ArrayList<Tuple<ItemStack, PlantDrop[]>>();
    private static final ItemStack grass = new ItemStack((Block)Blocks.field_150329_H, 1, 1);

    protected PlantRegistryImpl() {
    }

    @Override
    public void register(ItemStack itemStack, IPlantable plant, PlantDrop ... drops) {
        try {
            registers.add(new PlantEntry(itemStack, plant, drops));
        }
        catch (Exception e) {
            LogHelper.debug("Error while registering plant %s", itemStack.toString());
        }
    }

    @Override
    public void register(ItemStack itemStack, PlantDrop ... drops) {
        try {
            registers.add(new PlantEntry(itemStack, drops));
        }
        catch (Exception e) {
            LogHelper.debug("Error while registering plant %s", itemStack.toString());
        }
    }

    @Override
    public <T extends Item> void register(T plant, PlantDrop ... drops) {
        try {
            registers.add(new PlantEntry(plant, drops));
        }
        catch (Exception e) {
            LogHelper.debug("Error while registering plant %s", plant.getRegistryName());
        }
    }

    @Override
    public void registerDrops(@Nonnull ItemStack itemStack, PlantDrop ... drops) {
        try {
            if (drops.length > 0 || ItemStack.func_77989_b((ItemStack)itemStack, (ItemStack)grass)) {
                addedDrops.add((Tuple<ItemStack, PlantDrop[]>)new Tuple((Object)itemStack, (Object)drops));
            }
        }
        catch (Exception e) {
            LogHelper.debug("Error while registering drops for %s", itemStack.toString());
        }
    }

    protected static void commit() {
        for (PlantEntry plantEntry : registers) {
            PlantRegistry.getInstance().registerPlant(plantEntry);
        }
        for (Tuple tuple : addedDrops) {
            PlantRegistry.getInstance().addDrops((ItemStack)tuple.func_76341_a(), (PlantDrop[])tuple.func_76340_b());
        }
    }
}

