/*
 * Decompiled with CFR 0.152.
 */
package landmaster.plustic.modules;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import landmaster.plustic.PlusTiC;
import landmaster.plustic.config.Config;
import landmaster.plustic.modules.IModule;
import landmaster.plustic.tools.ToolKatana;
import landmaster.plustic.tools.ToolLaserGun;
import landmaster.plustic.tools.parts.ToolPartWithStoneMold;
import landmaster.plustic.tools.stats.BatteryCellMaterialStats;
import landmaster.plustic.tools.stats.LaserMediumMaterialStats;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.materials.IMaterialStats;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.modifiers.IModifier;
import slimeknights.tconstruct.library.tinkering.PartMaterialType;
import slimeknights.tconstruct.library.tools.IToolPart;
import slimeknights.tconstruct.library.tools.Pattern;
import slimeknights.tconstruct.library.tools.ToolCore;
import slimeknights.tconstruct.library.tools.ToolPart;
import slimeknights.tconstruct.tools.TinkerMaterials;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.tools.TinkerTools;

@Mod.EventBusSubscriber(modid="plustic")
public class ModuleTools
implements IModule {
    public static ToolKatana katana;
    public static ToolLaserGun laserGun;
    public static ToolPart pipe_piece;
    public static ToolPart laser_medium;
    public static ToolPart battery_cell;
    private static final List<ToolCore> tools;
    private static final List<IToolPart> toolParts;

    @SubscribeEvent
    public static void initItems(RegistryEvent.Register<Item> event) {
        pipe_piece = new ToolPartWithStoneMold(576);
        pipe_piece.func_77655_b("pipe_piece").setRegistryName("pipe_piece");
        event.getRegistry().register((IForgeRegistryEntry)pipe_piece);
        TinkerRegistry.registerToolPart((IToolPart)pipe_piece);
        PlusTiC.proxy.registerToolPartModel(pipe_piece);
        toolParts.add((IToolPart)pipe_piece);
        laser_medium = new ToolPartWithStoneMold(432);
        laser_medium.func_77655_b("laser_medium").setRegistryName("laser_medium");
        event.getRegistry().register((IForgeRegistryEntry)laser_medium);
        TinkerRegistry.registerToolPart((IToolPart)laser_medium);
        PlusTiC.proxy.registerToolPartModel(laser_medium);
        toolParts.add((IToolPart)laser_medium);
        battery_cell = new ToolPartWithStoneMold(432);
        battery_cell.func_77655_b("battery_cell").setRegistryName("battery_cell");
        event.getRegistry().register((IForgeRegistryEntry)battery_cell);
        TinkerRegistry.registerToolPart((IToolPart)battery_cell);
        PlusTiC.proxy.registerToolPartModel(battery_cell);
        toolParts.add((IToolPart)battery_cell);
        if (Config.laserGun) {
            laserGun = new ToolLaserGun();
            event.getRegistry().register((IForgeRegistryEntry)laserGun);
            TinkerRegistry.registerToolForgeCrafting((ToolCore)laserGun);
            PlusTiC.proxy.registerToolModel((ToolCore)laserGun);
            tools.add((ToolCore)laserGun);
            TinkerRegistry.addMaterialStats((Material)TinkerMaterials.prismarine, (IMaterialStats)new LaserMediumMaterialStats(2.5f, 20.0f));
            TinkerRegistry.addMaterialStats((Material)TinkerMaterials.blaze, (IMaterialStats)new BatteryCellMaterialStats(85000), (IMaterialStats[])new IMaterialStats[]{new LaserMediumMaterialStats(3.2f, 17.0f)});
            TinkerRegistry.addMaterialStats((Material)TinkerMaterials.endrod, (IMaterialStats)new BatteryCellMaterialStats(260000), (IMaterialStats[])new IMaterialStats[]{new LaserMediumMaterialStats(8.6f, 38.0f)});
            TinkerRegistry.addMaterialStats((Material)TinkerMaterials.copper, (IMaterialStats)new BatteryCellMaterialStats(55000));
            TinkerRegistry.addMaterialStats((Material)TinkerMaterials.silver, (IMaterialStats)new BatteryCellMaterialStats(75000));
            TinkerRegistry.addMaterialStats((Material)TinkerMaterials.manyullyn, (IMaterialStats)new BatteryCellMaterialStats(120000));
        }
        if (Config.katana) {
            katana = new ToolKatana();
            event.getRegistry().register((IForgeRegistryEntry)katana);
            TinkerRegistry.registerToolForgeCrafting((ToolCore)katana);
            PlusTiC.proxy.registerToolModel((ToolCore)katana);
            tools.add((ToolCore)katana);
        }
        for (IToolPart part : ModuleTools.getPlusTiCToolParts()) {
            for (ToolCore tool : ModuleTools.getPlusTiCTools()) {
                for (PartMaterialType pmt : tool.getRequiredComponents()) {
                    if (!pmt.getPossibleParts().contains(part)) continue;
                    TinkerRegistry.registerStencilTableCrafting((ItemStack)Pattern.setTagForPart((ItemStack)new ItemStack((Item)TinkerTools.pattern), (Item)((Item)part)));
                }
            }
        }
        for (IModifier modifier : new IModifier[]{TinkerModifiers.modBaneOfArthopods, TinkerModifiers.modBeheading, TinkerModifiers.modDiamond, TinkerModifiers.modEmerald, TinkerModifiers.modGlowing, TinkerModifiers.modHaste, TinkerModifiers.modKnockback, TinkerModifiers.modLuck, TinkerModifiers.modMendingMoss, TinkerModifiers.modNecrotic, TinkerModifiers.modReinforced, TinkerModifiers.modSharpness, TinkerModifiers.modShulking, TinkerModifiers.modSilktouch, TinkerModifiers.modSmite, TinkerModifiers.modSoulbound, TinkerModifiers.modWebbed}) {
            PlusTiC.proxy.registerModifierModel(modifier, new ResourceLocation("plustic", "models/item/modifiers/" + modifier.getIdentifier()));
        }
    }

    public static List<ToolCore> getPlusTiCTools() {
        return Collections.unmodifiableList(tools);
    }

    public static List<IToolPart> getPlusTiCToolParts() {
        return Collections.unmodifiableList(toolParts);
    }

    static {
        tools = new ArrayList<ToolCore>();
        toolParts = new ArrayList<IToolPart>();
    }
}

