/*
 * Decompiled with CFR 0.152.
 */
package landmaster.plustic.modules;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import landmaster.plustic.PlusTiC;
import landmaster.plustic.config.Config;
import landmaster.plustic.fluids.FluidMolten;
import landmaster.plustic.modules.IModule;
import landmaster.plustic.tools.stats.BatteryCellMaterialStats;
import landmaster.plustic.tools.stats.LaserMediumMaterialStats;
import landmaster.plustic.traits.Apocalypse;
import landmaster.plustic.traits.Heavy;
import landmaster.plustic.traits.Portly;
import landmaster.plustic.util.Utils;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.common.Loader;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Triple;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.materials.BowMaterialStats;
import slimeknights.tconstruct.library.materials.ExtraMaterialStats;
import slimeknights.tconstruct.library.materials.HandleMaterialStats;
import slimeknights.tconstruct.library.materials.HeadMaterialStats;
import slimeknights.tconstruct.library.materials.IMaterialStats;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.traits.ITrait;
import slimeknights.tconstruct.tools.TinkerTraits;

public class ModuleLandCore
implements IModule {
    @Override
    public void init() {
        if (Config.landCore && Loader.isModLoaded((String)"landcore")) {
            List<Triple> matData = Arrays.asList(Triple.of((Object)"thorium", (Object)65471, (Object)800), Triple.of((Object)"tungsten", (Object)0x5C5C5C, (Object)1100), Triple.of((Object)"landium", (Object)0xFF0077, (Object)1500));
            Object2ObjectOpenHashMap mats = new Object2ObjectOpenHashMap();
            matData.forEach(arg_0 -> ModuleLandCore.lambda$init$0((Map)mats, arg_0));
            Material thorium = (Material)mats.get("thorium");
            thorium.addTrait((ITrait)Apocalypse.apocalypse, "head");
            thorium.addTrait((ITrait)TinkerTraits.flammable);
            PlusTiC.proxy.setRenderInfo(thorium, 65471);
            TinkerRegistry.addMaterialStats((Material)thorium, (IMaterialStats)new HeadMaterialStats(500, 6.5f, 4.5f, 2), (IMaterialStats[])new IMaterialStats[]{new HandleMaterialStats(0.7f, -50), new ExtraMaterialStats(200), new BatteryCellMaterialStats(100000), PlusTiC.justWhy});
            Material tungsten = (Material)mats.get("tungsten");
            tungsten.addTrait((ITrait)Heavy.heavy);
            PlusTiC.proxy.setRenderInfo(tungsten, 0x5C5C5C);
            TinkerRegistry.addMaterialStats((Material)tungsten, (IMaterialStats)new HeadMaterialStats(700, 9.0f, 4.75f, 2), (IMaterialStats[])new IMaterialStats[]{new HandleMaterialStats(1.4f, 0), new ExtraMaterialStats(400), PlusTiC.justWhy});
            Material landium = (Material)mats.get("landium");
            landium.addTrait((ITrait)Portly.portly);
            PlusTiC.proxy.setRenderInfo(landium, 0xFF0077);
            TinkerRegistry.addMaterialStats((Material)landium, (IMaterialStats)new HeadMaterialStats(1500, 8.7f, 5.5f, 3), (IMaterialStats[])new IMaterialStats[]{new HandleMaterialStats(1.5f, -100), new ExtraMaterialStats(380), new BowMaterialStats(1.2f, 1.6f, 7.0f), new LaserMediumMaterialStats(7.0f, 30.0f)});
            PlusTiC.materials.putAll((Map<String, Material>)mats);
        }
    }

    private static /* synthetic */ void lambda$init$0(Map mats, Triple matDatum) {
        Material mat = new Material((String)matDatum.getLeft(), ((Integer)matDatum.getMiddle()).intValue());
        String ingot = "ingot" + StringUtils.capitalize((String)((String)matDatum.getLeft()));
        mat.addItem(ingot, 1, 144);
        mat.setCraftable(false).setCastable(true);
        FluidMolten matFluid = Utils.fluidMetal((String)matDatum.getLeft(), (Integer)matDatum.getMiddle());
        matFluid.setTemperature((Integer)matDatum.getRight());
        Utils.initFluidMetal((Fluid)matFluid);
        mat.setFluid((Fluid)matFluid);
        mats.put(matDatum.getLeft(), mat);
    }
}

