/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.protection.user;

import com.mojang.authlib.GameProfile;
import com.valkyrieofnight.vlib.protection.api.IUser;
import java.util.UUID;
import javax.annotation.Nonnull;

public class User
implements IUser {
    public static final User NONE = new User();
    protected UUID uuid;
    protected String username;

    private User() {
        this.uuid = null;
        this.username = "none";
    }

    public User(@Nonnull UUID uuid) {
        this(uuid, "");
    }

    public User(@Nonnull UUID uuid, String username) {
        this.uuid = uuid;
        this.username = username;
        if (this.username == null) {
            this.username = "";
        }
    }

    public User(@Nonnull GameProfile profile) {
        this.uuid = profile.getId();
        this.username = profile.getName();
    }

    @Override
    public UUID getUUID() {
        return this.uuid;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public boolean isUUID(UUID other) {
        return this.uuid == null ? other == null : this.uuid.equals(other);
    }

    @Override
    public boolean isUsername(String other) {
        return this.username.equals(other);
    }

    public boolean equals(Object o) {
        if (!(o instanceof IUser)) {
            return false;
        }
        IUser u = (IUser)o;
        return false;
    }
}

