/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.refinedrelocation.tile;

import javax.annotation.Nullable;
import net.blay09.mods.refinedrelocation.RefinedRelocationConfig;
import net.blay09.mods.refinedrelocation.api.Capabilities;
import net.blay09.mods.refinedrelocation.api.filter.IRootFilter;
import net.blay09.mods.refinedrelocation.api.grid.ISortingInventory;
import net.blay09.mods.refinedrelocation.capability.CapabilityRootFilter;
import net.blay09.mods.refinedrelocation.capability.CapabilitySimpleFilter;
import net.blay09.mods.refinedrelocation.capability.CapabilitySortingGridMember;
import net.blay09.mods.refinedrelocation.capability.CapabilitySortingInventory;
import net.blay09.mods.refinedrelocation.tile.TileMod;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class TileSortingInterface
extends TileMod
implements ITickable {
    private final ISortingInventory sortingInventory = Capabilities.getDefaultInstance(Capabilities.SORTING_INVENTORY);
    private final IRootFilter rootFilter = Capabilities.getDefaultInstance(Capabilities.ROOT_FILTER);
    private TileEntity cachedConnectedTile;
    private ItemStack[] lastInventory;
    private int currentDetectionSlot;

    public void onLoad() {
        super.onLoad();
        this.sortingInventory.onLoad(this);
    }

    public void func_73660_a() {
        IItemHandler itemHandler;
        this.baseUpdate();
        if (this.cachedConnectedTile == null) {
            this.cachedConnectedTile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(this.getFacing()));
        } else if (this.cachedConnectedTile.func_145837_r()) {
            this.cachedConnectedTile = null;
            this.lastInventory = null;
        }
        this.sortingInventory.onUpdate(this);
        if (!this.field_145850_b.field_72995_K && (itemHandler = this.sortingInventory.getItemHandler()) != null) {
            int inventorySize = itemHandler.getSlots();
            if (this.lastInventory == null || inventorySize != this.lastInventory.length) {
                this.lastInventory = new ItemStack[itemHandler.getSlots()];
                for (int i = 0; i < inventorySize; ++i) {
                    ItemStack currentStack = itemHandler.getStackInSlot(i);
                    this.lastInventory[i] = currentStack.func_190926_b() ? ItemStack.field_190927_a : currentStack.func_77946_l();
                }
                this.currentDetectionSlot = 0;
            }
            for (int j = 0; j < Math.min(RefinedRelocationConfig.sortingInterfaceSlotsPerTick, inventorySize); ++j) {
                int i = this.currentDetectionSlot;
                ItemStack prevStack = this.lastInventory[i];
                ItemStack currentStack = itemHandler.getStackInSlot(i);
                if (!ItemStack.func_179545_c((ItemStack)prevStack, (ItemStack)currentStack) || !ItemStack.func_77970_a((ItemStack)prevStack, (ItemStack)currentStack)) {
                    this.sortingInventory.onSlotChanged(i);
                    this.lastInventory[i] = currentStack.func_190926_b() ? ItemStack.field_190927_a : currentStack.func_77946_l();
                }
                ++this.currentDetectionSlot;
                if (this.currentDetectionSlot < inventorySize) continue;
                this.currentDetectionSlot = 0;
            }
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.sortingInventory.onInvalidate(this);
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        this.sortingInventory.onInvalidate(this);
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.sortingInventory.deserializeNBT((NBTBase)compound.func_74775_l("SortingInventory"));
        this.rootFilter.deserializeNBT((NBTBase)compound.func_74775_l("RootFilter"));
    }

    @Override
    public void readFromNBTSynced(NBTTagCompound compound) {
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74782_a("SortingInventory", this.sortingInventory.serializeNBT());
        compound.func_74782_a("RootFilter", this.rootFilter.serializeNBT());
        return compound;
    }

    @Override
    public NBTTagCompound writeToNBTSynced(NBTTagCompound compound) {
        return compound;
    }

    @Override
    protected void onFirstTick() {
        this.cachedConnectedTile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(this.getFacing()));
    }

    public EnumFacing getFacing() {
        return EnumFacing.func_82600_a((int)this.func_145832_p());
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.cachedConnectedTile != null && this.cachedConnectedTile.hasCapability(capability, this.getFacing().func_176734_d());
        }
        return capability == CapabilitySortingInventory.CAPABILITY || capability == CapabilitySortingGridMember.CAPABILITY || capability == CapabilityRootFilter.CAPABILITY || capability == CapabilitySimpleFilter.CAPABILITY || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (this.cachedConnectedTile != null) {
                return (T)this.cachedConnectedTile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.getFacing().func_176734_d());
            }
        } else {
            if (capability == CapabilitySortingInventory.CAPABILITY || capability == CapabilitySortingGridMember.CAPABILITY) {
                return (T)this.sortingInventory;
            }
            if (capability == CapabilityRootFilter.CAPABILITY || capability == CapabilitySimpleFilter.CAPABILITY) {
                return (T)this.rootFilter;
            }
        }
        return null;
    }

    @Override
    public String getUnlocalizedName() {
        return "container.refinedrelocation:sorting_interface";
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    @Override
    public void dropItemHandlers() {
    }
}

