/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.refinedrelocation.filter;

import net.blay09.mods.refinedrelocation.api.Capabilities;
import net.blay09.mods.refinedrelocation.api.client.IFilterIcon;
import net.blay09.mods.refinedrelocation.api.filter.IFilter;
import net.blay09.mods.refinedrelocation.client.ClientProxy;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class SameItemFilter
implements IFilter {
    public static final String ID = "refinedrelocation:same_item_filter";
    private boolean ignoreMetadata = false;
    private boolean ignoreNBT = true;

    @Override
    public String getIdentifier() {
        return ID;
    }

    @Override
    public boolean isFilterUsable(TileEntity tileEntity) {
        return tileEntity.hasCapability(Capabilities.SORTING_INVENTORY, null);
    }

    @Override
    public boolean passes(TileEntity tileEntity, ItemStack itemStack) {
        IItemHandler itemHandler = (IItemHandler)tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        if (itemHandler != null) {
            for (int i = 0; i < itemHandler.getSlots(); ++i) {
                ItemStack otherStack = itemHandler.getStackInSlot(i);
                if (otherStack.func_190926_b() || itemStack.func_77973_b() != otherStack.func_77973_b() || !this.ignoreMetadata && itemStack.func_77952_i() != otherStack.func_77952_i() || !this.ignoreNBT && !ItemStack.func_77970_a((ItemStack)itemStack, (ItemStack)otherStack)) continue;
                return true;
            }
        }
        return false;
    }

    public NBTBase serializeNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74757_a("IgnoreMetadata", this.ignoreMetadata);
        compound.func_74757_a("IgnoreNBT", this.ignoreNBT);
        return compound;
    }

    public void deserializeNBT(NBTBase nbt) {
        NBTTagCompound compound = (NBTTagCompound)nbt;
        this.ignoreMetadata = compound.func_74767_n("IgnoreMetadata");
        this.ignoreNBT = compound.func_74767_n("IgnoreNBT");
    }

    @Override
    public String getLangKey() {
        return "filter.refinedrelocation:same_item_filter";
    }

    @Override
    public String getDescriptionLangKey() {
        return "filter.refinedrelocation:same_item_filter.description";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IFilterIcon getFilterIcon() {
        return ClientProxy.TEXTURE_ATLAS.getSprite("refinedrelocation:icon_same_item_filter");
    }
}

