/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.refinedrelocation.client.gui.element;

import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.blay09.mods.refinedrelocation.api.RefinedRelocationAPI;
import net.blay09.mods.refinedrelocation.client.gui.base.IParentScreen;
import net.blay09.mods.refinedrelocation.client.gui.base.element.GuiImageButton;
import net.blay09.mods.refinedrelocation.tile.TileBlockExtender;
import net.blay09.mods.refinedrelocation.util.RelativeSide;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.TextFormatting;

public class GuiSideButton
extends GuiImageButton {
    private final TileBlockExtender tileEntity;
    private final RelativeSide side;

    public GuiSideButton(int x, int y, TileBlockExtender tileEntity, RelativeSide side) {
        super(x, y, "side_" + side.name().toLowerCase(Locale.ENGLISH));
        this.tileEntity = tileEntity;
        this.side = side;
        this.setSize(16, 16);
        this.setVisible(true);
    }

    @Override
    protected String getHoverTexture() {
        if (this.textureName.equals("side_front")) {
            return this.getNormalTexture();
        }
        return super.getHoverTexture();
    }

    @Override
    public void actionPerformed(int mouseButton) {
        int index;
        if (this.side == RelativeSide.FRONT) {
            if (GuiScreen.func_146272_n()) {
                for (RelativeSide side : RelativeSide.values()) {
                    if (side == RelativeSide.FRONT) continue;
                    this.tileEntity.setSideMapping(side, null);
                    RefinedRelocationAPI.sendContainerMessageToServer("ToggleSide", side.ordinal(), -1);
                }
            }
            return;
        }
        Object facing = this.tileEntity.getSideMapping(this.side);
        if (mouseButton == 0) {
            index = facing != null ? facing.func_176745_a() + 1 : 0;
        } else if (mouseButton == 1) {
            index = facing != null ? facing.func_176745_a() - 1 : 5;
        } else {
            return;
        }
        facing = index >= 6 ? null : (index < 0 ? null : EnumFacing.func_82600_a((int)index));
        this.tileEntity.setSideMapping(this.side, (EnumFacing)facing);
        RefinedRelocationAPI.sendContainerMessageToServer("ToggleSide", this.side.ordinal(), facing != null ? facing.func_176745_a() : -1);
    }

    @Override
    public void drawBackground(IParentScreen parentScreen, int mouseX, int mouseY, float partialTicks) {
        super.drawBackground(parentScreen, mouseX, mouseY, partialTicks);
        if (this.side != RelativeSide.FRONT) {
            FontRenderer fontRenderer = parentScreen.getFontRenderer();
            char sideChar = this.getFacingChar(this.tileEntity.getSideMapping(this.side));
            int x = this.getAbsoluteX() + this.getWidth() / 2 - fontRenderer.func_78263_a(sideChar) / 2;
            int y = this.getAbsoluteY() + this.getHeight() / 2 - fontRenderer.field_78288_b / 2;
            GlStateManager.func_179109_b((float)0.5f, (float)0.5f, (float)0.0f);
            parentScreen.getFontRenderer().func_78276_b(String.valueOf(sideChar), x, y, -1);
            GlStateManager.func_179109_b((float)-0.5f, (float)-0.5f, (float)0.0f);
        }
    }

    @Override
    public void addTooltip(List<String> list) {
        if (this.side == RelativeSide.FRONT) {
            list.add(TextFormatting.RED + I18n.func_135052_a((String)"gui.refinedrelocation:block_extender.front", (Object[])new Object[0]));
        } else {
            EnumFacing mapping = this.tileEntity.getSideMapping(this.side);
            list.add(TextFormatting.YELLOW + I18n.func_135052_a((String)"gui.refinedrelocation:block_extender.side_tooltip", (Object[])new Object[]{TextFormatting.WHITE + I18n.func_135052_a((String)("gui.refinedrelocation:block_extender.side_" + (mapping != null ? mapping.func_176610_l() : "none")), (Object[])new Object[0])}));
            list.add(TextFormatting.RED + I18n.func_135052_a((String)"gui.refinedrelocation:block_extender.toggle_side", (Object[])new Object[0]));
        }
    }

    private char getFacingChar(@Nullable EnumFacing facing) {
        if (facing == null) {
            return '-';
        }
        switch (facing) {
            case DOWN: {
                return 'D';
            }
            case UP: {
                return 'U';
            }
            case WEST: {
                return 'W';
            }
            case EAST: {
                return 'E';
            }
            case NORTH: {
                return 'N';
            }
            case SOUTH: {
                return 'S';
            }
        }
        return ' ';
    }
}

