/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.refinedrelocation.client.gui.element;

import java.util.List;
import net.blay09.mods.refinedrelocation.client.gui.base.element.GuiTextButton;
import net.blay09.mods.refinedrelocation.tile.TileBlockExtender;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Items;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;

public class GuiButtonStackLimiter
extends GuiTextButton {
    private final TileBlockExtender blockExtender;

    public GuiButtonStackLimiter(int x, int y, int width, int height, TileBlockExtender blockExtender) {
        super(x, y, width, height, "");
        this.blockExtender = blockExtender;
    }

    @Override
    public void actionPerformed(int mouseButton) {
        int limit = this.blockExtender.getStackLimiterLimit();
        int index = (int)(Math.log(limit) / Math.log(2.0));
        int maxIndex = (int)(Math.log(Items.field_190931_a.func_77639_j()) / Math.log(2.0));
        if (mouseButton == 0) {
            if (index < maxIndex) {
                ++index;
            }
        } else if (mouseButton == 1 && index > 0) {
            --index;
        }
        this.blockExtender.setStackLimiterLimit((int)Math.pow(2.0, index));
    }

    @Override
    public void mouseWheelMoved(int mouseX, int mouseY, int delta) {
        int limit = this.blockExtender.getStackLimiterLimit();
        if (delta > 0) {
            ++limit;
        } else if (delta < 0) {
            --limit;
        }
        limit = MathHelper.func_76125_a((int)limit, (int)1, (int)Items.field_190931_a.func_77639_j());
        this.blockExtender.setStackLimiterLimit(limit);
    }

    @Override
    public void update() {
        super.update();
        this.text = String.valueOf(this.blockExtender.getStackLimiterLimit());
    }

    @Override
    public void addTooltip(List<String> list) {
        list.add(I18n.func_135052_a((String)"gui.refinedrelocation:block_extender.stack_limiter", (Object[])new Object[0]));
        list.add(TextFormatting.GREEN + I18n.func_135052_a((String)"gui.refinedrelocation:block_extender.stack_limiter_increase", (Object[])new Object[0]));
        list.add(TextFormatting.RED + I18n.func_135052_a((String)"gui.refinedrelocation:block_extender.stack_limiter_decrease", (Object[])new Object[0]));
    }
}

