/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.tile.craftingmonitor;

import com.google.common.base.Optional;
import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingManager;
import com.raoulvdberge.refinedstorage.api.autocrafting.task.ICraftingTask;
import com.raoulvdberge.refinedstorage.api.network.INetwork;
import com.raoulvdberge.refinedstorage.item.ItemWirelessCraftingMonitor;
import com.raoulvdberge.refinedstorage.network.MessageWirelessCraftingMonitorSettings;
import com.raoulvdberge.refinedstorage.tile.craftingmonitor.ICraftingMonitor;
import com.raoulvdberge.refinedstorage.tile.data.TileDataParameter;
import java.util.Collection;
import java.util.Collections;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class WirelessCraftingMonitor
implements ICraftingMonitor {
    private ItemStack stack;
    private int networkDimension;
    private BlockPos network;
    private int tabPage;
    private Optional<UUID> tabSelected;

    public WirelessCraftingMonitor(ItemStack stack) {
        this.stack = stack;
        this.networkDimension = ItemWirelessCraftingMonitor.getDimensionId(stack);
        this.network = new BlockPos(ItemWirelessCraftingMonitor.getX(stack), ItemWirelessCraftingMonitor.getY(stack), ItemWirelessCraftingMonitor.getZ(stack));
        this.tabPage = ItemWirelessCraftingMonitor.getTabPage(stack);
        this.tabSelected = ItemWirelessCraftingMonitor.getTabSelected(stack);
    }

    @Override
    public String getGuiTitle() {
        return "gui.refinedstorage:wireless_crafting_monitor";
    }

    @Override
    public void onCancelled(EntityPlayerMP player, @Nullable UUID id) {
        INetwork network = this.getNetwork();
        if (network != null) {
            network.getItemGridHandler().onCraftingCancelRequested(player, id);
        }
    }

    @Override
    public TileDataParameter<Integer, ?> getRedstoneModeParameter() {
        return null;
    }

    @Override
    public Collection<ICraftingTask> getTasks() {
        INetwork network = this.getNetwork();
        if (network != null) {
            return network.getCraftingManager().getTasks();
        }
        return Collections.emptyList();
    }

    @Override
    @Nullable
    public ICraftingManager getCraftingManager() {
        INetwork network = this.getNetwork();
        if (network != null) {
            return network.getCraftingManager();
        }
        return null;
    }

    private INetwork getNetwork() {
        WorldServer world = DimensionManager.getWorld((int)this.networkDimension);
        if (world != null) {
            TileEntity tile = world.func_175625_s(this.network);
            return tile instanceof INetwork ? (INetwork)tile : null;
        }
        return null;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    @Override
    public boolean isActive() {
        return true;
    }

    @Override
    public void onClosed(EntityPlayer player) {
        INetwork network = this.getNetwork();
        if (network != null) {
            network.getNetworkItemHandler().close(player);
        }
    }

    @Override
    public Optional<UUID> getTabSelected() {
        return this.tabSelected;
    }

    @Override
    public int getTabPage() {
        return this.tabPage;
    }

    @Override
    public void onTabSelectionChanged(Optional<UUID> taskId) {
        this.tabSelected = taskId.isPresent() && this.tabSelected.isPresent() && ((UUID)taskId.get()).equals(this.tabSelected.get()) ? Optional.absent() : taskId;
        RS.INSTANCE.network.sendToServer((IMessage)new MessageWirelessCraftingMonitorSettings(this.tabSelected, this.tabPage));
    }

    @Override
    public void onTabPageChanged(int page) {
        if (page >= 0) {
            this.tabPage = page;
            RS.INSTANCE.network.sendToServer((IMessage)new MessageWirelessCraftingMonitorSettings(this.tabSelected, this.tabPage));
        }
    }
}

