/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.item.itemblock;

import com.raoulvdberge.refinedstorage.RSBlocks;
import com.raoulvdberge.refinedstorage.RSItems;
import com.raoulvdberge.refinedstorage.api.storage.IStorage;
import com.raoulvdberge.refinedstorage.api.storage.disk.IStorageDiskSyncData;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.apiimpl.util.OneSixMigrationHelper;
import com.raoulvdberge.refinedstorage.block.BlockStorage;
import com.raoulvdberge.refinedstorage.item.itemblock.ItemBlockBase;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;

public class ItemBlockStorage
extends ItemBlockBase {
    public ItemBlockStorage(BlockStorage storage) {
        super(storage, true);
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        super.func_77624_a(stack, world, tooltip, flag);
        if (this.isValid(stack)) {
            UUID id = this.getId(stack);
            API.instance().getStorageDiskSync().sendRequest(id);
            IStorageDiskSyncData data = API.instance().getStorageDiskSync().getData(id);
            if (data != null) {
                if (data.getCapacity() == -1) {
                    tooltip.add(I18n.func_135052_a((String)"misc.refinedstorage:storage.stored", (Object[])new Object[]{API.instance().getQuantityFormatter().format(data.getStored())}));
                } else {
                    tooltip.add(I18n.func_135052_a((String)"misc.refinedstorage:storage.stored_capacity", (Object[])new Object[]{API.instance().getQuantityFormatter().format(data.getStored()), API.instance().getQuantityFormatter().format(data.getCapacity())}));
                }
            }
            if (flag.func_194127_a()) {
                tooltip.add(id.toString());
            }
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack storageStack = player.func_184586_b(hand);
        if (!world.field_72995_K && player.func_70093_af() && storageStack.func_77960_j() != 4) {
            UUID diskId = null;
            IStorage disk = null;
            if (this.isValid(storageStack)) {
                diskId = this.getId(storageStack);
                disk = API.instance().getStorageDiskManager(world).get(diskId);
            }
            if (disk == null || disk.getStored() == 0) {
                ItemStack processor;
                ItemStack storagePart = new ItemStack((Item)RSItems.STORAGE_PART, storageStack.func_190916_E(), storageStack.func_77960_j());
                if (!player.field_71071_by.func_70441_a(storagePart.func_77946_l())) {
                    InventoryHelper.func_180173_a((World)world, (double)player.func_180425_c().func_177958_n(), (double)player.func_180425_c().func_177956_o(), (double)player.func_180425_c().func_177952_p(), (ItemStack)storagePart);
                }
                if (!player.field_71071_by.func_70441_a((processor = new ItemStack((Item)RSItems.PROCESSOR, storageStack.func_190916_E(), 3)).func_77946_l())) {
                    InventoryHelper.func_180173_a((World)world, (double)player.func_180425_c().func_177958_n(), (double)player.func_180425_c().func_177956_o(), (double)player.func_180425_c().func_177952_p(), (ItemStack)processor);
                }
                if (disk != null) {
                    API.instance().getStorageDiskManager(world).remove(diskId);
                    API.instance().getStorageDiskManager(world).markForSaving();
                }
                return new ActionResult(EnumActionResult.SUCCESS, (Object)new ItemStack((Block)RSBlocks.MACHINE_CASING));
            }
        }
        return new ActionResult(EnumActionResult.PASS, (Object)storageStack);
    }

    public int getEntityLifespan(ItemStack stack, World world) {
        return Integer.MAX_VALUE;
    }

    private UUID getId(ItemStack disk) {
        return disk.func_77978_p().func_186857_a("Id");
    }

    private boolean isValid(ItemStack disk) {
        return disk.func_77942_o() && disk.func_77978_p().func_186855_b("Id");
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        super.func_77663_a(stack, world, entity, itemSlot, isSelected);
        if (!world.field_72995_K) {
            OneSixMigrationHelper.migrateItemStorageBlockItem(world, stack);
        }
    }
}

