/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.network.packets;

import mod.chiselsandbits.helpers.ChiselToolType;
import mod.chiselsandbits.helpers.ModUtil;
import mod.chiselsandbits.interfaces.IChiselModeItem;
import mod.chiselsandbits.network.ModPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public class PacketSetColor
extends ModPacket {
    public EnumDyeColor newColor = EnumDyeColor.WHITE;
    public ChiselToolType type = ChiselToolType.TAPEMEASURE;
    public boolean chatNotification = false;

    @Override
    public void server(EntityPlayerMP player) {
        ItemStack ei = player.func_184614_ca();
        if (ei != null && ei.func_77973_b() instanceof IChiselModeItem) {
            EnumDyeColor originalMode = this.getColor(ei);
            this.setColor(ei, this.newColor);
            if (originalMode != this.newColor && this.chatNotification) {
                Minecraft.func_71410_x().field_71439_g.func_146105_b((ITextComponent)new TextComponentTranslation("chiselsandbits.color." + this.newColor.func_176762_d().toString(), new Object[0]), true);
            }
        }
    }

    private void setColor(ItemStack ei, EnumDyeColor newColor2) {
        if (ei != null) {
            ei.func_77983_a("color", (NBTBase)new NBTTagString(newColor2.name()));
        }
    }

    private EnumDyeColor getColor(ItemStack ei) {
        try {
            if (ei != null && ei.func_77942_o()) {
                return EnumDyeColor.valueOf((String)ModUtil.getTagCompound(ei).func_74779_i("color"));
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return EnumDyeColor.WHITE;
    }

    @Override
    public void getPayload(PacketBuffer buffer) {
        buffer.writeBoolean(this.chatNotification);
        buffer.func_179249_a((Enum)this.type);
        buffer.func_179249_a((Enum)this.newColor);
    }

    @Override
    public void readPayload(PacketBuffer buffer) {
        this.chatNotification = buffer.readBoolean();
        this.type = (ChiselToolType)buffer.func_179257_a(ChiselToolType.class);
        this.newColor = (EnumDyeColor)buffer.func_179257_a(EnumDyeColor.class);
    }
}

