/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.util;

import flaxbeard.immersivepetroleum.common.util.CommandHelp;
import flaxbeard.immersivepetroleum.common.util.CommandReservoir;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;

public class CommandHandler
extends CommandBase {
    ArrayList<IPSubCommand> commands = new ArrayList();
    final String name;

    public CommandHandler() {
        this.commands.add(new CommandHelp());
        this.commands.add(new CommandReservoir());
        this.name = "ip";
    }

    public String func_71517_b() {
        return this.name;
    }

    public int func_82362_a() {
        return 4;
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
        ArrayList<String> list = new ArrayList<String>();
        if (args.length > 0) {
            for (IPSubCommand sub : this.commands) {
                if (args.length == 1) {
                    if (!args[0].isEmpty() && !sub.getIdent().startsWith(args[0].toLowerCase(Locale.ENGLISH))) continue;
                    list.add(sub.getIdent());
                    continue;
                }
                if (!sub.getIdent().equalsIgnoreCase(args[0])) continue;
                String[] redArgs = new String[args.length - 1];
                System.arraycopy(args, 1, redArgs, 0, redArgs.length);
                ArrayList<String> subCommands = sub.getSubCommands(this, server, sender, redArgs);
                if (subCommands == null) continue;
                list.addAll(subCommands);
            }
        }
        return list;
    }

    public String func_71518_a(ICommandSender sender) {
        String sub = "";
        int i = 0;
        for (IPSubCommand com : this.commands) {
            sub = sub + (i++ > 0 ? "|" : "") + com.getIdent();
        }
        return "/" + this.name + " <" + sub + ">";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) {
        if (args.length > 0) {
            for (IPSubCommand com : this.commands) {
                if (!com.getIdent().equalsIgnoreCase(args[0])) continue;
                if (!sender.func_70003_b(com.getPermissionLevel(), this.func_71517_b())) {
                    TextComponentTranslation msg = new TextComponentTranslation("commands.generic.permission", new Object[0]);
                    msg.func_150256_b().func_150238_a(TextFormatting.RED);
                    sender.func_145747_a((ITextComponent)msg);
                    continue;
                }
                com.perform(this, server, sender, args);
            }
        } else {
            String sub = "";
            int i = 0;
            for (IPSubCommand com : this.commands) {
                sub = sub + (i++ > 0 ? ", " : "") + com.getIdent();
            }
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("chat.immersiveengineering.command.available", new Object[]{sub}));
        }
    }

    public static abstract class IPSubCommand {
        public abstract String getIdent();

        public abstract void perform(CommandHandler var1, MinecraftServer var2, ICommandSender var3, String[] var4);

        public String getHelp(String subIdent) {
            return "chat.immersivepetroleum.command." + this.getIdent() + subIdent + ".help";
        }

        public abstract ArrayList<String> getSubCommands(CommandHandler var1, MinecraftServer var2, ICommandSender var3, String[] var4);

        public abstract int getPermissionLevel();
    }
}

