/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.compat.crafttweaker;

import com.google.common.collect.Lists;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.liquid.ILiquidStack;
import flaxbeard.immersivepetroleum.api.crafting.PumpjackHandler;
import java.util.ArrayList;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.immersivepetroleum.Reservoir")
@ZenRegister
public class ReservoirTweaker {
    @ZenMethod
    public static void registerReservoir(String name, ILiquidStack fluid, int minSize, int maxSize, int replenishRate, int weight, int[] dimBlacklist, int[] dimWhitelist, String[] biomeBlacklist, String[] biomeWhitelist) {
        String string;
        int x;
        ArrayList biomeBlacklistList = Lists.newArrayList();
        ArrayList biomeWhitelistList = Lists.newArrayList();
        if (name.isEmpty()) {
            CraftTweakerAPI.logError((String)"Reservoir name can not be empty string!");
        } else if (minSize <= 0) {
            CraftTweakerAPI.logError((String)"Reservoir minSize has to be at least 1mb!");
        } else if (maxSize < minSize) {
            CraftTweakerAPI.logError((String)"Reservoir maxSize can not be smaller than minSize!");
        } else if (weight <= 1) {
            CraftTweakerAPI.logError((String)"Reservoir weight has to be greater than or equal to 1!");
        }
        String rFluid = fluid.getName();
        PumpjackHandler.ReservoirType res = PumpjackHandler.addReservoir(name, rFluid, minSize, maxSize, replenishRate, weight);
        for (x = 0; x < biomeBlacklist.length; ++x) {
            string = biomeBlacklist[x];
            if (string == null || string.isEmpty()) {
                CraftTweakerAPI.logError((String)("String '" + biomeBlacklist[x] + "' in biomeBlacklist is either Empty or Null"));
                continue;
            }
            biomeBlacklistList.add(biomeBlacklist[x]);
        }
        for (x = 0; x < biomeWhitelist.length; ++x) {
            string = biomeWhitelist[x];
            if (string == null || string.isEmpty()) {
                CraftTweakerAPI.logError((String)("String '" + biomeWhitelist[x] + "' in biomeBlacklist is either Empty or Null"));
                continue;
            }
            biomeWhitelistList.add(biomeWhitelist[x]);
        }
        res.dimensionBlacklist = dimBlacklist;
        res.dimensionWhitelist = dimWhitelist;
        res.biomeBlacklist = biomeBlacklistList.toArray(new String[0]);
        res.biomeWhitelist = biomeWhitelistList.toArray(new String[0]);
        CraftTweakerAPI.logInfo((String)("Added Reservoir Type: " + name));
    }
}

