/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.core.client.renderer;

import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.BlockPos;

public class GeometryTessellator
extends Tessellator {
    private static GeometryTessellator instance = null;
    private static double deltaS = 0.0;
    private double delta = 0.0;

    public GeometryTessellator() {
        this(0x200000);
    }

    public GeometryTessellator(int size) {
        super(size);
    }

    public static GeometryTessellator getInstance() {
        if (instance == null) {
            instance = new GeometryTessellator();
        }
        return instance;
    }

    public void setTranslation(double x, double y, double z) {
        this.func_178180_c().func_178969_c(x, y, z);
    }

    public void beginQuads() {
        this.begin(7);
    }

    public void beginLines() {
        this.begin(1);
    }

    public void begin(int mode) {
        this.func_178180_c().func_181668_a(mode, DefaultVertexFormats.field_181706_f);
    }

    public void func_78381_a() {
        super.func_78381_a();
    }

    public void setDelta(double delta) {
        this.delta = delta;
    }

    public static void setStaticDelta(double delta) {
        deltaS = delta;
    }

    public void drawCuboid(BlockPos pos, int sides, int argb) {
        this.drawCuboid(pos, pos, sides, argb);
    }

    public void drawCuboid(BlockPos begin, BlockPos end, int sides, int argb) {
        GeometryTessellator.drawCuboid(this.func_178180_c(), begin, end, sides, argb, this.delta);
    }

    public static void drawCuboid(BufferBuilder buffer, BlockPos pos, int sides, int argb) {
        GeometryTessellator.drawCuboid(buffer, pos, pos, sides, argb);
    }

    public static void drawCuboid(BufferBuilder buffer, BlockPos begin, BlockPos end, int sides, int argb) {
        GeometryTessellator.drawCuboid(buffer, begin, end, sides, argb, deltaS);
    }

    private static void drawCuboid(BufferBuilder buffer, BlockPos begin, BlockPos end, int sides, int argb, double delta) {
        if (buffer.func_178979_i() == -1 || sides == 0) {
            return;
        }
        double x0 = (double)begin.func_177958_n() - delta;
        double y0 = (double)begin.func_177956_o() - delta;
        double z0 = (double)begin.func_177952_p() - delta;
        double x1 = (double)(end.func_177958_n() + 1) + delta;
        double y1 = (double)(end.func_177956_o() + 1) + delta;
        double z1 = (double)(end.func_177952_p() + 1) + delta;
        switch (buffer.func_178979_i()) {
            case 7: {
                GeometryTessellator.drawQuads(buffer, x0, y0, z0, x1, y1, z1, sides, argb);
                break;
            }
            case 1: {
                GeometryTessellator.drawLines(buffer, x0, y0, z0, x1, y1, z1, sides, argb);
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported mode!");
            }
        }
    }

    public static void drawQuads(BufferBuilder buffer, double x0, double y0, double z0, double x1, double y1, double z1, int sides, int argb) {
        int a = argb >>> 24 & 0xFF;
        int r = argb >>> 16 & 0xFF;
        int g = argb >>> 8 & 0xFF;
        int b = argb & 0xFF;
        GeometryTessellator.drawQuads(buffer, x0, y0, z0, x1, y1, z1, sides, a, r, g, b);
    }

    public static void drawQuads(BufferBuilder buffer, double x0, double y0, double z0, double x1, double y1, double z1, int sides, int a, int r, int g, int b) {
        if ((sides & 1) != 0) {
            buffer.func_181662_b(x1, y0, z0).func_181669_b(r, g, b, a).func_181675_d();
            buffer.func_181662_b(x1, y0, z1).func_181669_b(r, g, b, a).func_181675_d();
            buffer.func_181662_b(x0, y0, z1).func_181669_b(r, g, b, a).func_181675_d();
            buffer.func_181662_b(x0, y0, z0).func_181669_b(r, g, b, a).func_181675_d();
        }
        if ((sides & 2) != 0) {
            buffer.func_181662_b(x1, y1, z0).func_181669_b(r, g, b, a).func_181675_d();
            buffer.func_181662_b(x0, y1, z0).func_181669_b(r, g, b, a).func_181675_d();
            buffer.func_181662_b(x0, y1, z1).func_181669_b(r, g, b, a).func_181675_d();
            buffer.func_181662_b(x1, y1, z1).func_181669_b(r, g, b, a).func_181675_d();
        }
        if ((sides & 4) != 0) {
            buffer.func_181662_b(x1, y0, z0).func_181669_b(r, g, b, a).func_181675_d();
            buffer.func_181662_b(x0, y0, z0).func_181669_b(r, g, b, a).func_181675_d();
            buffer.func_181662_b(x0, y1, z0).func_181669_b(r, g, b, a).func_181675_d();
            buffer.func_181662_b(x1, y1, z0).func_181669_b(r, g, b, a).func_181675_d();
        }
        if ((sides & 8) != 0) {
            buffer.func_181662_b(x0, y0, z1).func_181669_b(r, g, b, a).func_181675_d();
            buffer.func_181662_b(x1, y0, z1).func_181669_b(r, g, b, a).func_181675_d();
            buffer.func_181662_b(x1, y1, z1).func_181669_b(r, g, b, a).func_181675_d();
            buffer.func_181662_b(x0, y1, z1).func_181669_b(r, g, b, a).func_181675_d();
        }
        if ((sides & 0x10) != 0) {
            buffer.func_181662_b(x0, y0, z0).func_181669_b(r, g, b, a).func_181675_d();
            buffer.func_181662_b(x0, y0, z1).func_181669_b(r, g, b, a).func_181675_d();
            buffer.func_181662_b(x0, y1, z1).func_181669_b(r, g, b, a).func_181675_d();
            buffer.func_181662_b(x0, y1, z0).func_181669_b(r, g, b, a).func_181675_d();
        }
        if ((sides & 0x20) != 0) {
            buffer.func_181662_b(x1, y0, z1).func_181669_b(r, g, b, a).func_181675_d();
            buffer.func_181662_b(x1, y0, z0).func_181669_b(r, g, b, a).func_181675_d();
            buffer.func_181662_b(x1, y1, z0).func_181669_b(r, g, b, a).func_181675_d();
            buffer.func_181662_b(x1, y1, z1).func_181669_b(r, g, b, a).func_181675_d();
        }
    }

    public static void drawLines(BufferBuilder buffer, double x0, double y0, double z0, double x1, double y1, double z1, int sides, int argb) {
        int a = argb >>> 24 & 0xFF;
        int r = argb >>> 16 & 0xFF;
        int g = argb >>> 8 & 0xFF;
        int b = argb & 0xFF;
        GeometryTessellator.drawLines(buffer, x0, y0, z0, x1, y1, z1, sides, a, r, g, b);
    }

    public static void drawLines(BufferBuilder buffer, double x0, double y0, double z0, double x1, double y1, double z1, int sides, int a, int r, int g, int b) {
        if ((sides & 0x11) != 0) {
            buffer.func_181662_b(x0, y0, z0).func_181669_b(r, g, b, a).func_181675_d();
            buffer.func_181662_b(x0, y0, z1).func_181669_b(r, g, b, a).func_181675_d();
        }
        if ((sides & 0x12) != 0) {
            buffer.func_181662_b(x0, y1, z0).func_181669_b(r, g, b, a).func_181675_d();
            buffer.func_181662_b(x0, y1, z1).func_181669_b(r, g, b, a).func_181675_d();
        }
        if ((sides & 0x21) != 0) {
            buffer.func_181662_b(x1, y0, z0).func_181669_b(r, g, b, a).func_181675_d();
            buffer.func_181662_b(x1, y0, z1).func_181669_b(r, g, b, a).func_181675_d();
        }
        if ((sides & 0x22) != 0) {
            buffer.func_181662_b(x1, y1, z0).func_181669_b(r, g, b, a).func_181675_d();
            buffer.func_181662_b(x1, y1, z1).func_181669_b(r, g, b, a).func_181675_d();
        }
        if ((sides & 5) != 0) {
            buffer.func_181662_b(x0, y0, z0).func_181669_b(r, g, b, a).func_181675_d();
            buffer.func_181662_b(x1, y0, z0).func_181669_b(r, g, b, a).func_181675_d();
        }
        if ((sides & 6) != 0) {
            buffer.func_181662_b(x0, y1, z0).func_181669_b(r, g, b, a).func_181675_d();
            buffer.func_181662_b(x1, y1, z0).func_181669_b(r, g, b, a).func_181675_d();
        }
        if ((sides & 9) != 0) {
            buffer.func_181662_b(x0, y0, z1).func_181669_b(r, g, b, a).func_181675_d();
            buffer.func_181662_b(x1, y0, z1).func_181669_b(r, g, b, a).func_181675_d();
        }
        if ((sides & 0xA) != 0) {
            buffer.func_181662_b(x0, y1, z1).func_181669_b(r, g, b, a).func_181675_d();
            buffer.func_181662_b(x1, y1, z1).func_181669_b(r, g, b, a).func_181675_d();
        }
        if ((sides & 0x14) != 0) {
            buffer.func_181662_b(x0, y0, z0).func_181669_b(r, g, b, a).func_181675_d();
            buffer.func_181662_b(x0, y1, z0).func_181669_b(r, g, b, a).func_181675_d();
        }
        if ((sides & 0x24) != 0) {
            buffer.func_181662_b(x1, y0, z0).func_181669_b(r, g, b, a).func_181675_d();
            buffer.func_181662_b(x1, y1, z0).func_181669_b(r, g, b, a).func_181675_d();
        }
        if ((sides & 0x18) != 0) {
            buffer.func_181662_b(x0, y0, z1).func_181669_b(r, g, b, a).func_181675_d();
            buffer.func_181662_b(x0, y1, z1).func_181669_b(r, g, b, a).func_181675_d();
        }
        if ((sides & 0x28) != 0) {
            buffer.func_181662_b(x1, y0, z1).func_181669_b(r, g, b, a).func_181675_d();
            buffer.func_181662_b(x1, y1, z1).func_181669_b(r, g, b, a).func_181675_d();
        }
    }
}

