/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.world.gen;

import aroma1997.world.Config;
import aroma1997.world.gen.CustomLakeGen;
import aroma1997.world.gen.CustomOreGen;
import aroma1997.world.gen.CustomSurfaceGen;
import aroma1997.world.gen.RemoveBlockGen;
import com.google.common.base.Throwables;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.StreamSupport;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.JsonUtils;
import net.minecraft.world.gen.feature.WorldGenTallGrass;
import net.minecraft.world.gen.feature.WorldGenerator;

public class WorldGenConfig {
    private static Map<String, Function<JsonObject, WorldGenerator>> generators = new HashMap<String, Function<JsonObject, WorldGenerator>>();

    public static List<WorldGenerator> loadAdditionalWorldGen(File configFile) {
        JsonArray el;
        ArrayList<WorldGenerator> generators = new ArrayList<WorldGenerator>();
        try {
            el = new JsonParser().parse((Reader)new FileReader(configFile)).getAsJsonArray();
        }
        catch (FileNotFoundException e) {
            el = new JsonArray();
        }
        HashSet<String> addedKeys = new HashSet<String>();
        for (Object current : el) {
            JsonObject object = current.getAsJsonObject();
            WorldGenerator gen = WorldGenConfig.loadAdditionalWorldGen(object);
            if (gen != null) {
                generators.add(gen);
            }
            addedKeys.add(JsonUtils.func_151200_h((JsonObject)object, (String)"identifier"));
        }
        JsonArray internal = new JsonParser().parse((Reader)new InputStreamReader(WorldGenConfig.class.getResourceAsStream("/assets/aroma1997sdimension/configs/worldgen.json"))).getAsJsonArray();
        for (JsonElement current : internal) {
            if (addedKeys.contains(JsonUtils.func_151200_h((JsonObject)current.getAsJsonObject(), (String)"identifier"))) continue;
            el.add(current);
        }
        try (JsonWriter writer = new JsonWriter((Writer)new FileWriter(configFile));){
            writer.setIndent("\t");
            Streams.write((JsonElement)el, (JsonWriter)writer);
        }
        catch (IOException e) {
            Throwables.propagate((Throwable)e);
        }
        return generators;
    }

    private static WorldGenerator loadAdditionalWorldGen(JsonObject element) {
        WorldGenerator gen = generators.getOrDefault(JsonUtils.func_151200_h((JsonObject)element, (String)"type"), WorldGenConfig::loadError).apply(element);
        if (!JsonUtils.func_151209_a((JsonObject)element, (String)"enabled", (boolean)true)) {
            return null;
        }
        return gen;
    }

    private static WorldGenerator loadOreGen(JsonObject element) {
        int minHeight = JsonUtils.func_151203_m((JsonObject)element, (String)"minHeight");
        int maxHeight = JsonUtils.func_151203_m((JsonObject)element, (String)"maxHeight");
        float amount = JsonUtils.func_151217_k((JsonObject)element, (String)"amount");
        int size = JsonUtils.func_151203_m((JsonObject)element, (String)"size");
        IBlockState oreToPlace = Config.getStateFromString(JsonUtils.func_151200_h((JsonObject)element, (String)"ore"));
        return new CustomOreGen(minHeight, maxHeight, amount, size, oreToPlace);
    }

    private static WorldGenerator loadReplaceGen(JsonObject element) {
        HashSet sources = new HashSet();
        StreamSupport.stream(element.getAsJsonArray("originalBlock").spliterator(), false).map(JsonElement::getAsString).map(Config::getStateFromString).forEach(sources::add);
        IBlockState target = Config.getStateFromString(JsonUtils.func_151200_h((JsonObject)element, (String)"targetBlock"));
        Function<IBlockState, IBlockState> func = original -> sources.contains(original) ? target : original;
        return new RemoveBlockGen(func);
    }

    private static WorldGenerator loadLakeGen(JsonObject element) {
        IBlockState targetBlock = Config.getStateFromString(JsonUtils.func_151200_h((JsonObject)element, (String)"targetBlock"));
        return new CustomLakeGen(targetBlock.func_177230_c());
    }

    private static WorldGenerator grassGen(JsonObject element) {
        return new CustomSurfaceGen((WorldGenerator)new WorldGenTallGrass(BlockTallGrass.EnumType.GRASS));
    }

    private static WorldGenerator loadError(JsonObject element) {
        throw new IllegalArgumentException("Type " + JsonUtils.func_151200_h((JsonObject)element, (String)"type") + " with identifier " + JsonUtils.func_151200_h((JsonObject)element, (String)"identifier") + " is not supported for World Generation.");
    }

    static {
        generators.put("oreGen", WorldGenConfig::loadOreGen);
        generators.put("oreReplace", WorldGenConfig::loadReplaceGen);
        generators.put("lakes", WorldGenConfig::loadLakeGen);
        generators.put("grass", WorldGenConfig::grassGen);
        generators.put("_comment", e -> null);
    }
}

