/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common;

import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.BlockJukebox;
import net.minecraft.block.BlockSand;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityBeacon;
import net.minecraft.tileentity.TileEntityBrewingStand;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityCommandBlock;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.tileentity.TileEntityEnchantmentTable;
import net.minecraft.tileentity.TileEntityEnderChest;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.tileentity.TileEntityHopper;
import net.minecraft.tileentity.TileEntityNote;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import openblocks.Config;
import openmods.utils.ITester;
import openmods.utils.ObjectTester;

public class MagnetWhitelists {
    public static final MagnetWhitelists instance = new MagnetWhitelists();
    public final ObjectTester<Entity> entityWhitelist = ObjectTester.create();
    public final ObjectTester<BlockCoords> blockWhitelist = ObjectTester.create();
    public final ObjectTester<TileEntity> tileEntityWhitelist = ObjectTester.create();

    private MagnetWhitelists() {
    }

    public static ITester<BlockCoords> createBlockIdentityTester(Block template) {
        return o -> o.blockState.func_177230_c() == template ? ITester.Result.ACCEPT : ITester.Result.CONTINUE;
    }

    public static ITester<BlockCoords> createBlockClassTester(Class<? extends Block> cls) {
        return o -> cls.isInstance(o.blockState.func_177230_c()) ? ITester.Result.ACCEPT : ITester.Result.CONTINUE;
    }

    public void initTesters() {
        MinecraftForge.EVENT_BUS.post((Event)new EntityRegisterEvent(this.entityWhitelist));
        this.entityWhitelist.addTester((ITester)new ObjectTester.ClassTester(EntityItem.class));
        this.entityWhitelist.addTester((ITester)new ObjectTester.ClassTester(EntityBoat.class));
        this.entityWhitelist.addTester((ITester)new ObjectTester.ClassTester(EntityMinecart.class));
        ImmutableSet<ResourceLocation> allowedEntityLocations = MagnetWhitelists.toResourceLocationSet(Config.magnetEntityWhitelist);
        this.entityWhitelist.addTester(e -> allowedEntityLocations.contains(EntityList.func_191301_a((Entity)e)) ? ITester.Result.ACCEPT : ITester.Result.CONTINUE);
        MinecraftForge.EVENT_BUS.post((Event)new BlockRegisterEvent(this.blockWhitelist));
        this.blockWhitelist.addTester(o -> {
            float hardness = o.blockState.func_185887_b(o.world, (BlockPos)o);
            return hardness < 0.0f ? ITester.Result.REJECT : ITester.Result.CONTINUE;
        });
        this.blockWhitelist.addTester(o -> o.blockState.func_185901_i() == EnumBlockRenderType.MODEL ? ITester.Result.ACCEPT : ITester.Result.CONTINUE);
        this.blockWhitelist.addTester(MagnetWhitelists.createBlockClassTester(BlockSand.class));
        this.blockWhitelist.addTester(MagnetWhitelists.createBlockClassTester(BlockStairs.class));
        this.blockWhitelist.addTester(MagnetWhitelists.createBlockClassTester(BlockFence.class));
        this.blockWhitelist.addTester(MagnetWhitelists.createBlockClassTester(BlockFenceGate.class));
        this.blockWhitelist.addTester(MagnetWhitelists.createBlockIdentityTester((Block)Blocks.field_150434_aF));
        ImmutableSet<ResourceLocation> allowedBlockLocations = MagnetWhitelists.toResourceLocationSet(Config.magnetBlockWhitelist);
        this.blockWhitelist.addTester(e -> allowedBlockLocations.contains(Block.field_149771_c.func_177774_c((Object)e.blockState.func_177230_c())) ? ITester.Result.ACCEPT : ITester.Result.CONTINUE);
        MinecraftForge.EVENT_BUS.post((Event)new TileEntityRegisterEvent(this.tileEntityWhitelist));
        this.tileEntityWhitelist.addTester((ITester)new ObjectTester.ClassTester(TileEntityBeacon.class)).addTester((ITester)new ObjectTester.ClassTester(TileEntityBrewingStand.class)).addTester((ITester)new ObjectTester.ClassTester(TileEntityChest.class)).addTester((ITester)new ObjectTester.ClassTester(TileEntityCommandBlock.class)).addTester((ITester)new ObjectTester.ClassTester(TileEntityDispenser.class)).addTester((ITester)new ObjectTester.ClassTester(TileEntityEnchantmentTable.class)).addTester((ITester)new ObjectTester.ClassTester(TileEntityEnderChest.class)).addTester((ITester)new ObjectTester.ClassTester(TileEntityFurnace.class)).addTester((ITester)new ObjectTester.ClassTester(TileEntityHopper.class)).addTester((ITester)new ObjectTester.ClassTester(TileEntityNote.class)).addTester((ITester)new ObjectTester.ClassTester(BlockJukebox.TileEntityJukebox.class));
        ImmutableSet<ResourceLocation> allowedTileEntityLocations = MagnetWhitelists.toResourceLocationSet(Config.magnetTileEntityWhitelist);
        this.tileEntityWhitelist.addTester(e -> allowedTileEntityLocations.contains(TileEntity.func_190559_a(e.getClass())) ? ITester.Result.ACCEPT : ITester.Result.CONTINUE);
    }

    private static ImmutableSet<ResourceLocation> toResourceLocationSet(String[] names) {
        return (ImmutableSet)Arrays.asList(names).stream().map(ResourceLocation::new).collect(ImmutableSet.toImmutableSet());
    }

    public boolean testBlock(World world, BlockPos pos) {
        IBlockState blockState = world.func_180495_p(pos);
        Block block = blockState.func_177230_c();
        if (blockState.func_177230_c().isAir(blockState, (IBlockAccess)world, pos)) {
            return false;
        }
        if (block instanceof BlockContainer) {
            TileEntity te = world.func_175625_s(pos);
            return te != null ? this.tileEntityWhitelist.check((Object)te) : false;
        }
        return this.blockWhitelist.check((Object)new BlockCoords(blockState, world, (Vec3i)pos));
    }

    public static class TileEntityRegisterEvent
    extends WhitelistRegisterEvent<TileEntity> {
        protected TileEntityRegisterEvent(ObjectTester<TileEntity> tester) {
            super(tester);
        }
    }

    public static class BlockRegisterEvent
    extends WhitelistRegisterEvent<BlockCoords> {
        protected BlockRegisterEvent(ObjectTester<BlockCoords> tester) {
            super(tester);
        }
    }

    public static class EntityRegisterEvent
    extends WhitelistRegisterEvent<Entity> {
        protected EntityRegisterEvent(ObjectTester<Entity> tester) {
            super(tester);
        }
    }

    public static class WhitelistRegisterEvent<T>
    extends Event {
        protected final ObjectTester<T> tester;

        protected WhitelistRegisterEvent(ObjectTester<T> tester) {
            this.tester = tester;
        }

        public void addClass(Class<? extends T> cls) {
            this.tester.addTester((ITester)new ObjectTester.ClassTester(cls));
        }

        public void addClassNames(Class<? extends T> ... cls) {
            this.tester.addTester((ITester)new ObjectTester.ClassNameTester().addClasses((Class[])cls));
        }

        public void addClassNames(String ... names) {
            this.tester.addTester((ITester)new ObjectTester.ClassNameTester().addClasses(names));
        }
    }

    public static class BlockCoords
    extends BlockPos {
        public final IBlockState blockState;
        public final World world;

        BlockCoords(IBlockState blockState, World world, Vec3i pos) {
            super(pos);
            this.blockState = blockState;
            this.world = world;
        }
    }
}

