/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.powertools.machine.capbank;

import com.enderio.core.common.util.NullHelper;
import crazypants.enderio.api.capacitor.ICapacitorData;
import crazypants.enderio.base.Log;
import crazypants.enderio.base.TileEntityEio;
import crazypants.enderio.base.capacitor.DefaultCapacitorData;
import crazypants.enderio.base.conduit.ConduitUtil;
import crazypants.enderio.base.conduit.IConduitBundle;
import crazypants.enderio.base.config.config.DiagnosticsConfig;
import crazypants.enderio.base.machine.gui.IPowerBarData;
import crazypants.enderio.base.machine.interfaces.IIoConfigurable;
import crazypants.enderio.base.machine.modes.IoMode;
import crazypants.enderio.base.machine.modes.RedstoneControlMode;
import crazypants.enderio.base.network.PacketHandler;
import crazypants.enderio.base.paint.IPaintable;
import crazypants.enderio.base.power.IPowerInterface;
import crazypants.enderio.base.power.IPowerStorage;
import crazypants.enderio.base.power.PowerHandlerUtil;
import crazypants.enderio.base.power.forge.tile.ILegacyPoweredTile;
import crazypants.enderio.base.power.forge.tile.InternalRecieverTileWrapper;
import crazypants.enderio.powertools.init.PowerToolObject;
import crazypants.enderio.powertools.machine.capbank.CapBankType;
import crazypants.enderio.powertools.machine.capbank.InfoDisplayType;
import crazypants.enderio.powertools.machine.capbank.network.CapBankClientNetwork;
import crazypants.enderio.powertools.machine.capbank.network.ClientNetworkManager;
import crazypants.enderio.powertools.machine.capbank.network.EnergyReceptor;
import crazypants.enderio.powertools.machine.capbank.network.ICapBankNetwork;
import crazypants.enderio.powertools.machine.capbank.network.NetworkUtil;
import crazypants.enderio.powertools.machine.capbank.packet.PacketNetworkIdRequest;
import crazypants.enderio.util.NbtValue;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import info.loenwind.autosave.util.NBTAction;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Storable
public class TileCapBank
extends TileEntityEio
implements ILegacyPoweredTile.Receiver,
IIoConfigurable,
IPowerStorage,
IPaintable.IPaintableTileEntity,
IPowerBarData {
    @Store
    private EnumMap<EnumFacing, IoMode> faceModes;
    @Store
    private EnumMap<EnumFacing, InfoDisplayType> faceDisplayTypes;
    @Store(value={NBTAction.SAVE, NBTAction.CLIENT})
    private int energyStored;
    @Store
    private int maxInput = -1;
    @Store
    private int maxOutput = -1;
    @Store
    @Nonnull
    private RedstoneControlMode inputControlMode = RedstoneControlMode.IGNORE;
    @Store
    @Nonnull
    private RedstoneControlMode outputControlMode = RedstoneControlMode.IGNORE;
    private boolean redstoneStateDirty = true;
    @Nonnull
    private final List<EnergyReceptor> receptors = new ArrayList<EnergyReceptor>();
    private boolean receptorsDirty = true;
    private ICapBankNetwork network;
    private int networkId = -1;
    private int idRequestTimer = 0;
    private boolean displayTypesDirty;
    private boolean revalidateDisplayTypes;
    private int lastComparatorState;

    @Nonnull
    public CapBankType getType() {
        if (!this.func_145830_o()) {
            return CapBankType.VIBRANT;
        }
        return CapBankType.getTypeFromMeta(this.func_145832_p());
    }

    public void onNeighborBlockChange(Block blockId) {
        this.redstoneStateDirty = true;
        this.revalidateDisplayTypes = true;
        this.updateReceptors();
    }

    @SideOnly(value=Side.CLIENT)
    public void setNetworkId(int networkId) {
        this.networkId = networkId;
        if (networkId != -1) {
            ClientNetworkManager.getInstance().addToNetwork(networkId, this);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int getNetworkId() {
        return this.networkId;
    }

    public ICapBankNetwork getNetwork() {
        return this.network;
    }

    public boolean setNetwork(ICapBankNetwork network) {
        this.network = network;
        return true;
    }

    public boolean canConnectTo(@Nonnull TileCapBank cap) {
        CapBankType myType = this.getType();
        return myType.isMultiblock() && myType == cap.getType();
    }

    @Override
    public void onChunkUnload() {
        if (this.network != null) {
            this.network.destroyNetwork();
        }
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        if (this.network != null) {
            this.network.destroyNetwork();
        }
    }

    @Override
    public void doUpdate() {
        int comparatorState;
        if (this.field_145850_b.field_72995_K) {
            if (this.networkId == -1) {
                if (this.idRequestTimer <= 0) {
                    PacketHandler.INSTANCE.sendToServer((IMessage)new PacketNetworkIdRequest(this));
                    this.idRequestTimer = 5;
                } else {
                    --this.idRequestTimer;
                }
            }
            return;
        }
        if (this.network == null) {
            NetworkUtil.ensureValidNetwork(this);
            if (this.network == null) {
                return;
            }
        }
        if (this.redstoneStateDirty) {
            int sig = ConduitUtil.isBlockIndirectlyGettingPoweredIfLoaded(this.field_145850_b, this.func_174877_v());
            boolean recievingSignal = sig > 0;
            this.network.updateRedstoneSignal(this, recievingSignal);
            this.redstoneStateDirty = false;
        }
        if (this.receptorsDirty) {
            this.updateReceptors();
        }
        if (this.revalidateDisplayTypes) {
            this.validateDisplayTypes();
            this.revalidateDisplayTypes = false;
        }
        if (this.displayTypesDirty) {
            this.displayTypesDirty = false;
            IBlockState bs = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_184138_a(this.field_174879_c, bs, bs, 3);
        }
        if (this.lastComparatorState != (comparatorState = this.getComparatorOutput())) {
            this.field_145850_b.func_175666_e(this.func_174877_v(), this.func_145838_q());
            this.lastComparatorState = comparatorState;
        }
    }

    @Override
    @Nonnull
    public IoMode toggleIoModeForFace(@Nullable EnumFacing faceHit) {
        if (faceHit == null) {
            return IoMode.NONE;
        }
        IPowerInterface rec = this.getReceptorForFace(faceHit);
        IoMode curMode = this.getIoMode(faceHit);
        if (curMode == IoMode.PULL) {
            this.setIoMode(faceHit, IoMode.PUSH, true);
            return IoMode.PUSH;
        }
        if (curMode == IoMode.PUSH) {
            this.setIoMode(faceHit, IoMode.DISABLED, true);
            return IoMode.DISABLED;
        }
        if (curMode == IoMode.DISABLED && (rec == null || rec.getProvider() instanceof IConduitBundle)) {
            this.setIoMode(faceHit, IoMode.NONE, true);
            return IoMode.NONE;
        }
        this.setIoMode(faceHit, IoMode.PULL, true);
        return IoMode.PULL;
    }

    @Override
    public boolean supportsMode(@Nullable EnumFacing faceHit, @Nullable IoMode mode) {
        if (faceHit == null || mode == null) {
            return false;
        }
        IPowerInterface rec = this.getReceptorForFace(faceHit);
        if (mode == IoMode.NONE) {
            return rec == null || rec.getProvider() instanceof IConduitBundle;
        }
        return true;
    }

    @Override
    public void setIoMode(@Nullable EnumFacing faceHit, @Nullable IoMode mode) {
        if (faceHit != null && mode != null) {
            this.setIoMode(faceHit, mode, true);
        }
    }

    public void setIoMode(@Nonnull EnumFacing faceHit, @Nonnull IoMode mode, boolean updateReceptors) {
        if (mode == IoMode.NONE) {
            if (this.faceModes == null) {
                return;
            }
            this.faceModes.remove(faceHit);
            if (this.faceModes.isEmpty()) {
                this.faceModes = null;
            }
        } else {
            if (this.faceModes == null) {
                this.faceModes = new EnumMap(EnumFacing.class);
            }
            this.faceModes.put(faceHit, mode);
        }
        this.func_70296_d();
        if (updateReceptors) {
            this.validateModeForReceptor(faceHit);
            this.receptorsDirty = true;
        }
        if (this.func_145830_o()) {
            IBlockState bs = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_184138_a(this.field_174879_c, bs, bs, 3);
            this.field_145850_b.func_175685_c(this.field_174879_c, this.func_145838_q(), true);
        }
    }

    public void setDefaultIoMode(@Nonnull EnumFacing faceHit) {
        EnergyReceptor er = this.getEnergyReceptorForFace(faceHit);
        if (er == null || er.getConduit() != null) {
            this.setIoMode(faceHit, IoMode.NONE);
        } else if (er.getReceptor().canReceive()) {
            this.setIoMode(faceHit, IoMode.PUSH);
        } else {
            this.setIoMode(faceHit, IoMode.PULL);
        }
    }

    @Override
    public void clearAllIoModes() {
        if (this.network != null) {
            for (TileCapBank cb : this.network.getMembers()) {
                cb.doClearAllIoModes();
            }
        } else {
            this.doClearAllIoModes();
        }
    }

    private void doClearAllIoModes() {
        for (EnumFacing dir : EnumFacing.values()) {
            this.setDefaultIoMode((EnumFacing)NullHelper.notnullJ((Object)dir, (String)"Enum.values()"));
        }
    }

    @Override
    @Nonnull
    public IoMode getIoMode(@Nullable EnumFacing face) {
        if (this.faceModes == null) {
            return IoMode.NONE;
        }
        IoMode res = this.faceModes.get(face);
        if (res == null) {
            return IoMode.NONE;
        }
        return res;
    }

    public boolean hasDisplayTypes() {
        return this.faceDisplayTypes != null && !this.faceDisplayTypes.isEmpty();
    }

    @Nonnull
    public InfoDisplayType getDisplayType(EnumFacing face) {
        if (this.faceDisplayTypes == null) {
            return InfoDisplayType.NONE;
        }
        InfoDisplayType res = this.faceDisplayTypes.get(face);
        return res == null ? InfoDisplayType.NONE : res;
    }

    public void setDisplayType(EnumFacing face, InfoDisplayType type) {
        this.setDisplayType(face, type, true);
    }

    public void setDisplayType(EnumFacing face, InfoDisplayType type, boolean markDirty) {
        if (type == null) {
            type = InfoDisplayType.NONE;
        }
        if (this.faceDisplayTypes == null && type == InfoDisplayType.NONE) {
            return;
        }
        InfoDisplayType cur = this.getDisplayType(face);
        if (cur == type) {
            return;
        }
        if (this.faceDisplayTypes == null) {
            this.faceDisplayTypes = new EnumMap(EnumFacing.class);
        }
        if (type == InfoDisplayType.NONE) {
            this.faceDisplayTypes.remove(face);
        } else {
            this.faceDisplayTypes.put(face, type);
        }
        if (this.faceDisplayTypes.isEmpty()) {
            this.faceDisplayTypes = null;
        }
        if (markDirty) {
            this.displayTypesDirty = true;
            this.func_70296_d();
        }
        this.invalidateDisplayInfoCache();
    }

    public void validateDisplayTypes() {
        if (this.faceDisplayTypes == null) {
            return;
        }
        ArrayList<EnumFacing> reset = new ArrayList<EnumFacing>();
        for (Map.Entry<EnumFacing, InfoDisplayType> entry : this.faceDisplayTypes.entrySet()) {
            IBlockState bs = this.field_145850_b.func_180495_p(this.func_174877_v().func_177972_a((EnumFacing)NullHelper.notnullJ((Object)entry.getKey(), (String)"EnumMap.getKey()")));
            if (!bs.func_185914_p() && bs.func_177230_c() != PowerToolObject.block_cap_bank.getBlock()) continue;
            reset.add(entry.getKey());
        }
        for (EnumFacing dir : reset) {
            this.setDisplayType(dir, InfoDisplayType.NONE);
            this.setDefaultIoMode((EnumFacing)NullHelper.notnullJ((Object)dir, (String)"Enum.values()"));
        }
    }

    private void invalidateDisplayInfoCache() {
        if (this.network != null) {
            this.network.invalidateDisplayInfoCache();
        }
    }

    public boolean shouldRenderInPass(int pass) {
        if (this.faceDisplayTypes == null) {
            return false;
        }
        return pass == 0;
    }

    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public AxisAlignedBB getRenderBoundingBox() {
        if (!this.getType().isMultiblock() || !(this.network instanceof CapBankClientNetwork)) {
            return super.getRenderBoundingBox();
        }
        int xCoord = this.func_174877_v().func_177958_n();
        int yCoord = this.func_174877_v().func_177956_o();
        int zCoord = this.func_174877_v().func_177952_p();
        int minX = xCoord;
        int minY = yCoord;
        int minZ = zCoord;
        int maxX = minX + 1;
        int maxY = minY + 1;
        int maxZ = minZ + 1;
        if (this.faceDisplayTypes != null) {
            CapBankClientNetwork.IOInfo info;
            CapBankClientNetwork cn = (CapBankClientNetwork)this.network;
            if (this.faceDisplayTypes.get(EnumFacing.NORTH) == InfoDisplayType.IO) {
                info = cn.getIODisplayInfo(xCoord, yCoord, zCoord, EnumFacing.NORTH);
                maxX = Math.max(maxX, xCoord + info.width);
                minY = Math.min(minY, yCoord + 1 - info.height);
            }
            if (this.faceDisplayTypes.get(EnumFacing.SOUTH) == InfoDisplayType.IO) {
                info = cn.getIODisplayInfo(xCoord, yCoord, zCoord, EnumFacing.SOUTH);
                minX = Math.min(minX, xCoord + 1 - info.width);
                minY = Math.min(minY, yCoord + 1 - info.height);
            }
            if (this.faceDisplayTypes.get(EnumFacing.EAST) == InfoDisplayType.IO) {
                info = cn.getIODisplayInfo(xCoord, yCoord, zCoord, EnumFacing.EAST);
                maxZ = Math.max(maxZ, zCoord + info.width);
                minY = Math.min(minY, yCoord + 1 - info.height);
            }
            if (this.faceDisplayTypes.get(EnumFacing.WEST) == InfoDisplayType.IO) {
                info = cn.getIODisplayInfo(xCoord, yCoord, zCoord, EnumFacing.WEST);
                minZ = Math.min(minZ, zCoord + 1 - info.width);
                minY = Math.min(minY, yCoord + 1 - info.height);
            }
        }
        return new AxisAlignedBB((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
    }

    @Nonnull
    public RedstoneControlMode getInputControlMode() {
        return this.inputControlMode;
    }

    public void setInputControlMode(@Nonnull RedstoneControlMode inputControlMode) {
        this.inputControlMode = inputControlMode;
        this.func_70296_d();
    }

    @Nonnull
    public RedstoneControlMode getOutputControlMode() {
        return this.outputControlMode;
    }

    public void setOutputControlMode(@Nonnull RedstoneControlMode outputControlMode) {
        this.outputControlMode = outputControlMode;
        this.func_70296_d();
    }

    @Override
    public IPowerStorage getController() {
        return this.network;
    }

    @Override
    public long getEnergyStoredL() {
        if (this.network == null) {
            return this.getEnergyStored();
        }
        return this.network.getEnergyStoredL();
    }

    @Override
    public long getMaxEnergyStoredL() {
        if (this.network == null) {
            return this.getMaxEnergyStored();
        }
        return this.network.getMaxEnergyStoredL();
    }

    @Override
    public int getAverageIOPerTick() {
        return this.network == null ? 0 : this.network.getAverageIOPerTick();
    }

    @Override
    public boolean isOutputEnabled(@Nonnull EnumFacing direction) {
        IoMode mode = this.getIoMode(direction);
        return (mode == IoMode.PUSH || mode == IoMode.NONE) && this.isOutputEnabled();
    }

    private boolean isOutputEnabled() {
        if (this.network == null) {
            return true;
        }
        return this.network.isOutputEnabled();
    }

    @Override
    public boolean isInputEnabled(@Nonnull EnumFacing direction) {
        IoMode mode = this.getIoMode(direction);
        return (mode == IoMode.PULL || mode == IoMode.NONE) && this.isInputEnabled();
    }

    private boolean isInputEnabled() {
        if (this.network == null) {
            return true;
        }
        return this.network.isInputEnabled();
    }

    @Override
    public boolean isNetworkControlledIo(@Nonnull EnumFacing direction) {
        IoMode mode = this.getIoMode(direction);
        return mode == IoMode.NONE || mode == IoMode.PULL;
    }

    @Override
    public boolean isCreative() {
        return this.getType().isCreative();
    }

    @Nonnull
    public List<EnergyReceptor> getReceptors() {
        if (this.receptorsDirty) {
            this.updateReceptors();
        }
        return this.receptors;
    }

    private void updateReceptors() {
        if (this.network == null) {
            return;
        }
        this.network.removeReceptors(this.receptors);
        this.receptors.clear();
        for (EnumFacing dir : EnumFacing.values()) {
            IoMode ioMode;
            IPowerInterface pi = this.getReceptorForFace((EnumFacing)NullHelper.notnullJ((Object)dir, (String)"Enum.values()"));
            if (pi == null || (ioMode = this.getIoMode((EnumFacing)NullHelper.notnullJ((Object)dir, (String)"Enum.values()"))) == IoMode.DISABLED || ioMode == IoMode.PULL) continue;
            EnergyReceptor er = new EnergyReceptor(this, pi, (EnumFacing)NullHelper.notnullJ((Object)dir, (String)"Enum.values()"));
            this.validateModeForReceptor(er);
            this.receptors.add(er);
        }
        this.network.addReceptors(this.receptors);
        this.receptorsDirty = false;
    }

    private IPowerInterface getReceptorForFace(@Nonnull EnumFacing faceHit) {
        TileEntity te = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(faceHit));
        if (!(te instanceof TileCapBank)) {
            return PowerHandlerUtil.getPowerInterface((ICapabilityProvider)te, faceHit.func_176734_d());
        }
        TileCapBank other = (TileCapBank)te;
        if (other.getType() != this.getType()) {
            return PowerHandlerUtil.getPowerInterface((ICapabilityProvider)te, faceHit.func_176734_d());
        }
        return null;
    }

    private EnergyReceptor getEnergyReceptorForFace(@Nonnull EnumFacing dir) {
        IPowerInterface pi = this.getReceptorForFace(dir);
        if (pi == null || pi.getProvider() instanceof TileCapBank) {
            return null;
        }
        return new EnergyReceptor(this, pi, dir);
    }

    private void validateModeForReceptor(@Nonnull EnumFacing dir) {
        this.validateModeForReceptor(this.getEnergyReceptorForFace(dir));
    }

    private void validateModeForReceptor(EnergyReceptor er) {
        if (er == null) {
            return;
        }
    }

    @Override
    public void addEnergy(int energy) {
        if (this.network == null) {
            this.setEnergyStored(this.getEnergyStored() + energy);
        } else {
            this.network.addEnergy(energy);
        }
    }

    @Override
    public void setEnergyStored(int stored) {
        this.energyStored = MathHelper.func_76125_a((int)stored, (int)0, (int)this.getMaxEnergyStored());
        this.func_70296_d();
    }

    @Override
    public int getEnergyStored() {
        return this.energyStored;
    }

    @Override
    public int getMaxEnergyStored() {
        return this.getType().getMaxEnergyStored();
    }

    @Override
    public int getMaxEnergyRecieved(EnumFacing dir) {
        return this.getMaxInput();
    }

    @Override
    public int getMaxInput() {
        if (this.network == null) {
            return this.getType().getMaxIO();
        }
        return this.network.getMaxInput();
    }

    public void setMaxInput(int maxInput) {
        if (this.maxInput == maxInput) {
            return;
        }
        if (((Boolean)DiagnosticsConfig.debugTraceCapLimitsExtremelyDetailed.get()).booleanValue()) {
            StringBuilder sb = new StringBuilder("CapBank ").append(this).append(" input changed from ").append(this.maxInput).append(" to ").append(maxInput);
            for (StackTraceElement elem : new Exception("Stackstrace").getStackTrace()) {
                sb.append(" at ").append(elem);
            }
            Log.warn(sb);
        }
        this.maxInput = maxInput;
        this.func_70296_d();
    }

    public int getMaxInputOverride() {
        return this.maxInput;
    }

    @Override
    public int getMaxOutput() {
        if (this.network == null) {
            return this.getType().getMaxIO();
        }
        return this.network.getMaxOutput();
    }

    public void setMaxOutput(int maxOutput) {
        if (this.maxOutput == maxOutput) {
            return;
        }
        if (((Boolean)DiagnosticsConfig.debugTraceCapLimitsExtremelyDetailed.get()).booleanValue()) {
            StringBuilder sb = new StringBuilder("CapBank ").append(this).append(" output changed from ").append(this.maxOutput).append(" to ").append(maxOutput);
            for (StackTraceElement elem : new Exception("Stackstrace").getStackTrace()) {
                sb.append(" at ").append(elem);
            }
            Log.warn(sb);
        }
        this.maxOutput = maxOutput;
        this.func_70296_d();
    }

    public int getMaxOutputOverride() {
        return this.maxOutput;
    }

    @Override
    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        if (this.network == null || from == null) {
            return 0;
        }
        IoMode mode = this.getIoMode(from);
        if (mode == IoMode.DISABLED || mode == IoMode.PUSH) {
            return 0;
        }
        return this.network.receiveEnergy(maxReceive, simulate);
    }

    @Override
    public boolean canConnectEnergy(@Nonnull EnumFacing from) {
        return this.getIoMode(from) != IoMode.DISABLED;
    }

    public int getComparatorOutput() {
        double stored = this.getEnergyStored();
        return stored == 0.0 ? 0 : (int)(1.0 + stored / (double)this.getMaxEnergyStored() * 14.0);
    }

    @Override
    public boolean displayPower() {
        return true;
    }

    @Override
    public void readCustomNBT(@Nonnull ItemStack stack) {
        super.readCustomNBT(stack);
        this.energyStored = NbtValue.ENERGY.getInt(stack);
    }

    @Override
    public void writeCustomNBT(@Nonnull ItemStack stack) {
        super.writeCustomNBT(stack);
        NbtValue.ENERGY.setInt(stack, this.energyStored);
    }

    @Override
    @Nonnull
    public BlockPos getLocation() {
        return this.func_174877_v();
    }

    @Override
    @Nonnull
    public ICapacitorData getCapacitorData() {
        return DefaultCapacitorData.BASIC_CAPACITOR;
    }

    @Override
    public int getMaxUsage() {
        return 0;
    }

    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facingIn) {
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)CapabilityEnergy.ENERGY.cast((Object)InternalRecieverTileWrapper.get(this, facingIn));
        }
        return (T)super.getCapability(capability, facingIn);
    }
}

