/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.machine.vacuum.xp;

import com.enderio.core.api.client.gui.IGuiScreen;
import com.enderio.core.api.client.render.IWidgetIcon;
import com.enderio.core.client.gui.button.MultiIconButton;
import com.enderio.core.client.gui.button.ToggleButton;
import com.enderio.core.client.gui.widget.GuiToolTip;
import com.enderio.core.client.render.ColorUtil;
import com.enderio.core.client.render.EnderWidget;
import com.enderio.core.client.render.RenderUtil;
import com.google.common.collect.Lists;
import crazypants.enderio.base.fluid.Fluids;
import crazypants.enderio.base.gui.GuiContainerBaseEIO;
import crazypants.enderio.base.gui.IconEIO;
import crazypants.enderio.machines.lang.Lang;
import crazypants.enderio.machines.machine.vacuum.xp.IVacuumRangeRemoteExec;
import crazypants.enderio.machines.machine.vacuum.xp.TileXPVacuum;
import java.awt.Color;
import java.awt.Rectangle;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class GuiXPVacuum
extends GuiContainerBaseEIO
implements IVacuumRangeRemoteExec.GUI {
    private static final int RANGE_LEFT = 123;
    private static final int RANGE_TOP = 32;
    private static final int RANGE_WIDTH = 16;
    private static final int ID_RANGE_UP = 4611;
    private static final int ID_RANGE_DOWN = 4612;
    private static final int ID_SHOW_RANGE = 4613;
    @Nonnull
    private final ToggleButton showRangeB;
    @Nonnull
    private final GuiToolTip rangeTooltip;
    @Nonnull
    private final GuiToolTip primeTooltip;
    @Nonnull
    private final MultiIconButton rangeUpB;
    @Nonnull
    private final MultiIconButton rangeDownB;
    @Nonnull
    private final String headerRange;
    @Nonnull
    private final String headerXPVacuum;
    @Nonnull
    private final TileXPVacuum te;

    public GuiXPVacuum(@Nonnull Container container, @Nonnull TileXPVacuum te) {
        super(container, "xp_vacuum");
        this.te = te;
        this.field_147000_g = 152;
        this.field_146999_f = 176;
        int x = 123;
        int y = 32;
        this.rangeTooltip = new GuiToolTip(new Rectangle(x, y, 16, 16), new String[]{Lang.GUI_VACUUM_RANGE_TOOLTIP.get()});
        this.primeTooltip = new GuiToolTip(new Rectangle(27, 22, 32, 32), new String[]{Lang.GUI_VACUUM_PRIME_TOOLTIP.get()});
        this.rangeUpB = MultiIconButton.createAddButton((IGuiScreen)this, (int)4611, (int)(x += 16), (int)y);
        this.rangeDownB = MultiIconButton.createMinusButton((IGuiScreen)this, (int)4612, (int)x, (int)(y += 8));
        this.showRangeB = new ToggleButton((IGuiScreen)this, 4613, x + 10, y - 8, (IWidgetIcon)IconEIO.SHOW_RANGE, (IWidgetIcon)IconEIO.HIDE_RANGE);
        this.showRangeB.setSize(16, 16);
        this.addToolTip(new GuiToolTip(this.showRangeB.getBounds(), new String[]{"null"}){

            @Nonnull
            public List<String> getToolTipText() {
                return Lists.newArrayList((Object[])new String[]{(GuiXPVacuum.this.showRangeB.isSelected() ? Lang.GUI_HIDE_RANGE : Lang.GUI_SHOW_RANGE).get()});
            }
        });
        this.headerRange = Lang.GUI_VACUUM_RANGE.get();
        this.headerXPVacuum = Lang.GUI_VACUUM_XP_HEADER.get();
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.rangeUpB.onGuiInit();
        this.rangeDownB.onGuiInit();
        this.addToolTip(this.rangeTooltip);
        if (!this.te.isFormed()) {
            this.addToolTip(this.primeTooltip);
        }
        this.showRangeB.onGuiInit();
        this.showRangeB.setSelected(this.te.isShowingRange());
    }

    public void func_146284_a(@Nonnull GuiButton guiButton) {
        switch (guiButton.field_146127_k) {
            case 4611: {
                this.doSetVacuumRange((int)(this.te.getRange() + 1.0f));
                break;
            }
            case 4612: {
                this.doSetVacuumRange((int)(this.te.getRange() - 1.0f));
                break;
            }
            case 4613: {
                this.te.setShowRange(this.showRangeB.isSelected());
            }
        }
    }

    protected void func_146976_a(float par1, int par2, int par3) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.bindGuiTexture();
        int sx = (this.field_146294_l - this.field_146999_f) / 2;
        int sy = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(sx, sy, 0, 0, this.field_146999_f, this.field_147000_g);
        FontRenderer fr = this.getFontRenderer();
        fr.func_78276_b(this.headerRange, sx + this.field_146999_f - 11 - fr.func_78256_a(this.headerRange), sy + 19, ColorUtil.getRGB((Color)Color.DARK_GRAY));
        fr.func_78276_b(this.headerXPVacuum, this.getGuiLeft() + 20, this.getGuiTop() + 6, ColorUtil.getRGB((Color)Color.DARK_GRAY));
        IconEIO.map.render((IWidgetIcon)EnderWidget.BUTTON_DOWN, (double)(sx + 123), (double)(sy + 32), 16.0, 16.0, 0.0, true);
        String str = Integer.toString((int)this.te.getRange());
        int sw = fr.func_78256_a(str);
        fr.func_78276_b(str, sx + 123 + 16 - sw - 5, sy + 32 + 5, ColorUtil.getRGB((Color)Color.black));
        if (this.te.isFormed()) {
            this.renderFluid(new FluidStack(Fluids.XP_JUICE.getFluid(), 1), this.getGuiLeft() + 26, this.getGuiTop() + 21);
        }
        super.func_146976_a(par1, par2, par3);
    }

    private void renderFluid(FluidStack f, int x, int y) {
        ResourceLocation iconKey = f.getFluid().getStill();
        TextureAtlasSprite icon = Minecraft.func_71410_x().func_147117_R().getTextureExtry(iconKey.toString());
        if (icon != null) {
            RenderUtil.renderGuiTank((FluidStack)f, (int)1000, (int)1000, (double)(x + 1), (double)(y + 1), (double)0.0, (double)32.0, (double)32.0);
        }
    }
}

