/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.machine.generator.stirling;

import com.enderio.core.api.common.util.IProgressTile;
import crazypants.enderio.api.capacitor.ICapacitorData;
import crazypants.enderio.api.capacitor.ICapacitorKey;
import crazypants.enderio.base.machine.baselegacy.AbstractGeneratorEntity;
import crazypants.enderio.base.machine.baselegacy.SlotDefinition;
import crazypants.enderio.base.paint.IPaintable;
import crazypants.enderio.base.power.PowerDistributor;
import crazypants.enderio.machines.capability.LegacyStirlingWrapper;
import crazypants.enderio.machines.capacitor.CapacitorKey;
import crazypants.enderio.machines.init.MachineObject;
import crazypants.enderio.machines.machine.generator.stirling.PacketBurnTime;
import crazypants.enderio.machines.network.PacketHandler;
import crazypants.enderio.util.Prep;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;

@Storable
public class TileStirlingGenerator
extends AbstractGeneratorEntity
implements IProgressTile,
IPaintable.IPaintableTileEntity {
    @Nonnull
    private static final ResourceLocation SOUND = new ResourceLocation("enderio", "generator.stirling");
    @Store
    public int burnTime = 0;
    @Store
    public int totalBurnTime;
    @Store
    public boolean isLavaFired;
    private PowerDistributor powerDis;

    public TileStirlingGenerator() {
        super(new SlotDefinition(1, 0, 1), CapacitorKey.STIRLING_POWER_BUFFER, CapacitorKey.STIRLING_POWER_GEN);
        this.setEnergyLoss(CapacitorKey.STIRLING_POWER_LOSS);
    }

    protected TileStirlingGenerator(@Nonnull SlotDefinition slotDefinition, @Nonnull ICapacitorKey maxEnergyStored, @Nonnull ICapacitorKey maxEnergyUsed) {
        super(slotDefinition, maxEnergyStored, maxEnergyUsed);
    }

    @Override
    @Nonnull
    public String getMachineName() {
        return MachineObject.block_stirling_generator.getUnlocalisedName();
    }

    @Override
    public boolean isMachineItemValidForSlot(int i, @Nonnull ItemStack itemstack) {
        return TileEntityFurnace.func_145954_b((ItemStack)itemstack);
    }

    @Override
    public boolean isActive() {
        return this.burnTime > 0;
    }

    public float getProgress() {
        if (this.burnTime <= 0) {
            return -1.0f;
        }
        return (float)this.burnTime / (float)this.totalBurnTime;
    }

    public void setProgress(float progress) {
        this.burnTime = (int)((float)this.totalBurnTime * progress);
    }

    @Nonnull
    public TileEntity getTileEntity() {
        return this;
    }

    @Override
    public ResourceLocation getSound() {
        return SOUND;
    }

    @Override
    public void onNeighborBlockChange(@Nonnull IBlockState state, @Nonnull World worldIn, @Nonnull BlockPos posIn, @Nonnull Block blockIn, @Nonnull BlockPos fromPos) {
        super.onNeighborBlockChange(state, worldIn, posIn, blockIn, fromPos);
        if (this.powerDis != null) {
            this.powerDis.neighboursChanged();
        }
    }

    public static int getBurnTimeGeneric(@Nonnull ItemStack item) {
        return TileEntityFurnace.func_145952_a((ItemStack)item);
    }

    public static int getBurnTime(@Nonnull ItemStack item, @Nonnull ICapacitorKey maxUsage, @Nonnull ICapacitorData data) {
        float base = (float)TileStirlingGenerator.getBurnTimeGeneric(item) / ((float)maxUsage.get(data) / maxUsage.getDefaultFloat()) * TileStirlingGenerator.getBurnEfficiency(data);
        if (item.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) {
            base /= 5.0f;
        }
        return Math.round(base /= maxUsage.getDefaultFloat() / 15.0f);
    }

    public int getBurnTime(@Nonnull ItemStack item) {
        return TileStirlingGenerator.getBurnTime(item, this.maxEnergyUsed, this.getCapacitorData());
    }

    @Override
    protected boolean processTasks(boolean redstoneCheck) {
        ItemStack fuelStack;
        boolean needsUpdate = false;
        boolean sendBurnTimePacket = false;
        if (this.burnTime > 0) {
            if (this.getEnergyStored() < this.getMaxEnergyStored()) {
                this.setEnergyStored(this.getEnergyStored() + this.getPowerUsePerTick());
            }
            --this.burnTime;
            sendBurnTimePacket = this.shouldDoWorkThisTick(20, -1) || this.burnTime == 0;
        }
        this.transmitEnergy();
        if (redstoneCheck && this.burnTime <= 0 && this.getEnergyStored() < this.getMaxEnergyStored() && (fuelStack = this.inventory[0]) != null && Prep.isValid(fuelStack)) {
            this.burnTime = this.getBurnTime(fuelStack);
            if (this.burnTime > 0) {
                this.totalBurnTime = this.burnTime;
                this.isLavaFired = fuelStack.func_77973_b() == Items.field_151129_at;
                ItemStack containedItem = fuelStack.func_77973_b().getContainerItem(fuelStack.func_77979_a(1));
                if (Prep.isValid(containedItem)) {
                    if (Prep.isInvalid(fuelStack)) {
                        this.inventory[0] = containedItem;
                    } else {
                        this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, containedItem));
                    }
                }
                this.func_70296_d();
                needsUpdate = true;
            }
        }
        if (!needsUpdate && sendBurnTimePacket) {
            PacketHandler.sendToAllAround((IMessage)new PacketBurnTime(this), (TileEntity)this);
        }
        return needsUpdate;
    }

    public static float getEnergyMultiplier(@Nonnull ICapacitorData capacitorType) {
        return (float)CapacitorKey.STIRLING_POWER_GEN.get(capacitorType) / CapacitorKey.STIRLING_POWER_GEN.getDefaultFloat();
    }

    public static float getBurnEfficiency(@Nullable ICapacitorData data) {
        return data == null ? CapacitorKey.STIRLING_POWER_EFFICIENCY.getDefaultFloat() : CapacitorKey.STIRLING_POWER_EFFICIENCY.getFloat(data);
    }

    public float getBurnEfficiency() {
        return TileStirlingGenerator.getBurnEfficiency(this.getCapacitorData());
    }

    private boolean transmitEnergy() {
        int canTransmit;
        if (this.powerDis == null) {
            this.powerDis = new PowerDistributor(this.func_174877_v());
        }
        if ((canTransmit = Math.min(this.getEnergyStored(), this.getPowerUsePerTick() * 2)) <= 0) {
            return false;
        }
        int transmitted = this.powerDis.transmitEnergy(this.field_145850_b, canTransmit);
        this.setEnergyStored(this.getEnergyStored() - transmitted);
        return transmitted > 0;
    }

    @Override
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing1) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && facing1 != null) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)new LegacyStirlingWrapper(this, facing1));
        }
        return super.getCapability(capability, facing1);
    }

    @Override
    protected boolean hasStuffToPush() {
        ItemStack itemStack = this.inventory[0];
        return itemStack != null && Prep.isValid(itemStack) && !TileEntityFurnace.func_145954_b((ItemStack)itemStack);
    }

    public static class Simple
    extends TileStirlingGenerator {
        public Simple() {
            super(new SlotDefinition(1, 0, 0), CapacitorKey.SIMPLE_STIRLING_POWER_BUFFER, CapacitorKey.SIMPLE_STIRLING_POWER_GEN);
            this.setEnergyLoss(CapacitorKey.SIMPLE_STIRLING_POWER_LOSS);
        }

        @Override
        public boolean isMachineItemValidForSlot(int i, @Nonnull ItemStack itemstack) {
            return super.isMachineItemValidForSlot(i, itemstack) && Prep.isInvalid(itemstack.func_77973_b().getContainerItem(itemstack));
        }
    }
}

