/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.integration.jei;

import com.enderio.core.common.util.NNList;
import com.enderio.core.common.util.NullHelper;
import crazypants.enderio.base.EnderIO;
import crazypants.enderio.base.recipe.IMachineRecipe;
import crazypants.enderio.base.recipe.MachineRecipeInput;
import crazypants.enderio.base.recipe.MachineRecipeRegistry;
import crazypants.enderio.base.recipe.enchanter.EnchanterRecipe;
import crazypants.enderio.machines.config.config.PersonalConfig;
import crazypants.enderio.machines.init.MachineObject;
import crazypants.enderio.machines.machine.enchanter.ContainerEnchanter;
import crazypants.enderio.machines.machine.enchanter.GuiEnchanter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGuiIngredient;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.BlankRecipeCategory;
import mezz.jei.api.recipe.BlankRecipeWrapper;
import mezz.jei.api.recipe.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;

public class EnchanterRecipeCategory
extends BlankRecipeCategory<EnchanterRecipeWrapper> {
    @Nonnull
    public static final String UID = "Enchanter";
    private int xOff = 15;
    private int yOff = 24;
    @Nonnull
    private final IDrawable background;
    private EnchanterRecipeWrapper currentRecipe;

    public static void register(IModRegistry registry, IGuiHelper guiHelper) {
        if (!((Boolean)PersonalConfig.enableEnchanterJEIRecipes.get()).booleanValue()) {
            return;
        }
        registry.addRecipeCategories(new IRecipeCategory[]{new EnchanterRecipeCategory(guiHelper)});
        registry.handleRecipes(EnchanterRecipe.class, EnchanterRecipeWrapper::new, UID);
        registry.addRecipeClickArea(GuiEnchanter.class, 155, 8, 16, 16, new String[]{UID});
        registry.addRecipeCategoryCraftingItem(new ItemStack(MachineObject.block_enchanter.getBlockNN()), new String[]{UID});
        registry.addRecipes((Collection)NullHelper.notnullJ(MachineRecipeRegistry.instance.getRecipesForMachine("enchanter").values(), (String)"Map.values()"), UID);
        registry.getRecipeTransferRegistry().addRecipeTransferHandler(ContainerEnchanter.class, UID, ContainerEnchanter.FIRST_RECIPE_SLOT, ContainerEnchanter.NUM_RECIPE_SLOT, ContainerEnchanter.FIRST_INVENTORY_SLOT, ContainerEnchanter.NUM_INVENTORY_SLOT);
    }

    public EnchanterRecipeCategory(IGuiHelper guiHelper) {
        ResourceLocation backgroundLocation = EnderIO.proxy.getGuiTexture("enchanter");
        this.background = guiHelper.createDrawable(backgroundLocation, this.xOff, this.yOff, 146, 48);
    }

    @Nonnull
    public String getUid() {
        return UID;
    }

    @Nonnull
    public String getTitle() {
        return MachineObject.block_enchanter.getBlock().func_149732_F();
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull EnchanterRecipeWrapper recipeWrapper, @Nonnull IIngredients ingredients) {
        this.currentRecipe = recipeWrapper;
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        Map ings = guiItemStacks.getGuiIngredients();
        this.currentRecipe.setInfoData(ings);
        guiItemStacks.init(0, true, 16 - this.xOff - 1, 34 - this.yOff);
        guiItemStacks.init(1, true, 65 - this.xOff - 1, 34 - this.yOff);
        guiItemStacks.init(2, true, 85 - this.xOff - 1, 34 - this.yOff);
        guiItemStacks.init(3, false, 144 - this.xOff - 1, 34 - this.yOff);
        guiItemStacks.set(ingredients);
    }

    @Nonnull
    public String getModName() {
        return "enderiomachines";
    }

    public static class EnchanterRecipeWrapper
    extends BlankRecipeWrapper {
        @Nonnull
        private static final ResourceLocation XP_ORB_TEXTURE = new ResourceLocation("textures/entity/experience_orb.png");
        private final EnchanterRecipe rec;
        Map<Integer, ? extends IGuiIngredient<ItemStack>> currentIngredients;

        public EnchanterRecipeWrapper(EnchanterRecipe rec) {
            this.rec = rec;
        }

        public boolean isValid() {
            return this.rec != null;
        }

        public void drawInfo(@Nonnull Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
            Map enchants;
            ItemStack slot3;
            if (this.currentIngredients == null) {
                return;
            }
            IGuiIngredient<ItemStack> in0 = this.currentIngredients.get(0);
            IGuiIngredient<ItemStack> in1 = this.currentIngredients.get(1);
            IGuiIngredient<ItemStack> in2 = this.currentIngredients.get(2);
            IGuiIngredient<ItemStack> out = this.currentIngredients.get(3);
            int enchLvl = 0;
            if (out != null && (slot3 = (ItemStack)out.getDisplayedIngredient()) != null && (enchants = EnchantmentHelper.func_82781_a((ItemStack)slot3)).size() == 1) {
                Map.Entry ench = enchants.entrySet().iterator().next();
                enchLvl = (Integer)ench.getValue();
                String name = ((Enchantment)ench.getKey()).func_77316_c(enchLvl);
                String referenceName = EnchanterRecipeWrapper.getTranslatedName((Enchantment)ench.getKey(), enchLvl);
                if (referenceName.equals(name)) {
                    name = EnchanterRecipeWrapper.getTranslatedNameBase((Enchantment)ench.getKey(), enchLvl);
                    minecraft.field_71466_p.func_78276_b(name, 147 - minecraft.field_71466_p.func_78256_a(name), 0, 0x8B8B8B);
                    name = EnchanterRecipeWrapper.getTranslatedNameLevel((Enchantment)ench.getKey(), enchLvl);
                    minecraft.field_71466_p.func_78276_b(name, 147, 0, 0x8B8B8B);
                } else {
                    minecraft.field_71466_p.func_78276_b(name, 147 - minecraft.field_71466_p.func_78256_a(name), 0, 0x8B8B8B);
                }
            }
            if (in0 != null && in1 != null && in2 != null) {
                int xpCost;
                ItemStack slot0 = (ItemStack)in0.getDisplayedIngredient();
                ItemStack slot1 = (ItemStack)in1.getDisplayedIngredient();
                ItemStack slot2 = (ItemStack)in2.getDisplayedIngredient();
                if (slot0 != null && slot1 != null && slot2 != null && (xpCost = this.rec.getXPCost((NNList<MachineRecipeInput>)new NNList((Object[])new MachineRecipeInput[]{new MachineRecipeInput(0, slot0), new MachineRecipeInput(1, slot1), new MachineRecipeInput(1, slot2)}))) != 0) {
                    minecraft.func_110434_K().func_110577_a(XP_ORB_TEXTURE);
                    GlStateManager.func_179124_c((float)0.5019608f, (float)1.0f, (float)0.1254902f);
                    Gui.func_152125_a((int)-4, (int)26, (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16, (float)64.0f, (float)64.0f);
                    minecraft.field_71466_p.func_78276_b("" + xpCost, 9, 31, 0x404040);
                }
            }
        }

        @Nonnull
        public static String getTranslatedName(Enchantment e, int level) {
            String s = I18n.func_74838_a((String)e.func_77320_a());
            if (e.func_190936_d()) {
                s = TextFormatting.RED + s;
            }
            return level == 1 && e.func_77325_b() == 1 ? s : s + " " + I18n.func_74838_a((String)("enchantment.level." + level));
        }

        @Nonnull
        public static String getTranslatedNameBase(Enchantment e, int level) {
            String s = I18n.func_74838_a((String)e.func_77320_a());
            if (e.func_190936_d()) {
                s = TextFormatting.RED + s;
            }
            return s;
        }

        @Nonnull
        public static String getTranslatedNameLevel(Enchantment e, int level) {
            return level == 1 && e.func_77325_b() == 1 ? "" : " " + I18n.func_74838_a((String)("enchantment.level." + level));
        }

        public void setInfoData(Map<Integer, ? extends IGuiIngredient<ItemStack>> ings) {
            this.currentIngredients = ings;
        }

        public void getIngredients(@Nonnull IIngredients ingredients) {
            ArrayList<ItemStack> bookInputs = new ArrayList<ItemStack>();
            ArrayList<ItemStack> itemInputs = new ArrayList<ItemStack>();
            ArrayList<ItemStack> lapizInputs = new ArrayList<ItemStack>();
            ArrayList<ItemStack> itemOutputs = new ArrayList<ItemStack>();
            NNList<NNList<MachineRecipeInput>> variants = this.rec.getVariants();
            for (NNList variant : variants) {
                for (MachineRecipeInput machineRecipeInput : variant) {
                    if (machineRecipeInput.slotNumber == 0) {
                        bookInputs.add(machineRecipeInput.item);
                        continue;
                    }
                    if (machineRecipeInput.slotNumber == 1) {
                        itemInputs.add(machineRecipeInput.item);
                        continue;
                    }
                    if (machineRecipeInput.slotNumber != 2) continue;
                    lapizInputs.add(machineRecipeInput.item);
                }
                IMachineRecipe.ResultStack[] completedResult = this.rec.getCompletedResult(0L, 1.0f, (NNList<MachineRecipeInput>)((NNList)NullHelper.notnullM((Object)variant, (String)"NNList iterated to null")));
                itemOutputs.add(completedResult[0].item);
            }
            ArrayList<ArrayList<ItemStack>> inputs = new ArrayList<ArrayList<ItemStack>>();
            inputs.add(bookInputs);
            inputs.add(itemInputs);
            inputs.add(lapizInputs);
            ingredients.setInputLists(ItemStack.class, inputs);
            ingredients.setOutputLists(ItemStack.class, (List)NullHelper.notnullJ(Collections.singletonList(itemOutputs), (String)"Collections.singletonList()"));
        }
    }
}

