/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduits.network;

import crazypants.enderio.base.conduit.ConnectionMode;
import crazypants.enderio.base.conduit.IConduit;
import crazypants.enderio.base.conduit.IServerConduit;
import crazypants.enderio.conduits.conduit.redstone.IRedstoneConduit;
import crazypants.enderio.conduits.network.AbstractConduitPacket;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketConnectionMode
extends AbstractConduitPacket<IConduit> {
    private EnumFacing dir;
    private ConnectionMode mode;

    public PacketConnectionMode() {
    }

    public PacketConnectionMode(@Nonnull IConduit con, EnumFacing dir, ConnectionMode mode) {
        super(con);
        this.dir = dir;
        this.mode = mode;
    }

    @Override
    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        if (this.dir != null) {
            buf.writeShort(this.dir.ordinal());
        } else {
            buf.writeShort(-1);
        }
        if (this.mode != null) {
            buf.writeShort(this.mode.ordinal());
        } else {
            buf.writeShort(-1);
        }
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        short ord = buf.readShort();
        this.dir = ord < 0 ? null : EnumFacing.values()[ord];
        short modeOrd = buf.readShort();
        this.mode = modeOrd < 0 ? null : ConnectionMode.values()[modeOrd];
    }

    public static class Handler
    implements IMessageHandler<PacketConnectionMode, IMessage> {
        public IMessage onMessage(PacketConnectionMode message, MessageContext ctx) {
            Object conduit = message.getConduit(ctx);
            if (conduit instanceof IServerConduit) {
                if (conduit instanceof IRedstoneConduit) {
                    ((IRedstoneConduit)conduit).forceConnectionMode(message.dir, message.mode);
                } else if (conduit instanceof IServerConduit) {
                    ((IServerConduit)conduit).setConnectionMode(message.dir, message.mode);
                }
                IBlockState bs = message.getWorld(ctx).func_180495_p(message.getPos());
                message.getWorld(ctx).func_184138_a(message.getPos(), bs, bs, 3);
            }
            return null;
        }
    }
}

