/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.network;

import crazypants.enderio.base.network.PacketHandler;
import crazypants.enderio.util.ClientUtil;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketSpawnParticles
implements IMessage {
    private final List<Data> data = new ArrayList<Data>();

    public static void create(Entity position, EnumParticleTypes ... particles) {
        PacketSpawnParticles.create(position, 5, particles);
    }

    public static void create(Entity position, int count, EnumParticleTypes ... particles) {
        new PacketSpawnParticles().add(position.field_70165_t, position.field_70163_u + (double)position.field_70131_O * 0.8, position.field_70161_v, count, particles).send(position.field_70170_p, new BlockPos(position));
    }

    public static void create(World world, BlockPos position, EnumParticleTypes ... particles) {
        PacketSpawnParticles.create(world, position, 5, particles);
    }

    public static void create(World world, BlockPos position, int count, EnumParticleTypes ... particles) {
        new PacketSpawnParticles().add((double)position.func_177958_n() + 0.5, (double)position.func_177956_o() + 0.5, (double)position.func_177952_p() + 0.5, count, particles).send(world, position);
    }

    public static void create(World world, double posX, double posY, double posZ, int count, EnumParticleTypes ... particles) {
        new PacketSpawnParticles().add(posX, posY, posZ, count, particles).send(world, new BlockPos(posX, posY, posZ));
    }

    public PacketSpawnParticles add(Entity position, int count, EnumParticleTypes ... particles) {
        this.data.add(new Data(position.field_70165_t, position.field_70163_u + (double)position.field_70131_O * 0.8, position.field_70161_v, count, particles));
        return this;
    }

    public PacketSpawnParticles add(BlockPos position, EnumParticleTypes ... particles) {
        return this.add(position, 5, particles);
    }

    public PacketSpawnParticles add(BlockPos position, int count, EnumParticleTypes ... particles) {
        this.data.add(new Data((double)position.func_177958_n() + 0.5, (double)position.func_177956_o() + 0.5, (double)position.func_177952_p() + 0.5, count, particles));
        return this;
    }

    public PacketSpawnParticles add(double posX, double posY, double posZ, int count, EnumParticleTypes ... particles) {
        this.data.add(new Data(posX, posY, posZ, count, particles));
        return this;
    }

    public void send(World world, BlockPos reference) {
        PacketHandler.INSTANCE.sendToAllAround((IMessage)this, reference, world);
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeInt(this.data.size());
        for (Data elem : this.data) {
            elem.toBytes(buffer);
        }
    }

    public void fromBytes(ByteBuf buffer) {
        int count = buffer.readInt();
        for (int i = 0; i < count; ++i) {
            this.data.add(new Data(buffer));
        }
    }

    public static class Handler
    implements IMessageHandler<PacketSpawnParticles, IMessage> {
        public IMessage onMessage(PacketSpawnParticles message, MessageContext ctx) {
            for (Data data : message.data) {
                for (EnumParticleTypes particle : data.particles) {
                    if (particle == null) continue;
                    ClientUtil.spawnParcticles(data.posX, data.posY, data.posZ, data.count, particle);
                }
            }
            return null;
        }
    }

    public static class Data {
        final double posX;
        final double posY;
        final double posZ;
        final List<EnumParticleTypes> particles;
        final int count;

        public Data(double posX, double posY, double posZ, int count, EnumParticleTypes ... particles) {
            this.posX = posX;
            this.posY = posY;
            this.posZ = posZ;
            this.particles = Arrays.asList(particles);
            this.count = count;
        }

        Data(ByteBuf buffer) {
            this.posX = buffer.readFloat();
            this.posY = buffer.readFloat();
            this.posZ = buffer.readFloat();
            this.count = buffer.readByte();
            int size = buffer.readByte();
            this.particles = new ArrayList<EnumParticleTypes>(size);
            for (int i = 0; i < size; ++i) {
                this.particles.add(EnumParticleTypes.values()[buffer.readByte()]);
            }
        }

        void toBytes(ByteBuf buffer) {
            buffer.writeFloat((float)this.posX);
            buffer.writeFloat((float)this.posY);
            buffer.writeFloat((float)this.posZ);
            buffer.writeByte(this.count);
            int size = this.particles.size();
            buffer.writeByte(size);
            for (EnumParticleTypes particle : this.particles) {
                buffer.writeByte(particle.ordinal());
            }
        }
    }
}

