/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.loot;

import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class EntityLootHelper {
    @Nonnull
    static final Random rand = new Random();

    static ResourceLocation getDeathLootTable(EntityLiving entity) {
        return (ResourceLocation)ReflectionHelper.getPrivateValue(EntityLiving.class, (Object)entity, (String[])new String[]{"field_184659_bA", "deathLootTable"});
    }

    static long getDeathLootTableSeed(EntityLiving entity) {
        return (Long)ReflectionHelper.getPrivateValue(EntityLiving.class, (Object)entity, (String[])new String[]{"field_184653_bB", "deathLootTableSeed"});
    }

    public static void dropLoot(@Nonnull EntityLiving entity, ResourceLocation lootTable, @Nonnull DamageSource source) {
        ResourceLocation resourcelocation = EntityLootHelper.getDeathLootTable(entity);
        if (resourcelocation == null) {
            resourcelocation = lootTable;
        }
        if (resourcelocation != null) {
            long deathLootTableSeed;
            LootTable loottable = entity.field_70170_p.func_184146_ak().func_186521_a(resourcelocation);
            LootContext.Builder builder = new LootContext.Builder((WorldServer)entity.field_70170_p).func_186472_a((Entity)entity).func_186473_a(source);
            Entity trueSource = source.func_76346_g();
            if (trueSource instanceof EntityPlayer) {
                builder = builder.func_186470_a((EntityPlayer)trueSource).func_186469_a((float)ForgeHooks.getLootingLevel((Entity)entity, (Entity)trueSource, (DamageSource)source));
            }
            for (ItemStack itemstack : loottable.func_186462_a((deathLootTableSeed = EntityLootHelper.getDeathLootTableSeed(entity)) == 0L ? rand : new Random(deathLootTableSeed), builder.func_186471_a())) {
                if (itemstack == null) continue;
                entity.func_70099_a(itemstack, 0.0f);
            }
        }
    }
}

