/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.item.travelstaff;

import com.enderio.core.api.client.gui.IAdvancedTooltipProvider;
import com.enderio.core.common.MappedCapabilityProvider;
import com.enderio.core.common.transform.EnderCoreMethods;
import crazypants.enderio.api.IModObject;
import crazypants.enderio.api.capacitor.ICapacitorKey;
import crazypants.enderio.api.teleport.IItemOfTravel;
import crazypants.enderio.api.teleport.TravelSource;
import crazypants.enderio.api.upgrades.IDarkSteelItem;
import crazypants.enderio.api.upgrades.IEquipmentData;
import crazypants.enderio.base.EnderIO;
import crazypants.enderio.base.EnderIOTab;
import crazypants.enderio.base.capacitor.CapacitorKey;
import crazypants.enderio.base.config.config.TeleportConfig;
import crazypants.enderio.base.handler.darksteel.DarkSteelRecipeManager;
import crazypants.enderio.base.item.darksteel.attributes.EquipmentData;
import crazypants.enderio.base.item.darksteel.upgrade.energy.EnergyUpgrade;
import crazypants.enderio.base.item.darksteel.upgrade.energy.EnergyUpgradeManager;
import crazypants.enderio.base.render.itemoverlay.PowerBarOverlayRenderHelper;
import crazypants.enderio.base.teleport.TravelController;
import info.loenwind.autoconfig.factory.IValue;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemTravelStaff
extends Item
implements IItemOfTravel,
IAdvancedTooltipProvider,
EnderCoreMethods.IOverlayRenderAware,
IDarkSteelItem {
    private long lastBlickTick = 0L;

    public static ItemTravelStaff create(@Nonnull IModObject modObject, @Nullable Block block) {
        return new ItemTravelStaff(modObject);
    }

    protected ItemTravelStaff(@Nonnull IModObject modObject) {
        this.func_77637_a(EnderIOTab.tabEnderIOItems);
        modObject.apply(this);
        this.func_77625_d(1);
        this.func_77627_a(true);
    }

    @Override
    @Nonnull
    public MappedCapabilityProvider initCapabilities(@Nonnull ItemStack stack, @Nullable NBTTagCompound nbt, @Nonnull MappedCapabilityProvider capProv) {
        if (!((EnergyUpgrade)EnergyUpgrade.UPGRADES.get(0)).hasAnyUpgradeVariant(stack)) {
            ((EnergyUpgrade)EnergyUpgrade.UPGRADES.get(0)).addToItem(stack, this);
        }
        return IDarkSteelItem.super.initCapabilities(stack, nbt, capProv);
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull World world, @Nonnull EntityPlayer player, @Nonnull EnumHand hand) {
        ItemStack equipped = player.func_184586_b(hand);
        if (player.func_70093_af()) {
            long ticksSinceBlink = EnderIO.proxy.getTickCount() - this.lastBlickTick;
            if (ticksSinceBlink < 0L) {
                this.lastBlickTick = -1L;
            }
            if (((Boolean)TeleportConfig.enableBlink.get()).booleanValue() && world.field_72995_K && ticksSinceBlink >= (long)((Integer)TeleportConfig.blinkDelay.get()).intValue() && TravelController.instance.doBlink(equipped, hand, player)) {
                player.func_184609_a(hand);
                this.lastBlickTick = EnderIO.proxy.getTickCount();
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)equipped);
        }
        if (world.field_72995_K) {
            TravelController.instance.activateTravelAccessable(equipped, hand, world, player, TravelSource.STAFF);
        }
        player.func_184609_a(hand);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)equipped);
    }

    public boolean canDestroyBlockInCreative(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull ItemStack stack, @Nonnull EntityPlayer player) {
        return false;
    }

    public void addCommonEntries(@Nonnull ItemStack itemstack, @Nullable EntityPlayer entityplayer, @Nonnull List<String> list, boolean flag) {
        DarkSteelRecipeManager.addCommonTooltipEntries(itemstack, entityplayer, list, flag);
    }

    public void addBasicEntries(@Nonnull ItemStack itemstack, @Nullable EntityPlayer entityplayer, @Nonnull List<String> list, boolean flag) {
        DarkSteelRecipeManager.addBasicTooltipEntries(itemstack, entityplayer, list, flag);
    }

    public void addDetailedEntries(@Nonnull ItemStack itemstack, @Nullable EntityPlayer entityplayer, @Nonnull List<String> list, boolean flag) {
        list.add(EnergyUpgradeManager.getStoredEnergyString(itemstack));
        DarkSteelRecipeManager.addAdvancedTooltipEntries(itemstack, entityplayer, list, flag);
    }

    @Override
    public void extractInternal(@Nonnull ItemStack item, int powerUse) {
        EnergyUpgradeManager.extractEnergy(item, (IDarkSteelItem)this, powerUse, false);
    }

    public void func_150895_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> list) {
        if (this.func_194125_a(tab)) {
            ItemStack is = new ItemStack((Item)this);
            list.add((Object)is);
            is = new ItemStack((Item)this);
            ((EnergyUpgrade)EnergyUpgrade.UPGRADES.get(3)).addToItem(is, this);
            EnergyUpgradeManager.setPowerFull(is, this);
            list.add((Object)is);
        }
    }

    @Override
    public boolean isActive(@Nonnull EntityPlayer ep, @Nonnull ItemStack equipped) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return true;
    }

    public void renderItemOverlayIntoGUI(@Nonnull ItemStack stack, int xPosition, int yPosition) {
        PowerBarOverlayRenderHelper.instance.render(stack, xPosition, yPosition);
    }

    @Override
    public int getEnergyStored(@Nonnull ItemStack item) {
        return EnergyUpgradeManager.getEnergyStored(item);
    }

    @Override
    public boolean isForSlot(@Nonnull EntityEquipmentSlot slot) {
        return slot == EntityEquipmentSlot.MAINHAND;
    }

    @Override
    @Nonnull
    public IEquipmentData getEquipmentData() {
        return EquipmentData.IRON;
    }

    @Override
    @Nonnull
    public ICapacitorKey getEnergyStorageKey(@Nonnull ItemStack stack) {
        return CapacitorKey.DARK_STEEL_TRAVEL_ENERGY_BUFFER;
    }

    @Override
    @Nonnull
    public ICapacitorKey getEnergyInputKey(@Nonnull ItemStack stack) {
        return CapacitorKey.DARK_STEEL_TRAVEL_ENERGY_INPUT;
    }

    @Override
    @Nonnull
    public ICapacitorKey getEnergyUseKey(@Nonnull ItemStack stack) {
        return CapacitorKey.DARK_STEEL_TRAVEL_ENERGY_USE;
    }

    @Override
    @Nonnull
    public ICapacitorKey getAbsorptionRatioKey(@Nonnull ItemStack stack) {
        return CapacitorKey.NO_POWER;
    }

    @Override
    public void extractInternal(@Nonnull ItemStack item, IValue<Integer> powerUse) {
        EnergyUpgradeManager.extractEnergy(item, (IDarkSteelItem)this, powerUse, false);
    }
}

