/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.gui.tooltip;

import com.enderio.core.client.handlers.SpecialTooltipHandler;
import crazypants.enderio.base.lang.Lang;
import crazypants.enderio.base.lang.LangPower;
import crazypants.enderio.base.recipe.sagmill.IGrindingMultiplier;
import crazypants.enderio.base.recipe.sagmill.SagMillRecipeManager;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TooltipHandlerGrinding
implements SpecialTooltipHandler.ITooltipCallback {
    @SideOnly(value=Side.CLIENT)
    public void addCommonEntries(@Nonnull ItemStack itemstack, @Nullable EntityPlayer entityplayer, @Nonnull List<String> list, boolean flag) {
    }

    @SideOnly(value=Side.CLIENT)
    public void addBasicEntries(@Nonnull ItemStack itemstack, @Nullable EntityPlayer entityplayer, @Nonnull List<String> list, boolean flag) {
    }

    @SideOnly(value=Side.CLIENT)
    public void addDetailedEntries(@Nonnull ItemStack itemstack, @Nullable EntityPlayer entityplayer, @Nonnull List<String> list, boolean flag) {
        this.addEntries(itemstack, list, null);
    }

    public void addEntries(@Nonnull ItemStack itemstack, @Nonnull List<String> list, @Nullable String withGrindingMultiplier) {
        IGrindingMultiplier ball = SagMillRecipeManager.getInstance().getGrindballFromStack(itemstack);
        list.add(Lang.GRINDING_BALL_1.get(TextFormatting.BLUE));
        if (withGrindingMultiplier == null) {
            list.add(Lang.GRINDING_BALL_2.get(TextFormatting.GRAY, LangPower.toPercent(ball.getGrindingMultiplier())));
        } else {
            list.add(Lang.GRINDING_BALL_2.get(TextFormatting.GRAY, withGrindingMultiplier));
        }
        list.add(Lang.GRINDING_BALL_3.get(TextFormatting.GRAY, LangPower.toPercent(ball.getChanceMultiplier())));
        list.add(Lang.GRINDING_BALL_4.get(TextFormatting.GRAY, LangPower.toPercent(ball.getPowerMultiplier())));
    }

    public boolean shouldHandleItem(@Nonnull ItemStack item) {
        return SagMillRecipeManager.getInstance().getGrindballFromStack(item) != null;
    }
}

