/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.config.recipes.xml;

import com.enderio.core.common.util.NNList;
import crazypants.enderio.base.config.recipes.InvalidRecipeConfigException;
import crazypants.enderio.base.config.recipes.StaxFactory;
import crazypants.enderio.base.config.recipes.xml.AbstractCrafting;
import crazypants.enderio.base.config.recipes.xml.Item;
import crazypants.enderio.base.config.recipes.xml.ItemIntegerAmount;
import crazypants.enderio.base.config.recipes.xml.Output;
import crazypants.enderio.base.config.recipes.xml.OutputWithChance;
import crazypants.enderio.base.recipe.Recipe;
import crazypants.enderio.base.recipe.RecipeBonusType;
import crazypants.enderio.base.recipe.RecipeOutput;
import crazypants.enderio.base.recipe.ThingsRecipeInput;
import crazypants.enderio.base.recipe.sagmill.SagMillRecipeManager;
import java.util.ArrayList;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;

public class Sagmilling
extends AbstractCrafting {
    private int energy;
    @Nonnull
    private RecipeBonusType bonus = RecipeBonusType.MULTIPLY_OUTPUT;
    private Item input;

    @Override
    public Object readResolve() throws InvalidRecipeConfigException {
        try {
            super.readResolve();
            if (this.input == null) {
                throw new InvalidRecipeConfigException("Missing <input>");
            }
            if (this.energy <= 0) {
                throw new InvalidRecipeConfigException("Invalid low value for 'energy'");
            }
            this.valid = this.valid && this.input.isValid();
        }
        catch (InvalidRecipeConfigException e) {
            throw new InvalidRecipeConfigException(e, "in <sagmilling>");
        }
        return this;
    }

    @Override
    protected boolean checkOutputCount(int count) {
        return count >= 1;
    }

    @Override
    public void enforceValidity() throws InvalidRecipeConfigException {
        super.enforceValidity();
        this.input.enforceValidity();
    }

    @Override
    public void register(@Nonnull String recipeName) {
        if (this.isValid() && this.isActive()) {
            ThingsRecipeInput recipeInput = new ThingsRecipeInput(this.input.getThing());
            NNList recipeOutputs = new NNList();
            for (Output output : this.getOutputs()) {
                if (output instanceof OutputWithChance) {
                    recipeOutputs.add((Object)new RecipeOutput(output.getItemStack(), ((OutputWithChance)output).getChance()));
                    continue;
                }
                recipeOutputs.add((Object)new RecipeOutput(output.getItemStack(), 1.0f));
            }
            Recipe recipe = new Recipe(recipeInput, this.energy, this.bonus, (RecipeOutput[])recipeOutputs.toArray((Object[])new RecipeOutput[0]));
            SagMillRecipeManager.getInstance().addRecipe(recipe);
        }
    }

    @Override
    public boolean setAttribute(StaxFactory factory, String name, String value) throws InvalidRecipeConfigException, XMLStreamException {
        if ("bonus".equals(name)) {
            try {
                this.bonus = RecipeBonusType.valueOf(value.toUpperCase(Locale.ENGLISH));
            }
            catch (IllegalArgumentException e) {
                throw new InvalidRecipeConfigException("'" + value + "' is not a valid value for 'bonus'");
            }
            return true;
        }
        if ("energy".equals(name)) {
            this.energy = Integer.parseInt(value);
            return true;
        }
        return super.setAttribute(factory, name, value);
    }

    @Override
    public boolean setElement(StaxFactory factory, String name, StartElement startElement) throws InvalidRecipeConfigException, XMLStreamException {
        if ("input".equals(name) && this.input == null) {
            this.input = (Item)factory.read(new ItemIntegerAmount().setAllowDelaying(false), startElement);
            return true;
        }
        if ("output".equals(name)) {
            if (this.outputs == null) {
                this.outputs = new ArrayList();
            }
            this.outputs.add(factory.read(new OutputWithChance(), startElement));
            return true;
        }
        return super.setElement(factory, name, startElement);
    }
}

