/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.config.recipes.xml;

import com.enderio.core.common.util.stackable.Things;
import crazypants.enderio.base.config.recipes.InvalidRecipeConfigException;
import crazypants.enderio.base.config.recipes.StaxFactory;
import crazypants.enderio.base.config.recipes.xml.AbstractConditional;
import crazypants.enderio.base.config.recipes.xml.Enchantment;
import crazypants.enderio.base.config.recipes.xml.ItemIntegerAmount;
import crazypants.enderio.base.recipe.MachineRecipeRegistry;
import crazypants.enderio.base.recipe.enchanter.EnchanterRecipe;
import javax.annotation.Nonnull;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;

public class Enchanting
extends AbstractConditional {
    private ItemIntegerAmount input;
    private Enchantment enchantment;

    @Override
    public Object readResolve() throws InvalidRecipeConfigException {
        try {
            super.readResolve();
            if (this.input == null) {
                throw new InvalidRecipeConfigException("Missing <input>");
            }
            if (this.enchantment == null) {
                throw new InvalidRecipeConfigException("Missing <enchantment>");
            }
            this.valid = this.input.isValid() && this.enchantment.isValid();
        }
        catch (InvalidRecipeConfigException e) {
            throw new InvalidRecipeConfigException(e, "in <enchanting>");
        }
        return this;
    }

    @Override
    public void enforceValidity() throws InvalidRecipeConfigException {
        this.input.enforceValidity();
        this.enchantment.enforceValidity();
        if (this.input.getThing().isEmpty() || this.enchantment.getEnchantment() == null) {
            throw new InvalidRecipeConfigException("Valid child elements are invalid in <enchanting>");
        }
    }

    @Override
    public void register(@Nonnull String recipeName) {
        if (this.isValid() && this.isActive()) {
            Things thing = this.input.getThing();
            net.minecraft.enchantment.Enchantment enchantment2 = this.enchantment.getEnchantment();
            if (!thing.isEmpty() && enchantment2 != null) {
                EnchanterRecipe recipe = new EnchanterRecipe(thing, this.input.getAmount(), enchantment2, this.enchantment.getCostMultiplier());
                MachineRecipeRegistry.instance.registerRecipe("enchanter", recipe);
            }
        }
    }

    @Override
    public boolean setElement(StaxFactory factory, String name, StartElement startElement) throws InvalidRecipeConfigException, XMLStreamException {
        if ("input".equals(name) && this.input == null) {
            this.input = (ItemIntegerAmount)factory.read(new ItemIntegerAmount().setAllowDelaying(false), startElement);
            return true;
        }
        if ("enchantment".equals(name) && this.enchantment == null) {
            this.enchantment = factory.read(new Enchantment(), startElement);
            return true;
        }
        return super.setElement(factory, name, startElement);
    }
}

