/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.config.recipes.xml;

import crazypants.enderio.base.config.recipes.InvalidRecipeConfigException;
import crazypants.enderio.base.config.recipes.RecipeConfigElement;
import crazypants.enderio.base.config.recipes.StaxFactory;
import crazypants.enderio.base.config.recipes.xml.ItemOptional;
import java.util.Locale;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import net.minecraftforge.fml.common.Loader;

public class ConditionDependency
implements RecipeConfigElement {
    private String itemString;
    private String modString;
    private boolean reverse;
    private boolean valid;
    private transient ItemOptional item;

    @Override
    public Object readResolve() throws InvalidRecipeConfigException {
        try {
            boolean hasMod;
            boolean hasItem = this.itemString != null && !this.itemString.trim().isEmpty();
            boolean bl = hasMod = this.modString != null && !this.modString.trim().isEmpty();
            if (!hasItem && !hasMod) {
                throw new InvalidRecipeConfigException("Missing item and mod");
            }
            this.valid = true;
            if (hasItem) {
                this.item = new ItemOptional().setAllowDelaying(false);
                this.item.setName(this.itemString);
                this.item.readResolve();
                boolean bl2 = this.valid = this.valid && this.item.isValid();
            }
            if (hasMod) {
                if (this.modString.length() > 64) {
                    throw new InvalidRecipeConfigException(String.format("The modId %s is longer than the maximum of 64 characters.", this.modString));
                }
                if (!this.modString.equals(this.modString.toLowerCase(Locale.ENGLISH))) {
                    throw new InvalidRecipeConfigException(String.format("The modId %s must be all lowercase.", this.modString));
                }
                this.valid = this.valid && Loader.isModLoaded((String)this.modString);
            }
        }
        catch (InvalidRecipeConfigException e) {
            throw new InvalidRecipeConfigException(e, "in <dependency>");
        }
        return this;
    }

    @Override
    public boolean isValid() {
        return this.valid != this.reverse;
    }

    @Override
    public boolean setAttribute(StaxFactory factory, String name, String value) throws InvalidRecipeConfigException, XMLStreamException {
        if ("item".equals(name)) {
            this.itemString = value;
            return true;
        }
        if ("mod".equals(name)) {
            this.modString = value;
            return true;
        }
        if ("reverse".equals(name)) {
            this.reverse = Boolean.parseBoolean(value);
            return true;
        }
        return false;
    }

    @Override
    public boolean setElement(StaxFactory factory, String name, StartElement startElement) throws InvalidRecipeConfigException, XMLStreamException {
        return false;
    }

    @Override
    public void enforceValidity() throws InvalidRecipeConfigException {
    }
}

